@php
    $template = 'template' . $site_configurations->template_id;
@endphp
@extends('frontend.app')
@section('title', 'Our Author')
@if (isset($authorDetails))
    @section('meta_title', $authorDetails->meta_title)
    @section('meta_description', $authorDetails->meta_description)
    @section('meta_key', $authorDetails->meta_key)
    @section('meta_content', $authorDetails->meta_content)
@endif
@section('content')
    <!--=================== Author Details Start ==================-->
    <div class="author_details_area section_padding">
        <div class="container">
            <div class="row gy-4 gx-4">
                <div class="col-xxl-4 col-xl-4 col-lg-12 col-md-12 col-sm-12 col-12">
                    <div class="author_details_img">
                        <img src="{{ asset('storage/' . $authorDetails->image) }}" alt="{{ $authorDetails->name }}">
                    </div>
                </div>
                <div class="col-xxl-8 col-xl-8 col-lg-12 col-md-12 col-sm-12 col-12">
                    <div class="author_details_info">
                        <h4>{{ $authorDetails->name }}</h4>
                        <p>{{ $authorDetails->description }}</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </div>
    <!--=================== Author Details End ==================-->

    <!--=================== Author Book Start ==================-->
    @if ($authorBooks->isNotEmpty())
        <section class="author_book_area section_padding_bottom">
            <div class="container">
                <div class="row">
                    <div class="col-md-12">
                        <div class="section_title">
                            <h2>{{ $authorDetails->name }} এর বই সমূহ</h2>
                        </div>
                    </div>
                </div>
            </div>
            <div class="container section_top_space">
                <div class="row gy-3 gx-3">
                    @foreach ($authorBooks as $product)
                        <div class="col-xxl-2 col-xl-2 col-lg-3 col-md-4 col-sm-4 col-6">
                            @include("frontend.components.product_content.$template", [
                                'product' => $product,
                            ])
                        </div>
                    @endforeach
                </div>
            </div>
        </section>
    @endif
    <!--=================== Author Book End ==================-->

    <!--============ Related Products Area Start ============-->
    {{-- @if ($authorBooks->isNotEmpty())
        <section class="related_product_area section_padding_bottom">
            <div class="container">
                <div class="row">
                    <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        <div class="section_title text-center">
                            <h2>{{ $authorDetails->name }} এর বই সমূহ</h2>

                            <p>
                                (Showing {{ $authorBooks->firstItem() }} to {{ $authorBooks->lastItem() }} of total
                                {{ $authorBooks->total() }} books for {{ $authorDetails->name }})
                            </p>

                        </div>
                    </div>
                </div>
            </div>
            <div class="container section_top_space">
                <div class="row gy-3 gx-3">
                    @foreach ($authorBooks as $product)
                    <div class="col-xxl-2 col-xl-2 col-lg-3 col-md-4 col-sm-4 col-6">
                            @include("frontend.components.product_content.$template", ['product' => $product])
                        </div>
                        @endforeach
                </div>
                <div class="row section_top_space">
                    <div class="col-12">
                        <div class="common_pagination">
                            {!! $authorBooks->links() !!}
                        </div>
                    </div>
                </div>
            </div>
        </section>
    @endif --}}
    <!--============ Related Products Area End ============-->


@endsection
