@extends('frontend.app')
@section('title', 'Brand')
@section('content')
    <!--============ Brand Area Start ============-->
    <section class="brand_area section_padding">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="brand_ordering">
                        <ul class="brand_ordering_ul">
                            <li class="active"><a href="#a" class="brand_ordering_link">A</a></li>
                            <li><a href="#b" class="brand_ordering_link">B</a></li>
                            <li><a href="#c" class="brand_ordering_link">C</a></li>
                            <li><a href="#d" class="brand_ordering_link">D</a></li>
                            <li><a href="#e" class="brand_ordering_link">E</a></li>
                            <li><a href="#f" class="brand_ordering_link">F</a></li>
                            <li><a href="#g" class="brand_ordering_link">G</a></li>
                            <li><a href="#h" class="brand_ordering_link">H</a></li>
                            <li><a href="#i" class="brand_ordering_link">I</a></li>
                            <li><a href="#j" class="brand_ordering_link">J</a></li>
                            <li><a href="#k" class="brand_ordering_link">K</a></li>
                            <li><a href="#l" class="brand_ordering_link">L</a></li>
                            <li><a href="#m" class="brand_ordering_link">M</a></li>
                            <li><a href="#n" class="brand_ordering_link">N</a></li>
                            <li><a href="#o" class="brand_ordering_link">O</a></li>
                            <li><a href="#p" class="brand_ordering_link">P</a></li>
                            <li><a href="#q" class="brand_ordering_link">Q</a></li>
                            <li><a href="#r" class="brand_ordering_link">R</a></li>
                            <li><a href="#s" class="brand_ordering_link">S</a></li>
                            <li><a href="#t" class="brand_ordering_link">T</a></li>
                            <li><a href="#u" class="brand_ordering_link">U</a></li>
                            <li><a href="#v" class="brand_ordering_link">V</a></li>
                            <li><a href="#w" class="brand_ordering_link">W</a></li>
                            <li><a href="#x" class="brand_ordering_link">X</a></li>
                            <li><a href="#y" class="brand_ordering_link">Y</a></li>
                            <li><a href="#z" class="brand_ordering_link">Z</a></li>
                        </ul>
                        <div class="brand_content">
                            <div class="section_padding">
                                <div class="row">
                                    <div class="col-lg-12">
                                        <div class="section_title text-center">
                                            <h2>All Brands</h2>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @foreach ($brandsByLetter as $letter => $brands)
                                <div class="brand_item section_padding_bottom" id="{{ strtolower($letter) }}">
                                    <div class="">
                                        <div class="row">
                                            <div class="col-lg-12">
                                                <div class="brand_title">
                                                    <h4>{{ $letter }}</h4>
                                                </div>
                                                <div class="brand_list">

                                                    <ul>
                                                        @forelse ($brands as $brand)
                                                            <li>
                                                                <a href="{{ route('brand.product', $brand->slug) }}"
                                                                    class="brand_list_link">

                                                                    <div class="brand_name_img">
                                                                        <img
                                                                            src="{{ asset('storage/' . $brand->image) }}"
                                                                            alt="brands_img" />
                                                                    </div>

                                                                    {{-- <h5
                                                                        class="brand_name_title">{{ $brand->name }}
                                                                    </h5> --}}
                                                                </a>
                                                            </li>
                                                        @empty
                                                            <div><span href="#" class="text-center">No Brand
                                                                    found</span>
                                                            </div>
                                                        @endforelse
                                                    </ul>


                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--============ Brand Area End ============-->




@endsection
