@extends('frontend.app')
@section('title', 'Check Out')
@section('content')
    <!--============ Checkout Area Start ============-->
    <section class="checkout_area section_padding">

        <form id="order_form">
            <div class="container">
                <div class="row gy-4 justify-content-center align-items-center">
                    <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-12 col-12">

                        <div class="checkout_form_container">



                            <div class="checkout_form">
                                <div class="checkout_form_title">
                                    <h3>{{ dynamic_lang('please_order_now') }}</h3>
                                </div>
                                <div class="checkout_form_group">
                                    <label>{{ dynamic_lang('full_name') }} <span class="required_r">*</span></label>
                                    <input type="text" required name="name" value="{{ old('name') }}"
                                        placeholder="{{ dynamic_lang('full_name') }}">
                                    <i class="fa-regular fa-user"></i>
                                    @error('name')
                                        <span style="color:red">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="checkout_form_group">
                                    <label>{{ dynamic_lang('mobile_number') }} <span class="required_r">*</span></label>
                                    <input type="number" name="mobile_no"
                                        onkeyup="setNumber(this.value , {{ $setting->incomplete_order_system }})"
                                        value="{{ old('mobile_no') }}"
                                        placeholder="{{ dynamic_lang('mobile_number_placeholder') }}" maxlength="11"
                                        minlength="11"
                                        oninput="if(this.value.length > 11) this.value = this.value.slice(0, 11);">
                                    <i class="fa-solid fa-phone"></i>
                                    @error('mobile_no')
                                        <span style="color:red">{{ $message }}</span>
                                    @enderror
                                </div>


                                <div class="checkout_form_group">
                                    <label>{{ dynamic_lang('full_address') }} <span class="required_r">*</span></label>
                                    <input type="text" required name="address" value="{{ old('address') }}"
                                        placeholder="{{ dynamic_lang('full_address') }} ">
                                    <i class="fa-solid fa-location-dot"></i>
                                    @error('address')
                                        <span style="color:red">{{ $message }}</span>
                                    @enderror
                                </div>


                                <input type="hidden" id="free_delivery" value="{{ $has_free_delivery }}"
                                    name="free_delivery">
                                <input type="hidden" id="show_city_sub_city" value="{{ $setting->show_city_sub_city }}">
                                @if ($setting->show_city_sub_city == 1)
                                    <div class="checkout_form_group">
                                        <label>{{ dynamic_lang('city') }} <span class="required_r">*</span></label>
                                        <input type="hidden" id="setInputShippingCharge" name="shipping_charge">
                                        <select id="select_city"
                                            onchange="shippingCharge(this.value, this.options[this.selectedIndex].id, {{ $has_free_delivery }})"
                                            name="city_id" class="checkout_form_select">
                                            <option value="">{{ dynamic_lang('select_city') }}</option>
                                            @foreach ($cities as $city)
                                                <option value="{{ $city->id }}" id="{{ $city->delivery_charge }}">
                                                    {{ $city->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                        @error('shipping_charge_id')
                                            <span style="color:red">{{ $message }}</span>
                                        @enderror
                                    </div>

                                    <div class="checkout_form_group">
                                        <label>{{ dynamic_lang('sub_city') }} <span class="required_r">*</span></label>
                                        <select id="subcity" name="subcity_id" class="checkout_form_select">
                                            <option value="">{{ dynamic_lang('select_sub_city') }} </option>
                                        </select>
                                        @error('subcity')
                                            <span style="color:red">{{ $message }}</span>
                                        @enderror
                                    </div>
                                @else
                                    <div class="checkout_form_checkbox_group">
                                        <h4>{{ dynamic_lang('delivery_area') }} <span class="required_r">*</span></h4>
                                        <div class="checkout_form_checkbox_group_box">
                                            @foreach ($delivery_charges as $index => $delivery_charge)
                                                <div class="checkout_form_checkbox form-check">
                                                    <input required class="form-check-input"
                                                        value="{{ $delivery_charge->delivery_charge }}"
                                                        @if ($index === 0) checked @endif
                                                        onclick="shippingChargeBySelectArea(this.id , {{ $delivery_charge->delivery_charge }}, {{ $has_free_delivery }})"
                                                        type="radio" name="shipping_charge"
                                                        id="{{ $delivery_charge->id }}"
                                                        {{ old('shipping_charge') == $delivery_charge->id ? 'checked' : '' }}>

                                                    <label class="form-check-label" for="{{ $delivery_charge->id }}">
                                                        {{ $delivery_charge->name }}
                                                    </label>
                                                </div>
                                                @error('shipping_charge')
                                                    <span style="color:red">{{ $message }}</span>
                                                @enderror
                                            @endforeach
                                        </div>
                                    </div>
                                @endif

                                @if ($setting->show_checkout_note == 1)
                                    <div class="checkout_form_group">
                                        <label>{{ dynamic_lang('delivery_note') }} <span
                                                class="required_r">*</span></label>
                                        <input type="text" name="note" value="{{ old('note') }}"
                                            placeholder="{{ dynamic_lang('delivery_note') }}">
                                        <i class="fa-regular fa-comment"></i>
                                    </div>
                                @endif


                            </div>

                            <!--================== order summery Start  ===================-->
                            <div class="checkout_order_summary">
                                <h2 class="order_summary_title">Order Summary</h2>

                                @if ($site_configurations->coupon == 1)
                                    <div class="apply_coupon_group">
                                        <input type="hidden" id="coupon_amount" name="coupon_amount">
                                        <div class="apply_coupon_item">
                                            <input type="text" id="coupon_name" name="coupon"
                                                placeholder="Coupon Code">
                                            <a id="coupon_apply" class="apply_coupon_item_link">Apply</a>
                                        </div>
                                        <span id="coupon_valid" style="color: green;display:none">Congratulations. This Coupon is
                                            Valid.</span>
                                        <span id="coupon_invalid" style="color: red;display:none">Oops Sorry!. This Coupon is
                                            Invalid.</span>
                                    </div>
                                @endif


                                 

                                <div class="order_summary_table">
                                    <table>
                                        <thead>
                                            <tr>
                                                <th class="checkout_product_td_left">Product</th>
                                                <th class="checkout_product_th_qty">Quantity</th>
                                                <th class="checkout_product_th_price">Price</th>
                                                <th class="checkout_product_th_total_price">Total Price</th>
                                                <th class="checkout_product_td_right">Action</th>
                                            </tr>
                                        </thead>
                                        <tbody id="check_out_carts">
                                        <tbody>

                                        </tbody>
                                    </table>
                                </div>
                                <div>
                                    <div class="price_summary_table_cell">
                                        <strong>Sub Total :</strong>
                                        <input id="cart_sub_total" type="hidden" value="{{ $cart_sub_total }}">
                                        <strong id="show_cart_sub_total">{{ $cart_sub_total }} TK</strong>
                                    </div>
                                    <div class="price_summary_table_cell">
                                        <strong>Shipping Charge :</strong>
                                        @if ($has_free_delivery == 1)
                                            <strong>0 TK</strong>
                                        @else
                                            <strong id="show_shipping_charge">00 TK</strong>
                                        @endif
                                    </div>
                                    <div class="price_summary_table_cell">
                                        <strong>Discount Amount :</strong>
                                        <strong id="show_discount">00 TK</strong>
                                    </div>
                                    <div class="price_summary_table_cell">
                                        <strong class="price_payable_amount_text">Payable Amount :</strong>
                                    <strong class="price_payable_amount_text" id="show_payable">00 TK</strong>
                                    </div>
                                </div>
                                @if ($setting->bkash_active == 1)
                                    <div class="payment_methods_img">
                                        <ul>
                                            <input type="hidden" id="set_payment" name="payment" value="0">
                                            <li class="active_payment" onclick="setOnlinePayment(0)">
                                                <!-- First image is active by default -->
                                                <div class="payment_images">
                                                    <img src="{{ asset('frontend') }}/images/check_payment_img/payment-image1.jpg"
                                                        alt="Payment Images">
                                                </div>
                                            </li>
                                            <li onclick="setOnlinePayment(1)">
                                                <div class="payment_images">
                                                    <img src="{{ asset('frontend') }}/images/check_payment_img/payment-image2.jpg"
                                                        alt="Payment Images">
                                                </div>
                                            </li>
                                        </ul>
                                    </div>
                                @else
                                    <input type="hidden" id="set_payment" name="payment" value="0">
                                @endif
                                <div class="checkout_form_btn">
                                    <button id="order_form_submit" class="checkout_form_btn_link">
                                        <i class="las la-shopping-basket"></i>
                                        Order Submit
                                    </button>
                                </div>
                            </div>
                            <!--================== order summery end  ===================-->


                        </div>

                    </div>

                </div>
            </div>
        </form>

    </section>
    <!--============ Checkout Area End ============-->

@endsection
@section('scripts')
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Code to execute when the DOM is fully loaded
            function handleWindowLoad() {
                console.log('Window loading has ended.');
                gtmCartItemsEvent('begin_checkout');
                window.removeEventListener('load', handleWindowLoad);
            }

            window.addEventListener('load', handleWindowLoad, {
                once: true
            });

            // Other JavaScript functionality
        });
    </script>
@endsection
