@extends('frontend.app')
@section('title', 'Coupon Income')
@section('content')
    <!--============ Profile Area Start ============-->
    <section class="profile_area section_padding">
        <div class="container">
            <div class="row gy-4">
                <div class="col-xxl-3 col-xl-4 col-lg-4 col-md-12 col-sm-12 col-12">
                    @include('frontend.components.user_dashboard')
                </div>
                <div class="col-xxl-9 col-xl-8 col-lg-8 col-md-12 col-sm-12 col-12">
                    <div class="profile_right_side">
                        <div class="profile_heading text-center">
                            <h3> Coupon Income </h3>
                        </div>
                        @php

                            $total_income = App\Models\CustomerCashbook::where(
                                'customer_id',
                                Auth::guard('customer')->user()->id,
                            )
                                ->where('type', 'coupon')
                                ->where('is_income', 1)
                                ->sum('amount');
                            $total_expnse = App\Models\CustomerCashbook::where(
                                'customer_id',
                                Auth::guard('customer')->user()->id,
                            )
                                ->where('type', 'coupon')
                                ->where('is_income', 0)
                                ->sum('amount');
                        @endphp
                        <div class="profile_form section_top_space">
                            <div class="row" style="text-align: center;">
                                <div class="col-lg-4">
                                    <div class="visitor">
                                        <p>Pay Amount </p>

                                        <p> ({{ $total_income - $total_expnse }})</p>
                                    </div>
                                </div>
                                <div class="col-lg-4">
                                    <div class="visitor">
                                        <p>Balance</p>
                                        <p> ({{ Auth::guard('customer')->user()->coupon_income_amount }}) </p>
                                    </div>
                                </div>

                                <div class="col-lg-4">
                                    <div class="visitor">
                                        <p>Withdrawn</p>
                                        <p> ({{ $total_expnse }})</p>
                                    </div>
                                </div>
                            </div>
                            <br>
                            <div class="row" style="text-align: center;">
                                <div class="col-lg-3">
                                    <div class="visitor">
                                        <p>Total Order</p>

                                        <p> ({{ $totalOrders }})</p>
                                    </div>
                                </div>
                                <div class="col-lg-3">
                                    <div class="visitor">
                                        <p>Order Delivered</p>
                                        <p> ({{ $deliveredOrders }}) </p>
                                    </div>
                                </div>

                                <div class="col-lg-3">
                                    <div class="visitor">
                                        <p>Order Returned</p>
                                        <p> ({{ $returnedOrders }})</p>
                                    </div>
                                </div>
                                <div class="col-lg-3">
                                    <div class="visitor">
                                        <p>Order Canceled</p>
                                        <p> ({{ $canceledOrders }})</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

        
                    <br>
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="affiliate-request">
                                <h3 class="text-center">Withdraw</h3>

                                @error('password')
                                    <span class="is_error">{{ $message }}</span>
                                @enderror

                                <form action="{{ route('coupon.income.withdrawal') }}" method="POST">
                                    @csrf
                                    <div class="profile_form_item">
                                        <label>Payment Method(Name/Number)</label>
                                        <input type="text" required name="payment_method"
                                            placeholder="bKash/01500000000">
                                        @error('payment_method')
                                            <span class="is_error">{{ $message }}</span>
                                        @enderror
                                    </div>

                                    <div class="profile_form_item">
                                        <label>Note</label>
                                        <input type="text" name="note" placeholder="Note">
                                        @error('note')
                                            <span class="is_error">{{ $message }}</span>
                                        @enderror
                                    </div>

                                    <input type="hidden" value="{{ Auth::guard('customer')->user()->username }}"
                                        name="username">


                                    <div class="profile_form_item">
                                        <button class="profile_form_submit_btn_link" type="submit">Request
                                            Withdrawal</button>
                                    </div>
                                </form>

                            </div>
                        </div>
                    </div>


                </div>
            </div>
        </div>
    </section>
    <!--============ Profile Area End ============-->

@endsection
