@php
    $template = 'template' . $site_configurations->template_id;
@endphp
@extends('frontend.app')
@section('title', $general_settings->title)
@section('meta_title', $general_settings->meta_title)
@section('meta_description', $general_settings->meta_description)
@section('meta_key', $general_settings->meta_key)
@section('meta_content', $general_settings->meta_content)
@section('content')


    <!--============ Banner Area Start ============-->
    <div class="banner_area">

        <!-- template one start -->
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <div class="slider_banner_active owl-carousel">
                        @foreach ($sliders as $slider)
                            <div class="slider_banner_item">
                                <a href="{{ $slider->url }}" target="_blank">
                                    <img src="{{ asset('storage/' . $slider->image) }}" alt="{{ $slider->url }}">
                                </a>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
        <!-- template one end -->

    </div>
    <!--============ Banner Area End ============-->

    <!--============ Category Area Start ============-->
    
    <!-- template one start -->
    <section class="category_area section_padding_bottom lg-0 mt-4">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <div class="section_title text-center mb-3">
                        <h2>Categories</h2>
                    </div>
                </div>
            </div>
        </div>
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <div class="category_active owl-carousel">
                        @foreach ($top_section_categories as $category)
                        <div class="category_item">
                            <a href="{{route('product.category',[$category->slug])}}" class="category_item_link">
                                <div class="category_image">
                                    <img src="{{ asset('storage/' . $category->icon_image) }}" alt="{{$category->name}}" style="aspect-ratio:{{ $site_configurations->image_aspect_ratio }}">
                                </div>
                                <div class="category_name">
                                    <p>{{$category->name}}</p>
                                </div>
                            </a>
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </section>
       

    <!-- Brand one start -->
    @if ($top_section_brand->count() > 0)
    <section class="category_area section_padding_bottom lg-0 mt-4">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <div class="section_title text-center mb-3">
                        <h2>Brands</h2>
                    </div>
                </div>
            </div>
        </div>
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <div class="category_active owl-carousel">
                        @foreach ($top_section_brand as $brand)
                        <div class="category_item">
                            <a href="{{ route('all.product.brand', $brand->slug) }}" class="category_item_link">
                                <div class="category_image">
                                    <img src="{{ asset('storage/' . $brand->image) }}" alt="{{$brand->name}}" style="aspect-ratio:{{ $site_configurations->image_aspect_ratio }}">
                                </div>
                                <div class="category_name">
                                    <p>{{$brand->name}}</p>
                                </div>
                            </a>
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </section>
    @endif
    <!-- Brand one end -->

    <!--============ Category Area End ============-->

    <!--============ New Arrival Products Area Start ============-->
    <!-- template one start -->
        <section class="new_arrival_area section_padding_bottom">
            <div class="container">
                <div class="row">
                    <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        <div class="section_title text-center">
                            <h2>New Arrival Products</h2>
                        </div>
                    </div>
                </div>
            </div>
            <div class="container section_top_space">
                <div class="row">
                    <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        <div class="new_arrival_active owl-carousel">
                            @foreach ($new_arrival_products as $product)
                                @include("frontend.components.product_content.$template", ['product' => $product])
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </section>
    <!-- template one end -->
       
      
    <!--============ New Arrival Products Area End ============-->

    <!--============ Top Selling Products Area Start ============-->
        <!-- template one start -->
        <section class="top_selling_area section_padding_bottom">
            <div class="container">
                <div class="row">
                    <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        <div class="section_title text-center">
                            <h2>Top Selling Products</h2>
                        </div>
                    </div>
                </div>
            </div>
            <div class="container section_top_space">
                <div class="row">
                    <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        <div class="top_selling_active owl-carousel">

                            @foreach ($top_selling_products as $product)
                                @include("frontend.components.product_content.$template", ['product' => $product])
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- template one end -->
    <!--============ Top Selling Products Area End ============-->



    <!--============ Advertisement Banner Area Start ============-->
    <div class="advertisement_area section_padding_bottom">
        <div class="container">
            <div class="row gy-md-3 gx-md-3 gy-2 gx-2">
                @foreach ($after_top_selling_banner as $banner)
                <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-6 col-sm-6 col-6">
                    <div class="advertisement_image">
                        <a href="{{$banner->url}}">
                            <img src="{{asset('storage/'.$banner->banner)}}" alt="advertisement">
                        </a>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </div>
    <!--============ Advertisement Banner Area End ============-->

    <!--============ Category Wise Multiple Product Area Start ============-->
    <div id="loadmore_category_product">
    </div>
    <!--============ Category Wise Multiple Product Area End ============-->


    <!--================Loading Spinner Start==========================-->
    <div id="spinner" style=" display: none;text-align: center;">
        <img src="{{asset('frontend/images/spinner/200w.gif')}}" alt="Loading...">
    </div>
    <!--================Loading Spinner end==========================-->

    <!--============ Advertisement Banner Area Start ============-->
    @if ($before_footer_section)
    <div class="advertisement_area section_padding_bottom">
        <div class="container">
            <div class="row gy-md-3 gx-md-3 gy-2 gx-2">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <div class="advertisement_image">
                        <a href="{{$before_footer_section->url}}">
                            <img src="{{asset('storage/'.$before_footer_section->banner)}}" alt="advertisement">
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endif
    <!--============ Advertisement Banner Area End ============-->





  









    <!--============ Service Area Start ============-->
    <section class="service_area section_padding_bottom d-none d-lg-block">
        <div class="container">
            <div class="row gy-4">
                <div class="col-xxl-3 col-xl-3 col-lg-3 col-md-6">
                    <div class="service_item">
                        <div class="service_icon">
                            <i class="fa-solid fa-thumbs-up"></i>
                        </div>
                        <div class="service_title">
                            <h4>High-quality Goods</h4>
                        </div>
                        <div class="service_description">
                            <p>Enjoy top quality items for less</p>
                        </div>
                    </div>
                </div>
                <div class="col-xxl-3 col-xl-3 col-lg-3 col-md-6">
                    <div class="service_item">
                        <div class="service_icon">
                            <i class="fa-solid fa-headset"></i>
                        </div>
                        <div class="service_title">
                            <h4>24/7 Live chat</h4>
                        </div>
                        <div class="service_description">
                            <p>Get instant assistance whenever you need it</p>
                        </div>
                    </div>
                </div>
                <div class="col-xxl-3 col-xl-3 col-lg-3 col-md-6">
                    <div class="service_item">
                        <div class="service_icon">
                            <i class="fa-solid fa-truck"></i>
                        </div>
                        <div class="service_title">
                            <h4>Express Shipping</h4>
                        </div>
                        <div class="service_description">
                            <p>Fast & reliable delivery options</p>
                        </div>
                    </div>
                </div>
                <div class="col-xxl-3 col-xl-3 col-lg-3 col-md-6">
                    <div class="service_item">
                        <div class="service_icon">
                            <i class="fa fa-credit-card"></i>
                        </div>
                        <div class="service_title">
                            <h4>Secure Payment</h4>
                        </div>
                        <div class="service_description">
                            <p>Multiple safe payment methods</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--============ Service Area End ============-->




@endsection

@section('scripts')

    <!-- New Arrival Active -->
    <script>
        $(".new_arrival_active").owlCarousel({
            loop: true,
            animateOut: "fadeOut",
            animateIn: "fadeIn",
            margin: 14,
            nav: false,
            smartSpeed: 500,
            autoplay: true,
            autoplayTimeout: 7000,
            navText: [
                '<i class="icon fa fa-angle-left"></i>',
                '<i class="icon fa fa-angle-right"></i>',
            ],
            responsive: {
                0: {
                    items: 2,
                    margin: 6,
                },
                576: {
                    items: 3,
                    margin: 8,
                },
                768: {
                    items: 3,
                },
                992: {
                    items: 4,
                },
                1200: {
                    items: 4,
                },
                1400: {
                    items: `{{ $site_configurations->carousel_card_row }}`,
                },
                1500: {
                    items: `{{ $site_configurations->carousel_card_row }}`,
                },
            },
        });
    </script>

    <!-- Top Selling Active Active -->
    <script>
        $(".top_selling_active").owlCarousel({
            // loop: true,
            animateOut: "fadeOut",
            animateIn: "fadeIn",
            margin: 14,
            nav: false,
            smartSpeed: 500,
            autoplay: true,
            autoplayTimeout: 7000,
            navText: [
                '<i class="icon fa fa-angle-left"></i>',
                '<i class="icon fa fa-angle-right"></i>',
            ],
            responsive: {
                0: {
                    items: 2,
                    margin: 6,
                },
                576: {
                    items: 3,
                    margin: 8,
                },
                768: {
                    items: 3,
                },
                992: {
                    items: 4,
                },
                1200: {
                    items: 4,
                },
                1400: {
                    items: `{{ $site_configurations->carousel_card_row }}`,
                },
                1500: {
                    items: `{{ $site_configurations->carousel_card_row }}`,
                },
            },
        });
    </script>

    <script>
        var isLoading = false;
        //================load data========================
        function loadData() {
            console.log('loading....');
            isLoading = true; // Set loading flag to true
            $('#spinner').show();

            var data = {
                page: 1,
                limit: 2
            };

            $.ajax({
                url: "{{ route('load.more.category.product') }}",
                type: 'POST',
                dataType: 'json',
                data: {
                    page: data.page,
                    limit: data.limit
                },
                success: function(res) {
                    $('#loadmore_category_product').append(res.data);
                    isLoading = false;
                    $('#spinner').hide();
                },
                error: function(xhr, status, error) {
                    console.error(error);
                    isLoading = false;
                }
            });
        }



        
        //==========================load more data===========================
        $(function() {
            loadData();

            isLoading = true; // Set loading flag to true
            $('#spinner').show();

            var data = {
                page: 2,
                limit: 2
            };

            var obj = $(document).loadMore({
                loadType: 'auto',
                url: "{{ route('load.more.category.product') }}",
                dataType: 'json',
                type: 'post',
                scrollBottom: 700,
                data: {
                    page: data.page,
                    limit: data.limit
                },
                success: function(res) {
                    if (res.category_length == 0) {
                        this.ajaxSwitch = false;
                    }
                    data.page += 1;
                    obj.updatePram('data', data);
                    render(res.data);

                    isLoading = false;
                    $('#spinner').hide();
                }
            });

            function render(data) {
                $("#loadmore_category_product").append(data);
            }


        });
    </script>
@endsection
