@php
    $template = 'template' . $site_configurations->template_id;
    if ($top_author) {
        $author_info = $top_author->first();
        $total_order = $top_author->sum('total_orders');
    }
@endphp
@extends('frontend.app')
@section('title', $general_settings->title)
@section('meta_title', $general_settings->meta_title)
@section('meta_description', $general_settings->meta_description)
@section('meta_key', $general_settings->meta_key)
@section('meta_content', $general_settings->meta_content)
@section('content')

    <!--============ Banner Area Start ============-->
    <div class="banner_area section_padding_bottom">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <div class="slider_banner_active owl-carousel">
                        @foreach ($sliders as $slider)
                        <div class="slider_banner_item">
                            <a href="{{ $slider->url }}" target="_blank">
                                <img src="{{ asset('storage/' . $slider->image) }}" alt="{{ $slider->url }}">
                            </a>
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--============ Banner Area End ============-->

    <!--============ Advertisement Banner Area Start ============-->
    <div class="advertisement_area section_padding_bottom">
        <div class="container">
            <div class="row gy-2 gx-2 gy-lg-3 gx-lg-3">
                @foreach ($after_slider_banner as $banner)
                <div class="col-xxl-3 col-xl-3 col-lg-3 col-md-3 col-sm-6 col-6">
                    <div class="advertisement_image">
                        <a href="{{$banner->url}}">
                            <img src="{{asset('storage/'.$banner->banner)}}" alt="advertisement">
                        </a>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </div>
    <!--============ Advertisement Banner Area End ============-->

    <!--============ Delicery Features Area Start ============-->
    {{-- @include("frontend.pages.delivery_features") --}}
    <!--============ Delicery Features Area End ============-->

    <!--============ Category Area Start ============-->
    <section class="category_area section_padding_bottom">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <div class="category_active_template4 owl-carousel">
                        @foreach ($categories as $category)  
                            @if (count($category->subCategory) > 0)
                                <div class="category_item">
                                    <div class="category_item_name">
                                        <h3>{{$category->name}}</h3>
                                    </div>
                                    <div class="category_table_cell">
                                        @foreach ($category->subCategory->slice(0, 4) as $subCategory)  
                                            <div class="category_table_cell_item">
                                                <a href="{{route('product.category',[$category->slug, $subCategory->slug])}}">
                                                    <div class="category_book_image">
                                                        <img src="{{asset('storage/'.$subCategory->image)}}" alt="category" style="aspect-ratio:{{ $site_configurations->image_aspect_ratio }}">
                                                    </div>
                                                    <div class="category_book_name">
                                                        <h4> {{$subCategory->name}}</h4>
                                                    </div>
                                                </a>
                                            </div>
                                        @endforeach
                                    </div>
                                    @if (count($category->subCategory) > 4)
                                        <div class="category_see_all">
                                            <a href="{{route('product.category',[$category->slug])}}" class="category_see_all_link">
                                                আরও দেখুন
                                                <i class="las la-angle-right"></i>
                                            </a>
                                        </div>
                                    @endif
                                </div>
                            @endif
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--============ Category Area End ============-->

    <!--============ New Arrival Products Area Start ============-->
    <section class="new_arrival_area">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <div class="section_title_table_cell">
                        <div class="section_title">
                            <h2>নতুন প্রকাশিত বই</h2>
                        </div>
                        <div class="category_list">
                            <ul class="category_list_class">
                                <li>
                                    <a href="{{route('product.category',[$category->slug])}}" class="category_list_link category_list_link_view_all">
                                        আরও দেখুন
                                        <i class="las la-angle-right"></i>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="container">
            <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                <div class="new_arrival_active owl-carousel">
                    @foreach ($new_arrival_products as $product)
                        @include("frontend.components.product_content.$template", ['product' => $product])
                    @endforeach
                </div>
            </div>
        </div>
    </section>
    <!--============ New Arrival Products Area End ============-->

    <!--============ Top Selling Products Area Start ============-->
    <section class="top_selling_area">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <div class="section_title_table_cell">
                        <div class="section_title">
                            <h2>সর্বাধিক বিক্রিত বই</h2>
                        </div>
                        <div class="category_list">
                            <ul class="category_list_class">
                                <li>
                                    <a href="{{route('product.category',[$category->slug])}}" class="category_list_link category_list_link_view_all">
                                        আরও দেখুন
                                        <i class="las la-angle-right"></i>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <div class="top_selling_active owl-carousel">

                        @foreach ($top_selling_products as $product)
                            @include("frontend.components.product_content.$template", ['product' => $product])
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--============ Top Selling Products Area End ============-->

    <!--============ Authors Area End ============-->
    @if ($authors->isNotEmpty())
        <section class="author_area section_padding_bottom">
            <div class="container">
                <div class="row">
                    <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        <div class="author_bg">
                            <div class="row">
                                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                    <div class="section_title_table_cell">
                                        <div class="section_title">
                                            <h2>বেস্ট লেখকগন</h2>
                                        </div>
                                        <div class="category_list">
                                            <ul class="category_list_class">
                                                <li>
                                                    <a href="{{ route('all.authors') }}" class="category_list_link category_list_link_view_all">
                                                        আরও দেখুন
                                                        <i class="las la-angle-right"></i>
                                                    </a>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="section_top_space">
                                <div class="row">
                                    <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                        <div class="author_active owl-carousel">
                                            @foreach ($authors as $author)
                                                <div class="author_item">
                                                    <a href="{{ route('author.details', [$author->slug]) }}" class="author_item_link">
                                                        <div class="author_image">
                                                            <img src="{{ asset('storage/' . $author->image) }}">
                                                        </div>
                                                        <div class="author_name">
                                                            <p>{{ $author->name }}</p>
                                                        </div>
                                                    </a>
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    @endif
    <!--============ Authors Area Start ============-->

    <!--============ Advertisement Banner Area Start ============-->
    <div class="advertisement_area section_padding_bottom">
        <div class="container">
            <div class="row gy-2 gx-2 gy-lg-3 gx-lg-3">
                @foreach ($after_best_writer_banner as $banner)
                <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-6 col-sm-6 col-6">
                    <div class="advertisement_image">
                        <a href="{{$banner->url}}">
                            <img src="{{asset('storage/'.$banner->banner)}}" alt="advertisement">
                        </a>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </div>
    <!--============ Advertisement Banner Area End ============-->

    <!--============ Publisher Area End ============-->
    @if ($publishers->isNotEmpty())
        <section class="publisher_area section_padding_bottom">
            <div class="container">
                <div class="row">
                    <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        <div class="publisher_bg">
                            <div class="row">
                                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                    <div class="section_title_table_cell">
                                        <div class="section_title">
                                            <h2>জনপ্রিয় প্রকাশনী</h2>
                                        </div>
                                        <div class="category_list">
                                            <ul class="category_list_class">
                                                <li>
                                                    <a href="{{ route('publishers') }}" class="category_list_link category_list_link_view_all">
                                                        আরও দেখুন
                                                        <i class="las la-angle-right"></i>
                                                    </a>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="section_top_space">
                                <div class="row">
                                    <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                        <div class="publisher_active owl-carousel">
                                            @foreach ($publishers as $publisher)
                                            <div class="publisher_item">
                                                <a href="{{ route('publisher-details', [$publisher->slug]) }}" class="publisher_item_link">
                                                    <div class="publisher_image">
                                                        <img src="{{ asset('storage/' . $publisher->image) }}">
                                                    </div>
                                                    <div class="publisher_name">
                                                        <p>{{ $publisher->name }}</p>
                                                    </div>
                                                </a>
                                            </div>
                                            @endforeach
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    @endif
    <!--============ Publisher Area Start ============-->

    <!--============ Category Wise Multiple Product Area Start ============-->
    <div id="loadmore_category_product"></div>
    <!--============ Category Wise Multiple Product Area End ============-->

    <!--================Loading Spinner Start==========================-->
    <div id="spinner" style=" display: none;text-align: center;">
        <img src="{{asset('frontend/images/spinner/200w.gif')}}" alt="Loading...">
    </div>
    <!--================Loading Spinner end==========================-->

    <!--============ Author Of The Month Area Start ============-->
    {{-- @if ($top_author)
        <section class="author_of_the_month_area" style="background-image: url('https://i.postimg.cc/zGT7Q9wB/3-bg.jpg')">
            <div class="container">
                <div class="row">
                    <div class="col-xxl-12">
                        <div class="section_title text-center">
                            <h2>Author Of The Month</h2>
                        </div>
                    </div>
                </div>
            </div>
            <div class="container author_of_the_month_top_space">
                <div class="row gy-4 gx-4">
                    <div class="col-xxl-7 col-xl-7 col-lg-8 col-md-12 col-sm-12 col-12 order-lg-1 order-2">
                        <div class="the_month_content">
                            <div class="author_publisher_logo">
                                <img src="{{asset('storage/'.$author_info->author_image)}}" alt="author">
                            </div>
                            <div class="author_profile_details">
                                <h3>{{ $author_info->author_name }}</h3>
                                <span>{{ $total_order }} Orders</span>
                                <p>  {{ Str::substr($author_info->author_description, 0, 150)  }}</p>
                                <a href="#" class="author_read_more">Read More</a>
                            </div>
                            <div class="author_book_list">
                                <ul>
                                    @foreach ($top_author as $book)
                                        <li>

                                            <a href="{{ route('single.product', $book->slug) }}">
                                                <img src="{{asset('storage/'.$book->thumbnail_img)}}" alt="author book">
                                            </a>
                                        </li>
                                    @endforeach
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-xxl-5 col-xl-5 col-lg-4 col-md-12 col-sm-12 col-12 order-lg-2 order-1">
                        <div class="author_publisher_image">
                            <img src="{{asset('storage/'.$author_info->author_image)}}" alt="">
                        </div>
                    </div>
                </div>
            </div>
        </section>
    @endif --}}
    
    <!--============ Author Of The Month Area End ============-->



@endsection

@section('scripts')

    <!-- New Arrival Active Template Three -->
    <script>
        $(".new_arrival_active").owlCarousel({
            loop: false,
            animateOut: "fadeOut",
            animateIn: "fadeIn",
            margin: 14,
            nav: true,
            smartSpeed: 500,
            autoplay: false,
            autoplayTimeout: 7000,
            navText: [
                '<i class="icon fa fa-angle-left"></i>',
                '<i class="icon fa fa-angle-right"></i>',
            ],
            responsive: {
                0: {
                    items: 2,
                    margin: 6,
                },
                576: {
                    items: 3,
                    margin: 8,
                },
                768: {
                    items: 4,
                },
                992: {
                    items: 5,
                },
                1200: {
                    items: 5,
                },
                1400: {
                    items: `{{ $site_configurations->carousel_card_row }}`,
                },
                1500: {
                    items: `{{ $site_configurations->carousel_card_row }}`,
                },
            },
        });
    </script>


    <!-- Top Selling Active Active Template Three -->
    <script>
        $(".top_selling_active").owlCarousel({
            loop: false,
            animateOut: "fadeOut",
            animateIn: "fadeIn",
            margin: 14,
            nav: true,
            smartSpeed: 500,
            autoplay: false,
            autoplayTimeout: 7000,
            navText: [
                '<i class="icon fa fa-angle-left"></i>',
                '<i class="icon fa fa-angle-right"></i>',
            ],
            responsive: {
                0: {
                    items: 2,
                    margin: 6,
                },
                576: {
                    items: 3,
                    margin: 8,
                },
                768: {
                    items: 4,
                },
                992: {
                    items: 5,
                },
                1200: {
                    items: 5,
                },
                1400: {
                    items: `{{ $site_configurations->carousel_card_row }}`,
                },
                1500: {
                    items: `{{ $site_configurations->carousel_card_row }}`,
                },
            },
        });
    </script>

    <script>
        var isLoading = false;
        //================load data========================
        function loadData() {
            console.log('loading....');
            isLoading = true; // Set loading flag to true
            $('#spinner').show();

            var data = {
                page: 1,
                limit: 2
            };

            $.ajax({
                url: "{{ route('load.more.category.product') }}",
                type: 'POST',
                dataType: 'json',
                data: {
                    page: data.page,
                    limit: data.limit
                },
                success: function(res) {
                    $('#loadmore_category_product').append(res.data);
                    isLoading = false;
                    $('#spinner').hide();
                },
                error: function(xhr, status, error) {
                    console.error(error);
                    isLoading = false;
                }
            });
        }



        //==========================load more data===========================
        $(function() {
            loadData();

            isLoading = true; // Set loading flag to true
            $('#spinner').show();

            var data = {
                page: 2,
                limit: 2
            };

            var obj = $(document).loadMore({
                loadType: 'auto',
                url: "{{ route('load.more.category.product') }}",
                dataType: 'json',
                type: 'post',
                scrollBottom: 700,
                data: {
                    page: data.page,
                    limit: data.limit
                },
                success: function(res) {
                    if (res.category_length == 0) {
                        this.ajaxSwitch = false;
                    }
                    data.page += 1;
                    obj.updatePram('data', data);
                    render(res.data);

                    isLoading = false;
                    $('#spinner').hide();
                }
            });

            function render(data) {
                $("#loadmore_category_product").append(data);
            }


        });
    </script>
@endsection
