@php
    $template = 'template' . $site_configurations->template_id;
@endphp
@extends('frontend.app')
@section('title', $general_settings->title)
@section('meta_title', $general_settings->meta_title)
@section('meta_description', $general_settings->meta_description)
@section('meta_key', $general_settings->meta_key)
@section('meta_content', $general_settings->meta_content)
@section('content')


    <!--============ Banner Area Start ============-->
    <div class="banner_area">
        <div class="banner_area">
            <div class="banner_template_container">
                <div class="slider_banner_active owl-carousel">
                    @foreach ($sliders as $slider)
                        <div class="slider_banner_item">
                            <a href="{{ $slider->url }}" target="_blank">
                                <img src="{{ asset('storage/' . $slider->image) }}" alt="{{ $slider->url }}">
                            </a>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
    <!--============ Banner Area End ============-->

    <!--============ Delicery Features Area Start ============-->
    @include('frontend.pages.delivery_features')
    <!--============ Delicery Features Area End ============-->

    <!--============ Category Area Start ============-->
    <section class="category_area section_padding_bottom">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <div class="section_title text-center">
                        <h2>Categories</h2>
                    </div>
                </div>
            </div>
        </div>
        <div class="container section_top_space">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <div class="view_all_cat_container">
                        @foreach ($top_section_categories as $category)
                            <div class="view_all_cat_item">
                                <div class="view_all_cat_image">
                                    <a href="{{ route('product.category', [$category->slug]) }}">
                                        <img src="{{ asset('storage/' . $category->icon_image) }}" alt="{{ $category->name }}" style="aspect-ratio:{{ $site_configurations->image_aspect_ratio }}">
                                    </a>
                                </div>
                                <div class="view_all_cat_name">
                                    <a href="{{ route('product.category', [$category->slug]) }}" class="view_all_cat_name_link">
                                        {{$category->name}}
                                    </a>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--============ Category Area End ============-->

    <!--============ New Arrival Area Start ============-->
    <section class="new_arrival_area section_padding_bottom">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <div class="section_title text-center">
                        <h2>New Arrival Products</h2>
                    </div>
                </div>
            </div>
        </div>
        <div class="container section_top_space">
            <div class="row gy-2 gx-2 gy-lg-3 gx-lg-3">
                @foreach ($new_arrival_products as $product)
                    <div class="{{ $site_configurations->card_row }} col-xl-3 col-lg-4 col-md-4 col-sm-6 col-6">
                        @include("frontend.components.product_content.$template", [
                            'product' => $product,
                        ])
                    </div>
                @endforeach
            </div>
        </div>
    </section>
    <!--============ New Arrival Area End ============-->


    <!--============ Top Selling Area End ============-->
        <section class="new_arrival_area section_padding_bottom">
            <div class="container">
                <div class="row">
                    <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        <div class="section_title text-center">
                            <h2>Top Selling Products</h2>
                        </div>
                    </div>
                </div>
            </div>
            <div class="container section_top_space">
                <div class="row gy-2 gx-2 gy-lg-3 gx-lg-3">
                    @foreach ($top_selling_products as $product)
                        <div class="{{ $site_configurations->card_row }} col-xl-3 col-lg-4 col-md-4 col-sm-6 col-6">
                            @include("frontend.components.product_content.$template", [
                                'product' => $product,
                            ])
                        </div>
                    @endforeach
                </div>
            </div>
        </section>
    <!--============ Top Selling Area End ============-->

    <!--============ Advertisement Banner Area Start ============-->
    <div class="advertisement_area section_padding_bottom">
        <div class="container">
            <div class="row gy-md-3 gx-md-3 gy-2 gx-2">
                @foreach ($after_top_selling_banner as $banner)
                    <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-6 col-sm-6 col-6">
                        <div class="advertisement_image">
                            <a href="{{ $banner->url }}">
                                <img src="{{ asset('storage/' . $banner->banner) }}" alt="advertisement">
                            </a>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </div>
    <!--============ Advertisement Banner Area End ============-->

    <!--============ Category Wise Multiple Product Area Start ============-->
    <div id="loadmore_category_product">
    </div>
    <!--============ Category Wise Multiple Product Area End ============-->


    <!--================Loading Spinner Start==========================-->
    <div id="spinner" style=" display: none;text-align: center;">
        <img src="{{ asset('frontend/images/spinner/200w.gif') }}" alt="Loading...">
    </div>
    <!--================Loading Spinner end==========================-->

    <!--============ Advertisement Banner Area Start ============-->
    @if ($before_footer_section)
        <div class="advertisement_area section_padding_bottom">
            <div class="container">
                <div class="row gy-md-3 gx-md-3 gy-2 gx-2">
                    <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        <div class="advertisement_image">
                            <a href="{{ $before_footer_section->url }}">
                                <img src="{{ asset('storage/' . $before_footer_section->banner) }}" alt="advertisement">
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endif
    <!--============ Advertisement Banner Area End ============-->

    <!--============ Customer Review Section Area Start ============-->
    @if ($cus_review->isNotEmpty())
        @include('frontend.pages.review', ['cus_review' => $cus_review])
    @endif
    <!--============ Customer Review Section Area End ============-->
@endsection

@section('scripts')

    <!-- New Arrival Active -->
    <script>
        $(".new_arrival_active").owlCarousel({
            loop: true,
            animateOut: "fadeOut",
            animateIn: "fadeIn",
            margin: 14,
            nav: false,
            smartSpeed: 500,
            autoplay: true,
            autoplayTimeout: 7000,
            navText: [
                '<i class="icon fa fa-angle-left"></i>',
                '<i class="icon fa fa-angle-right"></i>',
            ],
            responsive: {
                0: {
                    items: 2,
                    margin: 6,
                },
                576: {
                    items: 3,
                    margin: 8,
                },
                768: {
                    items: 3,
                },
                992: {
                    items: 4,
                },
                1200: {
                    items: 4,
                },
                1400: {
                    items: `{{ $site_configurations->carousel_card_row }}`,
                },
                1500: {
                    items: `{{ $site_configurations->carousel_card_row }}`,
                },
            },
        });
    </script>

    <!-- Top Selling Active Active -->
    <script>
        $(".top_selling_active").owlCarousel({
            // loop: true,
            animateOut: "fadeOut",
            animateIn: "fadeIn",
            margin: 14,
            nav: false,
            smartSpeed: 500,
            autoplay: true,
            autoplayTimeout: 7000,
            navText: [
                '<i class="icon fa fa-angle-left"></i>',
                '<i class="icon fa fa-angle-right"></i>',
            ],
            responsive: {
                0: {
                    items: 2,
                    margin: 6,
                },
                576: {
                    items: 3,
                    margin: 8,
                },
                768: {
                    items: 3,
                },
                992: {
                    items: 4,
                },
                1200: {
                    items: 4,
                },
                1400: {
                    items: `{{ $site_configurations->carousel_card_row }}`,
                },
                1500: {
                    items: `{{ $site_configurations->carousel_card_row }}`,
                },
            },
        });
    </script>

    <script>
        var isLoading = false;
        //================load data========================
        function loadData() {
            console.log('loading....');
            isLoading = true; // Set loading flag to true
            $('#spinner').show();

            var data = {
                page: 1,
                limit: 2
            };

            $.ajax({
                url: "{{ route('load.more.category.product') }}",
                type: 'POST',
                dataType: 'json',
                data: {
                    page: data.page,
                    limit: data.limit
                },
                success: function(res) {
                    $('#loadmore_category_product').append(res.data);
                    isLoading = false;
                    $('#spinner').hide();
                },
                error: function(xhr, status, error) {
                    console.error(error);
                    isLoading = false;
                }
            });
        }

        //==========================load more data===========================
        $(function() {
            loadData();

            isLoading = true; // Set loading flag to true
            $('#spinner').show();

            var data = {
                page: 2,
                limit: 2
            };

            var obj = $(document).loadMore({
                loadType: 'auto',
                url: "{{ route('load.more.category.product') }}",
                dataType: 'json',
                type: 'post',
                scrollBottom: 700,
                data: {
                    page: data.page,
                    limit: data.limit
                },
                success: function(res) {
                    if (res.category_length == 0) {
                        this.ajaxSwitch = false;
                    }
                    data.page += 1;
                    obj.updatePram('data', data);
                    render(res.data);

                    isLoading = false;
                    $('#spinner').hide();
                }
            });

            function render(data) {
                $("#loadmore_category_product").append(data);
            }
        });
    </script>
@endsection