@php
    $template = 'template' . $site_configurations->template_id;
@endphp
@extends('frontend.app')
@section('title', $general_settings->title)
@section('meta_title', $general_settings->meta_title)
@section('meta_description', $general_settings->meta_description)
@section('meta_key', $general_settings->meta_key)
@section('meta_content', $general_settings->meta_content)
@section('content')


    <!--============ Banner Area Start ============-->
    <div class="banner_area">

        <!-- template one start -->
        <div class="banner_area section_padding_bottom">
            <div class="container">
                <div class="row">
                    <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        <div class="slider_banner_active owl-carousel">
                            @foreach ($sliders as $slider)
                                <div class="slider_banner_item">
                                    <a href="{{ $slider->url }}" target="_blank">
                                        <img src="{{ asset('storage/' . $slider->image) }}" alt="{{ $slider->url }}">
                                    </a>
                                </div>
                            @endforeach

                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- template one end -->

    </div>
    <!--============ Banner Area End ============-->

    <!--============ Category Area Start ============-->

    <!-- template one start -->
    @if ($top_section_categories->count() > 0)
        <section class="category_area section_padding_bottom lg-0 mt-4">
            <div class="container">
                <div class="row">
                    <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        <div class="section_title text-center mb-3">
                            <h2>Categories</h2>
                        </div>
                    </div>
                </div>
            </div>
            <div class="container">
                <div class="row">
                    <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        <div class="category_active_template8 owl-carousel">
                            @foreach ($top_section_categories as $category)
                                <div class="category_item">
                                    <a href="{{ route('product.category', [$category->slug]) }}" class="category_item_link">
                                        <div class="category_image">
                                            <img src="{{ asset('storage/' . $category->icon_image) }}"
                                                alt="{{ $category->name }}"
                                                style="aspect-ratio:{{ $site_configurations->image_aspect_ratio }}">
                                        </div>
                                        <div class="category_name">
                                            <p>{{ $category->name }}</p>
                                        </div>
                                    </a>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </section>
    @endif


    <!--============ Skin Concern Area Start ============-->
    @if ($skin_concern_products->count() > 0)
        <section class="skin_concern_area section_padding_bottom _custom_padding_top_index_section">
            <div class="container pb-3">
                <div class="row">
                    <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        <div class="section_title">
                            <h2>Skin Concern</h2>
                        </div>
                    </div>
                </div>
            </div>
            <div class="container">
                <div class="row gy-md-3 gx-md-3 gy-2 gx-2">
                    @forelse ($skin_concern_products as $skin)
                        <div class="col-xxl-2 col-xl-3 col-lg-3 col-md-4 col-sm-4 col-6">
                            <div class="skin_concern_item">
                                <a href="{{ route('concern.product', $skin->slug) }}" class="skin_concern_item_link">
                                    <div class="skin_concern_image">
                                        <img src="{{ asset('storage/' . $skin->image) }}" alt="skin types">
                                    </div>
                                </a>
                            </div>
                        </div>
                    @empty
                        <h3>No concern found</h3>
                    @endforelse
                </div>
            </div>
        </section>
    @endif
    
    <!--============ Skin Concern Area End ============-->




    <!--============ Shop By Origin Area Start ============-->
    {{-- @if ($countries_by_products->count() > 0)
        <section class="shop_by_origin_area section_padding_bottom _custom_padding_top_index_section">
            <div class="container pb-3">
                <div class="row">
                    <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        <div class="section_title">
                            <h2>Shop By Origin</h2>
                        </div>
                    </div>
                </div>
            </div>
            <div class="container">
                <div class="row gy-md-3 gx-md-3 gy-2 gx-2">
                    @forelse ($countries_by_products as $country)
                        <div class="col-xxl-2 col-xl-3 col-lg-3 col-md-4 col-sm-4 col-6">
                            <div class="shop_by_origin_item">
                                <a href="{{ route('country.product', $country->id) }}" class="shop_by_origin_item_link">
                                    <div class="shop_by_origin_image">
                                        <img src="{{ asset('storage/' . $country->image) }}" alt="shop origin">
                                    </div>
                                </a>
                            </div>
                        </div>
                    @empty
                        <h3>No Country found</h3>
                    @endforelse
                </div>
            </div>
        </section>
    @endif --}}
    <!--============ Shop By Origin Concern Area End ============-->



    <!--============ New Arrival Products Area Start ============-->
    <!-- template one start -->
    @if ($new_arrival_products->count() > 0)
        <section class="new_arrival_area section_padding_bottom">
            <div class="container">
                <div class="row">
                    <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        <div class="section_title text-center">
                            <h2>New Arrival Products</h2>
                        </div>
                    </div>
                </div>
            </div>
            <div class="container section_top_space">
                <div class="row">
                    <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        <div class="new_arrival_active owl-carousel">
                            @foreach ($new_arrival_products as $product)
                                @include("frontend.components.product_content.$template", [
                                    'product' => $product,
                                ])
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </section>
    @endif
    <!-- template one end -->


    <!--============ New Arrival Products Area End ============-->

    <!--============ Top Selling Products Area Start ============-->
    <!-- template one start -->
    @if ($top_selling_products->count() > 0)
        <section class="top_selling_area section_padding_bottom">
            <div class="container">
                <div class="row">
                    <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        <div class="section_title text-center">
                            <h2>Top Selling Products</h2>
                        </div>
                    </div>
                </div>
            </div>
            <div class="container section_top_space">
                <div class="row">
                    <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        <div class="top_selling_active owl-carousel">
                            @foreach ($top_selling_products as $product)
                                @include("frontend.components.product_content.$template", [
                                    'product' => $product,
                                ])
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </section>
    @endif
    <!-- template one end -->
    <!--============ Top Selling Products Area End ============-->



    <!--============ Advertisement Banner Area Start ============-->
    <div class="advertisement_area section_padding_bottom">
        <div class="container">
            <div class="row gy-md-3 gx-md-3 gy-2 gx-2">
                @foreach ($after_top_selling_banner as $banner)
                    <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-6 col-sm-6 col-6">
                        <div class="advertisement_image">
                            <a href="{{ $banner->url }}">
                                <img src="{{ asset('storage/' . $banner->banner) }}" alt="advertisement">
                            </a>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </div>
    <!--============ Advertisement Banner Area End ============-->

    <!--============ Combo Products Area Start ============-->
    @if ($combo_products->count() > 0 && $combo_products->isNotEmpty())
        <section class="comboProducts_area section_padding_bottom">
            <div class="container">
                <div class="row">
                    <div class="section_title text-center">
                        <h2>Combo Products</h2>
                    </div>
                </div>
            </div>
            <div class="container section_top_space">
                <div class="row">
                    <div class="col-12">
                        <div class="comboProducts_active owl-carousel">
                            @foreach ($combo_products as $product)
                                @include("frontend.components.product_content.$template", [
                                    'product' => $product,
                                ])
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </section>
    @endif
    <!--============ Combo Products Area End ============-->

    <!--============ Brands Area Start ============-->
    @if ($top_section_brand->count() > 0 && $top_section_brand->isNotEmpty())
        <section class="brands_area">
            <div class="container">
                <div class="row">
                    <div class="section_title text-center">
                        <h2>Our brands</h2>
                        <p>Fall in love with the latest novelties and best-sellers from your favorite brands!</p>
                    </div>
                </div>
            </div>
            <div class="container section_top_space">
                <div class="row">
                    <div class="col-12">
                        <div class="brands_active owl-carousel">
                            @foreach ($top_section_brand as $brand)
                                <div class="brand_image_slide_item ">
                                    <a href="{{ route('all.product.brand', $brand->slug) }}" class="brand_list_link">
                                        <img src="{{ asset('storage/' . $brand->image) }}" alt="{{ $brand->name }}"
                                            style="aspect-ratio:{{ $site_configurations->image_aspect_ratio }}"
                                            alt="brnd-img">
                                    </a>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </section>
    @endif
    <!--============ Brands Area End ============-->

    <!--============ Featured Products Area Start ============-->
    @if ($feature_products->count() > 0 && $feature_products->isNotEmpty())
        <section class="featured_area section_padding_bottom _custom_padding_top_index_section">
            <div class="container">
                <div class="row">
                    <div class="section_title text-center">
                        <h2>Featured Products</h2>
                    </div>
                </div>
            </div>
            <div class="container section_top_space">
                <div class="row gy-md-5 gx-md-3 gy-4 gx-2">

                    @forelse ($feature_products as $f_product)
                        <div class="col-xxl-2 column-4  col-lg-3 col-md-4 col-sm-6 col-6">
                            <div class="product_card">
                                <div class="product_image">
                                    <a href="{{ route('single.product', $f_product->slug) }}">
                                        <img src="{{ asset('storage/' . $f_product->thumbnail_img) }}" alt="product">
                                    </a>
                                    <div class="product_discount">
                                        <span>{{ getProductDiscountPrice($f_product->price, $f_product->sale_price) }}%</span>
                                    </div>
                                    <button class="cart_wishlist_btn" id="{{ $f_product->id }}"
                                        onclick="addToWishList(this.id)">
                                        <i class="fa-regular fa-heart"></i>
                                    </button>

                                </div>
                                <div class="product_content">
                                    @if ($product->stock <= 0 && $site_configurations->show_stock_out == 1)
                                        <div class="product_btn">
                                            <a type="button" @disabled(true) class="product_btn_link_stock_out">
                                                {{-- <i class="fa-solid fa-cart-plus"></i> --}}
                                                OUT OF STOCK
                                            </a>
                                        </div>
                                    @else
                                        <div class="product_btn">
                                            <a onclick="addToCardFromHome(this.id)"type="button" id="{{ $f_product->id }}"
                                                class="product_btn_link">
                                                <i class="fa-solid fa-cart-plus"></i>
                                                Add To Cart
                                            </a>
                                        </div>
                                    @endif
                                    <div class="product_name">
                                        <a href="{{ route('single.product', $f_product->slug) }}" class="product_name_link">
                                            <h2>{{ $f_product->name }}</h2>
                                        </a>
                                    </div>
                                    <div class="product_rating">
                                        @if ($f_product->avg_review)
                                            @if ($f_product->avg_review >= 0 && $f_product->avg_review <= 5)
                                                @for ($i = 1; $i <= 5; $i++)
                                                    @if ($f_product->avg_review >= $i)
                                                        <span><i class="fa-solid fa-star"></i></span>
                                                    @elseif ($f_product->avg_review >= $i - 0.5)
                                                        <span><i class="fa-regular fa-star"></i></span>
                                                    @else
                                                        <span> <i class="ion-ios-star-half"></i></span>
                                                    @endif
                                                @endfor
                                                @if ($f_product->review_ratings)
                                                    <span class="cart_rating_count">({{ $f_product->review_ratings }})
                                                        Reviews</span>
                                                @endif
                                            @endif
                                        @endif
                                    </div>
                                    <div class="product_price">
                                        <span class="product_new_price">{{ $f_product->sale_price }} TK</span>
                                        @if ($f_product->price > $f_product->sale_price)
                                            <span class="product_discount_price">{{ $f_product->price }} TK</span>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    @empty
                        <h2>No product found</h2>
                    @endforelse
                </div>
            </div>
        </section>
    @endif
    <!--============ Featured Products Area End ============-->


    <!--============ Category Wise Multiple Product Area Start ============-->
    <div id="loadmore_category_product">
    </div>
    <!--============ Category Wise Multiple Product Area End ============-->


    <!--================Loading Spinner Start==========================-->
    <div id="spinner" style=" display: none;text-align: center;">
        <img src="{{ asset('frontend/images/spinner/200w.gif') }}" alt="Loading...">
    </div>
    <!--================Loading Spinner end==========================-->

    <!--============ Advertisement Banner Area Start ============-->
    @if ($before_footer_section)
        <div class="advertisement_area section_padding_bottom">
            <div class="container">
                <div class="row gy-md-3 gx-md-3 gy-2 gx-2">
                    <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        <div class="advertisement_image">
                            <a href="{{ $before_footer_section->url }}">
                                <img src="{{ asset('storage/' . $before_footer_section->banner) }}" alt="advertisement">
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endif
    <!--============ Advertisement Banner Area End ============-->



    <!--============ Service Area Start ============-->
    <section class="service_area section_padding_bottom d-none d-lg-block">
        <div class="container">
            <div class="row gy-4">
                <div class="col-xxl-3 col-xl-3 col-lg-3 col-md-6">
                    <div class="service_item">
                        <div class="service_icon">
                            <svg class="icon" xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                                stroke-linecap="round" stroke-linejoin="round">
                                <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                <path d="M9 15l6 -6"></path>
                                <circle cx="9.5" cy="9.5" r=".5" fill="currentColor"></circle>
                                <circle cx="14.5" cy="14.5" r=".5" fill="currentColor"></circle>
                                <path
                                    d="M5 7.2a2.2 2.2 0 0 1 2.2 -2.2h1a2.2 2.2 0 0 0 1.55 -.64l.7 -.7a2.2 2.2 0 0 1 3.12 0l.7 .7a2.2 2.2 0 0 0 1.55 .64h1a2.2 2.2 0 0 1 2.2 2.2v1a2.2 2.2 0 0 0 .64 1.55l.7 .7a2.2 2.2 0 0 1 0 3.12l-.7 .7a2.2 2.2 0 0 0 -.64 1.55v1a2.2 2.2 0 0 1 -2.2 2.2h-1a2.2 2.2 0 0 0 -1.55 .64l-.7 .7a2.2 2.2 0 0 1 -3.12 0l-.7 -.7a2.2 2.2 0 0 0 -1.55 -.64h-1a2.2 2.2 0 0 1 -2.2 -2.2v-1a2.2 2.2 0 0 0 -.64 -1.55l-.7 -.7a2.2 2.2 0 0 1 0 -3.12l.7 -.7a2.2 2.2 0 0 0 .64 -1.55v-1">
                                </path>
                            </svg>
                        </div>
                        <div class="service_content">
                            <div class="service_title">
                                <h4>High-quality Goods</h4>
                            </div>
                            <div class="service_description">
                                <p>Enjoy top quality items for less</p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xxl-3 col-xl-3 col-lg-3 col-md-6">
                    <div class="service_item">
                        <div class="service_icon">
                            <svg class="icon" xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                                stroke-linecap="round" stroke-linejoin="round">
                                <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                <path d="M4 14v-3a8 8 0 1 1 16 0v3"></path>
                                <path d="M18 19c0 1.657 -2.686 3 -6 3"></path>
                                <path d="M4 14a2 2 0 0 1 2 -2h1a2 2 0 0 1 2 2v3a2 2 0 0 1 -2 2h-1a2 2 0 0 1 -2 -2v-3z">
                                </path>
                                <path d="M15 14a2 2 0 0 1 2 -2h1a2 2 0 0 1 2 2v3a2 2 0 0 1 -2 2h-1a2 2 0 0 1 -2 -2v-3z">
                                </path>
                            </svg>
                        </div>
                        <div class="service_content">
                            <div class="service_title">
                                <h4>24/7 Live chat</h4>
                            </div>
                            <div class="service_description">
                                <p>Get instant assistance whenever you need it</p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xxl-3 col-xl-3 col-lg-3 col-md-6">
                    <div class="service_item">
                        <div class="service_icon">
                            <svg class="icon" xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                                stroke-linecap="round" stroke-linejoin="round">
                                <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                <path d="M7 17m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"></path>
                                <path d="M17 17m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"></path>
                                <path d="M5 17h-2v-4m-1 -8h11v12m-4 0h6m4 0h2v-6h-8m0 -5h5l3 5"></path>
                                <path d="M3 9l4 0"></path>
                            </svg>
                        </div>
                        <div class="service_content">
                            <div class="service_title">
                                <h4>Express Shipping</h4>
                            </div>
                            <div class="service_description">
                                <p>Fast &amp; reliable delivery options</p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xxl-3 col-xl-3 col-lg-3 col-md-6">
                    <div class="service_item">
                        <div class="service_icon">
                            <svg class="icon" xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                                stroke-linecap="round" stroke-linejoin="round">
                                <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                <path d="M16.7 8a3 3 0 0 0 -2.7 -2h-4a3 3 0 0 0 0 6h4a3 3 0 0 1 0 6h-4a3 3 0 0 1 -2.7 -2">
                                </path>
                                <path d="M12 3v3m0 12v3"></path>
                            </svg>
                        </div>
                        <div class="service_content">
                            <div class="service_title">
                                <h4>Secure Payment</h4>
                            </div>
                            <div class="service_description">
                                <p>Multiple safe payment methods</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--============ Service Area End ============-->




@endsection

@section('scripts')

    <!-- New Arrival Active -->
    <script>
        $(".new_arrival_active").owlCarousel({
            loop: true,
            animateOut: "fadeOut",
            animateIn: "fadeIn",
            margin: 14,
            nav: false,
            smartSpeed: 500,
            autoplay: true,
            autoplayTimeout: 7000,
            navText: [
                '<i class="icon fa fa-angle-left"></i>',
                '<i class="icon fa fa-angle-right"></i>',
            ],
            responsive: {
                0: {
                    items: 2,
                    margin: 6,
                },
                576: {
                    items: 3,
                    margin: 8,
                },
                768: {
                    items: 3,
                },
                992: {
                    items: 4,
                },
                1200: {
                    items: 4,
                },
                1400: {
                    items: `{{ $site_configurations->carousel_card_row }}`,
                },
                1500: {
                    items: `{{ $site_configurations->carousel_card_row }}`,
                },
            },
        });
    </script>

    <!-- Top Selling Active Active -->
    <script>
        $(".top_selling_active").owlCarousel({
            // loop: true,
            animateOut: "fadeOut",
            animateIn: "fadeIn",
            margin: 14,
            nav: false,
            smartSpeed: 500,
            autoplay: true,
            autoplayTimeout: 7000,
            navText: [
                '<i class="icon fa fa-angle-left"></i>',
                '<i class="icon fa fa-angle-right"></i>',
            ],
            responsive: {
                0: {
                    items: 2,
                    margin: 6,
                },
                576: {
                    items: 3,
                    margin: 8,
                },
                768: {
                    items: 3,
                },
                992: {
                    items: 4,
                },
                1200: {
                    items: 4,
                },
                1400: {
                    items: `{{ $site_configurations->carousel_card_row }}`,
                },
                1500: {
                    items: `{{ $site_configurations->carousel_card_row }}`,
                },
            },
        });
    </script>

    <!-- Top Selling Active Active -->
    <script>
        $(".comboProducts_active").owlCarousel({
            // loop: true,
            animateOut: "fadeOut",
            animateIn: "fadeIn",
            margin: 14,
            nav: false,
            smartSpeed: 500,
            autoplay: true,
            autoplayTimeout: 7000,
            navText: [
                '<i class="icon fa fa-angle-left"></i>',
                '<i class="icon fa fa-angle-right"></i>',
            ],
            responsive: {
                0: {
                    items: 2,
                    margin: 6,
                },
                576: {
                    items: 3,
                    margin: 8,
                },
                768: {
                    items: 3,
                },
                992: {
                    items: 4,
                },
                1200: {
                    items: 4,
                },
                1400: {
                    items: `{{ $site_configurations->carousel_card_row }}`,
                },
                1500: {
                    items: `{{ $site_configurations->carousel_card_row }}`,
                },
            },
        });
    </script>

    <!-- Brands Area Active -->
    <script>
        $(".brands_active").owlCarousel({
            loop: true,
            animateOut: "fadeOut",
            animateIn: "fadeIn",
            margin: 14,
            nav: false,
            smartSpeed: 500,
            autoplay: true,
            autoplayTimeout: 7000,
            navText: [
                '<i class="icon fa fa-angle-left"></i>',
                '<i class="icon fa fa-angle-right"></i>',
            ],
            responsive: {
                0: {
                    items: 2,
                    margin: 6,
                },
                768: {
                    items: 3,
                    margin: 8,
                },
                992: {
                    items: 4,
                },
                1200: {
                    items: 6,
                },
                1500: {
                    items: 8,
                },
            },
        });
    </script>

    <script>
        var isLoading = false;
        //================load data========================
        function loadData() {
            console.log('loading....');
            isLoading = true; // Set loading flag to true
            $('#spinner').show();

            var data = {
                page: 1,
                limit: 2
            };

            $.ajax({
                url: "{{ route('load.more.category.product') }}",
                type: 'POST',
                dataType: 'json',
                data: {
                    page: data.page,
                    limit: data.limit
                },
                success: function(res) {
                    $('#loadmore_category_product').append(res.data);
                    isLoading = false;
                    $('#spinner').hide();
                },
                error: function(xhr, status, error) {
                    console.error(error);
                    isLoading = false;
                }
            });
        }




        //==========================load more data===========================
        $(function() {
            loadData();

            isLoading = true; // Set loading flag to true
            $('#spinner').show();

            var data = {
                page: 2,
                limit: 2
            };

            var obj = $(document).loadMore({
                loadType: 'auto',
                url: "{{ route('load.more.category.product') }}",
                dataType: 'json',
                type: 'post',
                scrollBottom: 700,
                data: {
                    page: data.page,
                    limit: data.limit
                },
                success: function(res) {
                    if (res.category_length == 0) {
                        this.ajaxSwitch = false;
                    }
                    data.page += 1;
                    obj.updatePram('data', data);
                    render(res.data);

                    isLoading = false;
                    $('#spinner').hide();
                }
            });

            function render(data) {
                $("#loadmore_category_product").append(data);
            }


        });
    </script>
@endsection
