@extends('frontend.app')
@section('title','Order-Success')
@section('content')
    <!--================== success header start  ==================-->
    <div class="success_header_area section_padding_bottom">
        <div class="success_header">
          <div class="success_title">
            <div class="check_out_icon">
              <i class="fa-solid fa-check"></i>
            </div>
            <h2>  {{dynamic_lang('thank_you')}}            </h2>
          </div>
        </div>
        <div class="success_content_info">
          <p class="success_p english_p">
            {{dynamic_lang('order_success_message')}}
          </p>
          <div class="success_order_details">
            <div class="success_order_header">
              <div class="overview__order">
                <p>Order number:</p>
                <span>{{$order->invoice_no}}</span>
                <input type="hidden" id="invoice_id" value="{{$order->invoice_no}}">
              
              </div>
              <div class="overview__order">
                <p>Date:</p>
                <span>{{$order->created_at->format('Y/M/d h:i a')}}</span>
              </div>
              <div class="overview__order">
                <p>Total:</p>
                <span>{{number_format($order->total + $order->shipping_cost)}} TK</span>
              </div>
              <div class="overview__order">
                <p>Payment method:</p>
                @if ($order->payment_status == 'completed')
                  <span>Bkash</span>
                @else
                  <span>Cash on delivery</span>
                @endif
              </div>
            </div>
            <div class="pay_deliveay_title">
              <p>Pay with cash upon delivery.</p>
            </div>
            <div class="order_details">
              <h4>Order details</h4>
              <table class="order_details_table">
                <tr>
                  <td class="order_left_side product_total">Product</td>
                  <td class="product_total">Total</td>
                </tr>
                @foreach ($order->orderItem as $item)  
                  <tr class="winter_warm_face_masks">
                    <td class="order_left_side winter_warm_td">
                      {{$item->product->name}} × {{$item->quantity}}
                    </td>
                    <td class="">{{number_format($item->total)}} TK</td>
                  </tr>
                @endforeach
                <tr>
                  <td class="order_left_side">Subtotal</td>
                  <td class="">{{number_format($order->orderItem->sum('total'))}} TK</td>
                </tr>
                <tr>
                  <td class="order_left_side">Shipping</td>
                  <td class="">{{number_format($order->shipping_cost)}} TK 
                    {{-- via Inside Dhaka --}}
                  </td>
                </tr>


                <tr>
                  <td class="order_left_side">Coupon</td>
                  <td class="">{{number_format($order->coupon_disocunt)}} TK 
                    {{-- via Inside Dhaka --}}
                  </td>
                </tr>
                <tr>
                  <td class="order_left_side">Payment method</td>
                  @if ($order->payment_status == 'completed')
                    <td class="">Bkash</td>
                  @else
                    <td class="">Cash on delivery</td>
                  @endif
                </tr>
                <tr>
                  <td class="left total">Total</td>
                  <td class="total">{{number_format($order->total + $order->shipping_cost - $order->coupon_disocunt)}} TK</td>
                </tr>
                @if ($order->payment_status == 'completed')

                <tr>
                  <td class="left total">Paid</td>
                  <td class="total">{{number_format($order->paid)}} TK</td>
                </tr>


                  <tr>
                    <td class="left total">Due Amount</td>
                    <td class="total">{{number_format($order->total + $order->shipping_cost - ($order->coupon_disocunt + $order->paid))}} TK</td>
                  </tr>
                @endif


              </table>
            </div>
          </div>
        </div>
      </div>
      <!--================== success header end  ==================-->
  
@endsection
@section('scripts')
  <script>
    document.addEventListener('DOMContentLoaded', function() {
        function handleWindowLoad() {
            var invoice_id = $('#invoice_id').val();
            var purchaseKey = 'purchase_shown_' + invoice_id;

            if (!localStorage.getItem(purchaseKey)) {
                gtmCartItemsEvent('purchase', invoice_id);
                localStorage.setItem(purchaseKey, '1');
            }

            window.removeEventListener('load', handleWindowLoad);
        }
        window.addEventListener('load', handleWindowLoad);
    });
  </script>
@endsection