@extends('frontend.app')
@section('title', $brand->name . ' Products')
@section('meta_title', $brand->meta_title)
@section('meta_description', $brand->meta_description)
@section('meta_key', $brand->meta_key)
@section('meta_content', $brand->meta_content)

@section('content')
    <!--============ Breadcrumb Area Start ============-->
    <div class="breadcrumb_area section_top_space">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-12">
                    <div class="_breadcrumb">
                        <ul>
                            <li>
                                <a href="{{ route('root') }}" class="breadcrumb_link">
                                    <i class="fa-solid fa-house-chimney"></i>
                                </a>
                            </li>
                            <li>
                                <a href="{{ route('brand.products', $brand->slug) }}" class="breadcrumb_link">
                                    {{ $brand->name }}
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--============ Breadcrumb Area End ============-->

    <!--============ Brand Info Area Start ============-->
    <div class="brand_info_area section_padding">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-12">
                    <div class="section_title text-center">
                        <h2>{{ $brand->name }}</h2>
                    </div>
                    @if($brand->description)
                    <div class="brand_description text-center">
                        <p>{{ $brand->description }}</p>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
    <!--============ Brand Info Area End ============-->

    <!--============ Shop Area Start ============-->
    <div class="shop_area section_padding_bottom">
        <div class="container">
            @if ($site_configurations->template_id == 3)
                <div class="row gy-3 gx-2 gy-lg-4 gx-lg-3" id="moreDataLoad">
                    
                </div>
            @elseif ($site_configurations->template_id == 4)
                <div class="row gy-2 gx-2 gy-lg-3 gx-lg-3" id="moreDataLoad">
                        
                </div>
            @else
                <div class="row gy-2 gx-2 gy-lg-3 gx-lg-3" id="moreDataLoad">
                    
                </div>
            @endif
        </div>
    </div>
    <!--============ Shop Area End ============-->

    <!--================Loading Spinner Start==========================-->
    <div id="spinner" style=" display: none;text-align: center;">
        <img src="{{ asset('frontend/images/spinner/200w.gif') }}" alt="Loading...">
    </div>
    <!--================Loading Spinner end==========================-->

    <!--===========get value ================== -->
    <input type="hidden" id="brand_slug" value="{{ $brand->slug }}">

@endsection

@section('scripts')
    <script>
        //==============variable=====================
        var isLoading = false;
        $('#spinner').hide();

        var brand_slug = $('#brand_slug').val();

        //=========loadData==========
        function loadData() {
            isLoading = true; // Set loading flag to true
            $('#spinner').show();
            var postData = {
                page: 1,
                limit: 12,
                brand_slug: brand_slug,
            };

            $.ajax({
                url: "{{ route('load.more') }}",
                type: 'POST',
                dataType: 'json',
                data: postData,
                success: function(res) {
                    $('#moreDataLoad').append(res.data);
                    isLoading = false;
                    $('#spinner').hide();
                },
                error: function(xhr, status, error) {
                    console.error(error);
                    isLoading = false;
                }
            });
        }

        //==========================load more data===========================
        $(function() {
            loadData();

            isLoading = true; // Set loading flag to true
            $('#spinner').show();

            var data = {
                page: 2,
                limit: 12,
                brand_slug: brand_slug
            };

            var postData = {
                page: data.page,
                limit: data.limit,
                brand_slug: data.brand_slug,
            };

            var obj = $(document).loadMore({
                url: "{{ route('load.more') }}",
                dataType: 'json',
                type: 'post',
                scrollBottom: 700,
                data: postData,
                success: function(res) {
                    if (res.product_length == 0) {
                        this.ajaxSwitch = false;
                    }
                    data.page += 1;
                    obj.updatePram('data', data);
                    render(res.data);

                    isLoading = false;
                    $('#spinner').hide();
                }
            });

            function render(data) {
                $("#moreDataLoad").append(data);
            }
        });
    </script>
@endsection