@extends('frontend.app')
@section('title','Brand Products')

@section('content')
       <!--============ Breadcrumb Area Start ============-->
       <div class="breadcrumb_area section_top_space">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-12">
                    <div class="_breadcrumb">
                        <ul>
                            <li>
                                <a href="{{route('root')}}" class="breadcrumb_link">
                                    <i class="fa-solid fa-house-chimney"></i>
                                </a>
                            </li>
                            <li>
                                <a href="{{route('all.product.brand',[$brand->slug])}}" class="breadcrumb_link">
                                   {{$brand->name}}
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--============ Breadcrumb Area End ============-->

    <!--============ Shop Area Start ============-->
    <div class="shop_area section_padding_bottom">
        <div class="container">
            <!-------------------show load product---------------->
            @if ($site_configurations->template_id == 3)
                <div class="row gy-3 gx-2 gy-lg-4 gx-lg-3" id="brandProductLoad">
                    
                </div>
            @elseif ($site_configurations->template_id == 4)
                <div class="row gy-2 gx-2 gy-lg-3 gx-lg-3" id="brandProductLoad">
                        
                </div>
            @else
                <div class="row gy-2 gx-2 gy-lg-3 gx-lg-3" id="brandProductLoad">
                    
                </div>
            @endif
        </div>
    </div>
    <!--============ Shop Area End ============-->

    
    <!--================Loading brandSpinner Start==========================-->
    <div id="brandSpinner" style=" display: none;text-align: center;">
        <img src="{{asset('frontend/images/spinner/200w.gif')}}" alt="Loading...">
    </div>
     <!--================Loading brandSpinner end==========================-->

     <!--===========get value ================== -->
     <input type="hidden" id="brand_slug" value="{{ $brand->slug }}">

@endsection

@section('scripts')
   

    <script>
        //==============variable=====================
        var isLoading = false;
        $('#brandSpinner').hide();

        var brand_slug = $('#brand_slug').val();


        //=========loadData==========
            function loadData() {
                isLoading = true; // Set loading flag to true
                $('#brandSpinner').show();
                var postData = {
                    page:1,
                    limit:12,
                    brand_slug:brand_slug,
                };

                $.ajax({
                    url: "{{route('load.more.brand.data')}}",
                    type: 'POST',
                    dataType: 'json',
                    data: postData,
                    success: function(res){
                        console.log("res data",res);
                        $('#brandProductLoad').append(res.data);
                        isLoading = false;
                        $('#brandSpinner').hide();
                    },
                    error: function (xhr, status, error) {
                        console.error(error);
                        isLoading = false;
                    }
                });
            }
         //==========================load more data===========================
         $(function(){
            loadData();

            isLoading = true; // Set loading flag to true
            $('#brandSpinner').show();

            var data = {
                page: 2,
                limit: 12,
                brand_slug:brand_slug,
            };


            var postData = {
                    page:data.page,
                    limit:data.limit,
                    brand_slug: data.brand_slug,
                };

            var obj = $(document).loadMore({
                url: "{{route('load.more.brand.data')}}",
                dataType: 'json',
                type:'post',
                scrollBottom: 700,
                data: postData,
                success: function (res) {
                    if(res.product_length == 0){
                        this.ajaxSwitch = false; 
                    }
                    data.page += 1;
                    obj.updatePram('data', data);
                    render(res.data);

                    isLoading = false;
                    $('#brandSpinner').hide();
                }
            });

            function render(data) {
                $("#brandProductLoad").append(data);
            }
              
        });
    </script>
@endsection
