@extends('frontend.app')
@if (isset($category) && isset($sub_category) && isset($sub_sub_category))
    @section('title', $sub_sub_category->name)
@elseif (isset($category) && isset($sub_category))
    @section('title', $sub_category->name)
@elseif (isset($category) && $sub_category == null && $sub_sub_category == null)
    @section('title', $category->name)
@endif
@if (isset($category) && isset($sub_category) && isset($sub_sub_category))
    @section('meta_title', $sub_sub_category->meta_title)
    @section('meta_description', $sub_sub_category->meta_description)
    @section('meta_key', $sub_sub_category->meta_key)
    @section('meta_content', $sub_sub_category->meta_content)  
@elseif (isset($category) && isset($sub_category)) 
    @section('meta_title', $sub_category->meta_title)
    @section('meta_description', $sub_category->meta_description)
    @section('meta_key', $sub_category->meta_key)
    @section('meta_content', $sub_category->meta_content)
@elseif (isset($category) && $sub_category == null && $sub_sub_category == null)
    @section('meta_title', $category->meta_title)
    @section('meta_description', $category->meta_description)
    @section('meta_key', $category->meta_key)
    @section('meta_content', $category->meta_content)
@endif
@section('content')
    <!--============ Breadcrumb Area Start ============-->
    <div class="breadcrumb_area section_top_space">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-12">
                    <div class="_breadcrumb">
                        <ul>
                            <li>
                                <a href="{{ route('root') }}" class="breadcrumb_link">
                                    <i class="fa-solid fa-house-chimney"></i>
                                </a>
                            </li>
                            <li>
                                <a href="{{ route('product.category', [$category->slug]) }}" class="breadcrumb_link">
                                    {{ $category->name }}
                                </a>
                            </li>
                            @if (isset($sub_category))
                                <li>
                                    <a href="{{ route('product.category', [$category->slug, $sub_category->slug]) }}"
                                        class="breadcrumb_link">
                                        / {{ $sub_category->name }}
                                    </a>
                                </li>
                            @endif
                            @if (isset($sub_sub_category))
                                <li>
                                    <a href="{{ route('product.category', [$category->slug, $sub_category->slug, $sub_sub_category->slug]) }}"
                                        class="breadcrumb_link">
                                        / {{ $sub_sub_category->name }}
                                    </a>
                                </li>
                            @endif
                            @if (isset($skin))
                                <li>
                                    <a href="" class="breadcrumb_link">
                                        / {{ $skin->name }}
                                    </a>
                                </li>
                            @endif
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--============ Breadcrumb Area End ============-->

    <!--============ Shop Category Area Start ============-->
    {{-- <div class="shop_category_area section_top_space">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-12">
                    <div class="shop_category">
                        <ul>

                            @if (isset($sub_category->subSubCategory) && count($sub_category->subSubCategory) > 0)
                                @foreach ($sub_category->subSubCategory as $sub_subCategory)
                                    <li>
                                        <a href="{{ route('product.category', [$category->slug, $sub_category->slug, $sub_subCategory->slug]) }}"
                                            class="shop_category_link">{{ $sub_subCategory->name }}</a>
                                    </li>
                                @endforeach
                            @else
                                @if (isset($category->subCategory) && count($category->subCategory) > 0)
                                    @foreach ($category->subCategory as $subCategory)
                                        <li>
                                            <a href="{{ route('product.category', [$category->slug, $subCategory->slug]) }}"
                                                class="shop_category_link">{{ $subCategory->name }}</a>
                                        </li>
                                    @endforeach
                                @endif
                            @endif

                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div> --}}
    <!--============ Shop Category Area End ============-->

    <!--============ Shop Area Start ============-->
    <div class="shop_area section_padding_bottom section_top_space">
        <div class="container">

            <div class="row">
                <div class="col-md-2 col-sm-4 col-4 d-lg-none d-md-block">
                    <div class="shop_filters" data-bs-toggle="offcanvas" href="#shopOffcanvas" role="button"
                        aria-controls="shopOffcanvas">
                        <i class="fa-solid fa-filter"></i>
                        <h5>Filters</h5>
                    </div>
                </div>
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-10 col-sm-8 col-8">
                    <div class="shop_product_header_item_short_by_wrap">
                        <div class="shop_product_header_item_short_by">
                            <div class="shop_product_header_item d-none d-lg-block">
                                <h6>All Best Sell (355)</h6>
                            </div>
                            <div class="shop_product_header_short_by">
                                <p>Sort By :</p>
                                <select id="sortingOptions">
                                    <option value="new">Newest</option>
                                    <option value="high_to_low">Price (High to Low)</option>
                                    <option value="low_to_high">Price (Low to High)</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


            <div class="row gy-3 gx-3">
                <div class="col-xxl-3 col-xl-3 col-lg-4 d-none d-lg-block">
                    <div class="widget">
                        <div class="shop_left_side">
                            <div class="accordion" id="accordionPanelsStayOpenExample">
                                <div class="accordion-item">
                                    <h2 class="accordion-header shop_accordion_header" id="priceRange">
                                        <button class="accordion-button shop_accordion_button" type="button"
                                            data-bs-toggle="collapse" data-bs-target="#collapsePriceRange"
                                            aria-expanded="false" aria-controls="collapsePriceRange">
                                            Price Range
                                        </button>
                                    </h2>
                                    <div id="collapsePriceRange" class="accordion-collapse collapse show"
                                        aria-labelledby="priceRange">
                                        <div class="price_range_content">
                                            <div class="price_range">
                                                <div class="range-slider">
                                                    <span class="rangeValues"></span>
                                                    <input id="minPrice" value="0" min="0" max="5000"
                                                        step="10" type="range">
                                                    <input id="maxPrice" value="5000" min="100" max="5000"
                                                        step="10" type="range">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                @if (isset($category->subCategory))
                                    @foreach ($category->subCategory as $subCategory)
                                        <div class="accordion-item">
                                            <h2 class="accordion-header shop_accordion_header"
                                                id="productType-{{ $subCategory->id }}">
                                                <button class="accordion-button shop_accordion_button" type="button"
                                                    data-bs-toggle="collapse"
                                                    data-bs-target="#collapseProductType-{{ $subCategory->id }}"
                                                    aria-expanded="true"
                                                    aria-controls="collapseProductType-{{ $subCategory->id }}">
                                                    {{ $subCategory->name }}
                                                </button>
                                            </h2>
                                            <div id="collapseProductType-{{ $subCategory->id }}"
                                                class="accordion-collapse collapse show"
                                                aria-labelledby="productType-{{ $subCategory->id }}">
                                                <div class="shop_category_list">
                                                    <ul>
                                                        @if (isset($subCategory->subSubCategory))
                                                            @foreach ($subCategory->subSubCategory as $subSubCategory)
                                                                <li>
                                                                    <div class="shop_category_list_check_box">
                                                                        <input type="checkbox"
                                                                            name="subSubCategoryWiseProduct[]"
                                                                            id="checkbox{{ $subSubCategory->name }}"
                                                                            value="{{ $subSubCategory->id }}"
                                                                            @if ($subSubCategory->id == $selected_sub_sub_category_id) checked @endif>
                                                                        <label for="checkbox{{ $subSubCategory->name }}">
                                                                            {{ $subSubCategory->name }}
                                                                        </label>
                                                                    </div>
                                                                </li>
                                                            @endforeach
                                                        @endif
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                @endif

                                <div class="accordion-item">
                                    <h2 class="accordion-header shop_accordion_header" id="brandOne">
                                        <button class="accordion-button shop_accordion_button" type="button"
                                            data-bs-toggle="collapse" data-bs-target="#collapseBrand" aria-expanded="false"
                                            aria-controls="collapseBrand">
                                            Brand
                                        </button>
                                    </h2>
                                    <div id="collapseBrand" class="accordion-collapse collapse show"
                                        aria-labelledby="brandOne">
                                        <div class="shop_size_checkbox_list">

                                            <ul class="laodBrandsItems">
                                                {{-- all brand name comming from ajax call  --}}
                                            </ul>

                                        </div>
                                    </div>
                                </div>
                                <div class="accordion-item">
                                    <h2 class="accordion-header shop_accordion_header" id="countryOne">
                                        <button class="accordion-button shop_accordion_button" type="button"
                                            data-bs-toggle="collapse" data-bs-target="#collapseCountry"
                                            aria-expanded="false" aria-controls="collapseCountry">
                                            Country
                                        </button>
                                    </h2>
                                    <div id="collapseCountry" class="accordion-collapse collapse show"
                                        aria-labelledby="countryOne">
                                        <div class="shop_size_checkbox_list">
                                            <ul>
                                                <ul class="laodCountryNames">
                                                    {{-- all country name comming from ajax call  --}}
                                                </ul>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xxl-9 col-xl-9 col-lg-8">
                    <div class="row gy-5 gx-3" id="moreDataLoad">

                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--============ Shop Area End ============-->




    <!--============ Shop Product Size Category Range Color  Area Area ============-->
    <div class="offcanvas_shop_product_content offcanvas offcanvas-start" tabindex="-1" id="shopOffcanvas"
        aria-labelledby="shopOffcanvas">
        <div class="shop_filter_table_cell">
            <div class="offcanvas_shop_filters">
                <i class="fa-solid fa-filter"></i>
                <h5>Filters</h5>
            </div>
            <div class="shop_close" data-bs-dismiss="offcanvas" aria-label="Close">
                <i class="fa-solid fa-xmark"></i>
            </div>
        </div>

        <div class="accordion" id="accordionPanelsStayOpenExample">
            <div class="accordion-item">
                <h2 class="accordion-header shop_accordion_header" id="priceRange">
                    <button class="accordion-button shop_accordion_button" type="button" data-bs-toggle="collapse"
                        data-bs-target="#collapsePriceRange" aria-expanded="false" aria-controls="collapsePriceRange">
                        Price Range
                    </button>
                </h2>
                <div id="collapsePriceRange" class="accordion-collapse collapse show" aria-labelledby="priceRange">
                    <div class="price_range_content">
                        <div class="price_range">
                            <div class="range-slider">
                                <span class="rangeValues"></span>
                                <input id="minPriceMobile" value="0" min="0" max="5000" step="10"
                                    type="range">
                                <input id="maxPriceMobile" value="5000" min="100" max="5000" step="10"
                                    type="range">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @if (isset($category->subCategory))
                @foreach ($category->subCategory as $subCategory)
                    <div class="accordion-item">
                        <h2 class="accordion-header shop_accordion_header" id="productType-{{ $subCategory->id }}">
                            <button class="accordion-button shop_accordion_button" type="button"
                                data-bs-toggle="collapse" data-bs-target="#collapseProductType-{{ $subCategory->id }}"
                                aria-expanded="true" aria-controls="collapseProductType-{{ $subCategory->id }}">
                                {{ $subCategory->name }}
                            </button>
                        </h2>
                        <div id="collapseProductType-{{ $subCategory->id }}" class="accordion-collapse collapse show"
                            aria-labelledby="productType-{{ $subCategory->id }}">
                            <div class="shop_category_list">
                                <ul>
                                    @if (isset($subCategory->subSubCategory))
                                        @foreach ($subCategory->subSubCategory as $subSubCategory)
                                            <li>
                                                <div class="shop_category_list_check_box">
                                                    <input type="checkbox" name="subSubCategoryWiseProduct[]"
                                                        id="checkbox{{ $subSubCategory->name }}"
                                                        value="{{ $subSubCategory->id }}"
                                                        @if ($subSubCategory->id == $selected_sub_sub_category_id) checked @endif>
                                                    <label for="checkbox{{ $subSubCategory->name }}">
                                                        {{ $subSubCategory->name }}
                                                    </label>
                                                </div>
                                            </li>
                                        @endforeach
                                    @endif
                                </ul>
                            </div>
                        </div>
                    </div>
                @endforeach
            @endif
            <div class="accordion-item">
                <h2 class="accordion-header shop_accordion_header" id="brandOne">
                    <button class="accordion-button shop_accordion_button" type="button" data-bs-toggle="collapse"
                        data-bs-target="#collapseBrand" aria-expanded="false" aria-controls="collapseBrand">
                        Brand
                    </button>
                </h2>
                <div id="collapseBrand" class="accordion-collapse collapse show" aria-labelledby="brandOne">
                    <div class="shop_size_checkbox_list">

                        <ul class="laodBrandsItems">
                            {{-- all brand name comming from ajax call --}}
                        </ul>
                    </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header shop_accordion_header" id="countryOne">
                    <button class="accordion-button shop_accordion_button" type="button" data-bs-toggle="collapse"
                        data-bs-target="#collapseCountry" aria-expanded="false" aria-controls="collapseCountry">
                        Country
                    </button>
                </h2>
                <div id="collapseCountry" class="accordion-collapse collapse show" aria-labelledby="countryOne">
                    <div class="shop_size_checkbox_list">
                        <ul>
                            <ul class="laodCountryNames">
                                {{-- all country name comming from ajax call  --}}
                            </ul>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--============ Shop Product Size Category Range Color  Area End ============-->


    <!--================Loading Spinner Start==========================-->
    <div id="spinner" style=" display: none;text-align: center;">
        <img src="{{ asset('frontend/images/spinner/200w.gif') }}" alt="Loading...">
    </div>
    <!--================Loading Spinner end==========================-->

    <!--===========get value ================== -->
    <input type="hidden" id="category_slug" value="{{ $category->slug }}">
    <input type="hidden" id="subcategory_slug" value="{{ $sub_category->slug ?? '' }}">
    <input type="hidden" id="sub_subcategory_slug" value="{{ $sub_sub_category->slug ?? '' }}">


@endsection
@section('scripts')


    <script>
        //==============variable=====================
        var isLoading = false;
        $('#spinner').hide();

        var category_slug = $('#category_slug').val();
        var subcategory_slug = $('#subcategory_slug').val();
        var sub_subcategory_slug = $('#sub_subcategory_slug').val();



        //==============variable=====================
        var isLoading = false;
        $('#spinner').hide();

        var category_slug = $('#category_slug').val();
        var subcategory_slug = $('#subcategory_slug').val();
        var sub_subcategory_slug = $('#sub_subcategory_slug').val();

        //=========loadData==========
        function loadData() {
            isLoading = true;
            $('#spinner').show();

            var postData = {
                page: 1,
                limit: 12,
                category_slug: category_slug,
                subcategory_slug: subcategory_slug,
                sub_subcategory_slug: sub_subcategory_slug,
            };

            $.ajax({
                url: "{{ route('load.more') }}",
                type: 'POST',
                dataType: 'json',
                data: postData,
                success: function(res) {
                    console.log("res data", res);

                    if (res.product_length == 0) {
                        var noProduct = `
                            <div class="no_product_found_img_box">
                                <img class="no_product_found_img" src="{{ asset('frontend') }}/images/nproduct_img.png" alt="No Product Found">
                            </div>`;
                        $('#moreDataLoad').empty().append(noProduct);
                    } else {
                        $('#moreDataLoad').append(res.data);
                    }

                    //==== Load Brands ====
                    $('.laodBrandsItems').empty();
                    $.each(res.brands, function(index, brand) {
                        var listItem = `
                            <li>
                                <div class="shop_size_checkbox_list_group">
                                    <input type="checkbox" name="productBrands[]" id="checkbox${index}" value="${brand.id}">
                                    <label for="checkbox${index}">
                                        <div class="title">${brand.name}</div>
                                    </label>
                                </div>
                            </li>`;
                        $('.laodBrandsItems').append(listItem);
                    });

                    //==== Load Countries ====
                    $('.laodCountryNames').empty();
                    $.each(res.countries, function(index, country) {
                        var listItem = `
                            <li>
                                <div class="shop_size_checkbox_list_group">
                                    <input type="checkbox" name="productCountrys[]" id="countryCheckbox${index}" value="${country.id}">
                                    <label for="countryCheckbox${index}">
                                        <div class="title">${country.name}</div>
                                    </label>
                                </div>
                            </li>`;
                        $('.laodCountryNames').append(listItem);
                    });

                    //==== Bind Filter Functions ====
                    FilterProductWithType('productBrands', {}, "{{ route('filter.with.brands') }}");
                    FilterProductWithType('productCountrys', {}, "{{ route('filter.with.countries') }}");

                    isLoading = false;
                    $('#spinner').hide();
                },
                error: function(xhr, status, error) {
                    console.error(error);
                    isLoading = false;
                    $('#spinner').hide();
                }
            });
        }

        //=================== Load More ===================
        $(function() {
            loadData();

            isLoading = true;
            $('#spinner').show();

            var data = {
                page: 2,
                limit: 12,
                category_slug: category_slug,
                subcategory_slug: subcategory_slug,
                sub_subcategory_slug: sub_subcategory_slug
            };

            var postData = {
                page: data.page,
                limit: data.limit,
                category_slug: data.category_slug,
                subcategory_slug: data.subcategory_slug,
                sub_subcategory_slug: data.sub_subcategory_slug,
            };

            var obj = $(document).loadMore({
                url: "{{ route('load.more') }}",
                dataType: 'json',
                type: 'post',
                scrollBottom: 700,
                data: postData,
                success: function(res) {
                    if (res.product_length == 0) {
                        this.ajaxSwitch = false;
                    }
                    data.page += 1;
                    obj.updatePram('data', data);
                    render(res.data);

                    isLoading = false;
                    $('#spinner').hide();
                }
            });

            function render(data) {
                $("#moreDataLoad").append(data);
            }
        });



        // select filtering
        $(document).ready(function() {
            $('#sortingOptions').on('change', function() {

                var sortOption = $(this).val();
                $.ajax({
                    url: "{{ route('products.sort.conditions') }}",
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        category_slug: category_slug,
                        sort: sortOption
                    },
                    success: function(res) {

                        if (res.product_length == 0) {
                            var noProduct = `
                            <div class="no_product_found_img_box">
                                <img class="no_product_found_img" src="{{ asset('frontend') }}/images/nproduct_img.png" alt="payment-method">
                            </div>`;
                            $('#moreDataLoad').empty();
                            $('#moreDataLoad').append(
                                noProduct);
                        } else {
                            $('#moreDataLoad')
                                .empty();
                            $('#moreDataLoad').append(res
                                .data);
                            $('#shopOffcanvas').offcanvas('hide');
                        }

                    },
                    error: function(xhr) {
                        console.error('Error fetching sorted products:', xhr);
                    }
                });
            });
        });


        //price filtering

        $(document).ready(function() {
            function handlePriceChange(minPriceSelector, maxPriceSelector) {
                $(minPriceSelector + ', ' + maxPriceSelector).on('change', function() {
                    var minPrice = $(minPriceSelector).val();
                    var maxPrice = $(maxPriceSelector).val();

                    console.log(minPrice, maxPrice);

                    var postData = {
                        min_price: minPrice,
                        max_price: maxPrice,
                        _token: "{{ csrf_token() }}" 
                    };

                    $.ajax({
                        url: "{{ route('products.filter.by.price') }}",
                        type: 'POST',
                        data: postData,
                        success: function(res) {
                            if (res.product_length == 0) {
                                var noProduct = `
                            <div class="no_product_found_img_box">
                                <img class="no_product_found_img" src="{{ asset('frontend') }}/images/nproduct_img.png" alt="no product found">
                            </div>`;
                                $('#moreDataLoad').empty().append(noProduct);
                                $('#shopOffcanvas').offcanvas('hide');
                            } else {
                                $('#moreDataLoad').empty().append(res.data);
                                toastr.success(res.product_length + " product found.");
                                $('#shopOffcanvas').offcanvas('hide');
                            }
                        },
                        error: function(xhr) {
                            toastr.error('Error fetching filtered products', xhr);
                        }
                    });
                });
            }

            handlePriceChange('#minPriceMobile', '#maxPriceMobile');
            handlePriceChange('#minPrice', '#maxPrice');
        });



        function FilterProductWithType(checkboxInputName, postData, ajaxUrl) {
            $(`input[name="${checkboxInputName}[]"]`).on('change', function(e) {
                var selectedItems = [];
                $(`input[name="${checkboxInputName}[]"]:checked`).each(function() {
                    selectedItems.push($(this).val());
                });

                postData[checkboxInputName] = selectedItems;

                console.log(`Selected ${checkboxInputName}:`, selectedItems);

                $.ajax({
                    url: ajaxUrl,
                    type: 'POST',
                    dataType: 'json',
                    data: postData,
                    success: function(res) {
                        if (res.product_length == 0) {
                            var noProduct = `
                        <div class="no_product_found_img_box">
                            <img class="no_product_found_img" src="{{ asset('frontend') }}/images/nproduct_img.png" alt="no product found">
                        </div>`;
                            $('#moreDataLoad').empty().append(noProduct);
                        } else {
                            $('#moreDataLoad').empty().append(res.data);
                        }
                        $('#shopOffcanvas').offcanvas('hide');
                    },
                    error: function(xhr, status, error) {
                        console.error(error);
                        toastr.error('Error fetching filtered products', xhr);
                    }
                });
            });
        }

        
        $(document).ready(function() {
            loadData();
            FilterProductWithType('productBrands', {}, "{{ route('filter.with.brands') }}");
            FilterProductWithType('productCountrys', {}, "{{ route('filter.with.countries') }}");
            FilterProductWithType('subSubCategoryWiseProduct', {
                category_slug: category_slug
            }, "{{ route('filter.with.subSubCategories') }}");
        });


        function updateRangeValues() {
            var min = document.getElementById('minPrice').value;
            var max = document.getElementById('maxPrice').value;
            document.querySelector('.rangeValues').textContent = min + ' - ' + max;
        }

        // Initial load
        updateRangeValues();

        // Update on slider move
        document.getElementById('minPrice').addEventListener('input', updateRangeValues);
        document.getElementById('maxPrice').addEventListener('input', updateRangeValues);


    </script>
@endsection
