@php
    $condition = '';
    if (today()->diffindays($product->created_at) < 14) {
        $condition = 'new';
    } else {
        $condition = 'in-stock';
    }

    $total_product_review = $total_review;
    $total_review = $total_review ? $total_review : 1;
    $variand_count = count($product->productVariant);
    $hasVideo = !empty($product->video_url);

    $template = 'template' . $site_configurations->template_id;
@endphp
@extends('frontend.app')
@section('title', $product->name . ' || ' . $product->product_code)
@section('meta_title', $product->meta_title)
@section('meta_description', $product->meta_description)
@section('meta_key', $product->meta_key)
@section('meta_content', $product->meta_content)
@push('facebook_open_graph')
    <meta property="og:title" content="{{ Str::substr($product->name, 0, 65) }}">
    <meta property="og:description" content="{{ $product->meta_description ?? 'n/a' }}">
    <meta property="og:url" content="{{ route('single.product', $product->slug) }}">
    <meta property="og:image" content="{{ asset('storage/' . $product->thumbnail_img) }}">
    @foreach ($product->productImage as $image)
        <meta property="og:image" content="{{ asset('storage/' . $image->image) }}">
    @endforeach
    @if ($product->sale_price < $product->price)
        <meta property="product:price:amount" content="{{ $product->sale_price }}">
    @else
        <meta property="product:price:amount" content="{{ $product->price }}">
    @endif
    <meta property="product:price:currency" content="BDT">
    <meta property="product:brand" content="{{ $general_settings->title }}">
    <meta property="product:category" content="{{ $product->category->name }}">
    <meta property="product:availability" content="in stock">
    <meta property="product:condition" content="new">
    <meta property="product:retailer_item_id" content="{{ $product->product_code }}">
    <meta property="product:item_group_id" content="{{ $product->id }}">
@endpush
@section('content')
    <!--============ Single Product Area Start ============-->
    <section class="single_product_area section_padding">
        <div class="container">
            <div class="row gy-sm-4 gx-sm-4 gy-4 gx-2">
                <div class="col-xxl-5 col-xl-6 col-lg-6 col-md-12 col-sm-12 col-12">
                    <div class="zooming_image_content">
                        <div id="video-url" data-url="{{ $product->video_url }}"></div>
                        <div class="youtube_video" id="youtube_video">
                            @if (!empty($product->video_url))
                                <iframe id="videoFrame" scrolling="no" width="100%" height="100%"
                                    style="aspect-ratio:{{ $site_configurations->image_aspect_ratio }}"
                                    src="{{ $product->video_url }}?enablejsapi=1&autoplay=1&mute=1"
                                    title="YouTube video player" frameborder="0"
                                    allow="accelerometer; autoplay; encrypted-media; gyroscope;" allowfullscreen>
                                </iframe>
                            @endif
                        </div>

                        <div class="zoom_img_active owl-carousel">
                            @foreach ($product->productImage as $index => $image)
                                <div data-fancybox="gallery" data-src="{{ asset('storage/' . $image->image) }}"
                                    data-dot="
                                        @if ($hasVideo) <div class='video_icon_overlay_content' style='position: relative; display: inline-block;'>
                                            @if ($index == 0)
                                            <span class='video_icon_overlay' onClick='showVideo({{ $image->id }})'></span> @endif
                                        </div>
                                         @endif
                                        <img src='{{ asset('storage/' . $image->image) }}' 
                                            onClick='showImg({{ $image->id }})' style='aspect-ratio:{{ $site_configurations->image_aspect_ratio }}'>
                                    "
                                    style="display: none;" id="main_image_{{ $image->id }}" class="zooming_show_image">
                                    <div class="project-picture" id="{{ $image->id }}">
                                        <img src="{{ asset('storage/' . $image->image) }}" alt=""
                                            style="aspect-ratio:{{ $site_configurations->image_aspect_ratio }}">
                                    </div>
                                </div>
                            @endforeach
                        </div>

                    </div>
                </div>
                <div class="col-xxl-4 col-xl-6 col-lg-6 col-md-12 col-sm-12 col-12">
                    <div class="single_product_details">
                        <div class="single_product_list d-lg-block d-none">
                            <ul>
                                <li>
                                    <a href="{{ route('root') }}" class="single_product_list_link">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="13" height="14"
                                            viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                                            stroke-linecap="round" stroke-linejoin="round" class="feather feather-home">
                                            <path d="M3 9l9-7 9 7v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"></path>
                                            <polyline points="9 22 9 12 15 12 15 22"></polyline>
                                        </svg>
                                    </a>
                                </li>
                                <li>
                                    <a href="{{ route('product.category', [@$product->category->slug]) }}"
                                        class="single_product_list_link">
                                        {{ @$product->category->name }}
                                    </a>
                                </li>
                                @if (isset($product->subCategory))
                                    <li>
                                        <a href="{{ route('product.category', [@$product->category->slug, @$product->subCategory->slug]) }}"
                                            class="single_product_list_link">
                                            {{ @$product->subCategory->name }}
                                        </a>
                                    </li>
                                @endif
                                @if (isset($product->subSubCategory))
                                    <li>
                                        <a href="{{ route('product.category', [@$product->category->slug, @$product->subCategory->slug, @$product->subSubCategory->slug]) }}"
                                            class="single_product_list_link">
                                            {{ @$product->subSubCategory->name }}
                                        </a>
                                    </li>
                                @endif
                            </ul>
                        </div>
                        <div class="single_product_name">
                            <input type="hidden" id="product_id" value="{{ $product->id }}">
                            <input type="hidden" id="product_stock" value="{{ $product->stock }}">
                            <h2>{{ $product->name }} - <span>{{ $product->product_code }}</span></h2>
                        </div>
                        {{-- <div class="single_product_attribute s_p_code">
                            <strong>Code:</strong>
                            <span>{{ $product->product_code }}</span>
                        </div> --}}


                        <div class="single_product_attribute s_p_price">
                            <strong>Price:</strong>
                            <div class="single_product_price">

                                <span class="single_product_new_price" id="variant_wise_price">{{ $product->sale_price }}
                                    TK</span>
                                @if ($product->price > $product->sale_price)
                                    <span class="single_product_discount_price sigle_discount_text">{{ $product->price }}
                                        TK</span>
                                @endif
                            </div>
                        </div>

                        {{-- <div class="single_pro_wishlist">
                            <button class="single_pro_wishlist_link" id="{{ $product->id }}"
                                data-variant="{{ $variand_count }}" onclick="addToWishList(this.id)">
                                <svg xmlns="http://www.w3.org/2000/svg" version="1.1"
                                    xmlns:xlink="http://www.w3.org/1999/xlink" x="0" y="0" viewBox="0 0 512 512"
                                    style="enable-background:new 0 0 512 512" xml:space="preserve" class="">
                                    <g>
                                        <path
                                            d="M489.864 101.1A130.755 130.755 0 0 0 429.7 50.21c-28.112-11.8-59.687-13.924-91.309-6.127-28.978 7.146-57.204 22.645-82.391 45.129-25.189-22.486-53.418-37.986-82.4-45.131-31.623-7.8-63.2-5.674-91.312 6.134a130.755 130.755 0 0 0-60.161 50.9C7.107 124.859-.534 153.734.03 184.615 2.534 321.9 207.036 446.737 248.006 470.37a16 16 0 0 0 15.989 0c40.974-23.636 245.494-148.495 247.976-285.779.558-30.879-7.086-59.751-22.107-83.491zm-9.887 82.916c-.8 44.388-30.39 96.139-85.563 149.655C343.319 383.229 285.2 420.583 256 437.964c-29.2-17.378-87.31-54.727-138.4-104.287-55.176-53.512-84.766-105.259-85.576-149.646-.884-48.467 22.539-87.462 62.656-104.313a106.644 106.644 0 0 1 41.511-8.238c36.795 0 75.717 17.812 108.4 51.046a16 16 0 0 0 22.815 0c45.406-46.17 102.85-62.573 149.9-42.811 40.121 16.845 63.547 55.834 62.671 104.298z"
                                            fill="currentColor" opacity="1" data-original="currentColor"></path>
                                    </g>
                                </svg>
                                <span>Add To Wishlist</span>
                            </button>
                        </div> --}}

                        {{-- <div class="shipping_highlight">
                            <h4 class="text-bangla"> {{ dynamic_lang('delivery_time') }} </h4>
                        </div> --}}

                        @if ($product->stock > 0 || $site_configurations->show_stock_out != 1)
                            @if ($variand_count > 0)
                                @foreach ($attributes as $attribute_id => $attribute_name)
                                    @if ($product->productVariant->contains('attribute_id', $attribute_id))
                                        <div class="select_attribute_container s_p_select">
                                            <strong class="single_product_attribute_label">Select
                                                {{ $attribute_name }}</strong>
                                            <div class="single_product_attribute">
                                                <div class="single_product_size_checkbox_list"
                                                    id="product_variant_{{ strtolower($attribute_name) }}">
                                                    <ul> @php
                                                        $sizeOrder = [
                                                            '26',
                                                            '27',
                                                            '28',
                                                            '29',
                                                            '30',
                                                            '31',
                                                            '32',
                                                            '33',
                                                            '34',
                                                            '35',
                                                            '36',
                                                            '37',
                                                            '38',
                                                            '39',
                                                            '40',
                                                            '41',
                                                            '42',
                                                            '43',
                                                            '44',
                                                            'XXS',
                                                            'XS',
                                                            'S',
                                                            'M',
                                                            'L',
                                                            'XL',
                                                            'XXL',
                                                            '2XL',
                                                            '3XL',
                                                            '4XL',
                                                            '5XL',
                                                        ];

                                                        $sortedVariants = $product->productVariant
                                                            ->where('attribute_id', $attribute_id)
                                                            ->sortBy(function ($variant) use ($sizeOrder) {
                                                                return array_search(
                                                                    $variant->variant->name,
                                                                    $sizeOrder,
                                                                ) !== false
                                                                    ? array_search($variant->variant->name, $sizeOrder)
                                                                    : 999;
                                                            });
                                                    @endphp
                                                        @foreach ($sortedVariants as $variant)
                                                            <li>
                                                                <div
                                                                    class="single_product_size_checkbox_list_group  variant">
                                                                    <input type="radio"
                                                                        name="variant{{ $attribute_name }}"
                                                                        value="{{ $variant->variant->name }}"
                                                                        onclick="getVariant(this.id, {{ $variant->price }}, {{ $product->sale_price }})"
                                                                        id="{{ $variant->variant->name . $variant->variant->id }}">
                                                                    <label
                                                                        for="{{ $variant->variant->name . $variant->variant->id }}">
                                                                        <div class="title">
                                                                            {{ $variant->variant->name }}
                                                                        </div>
                                                                    </label>
                                                                </div>
                                                            </li>
                                                        @endforeach
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                    @endif
                                @endforeach
                            @endif
                        @endif
                        @if ($product->stock <= 0 && $site_configurations->show_stock_out == 1)
                            <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-6 col-sm-6 col-6 mt-3">
                                <a href="#" disabled class="button_disable_add_to_cart">
                                    <i class="fa-solid fa-cart-shopping"></i>
                                    Out of stock
                                </a>
                            </div>
                        @else
                            <div class="single_product_qty_with_buy_now_btn">
                                <div class="single_product_attribute">
                                    <strong class="single_product_attribute_label d-lg-block d-none">Quantity</strong>
                                </div>
                                <div class="row gx-md-3 gy-md-3 gx-2 gy-2">

                                    <div class="col-xxl-5 col-xl-5 col-lg-5 col-md-6 col-sm-6 col-6">
                                        <div class="single_product_attribute">

                                            <div class="single_product_qty">
                                                <div class="single_product_qty_btn_minus">
                                                    <button type="button" onclick="decrement()"
                                                        class="single_product_qty_minus">
                                                        <i class="fa-solid fa-minus"></i>
                                                    </button>
                                                </div>
                                                <input class="product_qty" type="text" value="1" min="1">
                                                <div class="single_product_qty_btn_minus">
                                                    <button type="button" onclick="Increment()"
                                                        class="single_product_qty_plus">
                                                        <i class="fa-solid fa-plus"></i>
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-xxl-5 col-xl-5 col-lg-5 col-md-6 col-sm-6 col-6">
                                        <button type="button" id="{{ $product->id }}"
                                            data-variant="{{ $variand_count }}" class="single_product_add_to_cart"
                                            onclick="addToCard(event, this.id, this.getAttribute('data-variant'))">
                                            {{ dynamic_lang('add_to_cart') }}
                                        </button>
                                    </div>
                                    <div class="col-xxl-2 col-xl-2 col-lg-2 col-md-2 col-sm-2 col-2 d-lg-block d-none">
                                        <button class="single_product_add_to_wishlist" id="{{ $product->id }}"
                                            data-variant="{{ $variand_count }}" onclick="addToWishList(this.id)">
                                            <i class="fa-regular fa-heart"></i>
                                        </button>
                                    </div>
                                    <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                        <div class="single_product_buy_now_btn">
                                            <form id="buyNowForm" action="{{ route('buy.now') }}" method="POST">
                                                @csrf
                                                <input type="hidden" name="product_id" id="form_product_id"
                                                    value="">
                                                <input type="hidden" name="quantity" id="form_quantity" value="">
                                                <!-- Dynamic variant inputs will be appended here -->
                                                <a href="#" id="{{ $product->id }}"
                                                    data-variant="{{ $variand_count }}"
                                                    onclick="submitBuyNowForm(this.id, this.getAttribute('data-variant'), event)"
                                                    class="single_product_buy_now_btn_link cart_check_out">
                                                    {{ dynamic_lang('order_now') }}
                                                </a>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endif

                        <div class="contact_us_container">
                            <a href="tel:{{ $general_settings->header_contact_number }}"
                                class="call_contact_us call_whats">
                                <div class="call_icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                        viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                                        stroke-linecap="round" stroke-linejoin="round" class="feather feather-phone">
                                        <path
                                            d="M22 16.92v3a2 2 0 0 1-2.18 2 19.79 19.79 0 0 1-8.63-3.07 19.5 19.5 0 0 1-6-6 19.79 19.79 0 0 1-3.07-8.67A2 2 0 0 1 4.11 2h3a2 2 0 0 1 2 1.72 12.84 12.84 0 0 0 .7 2.81 2 2 0 0 1-.45 2.11L8.09 9.91a16 16 0 0 0 6 6l1.27-1.27a2 2 0 0 1 2.11-.45 12.84 12.84 0 0 0 2.81.7A2 2 0 0 1 22 16.92z">
                                        </path>
                                    </svg>
                                </div>
                                <div class="contact_des">
                                    <h5>{{ dynamic_lang('call_text') }}</h5>
                                    <h6>
                                        {{ $general_settings->header_contact_number }}
                                    </h6>
                                </div>

                                <div class="status-badge message_badge"></div>
                            </a>
                            <a href="https://wa.me/+88{{ $general_settings->whatsapp_number }}" id="whatsappLink"
                                class="call_contact_us call_whats">
                                <div class="whats_up">
                                    <i class="fa-brands fa-whatsapp"></i>
                                </div>
                                <div class="contact_des">
                                    <h5>{{ dynamic_lang('whatsapp_text') }}</h5>
                                    <h6>
                                        {{ $general_settings->whatsapp_number }}
                                    </h6>
                                </div>

                                <div class="status-badge whats_badge"></div>
                            </a>
                        </div>

                    </div>
                </div>
                @if ($related_products->isNotEmpty())
                    <div class="col-xxl-3 d-none d-xxl-block">
                        <div class="related_side_products_area">
                            <div class="section_title text-center">
                                <h2>Related Products</h2>
                            </div>
                            <div class="related_side_products owl-carousel">
                                @foreach ($related_products->take(10)->chunk(5) as $chunk)
                                    <div class="related_products_item">
                                        @foreach ($chunk as $related_product)
                                            <a href="{{ route('single.product', $related_product->slug) }}"
                                                class="related_product_item_link">
                                                <div class="related_product_img">
                                                    <img src="{{ asset('storage/' . $related_product->thumbnail_img) }}"
                                                        alt="{{ $related_product->name }}">
                                                </div>
                                                <div class="related_product_content">
                                                    <div class="related_product_name">
                                                        <h6>{{ $related_product->name }}</h6>
                                                    </div>
                                                    <div class="related_product_price">
                                                        <span
                                                            class="related_product_sale_price">{{ $related_product->sale_price }}TK</span>
                                                        <span
                                                            class="related_product_discount_price">{{ $related_product->price }}TK</span>
                                                    </div>
                                                </div>
                                            </a>
                                        @endforeach
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </section>
    <!--============ Single Product Area End ============-->

    <!--============ Single Product Tab Area Start ============-->
    <div class="single_product_tab_area section_padding_bottom">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <div class="single_product_tab">
                        <ul class="nav nav-tabs single_product_tab_nav" id="myTab" role="tablist">
                            <li class="nav-item single_product_tab_nav_item" role="presentation">
                                <button class="nav-link single_product_tab_nav_link active" id="home-tab"
                                    data-bs-toggle="tab" data-bs-target="#home" type="button" role="tab"
                                    aria-controls="home" aria-selected="true">
                                    Description
                                </button>
                            </li>
                            <li class="nav-item single_product_tab_nav_item" role="presentation">
                                <button class="nav-link single_product_tab_nav_link" id="profile-tab"
                                    data-bs-toggle="tab" data-bs-target="#profile" type="button" role="tab"
                                    aria-controls="profile" aria-selected="false">
                                    How To Order
                                </button>
                            </li>
                            <li class="nav-item single_product_tab_nav_item" role="presentation">
                                <button class="nav-link single_product_tab_nav_link" id="contact-tab"
                                    data-bs-toggle="tab" data-bs-target="#contact" type="button" role="tab"
                                    aria-controls="contact" aria-selected="false">
                                    Reviews
                                </button>
                            </li>
                        </ul>
                        <div class="tab-content" id="myTabContent">
                            <div class="tab-pane fade show active" id="home" role="tabpanel"
                                aria-labelledby="home-tab">
                                <div class="single_product_tab_content">
                                    {!! $product->details !!}
                                </div>
                            </div>
                            <div class="tab-pane fade" id="profile" role="tabpanel" aria-labelledby="profile-tab">
                                <div class="single_product_tab_content">
                                    <div class="single_product_tab_list">
                                        <ul>
                                            <li>
                                                Select number of product you want to buy.
                                            </li>
                                            <li>
                                                Click <strong>Add To Cart</strong> Button
                                            </li>
                                            <li>
                                                Then go to checkout page
                                            </li>
                                            <li>
                                                If you are a new customer, please click on Sign Up.provide us your valid
                                                information information.
                                            </li>
                                            <li>
                                                Complete your checkout, we received your order, and for order confirmation
                                                or customer service contact with you
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="contact" role="tabpanel" aria-labelledby="contact-tab">
                                <div class="single_product_tab_content">
                                    <div class="customer_comment_area section_padding_bottom">
                                        <div class="row">
                                            <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                                <div class="section_title text-center">
                                                    <h2>Reviews</h2>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="section_top_space">
                                            <div class="row gy-4 gx-4">

                                                <div class="col-xxl-3 col-xl-4 col-lg-12 col-md-12 col-sm-12 col-12">
                                                    <div class="customer_comment_title">
                                                        <span
                                                            class="customer_comment_avarage_rating">{{ $product->avg_review ?? 0 }}</span>
                                                        <span class="customer_comment_rating_name">
                                                            {{-- <i class="fa-solid fa-star"></i> --}}
                                                            Reviews
                                                        </span>
                                                    </div>
                                                    @php
                                                        $fullStars = floor($product->avg_review); // Full stars
                                                        $halfStar =
                                                            $product->avg_review - $fullStars >= 0.5 ? true : false; // Half star check
                                                    @endphp

                                                    <div class="customer_comment_rating">
                                                        @for ($i = 1; $i <= $fullStars; $i++)
                                                            <span>
                                                                <i class="fa-solid fa-star"></i>
                                                            </span>
                                                        @endfor

                                                        @if ($halfStar)
                                                            <span>
                                                                <i class="fa-solid fa-star-half-stroke"></i>
                                                            </span>
                                                        @endif

                                                        {{-- Fill remaining stars (if needed, e.g., for a 5-star rating system) --}}
                                                        {{-- @for ($i = $fullStars + ($halfStar ? 1 : 0); $i < 5; $i++)
                                                            <span>
                                                                <i class="fa-regular fa-star"></i>
                                                            </span>
                                                        @endfor --}}
                                                    </div>

                                                    <div class="customer_comment_rating_count">
                                                        <span>{{ number_format($total_product_review) }} reviews</span>
                                                    </div>
                                                </div>

                                                @php
                                                    $ratings = [
                                                        'five_star' => 5,
                                                        'four_star' => 4,
                                                        'three_star' => 3,
                                                        'two_star' => 2,
                                                        'one_star' => 1,
                                                    ];
                                                @endphp

                                                <div class="col-xxl-5 col-xl-5 col-lg-12 col-md-12 col-sm-12 col-12">
                                                    @foreach ($ratings as $ratingKey => $starCount)
                                                        <div class="customer_comment_item">
                                                            <div class="customer_comment_item_star">
                                                                @for ($i = 1; $i <= 5; $i++)
                                                                    <span>
                                                                        <i
                                                                            class="fa-{{ $i <= $starCount ? 'solid' : 'regular' }} fa-star"></i>
                                                                    </span>
                                                                @endfor
                                                            </div>
                                                            <div class="customer_comment_item_percentage_segment">
                                                                <span
                                                                    style="width: {{ number_format(($product->rating_stars[$ratingKey] / $total_review) * 100, 2) }}%;"></span>
                                                            </div>
                                                            <div class="customer_comment_item_percentage">
                                                                <span>{{ number_format(($product->rating_stars[$ratingKey] / $total_review) * 100, 2) }}%</span>
                                                            </div>
                                                        </div>
                                                    @endforeach
                                                </div>

                                                <div class="col-xxl-3 col-xl-3 col-lg-12 col-md-12 col-sm-12 col-12">
                                                    <div class="customer_comment_btn">
                                                        <button class="customer_comment_btn_link" data-bs-toggle="modal"
                                                            data-product_slug="{{ $product->slug }}"
                                                            data-bs-target="#staticBackdrop">
                                                            <i class="fa-regular fa-pen-to-square"></i>
                                                            Write a Review
                                                        </button>
                                                    </div>
                                                </div>

                                                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                                    <div class="customer_comment_review_content">
                                                        <div class="customer_comment_list">
                                                            <ul>
                                                                @foreach ($product_reviews as $review)
                                                                    <li>
                                                                        <div class="comment_customer_content">
                                                                            <div class="comment_customer_name">
                                                                                <h5>{{ $review->user_name }}</h5>
                                                                            </div>
                                                                            <div class="comment_customer_rating">
                                                                                @for ($i = 1; $i <= 5; $i++)
                                                                                    <span>
                                                                                        <i
                                                                                            class="fa-{{ $i <= $review->rating_stars ? 'solid' : 'regular' }} fa-star"></i>
                                                                                    </span>
                                                                                @endfor
                                                                            </div>
                                                                            <div class="customer_comment_details">
                                                                                <p>{{ $review->review }}</p>
                                                                            </div>
                                                                            @if ($review->image)
                                                                                <div class="customer_comment_image">
                                                                                    <img src="{{ asset('storage/' . $review->image) }}"
                                                                                        alt="{{ $review->image }}">
                                                                                </div>
                                                                            @endif
                                                                        </div>
                                                                    </li>
                                                                @endforeach
                                                            </ul>
                                                        </div>
                                                        <div class="comments_pagination">
                                                            {{ $product_reviews->links() }}
                                                        </div>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--============ Single Product Tab Area End ============-->

    <!--============ Related Products Area Start ============-->
    <section class="related_product_area section_padding_bottom">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <div class="section_title text-center">
                        <h2>Related Products</h2>
                    </div>
                </div>
            </div>
        </div>
        <div class="container section_top_space">
            <div class="row gy-lg-3 gx-lg-3 gy-2 gx-2">
                @foreach ($related_products->skip(10) as $product)
                    <div class="{{ $site_configurations->card_row }} col-xl-3 col-lg-4 col-md-4 col-sm-6 col-6">
                        @include("frontend.components.product_content.$template", ['product' => $product])
                    </div>
                @endforeach
            </div>
        </div>
    </section>
    <!--============ Related Products Area End ============-->


    <!--============ Comment Input Area Modal Start ============-->
    <div class="modal fade" id="staticBackdrop">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content modal_content">
                <div class="modal_deader">
                    <div class="modal_star">
                        <div class="modal_close" data-bs-dismiss="modal">
                            <i class="fa-solid fa-xmark"></i>
                        </div>
                        <div class="modal_star_title">
                            <h5>write your review</h5>
                        </div>

                    </div>
                </div>
                <div class="modal_body">
                    <div class="modal_comment_group">
                        <form id="review_form" enctype="multipart/form-data">
                            @csrf
                            <div class="modal_rating">
                                <input type="radio" id="star1" name="rating_stars" value="5">
                                <label for="star1"></label>
                                <input type="radio" id="star2" name="rating_stars" value="4">
                                <label for="star2"></label>
                                <input type="radio" id="star3" name="rating_stars" value="3">
                                <label for="star3"></label>
                                <input type="radio" id="star4" name="rating_stars" value="2">
                                <label for="star4"></label>
                                <input type="radio" id="star5" name="rating_stars" value="1">
                                <label for="star5"></label>
                            </div>
                            <div class="modal_comment_item">
                                <input type="text" name="user_name" placeholder="customer name">
                                @error('user_name')
                                    <span class="is_error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="modal_comment_item_textarea">
                                <textarea name="review" placeholder="write comment"></textarea>
                                @error('review')
                                    <span class="is_error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="modal_comment_item">
                                <input name="image" type="file" id="image">
                                @error('image')
                                    <span class="is_error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="modal_comment_item_btn">
                                <button id="review_submit" class="modal_comment_item_btn_link">Submit</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--============ Comment Input Area End ============-->

    {{-- Mobile view size --}}




@endsection
@section('scripts')
    <script src="https://www.youtube.com/iframe_api"></script>
    <script>
        Fancybox.bind('[data-fancybox]', {
            //
        });
    </script>
    <script>
        function submitBuyNowForm(id, have_variant, event) {
            event.preventDefault();
            let variants = {};
            let missingVariant = '';

            $('input[name^="variant"]').each(function() {
                let variantName = $(this).attr('name').replace('variant',
                    '');
                if (!$(`input[name="${$(this).attr('name')}"]:checked`).val()) {

                    missingVariant = variantName;
                    return false;
                } else {

                    variants[variantName] = $(`input[name="${$(this).attr('name')}"]:checked`).val();
                }
            });

            if (missingVariant) {
                toastr.info(`Please Select ${missingVariant}`);
                return;
            }


            document.getElementById('form_product_id').value = id;
            let quantity = document.querySelector(".product_qty").value;
            document.getElementById('form_quantity').value = quantity;


            $('#buyNowForm').find('.variant-input').remove();

            for (const [variant, value] of Object.entries(variants)) {
                $('<input>')
                    .attr('type', 'hidden')
                    .attr('name', `variants[${variant}]`)
                    .attr('value', value)
                    .addClass('variant-input')
                    .appendTo('#buyNowForm');
            }

            toastr.success('Order is processing, please wait...');

            document.getElementById('buyNowForm').submit();
            missingVariant = {};
        }
    </script>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Code to execute when the DOM is fully loaded
            function handleWindowLoad() {
                console.log('Window loading has ended.');
                //call product showing events
                gtmEvent($('#product_id').val(), 'view_item', 1);
                window.removeEventListener('load', handleWindowLoad);
            }
            window.addEventListener('load', handleWindowLoad, {
                once: true
            });
        });

        function mobileSubmenu($id) {
            document.getElementById($id).classList.toggle("mobile_submenu_toggle");
        }

        function mobileSubSubmenu($id) {
            document.getElementById($id).classList.toggle("mobile_sub_submenu_toggle");
        }
    </script>
    <!-- header mobile menu js end -->

    <!-- header mobile search js start -->
    <script>
        function search() {
            document.getElementById("search_id").classList.toggle("search_toggle");
        }
    </script>
    <!-- header mobile search js end -->

    <!-- multiple category mobile menu js start -->
    <script>
        function categoryList() {
            document.getElementById("category_list_id").classList.toggle("category_list_toggle");
        }
    </script>
    <!-- multiple category mobile menu js end -->
    <script>
        document.getElementById('whatsappLink').addEventListener('click', function(event) {
            event.preventDefault(); // Prevent default action
            var whatsappNumber = '{{ $general_settings->whatsapp_number }}';
            var pageUrl = window.location.href; // Get current page URL
            // console.log(pageUrl);
            var message = encodeURIComponent(pageUrl);
            var whatsappUrl = `https://wa.me/+88${whatsappNumber}?text=${message}`;
            // Open the WhatsApp URL in a new tab
            window.open(whatsappUrl, '_blank');
        });
    </script>
    <!-- Zooming Image Start -->
    <script>
        var player; // Reference to the YouTube player

        // Load the YouTube API
        function onYouTubeIframeAPIReady() {
            player = new YT.Player('videoFrame', {
                events: {
                    'onReady': onPlayerReady,

                }
            });
        }

        // This will be called when the player is ready
        function onPlayerReady(event) {
            // You can optionally start playing the video automatically when the player is ready
            // event.target.playVideo();
        }
        // list image start
        let clickImageList = document.querySelector('.zooming_show_image img');

        function showImg(id) {

            const videoPlayer = document.getElementById("youtube_video");
            // const imagesContainer = document.getElementById(`main_image_${id}`);
            const imageContainers = document.querySelectorAll('.zooming_show_image');
            // Pause and hide video if it's playing
            //if (player && player.getPlayerState() === YT.PlayerState.PLAYING) {
            // player.pauseVideo();
            //}

            videoPlayer.style.display = "none";
            // imagesContainer.style.display = "block";
            if (imageContainers) {
                imageContainers.forEach(imageContainer => {
                    imageContainer.style.display = 'block';
                });
            }

        }


        function resumeVideo() {
            // Play the video when clicking on the video area again
            if (player) {
                player.playVideo();
            }
        }

        // Load the YouTube IFrame API asynchronously
        var tag = document.createElement('script');
        tag.src = "https://www.youtube.com/iframe_api";
        var firstScriptTag = document.getElementsByTagName('script')[0];
        firstScriptTag.parentNode.insertBefore(tag, firstScriptTag);

        // Attach click event to videoWrapper to resume the video
        document.getElementById('youtube_video').addEventListener('click', function() {
            resumeVideo();
        });
        // list image end
        function showVideo(id) {

            var videoPlayer = document.getElementById("youtube_video");
            const imageContainers = document.querySelectorAll('.zooming_show_image');

            // Hide images container and show video player
            if (imageContainers) {
                imageContainers.forEach(imageContainer => {
                    imageContainer.style.display = 'none';
                });
                videoPlayer.style.display = "block";
            }
        }

        document.addEventListener('DOMContentLoaded', function() {
            const videoUrlElement = document.getElementById('video-url');
            const videoPlayer = document.getElementById('youtube_video');
            const imageContainers = document.querySelectorAll('.zooming_show_image');
            const videoIframe = document.getElementById('video-iframe');

            // Get the video URL from the data attribute
            const videoUrl = videoUrlElement.getAttribute('data-url');

            if (videoUrl) {
                // Video URL is present, show video and hide images
                videoPlayer.style.display = 'block';
                imageContainers.forEach(imageContainer => {
                    imageContainer.style.display = 'none';
                });
                videoIframe.src = videoUrl;
            } else {

                videoPlayer.style.display = 'none';
                if (imageContainers.length > 0) {
                    imageContainers.forEach(img => {
                        img.style.display = 'block';
                    });
                }
            }
        });

        // zooming image start
        document.querySelectorAll('.zooming_show_image').forEach(elem => {
            let x, y, width, height;
            elem.onmouseenter = () => {
                const size = elem.getBoundingClientRect();

                x = size.x;
                y = size.y;

                width = size.width;
                height = size.height;
            };

            elem.onmousemove = e => {
                const horizontal = (e.clientX - x) / width * 100;
                const vertical = (e.clientY - y) / height * 100;

                elem.style.setProperty('--x', horizontal + '%');
                elem.style.setProperty('--y', vertical + '%');
            };
        });
        // zooming image end

        // active image start
        var zoomingImageList = document.querySelectorAll("ul li");

        zoomingImageList.forEach(i => {
            i.addEventListener("click", () => {
                resetLinks();
                i.classList.add("active");
            })
        })

        function resetLinks() {
            zoomingImageList.forEach(i => {
                i.classList.remove("active")
            })
        }
        // active image end
    </script>
    <!-- Zooming Image End -->

    <script>
        $(".related_side_products").owlCarousel({
            loop: true,
            margin: 10,
            nav: true,
            smartSpeed: 500,
            autoplay: true,
            autoplayTimeout: 3000,
            autoplayHoverPause: true,
            navText: [
                '<i class="icon fa fa-angle-left related_side_icon"></i>',
                '<i class="icon fa fa-angle-right related_side_icon"></i>',
            ],
            responsive: {
                0: {
                    items: 1
                },
                600: {
                    items: 1
                },
                1000: {
                    items: 1
                }
            }
        });
    </script>
@endsection
