@php
    $condition = '';
    if (today()->diffindays($product->created_at) < 14) {
        $condition = 'new';
    } else {
        $condition = 'in-stock';
    }

    $total_product_review = $total_review;
    $total_review = $total_review ? $total_review : 1;
    $variand_count = count($product->productVariant);
    $hasVideo = !empty($product->video_url);

    $template = 'template' . $site_configurations->template_id;
@endphp
@extends('frontend.app')
@section('title', $product->name . ' || ' . $product->product_code)
@section('meta_title', $product->meta_title)
@section('meta_description', $product->meta_description)
@section('meta_key', $product->meta_key)
@section('meta_content', $product->meta_content)
@push('facebook_open_graph')
    <meta property="og:type" content="product">
    <meta property="og:title" content="{{ Str::substr($product->name, 0, 65) }}">
    <meta property="og:description" content="{{ $product->meta_description ?? 'n/a' }}">
    <meta property="og:url" content="{{ route('single.product', $product->slug) }}">
    <meta property="og:image" content="{{ asset('storage/' . $product->productImage[0]['image']) }}">
    <meta property="product:brand" content="{{ request()->getHost() }}">
    <meta property="product:availability" content="in stock">
    <meta property="product:condition" content="new">
    <meta property="product:price:amount" content="{{ $product->sale_price }}">
    <meta property="product:price:currency" content="BDT">
    <meta property="product:id" content="{{ $product->product_code }}">
    <meta property="product:item_group_id" content="{{ $product->product_code }}">
    <meta property="product:retailer_item_id" content="{{ $product->product_code }}">
@endpush


@section('content')
    <!--============ Single Product Area Start ============-->
    <section class="single_product_area section_padding">
        <div class="container">
            <div class="row gy-sm-4 gx-sm-4 gy-4 gx-2">
                <div class="col-xxl-4 col-xl-4 col-lg-6 col-md-12 col-sm-12 col-12">
                    <div class="single_product_list d-lg-none d-block mb-lg-0 mb-2">
                        <ul>
                            <li>
                                <a href="{{ route('root') }}" class="single_product_list_link">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="13" height="14"
                                        viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                                        stroke-linecap="round" stroke-linejoin="round" class="feather feather-home">
                                        <path d="M3 9l9-7 9 7v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"></path>
                                        <polyline points="9 22 9 12 15 12 15 22"></polyline>
                                    </svg>
                                </a>
                            </li>
                            <li>
                                <a href="{{ route('product.category', [@$product->category->slug]) }}"
                                    class="single_product_list_link">
                                    {{ @$product->category->name }}
                                </a>
                            </li>
                            @if (isset($product->subCategory))
                                <li>
                                    <a href="{{ route('product.category', [@$product->category->slug, @$product->subCategory->slug]) }}"
                                        class="single_product_list_link">
                                        {{ @$product->subCategory->name }}
                                    </a>
                                </li>
                            @endif
                            @if (isset($product->subSubCategory))
                                <li>
                                    <a href="{{ route('product.category', [@$product->category->slug, @$product->subCategory->slug, @$product->subSubCategory->slug]) }}"
                                        class="single_product_list_link">
                                        {{ @$product->subSubCategory->name }}
                                    </a>
                                </li>
                            @endif
                        </ul>
                    </div>
                    <div class="zooming_image_content">
                        <div id="video-url" data-url="{{ $product->video_url }}"></div>
                        <div class="youtube_video" id="youtube_video">
                            @if (!empty($product->video_url))
                                <iframe id="videoFrame" scrolling="no" width="100%" height="100%"
                                    style='aspect-ratio:{{ $site_configurations->image_aspect_ratio }}'
                                    src="{{ $product->video_url }}?enablejsapi=1&autoplay=1&mute=1"
                                    title="YouTube video player" frameborder="0"
                                    allow="accelerometer; autoplay; encrypted-media; gyroscope;" allowfullscreen>
                                </iframe>
                            @endif
                        </div>

                        <div class="zoom_img_active owl-carousel">
                            @foreach ($product->productImage as $index => $image)
                                <a data-fancybox="gallery" href="{{ asset('storage/' . $image->image) }}"
                                    data-dot="
                                        @if ($hasVideo) <div class='video_icon_overlay_content' style='position: relative; display: inline-block;'>
                                            @if ($index == 0)
                                            <span class='video_icon_overlay' onClick='showVideo({{ $image->id }})'></span> @endif
                                        </div>
                                         @endif
                                        <img src='{{ asset('storage/' . $image->image) }}' 
                                            onClick='showImg({{ $image->id }})' style='aspect-ratio:{{ $site_configurations->image_aspect_ratio }}'>
                                    "
                                    style="display: none;" id="main_image_{{ $image->id }}" class="zooming_show_image">
                                    <div class="project-picture" id="{{ $image->id }}">
                                        <img src="{{ asset('storage/' . $image->image) }}" alt=""
                                            style="aspect-ratio:{{ $site_configurations->image_aspect_ratio }}">
                                    </div>
                                </a>
                            @endforeach
                        </div>
                    </div>
                </div>

                <div class="col-xxl-4 col-xl-4 col-lg-6 col-md-12 col-sm-12 col-12">
                    <div class="single_product_details">
                        <div class="single_product_list d-lg-block d-none">
                            <ul>
                                <li>
                                    <a href="{{ route('root') }}" class="single_product_list_link">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="13" height="14"
                                            viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                                            stroke-linecap="round" stroke-linejoin="round" class="feather feather-home">
                                            <path d="M3 9l9-7 9 7v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"></path>
                                            <polyline points="9 22 9 12 15 12 15 22"></polyline>
                                        </svg>
                                    </a>
                                </li>
                                <li>
                                    <a href="{{ route('product.category', [@$product->category->slug]) }}"
                                        class="single_product_list_link">
                                        {{ @$product->category->name }}
                                    </a>
                                </li>
                                @if (isset($product->subCategory))
                                    <li>
                                        <a href="{{ route('product.category', [@$product->category->slug, @$product->subCategory->slug]) }}"
                                            class="single_product_list_link">
                                            {{ @$product->subCategory->name }}
                                        </a>
                                    </li>
                                @endif
                                @if (isset($product->subSubCategory))
                                    <li>
                                        <a href="{{ route('product.category', [@$product->category->slug, @$product->subCategory->slug, @$product->subSubCategory->slug]) }}"
                                            class="single_product_list_link">
                                            {{ @$product->subSubCategory->name }}
                                        </a>
                                    </li>
                                @endif
                            </ul>
                        </div>
                        <div class="single_product_name">
                            <input type="hidden" id="product_id" value="{{ $product->id }}">
                            <input type="hidden" id="product_stock" value="{{ $product->stock }}">
                            <h2>{{ $product->name }}</h2>
                        </div>
                        <div class="single_product_whatsapp">
                            <a href="https://wa.me/+88{{ $general_settings->whatsapp_number }}" id="whatsappLink"
                                class="single_product_whatsapp_link">
                                <svg data-v-ba5acb34="" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 48 48"
                                    width="22px" height="22px" fill-rule="evenodd" clip-rule="evenodd"
                                    class="single_whats_app">
                                    <path data-v-ba5acb34="" fill="#fff"
                                        d="M4.9,43.3l2.7-9.8C5.9,30.6,5,27.3,5,24C5,13.5,13.5,5,24,5c5.1,0,9.8,2,13.4,5.6	C41,14.2,43,18.9,43,24c0,10.5-8.5,19-19,19c0,0,0,0,0,0h0c-3.2,0-6.3-0.8-9.1-2.3L4.9,43.3z">
                                    </path>
                                    <path data-v-ba5acb34="" fill="#fff"
                                        d="M4.9,43.8c-0.1,0-0.3-0.1-0.4-0.1c-0.1-0.1-0.2-0.3-0.1-0.5L7,33.5c-1.6-2.9-2.5-6.2-2.5-9.6	C4.5,13.2,13.3,4.5,24,4.5c5.2,0,10.1,2,13.8,5.7c3.7,3.7,5.7,8.6,5.7,13.8c0,10.7-8.7,19.5-19.5,19.5c-3.2,0-6.3-0.8-9.1-2.3	L5,43.8C5,43.8,4.9,43.8,4.9,43.8z">
                                    </path>
                                    <path data-v-ba5acb34="" fill="#cfd8dc"
                                        d="M24,5c5.1,0,9.8,2,13.4,5.6C41,14.2,43,18.9,43,24c0,10.5-8.5,19-19,19h0c-3.2,0-6.3-0.8-9.1-2.3	L4.9,43.3l2.7-9.8C5.9,30.6,5,27.3,5,24C5,13.5,13.5,5,24,5 M24,43L24,43L24,43 M24,43L24,43L24,43 M24,4L24,4C13,4,4,13,4,24	c0,3.4,0.8,6.7,2.5,9.6L3.9,43c-0.1,0.3,0,0.7,0.3,1c0.2,0.2,0.4,0.3,0.7,0.3c0.1,0,0.2,0,0.3,0l9.7-2.5c2.8,1.5,6,2.2,9.2,2.2	c11,0,20-9,20-20c0-5.3-2.1-10.4-5.8-14.1C34.4,6.1,29.4,4,24,4L24,4z">
                                    </path>
                                    <path data-v-ba5acb34="" fill="#40c351"
                                        d="M35.2,12.8c-3-3-6.9-4.6-11.2-4.6C15.3,8.2,8.2,15.3,8.2,24c0,3,0.8,5.9,2.4,8.4L11,33l-1.6,5.8	l6-1.6l0.6,0.3c2.4,1.4,5.2,2.2,8,2.2h0c8.7,0,15.8-7.1,15.8-15.8C39.8,19.8,38.2,15.8,35.2,12.8z">
                                    </path>
                                    <path data-v-ba5acb34="" fill="#fff" fill-rule="evenodd"
                                        d="M19.3,16c-0.4-0.8-0.7-0.8-1.1-0.8c-0.3,0-0.6,0-0.9,0	s-0.8,0.1-1.3,0.6c-0.4,0.5-1.7,1.6-1.7,4s1.7,4.6,1.9,4.9s3.3,5.3,8.1,7.2c4,1.6,4.8,1.3,5.7,1.2c0.9-0.1,2.8-1.1,3.2-2.3	c0.4-1.1,0.4-2.1,0.3-2.3c-0.1-0.2-0.4-0.3-0.9-0.6s-2.8-1.4-3.2-1.5c-0.4-0.2-0.8-0.2-1.1,0.2c-0.3,0.5-1.2,1.5-1.5,1.9	c-0.3,0.3-0.6,0.4-1,0.1c-0.5-0.2-2-0.7-3.8-2.4c-1.4-1.3-2.4-2.8-2.6-3.3c-0.3-0.5,0-0.7,0.2-1c0.2-0.2,0.5-0.6,0.7-0.8	c0.2-0.3,0.3-0.5,0.5-0.8c0.2-0.3,0.1-0.6,0-0.8C20.6,19.3,19.7,17,19.3,16z"
                                        clip-rule="evenodd"></path>
                                </svg>
                                Need help?
                            </a>
                        </div>
                        <div class="single_product_attribute s_p_code">
                            <strong>Code:</strong>
                            <span>{{ $product->product_code }}</span>
                        </div>
                        <div class="single_product_attribute s_p_price">
                            <strong>Price:</strong>
                            <div class="single_product_price">

                                <span class="single_product_new_price" id="variant_wise_price">{{ $product->sale_price }}
                                    TK</span>
                                @if ($product->price > $product->sale_price)
                                    <span class="single_product_discount_price sigle_discount_text">{{ $product->price }}
                                        TK</span>
                                @endif
                            </div>
                        </div>
                        @if ($product->stock > 0 || $site_configurations->show_stock_out != 1)
                            @if ($variand_count > 0)
                                @foreach ($attributes as $attribute_id => $attribute_name)
                                    @if ($product->productVariant->contains('attribute_id', $attribute_id))
                                        <div class="select_attribute_container s_p_select">
                                            <strong class="single_product_attribute_label">Select
                                                {{ $attribute_name }}</strong>
                                            <div class="single_product_attribute">
                                                <div class="single_product_size_checkbox_list"
                                                    id="product_variant_{{ strtolower($attribute_name) }}">
                                                    <ul>
                                                        @php
                                                            $sizeOrder = [
                                                                '26',
                                                                '27',
                                                                '28',
                                                                '29',
                                                                '30',
                                                                '31',
                                                                '32',
                                                                '33',
                                                                '34',
                                                                '35',
                                                                '36',
                                                                '37',
                                                                '38',
                                                                '39',
                                                                '40',
                                                                '41',
                                                                '42',
                                                                '43',
                                                                '44',
                                                                'XXS',
                                                                'XS',
                                                                'S',
                                                                'M',
                                                                'L',
                                                                'XL',
                                                                'XXL',
                                                                '2XL',
                                                                '3XL',
                                                                '4XL',
                                                                '5XL',
                                                            ];

                                                            $sortedVariants = $product->productVariant
                                                                ->where('attribute_id', $attribute_id)
                                                                ->sortBy(function ($variant) use ($sizeOrder) {
                                                                    return array_search(
                                                                        $variant->variant->name,
                                                                        $sizeOrder,
                                                                    ) !== false
                                                                        ? array_search(
                                                                            $variant->variant->name,
                                                                            $sizeOrder,
                                                                        )
                                                                        : 999;
                                                                });
                                                        @endphp
                                                        @foreach ($sortedVariants as $variant)
                                                            <li>
                                                                <div
                                                                    class="single_product_size_checkbox_list_group  variant">
                                                                    <input type="radio"
                                                                        name="variant{{ $attribute_name }}"
                                                                        value="{{ $variant->variant->name }}"
                                                                        onclick="getVariant(this.id, {{ $variant->price }}, {{ $product->sale_price }})"
                                                                        id="{{ $variant->variant->name . $variant->variant->id }}">
                                                                    <label
                                                                        for="{{ $variant->variant->name . $variant->variant->id }}">
                                                                        <div class="title">
                                                                            {{ $variant->variant->name }}
                                                                        </div>
                                                                    </label>
                                                                </div>
                                                            </li>
                                                        @endforeach
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                    @endif
                                @endforeach
                            @endif
                        @endif
                        @if ($product->stock <= 0 && $site_configurations->show_stock_out == 1)
                            <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-6 col-sm-6 col-6 mt-3">
                                <a href="#" disabled class="button_disable_add_to_cart">
                                    <i class="fa-solid fa-cart-shopping"></i>
                                    Out of stock
                                </a>
                            </div>
                        @else
                            <div class="single_product_qty_with_buy_now_btn">
                                <div class="row gx-md-3 gy-md-3 gx-2 gy-2">
                                    <div class="col-xxl-5 col-xl-6 col-lg-6 col-md-5 col-sm-5 col-6">
                                        <div class="single_product_attribute">
                                            <strong class="s_p_qty">Qty: </strong>
                                            <div class="single_product_qty">
                                                <div class="single_product_qty_btn_minus">
                                                    <button type="button" onclick="decrement()"
                                                        class="single_product_qty_minus">
                                                        <i class="fa-solid fa-minus"></i>
                                                    </button>
                                                </div>
                                                <input class="product_qty" type="text" value="1" min="1">
                                                <div class="single_product_qty_btn_minus">
                                                    <button type="button" onclick="Increment()"
                                                        class="single_product_qty_plus">
                                                        <i class="fa-solid fa-plus"></i>
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-4 col-sm-4 col-4 d-lg-block d-none">
                                        <button type="button" id="{{ $product->id }}"
                                            data-variant="{{ $variand_count }}" class="single_product_add_to_cart "
                                            onclick="addToCard(event, this.id, this.getAttribute('data-variant'))">
                                            <i class="fa-solid fa-cart-shopping"></i>
                                            {{ dynamic_lang('add_to_cart') }}
                                        </button>
                                    </div>
                                    <div class="col-xxl-3 col-xl-2 col-lg-2 col-md-7 col-sm-7 col-6">
                                        <button class="single_product_add_to_wishlist" id="{{ $product->id }}"
                                            data-variant="{{ $variand_count }}" onclick="addToWishList(this.id)">
                                            <span class="d-lg-none d-block">Add to Wishlist</span>
                                            <i class="fa-regular fa-heart"></i>
                                        </button>
                                    </div>
                                    <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                        <div class="single_product_buy_now_btn d-lg-block d-none">
                                            <form id="buyNowForm" action="{{ route('buy.now') }}" method="POST">
                                                @csrf
                                                <input type="hidden" name="product_id" id="form_product_id"
                                                    value="">
                                                <input type="hidden" name="quantity" id="form_quantity" value="">
                                                <!-- Dynamic variant inputs will be appended here -->
                                                <a href="#" id="{{ $product->id }}"
                                                    data-variant="{{ $variand_count }}"
                                                    onclick="submitBuyNowForm(this.id, this.getAttribute('data-variant'), event)"
                                                    class="single_product_buy_now_btn_link cart_check_out">
                                                    {{ dynamic_lang('order_now') }}
                                                    <i class="fa-solid fa-check"></i>
                                                </a>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endif
                    </div>
                </div>
                <div class="col-xxl-4 col-xl-4 col-lg-12 col-md-12 col-sm-12 col-12">
                    <div class="single_product_specification_content">
                        <div class="single_product_specification_list">
                            <ul>
                                <li>
                                    <i class="fa-solid fa-check"></i>
                                    {{ dynamic_lang('delivery_time') }}
                                </li>
                                <li>
                                    <i class="fa-solid fa-thumbs-up"></i>
                                    Quality Product
                                </li>
                                <li>
                                    <i class="fa-solid fa-handshake"></i>
                                    Cash On Delivery Available
                                </li>
                                @if (count($delivery_charges) > 0)
                                    @foreach ($delivery_charges as $delivery_charge)
                                        <li>
                                            <i class="fa-solid fa-truck-fast"></i>
                                            Delivery Charge {{ $delivery_charge->name }}
                                            {{ $delivery_charge->delivery_charge }} TK
                                        </li>
                                    @endforeach
                                @endif
                            </ul>
                        </div>
                        <div class="single_product_call_details">
                            <div class="single_product_call_title">
                                <p>Have question about this product ? please call</p>
                            </div>
                            <div class="single_product_call">
                                <ul>
                                    <li>
                                        <a href="tel:{{ $general_settings->header_contact_number }}"
                                            class="single_product_call_link">
                                            <div class="single_product_call_content">
                                                <i class="fa-solid fa-phone"></i>
                                                @if (!empty($general_settings->header_contact_number))
                                                    {{ $general_settings->header_contact_number }}
                                                @endif
                                            </div>
                                        </a>
                                    </li>
                                    <li>
                                        <a href="tel:{{ $general_settings->header_contact_number_two }}"
                                            class="single_product_call_link">
                                            <div class="single_product_call_content">
                                                <i class="fa-solid fa-phone"></i>
                                                @if (!empty($general_settings->header_contact_number_two))
                                                    {{ $general_settings->header_contact_number_two }}
                                                @endif
                                            </div>
                                            <div class="single_product_call_payment_method">
                                                <p>Bkash Personal</p>
                                            </div>
                                        </a>
                                    </li>
                                    <li>
                                        <a href="tel:{{ $general_settings->header_contact_number_three }}"
                                            class="single_product_call_link">
                                            <div class="single_product_call_content">
                                                <i class="fa-solid fa-phone"></i>
                                                {{ $general_settings->header_contact_number_three }}
                                            </div>
                                            <div class="single_product_call_payment_method">
                                                <p>Nagad Personal</p>
                                            </div>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--============ Single Product Area End ============-->


    <div class="fixed_footer_menu_single_product fixed_footer_menu">
        <ul>
            <li>
                <a href="http://127.0.0.1:8000" class="fixed_footer_menu_link">
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor"
                        stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-home">
                        <path d="M3 9l9-7 9 7v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"></path>
                        <polyline points="9 22 9 12 15 12 15 22"></polyline>
                    </svg>
                    <p class="home_text">Home</p>
                </a>
            </li>
            <li>
                <a href="/login" class="fixed_footer_menu_link">
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor"
                        stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-user">
                        <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path>
                        <circle cx="12" cy="7" r="4"></circle>
                    </svg>
                    <p>Login</p>
                </a>
            </li>
            <li>
                <button type="button" id="{{ $product->id }}" data-variant="{{ $variand_count }}"
                    class="single_product_add_to_cart"
                    onclick="addToCard(event, this.id, this.getAttribute('data-variant'))">
                    <i class="fa-solid fa-cart-shopping"></i>
                    {{ dynamic_lang('add_to_cart') }}
                </button>
            </li>
            <li>
                <form id="buyNowForm" action="{{ route('buy.now') }}" method="POST">
                    @csrf
                    <input type="hidden" name="product_id" id="form_product_id" value="">
                    <input type="hidden" name="quantity" id="form_quantity" value="">
                    <!-- Dynamic variant inputs will be appended here -->
                    <a href="#" id="{{ $product->id }}" data-variant="{{ $variand_count }}"
                        onclick="submitBuyNowForm(this.id, this.getAttribute('data-variant'), event)"
                        class="single_product_buy_now_btn_link cart_check_out">
                        {{ dynamic_lang('order_now') }}
                        <i class="fa-solid fa-check"></i>
                    </a>
                </form>
            </li>
        </ul>
    </div>

    <!--============ Single Product Tab Area Start ============-->
    <div class="single_product_tab_area section_padding_bottom">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <div class="single_product_tab">
                        <ul class="nav nav-tabs single_product_tab_nav" id="myTab" role="tablist">
                            <li class="nav-item single_product_tab_nav_item" role="presentation">
                                <button class="nav-link single_product_tab_nav_link active" id="home-tab"
                                    data-bs-toggle="tab" data-bs-target="#home" type="button" role="tab"
                                    aria-controls="home" aria-selected="true">
                                    Description
                                </button>
                            </li>
                            <li class="nav-item single_product_tab_nav_item" role="presentation">
                                <button class="nav-link single_product_tab_nav_link" id="profile-tab"
                                    data-bs-toggle="tab" data-bs-target="#profile" type="button" role="tab"
                                    aria-controls="profile" aria-selected="false">
                                    How To Order
                                </button>
                            </li>
                            <li class="nav-item single_product_tab_nav_item" role="presentation">
                                <button class="nav-link single_product_tab_nav_link" id="contact-tab"
                                    data-bs-toggle="tab" data-bs-target="#contact" type="button" role="tab"
                                    aria-controls="contact" aria-selected="false">
                                    Reviews
                                </button>
                            </li>
                        </ul>
                        <div class="tab-content" id="myTabContent">
                            <div class="tab-pane fade show active" id="home" role="tabpanel"
                                aria-labelledby="home-tab">
                                <div class="single_product_tab_content">
                                    {!! $product->details !!}
                                </div>
                            </div>
                            <div class="tab-pane fade" id="profile" role="tabpanel" aria-labelledby="profile-tab">
                                <div class="single_product_tab_content">
                                    <div class="single_product_tab_list">
                                        <ul>
                                            <li>
                                                Select number of product you want to buy.
                                            </li>
                                            <li>
                                                Click <strong>Add To Cart</strong> Button
                                            </li>
                                            <li>
                                                Then go to checkout page
                                            </li>
                                            <li>
                                                If you are a new customer, please click on Sign Up.provide us your valid
                                                information information.
                                            </li>
                                            <li>
                                                Complete your checkout, we received your order, and for order confirmation
                                                or customer service contact with you
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="contact" role="tabpanel" aria-labelledby="contact-tab">
                                <div class="single_product_tab_content">
                                    <div class="customer_comment_area section_padding_bottom">
                                        <div class="row">
                                            <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                                <div class="section_title text-center">
                                                    <h2>Reviews</h2>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="section_top_space">
                                            <div class="row gy-4 gx-4">

                                                <div class="col-xxl-3 col-xl-4 col-lg-12 col-md-12 col-sm-12 col-12">
                                                    <div class="customer_comment_title">
                                                        <span
                                                            class="customer_comment_avarage_rating">{{ $product->avg_review ?? 0 }}</span>
                                                        <span class="customer_comment_rating_name">
                                                            {{-- <i class="fa-solid fa-star"></i> --}}
                                                            Reviews
                                                        </span>
                                                    </div>
                                                    @php
                                                        $fullStars = floor($product->avg_review); // Full stars
                                                        $halfStar =
                                                            $product->avg_review - $fullStars >= 0.5 ? true : false; // Half star check
                                                    @endphp

                                                    <div class="customer_comment_rating">
                                                        @for ($i = 1; $i <= $fullStars; $i++)
                                                            <span>
                                                                <i class="fa-solid fa-star"></i>
                                                            </span>
                                                        @endfor

                                                        @if ($halfStar)
                                                            <span>
                                                                <i class="fa-solid fa-star-half-stroke"></i>
                                                            </span>
                                                        @endif

                                                        {{-- Fill remaining stars (if needed, e.g., for a 5-star rating system) --}}
                                                        {{-- @for ($i = $fullStars + ($halfStar ? 1 : 0); $i < 5; $i++)
                                                            <span>
                                                                <i class="fa-regular fa-star"></i>
                                                            </span>
                                                        @endfor --}}
                                                    </div>

                                                    <div class="customer_comment_rating_count">
                                                        <span>{{ number_format($total_product_review) }} reviews</span>
                                                    </div>
                                                </div>

                                                @php
                                                    $ratings = [
                                                        'five_star' => 5,
                                                        'four_star' => 4,
                                                        'three_star' => 3,
                                                        'two_star' => 2,
                                                        'one_star' => 1,
                                                    ];
                                                @endphp

                                                <div class="col-xxl-5 col-xl-5 col-lg-12 col-md-12 col-sm-12 col-12">
                                                    @foreach ($ratings as $ratingKey => $starCount)
                                                        <div class="customer_comment_item">
                                                            <div class="customer_comment_item_star">
                                                                @for ($i = 1; $i <= 5; $i++)
                                                                    <span>
                                                                        <i
                                                                            class="fa-{{ $i <= $starCount ? 'solid' : 'regular' }} fa-star"></i>
                                                                    </span>
                                                                @endfor
                                                            </div>
                                                            <div class="customer_comment_item_percentage_segment">
                                                                <span
                                                                    style="width: {{ number_format(($product->rating_stars[$ratingKey] / $total_review) * 100, 2) }}%;"></span>
                                                            </div>
                                                            <div class="customer_comment_item_percentage">
                                                                <span>{{ number_format(($product->rating_stars[$ratingKey] / $total_review) * 100, 2) }}%</span>
                                                            </div>
                                                        </div>
                                                    @endforeach
                                                </div>

                                                <div class="col-xxl-3 col-xl-3 col-lg-12 col-md-12 col-sm-12 col-12">
                                                    <div class="customer_comment_btn">
                                                        <button class="customer_comment_btn_link" data-bs-toggle="modal"
                                                            data-product_slug="{{ $product->slug }}"
                                                            data-bs-target="#staticBackdrop">
                                                            <i class="fa-regular fa-pen-to-square"></i>
                                                            Write a Review
                                                        </button>
                                                    </div>
                                                </div>

                                                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                                    <div class="customer_comment_review_content">
                                                        <div class="customer_comment_list">
                                                            <ul>
                                                                @foreach ($product_reviews as $review)
                                                                    <li>
                                                                        <div class="comment_customer_content">
                                                                            <div class="comment_customer_name">
                                                                                <h5>{{ $review->user_name }}</h5>
                                                                            </div>
                                                                            <div class="comment_customer_rating">
                                                                                @for ($i = 1; $i <= 5; $i++)
                                                                                    <span>
                                                                                        <i
                                                                                            class="fa-{{ $i <= $review->rating_stars ? 'solid' : 'regular' }} fa-star"></i>
                                                                                    </span>
                                                                                @endfor
                                                                            </div>
                                                                            <div class="customer_comment_details">
                                                                                <p>{{ $review->review }}</p>
                                                                            </div>
                                                                            @if ($review->image)
                                                                                <div class="customer_comment_image">
                                                                                    <img src="{{ asset('storage/' . $review->image) }}"
                                                                                        alt="{{ $review->image }}">
                                                                                </div>
                                                                            @endif
                                                                        </div>
                                                                    </li>
                                                                @endforeach
                                                            </ul>
                                                        </div>
                                                        <div class="comments_pagination">
                                                            {{ $product_reviews->links() }}
                                                        </div>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--============ Single Product Tab Area End ============-->

    <!--============ Related Products Area Start ============-->
    <section class="related_product_area section_padding_bottom">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <div class="section_title text-center">
                        <h2>Related Products</h2>
                    </div>
                </div>
            </div>
        </div>
        <div class="container section_top_space">
            <div class="row gy-lg-3 gx-lg-3 gy-2 gx-2">
                @foreach ($related_products as $product)
                    <div class="{{ $site_configurations->card_row }} col-xl-3 col-lg-4 col-md-4 col-sm-6 col-6">
                        @include("frontend.components.product_content.$template", ['product' => $product])
                    </div>
                @endforeach

            </div>
        </div>
    </section>
    <!--============ Related Products Area End ============-->


    <!--============ Comment Input Area Modal Start ============-->
    <div class="modal fade" id="staticBackdrop">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content modal_content">
                <div class="modal_deader">
                    <div class="modal_star">
                        <div class="modal_close" data-bs-dismiss="modal">
                            <i class="fa-solid fa-xmark"></i>
                        </div>
                        <div class="modal_star_title">
                            <h5>write your review</h5>
                        </div>

                    </div>
                </div>
                <div class="modal_body">
                    <div class="modal_comment_group">
                        <form id="review_form" enctype="multipart/form-data">
                            @csrf
                            <div class="modal_rating">
                                <input type="radio" id="star1" name="rating_stars" value="5">
                                <label for="star1"></label>
                                <input type="radio" id="star2" name="rating_stars" value="4">
                                <label for="star2"></label>
                                <input type="radio" id="star3" name="rating_stars" value="3">
                                <label for="star3"></label>
                                <input type="radio" id="star4" name="rating_stars" value="2">
                                <label for="star4"></label>
                                <input type="radio" id="star5" name="rating_stars" value="1">
                                <label for="star5"></label>
                            </div>
                            <div class="modal_comment_item">
                                <input type="text" name="user_name" placeholder="customer name">
                                @error('user_name')
                                    <span class="is_error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="modal_comment_item_textarea">
                                <textarea name="review" placeholder="write comment"></textarea>
                                @error('review')
                                    <span class="is_error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="modal_comment_item">
                                <input name="image" type="file" id="image">
                                @error('image')
                                    <span class="is_error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="modal_comment_item_btn">
                                <button id="review_submit" class="modal_comment_item_btn_link">Submit</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--============ Comment Input Area End ============-->

    {{-- Mobile view size --}}




@endsection
@section('scripts')
    <script src="https://www.youtube.com/iframe_api"></script>
    <script>
        function submitBuyNowForm(id, have_variant, event) {
            event.preventDefault();
            let variants = {};
            let missingVariant = '';

            $('input[name^="variant"]').each(function() {
                let variantName = $(this).attr('name').replace('variant',
                    '');
                if (!$(`input[name="${$(this).attr('name')}"]:checked`).val()) {

                    missingVariant = variantName;
                    return false;
                } else {

                    variants[variantName] = $(`input[name="${$(this).attr('name')}"]:checked`).val();
                }
            });

            if (missingVariant) {
                toastr.info(`Please Select ${missingVariant}`);
                return;
            }


            document.getElementById('form_product_id').value = id;
            let quantity = document.querySelector(".product_qty").value;
            document.getElementById('form_quantity').value = quantity;


            $('#buyNowForm').find('.variant-input').remove();

            for (const [variant, value] of Object.entries(variants)) {
                $('<input>')
                    .attr('type', 'hidden')
                    .attr('name', `variants[${variant}]`)
                    .attr('value', value)
                    .addClass('variant-input')
                    .appendTo('#buyNowForm');
            }

            toastr.success('Order is processing, please wait...');

            document.getElementById('buyNowForm').submit();
            missingVariant = {};
        }
    </script>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Code to execute when the DOM is fully loaded
            function handleWindowLoad() {
                console.log('Window loading has ended.');
                //call product showing events
                gtmEvent($('#product_id').val(), 'view_item', 1);
                window.removeEventListener('load', handleWindowLoad);
            }
            window.addEventListener('load', handleWindowLoad, {
                once: true
            });
        });

        function mobileSubmenu($id) {
            document.getElementById($id).classList.toggle("mobile_submenu_toggle");
        }

        function mobileSubSubmenu($id) {
            document.getElementById($id).classList.toggle("mobile_sub_submenu_toggle");
        }
    </script>
    <!-- header mobile menu js end -->

    <!-- header mobile search js start -->
    <script>
        function search() {
            document.getElementById("search_id").classList.toggle("search_toggle");
        }
    </script>
    <!-- header mobile search js end -->

    <!-- multiple category mobile menu js start -->
    <script>
        function categoryList() {
            document.getElementById("category_list_id").classList.toggle("category_list_toggle");
        }
    </script>
    <!-- multiple category mobile menu js end -->
    <script>
        document.getElementById('whatsappLink').addEventListener('click', function(event) {
            event.preventDefault(); // Prevent default action
            var whatsappNumber = '{{ $general_settings->whatsapp_number }}';
            var pageUrl = window.location.href; // Get current page URL
            // console.log(pageUrl);
            var message = encodeURIComponent(pageUrl);
            var whatsappUrl = `https://wa.me/+88${whatsappNumber}?text=${message}`;
            // Open the WhatsApp URL in a new tab
            window.open(whatsappUrl, '_blank');
        });
    </script>
    <!-- Zooming Image Start -->
    <script>
        var player; // Reference to the YouTube player

        // Load the YouTube API
        function onYouTubeIframeAPIReady() {
            player = new YT.Player('videoFrame', {
                events: {
                    'onReady': onPlayerReady,

                }
            });
        }

        // This will be called when the player is ready
        function onPlayerReady(event) {
            // You can optionally start playing the video automatically when the player is ready
            // event.target.playVideo();
        }
        // list image start
        let clickImageList = document.querySelector('.zooming_show_image img');

        function showImg(id) {

            const videoPlayer = document.getElementById("youtube_video");
            // const imagesContainer = document.getElementById(`main_image_${id}`);
            const imageContainers = document.querySelectorAll('.zooming_show_image');
            // Pause and hide video if it's playing
            //if (player && player.getPlayerState() === YT.PlayerState.PLAYING) {
            // player.pauseVideo();
            //}

            videoPlayer.style.display = "none";
            // imagesContainer.style.display = "block";
            if (imageContainers) {
                imageContainers.forEach(imageContainer => {
                    imageContainer.style.display = 'block';
                });
            }

        }


        function resumeVideo() {
            // Play the video when clicking on the video area again
            if (player) {
                player.playVideo();
            }
        }

        // Load the YouTube IFrame API asynchronously
        var tag = document.createElement('script');
        tag.src = "https://www.youtube.com/iframe_api";
        var firstScriptTag = document.getElementsByTagName('script')[0];
        firstScriptTag.parentNode.insertBefore(tag, firstScriptTag);

        // Attach click event to videoWrapper to resume the video
        document.getElementById('youtube_video').addEventListener('click', function() {
            resumeVideo();
        });
        // list image end
        function showVideo(id) {

            var videoPlayer = document.getElementById("youtube_video");
            const imageContainers = document.querySelectorAll('.zooming_show_image');

            // Hide images container and show video player
            if (imageContainers) {
                imageContainers.forEach(imageContainer => {
                    imageContainer.style.display = 'none';
                });
                videoPlayer.style.display = "block";
            }
        }

        document.addEventListener('DOMContentLoaded', function() {
            const videoUrlElement = document.getElementById('video-url');
            const videoPlayer = document.getElementById('youtube_video');
            const imageContainers = document.querySelectorAll('.zooming_show_image');
            const videoIframe = document.getElementById('video-iframe');

            // Get the video URL from the data attribute
            const videoUrl = videoUrlElement.getAttribute('data-url');

            if (videoUrl) {
                // Video URL is present, show video and hide images
                videoPlayer.style.display = 'block';
                imageContainers.forEach(imageContainer => {
                    imageContainer.style.display = 'none';
                });
                videoIframe.src = videoUrl;
            } else {

                videoPlayer.style.display = 'none';
                if (imageContainers.length > 0) {
                    imageContainers.forEach(img => {
                        img.style.display = 'block';
                    });
                }
            }
        });

        // zooming image start
        document.querySelectorAll('.zooming_show_image').forEach(elem => {
            let x, y, width, height;
            elem.onmouseenter = () => {
                const size = elem.getBoundingClientRect();

                x = size.x;
                y = size.y;

                width = size.width;
                height = size.height;
            };

            elem.onmousemove = e => {
                const horizontal = (e.clientX - x) / width * 100;
                const vertical = (e.clientY - y) / height * 100;

                elem.style.setProperty('--x', horizontal + '%');
                elem.style.setProperty('--y', vertical + '%');
            };
        });
        // zooming image end

        // active image start
        var zoomingImageList = document.querySelectorAll("ul li");

        zoomingImageList.forEach(i => {
            i.addEventListener("click", () => {
                resetLinks();
                i.classList.add("active");
            })
        })

        function resetLinks() {
            zoomingImageList.forEach(i => {
                i.classList.remove("active")
            })
        }
        // active image end
    </script>
    <!-- Zooming Image End -->
@endsection
