@php
    $color = DB::table('background_and_colors')->first();
@endphp
<style>
    /*
==========================================
    Google Fonts
==========================================
*/
    @import url(<?php echo $general_settings->font_url; ?>);


    :root {
        --primary_color: <?php echo $color->primary_color; ?>;
        --primary_text_color: <?php echo $color->primary_text_color; ?>;
        --primary_hover_color: <?php echo $color->primary_hover_color; ?>;

        --menu_background_color: <?php echo $color->menu_background_color; ?>;
        --menu_text_color: <?php echo $color->menu_text_color; ?>;
        --menu_hover_color: <?php echo $color->menu_hover_color; ?>;

        --add_to_card_background_color: <?php echo $color->add_to_card_background_color; ?>;
        --add_to_card_text_color: <?php echo $color->add_to_card_text_color; ?>;
        --add_to_card_border_color: <?php echo $color->add_to_card_border_color; ?>;
        --add_to_card_hover_color: <?php echo $color->add_to_card_hover_color; ?>;

        --single_page_add_to_card_bg_color: <?php echo $color->single_page_add_to_card_bg_color; ?>;
        --single_page_add_to_card_text_color: <?php echo $color->single_page_add_to_card_text_color; ?>;
        --single_page_add_to_card_border_color: <?php echo $color->single_page_add_to_card_border_color; ?>;
        --single_page_add_to_card_hover_bg_color: <?php echo $color->single_page_add_to_card_hover_bg_color; ?>;
        --single_page_add_to_card_hover_text_color: <?php echo $color->single_page_add_to_card_hover_text_color; ?>;
        --single_page_add_to_card_hover_border_color: <?php echo $color->single_page_add_to_card_hover_border_color; ?>;

        --discount_price_color: <?php echo $color->discount_price_color; ?>;

        --footer_background_color: <?php echo $color->footer_background_color; ?>;
        --footer_text_color: <?php echo $color->footer_text_color; ?>;
        --footer_hover_color: <?php echo $color->footer_hover_color; ?>;

        --border: <?php echo $color->default_border_color; ?>;
        --shadow: <?php echo $color->default_box_color; ?>;
        --white: #ffffff;
        --black: #323232;
    }


    * {
        margin: 0;
        padding: 0;
    }

    html,
    body {
        width: 100%;
        height: 100%;
        margin: 0;
        padding: 0;
        font-family: <?php echo $general_settings->font_family; ?>;
        font-weight: normal;
        font-style: normal;
        font-size: 16px;
        line-height: 26px;
        color: var(--black);
    }

    p {
        color: var(--black);
    }

    img {
        max-width: 100%;
    }

    a,
    .button {
        -webkit-transition: all 0.3s ease-out 0s;
        -o-transition: all 0.3s ease-out 0s;
        transition: all 0.3s ease-out 0s;
    }

    a:focus,
    .button:focus {
        text-decoration: none;
        outline: none;
    }

    select:focus {
        outline: none;
    }

    button:focus,
    input:focus,
    input:focus,
    textarea,
    textarea:focus {
        outline: 0;
    }

    ul {
        margin: 0px;
        padding: 0px;
    }

    li {
        /* list-style: none; */
    }

    a {
        text-decoration: none;
    }

    h1,
    h2,
    h3,
    h4,
    h5,
    h6,
    p {
        margin: 0px;
    }

    h1,
    h2,
    h3,
    h4,
    h5,
    h6 {
        color: var(--black);
    }

    hr {
        -webkit-box-sizing: content-box;
        box-sizing: content-box;
        height: 0;
        margin: 0.5rem 0 !important;
    }

    *::-moz-placeholder {
        color: #999;
        opacity: 1;
        font-size: 16px;
    }

    *::-webkit-input-placeholder {
        color: #999;
        opacity: 1;
        font-size: 16px;
    }

    *:-ms-input-placeholder {
        color: #999;
        opacity: 1;
        font-size: 16px;
    }

    *::-ms-input-placeholder {
        color: #999;
        opacity: 1;
        font-size: 16px;
    }

    *::placeholder {
        color: #999;
        opacity: 1;
        font-size: 16px;
    }

    *::-moz-selection {
        background: #000000;
        color: #fff;
        text-shadow: none;
    }

    ::-moz-selection {
        background: #000000;
        color: #fff;
        text-shadow: none;
    }

    ::selection {
        background: #000000;
        color: #fff;
        text-shadow: none;
    }

    .padding_left_zero {
        padding-left: 0px !important;
    }

    .padding_right_zero {
        padding-right: 0px !important;
    }

    .section_padding {
        padding: 45px 0px;
    }

    .section_padding_top {
        padding-top: 45px;
    }

    .section_padding_bottom {
        padding-bottom: 45px;
    }

    .section_top_space {
        padding-top: 15px;
    }

    .border_section {
        border: 1px solid var(--border);
        padding: 10px 5px 5px 5px;
        border-radius: 3px;
    }

    .common_table_cell {
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
        -webkit-box-pack: justify;
        -ms-flex-pack: justify;
        justify-content: space-between;
    }

    .toaster-center {
        top: 30%;
        left: 50%;
        transform: translate(-50%, -50%);
        position: fixed;
        z-index: 9999;
        /* toasster end  */
    }

    /*
==============================================================
    Common Button Css
==============================================================
*/

    /*
==============================================================
    Section Heading Css
==============================================================
*/
    .section_title_table_cell {
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
        -webkit-box-pack: justify;
        -ms-flex-pack: justify;
        justify-content: space-between;
        padding-bottom: 10px;
        margin-bottom: 10px;
        border-bottom: 1px solid var(--border);
        position: relative;
    }

    .section_title h2 {
        font-size: 20px;
        display: block;
        text-transform: capitalize;
        color: var(--black);
        font-weight: 700;
        margin-bottom: 0;
    }

    .product_heading_table_cell {
        display: flex;
        align-items: center;
        justify-content: space-between;
    }

    .sub_categoty {}

    .sub_categoty ul {
        margin: 0;
        padding: 0;
    }

    .sub_categoty ul li {
        list-style: none;
        display: inline;
        margin-right: 1px;
    }

    .sub_categoty ul li:last-child {
        margin-right: 0px;
    }

    .sub_categoty ul li .sub_category_link {
        color: var(--black);
        transition: .3s;
        background-color: #E5E7EB;
        padding: 0px 10px;
        display: inline-block;
        border-radius: 20px;
        font-size: 13px;
    }

    .sub_categoty ul li .sub_category_link:hover {
        color: var(--primary_hover_color);
    }

    .see_all_btn {}

    .see_all_btn_link {
        background-color: var(--primary_color);
        color: var(--primary_text_color);
        font-size: 13px;
        display: inline-block;
        padding: 0px 10px;
        border-radius: 25px;
        transition: .3s;
    }

    .see_all_btn_link:hover {
        color: var(--primary_hover_color)
    }

    /*
==============================================================
    Header Area Css
==============================================================
*/
    /* header top css */
    .header_top {
        border-bottom: 1px solid var(--border);
        padding: 3px 0px;
    }

    .header_top_site_title {
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
        height: 100%;
    }

    .header_top_list {
        text-align: right;
    }

    .header_top_list ul {
        margin: 0;
        padding: 0;
    }

    .header_top_list ul li {
        list-style: none;
        display: inline-block;
        margin-left: 20px;
    }

    .header_top_list ul li:first-child {
        margin-left: 0px;
    }

    .header_top_list ul li:last-child {
        display: inline-block;
    }

    .header_top_list ul li .header_top_list_link {
        display: block;
        font-size: 14px;
        color: var(--black);
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .header_top_list ul li .header_top_list_link:hover {
        color: var(--primary_color) !important;
    }

    .header_top_list ul li .header_top_list_link i {
        padding-right: 2px;
        color: var(--primary_color);
    }

    .header_top_list ul li .header_top_list_link svg {
        padding-right: 2px;
        color: var(--primary_color);
        width: 18px;
        margin-top: -3px;
    }

    .header_top_list ul li .header_top_list_link.header_top_list_auth {
        background-color: var(--primary_color);
        color: var(--primary_text_color);
        padding: 2px 20px;
        border-radius: 3px;
    }

    .header_top_list ul li .header_top_list_link.header_top_list_auth:hover {
        color: var(--primary_hover_color) !important;
    }

    /* header middle css */


    .sticky_header.fixed {
        position: fixed;
        left: 0;
        right: 0;
        top: 0;
        /* height: 80px; */
        z-index: 999;
        -webkit-animation-name: fixedHeader;
        animation-name: fixedHeader;
        -webkit-animation-duration: .4s;
        animation-duration: .4s;
        background-color: var(--white);
        -webkit-box-shadow: var(--shadow);
        box-shadow: var(--shadow);
    }

    @-webkit-keyframes fixedHeader {
        0% {
            opacity: 0;
            -webkit-transform: translateY(-60px);
            transform: translateY(-60px);
        }

        100% {
            opacity: 1;
            -webkit-transform: translateY(0);
            transform: translateY(0);
        }
    }

    @keyframes fixedHeader {
        0% {
            opacity: 0;
            -webkit-transform: translateY(-60px);
            transform: translateY(-60px);
        }

        100% {
            opacity: 1;
            -webkit-transform: translateY(0);
            transform: translateY(0);
        }
    }

    .header_middle.sticky_header.fixed {
        /* padding: 10px 0px; */
    }

    .header_middle {
        padding: 10px 0px;
        box-shadow: var(--shadow);
        margin-bottom: 5px;
    }

    .header_middle_logo {
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
        height: 100%;
    }

    .header_middle_logo img {
        max-width: 100%;
        max-height: 50px;
    }

    .header_middle_search {
        position: relative;
    }

    .header_middle_search input {
        width: 100%;
        font-size: 16px;
        height: 50px;
        padding-left: 20px;
        padding-right: 60px;
        border: none;
        background-color: #f3f4f7;
        border-radius: 50px;
    }

    .header_middle_search_link svg {
        width: 18px;
        color: var(--black);
    }

    .header_middle_search_link {
        border: none;
        background-color: transparent;
        color: var(--primary_color);
        font-size: 20px;
        position: absolute;
        top: -8px;
        right: 0;
        bottom: 0;
        padding: 0px 20px;
    }

    .header_middle_table_cell {
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
        -webkit-box-pack: end;
        -ms-flex-pack: end;
        justify-content: end;
        height: 100%;
    }

    .header_middle_call_link {
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
    }

    .header_middle_call_icon i {
        color: var(--primary_color);
        font-size: 26px;
        -webkit-transform: rotate(36deg);
        -ms-transform: rotate(36deg);
        transform: rotate(36deg);
        margin-right: 5px;
    }

    .header_middle_call_icon svg {
        width: 22px;
        color: var(--primary_color);
        transform: rotate(45deg);
        margin-top: -1px;
    }

    .header_cart_amount {
        width: 100%;
        flex-shrink: 0;
        max-width: 125px;
        margin-right: 12px;
    }

    .header_cart_icon {
        cursor: pointer;
        position: relative;
    }

    .header_middle_cart_text.total_amount {
        margin-left: 12px;
        cursor: pointer;
    }

    .header_middle_auth_text {
        margin-left: 7px;
    }

    .header_middle_auth_text p {
        font-size: 16px;
        line-height: 14px;
        white-space: nowrap;
        font-weight: 400;
        letter-spacing: 1px;
    }

    .header_middle_tracking {
        margin-right: 30px;
    }

    .header_middle_tracking_icon svg {
        width: 43px;
        color: var(--primary_color);
        margin-top: 1px;
    }

    .header_cart_icon svg {
        width: 26px;
        color: var(--primary_color);
        margin-top: -4px;
    }

    .header_wishlist_icon {
        cursor: pointer;
        width: 45px;
        height: 45px;
        line-height: 45px;
        border-radius: 100%;
        border: 1px solid #ea2b0f;
        text-align: center;
        position: relative;
    }

    .header_wishlist_icon svg {
        width: 22px;
        color: #ea2b0f;
        margin-top: -4px;
    }

    .header_wishlist_icon .wish_list_count {
        line-height: 16px;
        display: inline-block;
        font-size: 12px;
        font-weight: 300;
        width: 16px;
        height: 16px;
        text-align: center;
        border-radius: 100%;
        background-color: #ea2b0f;
        color: var(--white);
        position: absolute;
        top: 5px;
        right: -5px;
    }

    .header_middle_call_link {
        overflow: hidden;
        width: 100%;
        display: flex;
        align-items: center;
    }

    .header_middle_call_icon {
        cursor: pointer;
        line-height: 45px;
    }

    .header_middle_call svg {
        width: 23px;
        color: var(--primary_color);
        margin-top: -4px;
    }

    .header_middle_call {
        margin-right: 28px;
    }

    .header_middle_call_text p {
        font-size: 14px;
        line-height: 14px;
    }

    .header_middle_call_text span {
        line-height: 13px;
        display: inline-block;
        color: var(--black);
        font-size: 15px;
        font-weight: 500;
        transition: .3s;
    }

    .header_middle_cart_text p {
        letter-spacing: 1px;
    }

    .header_middle_call_text span:hover {
        color: var(--primary_color);
    }

    .header_middle_wishlist {
        padding-right: 25px;
        height: 40px;
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
    }

    .header_middle_wishlist_icon {
        position: relative;
    }

    .header_middle_wishlist_icon i {
        font-size: 28px;
        color: var(--primary_color);
    }

    .header_middle_wishlist_icon span {
        position: absolute;
        bottom: 0;
        right: 0;
        color: var(--black);
        margin-bottom: -5px;
        margin-right: -6px;
        font-size: 14px;
    }

    .header_middle_cart {
        position: relative;
        margin-right: 25px;
        display: flex;
        align-items: center;
    }

    .header_middle_cart p {
        font-size: 16px;
        line-height: 14px;
        white-space: nowrap;
        font-weight: 400;
        letter-spacing: 1px;
    }

    .header_middle_cart .cart_item_total {
        line-height: 16px;
        display: inline-block;
        font-size: 12px;
        font-weight: 300;
        width: 16px;
        height: 16px;
        text-align: center;
        border-radius: 100%;
        background-color: var(--primary_color);
        color: var(--primary_text_color);
        position: absolute;
        top: -2px;
        right: -8px;
    }

    .header_middle_auth_link {
        overflow: hidden;
        width: 100%;
        display: flex;
        align-items: center;
    }

    .header_middle_icon {
        line-height: 45px;
    }

    .header_middle_icon svg {
        width: 29px;
        color: var(--primary_color);
        margin-top: -4px;
        margin-right: -5px;
    }

    .header_middle_text {
        display: block;
        overflow: hidden;
    }

    .header_middle_text span {
        display: block;
        line-height: 17px;
        color: var(--black);
        font-size: 14px;
    }

    .header_mobile_icon_link span {
        position: absolute;
        top: 0;
        left: 0;
        width: 16px;
        height: 16px;
        background-color: var(--black);
        text-align: center;
        line-height: 18px;
        font-size: 11px;
        color: var(--white);
        border-radius: 50%;
        margin-top: -9px;
        margin-left: 14px;
        display: block;
    }

    .header_mobile_cart {
        display: inline-block;
        position: relative;
        width: 22px;
        height: 22px;
        padding: 3px;
        border: 1px solid var(--primary_color);
        border-bottom-right-radius: 3px;
        border-bottom-left-radius: 3px;
        color: var(--black);
        font-size: 14px;
        line-height: 14px;
        text-align: center;
        -webkit-transition: all 0.2s;
        -o-transition: all 0.2s;
        transition: all 0.2s;
    }

    .header_mobile_cart_count {
        color: var(--black);
    }

    .header_mobile_cart_count::after {
        position: absolute;
        bottom: 90%;
        left: 50%;
        width: 10px;
        height: 6px;
        margin-bottom: 1px;
        margin-left: -6px;
        border: 1px solid #dc9814;
        color: var(--black);
        border-bottom: 0;
        border-top-left-radius: 99px;
        border-top-right-radius: 99px;
        content: "";
        -webkit-transition: all 0.2s;
        -o-transition: all 0.2s;
        transition: all 0.2s;
        pointer-events: none;
    }

    /* header search result item css */
    .header_search_item_content {
        position: relative;
    }

    .header_search_item {
        -webkit-box-shadow: var(--shadow);
        box-shadow: var(--shadow);
        background-color: var(--white);
        max-height: 400px;
        overflow: auto;
        position: absolute;
        top: 100%;
        left: 0;
        width: 100%;
        z-index: 999999999;
    }

    .header_search_item::-webkit-scrollbar-thumb {
        background: var(--primary_color);
        border-radius: 20px;
    }

    .header_search_item::-webkit-scrollbar {
        width: 5px;
    }

    .header_search_item ul {
        margin: 0;
        padding: 0;
    }

    .header_search_item ul li {
        list-style: none;
        display: block;
        width: 100%;
        overflow: hidden;
        border-bottom: 1px solid var(--border);
        padding: 5px 0px 5px 5px;
    }

    .header_search_item ul li:last-child {
        border-bottom: 0px;
    }

    .header_search_item_product_image {
        float: left;
        margin-right: 10px;
    }

    .header_search_item_product_image img {
        width: 50px;
    }

    .header_search_item_product_name p {
        color: var(--black);
        transition: .3s;
    }

    .header_search_item ul li:hover .header_search_item_content .header_search_item_product_name p {
        color: var(--primary_color) !important;
    }

    .header_search_item_product_new_price {
        color: var(--black);
    }

    .header_search_item_product_discount_price {
        color: #94a3b8;
        text-decoration: line-through;
        padding-left: 8px;
    }

    /* header bottom css */
    .header_bottom {
        background-color: var(--menu_background_color);
    }

    .main_menu {
        text-align: center;
    }

    .main_menu ul {
        margin: 0;
        padding: 0;
    }

    .main_menu ul li {
        list-style: none;
        display: inline-block;
        line-height: 50px;
        margin-left: 25px;
    }

    .main_menu ul li:first-child {
        margin-left: 0px;
    }

    .main_menu ul li a {
        text-decoration: none;
        font-size: 16px;
        font-weight: 500;
        color: var(--menu_text_color);
        position: relative;
        text-transform: capitalize;
        transition: color 0.3s ease;
    }

    .main_menu ul li:hover>a {
        color: var(--menu_hover_color);
    }

    .main_menu ul li .sub_menu {
        position: absolute;
        width: 270px;
        z-index: 500;
        background-color: #f9f9f9;
        box-shadow: -2px 2px 70px -25px rgba(0, 0, 0, 0.3);
        padding: 10px 0px;
        text-align: left;
        opacity: 0;
        visibility: hidden;
        transition: all 0.5s ease;
    }

    .main_menu ul li:hover>.sub_menu {
        margin-top: 0;
        visibility: visible;
        opacity: 1;
    }

    .main_menu ul li .sub_menu li {
        margin: 0px;
        display: flex;
        width: 100%;
        line-height: 25px;
        padding: 5px 20px;
    }

    .main_menu ul li .menu_icon i {
        font-size: 13px;
    }

    .main_menu ul li .sub_menu li a {
        font-size: 14px;
        font-weight: 400;
        display: block;
        width: 100%;
    }

    .main_menu ul li .sub_menu li a i {
        float: right;
        line-height: 25px;
    }

    .main_menu ul li .sub_menu li .sub_menu {
        left: 100%;
    }

    .main_menu ul li .sub_menu li:hover .sub_menu {
        margin-top: 0;
        visibility: visible;
        opacity: 1;
    }

    .main_menu ul li .sub_menu.mega_menu li ul li {
        line-height: 1;
        display: block;
        padding: 0;
    }

    .main_menu ul li .sub_menu.mega_menu li ul li a {
        padding: 10px 0;
        display: inline-block;
        font-size: 14px;
        font-weight: 400;
        transition: color 0.3s ease;
    }

    .main_menu ul li .sub_menu.mega_menu li ul li:hover>a {
        color: var(--menu_hover_color);
    }

    .main_menu ul li .sub_menu.mega_menu {
        text-align: left;
        left: 50%;
        transform: translateX(-50%);
        max-width: 1100px;
        width: 100%;
        display: flex;
        flex-wrap: wrap;
        padding: 5px 8px 8px 8px;
    }

    .main_menu ul li .sub_menu.mega_menu li {
        flex: 0 0 25%;
        padding: 0 15px;
    }

    .main_menu ul li .sub_menu.mega_menu li .title {
        font-size: 16px;
        color: var(--primary_color);
        font-weight: 500;
        line-height: 1;
        margin-bottom: 0;
        padding-top: 15px;
    }

    .mobile_menu_head,
    .mobile_menu_trigger {
        display: none;
    }


    .single_product_tab_content img {
        max-width: 100%;
        height: auto;
        display: block;
    }


    @media (min-width: 991.99px) {
        .main_menu ul li {
            position: relative;
        }

        .main_menu ul li .sub_menu {
            top: 100%;
            left: 0;
        }

        .main_menu ul li .sub_menu li .sub_menu {
            top: 0;
        }
    }

    /*responsive*/
    @media(max-width: 991.98px) {
        .mobile_menu_trigger {
            display: block;
        }

        .main_menu {
            text-align: left;
            position: fixed;
            width: 320px;
            background-color: #ffffff;
            left: 0;
            top: 0;
            height: 100%;
            overflow: hidden;
            transform: translate(-100%);
            transition: all 0.5s ease;
            z-index: 1099;
        }

        .main_menu.active {
            transform: translate(0%);
        }

        .main_menu ul li {
            line-height: 1;
            margin: 0;
            display: flex;
            align-items: center;
            justify-content: space-between;
            border-bottom: 1px solid var(--border);
        }

        .main_menu ul li a {
            line-height: 50px;
            height: 50px;
            padding: 0 0px 0 17px;
            display: block;
            color: var(--black);
        }

        .main_menu ul li .menu_icon {
            width: 45px;
            height: 40px;
            line-height: 40px;
            flex-shrink: 0;
            text-align: center;
        }

        .main_menu ul li .menu_icon i {
            font-size: 16px;
        }

        .main_menu .mobile_menu_head {
            display: flex;
            height: 50px;
            border-bottom: 1px solid rgba(0, 0, 0, 0.1);
            justify-content: space-between;
            align-items: center;
            position: relative;
            z-index: 501;
            position: sticky;
            background-color: #ffffff;
            top: 0;
        }

        .main_menu .mobile_menu_head .go_back {
            height: 50px;
            width: 50px;
            border-right: 1px solid rgba(0, 0, 0, 0.1);
            cursor: pointer;
            line-height: 50px;
            text-align: center;
            color: #000000;
            display: none;
        }

        .main_menu .mobile_menu_head .go_back svg {
            width: 30px;
        }

        .main_menu .mobile_menu_head.active .go_back {
            display: block;
        }

        .main_menu .mobile_menu_head .current_menu_title {
            font-size: 15px;
            font-weight: 600;
            color: var(--primary_color);
            letter-spacing: 1px;
        }

        .main_menu .mobile_menu_head .mobile_menu_close {
            height: 50px;
            width: 50px;
            border-left: 1px solid rgba(0, 0, 0, 0.1);
            cursor: pointer;
            line-height: 50px;
            text-align: center;
        }

        .main_menu .mobile_menu_head .mobile_menu_close svg {
            width: 25px;
            color: var(--black);
        }

        .main_menu ul li .sub_menu {
            visibility: visible;
            opacity: 1;
            position: absolute;
            box-shadow: none;
            margin: 0;
            padding: 15px;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            padding-top: 50px;
            padding-left: 0;
            padding-right: 0;
            max-width: none;
            min-width: auto;
            display: none;
            transform: translateX(0%);
            overflow-y: auto;
        }

        .main_menu ul li .sub_menu.mega_menu {
            visibility: visible;
            opacity: 1;
            position: absolute;
            box-shadow: none;
            margin: 0;
            padding: 15px;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            padding-top: 65px;
            max-width: none;
            min-width: auto;
            display: none;
            transform: translateX(0%);
            overflow-y: auto;
        }

        .main_menu>ul>li .sub_menu.active {
            display: block;
        }

        @keyframes slideLeft {
            0% {
                opacity: 0;
                transform: translateX(100%);
            }

            100% {
                opacity: 1;
                transform: translateX(0%);
            }
        }

        @keyframes slideRight {
            0% {
                opacity: 1;
                transform: translateX(0%);
            }

            100% {
                opacity: 0;
                transform: translateX(100%);
            }
        }

        .main_menu ul li .sub_menu li {
            line-height: inherit;
            padding: 0;
        }

        .main_menu ul li .sub_menu li a {
            line-height: 45px;
            height: 45px;
            font-size: 15px;
        }

        .main_menu ul li .sub_menu li .sub_menu {
            left: 0;
        }

        .main_menu ul li .sub_menu.mega_menu li {
            flex: 0 0 100%;
            padding: 0px;
        }

        .main_menu ul li .sub_menu.mega_menu li .title {
            margin-bottom: 5px;
            padding-top: 0;
        }

        .main_menu ul li .sub_menu.mega_menu li ul li a {
            height: 100%;
            line-height: 30px;
            border: none;
            padding: 1px 0px;
        }

        .main_menu ul li .sub_menu.mega_menu li ul {
            margin-bottom: 15px;
        }

        .menu_overlay {
            position: fixed;
            background-color: rgba(0, 0, 0, 0.5);
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            z-index: 1098;
            visibility: hidden;
            opacity: 0;
            transition: all 0.5s ease;
        }

        .menu_overlay.active {
            visibility: visible;
            opacity: 1;
        }
    }

    /*
==============================================================
    Delivery Feature Area Css
==============================================================
*/
    .delivery_feature {
        padding: 15px 20px;
        border-radius: 3px;
        border: 1px solid var(--border);
    }

    .delivery_feature_icon {
        width: 40px;
        float: left;
        margin-right: 20px;
        display: block;
        overflow: hidden;
    }

    .delivery_feature_icon svg {
        width: 40px;
        color: var(--primary_color);
    }

    .delivery_feature_icon.fast_delivery {
        width: 50px;
    }

    .delivery_feature_icon.best_support svg {
        width: 38px;
    }

    .delivery_feature_icon.cashon_delevery svg {
        width: 38px;
    }

    .delivery_feature_icon.fast_delivery svg {
        width: 55px;
        margin-top: -7px;
    }

    .delivery_feature_content {
        display: block;
        overflow: hidden;
    }

    .delivery_feature_content span {
        text-transform: capitalize;
        font-weight: 600;
        margin-bottom: 0;
        font-size: 15px;
        color: var(--black);
        line-height: 1;
        display: block;
        margin-bottom: 10px;
        letter-spacing: 1px;
    }

    .delivery_feature_content p {
        color: gray;
        font-size: 14px;
        letter-spacing: 1px;
        line-height: 1;
    }

    /*
==============================================================
    Aside Area Css
==============================================================
*/
    .aside_menu_slider_banner_content {
        /* display: flex; */
        /* overflow: hidden; */
    }

    .aside_menu {
        position: relative;
        background-color: #ffffff;
        height: 100%;
        width: 100%;
        flex-shrink: 0;
        box-shadow: var(--shadow);
    }

    .aside_menu ul {
        margin: 0;
        padding: 0;
        /* overflow-y: scroll; */
        /* max-height: 300px; */
    }

    .aside_menu ul::-webkit-scrollbar {
        width: 3px;
    }

    .aside_menu ul::-webkit-scrollbar-thumb:hover {
        background: #555;
    }

    .aside_menu ul li {
        list-style: none;
        border-bottom: 1px solid #dddddd;
        padding: 6px 10px;
        display: block;
        width: 100%;
    }

    .aside_menu ul li:first-child {
        border-top: 0px;
    }

    .aside_menu ul li:last-child {
        border-bottom: 0px;
    }

    .aside_menu ul li .aside_menu_link {
        display: block;
        text-decoration: none;
        display: flex;
        align-items: center;
        justify-content: space-between;
        color: #000000;
        font-weight: 400;
        font-size: 14px;
        text-transform: capitalize;
    }

    .aside_menu ul li .aside_menu_link i {
        font-size: 13px;
    }

    .aside_menu ul li:hover>.aside_menu_link {
        color: red;
    }

    .aside_menu ul li .aside_submenu {
        width: 210px;
        position: absolute;
        left: 100%;
        top: 0px;
        background: #FFF;
        box-shadow: rgba(0, 0, 0, 0.05) 0px 0px 0px 1px;
        display: none;
        height: 100%;
        z-index: 999;
    }

    .aside_menu ul li:hover>.aside_submenu {
        display: block;
    }

    /*
==============================================================
    Banner Area Css
==============================================================
*/
    .slider_banner_content {
        overflow: hidden;
    }

    .slider_banner_item img {
        width: 100% !important;
        color: transparent;
        /* aspect-ratio: 2.97598 / 1; */
        /* object-fit: cover; */
        max-height: 600px;
    }

    .slider_banner_active .owl-nav div {
        background-color: var(--primary_color);
        border: 1px solid var(--primary_color);
        color: var(--white);
        width: 45px;
        height: 45px;
        line-height: 45px;
        text-align: center;
        font-size: 20px;
        position: absolute;
        top: 50%;
        margin-top: -23px;
        font-weight: 400;
        margin-left: 0px;
        -webkit-transition: 0.5s;
        -o-transition: 0.5s;
        transition: 0.5s;
    }

    .slider_banner_active .owl-nav div:hover {
        color: var(--white);
    }

    .slider_banner_active .owl-nav .owl-next {
        right: 0;
        margin-right: 0px;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    /*
==============================================================
    Category Area Css
==============================================================
*/
    .category_container {
        display: grid;
        grid-template-columns: repeat(9, minmax(0, 1fr));
        gap: 10px;
        row-gap: 11px;
    }

    .category_item {
        border-radius: 3px;
        background-color: var(--white);
        box-shadow: var(--shadow);
    }

    .category_image img {
        border-radius: 3px 3px 0px 0px;
    }

    .category_name {
        text-align: center;
        padding: 4px 5px;
    }

    .category_name p {
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
        font-size: 13px;
        color: var(--black);
        text-overflow: ellipsis;
        text-transform: capitalize;
        font-weight: 600;
        overflow: hidden;
        width: 100%;
        display: -webkit-box;
        -webkit-line-clamp: 1;
        -webkit-box-orient: vertical;
    }

    /*
==============================================================
    Advertisement Area Css
==============================================================
*/
    .advertisement_image img {
        width: 100%;
        border-radius: 3px;
    }



    /*
==============================================================
    Product Cart Area Css
==============================================================
*/
    .product_card {
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
        border-radius: 3px;
        box-shadow: rgba(0, 0, 0, 0.05) 0px 0px 0px 1px;
        background-color: var(--white);
        margin-bottom: 1px;
        /* height: 100%; */
    }

    .product_image {
        position: relative;
        /* aspect-ratio: 1/1; */
    }

    .product_image img {
        width: 100%;
        height: 100%;
        border-radius: 3px 3px 0px 0px;
    }

    .product_discount {
        position: absolute;
        top: 5px;
        left: 0;
        background-color: var(--primary_color);
        color: var(--primary_text_color);
        padding: 0px 5px 0px 5px;
        font-size: 12px;
        line-height: 20px;
        text-align: center;
        border-radius: 0px 3px 3px 0px;
    }

    .fee_delivery {
        position: absolute;
        top: 5px;
        right: 0;
        background-color: #1da46e;
        color: var(--white);
        padding: 0px 5px;
        font-size: 12px;
        text-transform: uppercase;
        height: 20px;
        display: inline-flex;
        align-items: center;
        border-radius: 3px 0px 0px 3px;
    }

    .product_content {
        padding: 0px 6px 5px 5px;
    }

    .button_disable_add_to_cart {
        background-color: transparent;
        padding: 6px 0px;
        border-radius: 3px;
        display: block;
        width: 100%;
        text-align: center;
        background-color: #6c757d !important;
        color: var(--white) !important;
        font-size: 16px;
        border: none;
        transition: 0.5s;
        cursor: not-allowed;
    }

    .new_product {
        position: absolute;
        top: 0;
        left: 0;
        margin-top: 25px;
        -webkit-clip-path: polygon(0% 0%, 75% 0%, 100% 50%, 75% 100%, 0% 100%);
        clip-path: polygon(0% 0%, 75% 0%, 100% 50%, 75% 100%, 0% 100%);
    }

    .new_product span {
        background-color: var(--primary_color);
        color: var(--primary_text_color);
        font-size: 14px;
        padding: 1px 8px 1px 5px;
        border-radius: 0px 3px 3px 0px;
    }

    .product_name {
        line-height: 0px;
    }

    .product_name_link {
        font-size: 14px;
        color: var(--black);
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
        line-height: 22px;
        display: inline-block;
        margin-top: 10px;
        margin-bottom: 5px;
        overflow: hidden;
        width: 100%;
        display: -webkit-box;
        -webkit-line-clamp: 1;
        -webkit-box-orient: vertical;
    }

    .product_name_link:hover {
        color: var(--primary_color);
        /* display: inline-block; */
    }

    .product_price {
        margin-bottom: 7px;
        text-align: left;
    }

    .product_new_price {
        font-size: 14px;
        margin-right: 0px;
        color: var(--black);
        font-weight: 500;
    }

    .single_product_new_price {
        font-weight: 600;
        color: var(--black);
        font-size: 28px;
    }

    .product_discount_price {
        font-size: 14px;
        color: var(--discount_price_color);
        text-decoration: line-through;
        padding-left: 6px;
        font-weight: 500;
    }

    .product_btn_link {
        color: var(--white) !important;
        background-color: var(--primary_color);
        display: block;
        border: 1px solid var(--border);
        width: 100%;
        text-align: center;
        padding: 3px 0px;
        border-radius: 4px;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
        font-size: 14px;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .product_add_to_order {
        background-color: rgb(169 129 83/1);
    }

    .single_pro_specification.single_pro_question {
        margin-bottom: 10px;
    }

    .single_pro_specification_content {
        background-color: #F4F6F9;
        display: block;
        overflow: hidden;
        padding: 10px 10px 0px 20px;
        height: 100%;
        border-radius: 3px;
    }

    .single_pro_specification {
        margin-bottom: 5px;
    }

    .single_pro_specification strong {}

    .single_pro_specification ul {
        margin: 0;
        padding: 0;
    }

    .single_pro_specification ul li {
        display: flex;
        align-items: center;
        list-style: none;
        gap: 8px;
        margin-top: 4px;
        font-size: 14px;
    }

    .delivery_mobile_device {
        margin-top: 25px;
    }

    .single_pro_specification ul li svg {
        width: 16px;
    }

    .single_pro_specification ul li svg.online_pay_i {
        width: 18px;
    }

    .single_pro_specification ul li span {
        font-size: 14px;
    }

    /*
==============================================================
    Carousel Card Modal Area Css
==============================================================
*/
    /* .splide_relative {
  position: relative;
}
.modal-backdrop.show {
      opacity: 0;
  }
.modal-backdrop {
    z-index: -1040 !important;
}
.splide {
  position: inherit !important;
}
.splide__slide {
    position: inherit !important;
}
.splide__track {
    position: inherit !important;
} */


    .carousel_custom_area {
        position: relative;
        overflow: hidden;
    }

    .carousel_custom_table_cell {
        display: flex;
        overflow-x: auto;
        scroll-behavior: smooth;
        gap: 14px;
    }

    .carousel_custom_table_cell::-webkit-scrollbar {
        display: none;
    }

    .carousel_custom_item {
        flex: 0 0 auto;
        -webkit-box-flex: 0;
        -ms-flex: 0 0 auto;
        width: 16.666%;
    }

    .carousel_custom_pre_btn,
    .carousel_custom_next_btn {
        border: none;
        width: 35px;
        height: 40px;
        position: absolute;
        top: 0;
        display: flex;
        justify-content: center;
        align-items: center;
        z-index: 9;
        top: 50%;
        transform: translateY(-50%);
    }

    .carousel_custom_pre_btn {
        left: 0;
        transform: rotate (180deg);
    }

    .carousel_custom_next_btn {
        right: 0;
    }

    .carousel_custom_pre_btn i,
    .carousel_custom_next_btn i {
        opacity: 0.2;
    }

    .carousel_custom_pre_btn:hover i,
    .carousel_custom_next_btn:hover i {
        opacity: 1;
    }

    .carousel_custom_table_cell {
        cursor: grab;
    }

    .carousel_custom_table_cell:active {
        cursor: grabbing;
    }


    /*
==============================================================
    Service Area Css
==============================================================
*/
    .service_item {
        text-align: center;
    }

    .service_icon {
        width: 80px;
        height: 80px;
        line-height: 73px;
        text-align: center;
        font-size: 35px;
        border-radius: 50%;
        background: var(--primary_color);
        color: var(--primary_text_color);
        border: 5px solid var(--border);
        margin: 0 auto;
    }

    .service_icon i {
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .service_item:hover .service_icon i {
        -webkit-transform: scaleX(-1);
        -ms-transform: scaleX(-1);
        transform: scaleX(-1);
        cursor: pointer;
        -webkit-transition: 0.5s;
        -o-transition: 0.5s;
        transition: 0.5s;
    }

    .service_title {
        margin-top: 20px;
        margin-bottom: 5px;
    }

    .service_title h4 {
        font-size: 22px;
    }




    /*
==============================================================
    Wishlist Area Css
==============================================================
*/
    .wishlist_image img {
        width: 60px;
    }

    .wishlist_content table thead {
        background-color: #eeeeee;
    }

    .wishlist_content table thead tr th {
        padding-left: 10px !important;
        padding-right: 10px !important;
        font-weight: 500;
    }

    .wishlist_content table tbody tr td {
        padding-left: 10px !important;
        padding-right: 10px !important;
    }

    .wishlist_name_link {
        color: var(--black);
        display: block;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .wishlist_name_link:hover {
        color: var(--primary_color);
    }

    .wishlist_action_link {
        border: none;
        background-color: var(--primary_color);
        color: var(--primary_text_color);
        font-size: 14px;
        display: inline-block;
        padding: 3px 10px;
        border-radius: 3px;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
        text-align: center;
    }

    .wishlist_action_link:hover {
        color: var(--primary_hover_color);
    }

    .wishlist_delete_link {
        border: none;
        background-color: transparent;
        font-size: 18px;
        color: var(--black);
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
        cursor: pointer;
        color: red;
    }

    .wishlist_delete_link:hover {
        color: var(--primary_hover_color);
    }

    .wishlist_content tbody tr td {
        vertical-align: middle;
    }

    /*
==============================================================
    View Cart Area Css
==============================================================
*/
    .btn_disabled {
        pointer-events: none;
        opacity: 0.65;
    }

    .view_cart_shipping_content {
        border-top: 1px solid var(--border);
        border-bottom: 1px solid var(--border);
        padding: 20px 0px;
    }

    .view_cart_subtotal {
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
        -webkit-box-pack: justify;
        -ms-flex-pack: justify;
        justify-content: space-between;
        padding-bottom: 15px;
        padding-top: 10px;
    }

    .view_cart_subtotal strong {
        font-size: 20px;
        font-weight: 500;
    }

    .view_cart_total {
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
        -webkit-box-pack: justify;
        -ms-flex-pack: justify;
        justify-content: space-between;
        padding-top: 25px;
        margin-bottom: 25px;
    }

    .view_cart_total strong {
        font-size: 20px;
        font-weight: 500;
    }

    .view_cart_image img {
        width: 60px;
        height: 60px;
    }

    .view_cart_name_link {
        color: var(--black);
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .view_cart_name_link:hover {
        color: var(--primary_color);
    }

    .view_cart_action_link {
        border: none;
        background-color: var(--black);
        color: var(--white);
        font-size: 14px;
        display: inline-block;
        padding: 3px 10px;
        border-radius: 3px;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .view_cart_action_link:hover {
        color: var(--primary_color);
    }

    .view_cart_delete_link {
        border: none;
        background-color: transparent;
        font-size: 18px;
        color: var(--black);
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .view_cart_delete_link:hover {
        color: var(--primary_color);
    }

    .view_cart_qty_minus {
        border: 1px solid var(--border);
        color: var(--black);
        width: 40px;
        height: 40px;
        line-height: 40px;
        text-align: center;
        border-right: 0px;
        float: left;
        border-radius: 3px 0px 0px 3px;
        cursor: pointer;
        background-color: transparent;
    }

    .view_cart_qty input {
        border: 1px solid var(--border);
        color: var(--black);
        width: 50px;
        height: 40px;
        line-height: 40px;
        text-align: center;
        float: left;
        cursor: pointer;
    }

    .view_cart_qty_plus {
        border: 1px solid var(--border);
        color: var(--black);
        width: 40px;
        height: 40px;
        line-height: 40px;
        text-align: center;
        border-left: 0px;
        float: left;
        border-radius: 0px 3px 3px 0px;
        cursor: pointer;
        background-color: transparent;
    }

    .view_cart_right_side {
        background: var(--white);
        -webkit-box-shadow: 0px 30px 70px rgba(1, 15, 28, 0.1);
        box-shadow: 0px 30px 70px rgba(1, 15, 28, 0.1);
        padding: 36px 24px 28px;
    }

    .view_cart_process_checkout_link {
        display: inline-block;
        color: var(--white);
        background-color: var(--primary_color);
        border: 1px solid var(--primary_color);
        width: 100%;
        text-align: center;
        padding: 10px 0px;
        border-radius: 3px;
        font-size: 18px;
        text-transform: capitalize;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .view_cart_process_checkout_link:hover {
        color: var(--primary_color);
        background-color: var(--white);
        border: 1px solid var(--primary_color);
    }

    .view_cart_coupon {
        position: relative;
    }

    .view_cart_coupon label {
        display: block;
    }

    .view_cart_coupon input {
        border: 1px solid var(--border);
        padding: 10px 10px;
        width: 450px;
        height: 50px;
    }

    .view_cart_coupon_update {
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
        -webkit-box-pack: justify;
        -ms-flex-pack: justify;
        justify-content: space-between;
        margin-top: 20px;
    }

    .view_cart_coupon_btn {
        position: absolute;
        top: 0;
        right: 0;
        border: none;
        background: var(--primary_color);
        color: var(--white);
        padding: 10px 20px;
        display: inline-block;
        height: 50px;
    }

    .view_cart_update_btn {
        border: none;
        background-color: var(--primary_color);
        color: var(--white);
        display: inline-block;
        padding: 12px 25px;
        border-radius: 3px;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .view_cart_update_btn:hover {
        color: var(--black);
    }

    .product_shipping {
        -webkit-box-shadow: var(--shadow);
        box-shadow: var(--shadow);
        padding: 20px;
        border-radius: 3px;
    }

    .shipping_option_item {
        margin-top: 10px;
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
    }

    .shipping_option_item input[type="radio"] {
        -webkit-appearance: none;
        -moz-appearance: none;
        appearance: none;
        height: 20px;
        width: 20px;
        background-color: var(--white);
        border: 1px solid var(--border);
        border-radius: 3px;
        cursor: pointer;
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        outline: none;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
        -webkit-box-pack: center;
        -ms-flex-pack: center;
        justify-content: center;
        float: left;
        margin-right: 10px;
    }

    .shipping_option_item label {
        color: var(--black);
        font-size: 16px;
        cursor: pointer;
    }

    .shipping_option_item input[type="radio"]:after {
        font-family: "Font Awesome 6 Free";
        content: "\f00c";
        font-weight: 600;
        font-size: 16px;
        color: var(--white);
        display: none;
    }

    .shipping_option_item input[type="radio"]:checked {
        background-color: var(--primary_color);
    }

    .shipping_option_item input[type="radio"]:checked:after {
        display: block;
    }

    .shipping_option_item label,
    .shipping_option_item input {
        cursor: pointer;
    }

    /*
==============================================================
    Footer Area Css
==============================================================
*/
    .footer_area {
        border-top: 1px solid var(--border);
        background-color: var(--footer_background_color);
    }

    .footer_top {
        padding-top: 50px;
        padding-bottom: 45px;
    }

    .footer_logo img {
        max-height: 60px;
    }

    .footer_call {
        margin-top: 20px;
        margin-bottom: 30px;
    }

    .footer_call p {
        color: color-mix(in srgb, var(--footer_text_color), transparent 25%);
        font-size: 16px;
    }

    .footer_call .footer_call_link {
        font-size: 26px;
        font-weight: 600;
        letter-spacing: 1px;
        color: var(--footer_text_color);
        margin-top: 10px;
        display: block;
        transition: .3s;
    }

    .footer_call .footer_call_link:hover {
        color: var(--footer_hover_color);
    }

    .footer_social ul li {
        display: inline-block;
        margin-right: 10px;
        list-style: none;
    }

    .footer_social ul li:last-child {
        margin-right: 0px;
    }

    .footer_social ul li .footer_social_link {
        color: color-mix(in srgb, var(--footer_text_color), transparent 25%);
        font-size: 25px;
        display: block;
        transition: .3s;
    }

    .footer_social ul li .footer_social_link:hover {
        color: var(--footer_hover_color);
    }

    .footer_title {
        margin-bottom: 20px;
    }

    .footer_title h3 {
        font-size: 20px;
        font-weight: 600;
        color: var(--footer_text_color);
    }

    .footer_contact {}

    .footer_contact ul {}

    .footer_contact ul li {
        color: color-mix(in srgb, var(--footer_text_color), transparent 25%);
        list-style: none;
        font-weight: 300;
    }

    .footer_contact ul li p {
        color: color-mix(in srgb, var(--footer_text_color), transparent 25%);
        font-weight: 300;
    }

    .footer_contact ul li span {
        font-weight: 300;
    }

    .footer_contact ul li p strong {
        font-weight: 300;
    }

    .footer_contact ul li p span {
        font-weight: 300;
    }

    .footer_contact ul li:last-child {
        margin-bottom: 0px;
    }

    .footer_contact ul li .footer_contact_link {
        font-size: 16px;
        font-weight: 400;
        letter-spacing: 1px;
        color: color-mix(in srgb, var(--footer_text_color), transparent 25%);
        margin-top: 10px;
        display: block;
    }

    .footer_menu ul li {
        margin-bottom: 15px;
        list-style: none;
    }

    .footer_menu ul li:last-child {
        margin-bottom: 0px;
    }

    .footer_menu ul li .footer_menu_link {
        color: color-mix(in srgb, var(--footer_text_color), transparent 25%);
        font-weight: 300;
        transition: .3s;
        text-transform: capitalize;
    }

    .footer_menu ul li .footer_menu_link:hover {
        color: var(--footer_hover_color);
    }

    .footer_payment_method {
        text-align: center;
        margin-top: 25px;
        margin-bottom: 25px;
        display: block;
        width: 100%;
    }

    .footer_payment_method img {
        max-width: 100%;
    }

    .footer_bottom {
        border-top: 1px solid #eeeeee1f;
        padding: 10px 0px;
    }

    .copyright {
        display: flex;
        align-items: center;
        height: 100%;
    }

    .develop_by {
        display: flex;
        align-items: center;
        justify-content: end;
        gap: 5px;
    }

    .develop_by p {
        color: color-mix(in srgb, var(--footer_text_color), transparent 25%);
    }

    .develop_by .develop_by_link {
        color: var(--footer_hover_color);
        transition: .3s;
    }

    .develop_by .develop_by_link:hover {
        color: var(--footer_text_color);
    }

    .copyright p {
        color: color-mix(in srgb, var(--footer_text_color), transparent 25%);
        font-size: 16px;
    }

    .copyright p .copyright_link {
        color: var(--primary_color);
    }

    .payment_method {
        text-align: right;
    }

    .payment_method ul li {
        display: inline-block;
        margin-right: 2px;
        list-style: none;
    }

    .payment_method ul li:last-child {
        margin-right: 0px;
    }

    .payment_method ul li img {
        width: 80px;
        height: 40px;
        border: 1px solid var(--border);
        border-radius: 3px;
        padding: 6px;
    }

    .footer_copyright p {
        color: var(--footer_text_color);
        font-weight: 300;
    }

    .footer_develop_by {
        display: flex;
        justify-content: end;
    }

    .footer_develop_by p {
        color: var(--footer_text_color);
        font-weight: 300;
    }

    .footer_develop_by_link {
        color: orange;
        font-weight: 500;
        margin-left: 5px;
    }

    .footer_description {
        margin-top: 10px;
    }

    .footer_description p,
    .footer_description strong,
    .footer_description span,
    .footer_description h1,
    .footer_description h2,
    .footer_description h3,
    .footer_description h4,
    .footer_description h5,
    .footer_description h6 {
        color: var(--footer_text_color);
        font-weight: 300;
    }

    /*
==============================================================
    Fixed Communication Social Css
==============================================================
*/
    .fixed_communication_social.fixed_communication_social_active {
        z-index: 999 !important;
        position: relative;
    }

    .fixed_communication_social .fixed_communication_toggle {
        position: fixed;
        bottom: 67px;
        right: 6px;
        width: 48px;
        height: 48px;
        border-radius: 50%;
        display: flex;
        justify-content: center;
        align-items: center;
        cursor: pointer;
        z-index: 999;
        /* animation: ripple-red 1s linear infinite; */
        transition: .5s;
    }

    @-webkit-keyframes ripple-red {
        0% {
            box-shadow: 0 0 0 0 rgba(0, 128, 0, 0.3), 0 0 0 1px rgba(0, 128, 0, 0.3), 0 0 0 1px rgba(0, 128, 0, 0.3)
        }

        100% {
            box-shadow: 0 0 0 1px rgba(0, 128, 0, 0.3), 0 0 0 1px rgba(0, 128, 0, 0.3), 0 0 0 30px rgba(2241, 42, 2, 0)
        }
    }

    .fixed_communication_social .fixed_communication_toggle svg {
        position: absolute;
        opacity: 0;
        transition: 0.5s;
    }

    .fixed_communication_social .fixed_communication_toggle svg:nth-child(1) {
        opacity: 1;
        transform: rotate(360deg);
    }

    .fixed_communication_social.fixed_communication_social_active .fixed_communication_toggle svg:nth-child(1) {
        opacity: 0;
        transform: rotate(0deg);
    }

    .fixed_communication_social.fixed_communication_social_active .fixed_communication_toggle svg:nth-child(2) {
        opacity: 1;
        transform: rotate(360deg);
    }

    .fixed_communication_social.fixed_communication_social_active .fixed_communication_toggle svg:nth-child(3) {
        opacity: 1;
        transform: rotate(360deg);
    }

    .communication_social {
        position: fixed;
        bottom: 70px;
        right: 11px;
    }

    .communication_social ul li {
        transition: .3s;
        list-style: none;
    }

    .communication_social ul li:last-child {
        margin-bottom: 0px;
    }

    .communication_social ul li a {
        border-radius: 100%;
        color: #ffffff;
        position: relative;
    }

    .communication_social ul li a p {
        position: absolute;
        top: 0;
        right: 100%;
        width: max-content;
        margin-right: 15px;
        background-color: #ffffff;
        color: #333333;
        box-shadow: rgba(99, 99, 99, 0.2) 0px 2px 8px 0px;
        padding: 5px 8px;
        height: 25px;
        line-height: 18px;
        font-size: 14px;
        border-radius: 5px;
        opacity: 0;
        visibility: hidden;
        transition: .3s;
    }

    .communication_social ul li:hover a p {
        opacity: 1;
        visibility: visible;
    }

    .communication_social ul li a p::before {
        content: "";
        position: absolute;
        right: -10px;
        top: 50%;
        width: 0;
        height: 0;
        -webkit-transform: translateY(-50%);
        -ms-transform: translateY(-50%);
        transform: translateY(-50%);
        border-top: 10px solid transparent;
        border-left: 10px solid #e9ecef61;
        border-bottom: 10px solid transparent;
    }

    .fixed_communication_social .communication_social ul li:nth-child(1) {
        transform: translateY(78px);
    }

    .fixed_communication_social .communication_social ul li:nth-child(2) {
        transform: translateY(40px);
    }

    .fixed_communication_social.fixed_communication_social_active .communication_social ul li:nth-child(1) {
        transform: translateY(-60px);
    }

    .fixed_communication_social.fixed_communication_social_active .communication_social ul li:nth-child(2) {
        transform: translateY(-55px);
    }

    .fixed_communication_social.fixed_communication_social_active .communication_social ul li:nth-child(3) {
        transform: translateY(-50px);
    }

    .fixed_communication_social .fixed_communication_toggle p {
        width: max-content;
        display: block;
        height: 24px;
        line-height: 24px;
        font-size: 14px;
        position: absolute;
        top: 50%;
        transform: translateY(-50%);
        right: 100%;
        background-color: #ffffff;
        box-shadow: rgba(99, 99, 99, 0.2) 0px 2px 8px 0px;
        padding: 1px 10px;
        margin-right: 12px;
        border-radius: 3px;
        opacity: 0;
        visibility: hidden;
        transition: .3s;
    }

    .fixed_communication_social .fixed_communication_toggle p::before {
        content: "";
        position: absolute;
        right: -10px;
        top: 50%;
        width: 0;
        height: 0;
        -webkit-transform: translateY(-50%);
        -ms-transform: translateY(-50%);
        transform: translateY(-50%);
        border-top: 10px solid transparent;
        border-left: 10px solid #e9ecef61;
        border-bottom: 10px solid transparent;
        transition: .3s;
    }

    .fixed_communication_social.fixed_communication_social_active .fixed_communication_toggle:hover p {
        opacity: 1;
        visibility: visible;
    }

    .fixed_communication_social .fixed_communication_toggle svg ellipse {
        fill: red;
        stroke: none;
    }

    .fixed_communication_social .fixed_communication_toggle svg g circle {
        fill: var(--primary_color);
        stroke: none;
    }

    /*
==============================================================
    Header Mobile Device Area Css
==============================================================
*/
    .header_mobile_table_cell {
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
        -webkit-box-pack: justify;
        -ms-flex-pack: justify;
        justify-content: space-between;
    }

    .mobile_menu_trigger {
        line-height: 0;
    }

    .mobile_menu_trigger i {
        font-size: 25px;
        color: var(--primary_color);
    }

    .mobile_menu_trigger svg {
        width: 27px;
        color: var(--primary_color);
    }

    .header_mobile_search {
        line-height: 0px;
    }

    .header_mobile_search i {
        font-size: 22px;
        color: var(--primary_color);
    }

    .header_mobile_search svg {
        width: 22px;
        color: var(--primary_color);
    }

    .header_mobile_icon_link {
        position: relative;
    }

    .header_mobile_icon_link i {
        font-size: 22px;
        color: var(--primary_color);
    }

    /*
==============================================================
    Breadcrumb Area Css
==============================================================
*/
    ._breadcrumb {
        line-height: 14px;
    }

    ._breadcrumb ul {
        margin: 0;
        padding: 0;
    }

    ._breadcrumb ul li {
        list-style: none;
        display: inline-block;
        margin-right: 5px;
    }

    ._breadcrumb ul li:last-child {
        margin-right: 0px;
    }

    ._breadcrumb ul li .breadcrumb_link {
        display: block;
        color: var(--black);
        font-size: 14px;
        line-height: 12px;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    ._breadcrumb ul li .breadcrumb_link:hover {
        color: var(--primary_color);
    }

    /*
==============================================================
    Shop Category Area Css
==============================================================
*/
    .shop_category {
        margin-top: 15px;
        margin-bottom: 10px;
    }

    .shop_category ul {
        margin: 0;
        padding: 0;
    }

    .shop_category ul li {
        list-style: none;
        display: inline-block;
        margin-right: 1px;
        margin-bottom: 5px;
    }

    .shop_category ul li:last-child {
        margin-right: 0px;
    }

    .shop_category ul li .shop_category_link {
        display: block;
        font-size: 14px;
        color: var(--primary_text_color);
        background-color: var(--primary_color);
        padding: 3px 10px;
        text-transform: uppercase;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .shop_category ul li .shop_category_link:hover {
        color: var(--primary_hover_color);
    }

    /*
==============================================================
    Single Product Area Css
==============================================================
*/
    .single_product_tab_content ul {
        margin-left: 28px;
    }

    .single_product_tab_content li {
        /* list-style:disc; */
    }

    .single_product_tab_content table td {
        border: 1px solid #dee2e6;
        padding: 6px 10px;
    }

    .zooming_show_image {
        overflow: hidden;
    }

    .zooming_show_image img {
        width: 100%;
        height: 100%;
        cursor: pointer;
        border-radius: 5px;
    }

    .zooming_show_image:hover {
        --zoom: 3;
        border-radius: 5px;
    }

    .zoom_img_active .owl-dots img {
        width: 60px;
        cursor: pointer;
        border-radius: 5px;
        border: 2px solid #ffffff;
    }

    .zoom_img_active .owl-dots div.active img {
        border-color: var(--primary_color);
    }

    .zoom_img_active .owl-dots div {
        display: inline-block;
        transition: 0.7s;
        border-radius: 5px;
    }

    .zoom_img_active .owl-dots {
        text-align: left;
        overflow: hidden;
        white-space: nowrap;
        scroll-behavior: smooth;
    }

    .header_search_item_product_details {
        display: block;
        overflow: hidden;
    }

    .zoom_img_active .owl-dots div .video_icon_overlay::after {
        content: "\f167";
        position: absolute;
        top: 0;
        left: 0;
        transform: translate(-50%, -50%);
        color: #000000;
        background-color: #ffffff;
        width: 110px;
        height: 110px;
        line-height: 110px;
        font-size: 35px;
        font-weight: 600;
        font-family: "Font Awesome 6 Brands";
        opacity: .8;
        text-align: center;
    }

    .zoom_img_active .owl-dots div {
        position: relative;
    }

    .video_icon_overlay_content {
        position: absolute !important;
        top: 49% !important;
        left: 50% !important;
    }

    .zoom_img_active .owl-dots {
        position: relative;
        margin-top: 2px;
    }

    .youtube_video iframe {
        border-radius: 5px;
    }

    .zooming_image_content .youtube_video {
        line-height: 0;
    }

    .video_play_icon {
        position: absolute;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
        border: 2px solid #ffffff;
        padding: 0px 10px;
        color: #ffffff;
        font-size: 20px;
        border-radius: 3px;
        cursor: pointer;
    }

    .zoom_img_active .owl-nav .owl-prev,
    .zoom_img_active .owl-nav .owl-next {
        font-size: 16px;
        width: 30px;
        height: 30px;
        line-height: 30px;
        color: var(--primary_text_color);
        text-align: center;
        position: absolute;
        border: 1px solid var(--primary_color);
        background-color: var(--primary_color);
        border-radius: 100%;
        top: 45%;
        transform: translateY(-45%);
        opacity: 0;
        visibility: hidden;
        transition: .3s;
    }

    .zoom_img_active .owl-nav .owl-prev {
        left: 0;
    }

    .zoom_img_active .owl-nav .owl-next {
        right: 0;
    }

    .zooming_image_content:hover .zoom_img_active .owl-nav .owl-prev,
    .zooming_image_content:hover .zoom_img_active .owl-nav .owl-next {
        visibility: visible;
        opacity: 1;
    }

    .single_product_list ul {
        margin: 0;
        padding: 0;
        line-height: 1;
    }

    .single_product_list ul li {
        list-style: none;
        display: inline-block;
        margin-right: 5px;
        line-height: 1;
    }

    .single_product_list ul li:last-child {
        margin-right: 0px;
    }

    .single_product_list ul li:not(:last-child):after {
        content: "";
        position: relative;
        font-size: 12px;
        font-weight: 600;
        font-family: "Font Awesome 5 Free";
        color: var(--black);
        margin-left: 5px;
    }

    .single_product_list ul li .single_product_list_link {
        display: inline-block;
        font-size: 14px;
        color: var(--black);
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
        line-height: 1;
    }

    .single_product_list ul li .single_product_list_link:hover {
        color: var(--primary_color);
    }

    .single_product_name {
        margin-top: 25px;
    }

    .single_product_buy_now_btn {
        margin-top: 35px;
    }

    .single_pro_specification_link {
        color: var(--black);
        transition: .3s;
        font-size: 14px;
    }

    .single_pro_specification_link:hover {
        color: var(--primary_hover_color);
    }

    .single_product_name h2 {
        font-size: 22px;
        line-height: 28px;
    }

    .single_product_attribute_code {
        margin-bottom: 10px;
    }

    .single_product_attribute.s_p_code {
        margin-top: 18px;
        margin-bottom: -3px;
    }

    .single_product_attribute.s_p_price {
        margin-top: 25px;
    }

    .select_attribute_container.s_p_select {
        margin-top: 20px;
    }

    .single_product_qty_with_buy_now_btn {
        padding-top: 35px;
        display: block;
    }

    .single_product_btn_group {
        display: block;
        padding-top: 20px;
    }

    .single_product_whatsapp_link {
        color: #40c351;
        display: inline-block;
        border-bottom: 1px solid var(--white);
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
        display: inline-flex;
        gap: 5px;
    }

    .single_product_whatsapp_link:hover {
        color: #40c351;
    }

    .single_product_attribute {
        display: flex;
        align-items: center;
    }

    .single_product_attribute .s_p_qty {
        width: inherit;
        margin-right: 10px;
        letter-spacing: 1px;
    }

    .single_product_whatsapp {
        margin-top: 10px;
    }

    .single_product_attribute strong {
        width: 55px;
        font-weight: normal;
    }

    .single_product_attribute_label {
        font-weight: normal;
        margin-bottom: 1px;
        display: block;
    }

    .single_product_discount_price {
        color: var(--discount_price_color);
        text-decoration: line-through;
        padding-left: 10px;
        font-size: 20px;
    }

    .single_product_attribute_size {
        margin-top: 3px;
    }

    .single_product_attribute_qty strong {
        font-weight: normal;
        margin-bottom: 2px;
        display: block;
    }

    .single_product_size_checkbox_list ul li {
        display: inline-block;
        margin-right: 1px;
        margin-bottom: 2px;
        list-style: none;
    }

    .single_product_size_checkbox_list ul li:last-child {
        margin-right: 0px;
    }

    .single_product_size_checkbox_list_group {
        position: relative;
    }

    .single_product_size_checkbox_list_group input {
        display: none;
    }

    .single_product_size_checkbox_list_group label {
        cursor: pointer;
        border: 1px solid #cccccc;
        background: var(--white);
        text-align: center;
        -webkit-transition: all 200ms ease-in-out;
        -o-transition: all 200ms ease-in-out;
        transition: all 200ms ease-in-out;
        border-radius: 3px;
    }

    .single_product_size_checkbox_list_group .icon {
        margin-top: 10px;
        font-size: 30px;
        color: var(--black);
        -webkit-transition: all 200ms ease-in-out;
        -o-transition: all 200ms ease-in-out;
        transition: all 200ms ease-in-out;
    }

    .single_product_size_checkbox_list_group .title {
        font-size: 14px;
        color: #979797;
        padding: 0px 10px;
        -webkit-transition: all 200ms ease-in-out;
        -o-transition: all 200ms ease-in-out;
        transition: all 200ms ease-in-out;
        letter-spacing: .6px;
        text-transform: capitalize;
        line-height: 1;
        height: 28px;
        line-height: 28px;
        position: relative;
        z-index: 99;
    }

    .single_product_size_checkbox_list_group label:before {
        /* content: "✓"; */
        content: "";
        position: absolute;
        width: 100%;
        height: 100%;
        bottom: 0px;
        right: 0px;
        background: var(--primary_color);
        color: var(--primary_text_color);
        text-align: center;
        line-height: 14px;
        font-size: 10px;
        font-weight: 600;
        opacity: 0;
        -webkit-transform: scale(0.5);
        -ms-transform: scale(0.5);
        transform: scale(0.5);
        -webkit-transition: all 200ms ease-in-out;
        -o-transition: all 200ms ease-in-out;
        transition: all 200ms ease-in-out;
        /* border-radius: 25px 0px 3px 0px; */
        padding-left: 2px;
        padding-top: 2px;
        border-radius: 3px;
    }

    .single_product_size_checkbox_list_group input:checked+label:before {
        opacity: 1;
        -webkit-transform: scale(1);
        -ms-transform: scale(1);
        transform: scale(1);
    }

    .single_product_size_checkbox_list_group input:checked+label .icon {
        color: var(--primary_color);
    }

    .single_product_size_checkbox_list_group input:checked+label .title {
        color: var(--primary_text_color);
    }

    .single_product_size_checkbox_list_group input:checked+label {
        border: 1px solid var(--primary_color);
    }

    .single_pro_specification ul li svg.refund_i {
        width: 15px;
    }

    .single_pro_specification ul li .single_pro_specification_link svg {
        margin-right: 3px;
    }

    .single_product_qty {
        display: flex;
        align-items: center;
        width: 100%;
    }

    .single_product_call_link {
        display: flex;
        align-items: center;
        gap: 5px;
    }

    .single_product_qty_minus {
        border: 1px solid #cccccc;
        color: #979797;
        width: 35px;
        height: 40px;
        line-height: 40px;
        text-align: center;
        border-right: 0px;
        border-radius: 3px 0px 0px 3px;
        cursor: pointer;
        background-color: transparent;
        float: left;
        display: block;
    }

    .single_product_qty input {
        border: 1px solid #cccccc;
        color: #979797;
        width: 100%;
        height: 40px;
        line-height: 40px;
        text-align: center;
        float: left;
        display: block;
        border-right: 0;
        border-left: 0;
    }

    .single_product_qty_plus {
        border: 1px solid #cccccc;
        color: #979797;
        width: 35px;
        height: 40px;
        line-height: 40px;
        text-align: center;
        border-left: 0px;
        border-radius: 0px 3px 3px 0px;
        cursor: pointer;
        background-color: transparent;
        display: block;
    }

    .single_product_list ul li .single_product_list_link svg {
        margin-top: -4px;
    }

    .single_product_buy_now_btn_link {
        border: none;
        background-color: var(--primary_color);
        color: var(--primary_text_color) !important;
        padding: 7px 5px;
        border-radius: 3px;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
        width: 100%;
        text-align: center;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .product_card .product_btn_link:hover {
        color: var(--white);
    }

    .single_product_add_to_cart {
        border: 1px solid var(--single_page_add_to_card_border_color);
        background-color: var(--single_page_add_to_card_bg_color);
        color: var(--single_page_add_to_card_text_color);
        padding: 6px 0px;
        border-radius: 3px;
        display: block;
        width: 100%;
        text-align: center;
        /* color: var(--black); */
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .single_product_add_to_cart svg {
        width: 15px;
    }

    .single_product_add_to_cart:hover {
        background-color: var(--single_page_add_to_card_hover_bg_color);
        border-color: var(--single_page_add_to_card_hover_border_color) !important;
        color: var(--single_page_add_to_card_hover_text_color);
    }

    .single_product_add_to_wishlist {
        border: 1px solid #cccccc;
        background-color: transparent;
        display: block;
        padding: 6px 12px;
        border-radius: 3px;
        font-size: 20px;
        text-align: center;
        color: var(--black);
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .single_product_add_to_wishlist:hover {
        color: var(--primary_color);
    }

    .single_product_specification_list {
        border: 2px dotted var(--primary_color);
        padding: 10px;
        margin-bottom: 15px;
    }

    .single_product_specification_list ul {
        margin: 0;
        padding: 0;
    }

    .single_product_specification_list ul li {
        list-style: none;
        font-size: 14px;
        margin-bottom: 5px;
    }

    .single_product_specification_list ul li:last-child {
        margin-bottom: 0px;
    }

    .single_product_specification_list ul li i {
        padding-right: 5px;
    }

    .size_chart {
    cursor: pointer;
    border: 1px solid #cccccc;
    background: var(--white);
    text-align: center;
    -webkit-transition: all 200ms ease-in-out;
    -o-transition: all 200ms ease-in-out;
    transition: all 200ms ease-in-out;
    border-radius: 3px;
    padding: 2px 10px;
}
    #fixed_banner_container {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100vh;
        background-color: #0000009c;
        display: flex;
        justify-content: center;
        align-items: center;
        z-index: 99999;
    }

    .fixed_banner_img_with_closeIcon {
        position: relative;
        margin: 12px;
    }

    .fixed_banner_img_with_closeIcon img {
        max-width: 100%;
        max-height: 85vh;
    }

    .fixed_banner_img_with_closeIcon svg {
        color: #fff;
        z-index: 999;
        position: absolute;
        bottom: calc(100% + 5px);
        right: 0;
        cursor: pointer;
    }

    .single_product_call_details {
        border: 2px dotted var(--primary_color);
        padding: 10px;
    }

    .single_product_call {}

    .single_product_call ul {
        margin: 0;
        padding: 0;
    }

    .single_product_call ul li {
        list-style: none;
        margin-top: 5px;
    }

    .single_product_call ul li .single_product_call_link {
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
    }

    .single_product_call_content {
        font-size: 14px;
        color: var(--black);
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
        color: var(--primary_color);
    }

    .single_product_call_content:hover {
        color: var(--primary_color);
    }

    .single_product_call_content i {
        -webkit-transform: rotate(20deg);
        -ms-transform: rotate(20deg);
        transform: rotate(20deg);
        font-size: 11px;
    }

    .single_product_call_payment_method p {
        font-size: 14px;
        border: 1px dotted red;
        display: inline;
        padding: 2px 5px;
        color: red;
        margin-left: 5px;
    }

    .single_product_tab_nav {
        background-color: #ffffff;
        margin-bottom: 20px;
    }

    .single_product_tab_nav .single_product_tab_nav_link {
        border-radius: 0px;
        border: 1px solid #ffffff;
        color: var(--black);
        font-weight: 500;
        font-size: 15px;
        text-transform: uppercase;
        letter-spacing: 1px;
        border-bottom: none;
        text-transform: capitalize;
        font-size: 18px;
    }

    .single_product_tab_nav .single_product_tab_nav_link.active {
        color: var(--primary_color);
        background-color: #ffffff;
        border-color: #dee2e6 #dee2e6 #fff;
        border: 1px solid var(--border);
        border-bottom: none;
    }

    .single_product_tab_list {}

    .single_product_tab_list ul {
        margin: 0;
        padding: 0;
    }

    .single_product_tab_list ul li {
        list-style: none;
        margin-bottom: 10px;
        margin-left: 20px;
    }

    .single_product_tab_list ul li:last-child {
        margin-bottom: 0px;
    }


    .single_pro_wishlist {
        margin-top: 20px;
    }

    .single_pro_wishlist svg {
        width: 16px;
    }

    .single_pro_wishlist_link {
        border: none;
        display: flex;
        align-items: center;
        background-color: transparent;
        gap: 5px;
        line-height: 1;
        transition: .3s;
    }

    .single_pro_wishlist_link {
        color: var(--primary_color);
        font-size: 14px;

    }

    .single_pro_wishlist_link:hover {
        color: var(--primary_hover_color);
    }

    .products_sticky_buttton_fixed {
        position: fixed;
        right: 0;
        bottom: 0;
        left: 0;
        z-index: 99999999999999999;
        background-color: var(--white);
        border-top: 1px solid rgba(0, 0, 0, 0.1);
        /* height: 87px; */
        /* border: 1px solid red; */
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .single_product_tab_area {
        margin-top: -25px;
    }

    .shipping_highlight {
        padding: 1px 7px;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
        display: inline-block;
        border: 1px solid black;
        border-image-outset: 0;
        border-image-repeat: stretch;
        border-image-slice: 100%;
        border-image-source: none;
        border-image-width: 1;
        resize: both;
        -o-border-image: url("data:image/svg+xml;charset=utf-8,%3Csvg width='100' height='100' viewBox='0 0 100 100' fill='none' xmlns='http://www.w3.org/2000/svg'%3E %3Cstyle%3Epath%7Banimation:stroke 5s infinite linear%3B%7D%40keyframes stroke%7Bto%7Bstroke-dashoffset:776%3B%7D%7D%3C/style%3E%3ClinearGradient id='g' x1='0%25' y1='0%25' x2='0%25' y2='100%25'%3E%3Cstop offset='0%25' stop-color='%230037ff' /%3E%3Cstop offset='25%25' stop-color='%230037ff' /%3E%3Cstop offset='50%25' stop-color='%230037ff' /%3E%3Cstop offset='100%25' stop-color='%230037ff' /%3E%3C/linearGradient%3E %3Cpath d='M1.5 1.5 l97 0l0 97l-97 0 l0 -97' stroke-linecap='square' stroke='url(%23g)' stroke-width='3' stroke-dasharray='388'/%3E %3C/svg%3E") 1;
        border-image: url("data:image/svg+xml;charset=utf-8,%3Csvg width='100' height='100' viewBox='0 0 100 100' fill='none' xmlns='http://www.w3.org/2000/svg'%3E %3Cstyle%3Epath%7Banimation:stroke 5s infinite linear%3B%7D%40keyframes stroke%7Bto%7Bstroke-dashoffset:776%3B%7D%7D%3C/style%3E%3ClinearGradient id='g' x1='0%25' y1='0%25' x2='0%25' y2='100%25'%3E%3Cstop offset='0%25' stop-color='%230037ff' /%3E%3Cstop offset='25%25' stop-color='%230037ff' /%3E%3Cstop offset='50%25' stop-color='%230037ff' /%3E%3Cstop offset='100%25' stop-color='%230037ff' /%3E%3C/linearGradient%3E %3Cpath d='M1.5 1.5 l97 0l0 97l-97 0 l0 -97' stroke-linecap='square' stroke='url(%23g)' stroke-width='3' stroke-dasharray='388'/%3E %3C/svg%3E") 1;
        margin-bottom: 2px;
        margin-top: 15px;
    }

    .shipping_highlight h4 {
        font-weight: 400;
        font-size: 15px;
        line-height: 20px;
        color: var(--black);
        margin: 0;
    }







    .footer_button_fixed {
        width: 100%;
    }

    .fixed_home_icon {
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
    }


    .fixed_home_icon span {
        /* color: red; */
    }

    .addTOcart {
        background-color: var(--white);
        color: var(--black);
        padding: 4px;
        border-radius: 20px 0px 0px 20px;
        border: 1px solid var(--primary_color);
        font-size: 15px;
    }

    .buyToCart {
        background-color: var(--primary_color);
        color: var(--white);
        padding: 4px;
        border-radius: 0px 20px 20px 0px;
        margin-left: -8px;
        border: 1px solid var(--primary_color);
        font-size: 15px;
    }

    .fixed_home_icon span {
        font-size: 14px;
    }

    .fixed_home_icon i {
        font-size: 20px;
    }

    .mobile_footer_single {
        width: 97px !important;
    }

    .mobile_footer_single_size {
        /* width: 97px !important; */
        margin-right: 24px;
        text-align: center
    }

    .mobile_view {
        width: 60px !important;
    }

    .mobile_footer_single strong {
        font-weight: 500
    }

    .mobile_views_size {
        overflow-y: scroll !important;
        margin-bottom: 7px !important;
    }

    .mobile_views_lit ul {
        display: flex;
        overflow-x: auto;
    }

    .mobile_views_lit ul li {
        margin-right: 10px;
        list-style: none;
    }

    .call_icon {
        transition: 0.5s;
    }

    .call_whats {
        display: flex;
        align-items: center;
        border: 1px solid var(--border);
        border-radius: 5px;
        padding: 8px 12px;
        gap: 12px;
        width: 100%;
        height: auto;
        box-sizing: border-box;
        transition: 0.5s;
    }

    .call_contact_us:hover .call_icon {
        background-color: var(--primary_color);
        color: white;
    }

    .call_contact_us:hover .call_icon i {
        color: white;
    }

    .call_contact_us:hover .whats_up {
        background-color: #25d366;
        color: white;
    }

    .call_contact_us:hover .whats_up i {
        color: white;
    }

    .call_icon,
    .whats_up {
        display: flex;
        align-items: center;
        justify-content: center;
        width: 40px;
        height: 40px;
        border-radius: 50%;
        background-color: #f5f5f5;
        transition: 0.5s;
    }



    .call_icon i {
        transform: rotate(40deg);
        font-size: 22px;
        color: var(--primary_color);
    }

    .whats_up i {
        font-size: 22px;
        color: #25d366;
    }

    .contact_des {
        display: flex;
        flex-direction: column;
        justify-content: center;
    }

    .contact_des h5 {
        font-size: 15px;
        line-height: 20px;
        margin-bottom: 4px;
    }

    .contact_des h6 {
        font-size: 14px;
        line-height: 18px;
        margin: 0;
        letter-spacing: 1px;
    }

    /*
==============================================================
    Checkout Area Css
==============================================================
*/

    .checkout_form_title {
        text-align: center;
        margin-bottom: 30px;
    }

    .checkout_form_title h3 {
        font-size: 26px;
        font-weight: 600;
        text-transform: uppercase;
    }

    .checkout_form {
        background-color: var (--white);
        padding: 30px;
        border-radius: 3px;
        border: 1px solid var(--border);
        border-radius: 9px;
    }

    .checkout_form_group select {
        color: #999 !important;
    }

    .checkout_form_group select option {
        color: black !important;
    }

    .checkout_form_group {
        margin-bottom: 15px;
        position: relative;
    }

    .checkout_form_checkbox_group {
        margin-bottom: 15px;
    }

    .checkout_form_group i {
        position: absolute;
        bottom: 17px;
        transform: revert-layer;
        color: #999;
        right: 10px;
    }

    .checkout_form_group input {
        padding-right: 30px;
    }

    .checkout_form_group label {
        display: block;
        margin-bottom: 8px;
        font-size: 16px;
        font-weight: 500;
    }

    .required_r {
        color: red;
        font-size: 20px;
    }

    .checkout_form_group input,
    .checkout_form_group select,
    .checkout_form_group textarea {
        width: 100%;
        border: 1px solid var(--border);
        padding: 10px 10px;
        border-radius: 6px;
        font-size: 16px;
        background-color: rgb(241 245 249);
    }

    .checkout_form_checkbox.form-check {
        padding-left: 0;
        margin-bottom: 0;
        border: 1px solid var(--border);
        padding: 8px 10px;
        display: flex;
        align-items: center;
    }

    .checkout_form_checkbox.border_top_none {
        border-top: none !important;
    }

    .checkout_form_checkbox.form-check .form-check-input {
        margin-left: 0;
        cursor: pointer;
        border: 1px solid var(--primary_color) !important;
    }

    .checkout_form_checkbox.form-check label {
        padding-left: 10px;
        cursor: pointer;
        width: 100%;
    }

    .checkout_form_checkbox_group h4 {
        font-weight: 500;
        margin-bottom: 8px;
        font-size: 16px;
    }

    .checkout_form_checkbox.form-check .form-check-input:checked {
        background-color: var(--primary_color) !important;
        border-color: var(--primary_color) !important;
    }

    .checkout_form_checkbox.form-check .form-check-input:focus {
        box-shadow: inherit !important;
    }

    .price_payable_amount_text {
        font-weight: 600 !important;
        font-size: 18px;
    }

    .checkout_form_checkbox_group_box {
        border: 1px solid #eee;
        border-radius: 8px;
    }

    .checkout_form_checkbox.form-check:last-child {
        border-bottom: none;
    }





    .checkout_form_group .checkout_form_select {
        padding: 12px 10px;
    }

 
    .checkout_form_btn {
        text-align: center;
        margin-top: 20px;
        position: sticky;
        bottom: 12px;
        left: 50%;
        z-index: 3;
        padding: 0px 8px;
    }

    .checkout_form_btn_link {
        border: none;
        background-color: var(--primary_color);
        color: var(--primary_text_color);
        display: flex;
        transition: 0.3s;
        width: 100%;
        align-items: center;
        justify-content: center;
        gap: 8px;
        font-weight: 500;
        padding: 10px 0px;
        border-radius: 3px;
    }

    .checkout_form_btn_link:hover {
        color: var(--primary_hover_color);
    }

    .checkout_form_container {
        background-color: var(--white);
        padding: 20px;
        border-radius: 10px;
        border: 1px solid var(--border);
    }

    .checkout_order_summary {
        background-color: var(--white);
        padding: 30px;
        border-radius: 10px;
        border: 1px solid var(--border);
        height: 100%;
    }

    .payment_methods_img {
        margin-top: 14px;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .payment_methods_img ul {
        display: flex;
        gap: 10px;
        list-style: none;
    }

    .payment_images {
        width: 150px;
        cursor: pointer;
        transition: transform 0.3s ease;
    }

    .payment_images img {
        width: 100%;
        height: 100%;
        cursor: pointer;
        border: 2px solid #ddd;
        border-radius: 4px
    }

    .active_payment {
        border: 2px solid var(--primary_color);
        border-radius: 4px
    }

    .order_summary_title {
        text-align: center;
        margin-bottom: 20px;
        font-size: 22px;
        font-size: 24px;
        font-weight: 400;
        margin-top: 30px;
    }



    .order_summary_table {
        overflow-x: auto;
    }

    /* width */
    .order_summary_table::-webkit-scrollbar {
        height: 3px;
    }

    /* Track */
    .order_summary_table::-webkit-scrollbar-track {
        background: #f1f1f1;
    }

    /* Handle */
    .order_summary_table::-webkit-scrollbar-thumb {
        background: #888;
    }

    /* Handle on hover */
    .order_summary_table::-webkit-scrollbar-thumb:hover {
        background: #555;
    }

    .order_summary_table .table thead tr th {
        font-weight: 500;
    }

    .order_summary_table tbody,
    td,
    tfoot,
    th,
    thead,
    tr {
        border-color: var(--border) !important;
        border-style: solid;
        border-width: 0;
    }

    .order_summary_table table>:not(caption)>*>* {
        padding: .5rem .5rem;
        border-bottom-width: 1px;
    }

    .checkout_product_name_image {
        width: 50px;
        height: 50px;
        float: left;
        margin-right: 7px;
        display: block;
        overflow: hidden;
        border-radius: 4px;
        border: 1px solid #eee;
    }

    .checkout_product_name_image img {
        width: 100%;
        height: 100%;
        border-radius: 3px;
    }

    .products_checkout_name {
        display: block;
        overflow: hidden;
        height: 100%;
        display: flex;
    }

    .products_checkout_name p {
        line-height: 22px;
        font-size: 14px;
        width: max-content;
        white-space: normal;
    }

    .checkout_product_name_image p {
        font-size: 14px;
        line-height: 18px;
    }

    .checkout_product_qty {
        width: 85px;
        display: flex;
    }

    .checkout_product_qty_minus {
        border: 1px solid var(--border);
        color: #838383;
        width: 25px;
        height: 25px;
        line-height: 25px;
        text-align: center;
        border-right: 0px;
        border-radius: 3px 0px 0px 3px;
        cursor: pointer;
        background-color: transparent;
        font-size: 12px;
        display: block;
        float: left;
        transition: all .3s ease;
    }

    .checkout_product_qty_minus:hover {
        color: var(--primary_text_color);
        background-color: var(--primary_color);
    }

    .checkout_product_qty input {
        border: 1px solid var(--border);
        color: #838383;
        width: 30px;
        height: 25px;
        line-height: 25px;
        text-align: center;
        float: left;
        font-size: 14px;
        display: block;
    }

    .checkout_product_qty_plus {
        border: 1px solid var(--border);
        color: #838383;
        width: 25px;
        height: 25px;
        line-height: 25px;
        text-align: center;
        border-left: 0px;
        border-radius: 0px 3px 3px 0px;
        cursor: pointer;
        background-color: transparent;
        font-size: 12px;
        display: block;
        transition: all .3s ease;
    }

    .checkout_product_qty_plus:hover {
        color: var(--primary_text_color);
        background-color: var(--primary_color);
    }

    .checkout_product_price p {
        font-size: 14px;
        width: max-content;
        font-weight: 500;
    }

    .checkout_product_delete_icon {
        text-align: right;
    }

    .checkout_product_total_price p {
        font-size: 14px;
        width: max-content;
        font-weight: 500;
    }

    .checkout_product_delete_icon_link {
        border: none;
        background-color: transparent;
        color: red;
        font-size: 16px;
        cursor: pointer;
    }




    .checkout_form_btn_link {
        -webkit-animation: 1.40s both rsiShaker1 infinite;
        animation: 1.40s both rsiShaker1 infinite
    }

    @-webkit-keyframes rsiShaker1 {

        0%,
        to {
            -webkit-transform: scaleX(1);
            transform: scaleX(1)
        }

        10%,
        20% {
            -webkit-transform: scale3d(.97, .97, .97) rotate(-1deg);
            transform: scale3d(.97, .97, .97) rotate(-1deg)
        }

        30%,
        50%,
        70%,
        90% {
            -webkit-transform: scale3d(1.03, 1.03, 1.03) rotate(1deg);
            transform: scale3d(1.03, 1.03, 1.03) rotate(1deg)
        }

        40%,
        60%,
        80% {
            -webkit-transform: scale3d(1.03, 1.03, 1.03) rotate(-1deg);
            transform: scale3d(1.03, 1.03, 1.03) rotate(-1deg)
        }
    }

    @keyframes rsiShaker1 {

        0%,
        to {
            -webkit-transform: scaleX(1);
            transform: scaleX(1)
        }

        10%,
        20% {
            -webkit-transform: scale3d(.97, .97, .97) rotate(-1deg);
            transform: scale3d(.97, .97, .97) rotate(-1deg)
        }

        30%,
        50%,
        70%,
        90% {
            -webkit-transform: scale3d(1.03, 1.03, 1.03) rotate(1deg);
            transform: scale3d(1.03, 1.03, 1.03) rotate(1deg)
        }

        40%,
        60%,
        80% {
            -webkit-transform: scale3d(1.03, 1.03, 1.03) rotate(-1deg);
            transform: scale3d(1.03, 1.03, 1.03) rotate(-1deg)
        }
    }





    .checkout_product_td_left {
        padding-left: 0px !important;
    }

    .checkout_product_td_right {
        text-align: right;
        padding-right: 0px !important;
    }

    .price_summary_table_cell {
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
        -webkit-box-pack: justify;
        -ms-flex-pack: justify;
        justify-content: space-between;
        border-bottom: 1px solid var(--border);
        padding: 10px 0px;
    }

    .price_summary_table_cell:last-child {
        border-bottom: 0px;
        padding-bottom: 0px;
    }

    .price_summary_table_cell strong {
        font-weight: 400;
    }

    .apply_coupon_group label {
        display: block;
        margin-bottom: 3px;
    }

    .apply_coupon_item {
        display: flex;
        align-items: center;
        margin-bottom: 20px;
        cursor: pointer;
    }

    .apply_coupon_item:hover {
        display: flex;
        align-items: center;
        margin-bottom: 20px;
        cursor: pointer;
        color: var(--primary_hover_color);

    }

    .apply_coupon_item input {
        width: 100%;
        border: 1px solid var(--border);
        padding: 10px 10px;
        border-radius: 3px;
    }

    .apply_coupon_item_link {
        border: none;
        background-color: var(--primary_color);
        color: var(--primary_text_color);
        display: inline-block;
        padding: 10px 25px;
        border-radius: 3px;
        margin-left: 15px;
        transition: .3s;
    }

    .apply_coupon_item_link:hover {
        color: var(--primary_hover_color);
    }

    /*
==============================================================
    Success Area Css
==============================================================
*/
    .success_icon {
        background-color: green;
        color: var(--white);
        width: 50px;
        height: 50px;
        line-height: 50px;
        text-align: center;
        font-size: 25px;
        border-radius: 50%;
        margin: 0 auto;
    }

    .error_icon {
        background-color: rgb(245, 3, 3);
        color: var(--white);
        width: 50px;
        height: 50px;
        line-height: 50px;
        text-align: center;
        font-size: 25px;
        border-radius: 50%;
        margin: 0 auto;
    }

    .success_title {
        margin-top: 30px;
        margin-bottom: 10px;
    }

    .success_title h3 {
        font-size: 22px;
    }

    .success_call_link {
        color: var(--primary_color);
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .success_call_link:hover {
        color: var(--primary_color);
    }

    .success_btn {
        margin-top: 20px;
    }

    .success_btn_link {
        display: inline-block;
        color: var(--primary_text_color);
        background-color: var(--primary_color);
        padding: 10px 15px;
        border-radius: 3px;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .success_btn_link:hover {
        color: var(--primary_hover_color);
    }

    .price_payable_amount_text {
        font-weight: 600 !important;
        font-size: 18px;
    }

    /*
==============================================================
    Order Tracking Area Css
==============================================================
*/
    .order_tracking_content {
        -webkit-box-shadow: var(--shadow);
        box-shadow: var(--shadow);
        padding: 50px;
        border-radius: 3px;
    }

    .order_tracking_header {
        padding-bottom: 30px;
        margin-bottom: 20px;
        border-bottom: 1px solid var(--border);
    }

    .order_tracking_title {
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
        gap: 20px;
        margin-bottom: 10px;
    }

    .order_tracking_search input {
        width: 100%;
        border: 1px solid var(--primary_color);
        padding: 10px 20px;
        border-radius: 3px;
    }

    .order_tracking_search_btn_link {
        border: none;
        background-color: var(--primary_color);
        color: var(--white);
        width: 100%;
        height: 100%;
        display: block;
        font-size: 20px;
        padding: 11px 0px;
        border-radius: 3px;
    }

    .order_tracking_invoice strong {
        margin-right: 5px;
    }

    .order_tracking_customer_item {
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
        gap: 10px;
        margin-top: 5px;
    }

    .order_tracking_order_status_details {
        float: right;
    }

    .order_tracking_order_status {
        margin-top: 5px;
    }

    .order_tracking_order_status span {
        background-color: var(--primary_color);
        color: var(--white);
        display: inline-block;
        padding: 3px 20px;
        border-radius: 30px;
    }

    .order_tracking_order_cod span {
        font-weight: 500;
        font-size: 18px;
    }

    .order_tracking_sender_information {
        margin-top: 15px;
        margin-bottom: 15px;
    }

    .order_tracking_sender_organization {
        margin-top: 15px;
    }

    .order_tracking_sender_title {
        text-align: center;
        background-color: #dddddd;
    }

    .order_tracking_sender_title h3 {
        font-size: 20px;
        font-weight: 400;
        padding: 10px 0px;
    }

    .order_tracking_sender_organization h3 {
        font-size: 22px;
        font-weight: 500;
    }

    .order_tracking_sender_address p {
        margin-top: 5px;
    }

    .order_tracking_sender_address_link {
        color: var(--black);
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .order_tracking_sender_address_link:hover {
        color: var(--primary_color);
    }

    .order_tracking_sender_address strong {
        margin-right: 5px;
    }

    .order_tracking_courier_title {
        text-align: center;
        background-color: #dddddd;
        margin-bottom: 15px;
    }

    .order_tracking_courier_title h3 {
        font-size: 20px;
        font-weight: 400;
        padding: 10px 0px;
    }

    .order_tracking_courier_name h3 {
        font-size: 22px;
        font-weight: 500;
    }

    /*
==============================================================
    Fixed Footer Menu Area Css
==============================================================
*/
    .fixed_footer_menu {
        background-color: var(--white);
        -webkit-box-shadow: var(--shadow);
        box-shadow: var(--shadow);
        position: fixed;
        bottom: 0;
        left: 0;
        width: 100%;
        padding: 0px 15px;
        padding-top: 5px;
        padding-bottom: 3px;
        z-index: 999;
        display: none;
    }

    .fixed_footer_menu ul {
        margin: 0;
        padding: 0;
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
        -webkit-box-pack: justify;
        -ms-flex-pack: justify;
        justify-content: space-between;
    }

    .fixed_footer_menu ul li {
        list-style: none;
    }

    .fixed_footer_menu ul li .fixed_footer_menu_link {
        text-align: center;
        position: relative;
        text-align: center;
        display: block;
    }

    .fixed_footer_menu ul li .fixed_footer_menu_link svg {
        color: var(--primary_color);
    }

    .fixed_footer_menu ul li .fixed_footer_menu_link p {
        font-size: 13px;
        display: block;
        line-height: 14px;
        margin-top: 3px;
    }

    .fixed_footer_menu ul li .fixed_footer_menu_link i {
        display: block;
        color: var(--primary_color);
        font-size: 24px;
    }

    .fixed_footer_menu ul li .fixed_footer_menu_link:hover {
        color: var(--primary_color);
    }

    .fixed_footer_cart_count {
        position: absolute;
        top: 0;
        right: 0;
        display: block;
        width: 16px;
        height: 16px;
        line-height: 17px;
        text-align: center;
        background-color: var(--primary_color);
        color: var(--white);
        font-size: 10px;
        border-radius: 50%;
        margin-top: 2px;
        margin-right: -11px;
    }

    .fixed_footer_wishlist_count {
        position: absolute;
        top: 0;
        right: 0;
        display: block;
        width: 15px;
        height: 15px;
        line-height: 15px;
        text-align: center;
        background-color: var(--black);
        color: var(--white);
        font-size: 11px;
        border-radius: 50%;
        margin-top: -9px;
        margin-right: 4px;
    }

    .fixed_footer_menu_home {}

    .fixed_footer_menu_home svg {}

    .fixed_footer_menu_category {}

    .fixed_footer_menu_category svg {
        width: 27px;
    }

    .fixed_footer_menu_cart {}

    .fixed_footer_menu_cart svg {
        width: 25px;
    }

    .fixed_footer_menu_call {}

    .fixed_footer_menu_call svg {
        width: 19px;
    }

    .fixed_footer_menu_auth {}

    .fixed_footer_menu_auth svg {
        width: 22px;
    }

    /*
==============================================================
    Profile Area Css
==============================================================
*/
    .profile_left_side {
        border: 1px solid var(--border);
        border-radius: 3px;
        padding: 20px;
    }

    .profile_pic {
        width: 150px;
        margin: 0 auto;
    }

    .profile_pic img {
        max-width: 100%;
        height: auto;
    }

    .profile_name {
        text-align: center;
        margin-top: 15px;
    }

    .profile_name h5 {
        height: 25px;
        line-height: 25px;
        overflow: hidden;
    }

    .profile_menu_list {
        margin-top: 20px;
    }

    .profile_menu_list ul {
        margin: 0;
        padding: 0;
    }

    .profile_menu_list ul li {
        list-style: none;
        display: block;
        border-bottom: 1px solid var(--border);
        padding: 10px 0px;
    }

    .profile_menu_list ul li:last-child {
        border-bottom: 0px;
        padding-bottom: 0px;
    }

    .profile_menu_list ul li .profile_menu_list_link {
        display: block;
        color: var(--black);
        font-size: 16px;
        text-transform: uppercase;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .profile_menu_list ul li.active .profile_menu_list_link {
        color: var(--primary_color);
    }

    .profile_menu_list ul li .profile_menu_list_link:hover {
        color: var(--primary_color);
    }

    .profile_menu_list ul li .profile_menu_list_link i {
        padding-right: 8px;
    }

    .profile_oder_view_link {
        background-color: var(--primary_color);
        color: var(--primary_text_color);
        display: inline-block;
        padding: 3px 10px;
        font-size: 16px;
        border-radius: 3px;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .profile_oder_view_link:hover {
        color: var(--primary_hover_color);
    }

    .profile_oder_cancel_btn {
        border: none;
        background-color: #df5c39;
        color: var(--white);
        font-size: 14px;
        padding: 3px 10px;
        display: inline-block;
        border-radius: 3px;
        margin-bottom: 4px;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .profile_oder_cancel_btn:hover {
        color: var(--black);
    }

    .order_status {
        background-color: var(--primary_color);
        color: var(--white);
        font-size: 13px;
        display: inline-block;
        padding: 0px 5px;
        border-radius: 20px;
    }

    .order_discount {
        background-color: var(--primary_color);
        color: var(--primary_text_color);
        font-size: 13px;
        display: inline-block;
        border-radius: 20px;
        text-align: center;
        padding: 0px 5px;
    }

    .profile_right_side {
        border: 1px solid var(--border);
        padding: 20px;
        border-radius: 3px;
    }

    .profile_form_item {
        margin-bottom: 10px;
    }

    .profile_address_details {
        border: 1px solid var(--border);
        padding: 20px;
        border-radius: 3px;
    }

    .profile_shipping_address h3 {
        font-size: 28px;
        margin-bottom: 10px;
        border-bottom: 1px solid var(--border);
        padding-bottom: 10px;
    }

    .profile_shipping_address_list ul li {
        margin-bottom: 10px;
        list-style: none;
    }

    .profile_shipping_address_list ul li:last-child {
        margin-bottom: 0px;
    }

    .profile_form_item label {
        display: block;
        margin-bottom: 2px;
    }

    .profile_form_item input,
    select {
        display: block;
        width: 100%;
        border: 1px solid var(--border);
        border-radius: 3px;
        padding: 10px 15px;
    }

    .profile_form_submit_btn_link {
        display: block;
        width: 100%;
        border: none;
        background-color: var(--primary_color);
        color: var(--primary_text_color);
        padding: 10px 0px;
        font-size: 18px;
        border-radius: 3px;
        transition: .3s;
    }

    select.profile_edit_select {
        padding: 12px 10px;
    }

    .profile_form_submit_btn_link:hover {
        color: var(--primary_hover_color);
    }

    .profile_page_details h5 {
        margin-bottom: 10px;
    }

    .order_details img {
        width: 50px;
        height: 50px;
        float: left;
        margin-right: 10px;
    }

    .order_details_items {
        width: 100%;
        overflow: hidden;
    }

    .order_details_items_img {
        width: 50px;
        height: 50px;
        float: left;
        margin-right: 10px;
        display: block;
        overflow: hidden;
    }

    .order_details_items img {
        width: 100%;
        height: 100%;
    }

    .profile_page_order_view table tbody tr td strong {
        width: 120px !important;
        display: block;
    }

    .profile_page_order_view table thead tr th {
        font-weight: 400;
    }

    .profile_heading h3 {
        font-weight: 400;
        font-size: 22px;
    }

    .profile_page_order_view {
        position: relative;
    }

    .no_order_products p {
        position: absolute;
        bottom: -15px;
        left: 50%;
        transform: translate(-50%);
        color: red;
    }

    .max_content {
        white-space: nowrap;
    }

    .order_details.order_details_items {
        padding: 0;
        background-color: transparent;
        margin-top: 0;
    }

    /*
==============================================================
    Auth Area Css
==============================================================
*/
    .is_error {
        color: red;
        font-size: 14px;
    }

    .auth_wrap {
        border: 1px solid var(--border);
        padding: 25px;
        border-radius: 3px;
    }

    .auth_title {
        text-align: center;
        margin-bottom: 40px;
    }

    .auth_item {
        margin-bottom: 10px;
    }

    .auth_item label {
        display: block;
        margin-bottom: 2px;
    }

    .auth_item input {
        width: 100%;
        border: 1px solid var(--border);
        border-radius: 3px;
        padding: 10px 15px;
    }

    .auth_sub_btn_link {
        display: block;
        width: 100%;
        border: none;
        background-color: var(--primary_color);
        color: var(--primary_text_color);
        padding: 10px 0px;
        border-radius: 3px;
        text-transform: uppercase;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
        font-size: 16px;
    }

    .auth_sub_btn_link:hover {
        color: var(--primary_hover_color);
    }

    .auth_sub_btn_two_link {
        display: block;
        width: 100%;
        border: none;
        background-color: var(--primary_color);
        color: var(--primary_text_color);
        padding: 10px 0px;
        border-radius: 3px;
        text-transform: uppercase;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
        font-size: 16px;
        text-align: center;
        margin-top: 10px;
    }

    .auth_sub_btn_two_link:hover {
        color: var(--primary_hover_color);
    }

    .auth_forgotten_pass {
        margin-bottom: 15px;
    }

    .auth_forgotten_pass_link {
        display: inline-block;
        color: var(--black);
        border-bottom: 1px solid var(--white);
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .auth_forgotten_pass_link:hover {
        color: var(--primary_color);
        border-bottom: 1px solid var(--primary_color);
    }

    .auth_link_page {
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
        gap: 10px;
        margin-top: 15px;
         justify-content: center;
    }

    .auth_link_page_link {
        color: var(--primary_color);
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .auth_link_page_link:hover {
        color: var(--primary_hover_color);
    }
     .divider {
        display: flex;
        align-items: center;
        margin: 20px 0;
        color: #999;
        font-size: 14px;
    }

    .divider::before,
    .divider::after {
        content: '';
        flex: 1;
        height: 1px;
        background: #e0e0e0;
    }

    .divider span {
        padding: 0 15px;
    }

    .google-btn {
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 12px;
        background: white;
        color: #333;
        border: 2px solid #e0e0e0;
        padding: 10px;
        margin-bottom: 25px;
        transition: all 0.3s ease;
    }

    .google-btn:hover {
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        transform: translateY(-2px);
    }

    /*
==========================================
    Contact Us Area Css
==========================================
*/
    .single_contact_us {
        background-color: var(--white);
        border: 1px solid var(--border);
        padding: 20px;
        height: 100%;
    }

    .contact_us_title {
        margin-bottom: 5px;
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
        gap: 5px;
    }

    .contact_us_title i {
        font-size: 18px;
        line-height: 28px;
        color: var(--black);
    }

    .contact_us_title strong {
        color: var(--black);
        font-size: 18px;
        line-height: 28px;
        font-weight: 500;
    }

    .contact_us_location p strong {
        font-weight: 400;
    }

    .contact_us_location p {
        color: var(--black);
    }

    .contact_us_communication ul {
        margin: 0;
        padding: 0;
    }

    .contact_us_communication ul li {
        list-style: none;
    }

    .contact_us_communication ul li .contact_us_communication_link {
        display: inline-block;
        color: var(--text);
        font-weight: 400;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .contact_us_communication ul li .contact_us_communication_link:hover {
        color: var(--themeColor);
    }

    .contact_us_socialmedia ul li {
        display: inline-block;
        margin-top: 5px;
        list-style: none;
    }

    .contact_us_socialmedia ul li .contact_us_socialmedia_link {
        display: block;
        width: 35px;
        height: 35px;
        text-align: center;
        line-height: 35px;
        background-color: var(--black);
        border: 1px solid var(--black);
        color: var(--white);
        font-size: 16px;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .contact_us_socialmedia ul li .contact_us_socialmedia_link:hover {
        color: var(--themeColor);
        background-color: var(--white);
        border: 1px solid var(--primary_color);
    }

    .contact_us_form_item input,
    .contact_us_form_item textarea,
    .contact_us_form_item select {
        width: 100%;
        border: 1px solid var(--border);
        padding: 10px;
        border-radius: 3px;
        color: var(--black);
    }

    .contact_us_form_btn_link {
        background-color: var(--primary_color);
        color: var(--primary_text_color);
        font-weight: 500;
        border: none;
        padding: 10px 20px;
        border-radius: 3px;
        display: block;
        width: 100%;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
        letter-spacing: 1px;
        text-transform: uppercase;
    }

    .contact_us_form_btn_link:hover {
        color: var(--primary_hover_color);
    }

    /*
==============================================================
    Customer Comment Area Css
==============================================================
*/
    .modal_content {
        padding: 20px;
    }

    .modal_comment_item {
        margin-bottom: 10px;
    }

    .modal_comment_item input {
        width: 100%;
        border: 1px solid var(--border);
        border-radius: 3px;
        outline: none;
        padding: 8px 10px;
    }

    .modal_comment_item_textarea textarea {
        width: 100%;
        border: 1px solid var(--border);
        border-radius: 3px;
        outline: none;
        padding: 8px 10px;
    }

    .modal_comment_item_btn {
        text-align: center;
    }

    .modal_comment_item_btn_link {
        border: none;
        padding: 8px 15px;
        background-color: var(--primary_color);
        color: var(--primary_text_color);
        border-radius: 3px;
        display: inline-block;
        transition: .3s;
    }

    .modal_comment_item_btn_link:hover {
        color: var(--primary_hover_color);
    }

    .modal_star_title h5 {
        font-size: 23px;
        text-transform: capitalize;
    }

    .modal_rating {
        float: left;
        margin-top: 15px;
        margin-bottom: 20px;
    }

    .modal_rating:not(:checked)>input {
        position: absolute;
        top: -9999px;
    }

    .modal_rating:not(:checked)>label {
        float: right;
        width: 1em;
        overflow: hidden;
        white-space: nowrap;
        cursor: pointer;
        font-size: 30px;
        color: #dddddd;
    }

    .modal_rating:not(:checked)>label:before {
        content: "★ ";
    }

    .modal_rating>input:checked~label {
        color: #ffc700;
    }

    .modal_close {
        text-align: right;
        font-size: 22px;
        cursor: pointer;
        position: absolute;
        top: 0;
        right: 0;
        margin-top: 8px;
        margin-right: 10px;
    }

    .fixed_product_card_size strong {
        font-weight: normal;
    }




    .customer_comment_title {
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
        gap: 20px;
    }

    .customer_comment_avarage_rating {
        font-size: 40px;
    }

    .customer_comment_rating_name {
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
        color: var(--primary_text_color);
        position: relative;
        background-color: var(--primary_color);
        padding: 0 12px 0 4px;
        height: 30px;
        font-size: 20px;
        border-radius: 2px 0 0 2px;
        background-size: 100% 100%;
        background-repeat: no-repeat;
        gap: 5px;
    }

    .customer_comment_rating_name:after {
        content: " ";
        position: absolute;
        right: -10px;
        width: 0;
        height: 0;
        border-top: 30px solid var(--primary_color);
        border-right: 10px solid transparent;
        border-left: 10px solid transparent;
    }

    .customer_comment_rating {
        margin-top: 25px;
        margin-bottom: 10px;
    }

    .customer_comment_rating_name i {
        font-size: 15px;
    }

    .customer_comment_rating span {
        color: var(--primary_color);
        font-size: 18px;
    }

    .comment_customer_name h5 {
        font-size: 16px;
    }

    .comment_customer_rating span {
        font-size: 14px;
    }

    .comment_customer_rating {
        margin-top: 8px;
        margin-bottom: 2px;
    }

    .customer_comment_review_content {
        max-height: 450px;
        overflow: auto;
    }

    .customer_comment_review_content::-webkit-scrollbar {
        width: 5px;
    }

    .customer_comment_review_content::-webkit-scrollbar-thumb {
        background: var(--primary_color);
    }

    .customer_comment_list ul {
        margin: 0;
        padding: 0;
    }

    .customer_comment_list ul li {
        display: block;
        overflow: hidden;
        list-style: none;
        border-top: 1px solid var(--border);
        padding: 20px 0px;
        list-style: none;
    }

    .customer_comment_btn {
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
        -webkit-box-pack: center;
        -ms-flex-pack: center;
        justify-content: center;
        height: 100%;
    }

    .customer_comment_btn_link {
        border: 1px solid var(--border);
        padding: 10px 20px;
        border-radius: 3px;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .customer_comment_btn_link:hover {
        color: var(--primary_color);
    }

    .customer_comment_item {
        width: 100%;
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
        overflow: hidden;
        -webkit-box-pack: center;
        -ms-flex-pack: center;
        justify-content: center;
        gap: 10px;
        margin-bottom: 10px;
    }

    .customer_comment_item_star {
        width: 100px;
    }

    .customer_comment_item_star span {
        font-size: 14px;
        line-height: 24px;
    }

    .customer_comment_item_percentage_segment {
        width: 200px;
        background-color: var(--border);
        height: 10px;
        display: block;
    }

    .customer_comment_item_percentage {
        width: 40px;
        text-align: right;
    }

    .customer_comment_item_percentage_segment span {
        background-color: var(--black);
        height: 10px;
        display: block;
    }

    .customer_comment_image img {
        width: 75px;
        height: 75px;
        float: left;
        margin-right: 5px;
    }

    .customer_comment_image {
        margin-top: 10px;
    }

    .customer_comment_view_all_link {
        color: var(--black);
        border-bottom: 1px solid;
        display: inline-block;
        font-weight: 400;
        font-size: 22px;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .customer_comment_view_all_link:hover {
        color: var(--primary_color);
    }

    .customer_comment_view_all {
        text-align: center;
    }

    .comments_pagination {
        text-align: right;
        margin-bottom: 10px;
        margin-top: 10px;
    }

    .comments_pagination ul {
        display: inline-block;
        margin: 0;
        padding: 0;
    }

    .comments_pagination ul li {
        list-style: none;
        float: left;
        border-left: 1px solid var(--border);
        border-top: 1px solid var(--border);
        border-bottom: 1px solid var(--border);
    }

    .comments_pagination ul li:last-child {
        border-right: 1px solid var(--border);
    }

    .comments_pagination ul li .comments_pagination_link {
        color: var(--black);
        display: inline-block;
        padding: 3px 15px;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .comments_pagination ul li .comments_pagination_link:hover {
        color: var(--primary_color);
    }

    .comments_pagination_active {
        background-color: var(--primary_color);
    }

    .comments_pagination_active:hover {
        color: var(--black) !important;
    }

    /*
==============================================================
    Fixed Product Cart Area Css
==============================================================
*/
    .fixed_product_sticky {
        position: fixed;
        top: 40%;
        right: 0;
        background: var(--white);
        box-shadow: var(--shadow);
        cursor: pointer;
        z-index: 888888;
        border: 1px solid var(--primary_color);
    }

    .fixed_product_sticky_icon {
        text-align: center;
        margin-top: 5px;
        line-height: 1;
    }

    .fixed_product_sticky_icon i {
        color: var(--primary_color);
        font-size: 22px;
    }

    .fixed_product_sticky_price {
        text-align: center;
    }

    .fixed_product_sticky_price p {
        font-size: 14px;
        padding: 1px 10px;
        padding-top: 0px;
        color: var(--black);
    }

    .fixed_product_sticky_count {
        text-align: center;
    }

    .fixed_product_sticky_count p {
        background-color: var(--primary_color);
        color: var(--primary_text_color);
        font-size: 14px;
        padding: 0px 10px;
        transition: .3s;
    }

    .fixed_product_sticky:hover .fixed_product_sticky_count p {
        color: var(--primary_hover_color);
    }

    .fixed_product_card_content {
        /* right: 8px; */
        width: 460px;
        z-index: 999999999999;
    }

    .fixed_product_card_header {
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
        -webkit-box-pack: justify;
        -ms-flex-pack: justify;
        justify-content: space-between;
        padding: 10px;
        padding-right: 15px;
        border-bottom: 1px solid var(--border);
    }

    .fixed_product_card_header_icon {
        position: relative;
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
        gap: 10px;
    }

    .fixed_product_card_header_icon i {
        font-size: 25px;
        color: var(--primary_color);
    }

    .fixed_product_card_header_icon svg {
        width: 25px;
        color: var(--primary_color);
    }

    .fixed_product_card_header_icon span {
        background-color: var(--primary_color);
        color: var(--primary_text_color);
        display: inline-block;
        width: 18px;
        height: 18px;
        line-height: 18px;
        text-align: center;
        border-radius: 20px;
        font-size: 12px;
        position: absolute;
        top: 0;
        right: -13px;
    }

    .fixed_product_card_header_close i {
        font-size: 20px;
        background-color: #dddddd;
        color: red;
        display: inline-block;
        padding: 5px 9px;
        cursor: pointer;
        border-radius: 100%;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .fixed_product_card_header_close i:hover {
        color: var(--primary_color);
    }

    .fixed_product_card_list {
        max-height: 700px;
        overflow-y: auto;
        padding-bottom: 300px;
    }

    .fixed_product_card_list ul {
        margin: 0;
        padding: 0;
    }

    .fixed_product_card_list ul li {
        list-style: none;
        display: block;
        overflow: hidden;
        border-bottom: 1px solid var(--border);
        padding: 5px 10px;
        padding-right: 15px;
    }

    .fixed_product_card_list ul li:last-child {
        border-bottom: 0px;
    }

    .fixed_product_card_list_table_cell {
        /* display: -webkit-box; */
        display: -ms-flexbox;
        display: flex;
        gap: 15px;
        /* border-bottom: 1px solid var(--border); */
        /* padding: 5px 0px; */
        /* padding-right: 10px; */
    }

    .fixed_product_card_image img {
        width: 70px;
        border-radius: 3px;
    }

    .fixed_product_card_details {
        width: 100%;
    }

    .fixed_product_card_name p {
        margin-top: -3px;
        overflow: hidden;
        width: 100%;
        display: -webkit-box;
        -webkit-line-clamp: 2;
        -webkit-box-orient: vertical;
    }

    .fixed_product_card_name_size_delete {
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-pack: justify;
        -ms-flex-pack: justify;
        justify-content: space-between;
    }

    .fixed_product_card_name h5 {
        font-size: 16px;
        line-height: 22px;
        color: var(--black);
    }

    .fixed_product_card_delete_icon {
        width: 40px;
        text-align: right;
    }

    .fixed_product_card_delete_icon i {
        color: var(--black);
        font-size: 18px;
        cursor: pointer;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .fixed_product_card_delete_icon i:hover {
        color: var(--primary_color);
    }

    .fixed_product_card_qty_minus {
        float: left;
    }

    .fixed_product_card_qty_minus i {
        width: 25px;
        height: 25px;
        line-height: 25px;
        text-align: center;
        border: 1px solid var(--border);
        border-right: 0px;
        border-radius: 3px 0px 0px 3px;
        color: #979797;
        cursor: pointer;
        font-size: 13px;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .fixed_product_card_qty input {
        width: 40px;
        border: 1px solid var(--border);
        height: 25px;
        text-align: center;
        float: left;
        color: #979797;
        cursor: pointer;
        font-size: 13px;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .fixed_product_card_qty_plus {
        float: left;
    }

    .fixed_product_card_qty_plus i {
        width: 25px;
        height: 25px;
        line-height: 25px;
        text-align: center;
        border: 1px solid var(--border);
        border-left: 0px;
        border-radius: 0px 3px 3px 0px;
        color: #979797;
        cursor: pointer;
        font-size: 13px;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .fixed_product_card_qty_price {
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
        -webkit-box-pack: justify;
        -ms-flex-pack: justify;
        justify-content: space-between;
        margin-top: 5px;
    }

    .fixed_product_card_close_price p {
        font-size: 16px;
        color: var(--black);
    }

    .fixed_product_card_footer {
        position: absolute;
        bottom: 0;
        left: 0;
        right: 0;
        width: 100%;
        padding: 10px;
        padding-right: 15px;
        background-color: #f5f6f7;
    }

    .fixed_product_card_footer_count {
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
        -webkit-box-pack: justify;
        -ms-flex-pack: justify;
        justify-content: space-between;
        padding-top: 10px;
    }

    .fixed_product_card_footer_count strong {
        font-size: 20px;
        font-weight: 400;
    }

    .fixed_product_card_footer_count strong i {
        font-size: 26px;
        padding-right: 3px;
    }

    .fixed_product_card_footer_checkout {
        margin-top: 20px;
        margin-bottom: 10px;
    }

    .fixed_product_card_footer_checkout_link {
        display: block;
        width: 100%;
        background-color: var(--primary_color);
        text-align: center;
        color: var(--white);
        font-size: 18px;
        padding: 10px 0px;
        font-weight: 500;
        border-radius: 3px;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .fixed_product_card_footer_checkout_link:hover {
        color: var(--primary_hover_color);
    }

    .fixed_product_card_footer_view_cart {
        text-align: center;
    }

    .fixed_product_card_footer_view_cart_link {
        font-weight: 500;
        text-align: center;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
        background-color: var(--black);
        color: var(--white);
        display: block;
        padding: 10px 0px;
        border-radius: 3px;
    }

    .fixed_product_card_footer_view_cart_link:hover {
        color: var(--primary_color);
    }

    /* scroll css */
    .fixed_product_card_list::-webkit-scrollbar {
        width: 5px;
    }

    .fixed_product_card_list::-webkit-scrollbar-track {
        background: var(--white);
    }

    .fixed_product_card_list::-webkit-scrollbar-thumb {
        background: var(--primary_color);
    }

    .fixed_product_card_list::-webkit-scrollbar-thumb:hover {
        background: #555;
    }




    /*
==============================================================
    Related Product Area Css
==============================================================
*/
    .related_side_products {
        background-color: #F4F6F9;
        padding: 20px;
        padding-top: 15px;
        padding-bottom: 15px;
        border-radius: 5px;
    }

    .related_product_img {
        width: 74px;
        float: left;
        margin-right: 10px;
        display: block;
        overflow: hidden;
    }

    .related_product_price {
        margin-top: 5px;
    }

    .related_product_item_link {
        display: block;
        overflow: hidden;
    }

    .related_product_name h6 {
        font-weight: 400;
        overflow: hidden;
        width: 100%;
        display: -webkit-box;
        -webkit-line-clamp: 2;
        -webkit-box-orient: vertical;
        font-size: 15px;
        transition: .3s;
    }

    .related_product_name h6:hover {
        color: var(--primary_color);
    }

    .related_product_sale_price {
        color: var(--black);
        font-weight: 400;
        font-size: 14px;
    }

    .related_product_discount_price {
        color: red;
        text-decoration: line-through;
        margin-left: 5px;
        font-size: 14px;
    }

    .related_product_content {
        display: block;
        overflow: hidden;
    }

    .related_product_item_link {
        display: block;
        overflow: hidden;
        border-bottom: 1px solid var(--border);
        padding: 5px 0px;
    }

    .related_product_item_link:last-child {
        border-bottom: 0px;
    }

    .related_product_img img {
        border-radius: 3px;
    }

    .related_side_products {
        margin-top: 16px;
    }

    .related_side_products {
        position: relative;
    }

    .related_side_products .owl-nav {
        position: absolute;
        display: flex;
        align-items: center;
        gap: 13px;
        font-size: 18px;
        bottom: 20px;
        left: 50%;
        transform: translateX(-50%);
        display: none;
    }

    .related_side_products .owl-nav .owl-prev i {
        width: 30px;
        height: 30px;
        border: 1px solid var(--primary_color);
        color: var(--primary_color);
        display: flex;
        align-items: center;
        justify-content: center;
        border-radius: 50%;
        transition: 0.5s ease-in-out;
    }

    .related_side_products .owl-nav .owl-next i {
        width: 30px;
        height: 30px;
        border: 1px solid var(--primary_color);
        color: var(--primary_color);
        display: flex;
        align-items: center;
        justify-content: center;
        border-radius: 50%;
        transition: 0.5s ease-in-out;
    }



    /*
==============================================================
    Load More Area Css
==============================================================
*/
    .load_more_details {
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 10px;
        border: 1px solid var(--primary_color);
        border-radius: 3px;
        cursor: pointer;
        width: 200px;
        text-align: center;
        margin: 0 auto;
        padding: 10px 5px;
        transition: 0.3s;
    }

    .load_more_details p,
    .load_more_details i {
        transition: 0.3s;
    }

    .load_more_details:hover {
        gap: 15px;
    }

    .load_more_details:hover p,
    .load_more_details:hover i {
        color: var(--primary_color);
    }

    .load_more_bar {
        width: 50%;
        height: 5px;
        background-color: #eeeeee;
        margin: 0 auto;
        margin-bottom: 35px;
    }

    .load_more_bar span {
        background-color: var(--primary_color);
        height: 5px;
        display: block;
    }

    /*==============================================================
success two section start
==============================================================
*/
    .success_header_area {
        background-color: #f8f6f8;
    }

    .success_header {
        background-color: #177e62;
        display: flex;
        justify-content: center;
        align-items: center;
        flex-direction: column;
        text-align: center;
        margin-top: 0;
        margin-bottom: 0;
        padding: 10px 0px;
    }

    .success_title {
        text-align: center;
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
    }

    .check_out_icon {
        background-color: #49c077;
        width: 43px;
        height: 43px;
        border-radius: 5px;
        display: flex;
        justify-content: center;
        align-items: center;
    }

    .check_out_icon i {
        font-size: xx-large;
        color: dimgrey;
    }

    .success_title h2 {
        color: white;
        font-weight: 600;
        margin-top: 20px;
    }

    .success_content_info {
        display: flex;
        justify-content: center;
        align-items: center;
        flex-direction: column;
    }

    .success_p {
        color: #1a1e23;
        font-family: "Inter", Sans-serif;
        font-size: 20px;
        font-weight: normal;
        letter-spacing: -0.5px;
        text-align: center;
        width: 800px;
        padding: 33px 0px;
        line-height: 30px;
    }

    .english_p {
        font-size: 25px !important;
    }

    .success_order_details {
        background-color: var(--white);
        border-style: solid;
        border-width: 1px 1px 1px 1px;
        border-color: #dee0e3;
        box-shadow: 0px 64px 80px -40px rgba(0, 0, 0, 0.12);
        border-radius: 12px 12px 12px 12px;
        width: 810px;
        height: auto;
        padding: 25px 40px;
    }

    .success_order_header {
        background-color: #f8f6f8;
        display: flex;
        gap: 20px;
        align-items: center;
        padding: 24px 40px;
    }

    .overview__order {
        display: inline-block;
        border-right: 1px dashed #ccc;
        padding: 0.5em 1em 0.5em 0;
        margin: 0.5em 0.5em 0.5em 0;
        list-style-type: none;
    }

    .overview__order:last-child {
        border-right: none;
    }

    .overview__order span {
        font-weight: 600;
        font-size: 13px;
        color: #746e6e;
    }

    .overview__order p {
        font-weight: 300;
    }

    .pay_deliveay_title {
        margin-top: 20px;
        font-size: 16px;
        font-weight: 300;
    }

    .order_details {
        padding: 24px 40px;
        background-color: #f8f6f8;
        margin-top: 15px;
    }

    .product_total {
        font-weight: 700;
        color: gray;
    }

    .checkout_product_th_total_price {
        white-space: nowrap;
    }

    table.order_details_table tr {
        margin-top: 25px;
    }

    .order_summary_table table thead tr th {
        font-weight: 400;
        color: var(--black);
        padding: 5px;
        font-size: 16px;
    }

    .order_summary_table table tbody tr td {
        padding-top: 5px;
    }

    .order_summary_table table {
        width: 100%;
    }

    .order_summary_table table thead tr {
        border-bottom: 1px solid var(--border);
    }

    .order_details_table td {
        font-size: 13px;
        padding-bottom: 10px;
    }

    .order_left_side {
        width: 413px;
    }

    .winter_warm_face_masks {
        border-top: 1px dashed #ccc;
        border-bottom: 1px dashed #ccc;
    }

    .winter_warm_td {
        padding-top: 5px;
    }

    /*
==============================================================
    404 Page Css
==============================================================
*/
    .page_404_area {
        text-align: center;
    }

    .page_404_image img {
        max-width: 50%;
    }

    .page_404_content {
        padding-top: 30px;
        padding-bottom: 30px;
    }

    .page_404_content p {
        margin-top: 10px;
        margin-bottom: 10px;
    }

    .go_back_btn {
        display: block;
        background-color: var(--primary_color);
        color: var(--primary_text_color);
        transition: .3s;
        width: max-content;
        margin: 0 auto;
        padding: 8px 15px;
        border-radius: 5px;
        margin-bottom: 20px;
        margin-top: 25px;
    }

    .go_back_btn:hover {
        color: var(--primary_hover_color);
    }





    /*
==============================================================
    Whatsapp Icon Css
==============================================================
*/
    .fixed_footer_whatsapp_icon {
        position: relative;
        background-color: #0DC043;
        color: var(--white);
        width: 40px;
        height: 40px;
        line-height: 40px;
        text-align: center;
        border-radius: 100%;
        position: fixed;
        bottom: 80px;
        right: 15px;
        z-index: 99;
    }

    .fixed_footer_whatsapp_icon .whatsapp_icon {
        color: var(--white);
        font-size: 25px;
    }

    .whatsapp_close i {
        position: absolute;
        top: -14px;
        right: -1px;
        color: var(--black);
        font-size: 18px;
        cursor: pointer;
    }

    .whatsapp_toggle {
        display: none;
    }

    /*
==============================================================
    Responsive Area Css
==============================================================
*/
    /*
==============================================================
     Custom Column Area Css
==============================================================
*/
    .col-xxxl-5 {
        padding-left: 7px;
        padding-right: 7px;
        float: left;
    }




    /* user and reseller login page start */
    .reseller_register_image {
        height: 340px;
    }

    .reseller_register_image img {
        width: 100%;
        height: 100%;
    }

    .reseller_register_btn {
        text-align: center;
        padding: 8px;
        background: var(--primary_color);
        width: 50%;
        border-radius: 10px;
        margin: 0 auto;
        margin-top: 20px;
    }

    .reseller_register_link {
        color: var(--white);
    }

    .reseller_register_image:hover {
        border: 1px solid red;
        border-radius: 2px;
    }

    .cart_order_modal_container {}

    .modal_cart_order_title {
        font-size: 17px;
        font-weight: 500;
    }

    .cart_order_modal_container .btn-close:focus {
        box-shadow: inherit !important;
    }

    .product_select_attribute_container p {
        font-size: 16px;
        font-weight: 400;
    }


    .product_select_attribute_modal ul li {
        display: flex;
        align-items: center;
        justify-content: space-between;
        background-color: #F5F4F4;
        padding: 10px 10px;
        border-radius: 4px;
        margin-top: 8px;
        list-style: none;
    }


    .cart_order_modal_container .modal-header {
        border-bottom: none !important;
        padding-bottom: 0 !important;
    }


    .select_price_btn_modal button {
        padding: 2px 9px;
        border-radius: 3px;
        border: none;
        display: block;
        text-align: center;
        background-color: var(--primary_color);
        color: var(--white);
        font-size: 15px;
        display: flex;
        align-items: center;
    }

    .product_select_attribute_container_modal p {
        font-weight: 500;
    }

    .select_order_button {
        background-color: #FFA500 !important;
    }

    .select_price_btn_modal {
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .select_price_btn_modal button i {
        margin-right: 6px;
    }

    .select_size_name_modal span {
        font-size: 15px;
        font-weight: 500;
        text-transform: uppercase;
    }

    span.select_price_modal {
        font-weight: 500;
        font-size: 15px;
        text-transform: uppercase;
    }

    .product_btn_link .img_svg_icon {
        margin-top: -2px;
        width: 19px;
        margin-right: 5px;
        filter: brightness(0) saturate(100%) invert(100%) sepia(0%) saturate(1%) hue-rotate(159deg) brightness(106%) contrast(101%);
    }

    .img_svg_icon {
        width: 19px;
        margin-right: 5px;
        filter: brightness(0) saturate(100%) invert(100%) sepia(0%) saturate(1%) hue-rotate(159deg) brightness(106%) contrast(101%);
    }



    .customer_slider_per_review {
        position: relative;
    }


    .customer_slider_per_review .owl-nav .owl-next {
        position: absolute;
        top: 50%;
        transform: translateY(-50%);
        right: 0;
    }

    .customer_slider_per_review .owl-nav .owl-prev {
        position: absolute;
        top: 50%;
        transform: translateY(-50%);
        left: 0;
    }


    .customer_review_icon {
        width: 30px;
        height: 30px;
        background-color: var(--primary_color);
        display: flex;
        align-items: center;
        justify-content: center;
        color: var(--white);
        border-radius: 50%;
        cursor: pointer;
    }

    .title_bottom_over_underline {
        height: 2px;
        max-width: 349px;
        background-color: var(--primary_color);
        margin: 0 auto;
        margin-top: -10.1px;
        margin-bottom: 12px;
    }

    .title_bottom_underline {
        color: gray;
        padding: 0.5px 0px;
    }



    .customer_slider_review_container {
        margin-top: 12px;
    }

    /*
==============================================================
 top service section start
 ==============================================================
*/


    .top_service_sigle_card {
        display: flex;
        align-items: center;
        justify-content: center;
        flex-direction: column;
    }


    .item_1 {
        background-color: #FFF3FF;
        position: relative;
        width: 110%;
        height: 100%;
    }


    .item_2 {
        clip-path: polygon(9% 0, 100% 0, 91% 100%, 0 100%);
        background: #FFEBFF;
        width: 112%;
        height: 100%;


    }

    .item_3 {
        background-color: #FCDEFB;
        clip-path: polygon(9% 0, 100% 0, 91% 100%, 0 100%);
        width: 112%;
        position: relative;
        height: 100%;

    }

    .item_4 {
        background-color: #FBD4FC;
        width: 100%;
        height: 100%;

    }

    .top_servie_item {
        text-align: center;
        padding: 22px 33px
    }

    .top_servie_item i {
        font-size: 22px;
        margin-bottom: 12px;
    }

    .top_servie_item h5 {
        font-size: 20px;
        margin-bottom: 6px;
    }

    .product_banner_overly {
        position: absolute;
        width: 100%;
        height: 100%;
        background: #121212;
        background: linear-gradient(179deg, #000000, #fff);
        opacity: 0.5;
        border-radius: 16px;
    }



    @media (min-width: 1499.99px) {
        .col-xxxl-5 {
            -webkit-box-flex: 0;
            -ms-flex: 0 0 auto;
            flex: 0 0 auto;
            width: 20%;
        }
    }

    @media only screen and (min-width: 1399.99px) {
        .container {
            /* max-width: 90%; */
        }

        .product_btn_link {
            font-size: 11px;
        }
    }


    @media only screen and (min-width: 1620px) {

        .product_btn_link {
            font-size: 14px;
        }

        .product_btn_link .img_svg_icon {
            width: 17px;
        }
    }


    @media only screen and (max-width: 1700px) {}

    @media only screen and (max-width: 1600px) {
        /* .checkout_order_summary {
      padding: 20px;
    } */

        /* .checkout_form {
      padding: 20px;
    } */

        .zooming_image_list ul li img {
            width: 50px;
            margin-right: 3px;
            height: 50px;
        }

        .single_product_add_to_cart {
            font-size: 14px;
        }

        .single_product_buy_now_btn_link {
            font-size: 14px;
        }

        .single_product_qty_plus {
            font-size: 14px;
        }

        .single_product_qty_minus {
            font-size: 14px;
        }

        .single_product_qty input {
            font-size: 14px;
        }
    }

    @media only screen and (max-width: 1499.99px) {
        .carousel_custom_item {
            width: 25%;
        }
    }

    @media only screen and (max-width: 1399.99px) {
        .category_container {
            grid-template-columns: repeat(8, minmax(0, 1fr));
        }

        .header_middle_icon {
            line-height: 40px;
        }

        .header_middle_icon svg {
            margin-top: -7px;
        }

        .header_cart_icon {
            width: 40px;
            height: 40px;
            line-height: 40px;
        }

        .header_cart_icon svg {
            margin-top: -7px;
        }

        .header_middle_cart .cart_item_total {
            top: 2px;
            right: -8px;
        }

        .header_wishlist_icon {
            width: 40px;
            height: 40px;
            line-height: 40px;
        }

        .header_wishlist_icon .wish_list_count {
            top: 2px;
            right: -8px;
        }

        .header_middle_cart {
            margin-right: 15px;
        }

        .header_middle_wishlist {
            padding-right: 15px;
        }

        .header_middle_auth_text p {
            font-size: 15px;
        }

        .header_middle_cart_text {
            font-size: 15px;
        }

        .single_product_buy_now_btn_link {
            font-size: 15px;
        }

        .single_product_qty_plus {
            font-size: 15px;
        }

        .single_product_qty_minus {
            font-size: 15px;
        }

        .single_product_qty input {
            font-size: 15px;
        }

        .aside_menu ul li {
            padding: 4px 10px;
        }
    }

    @media screen and (max-width: 1199.98px) {
        .checkout_form {
            padding: 25px;
        }

        .checkout_order_summary {
            padding: 25px;
        }

        .aside_menu ul li .aside_menu_link {
            font-size: 13px;
        }

        .carousel_custom_item {
            width: 33.33333333%;
        }

        .category_container {
            grid-template-columns: repeat(6, minmax(0, 1fr));
        }

        .service_title h4 {
            font-size: 18px;
        }

        .header_middle_logo img {
            height: 35px;
        }

        .single_product_specification_content {
            display: -webkit-box;
            display: -ms-flexbox;
            display: flex;
            gap: 15px;
        }

        .single_product_specification_list {
            margin-bottom: 0px;
        }

        /* .checkout_form {
      padding: 30px;
    } */

        /* .checkout_order_summary {
      padding: 30px;
    } */

        .customer_comment_avarage_rating {
            font-size: 20px;
        }

        .customer_comment_rating_name {
            height: 26px;
            font-size: 14px;
        }

        .customer_comment_rating_name:after {
            border-top: 26px solid var(--primary_color);
        }

        .customer_comment_rating_name i {
            font-size: 12px;
        }

        .customer_comment_rating span {
            font-size: 14px;
        }

        .customer_comment_rating {
            margin-top: 10px;
            margin-bottom: 2px;
        }

        .customer_comment_item {
            gap: 5px;
        }

        .customer_comment_item_percentage_segment {
            width: 150px;
        }

        .customer_comment_title {
            -webkit-box-pack: center;
            -ms-flex-pack: center;
            justify-content: center;
        }

        .customer_comment_rating {
            text-align: center;
        }

        .customer_comment_rating_count {
            text-align: center;
        }

        .comments_pagination {
            text-align: center;
        }

        .customer_comment_image img {
            width: 50px;
            height: 50px;
        }
    }

    @media screen and (max-width: 991.98px) {
        .header_middle_search_link {
            top: -3px;
        }

        .sub_categoty {
            margin-top: 15px;
            text-align: center;
            justify-content: center;
            display: flex;
        }

        .sub_categoty ul {
            display: flex;
            align-items: center;
            overflow-x: scroll;
            padding-bottom: 5px;
        }

        .sub_categoty ul::-webkit-scrollbar {
            height: 3px;
        }

        /* Track */

        /* Handle */
        .sub_categoty ul::-webkit-scrollbar-thumb {
            background: #888;
        }

        /* Handle on hover */
        .sub_categoty ul::-webkit-scrollbar-thumb:hover {
            background: #555;
        }

        .sub_categoty ul li {
            flex-shrink: 0;
        }

        .sub_categoty ul li .sub_category_link {
            font-size: 13px;
        }

        .header_mobile_logo img {
            max-height: 50px;
        }

        .category_container {
            grid-template-columns: repeat(5, minmax(0, 1fr));
        }

        .footer_bottom_area {
            padding-bottom: 20px;
            padding-top: 0px;
        }

        .customer_review_icon {
            display: none;
        }

        .single_product_tab_area {
            margin-top: 0px;
        }

        .title_bottom_over_underline {
            display: none;
        }

        .section_padding {
            padding: 20px 0px;
        }

        .section_padding_top {
            padding-top: 20px;
        }

        .section_padding_bottom {
            padding-bottom: 20px;
        }

        .section_top_space {
            padding-top: 10px;
        }

        .single_product_details {
            margin-top: -10px;
        }


        .product_header_section {
            text-align: left;
        }

        .product_btn {
            margin-top: 7px;
        }

        .fixed_footer_menu {
            display: block;
        }

        .header_top_list {
            text-align: center;
        }

        .header_top_list ul li:last-child {
            display: none;
        }

        .header_mobile_icon_link i {
            font-size: 18px;
        }

        .header_mobile_cart {
            width: 18px;
            height: 18px;
            font-size: 13px;
            line-height: 10px;
        }

        .auth_wrap {
            padding: 20px;
        }

        .auth_title {
            margin-bottom: 20px;
        }

        .header_middle_search input {
            height: 40px;
        }

        .header_middle_search_link {
            font-size: 16px;
        }

        .fixed_product_sticky {
            display: none;
        }

        .header_middle {
            padding: 1px 0px;
            border-top: 0px;
        }

        .search_class {
            display: none;
        }

        .search_toggle {
            display: block;
        }

        .banner_slider_image {
            height: 500px;
        }

        .footer_develop_by {
            float: inherit;
            text-align: center;
            display: -webkit-box;
            display: -ms-flexbox;
            display: flex;
            -webkit-box-align: center;
            -ms-flex-align: center;
            align-items: center;
            -webkit-box-pack: center;
            -ms-flex-pack: center;
            justify-content: center;
            margin-top: 5px;
        }

        .footer_area {
            padding-bottom: 60px;
        }

        .success_content_info {
            padding: 0px 10px;
        }

        .success_p {
            width: 100%;
            padding: 15px 5px;
            font-size: 18px;
            line-height: 30px;
        }

        .success_order_details {
            width: 100%;
            padding: 5px 6px;
        }

        .success_order_header {
            flex-direction: column;
            gap: 0;
            align-items: baseline;
            padding: 5px 30px;
        }

        .overview__order {
            border-right: none;
            border-bottom: 1px dashed #ccc;
            width: 100%;
        }

        .overview__order:last-child {
            border-bottom: none;
        }

        .fixed_footer_whatsapp_icon {
            position: relative;
            background-color: #0DC043;
            color: var(--white);
            width: 40px;
            height: 40px;
            line-height: 40px;
            text-align: center;
            border-radius: 100%;
            position: fixed;
            bottom: 110px;
            right: 15px;
            z-index: 99;
        }

         .checkout_form_btn {
            bottom: 58px;
        }
    }

    @media screen and (max-width: 767.98px) {
        .footer_copyright {
            text-align: center;
        }

        .category_container {
            gap: 8px;
        }

        .carousel_custom_item {
            width: 50%;
        }

        .carousel_custom_table_cell {
            gap: 8px;
        }

        .category_container {
            grid-template-columns: repeat(4, minmax(0, 1fr));
        }

        .zoom_img_active .owl-dots img {
            width: 50px;
        }

        .col-xxxl-5 {
            padding-left: 4px;
            padding-right: 4px;
            float: left;
        }

        .page_404_content {
            padding-top: 5px;
            padding-bottom: 0px;
        }

        .go_back_btn {
            padding: 5px 15px;
            margin-bottom: 10px;
            margin-top: 10px;
        }

        .success_p.english_p {
            font-size: 18px !important;
            font-weight: normal;
            line-height: 25px;
        }


        .checkout_form_checkbox_group {
            padding-top: 5px;
        }

        .apply_coupon_item_link {
            margin-left: 10px;
        }

        .checkout_product_price {
            width: 80px;
        }

        .checkout_product_qty {
            width: 100px;
        }

        .mobile_footer_single_size {
            margin-right: 15px;
        }

        .custom_section_title h2 {
            display: block !important;
            width: 100% !important;
            text-align: center !important;
        }

        .slider_banner_active .owl-nav div {
            display: none;
        }

        /* heading category list toggle css start */
        .section_title_table_cell {
            -webkit-box-pack: center;
            -ms-flex-pack: center;
            justify-content: center;
        }

        .section_title h2 i {
            padding-left: 10px;
            font-size: 18px;
        }

        .section_title i {
            display: block;
        }

        .section_title_table_cell .section_title h2 {
            display: -webkit-box;
            display: -ms-flexbox;
            display: flex;
            -webkit-box-align: center;
            -ms-flex-align: center;
            align-items: center;
        }

        .single_product_specification_content {
            display: inherit;
        }

        .single_product_specification_list {
            margin-bottom: 15px;
        }

        .product_name_link {
            font-size: 14px;
        }

        .order_tracking_content {
            padding: 20px;
        }

        .wishlist_image img {
            width: 40px;
        }

        .wishlist_name_link {
            line-height: 18px;
            font-size: 13px;
        }

        .wishlist_price span {
            display: block;
            font-size: 13px;
            line-height: 18px;
        }

        .wishlist_action_link {
            font-size: 12px;
            padding: 0px 2px;
            width: 80px;
        }

        .wishlist_delete {
            text-align: right;
        }

        .wishlist_price {
            width: 80px;
        }

        .wishlist_name {
            width: 120px;
        }

        .wishlist_delete_link {
            font-size: 16px;
        }

        .view_cart_coupon input {
            width: 100%;
            padding: 7px 10px;
            height: 45px;
        }

        .view_cart_coupon_update {
            display: block;
        }

        .view_cart_coupon_btn {
            padding: 10px 15px;
            height: 45px;
        }

        .view_cart_update {
            text-align: center;
            margin-top: 20px;
        }

        .view_cart_update_btn {
            padding: 10px 20px;
        }

        .view_cart_subtotal strong {
            font-size: 16px;
        }

        .view_cart_total strong {
            font-size: 16px;
        }

        .view_cart_image img {
            width: 40px;
            height: 40px;
        }

        .view_cart_name_link {
            font-size: 13px;
            line-height: 18px;
        }

        .view_cart_name {
            width: 120px;
        }

        .view_cart_price span {
            display: block;
            font-size: 13px;
            line-height: 18px;
        }

        .view_cart_price {
            width: 75px;
        }

        .view_cart_qty_minus {
            width: 25px;
            height: 25px;
            line-height: 25px;
            font-size: 16px;
        }

        .view_cart_qty input {
            width: 35px;
            height: 25px;
            line-height: 25px;
        }

        .view_cart_qty_plus {
            width: 25px;
            height: 25px;
            line-height: 25px;
            font-size: 16px;
        }

        .view_cart_qty {
            width: 85px;
        }

        .profile_form_item input {
            padding: 10px 10px;
        }

        .profile_form_submit_btn_link {
            padding: 10px 0px;
        }

        .auth_item {
            margin-bottom: 10px;
        }

        .order_tracking_sender_title h3 {
            padding: 5px 0px;
            font-size: 18px;
        }

        .order_tracking_courier_title h3 {
            font-size: 18px;
            padding: 5px 0px;
        }

        .header_search_item_product_name p {
            font-size: 14px;
            line-height: 18px;
        }

        .header_search_item_product_price span {
            font-size: 14px;
        }

        .customer_comment_review_content {
            max-height: 350px;
        }

        .load_more_bar {
            width: 80%;
        }

        .load_more_bar p {
            font-size: 14px;
        }

        .load_more_details {
            width: 120px;
            padding: 2px 5px;
        }

        .load_more_details p,
        .load_more_details i {
            font-size: 14px;
        }

        .tracking-icon {
            margin-right: 19px;
            margin-left: 0px;
        }

        .tracking-timeline::before {
            left: 12px;
        }

        .checkout_form_btn {
            text-align: center;
            margin-top: 20px;
            position: fixed !important;
            bottom: 56px;
            left: 0;
            z-index: 3;
            padding: 0px 8px;
            width: 100%;
            margin: 0;
        }
    }

    @media screen and (max-width: 576px) {

        /* Mobile Device 576 Padding Customize Start */
        .col-xxl-1,
        .col-xxl-2,
        .col-xxl-2,
        .col-xxl-4,
        .col-xxl-5,
        .col-xxl-6,
        .col-xxl-7,
        .col-xxl-8,
        .col-xxl-9,
        .col-xxl-10,
        .col-xxl-11,
        .col-xxl-12,
        .col-xl-1,
        .col-xl-2,
        .col-xl-2,
        .col-xl-4,
        .col-xl-5,
        .col-xl-6,
        .col-xl-7,
        .col-xl-8,
        .col-xl-9,
        .col-xl-10,
        .col-xl-11,
        .col-xl-12,
        .col-lg-1,
        .col-lg-2,
        .col-lg-2,
        .col-lg-4,
        .col-lg-5,
        .col-lg-6,
        .col-lg-7,
        .col-lg-8,
        .col-lg-9,
        .col-lg-10,
        .col-lg-11,
        .col-lg-12,
        .col-md-1,
        .col-md-2,
        .col-md-2,
        .col-md-4,
        .col-md-5,
        .col-md-6,
        .col-md-7,
        .col-md-8,
        .col-md-9,
        .col-md-10,
        .col-md-11,
        .col-md-12,
        .col-sm-1,
        .col-sm-2,
        .col-sm-2,
        .col-sm-4,
        .col-sm-5,
        .col-sm-6,
        .col-sm-7,
        .col-sm-8,
        .col-sm-9,
        .col-sm-10,
        .col-sm-11,
        .col-sm-12,
        .col-1,
        .col-2,
        .col-2,
        .col-4,
        .col-5,
        .col-6,
        .col-7,
        .col-8,
        .col-9,
        .col-10,
        .col-11,
        .col-12 {
            padding-left: 3px !important;
            padding-right: 3px !important;
        }

        .container,
        .container-fluid,
        .container-lg,
        .container-md,
        .container-sm,
        .container-xl,
        .container-xxl {
            padding-right: 3px !important;
            padding-left: 3px !important;
        }

        .row {
            margin-right: 0px !important;
            margin-left: 0px !important;
        }

        /* Mobile Device 576 Padding Customize End */
        .category_container {
            grid-template-columns: repeat(3, minmax(0, 1fr));
        }

        .single_product_list.mobile_device_cat {
            padding-top: 10px;
            padding-bottom: 12px;
        }

        .single_product_name {
            margin-top: 0px;
        }

        .checkout_form_checkbox.form-check .form-check-input {
            margin-left: 5px;
        }

        .checkout_form_checkbox.form-check .form-check-input {
            margin-left: 0px !important;
        }

        .checkout_form_checkbox_group {
            gap: 10px;
        }

        .checkout_form_checkbox.form-check label {
            font-size: 14px;
        }

        .checkout_form_checkbox_group h4 {
            font-size: 12px;
            line-height: 24px;
        }

        .payment_images {
            width: 90px;
        }

        .checkout_form {
            padding: 5px;
        }

        .checkout_order_summary {
            padding: 5px;
        }

        .border_section {
            padding: 5px 2px 2px 2px;
        }

        .single_product_qty input {
            height: 36px;
            line-height: 36px;
        }

        .single_product_qty_minus {
            height: 36px;
            line-height: 36px;
        }

        .single_product_qty_plus {
            height: 36px;
            line-height: 36px;
        }

        .single_product_add_to_cart {
            padding: 5px 0px;
        }

        .single_product_details {
            margin-top: -10px;
        }

        .title_bottom_underline {
            margin-bottom: 0 !important;
        }

        .carousel_custom_pre_btn,
        .carousel_custom_next_btn {
            display: none;
        }

        .product_btn {
            margin-top: 0px;
        }

        .category_name {
            padding: 0px 5px;
            padding-top: 5px;
        }

        .category_name p {
            font-size: 13px;
            font-weight: 500;
        }

        .footer_bottom_area {
            padding-bottom: 5px;
        }

        .header_area {
            /* padding: 0px 10px; */
        }

        .header_mobile_device {
            padding: 1px 10px;
        }

        .slider_banner_item {
            margin-top: 0px;
        }

        .footer_area {
            padding-left: 10px;
            padding-right: 10px;
        }

        .single_product_area {
            padding-top: 0px;
        }

        .zooming_image_content,
        .single_product_list,
        .single_product_name,
        .single_product_whatsapp,
        .single_product_attribute.s_p_code,
        .single_product_attribute.s_p_price,
        .select_attribute_container.s_p_select,
        .delivery_mobile_device {
            padding: 0px 10px;
        }

        .delivery_mobile_device {
            margin-top: 10px;
        }

        .shipping_highlight {
            margin-left: 10px;
            margin-right: 10px;
        }

        .contact_us_container {
            padding: 0px 8px;
        }

        .single_product_buy_now_btn {
            margin-top: 12px;
        }

        .single_product_qty_with_buy_now_btn {
            padding-left: 7px;
            padding-right: 7px;
            padding-top: 18px;
        }

        .single_product_specification_content {
            padding-left: 10px;
            padding-right: 10px;
        }

        .single_product_tab_area {
            padding-left: 10px;
            padding-right: 10px;
        }

        .order_tracking_area {
            padding-left: 10px;
            padding-right: 10px;
        }

        .about_us_area {
            padding-left: 10px;
            padding-right: 10px;
        }

        .contact_us_area {
            padding-left: 10px;
            padding-right: 10px;
        }

        .auth_area {
            padding-left: 10px;
            padding-right: 10px;
        }

        .section_title_table_cell {
            padding-bottom: 0;
            border-bottom: none;
        }

        .section_title h2 i {
            font-size: 16px;
        }

        .fixed_product_card_footer_count strong {
            font-size: 18px;
        }

        .fixed_product_card_close_price p {
            font-size: 14px;
        }

        .fixed_product_card_footer_checkout_link {
            font-weight: 400;
        }

        .section_title h2 {
            font-weight: 400;
            font-size: 18px;
        }

        .checkout_form_btn_link {
            font-weight: 300;
        }

        .checkout_form_group i {
            bottom: 14px;
        }

        .header_top_list ul {
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .profile_right_side {
            padding: 10px;
        }

        .fixed_product_card_content {
            width: 90% !important;
        }

        .text_center_576 {
            text-align: center;
        }

        .single_product_whatsapp {
            margin-top: 5px;
        }

        .single_product_attribute.s_p_code {
            margin-top: 15px;
        }

        .single_product_attribute.s_p_price {
            margin-top: 7px;
        }

        .select_attribute_container.s_p_select {
            margin-top: 4px;
        }

        .single_product_btn_group {
            padding-top: 10px;
        }

        .product_card {
            padding: 2px;
        }

        /* .checkout_form {
          padding: 15px;
        } */

        .checkout_form_title {
            margin-bottom: 20px;
        }

        .checkout_form_title h3 {
            font-size: 20px;
            padding-bottom: 0px;
        }

        .order_summary_title h3 {
            font-size: 20px;
        }


        .checkout_form_group input,
        .checkout_form_group select,
        .checkout_form_group textarea {
            padding: 7px 10px;
        }

        .checkout_form_group .checkout_form_select {
            padding: 8px 10px;
        }

        .checkout_form_group {
            margin-bottom: 6px;
        }

        .checkout_form_group label {
            margin-bottom: 1px;
        }

        /* .checkout_order_summary {
      padding: 15px;
    } */

        .order_summary_table .table thead tr th {
            font-size: 13px;
            line-height: 20px;
        }

        .checkout_product_name_image p {
            font-size: 12px;
        }

        .apply_coupon_item input {
            padding: 6px 10px;
        }

        .apply_coupon_item_link {
            padding: 6px 15px;
        }

        .success_title h3 {
            font-size: 20px;
            line-height: 30px;
        }

        .success_subtitle p {
            font-size: 14px;
        }

        .success_call p {
            font-size: 14px;
        }

        .product_name_link {
            margin-bottom: 0px;
            margin-top: 5px;
        }

        .product_price {
            margin-bottom: 5px;
        }

        .product_new_price {
            font-size: 14px;
        }

        .product_discount_price {
            font-size: 14px;
            padding-left: 5px;
        }

        .product_btn_link {
            padding: 1px 0px;
            font-size: 14px;
        }

        .order_tracking_title strong {
            font-size: 13px;
            line-height: 20px;
            font-weight: 500;
        }

        .order_tracking_title p {
            font-size: 13px;
            line-height: 20px;
        }

        .order_tracking_search input {
            padding: 7px 10px;
            font-size: 14px;
        }

        .order_tracking_search_btn_link {
            font-size: 18px;
            padding: 8px 0px;
        }

        .order_tracking_date p {
            font-size: 14px;
        }

        .order_tracking_invoice strong {
            font-weight: 500;
        }

        .order_tracking_order_status_details {
            float: inherit;
            margin-bottom: 15px;
        }

        .order_tracking_header {
            padding-bottom: 20px;
            margin-bottom: 15px;
        }

        .order_tracking_sender_organization h3 {
            font-size: 20px;
        }

        .order_tracking_courier_name h3 {
            font-size: 20px;
        }

        .order_tracking_customer_item {
            -webkit-box-align: inherit;
            -ms-flex-align: inherit;
            align-items: inherit;
        }

        .auth_item input {
            padding: 10px 15px;
        }

        .auth_sub_btn_link {
            padding: 10px 0px;
            font-size: 16px;
        }

        .auth_sub_btn_two_link {
            padding: 10px 0px;
            font-size: 16px;
        }

        .auth_title h3 {
            font-size: 20px;
        }

        .order_left_side {
            width: 284px;
        }

        .single_product_tab_nav .single_product_tab_nav_link {
            font-size: 14px;
            padding: 4px 5px;
        }

        .auth_link_page.auth_reg {
            flex-direction: column;
            gap: 0px;
        }

        .footer_top {
            padding-top: 20px;
            padding-bottom: 25px;
        }

        .footer_title {
            margin-bottom: 7px;
        }

        .footer_menu ul li {
            margin-bottom: 5px;
        }

        .single_product_new_price {
            font-size: 20px;
        }
    }

    @media screen and (max-width: 480px) {
        .single_product_name {
            margin-top: 0px;
        }

        .single_product_name h2 {
            font-size: 18px;
        }

        .single_product_specification_list ul li {
            font-size: 12px;
            margin-bottom: 2px;
        }

        .single_product_call_title p {
            line-height: 24px;
        }

        .single_product_tab_nav {
            display: -webkit-box;
            display: -ms-flexbox;
            display: flex;
            -webkit-box-align: center;
            -ms-flex-align: center;
            align-items: center;
            -webkit-box-pack: justify;
            -ms-flex-pack: justify;
            justify-content: space-between;
        }

        .order_details {
            padding: 24px 8px;
        }

        .order_left_side {
            width: 145px;
            padding-right: 25px;
        }


    }

    @media screen and (max-width: 375px) {
        .single_product_add_to_cart {
            font-size: 13px;
        }

        .single_product_qty_minus {
            width: 30px;
        }

        .single_product_qty_plus {
            width: 30px;
        }

        .mobile_footer_single {
            width: 76px !important;
        }
    }

    @media screen and (max-width: 345px) {
        .mobile_footer_single {
            width: 63px !important;
        }
    }
</style>
