@php
    $color = DB::table('background_and_colors')->first();
@endphp
<style>
    /*
==========================================
    Google Fonts
==========================================
*/
    /* font-family: 'Rubik', sans-serif;  */

    @import url('https://fonts.googleapis.com/css2?family=Jost:wght@100..900&display=swap');


    :root {
        --primary_color: <?php echo $color->primary_color; ?>;
        --primary_text_color: <?php echo $color->primary_text_color; ?>;
        --primary_hover_color: <?php echo $color->primary_hover_color; ?>;

        --menu_background_color: <?php echo $color->menu_background_color; ?>;
        --menu_text_color: <?php echo $color->menu_text_color; ?>;
        --menu_hover_color: <?php echo $color->menu_hover_color; ?>;

        --add_to_card_background_color: <?php echo $color->add_to_card_background_color; ?>;
        --add_to_card_text_color: <?php echo $color->add_to_card_text_color; ?>;
        --add_to_card_border_color: <?php echo $color->add_to_card_border_color; ?>;
        --add_to_card_hover_color: <?php echo $color->add_to_card_hover_color; ?>;

        --single_page_add_to_card_bg_color: <?php echo $color->single_page_add_to_card_bg_color; ?>;
        --single_page_add_to_card_text_color: <?php echo $color->single_page_add_to_card_text_color; ?>;
        --single_page_add_to_card_border_color: <?php echo $color->single_page_add_to_card_border_color; ?>;
        --single_page_add_to_card_hover_bg_color: <?php echo $color->single_page_add_to_card_hover_bg_color; ?>;
        --single_page_add_to_card_hover_text_color: <?php echo $color->single_page_add_to_card_hover_text_color; ?>;
        --single_page_add_to_card_hover_border_color: <?php echo $color->single_page_add_to_card_hover_border_color; ?>;

        --discount_price_color: <?php echo $color->discount_price_color; ?>;

        --footer_background_color: <?php echo $color->footer_background_color; ?>;
        --footer_text_color: <?php echo $color->footer_text_color; ?>;
        --footer_hover_color: <?php echo $color->footer_hover_color; ?>;

        --border: <?php echo $color->default_border_color; ?>;
        --shadow: <?php echo $color->default_box_color; ?>;
        --white: #ffffff;
        --black: #323232;
    }

    .sticky {
        position: fixed;
        top: 0;
        width: 100%;

    }

    .header_up_list ul li .header_up_list_link i {
        padding-right: 5px;
    }

    .mobile_sticky_footer_table {
        display: none;
    }

    .single_product_tab_video {
        width: 50%;
        margin: 0 auto;
    }

    .header_up_list {
        text-align: right;
    }

    .header_up_list ul {}

    .header_up_list ul li {
        display: inline-block;
        margin-right: 20px;
    }

    .header_up_list ul li:last-child {
        margin-right: 0px;
    }

    .header_up_list ul li .header_up_list_link {
        color: var(--white);
    }

    .header_up_list ul li .header_up_list_link:hover {}


    .widget {
        position: sticky;
        top: 173px;
    }

    /* ==========  */

    .sticky_header.fixed {
        position: fixed;
        left: 0;
        right: 0;
        top: 0;
        /* height: 80px; */
        z-index: 999;
        /* -webkit-animation-name: fixedHeader;
        animation-name: fixedHeader; */
        -webkit-animation-duration: .4s;
        animation-duration: .4s;
        background-color: var(--white);
    }

    @-webkit-keyframes fixedHeader {
        0% {
            opacity: 0;
            -webkit-transform: translateY(-60px);
            transform: translateY(-60px);
        }

        100% {
            opacity: 1;
            -webkit-transform: translateY(0);
            transform: translateY(0);
        }
    }

    @keyframes fixedHeader {
        0% {
            opacity: 0;
            -webkit-transform: translateY(-60px);
            transform: translateY(-60px);
        }

        100% {
            opacity: 1;
            -webkit-transform: translateY(0);
            transform: translateY(0);
        }
    }

    .header_middle.sticky_header.fixed {
        padding: 5px 0px;
    }

    .header_middle.sticky_header.fixed {
        height: 65px;
    }





    /*
==============================================================
    Scroll to top Css
==============================================================
*/
    .scroll-to-top-button {
        display: none;
        position: fixed;
        bottom: 18px;
        right: 18px;
        background-color: var(--primary_color);
        color: #fff;
        border: none;
        border-radius: 2px;
        font-size: 17px;
        cursor: pointer;
        transition: opacity .3s ease-in-out;
        width: 40px;
        height: 40px;
        line-height: 40px;
        text-align: center;
    }

    .scroll-to-top-button:hover {
        background-color: var(--primary_color);
        transition: 0.4s all linear;
    }

    * {
        margin: 0;
        padding: 0;
    }

    html,
    body {
        width: 100%;
        height: 100%;
        margin: 0;
        padding: 0;
        font-family: "Jost", sans-serif;
        font-weight: normal;
        font-style: normal;
        font-size: 16px;
        line-height: 26px;
        color: var(--black);
    }

    .section_title_cat {
        text-align: center;
    }

    p {
        color: var(--black);
    }

    a,
    .button {
        -webkit-transition: all 0.3s ease-out 0s;
        -o-transition: all 0.3s ease-out 0s;
        transition: all 0.3s ease-out 0s;
    }

    a:focus,
    .button:focus {
        text-decoration: none;
        outline: none;
    }

    select:focus {
        outline: none;
    }

    button:focus,
    input:focus,
    input:focus,
    textarea,
    textarea:focus {
        outline: 0;
    }

    ul {
        margin: 0px;
        padding: 0px;
    }

    li {
        list-style: none;
    }

    a {
        text-decoration: none;
    }

    h1,
    h2,
    h3,
    h4,
    h5,
    h6,
    p {
        margin: 0px;
    }

    h1,
    h2,
    h3,
    h4,
    h5,
    h6 {
        color: var(--black);
    }

    hr {
        -webkit-box-sizing: content-box;
        box-sizing: content-box;
        height: 0;
    }

    *::-moz-placeholder {
        color: #555555;
        opacity: 1;
        font-size: 16px;
    }

    *::-webkit-input-placeholder {
        color: #555555;
        opacity: 1;
        font-size: 16px;
    }

    *:-ms-input-placeholder {
        color: #555555;
        opacity: 1;
        font-size: 16px;
    }

    *::-ms-input-placeholder {
        color: #555555;
        opacity: 1;
        font-size: 16px;
    }

    *::placeholder {
        color: #555555;
        opacity: 1;
        font-size: 16px;
    }

    *::-moz-selection {
        background: #000000;
        color: #fff;
        text-shadow: none;
    }

    ::-moz-selection {
        background: #000000;
        color: #fff;
        text-shadow: none;
    }

    ::selection {
        background: #000000;
        color: #fff;
        text-shadow: none;
    }

    .padding_left_zero {
        padding-left: 0px !important;
    }

    .padding_right_zero {
        padding-right: 0px !important;
    }

    .section_padding {
        padding: 45px 0px;
    }

    .section_padding_top {
        padding-top: 60px;
    }

    .section_padding_bottom {
        padding-bottom: 40px;
    }

    .section_margin_top {
        margin-top: 40px;
    }

    .section_top_space {
        padding-top: 25px;
    }

    .common_table_cell {
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
        -webkit-box-pack: justify;
        -ms-flex-pack: justify;
        justify-content: space-between;
    }



    /*
==============================================================
    Header Area Css
==============================================================
*/
    .section_title_table_cell {
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
        -webkit-box-pack: justify;
        -ms-flex-pack: justify;
        justify-content: space-between;
        padding-bottom: 10px;
        margin-bottom: 10px;
        border-bottom: 1px solid var(--border);
    }

    .section_title h2 {
        font-size: 25px;
        display: block;
        text-transform: capitalize;
        color: var(--black);
        font-weight: 500;
        margin-bottom: 0;
        text-align: center;
    }

    .featured_pro_title h2 {
        font-size: 25px;
        display: block;
        text-transform: capitalize;
        color: var(--black);
        font-weight: 500;
        margin-bottom: 0;
    }

    .section_title_cat h2 {
        font-size: 20px;
        display: block;
        text-transform: capitalize;
        color: var(--black);
        font-weight: 500;
        margin-bottom: 0;
    }

    .category_list ul {
        margin: 0;
        padding: 0;
    }

    .category_list ul li {
        list-style: none;
        display: inline-block;
        line-height: 25px;
        margin-right: 3px;
    }

    .category_list ul li:last-child {
        margin-right: 0px;
    }

    .category_list ul li .category_list_link {
        display: block;
        border-bottom: 1px solid var(--primary_color);
        color: var(--black);
        font-size: 14px;
        text-transform: capitalize;
        padding: 0px 3px;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .header_top_list ul li .header_top_list_link svg {
        width: 28px;
        height: 28px;
        color: var(--primary_color);
    }

    .category_list ul li:hover .category_list_link {
        color: var(--hover);
    }

    .category_list_link_view_all {
        background-color: var(--primary_color) !important;
        color: var(--white) !important;
        padding: 1px 10px !important;
        border-radius: 3px !important;
        border-bottom: none !important;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .category_list_link_view_all:hover {
        color: var(--black) !important;
    }

    .section_title i {
        display: none;
    }

    /*
==============================================================
    Header Area Css
==============================================================
*/
    /* header top css */
    .header_top {
        display: flex;
        align-items: center;
        height: 80px;
    }

    .header_top_cell {
        display: flex;
        align-items: center;
        justify-content: space-between;
    }

    .header_top_list ul li .header_top_list_link.header_top_list_cart {
        font-size: 22px;
    }

    .header_top_list ul li .header_top_list_link.header_top_list_user {
        font-size: 33px;
    }

    .header_top_list ul li .header_top_list_link.header_top_list_user svg {
        height: 32px;
        display: block;
        width: 34px;
        margin-top: -4px;
    }

    .header_search {
        position: relative;
    }

    .header_search input {
        width: 100%;
        border: 1px solid var(--primary_color);
        border-radius: 5px;
        padding: 10px 30px;
        height: 55px;
        line-height: 55px;
    }

    .header_search_btn {
        position: absolute;
        top: 0;
        right: 0;
        font-size: 18px;
        height: 45px;
        line-height: 45px;
        border: none;
        background: var(--primary_color);
        color: var(--primary_text_color);
        padding: 0px 25px;
        border-radius: 3px;
        margin-top: 5px;
        margin-right: 6px;
    }


    .fixed_product_sticky_icon svg {
        color: var(--primary_color);
    }

    .fixed_product_card_delete_icon .card_remove i {
        color: var(--primary_color);
    }


    .header_top_list {
        display: flex;
        align-items: center;
        height: 55px;
        justify-content: end;
    }


    .header_top_list ul {
        display: flex;
        align-items: center;
        justify-content: end;
        gap: 30px;
        height: 50px;
        padding-top: 11px;
    }

    .header_top_list ul li {
        position: relative;
    }

    .header_top_list ul li .header_top_list_link {
        font-size: 25px;
        color: var(--primary_color);
    }

    .header_count {
        position: absolute;
        top: 0;
        right: 0;
        width: 18px;
        height: 18px;
        line-height: 18px;
        background-color: var(--primary_color);
        color: var(--white);
        font-size: 12px;
        text-align: center;
        border-radius: 20px;
        margin-top: -5px;
        margin-right: -12px;
    }

    .header_logo img {
        height: 55px;
    }


    .sticky {
        position: fixed;
        top: 0;
        width: 100%;
        -webkit-box-shadow: var(--shadow);
        box-shadow: var(--shadow);
        background-color: var(--white);
        z-index: 999;
        transition: top 0.3s ease;
    }


    .sticky+.content .brand_area {
        padding-top: 400px !important;
    }

    @keyframes cool {
        0% {
            --degrees: 0deg;
        }

        100% {
            --degrees: 360deg;
        }
    }




    .sticky_product_right .sticky_btn button i {
        padding-right: 6px;
    }

    .mobile_sticky_footer_btn button i {
        padding-right: 5px;
    }




    .header_middle {
        padding: 15px 0px;
    }

    .header_middle_logo {
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
        height: 100%;
    }

    .header_middle_logo img {
        max-width: 100%;
        max-height: 100%;
        height: 50px;
    }

    .header_middle_search {
        position: relative;
    }

    .header_middle_search input {
        border: 1px solid var(--border);
        width: 100%;
        font-size: 16px;
        border-radius: 3px;
        height: 55px;
        padding-left: 20px;
        padding-right: 60px;
    }

    .header_middle_search_link {
        border: none;
        background-color: transparent;
        color: var(--black);
        font-size: 20px;
        position: absolute;
        top: 0;
        right: 0;
        bottom: 0;
        padding: 0px 20px;
    }

    .header_middle_table_cell {
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
        -webkit-box-pack: end;
        -ms-flex-pack: end;
        justify-content: end;
        height: 100%;
    }

    .header_middle_call_link {
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
    }

    .header_middle_call_icon i {
        color: var(--primary_color);
        font-size: 26px;
        -webkit-transform: rotate(36deg);
        -ms-transform: rotate(36deg);
        transform: rotate(36deg);
        margin-right: 5px;
    }

    .header_middle_call_text p {
        font-size: 14px;
        line-height: 14px;
    }

    .header_middle_call_text span {
        line-height: 13px;
        display: inline-block;
        color: var(--black);
        font-size: 15px;
        font-weight: 500;
    }

    .header_middle_wishlist {
        border-left: 1px solid var(--border);
        border-right: 1px solid var(--border);
        padding: 0px 20px;
        margin: 0px 50px;
        height: 40px;
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
    }

    .header_middle_wishlist_icon {
        position: relative;
    }

    .header_middle_wishlist_icon i {
        font-size: 28px;
        color: var(--primary_color);
    }

    .header_middle_wishlist_icon span {
        position: absolute;
        bottom: 0;
        right: 0;
        color: var(--black);
        margin-bottom: -5px;
        margin-right: -6px;
        font-size: 14px;
    }

    .banner_image img {
        width: 100%;
        max-height: 200px;
    }

    .header_middle_cart p {
        font-size: 14px;
        line-height: 14px;
    }

    .header_middle_cart span {
        line-height: 13px;
        display: inline-block;
        color: var(--black);
        font-size: 15px;
        font-weight: 500;
    }

    .header_mobile_icon_link span {
        position: absolute;
        top: 0;
        left: 0;
        width: 16px;
        height: 16px;
        background-color: var(--black);
        text-align: center;
        line-height: 18px;
        font-size: 11px;
        color: var(--white);
        border-radius: 50%;
        margin-top: -9px;
        margin-left: 14px;
        display: block;
    }

    .header_mobile_cart {
        display: inline-block;
        position: relative;
        width: 22px;
        height: 22px;
        padding: 3px;
        border: 1px solid var(--primary_color);
        border-bottom-right-radius: 3px;
        border-bottom-left-radius: 3px;
        color: var(--black);
        font-size: 14px;
        line-height: 14px;
        text-align: center;
        -webkit-transition: all 0.2s;
        -o-transition: all 0.2s;
        transition: all 0.2s;
    }

    .header_mobile_cart_count {
        color: var(--black);
    }

    .header_mobile_cart_count::after {
        position: absolute;
        bottom: 90%;
        left: 50%;
        width: 10px;
        height: 6px;
        margin-bottom: 1px;
        margin-left: -6px;
        border: 1px solid #dc9814;
        color: var(--black);
        border-bottom: 0;
        border-top-left-radius: 99px;
        border-top-right-radius: 99px;
        content: "";
        -webkit-transition: all 0.2s;
        -o-transition: all 0.2s;
        transition: all 0.2s;
        pointer-events: none;
    }

    /* header search result item css */
    .header_search_item_content {
        position: relative;
    }

    .header_search_item {
        -webkit-box-shadow: var(--shadow);
        box-shadow: var(--shadow);
        background-color: var(--white);
        max-height: 400px;
        overflow: auto;
        position: absolute;
        top: 100%;
        left: 0;
        width: 100%;
        z-index: 999999999;
        border-radius: 0px 10px 10px 0px;
    }

    .header_search_item::-webkit-scrollbar-thumb {
        background: var(--primary_color);
        border-radius: 20px;
    }

    .header_search_item::-webkit-scrollbar {
        width: 5px;
    }

    .header_search_item ul {
        margin: 0;
        padding: 0;
    }

    .header_search_item ul li {
        list-style: none;
        display: block;
        width: 100%;
        overflow: hidden;
        border-bottom: 1px solid var(--border);
        padding: 5px 0px 5px 5px;
    }

    .header_search_item ul li:last-child {
        border-bottom: 0px;
    }

    .header_search_item_product_image {
        float: left;
        margin-right: 10px;
    }

    .header_search_item_product_image img {
        width: 50px;
        height: 50px;
    }

    .header_search_item_product_new_price {
        color: var(--black);
    }

    .header_search_item_product_discount_price {
        color: #94a3b8;
        text-decoration: line-through;
        padding-left: 8px;
    }

    /* header bottom css */
    .header_bottom {
        padding-top: 10px;
        padding-bottom: 5px;
        box-shadow: rgba(0, 0, 0, 0.04) 0px 2px 3px;
    }

    .main_menu ul li {
        display: inline-block;
        margin-left: 2px;
        margin-bottom: 15px;
    }

    .main_menu ul li .main_menu_link {
        font-size: 15px;
        font-weight: 400;
        color: var(--black);
        position: relative;
        text-transform: uppercase;
        transition: color 0.3s ease;
        background: #f9f9f9;
        display: block;
        padding: 2px 10px;
        border-radius: 69px;
        width: max-content;
        letter-spacing: 1px;
    }

    .main_menu ul li:hover .main_menu_link {
        color: var(--primary_color);
    }

    .main_menu ul li .main_menu_link svg {
        margin-top: -4px;
    }

    nav.main_menu {
        position: relative;
    }

    .main_menu ul li .sub_menu {
        position: absolute;
        z-index: 500;
        background-color: var(--white);
        box-shadow: 0 16px 24px #afafaf29;
        padding: 20px 30px;
        transition: all 0.5s ease;
        opacity: 0;
        visibility: hidden;
        text-align: left;
        /*max-width: 1200px;*/
        width: 100%;
        padding: 20px 15px;
        display: flex;
        flex-wrap: wrap;
        left: 50%;
        transform: translateX(-50%);
    }

    .main_menu ul li .main_menu_link i {
        font-size: 14px;
    }

    .main_menu ul li:hover .sub_menu {
        visibility: visible;
        opacity: 1;
    }

    .main_menu ul li .single_column_menu {
        min-width: 280px;
        max-width: 350px;
    }

    /* mega menu */
    .sub_menu_item {
        flex: 0 0 20%;
        padding: 0 15px;
    }

    .sub_menu_item ul {
        margin: 0;
        padding: 0;
    }

    .sub_menu_item .sub_menu_title {
        font-size: 15px;
        color: var(--black);
        line-height: 1px;
        text-transform: uppercase;
        margin-top: 15px;
        margin-bottom: 15px;
        display: block;
        font-weight: 500;
    }

    .sub_menu_item ul li {
        line-height: 1px;
        display: block;
        margin-left: 0px;
    }

    .sub_menu_link {
        padding: 10px 0;
        display: inline-block;
        font-size: 14px;
        color: #959090;
        transition: color 0.3s ease;
    }

    .sub_menu_link:hover {
        color: #ea4636;
    }

    .toaster-center {
        top: 30%;
        left: 50%;
        transform: translate(-50%, -50%);
        position: fixed;
        z-index: 9999;
    }



    .main_menu_link.h_combo {
        background-color: #06d6a0 !important;
        color: var(--white) !important;
    }

    .main_menu_link.h_buy_one {
        background-color: #9747FF !important;
        color: var(--white) !important;
    }

    .main_menu_link.h_daily_offers {
        background-color: var(--primary_color) !important;
        color: var(--white) !important;
    }

    .main_menu_link.h_brand {
        background-color: #06d6a0 !important;
        color: var(--white) !important;
    }



    .header_mobile_middle {
        overflow-y: auto;
    }




    /*
==============================================================
    Sticky Product Area Css
==============================================================
*/
    .sticky_product {
        width: 100%;
        position: fixed;
        bottom: 0;
        left: 0;
        right: 0;
        z-index: 999999;
        background: #ffffff;
        display: none;
    }

    .sticky_product.fixed {
        position: fixed;
        left: 0;
        right: 0;
        bottom: 0;
        z-index: 1040;
        -webkit-animation-name: fixedHeader;
        animation-name: fixedHeader;
        -webkit-animation-duration: .4s;
        animation-duration: .4s;
        background-color: var(--white);
        -webkit-box-shadow: var(--shadow);
        box-shadow: var(--shadow);
        background: #ffffff;
        display: block;
        padding: 5px 0px;
    }

    @-webkit-keyframes fixedHeader {
        0% {
            opacity: 0;
            -webkit-transform: translateY(-20px);
            transform: translateY(-20px);
        }

        100% {
            opacity: 1;
            -webkit-transform: translateY(0);
            transform: translateY(0);
        }
    }

    @keyframes fixedHeader {
        0% {
            opacity: 0;
            -webkit-transform: translateY(-20px);
            transform: translateY(-20px);
        }

        100% {
            opacity: 1;
            -webkit-transform: translateY(0);
            transform: translateY(0);
        }
    }

    .fiex_single_sticky {
        width: 100%;
        position: fixed;
        bottom: -100px;
        left: 0;
        right: 0;
        z-index: 999;
        background: #ffffff;
        display: block;
        opacity: 0;
        transition: all 0.4s ease-in-out;
    }

    .fiex_single_sticky.fixed {
        bottom: 0;
        opacity: 1;
        -webkit-animation-name: fixedHeader;
        animation-name: fixedHeader;
        -webkit-animation-duration: .4s;
        animation-duration: .4s;
        background-color: var(--white);
        -webkit-box-shadow: var(--shadow);
        box-shadow: var(--shadow);
        background: #ffffff;
        padding: 5px 0px;
    }

    @-webkit-keyframes fixedHeader {
        0% {
            opacity: 0;
            -webkit-transform: translateY(20px);
            transform: translateY(20px);
        }

        100% {
            opacity: 1;
            -webkit-transform: translateY(0);
            transform: translateY(0);
        }
    }

    @keyframes fixedHeader {
        0% {
            opacity: 0;
            -webkit-transform: translateY(20px);

            transform: translateY(20px);

        }

        100% {
            opacity: 1;
            -webkit-transform: translateY(0);
            transform: translateY(0);
        }
    }

    .sticky_product_left {
        display: flex;
        align-items: center;
        gap: 15px;
    }

    .sticky_product_left .product_image {
        border-radius: 3px;
        height: 65px;
        min-width: 65px;
        width: 65px;
    }

    .product_name_with_price .product_name {
        margin-top: 10px;
    }

    .product_name_with_price .product_name h4 {
        font-size: 14px;
    }

    .product_name_with_price .product_price {
        text-align: left;
    }


    .sticky_product_right .sticky_btn {
        text-align: right;
        display: flex;
        align-items: center;
    }

    .sticky_product_right .sticky_btn button {
        border: 1px solid var(--primary_color);
        background-color: var(--primary_color);
        color: var(--primary_text_color);
        display: inline-block;
        font-size: 15px;
        padding: 9px 30px;
        transition: .3s;
    }

    .sticky_product_right .sticky_btn a {
        border: 1px solid var(--primary_color);
        background-color: var(--primary_color);
        color: var(--primary_text_color);
        display: inline-block;
        font-size: 15px;
        padding: 9px 30px;
        transition: .3s;
    }

    .sticky_product_right .sticky_btn button.sticky_btn_add_to_cart {
        border: 1px solid #06d6a0;
        background-color: #06d6a0;
        color: var(--white);
        margin-right: 10px;
    }

    .sticky_product_right .sticky_btn a.sticky_btn_add_to_cart {
        border: 1px solid #06d6a0;
        background-color: #06d6a0;
        color: var(--white);
        margin-right: 10px;
    }

    .sticky_product_right .sticky_btn button:hover {
        border: 1px solid var(--black);
        background-color: var(--black);
        color: var(--white);
    }

    .sticky_product_right .sticky_btn a:hover {
        border: 1px solid var(--black);
        background-color: var(--black);
        color: var(--white);
    }

    .sticky_product_right {
        display: flex;
        align-items: center;
        justify-content: end;
        height: 100%;
    }


    /*
==============================================================
    Search Product Area Css
==============================================================
*/
    ._search_product {
        box-shadow: var(--shadow);
        background-color: var(--white);
        z-index: 9999999;
        position: absolute;
        top: 100%;
        left: 0;
        width: 100%;
        border-radius: 3px;
        overflow-y: auto;
        max-height: 400px;
    }


    ._search_product::-webkit-scrollbar {
        width: 5px;
    }


    ._search_product::-webkit-scrollbar-track {
        background: var(--white);
    }


    ._search_product::-webkit-scrollbar-thumb {
        background: var(--primary_color);
    }

    ._search_product ul {}

    ._search_product ul li {
        display: block;
        overflow: hidden;
        border-bottom: 1px solid var(--border);
        padding: 2px 5px;
    }

    ._search_product_content {}

    ._search_product_content ._search_product_image {
        float: left;
        margin-right: 10px;
    }

    ._search_product_content ._search_product_image img {
        width: 50px;
        height: 50px;
    }

    ._search_product_content ._search_product_details {}

    ._search_product_details ._search_product_name h5 {
        font-size: 16px;
        font-weight: 500;
        -webkit-transition: 0.5s;
        -o-transition: 0.5s;
        transition: 0.5s;
    }

    ._search_product_details ._search_product_price {}

    ._search_product_details ._search_product_price ._new_price {
        color: var(--primary_color);
        font-weight: 500;
        font-size: 14px;
    }

    ._search_product_details ._search_product_price ._discount_price {
        color: red;
        text-decoration: line-through;
        font-weight: 500;
        padding-left: 6px;
        font-size: 14px;
    }

    ._search_product ul li:hover ._search_product_details ._search_product_name h5 {
        color: var(--primary_color);
    }





    /*
==============================================================
    Banner Area Css
==============================================================
*/

    .slider_banner_item img {
        width: 100% !important;
        max-height: 550px !important;
    }

    .slider_banner_active .owl-nav div {
        background-color: var(--primary_color);
        border: 1px solid var(--primary_color);
        color: var(--white);
        width: 45px;
        height: 45px;
        line-height: 45px;
        text-align: center;
        font-size: 20px;
        position: absolute;
        top: 50%;
        margin-top: -23px;
        font-weight: 400;
        margin-left: 0px;
        -webkit-transition: 0.5s;
        -o-transition: 0.5s;
        transition: 0.5s;
    }

    .slider_banner_active .owl-nav div:hover {
        color: var(--white);
    }

    .slider_banner_active .owl-nav .owl-next {
        right: 0;
        margin-right: 0px;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    /*
==============================================================
    Banner Area Css
==============================================================
*/
    .banner_image img {
        width: 100%;
    }


    ._custom_padding_top_index_section {
        padding-top: 35px;
    }


    /*
==============================================================
    Shop By Category Area Css
==============================================================
*/
    .shop_by_category_item {
        overflow: hidden;
        border-radius: 10px;
    }

    .shop_by_category_item img {
        width: 100%;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
        overflow: hidden;
        aspect-ratio: 1 / 1;
        background-size: cover;
        height: 100%;
    }

    .shop_by_category_item:hover img {
        transform: scale(1.1);
    }

    /*
==============================================================
    Hot Deals Area Css
==============================================================
*/
    .hot_deals_item {
        overflow: hidden;
    }

    .hot_deals_item img {
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
        overflow: hidden;
        border-radius: 10px;
    }

    .hot_deals_item:hover img {
        transform: scale(1.1);
    }

    .hot_deals_active .owl-nav {
        position: absolute;
        top: -40px;
        right: 0;
        font-size: 22px;
    }

    .hot_deals_active .owl-nav .owl-prev {
        position: absolute;
        top: 0;
        right: 0;
        margin-right: 30px;
    }


    /*
==============================================================
    product types Area Css
==============================================================
*/
    .product_types_item {
        position: relative;
    }

    .product_types_item_link {
        background-color: var(--white);
        border-radius: 10px;
        margin: 1px 1px;
        display: block;
        margin-top: 15px;
        overflow: hidden;
    }

    .product_types_item:hover .product_types_image {
        transform: scale(1.1);
    }

    .product_types_name {
        text-align: center;
        position: absolute;
        bottom: 0;
        left: 0;
        right: 0;
        background: var(--white);
        margin-bottom: 5px;
        display: inline-block;
        width: max-content;
        margin: 0 auto;
        margin-bottom: 5px;
        padding: 2px 10px;
        border-radius: 3px;
    }

    .product_types_image {
        aspect-ratio: 1/1;
        text-align: center;
        margin: 0 auto;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;

    }

    .no_product_found_img_box {
        text-align: center;
    }

    .no_product_found_img {
        max-width: 800px;
        max-height: 500px;
        width: 100%;
        overflow: hidden;
    }

    .product_types_image img {
        display: block;
        width: 100%;
        border-radius: 3px;
    }

    .product_types_name p {
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
        font-size: 14px;
        font-weight: 500;
    }

    .product_types_name p:hover {
        color: var(--primary_color) !important;
    }

    .product_types_active .owl-nav div {
        background-color: var(--primary_color);
        border: 1px solid var(--primary_color);
        color: var(--white);
        width: 45px;
        height: 45px;
        line-height: 45px;
        text-align: center;
        font-size: 20px;
        position: absolute;
        top: 50%;
        margin-top: -23px;
        font-weight: 400;
        margin-left: 0px;
        -webkit-transition: 0.5s;
        -o-transition: 0.5s;
        transition: 0.5s;
    }

    .product_types_active .owl-nav div:hover {
        color: var(--white);
    }

    .product_types_active .owl-nav .owl-next {
        right: 0;
        margin-right: 0px;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    /*
==============================================================
    Skin Types Area Css
==============================================================
*/
    .skin_types_item {
        position: relative;
    }

    .skin_types_item_link {
        background-color: var(--white);
        border-radius: 10px;
        margin: 1px 1px;
        display: block;
        margin-top: 15px;
        overflow: hidden;
    }

    .skin_types_item:hover .skin_types_image {
        transform: scale(1.1);
    }

    .skin_types_name {
        text-align: center;
        position: absolute;
        bottom: 0;
        left: 0;
        right: 0;
        background: var(--white);
        margin-bottom: 5px;
        display: inline-block;
        width: max-content;
        margin: 0 auto;
        margin-bottom: 5px;
        padding: 2px 10px;
        border-radius: 3px;
    }

    .skin_types_image {
        aspect-ratio: 1/1;
        text-align: center;
        margin: 0 auto;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .skin_types_image img {
        display: block;
        width: 100%;
        border-radius: 3px;
    }

    .skin_types_name p {
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
        font-size: 14px;
        font-weight: 500;
    }

    .skin_types_name p:hover {
        color: var(--primary_color) !important;
    }

    .skin_types_active .owl-nav div {
        background-color: var(--primary_color);
        border: 1px solid var(--primary_color);
        color: var(--white);
        width: 45px;
        height: 45px;
        line-height: 45px;
        text-align: center;
        font-size: 20px;
        position: absolute;
        top: 50%;
        margin-top: -23px;
        font-weight: 400;
        margin-left: 0px;
        -webkit-transition: 0.5s;
        -o-transition: 0.5s;
        transition: 0.5s;
    }

    .skin_types_active .owl-nav div:hover {
        color: var(--white);
    }

    .skin_types_active .owl-nav .owl-next {
        right: 0;
        margin-right: 0px;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    /*
==============================================================
    Skin Concern Area Css
==============================================================
*/
    .skin_concern_item {
        position: relative;
    }

    .skin_concern_item_link {
        background-color: var(--white);
        border-radius: 10px;
        margin: 1px 1px;
        display: block;
        overflow: hidden;
    }

    .skin_concern_item:hover .skin_concern_image {
        transform: scale(1.1);
    }

    .skin_concern_name {
        text-align: center;
        position: absolute;
        bottom: 0;
        left: 0;
        right: 0;
        background: var(--white);
        margin-bottom: 5px;
        display: inline-block;
        width: max-content;
        margin: 0 auto;
        margin-bottom: 5px;
        padding: 2px 10px;
        border-radius: 3px;
    }

    .skin_concern_image {
        aspect-ratio: 1/1;
        text-align: center;
        margin: 0 auto;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .skin_concern_image img {
        display: block;
        width: 100%;
    }

    .skin_concern_name {
        text-align: center;
    }

    .skin_concern_name p {
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
        font-size: 14px;
        font-weight: 500;
    }

    .skin_concern_name p:hover {
        color: var(--primary_color) !important;
    }

    .skin_concern_active .owl-nav div {
        background-color: var(--primary_color);
        border: 1px solid var(--primary_color);
        color: var(--white);
        width: 45px;
        height: 45px;
        line-height: 45px;
        text-align: center;
        font-size: 20px;
        position: absolute;
        top: 50%;
        margin-top: -23px;
        font-weight: 400;
        margin-left: 0px;
        -webkit-transition: 0.5s;
        -o-transition: 0.5s;
        transition: 0.5s;
    }

    .skin_concern_active .owl-nav div:hover {
        color: var(--white);
    }

    .skin_concern_active .owl-nav .owl-next {
        right: 0;
        margin-right: 0px;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .header_up_call_link {
        display: flex;
        align-items: center;
        justify-content: end;
        font-size: 14px;
        color: var(--primary_text_color);
    }

    .header_up_website p {
        color: var(--primary_text_color);
    }

    .header_up_website_link {
        color: var(--primary_text_color);
        font-weight: 700;
        display: flex;
        align-items: center;
    }


    .header_up_call_link svg {
        width: 27px;
        height: 15px;
        transform: rotate(15deg);
    }

    .header_up_call_link:hover {
        color: var(--primary_text_color);
    }

    .header_up {
        background-color: var(--primary_color);
        padding: 2px 0px;
    }

    /*
==============================================================
    Shop By Origin Area Css
==============================================================
*/
    .shop_by_origin_item {
        position: relative;
    }

    .shop_by_origin_item_link {
        background-color: var(--white);
        border-radius: 10px;
        margin: 1px 1px;
        display: block;
        overflow: hidden;
    }

    .shop_by_origin_item:hover .shop_by_origin_image {
        transform: scale(1.1);
    }

    .shop_by_origin_name {
        text-align: center;
        position: absolute;
        bottom: 0;
        left: 0;
        right: 0;
        background: var(--white);
        margin-bottom: 5px;
        display: inline-block;
        width: max-content;
        margin: 0 auto;
        margin-bottom: 5px;
        padding: 2px 10px;
        border-radius: 3px;
    }

    .shop_by_origin_image {
        aspect-ratio: 1/1;
        text-align: center;
        margin: 0 auto;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
        width: 100%;
        max-height: 150px;
        display: block;
        display: flex;
        justify-content: center;
    }

    .shop_by_origin_image img {
        display: block;
        max-width: 100%;
        height: 100%;
        object-position: center;
    }

    .shop_by_origin_name {
        text-align: center;
    }

    .shop_by_origin_name p {
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
        font-size: 14px;
        font-weight: 500;
    }

    .shop_by_origin_name p:hover {
        color: var(--primary_color) !important;
    }

    .shop_by_origin_active .owl-nav div {
        background-color: var(--primary_color);
        border: 1px solid var(--primary_color);
        color: var(--white);
        width: 45px;
        height: 45px;
        line-height: 45px;
        text-align: center;
        font-size: 20px;
        position: absolute;
        top: 50%;
        margin-top: -23px;
        font-weight: 400;
        margin-left: 0px;
        -webkit-transition: 0.5s;
        -o-transition: 0.5s;
        transition: 0.5s;
    }

    .shop_by_origin_active .owl-nav div:hover {
        color: var(--white);
    }

    .shop_by_origin_active .owl-nav .owl-next {
        right: 0;
        margin-right: 0px;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    /*
==============================================================
    Product Collection Area Css
==============================================================
*/
    .product_collection_table_cell {
        display: flex;
        align-items: center;
        justify-content: space-between;
    }

    .product_collection_link a {
        border: 1px solid var(--border);
        color: var(--black);
        padding: 10px 20px;
        border-radius: 5px;
        display: flex;
        align-items: center;
        gap: 10px;
        transition: .3s;
    }

    .product_collection_link a:hover {
        border-color: 1px solid var(--primary_color);
        color: var(--primary_color);
    }

    .product_collection {
        overflow: hidden;
    }

    .collection_image {
        position: relative;
        transition: .3s;
        overflow: hidden;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .collection_image::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: rgba(1, 15, 28, .5);
        border-radius: 5px;
    }

    .collection_image img {
        width: 100%;
        border-radius: 3px;
        overflow: hidden;
        width: 100%;
        max-height: 100%;
        object-fit: contain;
        object-position: center;
    }

    .product_details {
        position: absolute;
        bottom: 30px;
        left: 0;
        right: 0;
        text-align: center;
        z-index: 999999;
        transition: .3s;
        margin-bottom: 25px;
    }

    .collection_link {
        font-size: 26px;
        font-weight: 600;
        color: var(--white);
        background-image: linear-gradient(#fff, #fff), linear-gradient(#fff, #fff);
        background-position: 100% 100%, 0 88%;
        background-repeat: no-repeat;
        background-size: 0 1px, 0 1px;
        transition: background-size .4s linear;
    }

    .collection_link:hover {
        color: var(--white);
    }

    .product_details p {
        font-weight: 500;
        color: var(--white);
        font-size: 18px;
        margin-top: 5px;
    }

    .collection_link:hover {
        background-size: 0 1px, 100% 1px;
    }

    .product_collection:hover .collection_image {
        transform: scale(1.1);
    }

    .sp_product_brand {
        display: flex;
        align-items: center;
        margin-top: 10px;
    }

    .sp_product_brand strong {
        width: 60px;
        font-weight: 500;
        display: inline-block;
        color: #000;
    }




    /*
==============================================================
    Best Selling Area Css
==============================================================
*/
    .best_belling_active .owl-nav {
        position: absolute;
        top: -40px;
        right: 0;
        font-size: 22px;
    }

    .best_belling_active .owl-nav .owl-prev {
        position: absolute;
        top: 0;
        right: 0;
        margin-right: 40px;
    }

    .best_belling_active .owl-nav .owl-prev,
    .best_belling_active .owl-nav .owl-next {
        width: 30px;
        height: 30px;
        border: 1px solid #efefef;
        display: flex;
        align-items: center;
        justify-content: center;
        border-radius: 5px;
    }



    .best_belling_active .icon {
        font-size: 16px;
        color #333;
    }


    /*
==============================================================
    Combo Products Area Css
==============================================================
*/
    .combo_products_active .owl-nav {
        position: absolute;
        top: -40px;
        right: 0;
        font-size: 22px;
    }

    .combo_products_active .owl-nav .owl-prev {
        position: absolute;
        top: 0;
        right: 0;
        margin-right: 30px;
    }


    /*
==============================================================
    Daily Offer Products Area Css
==============================================================
*/
    .daily_offer_active .owl-nav {
        position: absolute;
        top: -40px;
        right: 0;
        font-size: 22px;
    }

    .daily_offer_active .owl-nav .owl-prev {
        position: absolute;
        top: 0;
        right: 0;
        margin-right: 30px;
    }




    /*
==============================================================
    Brand Image Slide Area Css
==============================================================
*/
    /* .brand_image_slider.owl-carousel .owl-item .brand_image_slide_item */
    .brand_image_slider .brand_image_slide_item {
        width: 100%;
        aspect-ratio: 1/1;
        border-radius: 3px;
        border: 1px solid rgba(0, 0, 0, 0.15);
        padding: 5px 10px;
        display: flex;
        flex-direction: column;
        justify-content: center;
    }

    .brand_image_slider .brand_image_slide_item img {
        max-width: 100%;
        max-height: 100%;
        object-fit: cover;
        /* cursor: pointer; */
    }

    .brand_image_area_title_subtitle h5 {
        font-size: 18px;
        font-weight: 600;
    }

    .brand_image_area_title_subtitle p {
        font-size: 16px;
        font-weight: normal;
    }

    .brand_image_area_see_all_btn a {
        background: var(--primary_color);
        border-radius: 5px;
        padding: 5px 10px;
        font-size: 16px;
        color: #000;
        white-space: nowrap;
        color: #ffffff;
        line-height: 0 !important;
        padding-top: 2px;
        padding-bottom: 4px;
    }

    .our_brand_relation {
        position: relative;
    }

    .brand_image_area_see_all_btn {
        text-align: right;
        position: absolute;
        top: 15px;
        right: 0;
    }

    /* ------- */
    .brand_image_slide_item {
        width: 100%;
        aspect-ratio: 1/1;
        border-radius: 3px;
        border: 1px solid rgba(0, 0, 0, 0.15);
        padding: 5px 10px;
        display: flex;
        flex-direction: column;
        justify-content: center;
    }

    .brand_image_slide_item img {
        max-width: 100%;
        max-height: 100%;
        object-fit: cover;
        cursor: pointer;
    }







    /*
==============================================================
    Product Cart Area Css
==============================================================
*/
    .brand_ordering {}

    .brand_ordering .brand_ordering_ul {
        display: flex;
        align-items: center;
        justify-content: center;
        flex-wrap: wrap;
        gap: 10px;
    }

    .brand_ordering .brand_ordering_ul li {}

    .brand_ordering .brand_ordering_ul li .brand_ordering_link {
        display: block;
        width: 40px;
        height: 40px;
        line-height: 40px;
        text-align: center;
        color: var(--black);
        border-radius: 100%;
        font-weight: 500;
    }

    .brand_ordering .brand_ordering_ul li.active .brand_ordering_link {
        background-color: var(--primary_color);
        color: var(--primary_text_color);
    }

    .brand_title {
        background-color: #f5f4f7;
        padding: 15px 25px;
        border-radius: 5px;
    }


    .brand_list {}

    .brand_list ul {
        /* display: flex; */
        /* flex-wrap: wrap; */
        margin-top: 10px;
    }

    .brand_list.shop_brans_list ul {
        margin-top: 0px !important;
    }

    .brand_list.shop_brans_list {
        padding-top: 0px;
    }

    .brand_list ul li {
        /* width: 48%; */
        display: inline-block;
    }

    .brand_list ul li .brand_list_link {
        /* color: var(--black); */
        /* margin-top: 3px; */
        /* display: flex; */
        /* align-items: center; */
        /* flex-direction: column; */
    }

    .brand_list ul li .brand_list_link {
        color: var(--black);
        margin-top: 3px;
        /* display: flex; */
        /* align-items: center; */
        /* flex-direction: column; */
        /* width: 150px;
    height: 150px; */
        display: block;
    }

    .brand_list ul li .brand_list_link:hover {
        color: var(--primary_color);
    }

    .shop_brans_list ul li {
        width: 100%;
    }









    /*
==============================================================
    Product Cart Area Css
==============================================================
*/

    .product_card {
        /* padding: 8px; */
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
        /* box-shadow: var(--shadow); */
        background-color: var(--white);
    }

    .product_cart_slide {
        margin: 0px 2px 8px 2px;
    }

    .product_card:hover {
        /* -webkit-box-shadow: 1px 12px 13px -12px rgba(0, 0, 0, 0.5); */
        /* box-shadow: 1px 12px 13px -12px rgba(0, 0, 0, 0.5); */
        border-color: var(--primary_color);
    }

    .product_image {
        position: relative;
        width: 100%;
        aspect-ratio: 1/1;
        /* max-height: 280px; */
        overflow: hidden;
        background-color: #F2F2F2;
    }

    .cart_wishlist_btn {
        border: none;
        background: transparent;
        font-size: 20px;
        position: absolute;
        top: 0;
        right: 0;
        margin-top: 10px;
        margin-right: 10px;
        color: var(--primary_color);
        cursor: pointer;
    }

    .product_image img {
        width: 100%;
        height: 100%;
        -o-object-fit: cover;
        object-fit: cover;
        transition: .3s;
    }

    .product_card:hover .product_image img {
        transform: scale(1.1);
    }

    .product_discount {
        position: absolute;
        top: 10px;
        left: 10px;
        /* -webkit-clip-path: polygon(0% 0%, 75% 0%, 100% 50%, 75% 100%, 0% 100%); */
        /* clip-path: polygon(0% 0%, 75% 0%, 100% 50%, 75% 100%, 0% 100%); */
        background-color: var(--primary_color);
        color: var(--white);
        font-size: 12px;
        line-height: 20px;
        text-align: center;
        width: 30px;
        height: 30px;
        text-align: center;
        border-radius: 100%;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .new_product {
        position: absolute;
        top: 0;
        left: 0;
        margin-top: 5px;
        -webkit-clip-path: polygon(0% 0%, 75% 0%, 100% 50%, 75% 100%, 0% 100%);
        clip-path: polygon(0% 0%, 75% 0%, 100% 50%, 75% 100%, 0% 100%);
    }

    .new_product span {
        background-color: var(--primary_color);
        color: var(--white);
        font-size: 14px;
        padding: 1px 8px 1px 5px;
        border-radius: 0px 3px 3px 0px;
    }

    .product_rating span {
        color: orange;
        font-size: 13px;
    }

    .product_rating span.no_rating {
        color: #000000;
    }

    .product_rating span.cart_rating_count {
        color: #000000;
    }

    .product_name {
        margin-top: 15px;
    }

    .product_price {
        margin: 0px 0px;
        text-align: center;
    }

    .product_name_link h2 {
        font-size: 17px;
        color: var(--black);
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
        line-height: 21px;
        display: inline-block;
        overflow: hidden;
        height: 44px;
        font-weight: 500;
        padding: 0px 5px;
    }

    .product_name_link h2:hover {
        color: var(--black);
        display: inline-block;
    }

    /* .product_name_link{
        font-size: 17px;
        color: var(--black);
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
        line-height: 20px;
        display: inline-block;
        overflow: hidden;
        height: 20px;
        font-weight: 500;
        padding: 0px 5px;
    }

    .product_name_link h2 {
        font-size: 18px;
        color: var(--black);
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
        line-height: 18px;
        display: inline-block;
        overflow: hidden;
        height: 20px;
        font-weight: 500;
    }

    .product_name_link h2:hover {
        color: var(--black);
        display: inline-block;
    } */

    .product_new_price {
        font-size: 16px;
        color: var(--primary_color);
        font-weight: 600;
    }

    .product_discount_price {
        font-size: 16px;
        color: red;
        text-decoration: line-through;
        padding-left: 8px;
        font-weight: 500;
    }

    .scroll_discount_price {
        color: red;
        text-decoration: line-through;
    }



    .header_top_list ul li .header_top_list_link.h_wishlist_ico svg {
        width: 33px;
        height: 31px;
    }

    .product_btn {
        text-align: center;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .product_btn_link {
        color: var(--primary_text_color);
        background-color: var(--primary_color);
        display: block;
        max-width: 100%;
        text-align: center;
        padding: 5px 15px;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
        cursor: pointer;
        font-size: 14px;
    }

    .product_btn_link_stock_out {
        color: black !important;
        background-color: rgb(218, 218, 218) !important;
        display: block;
        max-width: 100%;
        text-align: center;
        padding: 5px 15px;
        cursor: not-allowed;
        ;
        transition: 0.3s;
        font-size: 14px;
        cursor: not-allowed !important;
        border: none !important;
        font-weight: 500;
    }

    .out_of_stock_bottom {
        color: var(--white) !important;
    }


    .single_page_stock_out_btn {
        border-radius: 3px;
        cursor: not-allowed !important;
    }


    .product_btn_mobile {
        padding: 0px 0px;
        margin-bottom: 10px;
        margin-top: 5px;
        display: none;
    }

    .product_btn_link:hover {
        color: var(--primary_text_color);
    }

    .product_btn_link i {
        padding-right: 5px;
    }

    .cart_review {
        color: var(--black) !important;
    }


    .product_card {
        position: relative;
        padding: 5px;
        z-index: 9;
    }

    .product_card:hover::before,
    .product_card:hover::after {
        width: 100%;
        height: 100%;
    }

    .product_card::before {
        top: 0;
        left: 0;
    }

    .product_card::before,
    .product_card::after {
        box-sizing: inherit;
        content: '';
        position: absolute;
        z-index: -1;
        width: 0;
        height: 0;
        transition: color 0.3s;
        border: 2px solid transparent;
    }

    .product_card:hover::before {
        border-top-color: var(--primary_color);
        border-right-color: var(--primary_color);
        transition: width 0.3s ease-out,
            height 0.3s ease-out 0.3s;
    }

    .product_card:hover::after {
        border-bottom-color: var(--primary_color);
        border-left-color: var(--primary_color);
        transition: height 0.3s ease-out,
            width 0.3s ease-out 0.3s;
    }

    .product_card::after {
        top: 0;
        bottom: 0;
        left: 0;
        right: 0;
    }






    /*
==============================================================
    Service Area Css
==============================================================
*/
    .service_item {
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .service_item {
        display: flex;
        align-items: center;
        gap: 15px;
        border: 1px solid var(--border);
        padding: 10px 25px;
        border-radius: 3px;
    }

    .service_icon svg {
        width: 40px;
        height: 40px;
    }

    .service_title h4 {
        font-size: 18px;
    }

    .service_description p {
        font-size: 16px;
        font-weight: 300;
    }









    /*
==============================================================
    Wishlist Area Css
==============================================================
*/
    .wishlist_image img {
        width: 60px;
        height: 60px;
    }

    .wishlist_name_link {
        color: var(--black);
        display: block;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .wishlist_name_link:hover {
        color: var(--hover);
    }

    .wishlist_action_link {
        border: none;
        background-color: var(--black);
        color: var(--white);
        font-size: 14px;
        display: inline-block;
        padding: 3px 10px;
        border-radius: 3px;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .wishlist_action_link:hover {
        color: var(--hover);
    }

    .wishlist_delete_link {
        border: none;
        background-color: transparent;
        font-size: 18px;
        color: var(--black);
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .wishlist_delete_link:hover {
        color: var(--hover);
    }

    /*
==============================================================
    View Cart Area Css
==============================================================
*/
    .btn_disabled {
        pointer-events: none;
        opacity: 0.65;
    }

    .view_cart_shipping_content {
        border-top: 1px solid var(--border);
        border-bottom: 1px solid var(--border);
        padding: 20px 0px;
    }

    .view_cart_subtotal {
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
        -webkit-box-pack: justify;
        -ms-flex-pack: justify;
        justify-content: space-between;
        padding-bottom: 15px;
        padding-top: 10px;
    }

    .view_cart_subtotal strong {
        font-size: 20px;
        font-weight: 500;
    }

    .view_cart_total {
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
        -webkit-box-pack: justify;
        -ms-flex-pack: justify;
        justify-content: space-between;
        padding-top: 25px;
        margin-bottom: 25px;
    }

    .view_cart_total strong {
        font-size: 20px;
        font-weight: 500;
    }

    .view_cart_image img {
        width: 60px;
        height: 60px;
    }

    .view_cart_name_link {
        color: var(--black);
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .view_cart_name_link:hover {
        color: var(--hover);
    }

    .view_cart_action_link {
        border: none;
        background-color: var(--black);
        color: var(--white);
        font-size: 14px;
        display: inline-block;
        padding: 3px 10px;
        border-radius: 3px;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .view_cart_action_link:hover {
        color: var(--hover);
    }

    .view_cart_delete_link {
        border: none;
        background-color: transparent;
        font-size: 18px;
        color: var(--black);
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .view_cart_delete_link:hover {
        color: var(--hover);
    }

    .view_cart_qty_minus {
        border: 1px solid var(--border);
        color: var(--black);
        width: 40px;
        height: 40px;
        line-height: 40px;
        text-align: center;
        border-right: 0px;
        float: left;
        border-radius: 3px 0px 0px 3px;
        cursor: pointer;
        background-color: transparent;
    }

    .view_cart_qty input {
        border: 1px solid var(--border);
        color: var(--black);
        width: 50px;
        height: 40px;
        line-height: 40px;
        text-align: center;
        float: left;
        cursor: pointer;
    }

    .view_cart_qty_plus {
        border: 1px solid var(--border);
        color: var(--black);
        width: 40px;
        height: 40px;
        line-height: 40px;
        text-align: center;
        border-left: 0px;
        float: left;
        border-radius: 0px 3px 3px 0px;
        cursor: pointer;
        background-color: transparent;
    }

    .view_cart_right_side {
        background: var(--white);
        -webkit-box-shadow: 0px 30px 70px rgba(1, 15, 28, 0.1);
        box-shadow: 0px 30px 70px rgba(1, 15, 28, 0.1);
        padding: 36px 24px 28px;
    }

    .view_cart_process_checkout_link {
        display: inline-block;
        color: var(--white);
        background-color: var(--primary_color);
        border: 1px solid var(--primary_color);
        width: 100%;
        text-align: center;
        padding: 10px 0px;
        border-radius: 3px;
        font-size: 18px;
        text-transform: capitalize;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .view_cart_process_checkout_link:hover {
        color: var(--primary_color);
        background-color: var(--white);
        border: 1px solid var(--primary_color);
    }

    .view_cart_coupon {
        position: relative;
    }

    .view_cart_coupon label {
        display: block;
    }

    .view_cart_coupon input {
        border: 1px solid var(--border);
        padding: 10px 10px;
        width: 450px;
        height: 50px;
    }

    .view_cart_coupon_update {
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
        -webkit-box-pack: justify;
        -ms-flex-pack: justify;
        justify-content: space-between;
        margin-top: 20px;
    }

    .view_cart_coupon_btn {
        position: absolute;
        top: 0;
        right: 0;
        border: none;
        background: var(--primary_color);
        color: var(--white);
        padding: 10px 20px;
        display: inline-block;
        height: 50px;
    }

    .view_cart_update_btn {
        border: none;
        background-color: var(--primary_color);
        color: var(--white);
        display: inline-block;
        padding: 12px 25px;
        border-radius: 3px;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .view_cart_update_btn:hover {
        color: var(--black);
    }

    .product_shipping {
        -webkit-box-shadow: var(--shadow);
        box-shadow: var(--shadow);
        padding: 20px;
        border-radius: 3px;
    }

    .shipping_option_item {
        margin-top: 10px;
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
    }

    .shipping_option_item input[type="radio"] {
        -webkit-appearance: none;
        -moz-appearance: none;
        appearance: none;
        height: 20px;
        width: 20px;
        background-color: var(--white);
        border: 1px solid var(--border);
        border-radius: 3px;
        cursor: pointer;
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        outline: none;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
        -webkit-box-pack: center;
        -ms-flex-pack: center;
        justify-content: center;
        float: left;
        margin-right: 10px;
    }

    .shipping_option_item label {
        color: var(--black);
        font-size: 16px;
        cursor: pointer;
    }

    .shipping_option_item input[type="radio"]:after {
        font-family: "Font Awesome 6 Free";
        content: "\f00c";
        font-weight: 600;
        font-size: 16px;
        color: var(--white);
        display: none;
    }

    .shipping_option_item input[type="radio"]:checked {
        background-color: var(--hover);
    }

    .shipping_option_item input[type="radio"]:checked:after {
        display: block;
    }

    .shipping_option_item label,
    .shipping_option_item input {
        cursor: pointer;
    }



    /*
==============================================================
    Map Area Css
==============================================================
*/

    .map-area {
        -webkit-box-shadow: 0px 0px 2px 0px rgba(0, 0, 0, 0.5);
        box-shadow: 0px 0px 2px 0px rgba(0, 0, 0, 0.5);
        padding: 16px 16px 16px 16px;
    }



    /*
==============================================================
    Footer Area Css
==============================================================
*/
    .footer_area {
        background-color: var(--footer_background_color);
        padding-top: 60px;
    }

    .footer_logo img {
        height: 50px;
    }

    .footer_description {
        margin-top: 15px;
    }

    .footer_description p {
        color: var(--white);
    }

    .footer_title {
        margin-bottom: 15px;
    }

    ._footer_title h2 {
        color: var(--footer_text_color);
    }

    .footer_title h4 {
        color: var(--white);
        font-size: 20px;
        font-weight: 500;
        position: relative;
        display: inline-block;
    }

    .footer_title h4::after {
        content: "";
        width: 60%;
        background: var(--white);
        height: 2px;
        display: block;
        margin-top: 1px;
    }

    .footer_list ul {
        margin: 0;
        padding: 0;
    }

    .footer_list ul li {
        list-style: none;
        margin-bottom: 5px;
    }

    .footer_list ul li:last-child {
        margin-bottom: 0px;
    }

    .footer_list ul li .footer_list_link {
        display: inline-block;
        color: var(--white);
        font-size: 16px;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .footer_list ul li .footer_list_link:hover {
        /* color: var(--white); */
    }

    .footer_payment_method img {
        width: 100%;
    }

    .footer_bottom {
        border-top: 1px solid #ced4da4d;
        padding: 10px 0px;
    }

    .fixed_footer_menu ul li .fixed_footer_menu_link._category_ svg {
        width: 20px !important;
        height: 20px !important;
    }

    .footer_copyright p {
        color: var(--white);
    }

    .footer_develop_by {
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
        gap: 10px;
    }

    .footer_develop_by {
        float: right;
    }

    .footer_develop_by p {
        color: var(--white);
    }

    .footer_develop_by_link {
        color: var(--black);
        font-weight: 500;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .footer_develop_by_link {
        color: var(--primary_color);
    }

    .footer_social {
        margin-bottom: 20px;
        margin-top: 20px;
    }

    .footer_social ul {
        margin: 0;
        padding: 0;
    }

    .footer_social ul li {
        list-style: none;
        display: inline-block;
        margin-right: 3px;
    }

    .footer_social ul li:last-child {
        margin-right: 0px;
    }

    .footer_social ul li .footer_social_link {
        display: block;
        border: 1px solid var(--border);
        color: var(--white);
        width: 40px;
        height: 40px;
        line-height: 40px;
        text-align: center;
        font-size: 22px;
        border-radius: 3px;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .footer_social ul li .footer_social_link:hover {
        border: 1px solid var(--border);
        background-color: var(--white);
        color: var(--black);
    }

    .footer_iframe iframe {
        width: 100%;
        height: 120px;
    }

    .footer_app_img h2 {
        font-size: 25px;
        margin-bottom: 10px;
        margin-top: 27px;
    }

    .single_product_details {
        /* padding-left: 15px; */
    }

    ._footer_top {
        margin-bottom: 50px;
    }

    ._footer_title {
        margin-bottom: 25px;
    }

    ._footer_para {
        margin-top: 25px;
        margin-bottom: 25px;
    }

    ._footer_para p {
        color: var(--footer_text_color);
    }

    ._footer_social {}

    ._footer_social ul {}

    ._footer_social ul li {
        display: inline-block;
        margin-right: 10px;
    }

    ._footer_social ul li:last-child {
        margin-right: 0px;
    }

    ._footer_social ul li ._footer_social_link {
        display: block;
        border: 1px solid var(--white);
        width: 40px;
        height: 40px;
        line-height: 40px;
        text-align: center;
        color: var(--white);
        border-radius: 3px;
    }

    ._footer_title p {
        font-size: 23px;
        color: var(--black);
        font-weight: 500;
    }

    ._footer_list {}

    ._footer_list ul {}

    ._footer_list ul li {
        margin-bottom: 10px;
        position: relative;
    }

    ._footer_list ul li:last-child {
        margin-bottom: 0px;
    }

    ._footer_list ul li ._footer_list_link p {
        color: var(--footer_text_color);
    }

    ._footer_list ul li ._footer_list_link p {
        color: var(--footer_text_color);
        padding-left: 15px;
    }

    ._footer_list ul li ._footer_list_link p::after {
        content: '';
        position: absolute;
        top: 50%;
        transform: translateY(-50%);
        left: 0;
        width: 5px;
        height: 5px;
        background: var(--footer_text_color);
        border-radius: 100%;
    }

    ._footer_number p {
        color: var(--footer_text_color);
    }

    ._footer_number a {
        font-size: 28px;
        color: var(--footer_text_color);
        font-weight: 500;
        display: block;
        padding-top: 10px;
    }

    ._footer_email a {
        display: flex;
        align-items: center;
        gap: 10px;
        font-size: 20px;
        color: var(--footer_text_color);
    }

    ._footer_email a:hover {
        color: var(--black);
    }

    ._footer_address i {
        font-size: 20px;
        float: left;
        width: 30px;
        display: block;
        overflow: hidden;
        color: var(--footer_text_color);
        margin-top: 3px;
    }

    ._footer_address p {
        font-size: 18px;
        color: var(--footer_text_color);
        display: block;
        overflow: hidden;
    }

    ._footer_email {
        margin-top: 25px;
        margin-bottom: 15px;
    }



    .footer_payment_img {
        width: 100%;
        height: 100%;
        display: flex;
        align-items: center;
        justify-content: center;
    }


    .footer_payment_img img {
        width: 100%;
        height: 100%;
    }


    /*
==============================================================
    Header Mobile Device Area Css
==============================================================
*/
    .header_mobile_table_cell {
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
        -webkit-box-pack: justify;
        -ms-flex-pack: justify;
        justify-content: space-between;
    }

    .header_mobile_toggle {
        line-height: 0;
    }

    .header_mobile_toggle i {
        font-size: 22px;
        color: var(--primary_color);
    }

    .header_mobile_search {
        line-height: 0px;
    }

    .header_mobile_search i {
        font-size: 22px;
        color: var(--primary_color);
    }

    .header_mobile_icon_link {
        position: relative;
    }

    .header_mobile_icon_link i {
        font-size: 22px;
        color: var(--primary_color);
    }

    /*
==============================================================
    Breadcrumb Area Css
==============================================================
*/
    ._breadcrumb {
        line-height: 14px;
    }

    ._breadcrumb ul {
        margin: 0;
        padding: 0;
    }

    ._breadcrumb ul li {
        list-style: none;
        display: inline-block;
        margin-right: 5px;
    }

    ._breadcrumb ul li:last-child {
        margin-right: 0px;
    }

    ._breadcrumb ul li .breadcrumb_link {
        display: block;
        color: var(--black);
        font-size: 14px;
        line-height: 12px;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    ._breadcrumb ul li .breadcrumb_link:hover {
        color: var(--hover);
    }

    /*
==============================================================
    Shop Category Area Css
==============================================================
*/
    .shop_category ul {
        margin: 0;
        padding: 0;
    }

    .shop_category ul li {
        list-style: none;
        display: inline-block;
        margin-right: 1px;
        margin-bottom: 5px;
    }

    .shop_category ul li:last-child {
        margin-right: 0px;
    }

    .shop_category ul li .shop_category_link {
        display: block;
        font-size: 14px;
        color: var(--white);
        background-color: var(--primary_color);
        padding: 3px 10px;
        text-transform: uppercase;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .shop_category ul li .shop_category_link:hover {
        color: var(--black);
    }

    /*
==============================================================
    Single Product Area Css
==============================================================
*/

    .single_page_right_container {
        width: 100%;
    }

    .zooming_show_image {
        /* position: relative; */
        /* height: 500px; */
        overflow: hidden;
        /* box-shadow: -1px 5px 15px #000; */
    }

    .zooming_show_image img {
        width: 100%;
        height: 100%;
        border-radius: 10px;
        /* position: absolute; */
        /* object-fit: contain; */
        -webkit-transform: scale(var(--zoom, 1));
        -ms-transform: scale(var(--zoom, 1));
        transform: scale(var(--zoom, 1));
        -webkit-transform-origin: var(--x) var(--y);
        -ms-transform-origin: var(--x) var(--y);
        transform-origin: var(--x) var(--y);
        -webkit-transition: -webkit-transform 0.3s ease;
        transition: -webkit-transform 0.3s ease;
        -o-transition: transform 0.3s ease;
        transition: transform 0.3s ease;
        transition: transform 0.3s ease, -webkit-transform 0.3s ease;
        cursor: -webkit-zoom-in;
        cursor: zoom-in;
    }

    .zooming_image_list {
        align-items: center;
        gap: 10px;
        /* margin-top: 10px; */
    }

    .zooming_image_list ul {
        margin: 0;
        padding: 0;
        align-items: center;
        overflow-x: scroll;
        float: left;
    }

    .zooming_image_list ul::-webkit-scrollbar {
        height: 5px;
        cursor: pointer;
    }

    .zooming_image_list ul::-webkit-scrollbar-thumb {
        background: var(--primary_color);
        cursor: pointer;
    }

    .zooming_image_list ul li {
        display: block;
        margin-right: 1px;
        margin-bottom: 5px;
    }

    .zooming_image_list ul li:last-child {
        margin-right: 0px;
    }

    .zooming_image_list ul li img {
        width: 80px;
        height: 80px;
        margin-right: 5px;
        border-radius: 3px;
        cursor: pointer;
        border: 0.5px solid #dddddd;
        /* opacity: 0.2; */
    }

    .zooming_show_image:hover {
        --zoom: 3;
        border-radius: 10px;
    }

    .zooming_image_list ul li.active img {
        border: 2.5px solid red;
        /* opacity: 1; */
    }

    .single_product_list ul {
        margin: 0;
        padding: 0;
    }

    .single_product_list ul li {
        list-style: none;
        display: inline-block;
        margin-right: 5px;
    }

    .single_product_list ul li:last-child {
        margin-right: 0px;
    }

    .single_product_list ul li:not(:last-child):after {
        content: "";
        position: relative;
        font-size: 12px;
        font-weight: 600;
        font-family: "Font Awesome 5 Free";
        color: var(--black);
        margin-left: 5px;
    }

    .single_product_list ul li .single_product_list_link {
        display: inline-block;
        font-size: 14px;
        color: var(--black);
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .single_product_list ul li .single_product_list_link:hover {
        color: var(--hover);
    }

    .single_product_name {
        margin-bottom: 15px;
    }

    .single_product_name h2 {
        font-size: 25px;
        font-weight: 600;
        text-transform: capitalize;
    }

    .single_product_new_price {
        font-size: 22px;
        color: var(--primary_color);
        font-weight: 600;
    }

    .single_product_whatsapp_link {
        color: #40c351;
        display: inline-block;
        border-bottom: 1px solid var(--white);
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .single_product_whatsapp_link:hover {
        color: #40c351;
    }

    .single_product_attribute {
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
    }

    .single_product_attribute strong {
        width: 60px;
        font-weight: 500;
    }

    .s_p_qty {
        width: 83px !important;
    }


    .single_product_discount_price {
        color: red;
        text-decoration: line-through;
        padding-left: 10px;
        font-weight: 600;
        font-size: 20px;
    }

    .single_payment_method_img img {
        height: 100%;
        width: auto;
    }

    .single_payment_method_img {
        height: 32px;
        width: 66px;
        display: flex;
        align-items: end;
        justify-content: end;
    }

    .single_payment_method {}

    .single_payment_method ul {
        display: flex;
        align-items: center;
        gap: 50px;
    }

    .single_payment_method ul li {
        display: flex;
        align-items: center;
        gap: 5px;
    }

    .single_product_attribute.sp_code,
    .single_product_attribute.sp_price,
    .single_payment_method {
        /* border-top: 1px solid var(--border);
    border-bottom: 1px solid var(--border); */
        padding: 10px 0px;
    }


    .social_share_icon ul {
        display: flex;
        align-items: center;
        gap: 20px;
        margin-top: 12px;
    }

    .social_share_icon ul li a {
        width: 29px;
        height: 29px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 15px;
    }

    .social_share_icon ul li:nth-child(1) a {
        background: #4267B2;
        color: var(--white);
    }

    .social_share_icon ul li:nth-child(2) a {
        background: #C13584;
        color: var(--white);
    }

    .social_share_icon ul li:nth-child(3) a {
        background: #1DA1F2;
        color: var(--white);
    }

    .social_share_icon ul li:nth-child(4) a {
        background: #25D366;
        color: var(--white);
    }



    .qty_text {
        font-weight: 400;
        width: 83px;
    }


    .sp_social {
        border-top: 1px solid var(--border);
        padding: 10px 0px;
    }

    .sp_wrap {
        max-width: 1400px;
        margin: 0 auto;
    }



    .sp_specification {
        margin-top: 10px;
    }

    .sp_specification ul {}

    .sp_specification ul li {
        margin-bottom: 10px;
    }

    .sp_specification ul li:last-child {}


    .sp_social {}

    .sp_social ul {}

    .sp_social ul li {
        display: inline-block;
        margin-right: 30px;
    }

    .sp_social ul li:last-child {
        margin-right: 0px;
    }

    .sp_social ul li .sp_social_link {
        color: var(--black);
        font-size: 17px;
    }


    .single_product_attribute_size {
        margin-top: -7px;
    }

    .single_product_size_checkbox_list ul li {
        display: inline-block;
        margin-right: 3px;
        margin-bottom: 7px;
    }

    .single_product_size_checkbox_list ul li:last-child {
        margin-right: 0px;
    }

    .single_product_size_checkbox_list_group {
        position: relative;
    }

    .single_product_size_checkbox_list_group .icon {
        margin-top: 10px;
        font-size: 30px;
        color: var(--black);
        -webkit-transition: all 200ms ease-in-out;
        -o-transition: all 200ms ease-in-out;
        transition: all 200ms ease-in-out;
    }

    .single_product_size_checkbox_list_group label:before {
        content: "✓";
        position: absolute;
        width: 20px;
        height: 18px;
        bottom: 0px;
        right: 0px;
        background: var(--primary_color);
        color: var(--white);
        text-align: center;
        line-height: 18px;
        font-size: 14px;
        font-weight: 600;
        /* border-radius: 50%; */
        opacity: 0;
        -webkit-transform: scale(0.5);
        -ms-transform: scale(0.5);
        transform: scale(0.5);
        -webkit-transition: all 200ms ease-in-out;
        -o-transition: all 200ms ease-in-out;
        transition: all 200ms ease-in-out;
        border-radius: 25px 0px 3px 0px;
        padding-left: 4px;
        padding-top: 2px;
    }

    .single_product_size_checkbox_list_group input:checked+label:before {
        opacity: 1;
        -webkit-transform: scale(1);
        -ms-transform: scale(1);
        transform: scale(1);
    }

    .single_product_size_checkbox_list_group input:checked+label .icon {
        color: var(--primary_color);
    }

    .single_product_size_checkbox_list_group input:checked+label {
        border: 1px solid var(--primary_color);
    }

    .single_product_qty_with_buy_now_btn {
        margin-top: 20px;
        margin-bottom: 20px;
    }

    .single_product_qty {
        display: flex;
        align-items: center;
    }

    .single_product_qty_minus {
        border: 1px solid var(--border);
        color: var(--black);
        width: 40px;
        height: 40px;
        line-height: 40px;
        text-align: center;
        border-right: 0px;
        border-radius: 3px 0px 0px 3px;
        cursor: pointer;
        background-color: transparent;
        float: left;
        display: block;
    }

    .single_product_name h1 {
        font-size: 25px;
        font-weight: 600;
    }


    .single_product_buy_now_btn_link {
        border: none;
        background-color: var(--primary_color);
        color: var(--primary_text_color);
        padding: 7px 5px;
        border-radius: 3px;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
        width: 100%;
        display: block;
        text-align: center;
    }

    .single_product_buy_now_btn_link:hover {
        color: var(--primary_text_color);
    }

    .single_product_call_details {
        border: 2px dotted var(--primary_color);
        padding: 10px;
    }

    .single_product_call_payment_method p {
        font-size: 14px;
        border: 1px dotted #ff4d03;
        display: inline;
        padding: 2px 5px;
        color: var(--primary_color);
        margin-left: 5px;
    }

    .single_product_tab_nav {
        margin-bottom: 20px;
        justify-content: center;
    }


    .single_product_tab ul li {
        margin-right: 15px;
        margin-bottom: 10px;
    }

    .single_product_tab ul li:last-child {
        margin-right: 0px;
    }

    .fixed_footer_menu ul li .fixed_footer_menu_link img {
        height: 30px;
    }

    .single_brand_img {
        /* width: 80px; */
        height: 50px;
        padding: 2px;
        margin-right: 7px;
        box-shadow: rgba(0, 0, 0, 0.15) 0px 0px 3px 0px;
        cursor: pointer;
    }

    .single_brand_img img {
        width: 100%;
        height: 100%;
        background-size: cover;
    }


    ._single_product_color {
        margin-bottom: 25px;
    }

    ._single_product_attribute_title {
        position: relative;
    }

    ._single_product_attribute_title h5 {
        margin: 0;
        /* font-weight: bold; */
        color: #000000;
        font-size: 16px;
        text-transform: capitalize;
        width: 75px;
        display: block;
        float: left;
        padding-top: 0px;
    }

    ._single_product_attribute_title span {
        line-height: 20px;
        display: block;
        color: #000000;
        font-size: 16px;
        text-transform: capitalize;
    }

    ._single_product_attribute_title i {
        font-size: 18px;
        font-weight: bold;
        cursor: pointer;
        position: absolute;
        top: 0px;
        right: 0;
        color: #A9ACAD;
    }

    ._single_product_attribute_value_image {
        margin-left: 75px;
        margin-top: 10px;
        position: relative;
    }

    ._single_product_attribute_value_image img {
        width: 60px;
        height: 60px;
        padding: 3px;
        cursor: pointer;
        border: 2.5px solid #ddd;
    }

    ._single_product_attribute_value_image .size_stock_out {
        /* background-color: red; */
        cursor: not-allowed !important;
        position: relative;
        border: 0.5px solid black;
        opacity: 0.2;
    }




    .__active_img_item {
        border: 1.5px solid #fbca51 !important;
    }

    .color_img_toggle {
        display: block;
    }

    .show_images {
        display: none;
    }

    .rotate_img_angle {
        transform: rotate(180deg);
        transition: 1s;
    }


    .video_icon_modal {
        position: relative;
    }

    .video_play_icon {
        position: absolute;
        left: 50%;
        top: 50%;
        transform: translate(-50%, -50%);
    }

    .video_icon_img {
        width: 50px !important;
        height: 40px !important;
        border: inherit !important;
    }

    .video_icon_img img {
        width: 100% !important;
        height: 100% !important;
        border: inherit !important;
    }


    .single_first_img_color {
        position: absolute;
        width: 95%;
        height: 100%;
        top: 0;
        left: 0;
        background: rgb(0 0 0 .1);
        background-color: #000000;
        opacity: 0.5;
        border-radius: 1px;
    }

    /* .youtube_video {
            width: 100%;
            height: 500px;
        }

        .youtube_video iframe {
            width: 100%;
            height: 100%;
            border-radius: 5px;
        } */


    .zooming_image_content {
        /* display: flex; */
        /* align-items: baseline; */
        /* gap: 6px; */
    }

    .youtube_video {
        width: 100%;
        height: 550px;
    }

    .youtube_video iframe {
        width: 100%;
        height: 100%;
        border-radius: 5px;
    }



    /*
==============================================================
    Single Product Area Css
==============================================================
*/
    .single_product_tab_content ul {
        margin-left: 28px;
    }

    .single_product_tab_content li {
        /* list-style:disc; */
    }

    .single_product_tab_content table td {
        border: 1px solid #dee2e6;
        padding: 6px 10px;
    }

    .zooming_show_image {
        overflow: hidden;
    }

    .zooming_show_image img {
        width: 100%;
        height: 100%;
        -webkit-transform: scale(var(--zoom, 1));
        -ms-transform: scale(var(--zoom, 1));
        transform: scale(var(--zoom, 1));
        -webkit-transform-origin: var(--x) var(--y);
        -ms-transform-origin: var(--x) var(--y);
        transform-origin: var(--x) var(--y);
        -webkit-transition: -webkit-transform 0.3s ease;
        transition: -webkit-transform 0.3s ease;
        -o-transition: transform 0.3s ease;
        transition: transform 0.3s ease;
        transition: transform 0.3s ease, -webkit-transform 0.3s ease;
        cursor: -webkit-zoom-in;
        cursor: zoom-in;
    }

    .zooming_show_image:hover {
        --zoom: 3;
    }

    .zoom_img_active .owl-dots img {
        width: 60px;
        cursor: pointer;
        border: 1px solid #ffffff;
    }

    .zoom_img_active .owl-dots div.active img {
        border-color: var(--primary_color);
    }

    .zoom_img_active .owl-dots div {
        display: inline-block;
        transition: 0.7s;
    }

    .zoom_img_active .owl-dots {
        text-align: left;
        overflow: hidden;
        white-space: nowrap;
        scroll-behavior: smooth;
    }

    .zoom_img_active .owl-dots div .video_icon_overlay::after {
        content: "\f167";
        position: absolute;
        top: 0;
        left: 0;
        transform: translate(-50%, -50%);
        color: #000000;
        background-color: #ffffff;
        width: 60px;
        height: 60px;
        line-height: 60px;
        font-size: 35px;
        font-weight: 600;
        font-family: "Font Awesome 6 Brands";
        opacity: .8;
        text-align: center;
    }

    .zoom_img_active .owl-dots div {
        position: relative;
    }

    .video_icon_overlay_content {
        position: absolute !important;
        top: 49% !important;
        left: 48% !important;
    }

    .zoom_img_active .owl-dots {
        position: relative;
        margin-top: 2px;
    }

    .zooming_image_content .youtube_video {
        line-height: 0;
    }

    .video_play_icon {
        position: absolute;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
        border: 2px solid #ffffff;
        padding: 0px 10px;
        color: #ffffff;
        font-size: 20px;
        border-radius: 3px;
        cursor: pointer;
    }

    .zoom_img_active .owl-nav .owl-prev,
    .zoom_img_active .owl-nav .owl-next {
        font-size: 20px;
        width: 20px;
        height: 20px;
        line-height: 20px;
        color: #9b9b9b;
        text-align: center;
        position: absolute;
        top: 45%;
        transform: translateY(-45%);
        opacity: 0;
        visibility: hidden;
        transition: .3s;
    }

    .zoom_img_active .owl-nav .owl-prev {
        left: 0;
    }

    .zoom_img_active .owl-nav .owl-next {
        right: 0;
    }

    .zooming_image_content:hover .zoom_img_active .owl-nav .owl-prev,
    .zooming_image_content:hover .zoom_img_active .owl-nav .owl-next {
        visibility: visible;
        opacity: 1;
    }

    .single_product_list ul {
        margin: 0;
        padding: 0;
        line-height: 1;
    }

    .single_product_list ul li {
        list-style: none;
        display: inline-block;
        margin-right: 5px;
        line-height: 1;
    }

    .single_product_list ul li:last-child {
        margin-right: 0px;
    }

    .single_product_list ul li:not(:last-child):after {
        content: "";
        position: relative;
        font-size: 12px;
        font-weight: 600;
        font-family: "Font Awesome 5 Free";
        color: var(--black);
        margin-left: 5px;
    }

    .single_product_list ul li .single_product_list_link {
        display: inline-block;
        font-size: 14px;
        color: var(--black);
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
        line-height: 1;
    }

    .single_product_list ul li .single_product_list_link:hover {
        color: var(--primary_color);
    }





    .single_product_attribute {
        display: flex;
        align-items: center;
    }

    .single_product_attribute_code {
        margin-bottom: 10px;
    }

    .single_product_attribute.s_p_code {
        margin-top: 10px;
        padding: 10px 0px;
    }

    .single_product_attribute.s_p_price {
        margin-top: 10px;
        padding: 10px 0px;
    }

    .select_attribute_container.s_p_select {
        margin-top: 10px;
    }

    .single_product_btn_group {
        display: block;
        padding-top: 20px;
    }

    .single_product_whatsapp_link {
        color: #40c351;
        display: inline-block;
        border-bottom: 1px solid var(--white);
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .single_product_whatsapp_link:hover {
        color: #40c351;
    }



    .single_product_whatsapp {
        margin-top: 10px;
    }



    .single_product_attribute_label {
        font-weight: normal;
        margin-bottom: 6px;
        display: block;
    }



    .single_product_attribute_size {
        margin-top: 3px;
    }

    .single_product_attribute_qty strong {
        font-weight: normal;
        margin-bottom: 2px;
        display: block;
    }

    .single_product_size_checkbox_list ul li {
        /* display: inline-block; */
        margin-right: 1px;
        margin-bottom: 2px;
        list-style: none;
    }

    .single_product_size_checkbox_list ul li:last-child {
        margin-right: 0px;
    }

    .single_product_size_checkbox_list_group {
        position: relative;
    }

    .single_product_size_checkbox_list_group input {
        display: none;
    }

    .single_product_size_checkbox_list_group label {
        cursor: pointer;
        border: 1px solid #cccccc;
        background: var(--white);
        text-align: center;
        -webkit-transition: all 200ms ease-in-out;
        -o-transition: all 200ms ease-in-out;
        transition: all 200ms ease-in-out;
        border-radius: 3px;
    }

    .single_product_size_checkbox_list ul {
        display: flex;
        align-items: center;
        flex-wrap: wrap;
        gap: 6px;
    }

    .label_img_container {
        display: flex;
        align-items: center;
        flex-direction: column;
    }

    .label_img {
        width: 100%;
        height: 50px;
    }

    .label_img img {
        width: 100%;
        height: 100%;
        object-fit: fill;
    }

    .single_product_size_checkbox_list_group .icon {
        margin-top: 10px;
        font-size: 30px;
        color: var(--black);
        -webkit-transition: all 200ms ease-in-out;
        -o-transition: all 200ms ease-in-out;
        transition: all 200ms ease-in-out;
    }

    .single_product_size_checkbox_list_group .title {
        font-size: 14px;
        padding: 4px 20px;
        color: #333;
        -webkit-transition: all 200ms ease-in-out;
        -o-transition: all 200ms ease-in-out;
        transition: all 200ms ease-in-out;
        width: 100%;
        line-height: 20px;
        font-weight: 500;
    }

    .single_product_size_checkbox_list_group label:hover {
        border: 1px solid var(--primary_color)
    }

    .single_product_size_checkbox_list_group input:checked+label .title {
        color: var(--primary_color);
        font-weight: 600;
    }

    .single_product_qty {
        display: flex;
        align-items: center;
    }

    .single_product_qty input {
        border: 1px solid var(--border);
        color: #979797;
        width: 100%;
        height: 40px;
        line-height: 40px;
        text-align: center;
        float: left;
        display: block;
    }

    .single_product_qty_plus {
        border: 1px solid var(--border);
        color: #979797;
        width: 35px;
        height: 40px;
        line-height: 40px;
        text-align: center;
        border-left: 0px;
        border-radius: 0px 3px 3px 0px;
        cursor: pointer;
        background-color: transparent;
        display: block;
    }


    .single_product_add_to_cart {
        border: 1px solid var(--single_page_add_to_card_border_color);
        background-color: var(--single_page_add_to_card_bg_color);
        border-radius: 5px;
        display: block;
        width: 100%;
        text-align: center;
        color: var(--single_page_add_to_card_text_color);
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
        padding: 6px 0px;
    }

    .single_product_add_to_cart:hover {
        background-color: var(--single_page_add_to_card_hover_bg_color);
        color: var(--single_page_add_to_card_hover_text_color);
        border-color: var(--single_page_add_to_card_hover_border_color);
    }

    .single_product_add_to_wishlist {
        border: 1px solid var(--border);
        background-color: transparent;
        display: block;
        padding: 6px 12px;
        border-radius: 3px;
        font-size: 20px;
        text-align: center;
        color: var(--black);
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .single_product_add_to_wishlist:hover {
        color: var(--primary_color);
    }

    .single_product_specification_list {
        border: 2px dotted var(--primary_color);
        padding: 10px;
        margin-bottom: 15px;
    }

    .single_product_specification_list ul {
        margin: 0;
        padding: 0;
    }

    .single_product_specification_list ul li {
        list-style: none;
        font-size: 14px;
        margin-bottom: 5px;
    }

    .single_product_specification_list ul li:last-child {
        margin-bottom: 0px;
    }

    .single_product_specification_list ul li i {
        padding-right: 5px;
    }

    .single_product_call_details {
        border: 2px dotted var(--primary_color);
        padding: 10px;
    }

    .single_product_call ul {
        margin: 0;
        padding: 0;
    }

    .single_product_call ul li {
        list-style: none;
        margin-top: 5px;
    }

    .single_product_call ul li .single_product_call_link {
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
    }

    .single_product_call_content {
        font-size: 14px;
        color: var(--black);
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
        color: var(--primary_color);
    }


    .single_product_call_content:hover {
        color: var(--primary_color);
    }

    .click_zoom_arror svg {
        width: 18px;
        color: var(--primary_color)
    }

    .click_zoom_arror {
        width: 45px;
        height: 45px;
        display: flex;
        align-items: center;
        justify-content: center;
        background-color: #ffffff;
        border-radius: 9999px;
        position: absolute;
        bottom: 25px;
        right: 25px;
        cursor: pointer;
    }

    .single_product_call_content i {
        -webkit-transform: rotate(20deg);
        -ms-transform: rotate(20deg);
        transform: rotate(20deg);
        font-size: 11px;
    }



    .single_product_tab_nav {
        margin-bottom: 20px;
        padding-bottom: 10px;
    }

    .single_product_tab_nav .single_product_tab_nav_link {
        border-radius: 25px;
        border: 1px solid var(--primary_color);
        color: var(--black);
        font-weight: 500;
        font-size: 15px;
        text-transform: uppercase;
    }

    .single_product_tab_nav .single_product_tab_nav_link.active {
        color: var(--primary_text_color);
        background-color: var(--primary_color);
        border-color: #dee2e6 #dee2e6 #fff;
    }

    .single_product_tab_list {}

    .single_product_tab_list ul {
        margin: 0;
        padding: 0;
    }

    .single_product_tab_list ul li {
        list-style: none;
        margin-bottom: 10px;
        margin-left: 20px;
    }

    .single_product_tab_list ul li:last-child {
        margin-bottom: 0px;
    }


    .products_sticky_buttton_fixed {
        position: fixed;
        right: 0;
        bottom: 0;
        left: 0;
        z-index: 99999999999999999;
        background-color: var(--white);
        border-top: 1px solid rgba(0, 0, 0, 0.1);
        /* height: 87px; */
        /* border: 1px solid red; */
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .single_product_tab_area {
        margin-top: -25px;
    }

    .footer_button_fixed {
        width: 100%;
    }

    .fixed_home_icon {
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
    }

    .addTOcart {
        background-color: var(--white);
        color: var(--black);
        padding: 4px;
        border-radius: 20px 0px 0px 20px;
        border: 1px solid var(--primary_color);
        font-size: 15px;
    }

    .buyToCart {
        background-color: var(--primary_color);
        color: var(--white);
        padding: 4px;
        border-radius: 0px 20px 20px 0px;
        margin-left: -8px;
        border: 1px solid var(--primary_color);
        font-size: 15px;
    }

    .fixed_home_icon span {
        font-size: 14px;
    }

    .fixed_home_icon i {
        font-size: 20px;
    }

    .mobile_footer_single {
        width: 97px !important;
    }

    .mobile_footer_single_size {
        /* width: 97px !important; */
        margin-right: 24px;
        text-align: center
    }

    .mobile_view {
        width: 60px !important;
    }

    .mobile_footer_single strong {
        font-weight: 500
    }

    .mobile_views_size {
        overflow-y: scroll !important;
        margin-bottom: 7px !important;
    }

    .mobile_views_lit ul {
        display: flex;
        overflow-x: auto;
    }

    .mobile_views_lit ul li {
        margin-right: 10px;
        list-style: none;
    }

    /* --- */
    .p_custom_width {
        max-width: 1400px;
        margin: 0 auto;
    }




    /*
==============================================================
    Checkout Area Css
==============================================================
*/

    .checkout_order_summary {
        background-color: var(--white);
        padding: 30px;
        border-radius: 10px;
        border: 1px solid var(--border);
    }

    .checkout_form_title {
        text-align: center;
        margin-bottom: 30px;
    }


    .checkout_form_title h3 {
        font-size: 22px;
        font-weight: 600;
        text-transform: uppercase;
    }

    .checkout_form {
        background-color: var(--white);
        padding: 30px;
        border-radius: 3px;
        border: 1px solid var(--border);
        border-radius: 9px;
    }

    .checkout_form_group select {
        color: #999 !important;
    }

    .checkout_form_group select option {
        color: black !important;
    }

    .checkout_form_group {
        margin-bottom: 15px;
        position: relative;
    }

    .checkout_form_checkbox_group {
        margin-bottom: 15px;
    }

    .checkout_form_group i {
        position: absolute;
        bottom: 17px;
        transform: revert-layer;
        color: #999;
        right: 10px;
    }

    .checkout_form_group input {
        padding-right: 30px;
    }

    .checkout_form_group label {
        display: block;
        margin-bottom: 8px;
        font-size: 16px;
        font-weight: 500;
    }

    .required_r {
        color: red;
        font-size: 20px;
    }

    .checkout_form_group input,
    .checkout_form_group select,
    .checkout_form_group textarea {
        width: 100%;
        border: 1px solid var(--border);
        padding: 10px 10px;
        border-radius: 6px;
        font-size: 16px;
        background-color: rgb(241 245 249);
    }

    .checkout_form_checkbox.form-check {
        padding-left: 0;
        margin-bottom: 0;
        border: 1px solid var(--border);
        padding: 8px 10px;
        display: flex;
        align-items: center;
    }

    .checkout_form_checkbox.border_top_none {
        border-top: none !important;
    }

    .checkout_form_checkbox.form-check .form-check-input {
        margin-left: 0;
        cursor: pointer;
        border: 1px solid var(--primary_color) !important;
    }

    .checkout_form_checkbox.form-check label {
        padding-left: 10px;
        cursor: pointer;
        width: 100%;
    }

    .checkout_form_checkbox_group h4 {
        font-weight: 500;
        margin-bottom: 8px;
        font-size: 16px;
    }

    .checkout_form_checkbox.form-check .form-check-input:checked {
        background-color: var(--primary_color) !important;
        border-color: var(--primary_color) !important;
    }

    .checkout_form_checkbox.form-check .form-check-input:focus {
        box-shadow: inherit !important;
    }

    .price_payable_amount_text {
        font-weight: 600 !important;
        font-size: 18px;
    }

    .checkout_form_checkbox_group_box {
        border: 1px solid #eee;
        border-radius: 8px;
    }

    .order_summary_table table thead tr th {
        font-weight: 400;
        color: var(--black);
        padding: 5px;
        font-size: 16px;
    }

    .checkout_form_checkbox.form-check:last-child {
        border-bottom: none;
    }

    .price_payable_amount_text {
        font-weight: 600 !important;
        font-size: 18px;
    }





    .checkout_form_group .checkout_form_select {
        padding: 12px 10px;
    }

    .checkout_form_btn {
        text-align: center;
        margin-top: 20px;
        position: sticky;
        bottom: 12px;
        left: 50%;
        z-index: 3;
        padding: 0px 8px;
    }

    .checkout_form_btn_link {
        border: none;
        background-color: var(--primary_color);
        color: var(--primary_text_color);
        display: flex;
        transition: 0.3s;
        width: 100%;
        align-items: center;
        justify-content: center;
        gap: 8px;
        font-weight: 500;
        padding: 10px 0px;
        border-radius: 3px;
    }

    .checkout_form_btn_link:hover {
        color: var(--primary_hover_color);
    }

    .checkout_form_container {
        background-color: var(--white);
        padding: 20px;
        border-radius: 10px;
        border: 1px solid var(--border);
    }

    .checkout_order_summary {
        /* background-color: var(--white);
    padding: 50px;
    border-radius: 10px;
    border: 1px solid var(--border); */
    }

    .payment_methods_img {
        margin-top: 14px;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .payment_methods_img ul {
        display: flex;
        gap: 10px;
        list-style: none;
    }

    .payment_images {
        width: 150px;
        cursor: pointer;
        transition: transform 0.3s ease;
    }

    .payment_images img {
        width: 100%;
        height: 100%;
        cursor: pointer;
        border: 2px solid #ddd;
        border-radius: 4px
    }

    .active_payment {
        border: 2px solid var(--primary_color);
        border-radius: 4px
    }

    .order_summary_title {
        text-align: center;
        margin-bottom: 10px;
        font-size: 20px;
        font-size: 24px;
        font-weight: 400;
        margin-top: 10px;
    }



    .order_summary_table {
        overflow-x: auto;
    }

    /* width */
    .order_summary_table::-webkit-scrollbar {
        height: 3px;
    }

    /* Track */
    .order_summary_table::-webkit-scrollbar-track {
        background: #f1f1f1;
    }

    /* Handle */
    .order_summary_table::-webkit-scrollbar-thumb {
        background: #888;
    }

    /* Handle on hover */
    .order_summary_table::-webkit-scrollbar-thumb:hover {
        background: #555;
    }

    .order_summary_table .table thead tr th {
        font-weight: 500;
    }

    .order_summary_table tbody,
    td,
    tfoot,
    th,
    thead,
    tr {
        border-color: var(--border) !important;
        border-style: solid;
        border-width: 0;
    }

    .order_summary_table table>:not(caption)>*>* {
        padding: .5rem .5rem;
        border-bottom-width: 1px;
    }

    .checkout_product_name_image {
        width: 50px;
        height: 50px;
        float: left;
        margin-right: 7px;
        display: block;
        overflow: hidden;
        border-radius: 4px;
        border: 1px solid #eee;
    }

    .checkout_product_name_image img {
        width: 100%;
        height: 100%;
        border-radius: 3px;
    }

    .products_checkout_name {
        display: block;
        overflow: hidden;
    }

    .products_checkout_name p {
        line-height: 22px;
        font-size: 14px;
        width: max-content;
        white-space: normal;
    }

    .checkout_product_name_image p {
        font-size: 14px;
        line-height: 18px;
    }

    .checkout_product_qty {
        width: 85px;
        display: flex;
    }

    .checkout_product_qty_minus {
        border: 1px solid var(--border);
        color: #838383;
        width: 25px;
        height: 25px;
        line-height: 25px;
        text-align: center;
        border-right: 0px;
        border-radius: 3px 0px 0px 3px;
        cursor: pointer;
        background-color: transparent;
        font-size: 12px;
        display: block;
        float: left;
        transition: all .3s ease;
    }

    .checkout_product_qty_minus:hover {
        color: var(--primary_text_color);
        background-color: var(--primary_color);
    }

    .checkout_product_qty input {
        border: 1px solid var(--border);
        color: #838383;
        width: 30px;
        height: 25px;
        line-height: 25px;
        text-align: center;
        float: left;
        font-size: 14px;
        display: block;
    }

    .checkout_product_qty_plus {
        border: 1px solid var(--border);
        color: #838383;
        width: 25px;
        height: 25px;
        line-height: 25px;
        text-align: center;
        border-left: 0px;
        border-radius: 0px 3px 3px 0px;
        cursor: pointer;
        background-color: transparent;
        font-size: 12px;
        display: block;
        transition: all .3s ease;
    }

    .checkout_product_qty_plus:hover {
        color: var(--primary_text_color);
        background-color: var(--primary_color);
    }

    .checkout_product_price p {
        font-size: 14px;
        width: max-content;
        font-weight: 500;
    }

    .checkout_product_delete_icon {
        text-align: right;
    }

    .checkout_product_total_price p {
        font-size: 14px;
        width: max-content;
        font-weight: 500;
    }

    .checkout_product_delete_icon_link {
        border: none;
        background-color: transparent;
        color: red;
        font-size: 16px;
        cursor: pointer;
    }




    .checkout_form_btn_link {
        -webkit-animation: 1.40s both rsiShaker1 infinite;
        animation: 1.40s both rsiShaker1 infinite
    }

    @-webkit-keyframes rsiShaker1 {

        0%,
        to {
            -webkit-transform: scaleX(1);
            transform: scaleX(1)
        }

        10%,
        20% {
            -webkit-transform: scale3d(.97, .97, .97) rotate(-1deg);
            transform: scale3d(.97, .97, .97) rotate(-1deg)
        }

        30%,
        50%,
        70%,
        90% {
            -webkit-transform: scale3d(1.03, 1.03, 1.03) rotate(1deg);
            transform: scale3d(1.03, 1.03, 1.03) rotate(1deg)
        }

        40%,
        60%,
        80% {
            -webkit-transform: scale3d(1.03, 1.03, 1.03) rotate(-1deg);
            transform: scale3d(1.03, 1.03, 1.03) rotate(-1deg)
        }
    }

    @keyframes rsiShaker1 {

        0%,
        to {
            -webkit-transform: scaleX(1);
            transform: scaleX(1)
        }

        10%,
        20% {
            -webkit-transform: scale3d(.97, .97, .97) rotate(-1deg);
            transform: scale3d(.97, .97, .97) rotate(-1deg)
        }

        30%,
        50%,
        70%,
        90% {
            -webkit-transform: scale3d(1.03, 1.03, 1.03) rotate(1deg);
            transform: scale3d(1.03, 1.03, 1.03) rotate(1deg)
        }

        40%,
        60%,
        80% {
            -webkit-transform: scale3d(1.03, 1.03, 1.03) rotate(-1deg);
            transform: scale3d(1.03, 1.03, 1.03) rotate(-1deg)
        }
    }









    .checkout_product_td_left {
        padding-left: 0px !important;
    }

    .checkout_product_td_right {
        text-align: right;
        padding-right: 0px !important;
    }

    .price_summary_table_cell {
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
        -webkit-box-pack: justify;
        -ms-flex-pack: justify;
        justify-content: space-between;
        border-bottom: 1px solid var(--border);
        padding: 10px 0px;
    }

    .price_summary_table_cell:last-child {
        border-bottom: 0px;
        padding-bottom: 0px;
    }

    .price_summary_table_cell strong {
        font-weight: 400;
    }

    .apply_coupon_group label {
        display: block;
        margin-bottom: 3px;
    }

    .apply_coupon_item {
        display: flex;
        align-items: center;
        margin-bottom: 20px;
        cursor: pointer;
    }

    .apply_coupon_item:hover {
        display: flex;
        align-items: center;
        margin-bottom: 20px;
        cursor: pointer;
        color: var(--primary_hover_color);

    }

    .apply_coupon_item input {
        width: 100%;
        border: 1px solid var(--border);
        padding: 10px 10px;
        border-radius: 3px;
    }

    .apply_coupon_item_link {
        border: none;
        background-color: var(--primary_color);
        color: var(--primary_text_color);
        display: inline-block;
        padding: 10px 25px;
        border-radius: 3px;
        margin-left: 15px;
        transition: .3s;
    }

    .apply_coupon_item_link:hover {
        color: var(--primary_hover_color);
    }

    /*
==============================================================
    Success Area Css
==============================================================
*/
    .success_icon {
        background-color: green;
        color: var(--white);
        width: 50px;
        height: 50px;
        line-height: 50px;
        text-align: center;
        font-size: 25px;
        border-radius: 50%;
        margin: 0 auto;
    }

    .error_icon {
        background-color: rgb(245, 3, 3);
        color: var(--white);
        width: 50px;
        height: 50px;
        line-height: 50px;
        text-align: center;
        font-size: 25px;
        border-radius: 50%;
        margin: 0 auto;
    }

    .success_title {
        margin-top: 30px;
        margin-bottom: 10px;
    }

    .success_title h3 {
        font-size: 22px;
    }

    .success_call_link {
        color: var(--primary_color);
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .success_call_link:hover {
        color: var(--hover);
    }

    .success_btn {
        margin-top: 20px;
    }

    .success_btn_link {
        display: inline-block;
        color: var(--white);
        background-color: var(--primary_color);
        padding: 10px 15px;
        border-radius: 3px;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .success_btn_link:hover {
        color: var(--white);
    }

    /*
==============================================================
    Order Tracking Area Css
==============================================================
*/
    .order_tracking_content {
        -webkit-box-shadow: var(--shadow);
        box-shadow: var(--shadow);
        padding: 50px;
        border-radius: 3px;
    }

    .order_tracking_header {
        padding-bottom: 30px;
        margin-bottom: 20px;
        border-bottom: 1px solid var(--border);
    }

    .order_tracking_title {
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
        gap: 20px;
        margin-bottom: 10px;
    }

    .order_tracking_search input {
        width: 100%;
        border: 1px solid var(--primary_color);
        padding: 10px 20px;
        border-radius: 3px;
    }

    .order_tracking_search_btn_link {
        border: none;
        background-color: var(--primary_color);
        color: var(--white);
        width: 100%;
        height: 100%;
        display: block;
        font-size: 20px;
        padding: 11px 0px;
        border-radius: 3px;
    }

    .order_tracking_invoice strong {
        margin-right: 5px;
    }

    .order_tracking_customer_item {
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
        gap: 10px;
        margin-top: 5px;
    }

    .order_tracking_order_status_details {
        float: right;
    }

    .order_tracking_order_status {
        margin-top: 5px;
    }

    .order_tracking_order_status span {
        background-color: var(--primary_color);
        color: var(--white);
        display: inline-block;
        padding: 3px 20px;
        border-radius: 30px;
    }

    .order_tracking_order_cod span {
        font-weight: 500;
        font-size: 18px;
    }

    .order_tracking_sender_information {
        margin-top: 15px;
        margin-bottom: 15px;
    }

    .order_tracking_sender_organization {
        margin-top: 15px;
    }

    .order_tracking_sender_title {
        text-align: center;
        background-color: #dddddd;
    }

    .order_tracking_sender_title h3 {
        font-size: 20px;
        font-weight: 400;
        padding: 10px 0px;
    }

    .order_tracking_sender_organization h3 {
        font-size: 22px;
        font-weight: 500;
    }

    .order_tracking_sender_address p {
        margin-top: 5px;
    }

    .order_tracking_sender_address_link {
        color: var(--black);
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .order_tracking_sender_address_link:hover {
        color: var(--hover);
    }

    .order_tracking_sender_address strong {
        margin-right: 5px;
    }

    .order_tracking_courier_title {
        text-align: center;
        background-color: #dddddd;
        margin-bottom: 15px;
    }

    .order_tracking_courier_title h3 {
        font-size: 20px;
        font-weight: 400;
        padding: 10px 0px;
    }

    .order_tracking_courier_name h3 {
        font-size: 22px;
        font-weight: 500;
    }

    /*
==============================================================
    Client Review Area Css
==============================================================
*/
    .client_review_item img {
        width: 100%;
    }

    .client_review_active .owl-dots .owl-dot {
        width: 15px;
        height: 15px;
        background: #ffffff;
        border-radius: 100%;
        border: 1px solid var(--primary_color);
        display: flex;
        align-items: center;
        justify-content: center;
        text-align: center;
        margin: 0 auto;
        float: left;
        margin-right: 5px;
    }

    .client_review_active .owl-dots .owl-dot.active {
        background-color: var(--primary_color);
        border-color: var(--primary_color);
    }

    .client_review_active .owl-dots {
        position: absolute;
        bottom: -35px;
        left: 50%;
        transform: translateX(-50%);
    }













    /*
==============================================================
    Shop Page Area Css
==============================================================
*/
    .shop_product_header_item_short_by {
        display: flex;
        align-items: center;
        justify-content: space-between;
    }

    .shop_product_header_short_by {
        display: flex;
        align-items: center;
        justify-content: end;
        gap: 10px;
    }

    .shop_product_header_short_by p {
        width: 90px;
    }

    .shop_product_header_item_short_by_wrap {
        margin-bottom: 20px;
    }
























    .shop_filters {
        background-color: #f9f9f9;
        padding: 15px 20px;
        border-top: 1px solid var(--border);
        border-left: 1px solid var(--border);
        border-right: 1px solid var(--border);
        border-radius: 3px 3px 0px 0px;
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
        gap: 10px;
    }

    .shop_filters i {
        color: var(--black);
        font-size: 25px;
    }

    .shop_filters h5 {
        font-size: 25px;
        line-height: 35px;
    }

    .shop_accordion_button {
        font-size: 20px;
        list-style: 30px;
    }

    .shop_accordion_button {
        -webkit-box-shadow: none !important;
        box-shadow: none !important;
    }

    .shop_accordion_item:first-of-type {
        border-top-left-radius: 0px;
        border-top-right-radius: 0px;
    }

    .shop_accordion_button:not(.collapsed) {
        color: var(--black);
        background-color: var(--white);
    }

    .shop_accordion_button:focus {
        -webkit-box-shadow: none !important;
        box-shadow: none !important;
    }

    .shop_category_list {
        padding-top: 0px;
        padding-left: 20px;
        padding-right: 20px;
        padding-bottom: 20px;
    }

    .shop_category_list ul li {
        margin-bottom: 10px;
    }

    .shop_category_list ul li:last-child {
        margin-bottom: 0px;
    }

    .shop_category_list_check_box {
        cursor: pointer;
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
    }

    .shop_category_list_check_box input[type="checkbox"] {
        -webkit-appearance: none;
        -moz-appearance: none;
        appearance: none;
        height: 20px;
        width: 20px;
        background-color: var(--white);
        border: 1px solid var(--border);
        border-radius: 3px;
        cursor: pointer;
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        outline: none;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
        -webkit-box-pack: center;
        -ms-flex-pack: center;
        justify-content: center;
        float: left;
    }

    .shop_category_list_check_box label {
        color: var(--black);
        font-size: 16px;
        cursor: pointer;
        padding-left: 10px;
    }

    .shop_category_list_check_box input[type="checkbox"]:after {
        font-family: "Font Awesome 6 Free";
        content: "\f00c";
        font-weight: 600;
        font-size: 16px;
        color: var(--white);
        display: none;
    }

    .shop_category_list_check_box input[type="checkbox"]:checked {
        background-color: var(--primary_color);
    }

    .shop_category_list_check_box input[type="checkbox"]:checked:after {
        display: block;
    }

    .shop_category_list_check_box label,
    .shop_category_list_check_box input {
        cursor: pointer;
    }

    .shop_color_list {
        padding-top: 5px;
        padding-left: 20px;
        padding-right: 20px;
        padding-bottom: 20px;
    }

    .shop_color_background {
        width: 20px;
        height: 20px;
        border: 1px solid var(--border);
        border-radius: 20px;
        margin-right: 10px;
    }

    .shop_color_list ul li {
        margin-bottom: 10px;
    }

    .shop_color_list ul li:last-child {
        margin-bottom: 0px;
    }

    .shop_color_list_check_box {
        cursor: pointer;
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
    }

    .shop_color_list_check_box input[type="checkbox"] {
        -webkit-appearance: none;
        -moz-appearance: none;
        appearance: none;
        height: 20px;
        width: 20px;
        background-color: var(--white);
        border: 1px solid var(--border);
        border-radius: 3px;
        cursor: pointer;
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        outline: none;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
        -webkit-box-pack: center;
        -ms-flex-pack: center;
        justify-content: center;
        float: left;
        margin-right: 10px;
    }

    .shop_color_list_check_box label {
        color: var(--black);
        font-size: 16px;
        cursor: pointer;
    }

    .shop_color_list_check_box input[type="checkbox"]:after {
        font-family: "Font Awesome 6 Free";
        content: "\f00c";
        font-weight: 600;
        font-size: 16px;
        color: var(--white);
        display: none;
    }

    .shop_color_list_check_box input[type="checkbox"]:checked {
        background-color: var(--primary_color);
    }

    .shop_color_list_check_box input[type="checkbox"]:checked:after {
        display: block;
    }

    .shop_color_list_check_box label,
    .shop_color_list_check_box input {
        cursor: pointer;
    }

    .shop_size_checkbox_list {
        margin-bottom: 15px;
        padding-left: 20px;
        padding-right: 20px;
    }

    .shop_size_checkbox_list ul li {
        display: inline-block;
        margin-right: 3px;
        margin-bottom: 7px;
    }

    .shop_size_checkbox_list ul li:last-child {
        margin-right: 0px;
    }

    .shop_size_checkbox_list_group {
        position: relative;
    }

    .shop_size_checkbox_list_group input {
        display: none;
    }

    .shop_size_checkbox_list_group label {
        cursor: pointer;
        border: 1px solid var(--border);
        background: var(--white);
        text-align: center;
        -webkit-transition: all 200ms ease-in-out;
        -o-transition: all 200ms ease-in-out;
        transition: all 200ms ease-in-out;
        border-radius: 3px;
    }

    .shop_size_checkbox_list_group .icon {
        margin-top: 10px;
        font-size: 30px;
        color: var(--black);
        -webkit-transition: all 200ms ease-in-out;
        -o-transition: all 200ms ease-in-out;
        transition: all 200ms ease-in-out;
    }

    .shop_size_checkbox_list_group .title {
        font-size: 16px;
        color: var(--black);
        padding: 5px 15px;
        -webkit-transition: all 200ms ease-in-out;
        -o-transition: all 200ms ease-in-out;
        transition: all 200ms ease-in-out;
    }

    .shop_size_checkbox_list_group label:before {
        content: "✓";
        position: absolute;
        width: 20px;
        height: 18px;
        bottom: 0px;
        right: 0px;
        background: var(--primary_color);
        color: var(--white);
        text-align: center;
        line-height: 18px;
        font-size: 14px;
        font-weight: 600;
        /* border-radius: 50%; */
        opacity: 0;
        -webkit-transform: scale(0.5);
        -ms-transform: scale(0.5);
        transform: scale(0.5);
        -webkit-transition: all 200ms ease-in-out;
        -o-transition: all 200ms ease-in-out;
        transition: all 200ms ease-in-out;
        border-radius: 25px 0px 3px 0px;
        padding-left: 4px;
        padding-top: 2px;
    }

    .shop_size_checkbox_list_group input:checked+label:before {
        opacity: 1;
        -webkit-transform: scale(1);
        -ms-transform: scale(1);
        transform: scale(1);
    }

    .shop_size_checkbox_list_group input:checked+label .icon {
        color: var(--primary_color);
    }

    .shop_size_checkbox_list_group input:checked+label .title {
        color: var(--primary_color);
    }

    .shop_size_checkbox_list_group input:checked+label {
        border: 1px solid var(--primary_color);
    }



    .brand_list {
        padding-top: 5px;
        /* padding-left: 20px; */
        /* padding-right: 20px; */
        padding-bottom: 20px;
    }

    .brand_list ul li {
        /* margin-bottom: 10px; */
        margin-right: 8px;
        margin-bottom: 8px
    }

    .brand_list ul li:last-child {
        /* margin-bottom: 0px; */
    }

    .brand_list_check_box {
        cursor: pointer;
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
    }

    .brand_list_check_box input[type="checkbox"] {
        -webkit-appearance: none;
        -moz-appearance: none;
        appearance: none;
        height: 20px;
        width: 20px;
        background-color: var(--white);
        border: 1px solid var(--border);
        border-radius: 3px;
        cursor: pointer;
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        outline: none;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
        -webkit-box-pack: center;
        -ms-flex-pack: center;
        justify-content: center;
        float: left;
    }

    .brand_list_check_box label {
        color: var(--black);
        font-size: 16px;
        cursor: pointer;
        padding-left: 10px;
    }

    .brand_list_check_box input[type="checkbox"]:after {
        font-family: "Font Awesome 6 Free";
        content: "\f00c";
        font-weight: 600;
        font-size: 16px;
        color: var(--white);
        display: none;
    }

    .brand_list_check_box input[type="checkbox"]:checked {
        background-color: var(--primary_color);
    }

    .brand_list_check_box input[type="checkbox"]:checked:after {
        display: block;
    }

    .brand_list_check_box label,
    .brand_list_check_box input {
        cursor: pointer;
    }


    .brand_lists ul {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(110px, 1fr));
        justify-items: center;
        gap: 15px;
        margin: auto;
    }


    .brand_lists ul li a {
        background: white;
        width: 100%;
        cursor: pointer;
        height: 94px;
        border-radius: 4px;
        box-shadow: rgba(0, 0, 0, 0.15) 1px 1px 4px 0px;
    }

    .brand_name_img {
        width: 120px;
        height: 80px;
    }

    .brand_name_img img {
        width: 100%;
        height: 100%;
        border: 1px solid #dddddd;
        border-radius: 5px;
    }



    /* ===================Price Range Old Start ==================== */
    .price_range_content {
        padding: 0px 20px 30px;
    }

    .price-input {
        width: 100%;
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        margin: 25px 0 30px;
    }

    .price-input .field {
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        width: 100%;
        height: 45px;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
    }

    .field input {
        width: 100%;
        height: 100%;
        outline: none;
        font-size: 16px;
        margin-left: 12px;
        border-radius: 5px;
        text-align: center;
        border: 1px solid #999;
        -moz-appearance: textfield;
    }

    .field input[type="number"]::-webkit-outer-spin-button,
    .field input[type="number"]::-webkit-inner-spin-button {
        -webkit-appearance: none;
    }

    .price-input .separator {
        width: 80px;
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        font-size: 19px;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
        -webkit-box-pack: center;
        -ms-flex-pack: center;
        justify-content: center;
    }

    .price_rangle_progress {
        height: 5px;
        position: relative;
        background: #ddd;
        border-radius: 5px;
    }

    .price_rangle_progress .progress {
        height: 100%;
        left: 25%;
        right: 25%;
        position: absolute;
        border-radius: 5px;
        background: #17a2b8;
    }

    .range-input {
        position: relative;
    }

    .range-input input {
        position: absolute;
        width: 100%;
        height: 5px;
        top: -5px;
        background: none;
        pointer-events: none;
        -webkit-appearance: none;
        -moz-appearance: none;
    }

    .range-input input[type="range"]::-webkit-slider-thumb {
        height: 17px;
        width: 17px;
        border-radius: 50%;
        background: #17a2b8;
        pointer-events: auto;
        -webkit-appearance: none;
        -webkit-box-shadow: 0 0 6px rgba(0, 0, 0, 0.05);
        box-shadow: 0 0 6px rgba(0, 0, 0, 0.05);
    }

    .range-input input[type="range"]::-moz-range-thumb {
        height: 17px;
        width: 17px;
        border: none;
        border-radius: 50%;
        background: #17a2b8;
        pointer-events: auto;
        -moz-appearance: none;
        box-shadow: 0 0 6px rgba(0, 0, 0, 0.05);
    }

    /* ===================Price Range Old End ==================== */




    /* ===================Price Range New Start ==================== */
    .shop_filters i {
        font-size: 18px;
    }

    .shop_filters h5 {
        font-size: 18px;
        line-height: 28px;
    }

    .shop_filters {
        padding: 6px 15px;
        border-bottom: 1px solid var(--border);
        border-radius: 3px 3px 3px 3px;
        gap: 10px;
        -webkit-box-pack: center;
        -ms-flex-pack: center;
        justify-content: center;
    }

    .offcanvas_shop_product_content {
        z-index: 99999;
        overflow-y: auto;
        padding-bottom: 100px;
    }

    .shop_filter_table_cell {
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
        -webkit-box-pack: justify;
        -ms-flex-pack: justify;
        justify-content: space-between;
        padding: 15px 20px;
    }

    .offcanvas_shop_filters {
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
        gap: 5px;
    }

    .offcanvas_shop_filters i {
        font-size: 20px;
    }

    .shop_close {
        line-height: 0px;
    }

    .shop_close i {
        font-size: 24px;
    }

    .zoom-big-img {
        height: 700px;
    }

    .price_range_content {
        padding: 0px 20px 30px;
    }

    .price_range .range-slider {
        padding: 30px;
        border-radius: 3px;
        position: absolute;
        left: 39%;
        transform: translate(-39%);
        background-color: rgb(255, 255, 255);
        padding-top: 15px;
    }

    .price_range .range-slider {
        width: 250px;
        text-align: center;
        position: relative;
        padding-bottom: 20px;
    }

    .price_range .range-slider .rangeValues {
        display: block;
        padding: 10px 10px;
        font-size: 18px;
        margin-bottom: 30px;
        border: 1px solid var(--border);
        border-radius: 3px;
    }

    .price_range .range-slider input[type=range] {
        -webkit-appearance: none;
        border: 1px solid white;
        width: 250px;
        position: absolute;
        left: 0;
    }

    .price_range .range-slider input[type=range]::-webkit-slider-runnable-track {
        width: 300px;
        height: 5px;
        background: #ddd;
        border: none;
        border-radius: 3px;
    }

    .price_range .range-slider input[type=range]::-webkit-slider-thumb {
        -webkit-appearance: none;
        border: none;
        height: 18px;
        width: 18px;
        border-radius: 50%;
        background: #0273a0;
        margin-top: -6px;
        cursor: pointer;
        position: relative;
        z-index: 1;
    }

    .price_range .range-slider input[type=range]:focus {
        outline: none;
    }

    .price_range .range-slider input[type=range]:focus::-webkit-slider-runnable-track {
        background: #ccc;
    }

    .range-wrap {
        border: 1px solid var(--border);
        margin-bottom: 20px;
        padding-top: 20px;
        border-radius: 3px;
    }

    /* ===================Price Range New End ==================== */

    .h_mobile_ico {
        display: flex;
        align-items: center;
        gap: 20px;
    }

    .h_mobile_ico svg {
        color: var(--primary_color);
        width: 35px;
    }

    /*
==============================================================
    Fixed Footer Menu Area Css
==============================================================
*/
    .fixed_footer_menu {
        background-color: var(--white);
        -webkit-box-shadow: var(--shadow);
        box-shadow: var(--shadow);
        position: fixed;
        bottom: 0;
        left: 0;
        width: 100%;
        padding: 0px 15px;
        padding-top: 5px;
        padding-bottom: 3px;
        z-index: 999999999;
        display: none;
    }

    .fixed_footer_menu ul {
        margin: 0;
        padding: 0;
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
        -webkit-box-pack: justify;
        -ms-flex-pack: justify;
        justify-content: space-between;
    }

    .fixed_footer_menu ul li {
        list-style: none;
        text-align: center;
    }

    .fixed_footer_menu ul li .fixed_footer_menu_link svg {
        color: var(--primary_color);
    }

    .fixed_footer_menu ul li .fixed_footer_menu_link svg {
        color: var(--primary_color);
        width: 26px;
        height: 22px;
    }

    .fixed_footer_menu ul li .fixed_footer_menu_link._account_ svg {
        height: 24px;
    }

    .fixed_footer_menu ul li .fixed_footer_menu_link {
        text-align: center;
        position: relative;
    }

    .fixed_footer_menu ul li .fixed_footer_menu_link p {
        font-size: 13px;
        display: block;
        line-height: 14px;
        margin-top: 5px;
    }

    .fixed_footer_menu ul li .fixed_footer_menu_link .wish_list_count {
        position: absolute;
        top: 0;
        right: -2px;
        width: 16px;
        height: 16px;
        line-height: 16px;
        background-color: var(--primary_color);
        font-size: 12px;
        color: var(--primary_text_color);
        border-radius: 100%;
    }

    .fixed_footer_menu ul li .fixed_footer_menu_link i {
        display: block;
        color: var(--primary_color);
        font-size: 18px;
    }

    .fixed_footer_menu ul li .fixed_footer_menu_link:hover {
        color: var(--hover);
    }

    .fixed_footer_cart_count {
        position: absolute;
        top: 10px;
        right: -5px;
        display: block;
        width: 15px;
        height: 15px;
        line-height: 15px;
        text-align: center;
        background-color: var(--primary_color);
        color: var(--white);
        font-size: 11px;
        border-radius: 50%;
        margin-top: -10px;
        margin-right: -4px;
    }

    .fixed_footer_wishlist_count {
        position: absolute;
        top: 0;
        right: 0;
        display: block;
        width: 15px;
        height: 15px;
        line-height: 15px;
        text-align: center;
        background-color: var(--black);
        color: var(--white);
        font-size: 11px;
        border-radius: 50%;
        margin-top: -9px;
        margin-right: 4px;
    }

    /*
==============================================================
    Profile Area Css
==============================================================
*/
    .profile_left_side {
        border: 1px solid var(--border);
        border-radius: 3px;
        padding: 20px;
    }

    .profile_pic {
        width: 150px;
        margin: 0 auto;
    }

    .profile_pic img {
        max-width: 100%;
        height: auto;
    }

    .profile_name {
        text-align: center;
        margin-top: 15px;
    }

    .profile_menu_list {
        margin-top: 20px;
    }

    .profile_menu_list ul {
        margin: 0;
        padding: 0;
    }

    .profile_menu_list ul li {
        list-style: none;
        display: block;
        border-bottom: 1px solid var(--border);
        padding: 10px 0px;
    }

    .profile_menu_list ul li:last-child {
        border-bottom: 0px;
        padding-bottom: 0px;
    }

    .profile_menu_list ul li .profile_menu_list_link {
        display: block;
        color: var(--black);
        font-size: 16px;
        text-transform: uppercase;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .profile_menu_list ul li .profile_menu_list_link:hover {
        color: var(--hover);
    }

    .profile_menu_list ul li .profile_menu_list_link i {
        padding-right: 8px;
    }

    .profile_oder_view_link {
        background-color: var(--primary_color);
        color: var(--white);
        display: inline-block;
        padding: 3px 10px;
        font-size: 16px;
        border-radius: 3px;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .profile_oder_view_link:hover {
        color: var(--black);
    }

    .profile_oder_cancel_btn {
        border: none;
        background-color: #df5c39;
        color: var(--white);
        font-size: 14px;
        padding: 3px 10px;
        display: inline-block;
        border-radius: 3px;
        margin-bottom: 4px;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .profile_oder_cancel_btn:hover {
        color: var(--black);
    }

    .order_status {
        background-color: var(--primary_color);
        color: var(--white);
        font-size: 13px;
        display: inline-block;
        padding: 0px 5px;
        border-radius: 20px;
    }

    .order_discount {
        background-color: var(--primary_color);
        color: var(--white);
        font-size: 13px;
        display: inline-block;
        border-radius: 20px;
        text-align: center;
        padding: 0px 5px;
    }

    .profile_right_side {
        border: 1px solid var(--border);
        padding: 20px;
        border-radius: 3px;
    }

    .profile_form_item {
        margin-bottom: 10px;
    }

    .profile_address_details {
        border: 1px solid var(--border);
        padding: 20px;
        border-radius: 3px;
    }

    .profile_shipping_address h3 {
        font-size: 28px;
        margin-bottom: 10px;
        border-bottom: 1px solid var(--border);
        padding-bottom: 10px;
    }

    .profile_shipping_address_list ul li {
        margin-bottom: 10px;
    }

    .profile_shipping_address_list ul li:last-child {
        margin-bottom: 0px;
    }

    .profile_form_item label {
        display: block;
        margin-bottom: 2px;
    }

    .profile_form_item input,
    select {
        display: block;
        width: 100%;
        border: 1px solid var(--border);
        border-radius: 3px;
        padding: 10px 15px;
        padding-left: 5px;
    }

    .profile_form_submit_btn_link {
        display: block;
        width: 100%;
        border: none;
        background-color: var(--primary_color);
        color: var(--white);
        padding: 10px 0px;
        font-size: 18px;
        border-radius: 3px;
    }

    .profile_page_details h5 {
        margin-bottom: 10px;
    }

    .order_details img {
        width: 50px;
        height: 50px;
        float: left;
        margin-right: 10px;
    }

    .profile_page_order_view table tbody tr td strong {
        width: 120px !important;
        display: block;
    }

    /*
==============================================================
    Auth Area Css
==============================================================
*/
    .is_error {
        color: red;
        font-size: 14px;
    }

    .auth_wrap {
        border: 1px solid var(--border);
        padding: 30px;
        border-radius: 3px;
    }

    .auth_title {
        text-align: center;
        margin-bottom: 40px;
    }

    .auth_item {
        margin-bottom: 10px;
    }

    .auth_item label {
        display: block;
        margin-bottom: 2px;
    }

    .auth_item input {
        width: 100%;
        border: 1px solid var(--border);
        border-radius: 3px;
        padding: 10px 15px;
    }

    .auth_sub_btn_link {
        display: block;
        width: 100%;
        border: none;
        background-color: var(--primary_color);
        color: var(--white);
        padding: 10px 0px;
        border-radius: 3px;
        text-transform: uppercase;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
        font-size: 16px;
    }

    .auth_sub_btn_link:hover {
        color: var(--black);
    }

    .auth_sub_btn_two_link {
        display: block;
        width: 100%;
        border: none;
        background-color: var(--primary_color);
        color: var(--white);
        padding: 10px 0px;
        border-radius: 3px;
        text-transform: uppercase;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
        font-size: 16px;
        text-align: center;
        margin-top: 10px;
    }

    .auth_sub_btn_two_link:hover {
        color: var(--black);
    }

    .auth_forgotten_pass {
        margin-bottom: 15px;
    }

    .auth_forgotten_pass_link {
        display: inline-block;
        color: var(--black);
        border-bottom: 1px solid var(--white);
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .auth_forgotten_pass_link:hover {
        color: var(--hover);
        border-bottom: 1px solid var(--hover);
    }

    .auth_link_page {
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
        gap: 10px;
        margin-top: 15px;
        justify-content: center;
    }

    .auth_link_page_link {
        color: var(--primary_color);
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .auth_link_page_link:hover {
        color: var(--black);
    }

    .divider {
        display: flex;
        align-items: center;
        margin: 20px 0;
        color: #999;
        font-size: 14px;
    }

    .divider::before,
    .divider::after {
        content: '';
        flex: 1;
        height: 1px;
        background: #e0e0e0;
    }

    .divider span {
        padding: 0 15px;
    }

    .google-btn {
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 12px;
        background: white;
        color: #333;
        border: 2px solid #e0e0e0;
        padding: 10px;
        margin-bottom: 25px;
        transition: all 0.3s ease;
    }

    .google-btn:hover {
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        transform: translateY(-2px);
    }

    /*
==========================================
    Contact Us Area Css
==========================================
*/
    .single_contact_us {
        background-color: var(--white);
        border: 1px solid var(--border);
        padding: 20px;
        height: 100%;
    }

    .contact_us_title {
        margin-bottom: 5px;
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
        gap: 5px;
    }

    .contact_us_title i {
        font-size: 18px;
        line-height: 28px;
        color: var(--black);
    }

    .contact_us_title strong {
        color: var(--black);
        font-size: 18px;
        line-height: 28px;
    }

    .contact_us_location p {
        color: var(--black);
    }

    .contact_us_communication ul {
        margin: 0;
        padding: 0;
    }

    .contact_us_communication ul li {
        list-style: none;
    }

    .contact_us_communication ul li .contact_us_communication_link {
        display: inline-block;
        color: var(--text);
        font-weight: 400;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .contact_us_communication ul li .contact_us_communication_link:hover {
        color: var(--themeColor);
    }

    .contact_us_socialmedia ul li {
        display: inline-block;
        margin-top: 5px;
    }

    .contact_us_socialmedia ul li .contact_us_socialmedia_link {
        display: block;
        width: 35px;
        height: 35px;
        text-align: center;
        line-height: 35px;
        background-color: var(--black);
        border: 1px solid var(--black);
        color: var(--white);
        font-size: 16px;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .contact_us_socialmedia ul li .contact_us_socialmedia_link:hover {
        color: var(--themeColor);
        background-color: var(--white);
        border: 1px solid var(--primary_color);
    }

    .contact_us_form_item input,
    .contact_us_form_item textarea,
    .contact_us_form_item select {
        width: 100%;
        border: 1px solid var(--border);
        padding: 10px;
        border-radius: 3px;
        color: var(--black);
    }

    .contact_us_form_btn_link {
        background-color: var(--primary_color);
        color: var(--white);
        font-weight: 500;
        border: none;
        padding: 10px 20px;
        border-radius: 3px;
        display: block;
        width: 100%;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
        letter-spacing: 1px;
        text-transform: uppercase;
    }

    .contact_us_form_btn_link:hover {
        color: var(--black);
    }

    /*
==============================================================
    Customer Comment Area Css
==============================================================
*/
    .modal_content {
        padding: 20px;
    }

    .modal_comment_item {
        margin-bottom: 10px;
    }

    .modal_comment_item input {
        width: 100%;
        border: 1px solid var(--border);
        border-radius: 3px;
        outline: none;
        padding: 8px 10px;
    }

    .modal_comment_item_textarea textarea {
        width: 100%;
        border: 1px solid var(--border);
        border-radius: 3px;
        outline: none;
        padding: 8px 10px;
    }

    .modal_comment_item_btn {
        text-align: center;
    }

    .modal_comment_item_btn_link {
        border: none;
        padding: 8px 15px;
        background-color: var(--black);
        color: var(--white);
        border-radius: 3px;
        display: inline-block;
    }


    .modal_star_title h5 {
        font-size: 23px;
        text-transform: capitalize;
    }

    .modal_rating {
        float: left;
        margin-top: 15px;
        margin-bottom: 20px;
    }

    .modal_rating:not(:checked)>input {
        position: absolute;
        top: -9999px;
    }

    .modal_rating:not(:checked)>label {
        float: right;
        width: 1em;
        overflow: hidden;
        white-space: nowrap;
        cursor: pointer;
        font-size: 30px;
        color: #dddddd;
    }

    .modal_rating:not(:checked)>label:before {
        content: "★ ";
    }

    .modal_rating>input:checked~label {
        color: #ffc700;
    }

    .modal_close {
        text-align: right;
        font-size: 22px;
        cursor: pointer;
        position: absolute;
        top: 0;
        right: 0;
        margin-top: 8px;
        margin-right: 10px;
    }

    .fixed_product_card_size strong {
        font-weight: normal;
    }




    .customer_comment_title {
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
        gap: 20px;
    }

    .customer_comment_avarage_rating {
        font-size: 40px;
    }

    .customer_comment_rating_name {
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
        color: var(--white);
        position: relative;
        background-color: var(--primary_color);
        padding: 0 12px 0 4px;
        height: 30px;
        font-size: 20px;
        border-radius: 2px 0 0 2px;
        background-size: 100% 100%;
        background-repeat: no-repeat;
        gap: 5px;
    }

    .customer_comment_rating_name:after {
        content: " ";
        position: absolute;
        right: -10px;
        width: 0;
        height: 0;
        border-top: 30px solid var(--primary_color);
        border-right: 10px solid transparent;
        border-left: 10px solid transparent;
    }

    .customer_comment_rating {
        margin-top: 25px;
        margin-bottom: 10px;
    }

    .customer_comment_rating_name i {
        font-size: 15px;
    }

    .customer_comment_rating span {
        color: var(--primary_color);
        font-size: 18px;
    }

    .comment_customer_name h5 {
        font-size: 16px;
    }

    .comment_customer_rating span {
        font-size: 14px;
    }

    .comment_customer_rating {
        margin-top: 8px;
        margin-bottom: 2px;
    }

    .customer_comment_review_content {
        max-height: 450px;
        overflow: auto;
    }

    .customer_comment_review_content::-webkit-scrollbar {
        width: 5px;
    }

    .customer_comment_review_content::-webkit-scrollbar-thumb {
        background: var(--primary_color);
    }

    .customer_comment_list ul {
        margin: 0;
        padding: 0;
    }

    .customer_comment_list ul li {
        display: block;
        overflow: hidden;
        list-style: none;
        border-top: 1px solid var(--border);
        padding: 20px 0px;
    }

    .customer_comment_btn {
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
        -webkit-box-pack: center;
        -ms-flex-pack: center;
        justify-content: center;
        height: 100%;
    }

    .customer_comment_btn_link {
        border: 1px solid var(--border);
        padding: 10px 20px;
        border-radius: 3px;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .customer_comment_btn_link:hover {
        color: var(--hover);
    }

    .customer_comment_item {
        width: 100%;
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
        overflow: hidden;
        -webkit-box-pack: center;
        -ms-flex-pack: center;
        justify-content: center;
        gap: 10px;
        margin-bottom: 10px;
    }

    .customer_comment_item_star {
        width: 100px;
    }

    .customer_comment_item_star span {
        font-size: 14px;
        line-height: 24px;
    }

    .customer_comment_item_percentage_segment {
        width: 200px;
        background-color: var(--border);
        height: 10px;
        display: block;
    }

    .customer_comment_item_percentage {
        width: 40px;
        text-align: right;
    }

    .customer_comment_item_percentage_segment span {
        background-color: var(--black);
        height: 10px;
        display: block;
    }

    .customer_comment_image img {
        width: 75px;
        height: 75px;
        float: left;
        margin-right: 5px;
    }

    .customer_comment_image {
        margin-top: 10px;
    }

    .customer_comment_view_all_link {
        color: var(--black);
        border-bottom: 1px solid;
        display: inline-block;
        font-weight: 400;
        font-size: 22px;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .customer_comment_view_all_link:hover {
        color: var(--hover);
    }

    .customer_comment_view_all {
        text-align: center;
    }

    .comments_pagination {
        text-align: right;
        margin-bottom: 10px;
        margin-top: 10px;
    }

    .comments_pagination ul {
        display: inline-block;
        margin: 0;
        padding: 0;
    }

    .comments_pagination ul li {
        list-style: none;
        float: left;
        border-left: 1px solid var(--border);
        border-top: 1px solid var(--border);
        border-bottom: 1px solid var(--border);
    }

    .comments_pagination ul li:last-child {
        border-right: 1px solid var(--border);
    }

    .comments_pagination ul li .comments_pagination_link {
        color: var(--black);
        display: inline-block;
        padding: 3px 15px;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .comments_pagination ul li .comments_pagination_link:hover {
        color: var(--hover);
    }

    .comments_pagination_active {
        background-color: var(--primary_color);
    }

    .comments_pagination_active:hover {
        color: var(--black) !important;
    }

    /*
==============================================================
    Fixed Product Cart Area Css
==============================================================
*/
    .fixed_product_sticky {
        position: fixed;
        top: 40%;
        right: 0;
        background: var(--white);
        -webkit-box-shadow: rgba(0, 0, 0, 0.35) 0px 5px 15px;
        box-shadow: rgba(0, 0, 0, 0.35) 0px 5px 15px;
        cursor: pointer;
        z-index: 888888;
    }

    .fixed_product_sticky_icon {
        text-align: center;
        margin-top: 15px;
    }

    .fixed_product_sticky_icon i {
        color: var(--primary_color);
        font-size: 22px;
    }

    .fixed_product_sticky_price {
        text-align: center;
    }

    .fixed_product_sticky_price p {
        font-size: 14px;
        padding: 5px 10px;
        color: var(--black);
    }

    .fixed_product_sticky_count {
        text-align: center;
    }

    .fixed_product_sticky_count p {
        background-color: var(--primary_color);
        color: var(--white);
        font-size: 14px;
        padding: 0px 10px;
    }

    .fixed_product_card_content {
        right: 8px;
        width: 460px;
        z-index: 999999999999;
    }

    .fixed_product_card_header {
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
        -webkit-box-pack: justify;
        -ms-flex-pack: justify;
        justify-content: space-between;
        padding: 10px;
        border-bottom: 1px solid var(--border);
    }

    .fixed_product_card_header_icon {
        position: relative;
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
        gap: 10px;
    }

    .fixed_product_card_header_icon i {
        font-size: 25px;
        color: var(--primary_color);
    }

    .fixed_product_card_header_icon span {
        background-color: var(--primary_color);
        color: var(--white);
        display: inline-block;
        width: 20px;
        height: 20px;
        line-height: 20px;
        text-align: center;
        border-radius: 20px;
        font-size: 14px;
    }

    .fixed_product_card_header_close i {
        font-size: 20px;
        background-color: var(--primary_color);
        color: var(--white);
        display: inline-block;
        padding: 5px 9px;
        cursor: pointer;
        border-radius: 3px;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .fixed_product_card_header_close i:hover {
        color: var(--hover);
    }

    .fixed_product_card_list {
        max-height: 700px;
        overflow-y: auto;
        padding-bottom: 300px;
    }

    .fixed_product_card_list ul {
        margin: 0;
        padding: 0;
    }

    .fixed_product_card_list ul li {
        list-style: none;
        display: block;
        overflow: hidden;
        border-bottom: 1px solid var(--border);
        padding: 10px 10px;
    }

    .fixed_product_card_list ul li:last-child {
        border-bottom: 0px;
    }

    .fixed_product_card_list_table_cell {
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        gap: 15px;
    }

    .fixed_product_card_image img {
        width: 80px;
        height: 80px;
    }

    .fixed_product_card_details {
        width: 100%;
    }

    .fixed_product_card_name_size_delete {
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-pack: justify;
        -ms-flex-pack: justify;
        justify-content: space-between;
    }

    .fixed_product_card_name h5 {
        font-size: 16px;
        line-height: 22px;
        color: var(--black);
    }

    .fixed_product_card_delete_icon {
        width: 40px;
        text-align: right;
    }

    .fixed_product_card_delete_icon i {
        color: var(--black);
        font-size: 18px;
        cursor: pointer;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .fixed_product_card_delete_icon i:hover {
        color: var(--hover);
    }

    .fixed_product_card_qty_minus {
        float: left;
    }

    .fixed_product_card_qty_minus i {
        width: 25px;
        height: 25px;
        line-height: 25px;
        text-align: center;
        border: 1px solid var(--border);
        border-right: 0px;
        border-radius: 3px 0px 0px 3px;
        color: var(--black);
        cursor: pointer;
    }

    .fixed_product_card_qty input {
        width: 40px;
        border: 1px solid var(--border);
        height: 25px;
        text-align: center;
        float: left;
    }

    .fixed_product_card_qty_plus {
        float: left;
    }

    .fixed_product_card_qty_plus i {
        width: 25px;
        height: 25px;
        line-height: 25px;
        text-align: center;
        border: 1px solid var(--border);
        border-left: 0px;
        border-radius: 0px 3px 3px 0px;
        color: var(--black);
        cursor: pointer;
    }

    .fixed_product_card_qty_price {
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
        -webkit-box-pack: justify;
        -ms-flex-pack: justify;
        justify-content: space-between;
        margin-top: 5px;
    }

    .fixed_product_card_close_price p {
        font-size: 16px;
        color: var(--black);
    }

    .fixed_product_card_footer {
        position: absolute;
        bottom: 0;
        left: 0;
        right: 0;
        width: 100%;
        padding: 10px;
        background-color: #f5f6f7;
    }

    .fixed_product_card_footer_count {
        display: -webkit-box;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
        -webkit-box-pack: justify;
        -ms-flex-pack: justify;
        justify-content: space-between;
        padding-top: 10px;
    }

    .fixed_product_card_footer_count strong {
        font-size: 20px;
        font-weight: 400;
    }

    .fixed_product_card_footer_count strong i {
        font-size: 26px;
        padding-right: 3px;
    }

    .fixed_product_card_footer_checkout {
        margin-top: 20px;
        margin-bottom: 10px;
    }

    .fixed_product_card_footer_checkout_link {
        display: block;
        width: 100%;
        background-color: var(--primary_color);
        text-align: center;
        color: var(--primary_text_color);
        font-size: 18px;
        padding: 10px 0px;
        font-weight: 500;
        border-radius: 3px;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
    }

    .fixed_product_card_footer_checkout_link:hover {
        color: var(--primary_text_color);
    }

    .fixed_product_card_footer_view_cart {
        text-align: center;
    }

    .fixed_product_card_footer_view_cart_link {
        font-weight: 500;
        text-align: center;
        -webkit-transition: 0.3s;
        -o-transition: 0.3s;
        transition: 0.3s;
        background-color: var(--black);
        color: var(--white);
        display: block;
        padding: 10px 0px;
        border-radius: 3px;
    }

    .fixed_product_card_footer_view_cart_link:hover {
        color: var(--hover);
    }

    /* scroll css */
    .fixed_product_card_list::-webkit-scrollbar {
        width: 5px;
    }

    .fixed_product_card_list::-webkit-scrollbar-track {
        background: var(--white);
    }

    .fixed_product_card_list::-webkit-scrollbar-thumb {
        background: var(--primary_color);
    }

    .fixed_product_card_list::-webkit-scrollbar-thumb:hover {
        background: #555;
    }

    /*
==============================================================
    Whatsapp Icon Css
==============================================================
*/
    .fixed_footer_whatsapp_icon {
        position: relative;
        background-color: #0DC043;
        color: var(--white);
        width: 40px;
        height: 40px;
        line-height: 40px;
        text-align: center;
        border-radius: 100%;
        position: fixed;
        bottom: 85px;
        right: 15px;
        z-index: 99;
    }

    .fixed_footer_whatsapp_icon .whatsapp_icon {
        color: var(--white);
        font-size: 25px;
    }

    .whatsapp_close i {
        position: absolute;
        top: -14px;
        right: -1px;
        color: var(--black);
        font-size: 18px;
        cursor: pointer;
    }

    .whatsapp_toggle {
        display: none;
    }

    /*
==============================================================
    Load More Area Css
==============================================================
*/

    .mobile_sticky_footer {}

    .mobile_sticky_footer {
        background-color: #fff;
        position: fixed;
        left: 0;
        right: 0;
        bottom: 0;
        z-index: 99999999999;
        padding: 0px 15px;
    }


    .mobile_sticky_footer ul li button {
        border: 1px solid var(--primary_color);
        background-color: var(--primary_color);
        color: var(--primary_text_color);
        display: inline-block;
        font-size: 15px;
        padding: 9px 30px;
        transition: .3s;
    }

    .mobile_sticky_footer {
        background-color: #fff;
        position: fixed;
        left: 0;
        right: 0;
        bottom: 0;
        z-index: 99999999999;
        padding: 10px 15px;
        display: flex;
        align-items: center;
        justify-content: space-between;
    }

    .mobile_sticky_footer_btn button {
        border: 1px solid var(--primary_color);
        background-color: var(--primary_color);
        color: var(--primary_text_color);
        display: inline-block;
        font-size: 15px;
        padding: 3px 15px;
        transition: .3s;
    }

    .mobile_sticky_footer_btn button.sticky_btn_add_to_cart {
        border: 1px solid #06d6a0;
        background-color: #06d6a0;
        color: var(--white);
        border-radius: 20px 0px 0px 20px;
    }

    .mobile_sticky_footer_btn a {
        border: 1px solid var(--primary_color);
        background-color: var(--primary_color);
        color: var(--primary_text_color);
        display: inline-block;
        font-size: 15px;
        padding: 3px 15px;
        transition: .3s;
        border-radius: 0px 20px 20px 0px;
    }

    .mobile_sticky_footer_btn a.sticky_btn_add_to_cart {
        border: 1px solid #06d6a0;
        background-color: #06d6a0;
        color: var(--white);
        border-radius: 20px 0px 0px 20px;
    }

    .mobile_sticky_footer_btn {
        display: flex;
        align-items: center;
    }

    .mobile_sticky_footer .mobile_sticky_footer_link i {
        display: block;
        text-align: center;
    }

    .mobile_sticky_footer_btn button.sticky_btn_order {
        border-radius: 0px 20px 20px 0px;
    }

    .mobile_sticky_footer .mobile_sticky_footer_link {
        color: var(--primary_color);
        font-weight: 400;
        font-size: 17px;
    }







    /*
==============================================================
    Load More Area Css
==============================================================
*/
    .load_more_details {
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 10px;
        border: 1px solid var(--primary_color);
        border-radius: 3px;
        cursor: pointer;
        width: 200px;
        text-align: center;
        margin: 0 auto;
        padding: 10px 5px;
        transition: 0.3s;
    }

    .load_more_details p,
    .load_more_details i {
        transition: 0.3s;
    }

    .load_more_details:hover {
        gap: 15px;
    }

    .load_more_details:hover p,
    .load_more_details:hover i {
        color: var(--hover);
    }

    .load_more_bar {
        width: 50%;
        height: 5px;
        background-color: #eeeeee;
        margin: 0 auto;
        margin-bottom: 35px;
    }

    .load_more_bar span {
        background-color: var(--primary_color);
        height: 5px;
        display: block;
    }

    /*==============================================================
success two section start
==============================================================
*/

    /* tr {
  vertical-align: none;
  display: flex;
  justify-content: space-between;
} */

    .success_header {
        background-color: var(--success_color);
        display: flex;
        justify-content: center;
        align-items: center;
        flex-direction: column;
        text-align: center;
        margin-top: 0;
        margin-bottom: 0;
        padding: 10px 0px;
    }

    .success_title {
        text-align: center;
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
    }

    .check_out_icon {
        background-color: #49c077;
        width: 43px;
        height: 43px;
        border-radius: 5px;
        display: flex;
        justify-content: center;
        align-items: center;
    }

    .check_out_icon i {
        font-size: xx-large;
        color: dimgrey;
    }

    .success_title h2 {
        color: white;
        font-weight: 600;
        margin-top: 20px;
    }

    .success_content_info {
        background-color: #f8f6f8;
        display: flex;
        justify-content: center;
        align-items: center;
        flex-direction: column;
    }

    .success_p {
        color: #1a1e23;
        font-family: "Inter", Sans-serif;
        font-size: 20px;
        font-weight: 600;
        letter-spacing: -0.5px;
        text-align: center;
        width: 800px;
        padding: 33px 0px;
    }

    .english_p {
        font-size: 25px !important;
    }

    .success_order_details {
        background-color: var(--white);
        border-style: solid;
        border-width: 1px 1px 1px 1px;
        border-color: #dee0e3;
        box-shadow: 0px 64px 80px -40px rgba(0, 0, 0, 0.12);
        border-radius: 12px 12px 12px 12px;
        width: 810px;
        height: auto;
        padding: 25px 40px;
    }

    .success_order_header {
        background-color: #f8f6f8;
        display: flex;
        gap: 20px;
        align-items: center;
        padding: 24px 40px;
    }

    .overview__order {
        display: inline-block;
        border-right: 1px dashed #ccc;
        padding: 0.5em 1em 0.5em 0;
        margin: 0.5em 0.5em 0.5em 0;
        list-style-type: none;
    }

    .overview__order:last-child {
        border-right: none;
    }

    .overview__order span {
        font-weight: 600;
        font-size: 13px;
        color: #746e6e;
    }

    .overview__order p {
        font-weight: 300;
    }

    .pay_deliveay_title {
        margin-top: 20px;
        font-size: 16px;
        font-weight: 300;
    }

    .order_details {
        padding: 24px 40px;
        background-color: #f8f6f8;
        margin-top: 30px;
    }

    .product_total {
        font-weight: 700;
        color: gray;
    }

    table.order_details_table tr {
        margin-top: 25px;
    }

    .order_details_table td {
        font-size: 13px;
        padding-bottom: 10px;
    }

    .order_left_side {
        width: 413px;
    }

    .winter_warm_face_masks {
        border-top: 1px dashed #ccc;
        border-bottom: 1px dashed #ccc;
    }

    .winter_warm_td {
        padding-top: 5px;
    }



    .checkout_form_title h3 {
        font-size: 24px;
        font-weight: 400;
    }

    .checkout_form {
        background-color: var(--white);
        padding: 30px;
        border-radius: 3px;
        border: 1px solid var(--border);
        border-radius: 9px;
    }

    .checkout_form_group {
        margin-bottom: 15px;
        position: relative;
    }

    .checkout_form_checkbox_group {
        margin-bottom: 15px;
    }

    .checkout_form_group i {
        position: absolute;
        bottom: 17px;
        transform: revert-layer;
        color: #999;
        right: 10px;
    }

    .checkout_form_group input {
        padding-right: 30px;
    }

    .checkout_form_group input,
    .checkout_form_group select,
    .checkout_form_group textarea {
        width: 100%;
        border: 1px solid var(--border);
        padding: 10px 10px;
        border-radius: 3px;
    }

    .checkout_form_checkbox.form-check {
        padding-left: 0;
        margin-bottom: 0;
        border: 1px solid var(--border);
        padding: 8px 10px;
        display: flex;
        align-items: center;
    }

    .checkout_form_checkbox.border_top_none {
        border-top: none !important;
    }

    .checkout_form_checkbox.form-check .form-check-input {
        margin-left: 0;
        cursor: pointer;
        margin-top: 0px !important;
    }

    .checkout_form_checkbox.form-check label {
        padding-left: 10px;
        cursor: pointer;
        display: block;
        width: 100%
    }

    .checkout_form_checkbox.form-check {
        padding-left: 0;
        margin-bottom: 0;
        border: 1px solid var(--border);
        padding: 8px 10px;
    }

    .checkout_form_checkbox_group h4 {
        font-weight: 400;
        margin-bottom: 9px;
        font-size: 16px;
    }




    .checkout_form_group .checkout_form_select {
        padding: 12px 10px;
    }

    .checkout_form_btn {
        text-align: center;
        margin-top: 20px;
    }

    .checkout_form_btn_link {
        border: none;
        background-color: var(--primary_color);
        color: var(--primary_text_color);
        display: flex;
        transition: 0.3s;
        width: 100%;
        align-items: center;
        justify-content: center;
        gap: 8px;
        font-weight: 500;
        padding: 10px 0px;
        border-radius: 3px;
    }

    .checkout_form_btn_link:hover {
        color: var(--primary_hover_color);
    }

    .checkout_order_summary {
        background-color: var(--white);
        padding: 30px;
        border-radius: 10px;
        border: 1px solid var(--border);
    }

    .payment_methods_img {
        margin-top: 14px;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .payment_methods_img ul {
        display: flex;
        gap: 10px;
        list-style: none;
    }

    .payment_images {
        width: 150px;
        cursor: pointer;
        transition: transform 0.3s ease;
    }

    .payment_images img {
        width: 100%;
        height: 100%;
        cursor: pointer;
        border: 2px solid #ddd;
        border-radius: 4px
    }

    .active_payment {
        border: 2px solid var(--primary_color);
        border-radius: 4px
    }

    .order_summary_title {
        text-align: center;
        margin-bottom: 30px;
    }

    .order_summary_title h3 {
        font-size: 24px;
        font-weight: 400;
    }

    .order_summary_table {
        overflow-x: auto;
    }

    /* width */
    .order_summary_table::-webkit-scrollbar {
        height: 3px;
    }

    /* Track */
    .order_summary_table::-webkit-scrollbar-track {
        background: #f1f1f1;
    }

    /* Handle */
    .order_summary_table::-webkit-scrollbar-thumb {
        background: #888;
    }

    /* Handle on hover */
    .order_summary_table::-webkit-scrollbar-thumb:hover {
        background: #555;
    }

    .order_summary_table .table thead tr th {
        font-weight: 500;
    }

    .order_summary_table tbody,
    td,
    tfoot,
    th,
    thead,
    tr {
        border-color: var(--border) !important;
        border-style: solid;
        border-width: 0;
    }

    .order_summary_table table>:not(caption)>*>* {
        padding: .5rem .5rem;
        border-bottom-width: 1px;
    }

    .checkout_product_name_image {
        width: 50px;
        height: 50px;
        float: left;
        margin-right: 7px;
        display: block;
        overflow: hidden;
    }

    .checkout_product_name_image img {
        width: 100%;
        height: 100%;
    }

    .products_checkout_name {
        display: block;
        overflow: hidden;
    }

    .products_checkout_name p {
        line-height: 22px;
        font-size: 14px;
        width: max-content;
        white-space: normal;
    }

    .checkout_product_name_image p {
        font-size: 14px;
        line-height: 18px;
    }

    .checkout_product_qty {
        width: 85px;
        display: flex;
    }

    .checkout_product_qty_minus {
        border: 1px solid var(--border);
        color: #979797;
        width: 25px;
        height: 25px;
        line-height: 25px;
        text-align: center;
        border-right: 0px;
        border-radius: 3px 0px 0px 3px;
        cursor: pointer;
        background-color: transparent;
        font-size: 12px;
        display: block;
        float: left;
    }

    .checkout_product_qty input {
        border: 1px solid var(--border);
        color: #979797;
        width: 30px;
        height: 25px;
        line-height: 25px;
        text-align: center;
        float: left;
        font-size: 14px;
        display: block;
    }

    .checkout_product_qty_plus {
        border: 1px solid var(--border);
        color: #979797;
        width: 25px;
        height: 25px;
        line-height: 25px;
        text-align: center;
        border-left: 0px;
        border-radius: 0px 3px 3px 0px;
        cursor: pointer;
        background-color: transparent;
        font-size: 12px;
        display: block;
    }

    .checkout_product_price p {
        font-size: 14px;
        width: max-content;
    }

    .checkout_product_delete_icon {
        text-align: right;
    }

    .checkout_product_total_price p {
        font-size: 14px;
        width: max-content;
    }

    .checkout_product_delete_icon_link {
        border: none;
        background-color: transparent;
        color: red;
        font-size: 16px;
        cursor: pointer;
    }

    .checkout_form_group select {
        color: #999 !important;
    }

    .checkout_form_group select option {
        color: black !important;
    }



    .checkout_form_btn_link {
        -webkit-animation: 1.40s both rsiShaker1 infinite;
        animation: 1.40s both rsiShaker1 infinite
    }



    .header_middle_icon svg {
        width: 33px;
        color: var(--primary_color);
    }


    .header_middle_text {
        display: block;
        overflow: hidden;
    }

    .header_middle_text span {
        display: block;
        line-height: 17px;
        color: var(--black);
        font-size: 14px;
    }

    .single_product_tab_content img {
        max-width: 100%;
        height: auto;
        display: block;
    }

    /*
==============================================================
    Responsive Area Css
==============================================================
*/
    @media (min-width:1200px) and (max-width: 1600px) {
        .column-4 {
            -webkit-box-flex: 0;
            -ms-flex: 0 0 auto;
            flex: 0 0 auto;
            width: 20%;
        }
    }

    @media only screen and (min-width: 1400px) {
        .container {
            max-width: 90%;
        }
    }

    @media only screen and (max-width: 1700px) {}

    @media only screen and (max-width: 1600px) {
        .zooming_show_image {
            /* height: 430px; */
        }

        .zooming_image_list ul li img {
            width: 60px;
            margin-right: 3px;
            height: 60px;
        }

        .single_product_add_to_cart {
            font-size: 14px;
        }

        .single_product_buy_now_btn_link {
            font-size: 14px;
        }

        .single_product_qty_plus {
            font-size: 14px;
        }

        .single_product_qty_minus {
            font-size: 14px;
        }

        .single_product_qty input {
            font-size: 14px;
        }
    }

    @media only screen and (max-width: 1500px) {}

    @media only screen and (max-width: 1399.98px) {
        .sp_wrap {
            max-width: 100%;
        }

        .single_payment_method ul {
            gap: 15px;
        }

        .single_product_add_to_cart {
            font-size: 15px;
        }

        .single_product_buy_now_btn_link {
            font-size: 15px;
        }

        .single_product_qty_plus {
            font-size: 15px;
        }

        .single_product_qty_minus {
            font-size: 15px;
        }

        .single_product_qty input {
            font-size: 15px;
        }


        /* .checkout_product_name_image {
            width: 200px;
        } */

        .zooming_show_image {
            /* height: 350px; */
        }

        .product_image {
            /* max-height: 260px; */
        }

        .header_middle_wishlist {
            margin: 0px 25px;
        }
    }

    @media screen and (max-width: 1199.98px) {
        .service_item {
            gap: 10px;
            padding: 10px 5px;
        }

        .single_product_details {
            padding-left: 0px;
        }

        .single_payment_method ul li p {
            font-size: 14px;
        }



        .single_product_add_to_wishlist {
            font-size: 16px;
        }

        .product_image {
            /* max-height: 260px; */
        }

        .header_middle_logo img {
            height: 35px;
        }

        .single_product_specification_content {
            display: -webkit-box;
            display: -ms-flexbox;
            display: flex;
            -webkit-box-align: center;
            -ms-flex-align: center;
            align-items: center;
            -webkit-box-pack: center;
            -ms-flex-pack: center;
            justify-content: center;
            gap: 20px;
        }

        .single_product_specification_list {
            margin-bottom: 0px;
        }

        .customer_comment_avarage_rating {
            font-size: 20px;
        }

        .customer_comment_rating_name {
            height: 27px;
            font-size: 14px;
        }

        .customer_comment_rating_name:after {
            border-top: 27px solid var(--primary_color);
        }

        .customer_comment_rating_name i {
            font-size: 12px;
        }

        .customer_comment_rating span {
            font-size: 14px;
        }

        .customer_comment_rating {
            margin-top: 10px;
            margin-bottom: 2px;
        }

        .customer_comment_item {
            gap: 5px;
        }

        .customer_comment_item_percentage_segment {
            width: 150px;
        }

        .customer_comment_title {
            -webkit-box-pack: center;
            -ms-flex-pack: center;
            justify-content: center;
        }

        .customer_comment_rating {
            text-align: center;
        }

        .customer_comment_rating_count {
            text-align: center;
        }

        .comments_pagination {
            text-align: center;
        }

        .customer_comment_image img {
            width: 50px;
            height: 50px;
        }

        .zooming_show_image {
            /* height: 430px; */
        }

        .single_product_qty_minus {
            width: 32px;
        }

        .single_product_qty_plus {
            width: 32px;
        }
    }

    @media screen and (max-width: 1028px) {
        .qty_text {
            width: 40px;
        }
    }

    @media screen and (max-width: 991.98px) {
        .mobile_sticky_footer_table {
            display: block;
        }

        .single_product_tab_video {
            width: 100%;
            margin: 0 auto;
        }

        .social_share_icon ul {
            margin-bottom: 40px;
        }

        .sticky_product {
            display: none !important;
        }

        .youtube_video {
            width: 100%;
            height: 350px;
        }

        .fiex_single_sticky {
            display: none !important;
        }

        .padding_top_f {
            margin-top: 30px;
        }

        ._footer_title {
            margin-bottom: 15px;
        }

        .header_top {
            height: 100%;
        }

        ._search_product {
            max-height: 300px;
        }

        .header_search input {
            border-radius: 3px;
            padding: 10px 20px;
            height: 45px;
            line-height: 45px;
        }

        .main_menu_link.h_combo {
            padding: 3px 12px 3px 2px;
        }

        /* .header_search_btn {
    font-size: 19px;
    height: 45px;
    line-height: 45px;
    padding: 0px 15px;
    border-radius: 0px 3px 3px 0px;
} */
        .header_search_btn {
            display: none;
        }

        .shop_filters h5 {
            font-size: 16px;
            line-height: 26px;
        }

        .shop_filters i {
            font-size: 16px;
        }

        .shop_filters {
            padding: 5px 10px;
            border: 1px solid var(--border);
            border-radius: 3px;
            gap: 5px;
        }

        .profile_form_item input,
        select {
            padding: 5px 15px;
            padding-left: 5px;
        }

        .shop_product_header_item_short_by_wrap {
            margin-bottom: 20px;
            display: flex;
            align-items: center;
            justify-content: end;
        }

        .shop_area {
            margin-top: 10px;
        }

        .section_padding {
            padding: 20px 0px;
        }

        .section_padding_top {
            padding-top: 20px;
        }

        .section_padding_bottom {
            padding-bottom: 20px;
        }

        .section_top_space {
            padding-top: 15px;
        }

        .fixed_footer_menu {
            display: block;
        }

        .header_mobile_logo img {
            height: 50px;
        }

        .header_mobile_search i {
            font-size: 22px;
        }

        .header_mobile_icon_link i {
            font-size: 18px;
        }

        .header_mobile_cart {
            width: 18px;
            height: 18px;
            font-size: 13px;
            line-height: 10px;
        }

        .auth_wrap {
            padding: 20px;
        }

        .auth_title {
            margin-bottom: 20px;
        }

        .header_middle_search input {
            height: 40px;
        }

        .header_middle_search_link {
            font-size: 16px;
        }

        .fixed_product_sticky {
            /* display: none;  */
        }

        .header_mobile_device {
            padding: 8px 0px;
        }

        .header_middle {
            padding: 3px 0px;
            border-top: 0px;
        }

        .search_class {
            display: none;
        }

        .search_toggle {
            display: block;
            margin-bottom: 10px;
        }

        .header_mobile_menu {
            z-index: 9999999999;
        }

        .header_mobile_top {
            display: -webkit-box;
            display: -ms-flexbox;
            display: flex;
            -webkit-box-align: center;
            -ms-flex-align: center;
            align-items: center;
            -webkit-box-pack: justify;
            -ms-flex-pack: justify;
            justify-content: space-between;
            padding: 10px 20px;
            position: static;
        }

        .header_mobile_close_icon i {
            font-size: 25px;
        }

        .header_mobile_close_icon i {
            font-size: 25px;
        }

        .mobile_main_menu ul {
            margin: 0;
            padding: 0;
        }

        .mobile_main_menu ul li {
            list-style: none;
            display: block;
            border-top: 1px solid var(--border);
            padding: 8px 20px;
            position: relative;
            overflow: hidden;
        }

        .mobile_main_menu ul li i {
            position: absolute;
            top: 7px;
            right: 0;
            margin-top: 8px;
            margin-right: 20px;
            font-size: 14px;
        }

        .mobile_main_menu ul li .mobile_main_menu_link {
            color: var(--black);
            display: block;
            font-size: 16px;
            text-transform: uppercase;
            -webkit-transition: 0.3s;
            -o-transition: 0.3s;
            transition: 0.3s;
        }

        .mobile_main_menu ul li:hover>.mobile_main_menu_link {
            color: var(--primary_color);
        }

        .mobile_main_menu ul li .mobile_main_submenu {
            margin-left: 20px;
        }

        .mobile_main_menu ul li .mobile_main_submenu li {
            padding: 0px;
            border: none;
            overflow: hidden;
            display: block;
            border-bottom: 1px solid #ddd;
        }

        .mobile_main_menu ul li .mobile_main_submenu li:last-child {
            border-bottom: none;
        }

        .mobile_main_menu ul li .mobile_main_submenu li .mobile_main_submenu_link {
            color: var(--black);
            display: block;
            font-size: 16px;
            text-transform: capitalize;
            -webkit-transition: 0.3s;
            -o-transition: 0.3s;
            transition: 0.3s;
            padding: 4px 0px;
        }

        .mobile_main_menu ul li .mobile_main_submenu .mobile_main_sub_submenu {
            margin-left: 16px;
        }

        .mobile_main_menu ul li .mobile_main_submenu li .mobile_main_sub_submenu li {
            padding: 0px;
            border-bottom: 1px solid #ddd;
        }

        .mobile_main_menu ul li .mobile_main_submenu li .mobile_main_sub_submenu li:last-child {
            border-bottom: none;
        }

        .mobile_main_menu ul li .mobile_main_submenu li .mobile_main_sub_submenu_link {
            color: var(--black);
            display: block;
            font-size: 16px;
            text-transform: capitalize;
            -webkit-transition: 0.3s;
            -o-transition: 0.3s;
            transition: 0.3s;
            padding: 4px;
        }

        .mobile_main_menu ul li .main_menu_link.h_buy_one,
        .mobile_main_menu ul li .main_menu_link.h_brand {
            padding: 3px 12px 3px 6px;
        }

        .main_menu_link.h_daily_offers {
            padding: 3px 12px 3px 6px;
        }

        .mobile_submenu_class {
            display: none;
        }

        .mobile_submenu_toggle {
            display: block;
        }

        .mobile_sub_submenu_class {
            display: none;
        }

        .mobile_sub_submenu_toggle {
            display: block;
        }

        .banner_slider_image {
            height: 500px;
        }

        .footer_middle {
            margin-top: 10px;
            margin-bottom: 10px;
        }

        .footer_copyright {
            text-align: center;
        }

        .footer_develop_by {
            float: inherit;
            text-align: center;
            display: -webkit-box;
            display: -ms-flexbox;
            display: flex;
            -webkit-box-align: center;
            -ms-flex-align: center;
            align-items: center;
            -webkit-box-pack: center;
            -ms-flex-pack: center;
            justify-content: center;
            margin-top: 5px;
        }

        .footer_area {
            padding-bottom: 50px;
        }

        .zooming_show_image {
            /* height: 550px; */
        }

        .success_content_info {
            padding: 0px 10px;
        }

        .success_p {
            width: 100%;
            padding: 15px 5px;
            font-size: 18px;
            line-height: 30px;
        }

        .success_order_details {
            width: 100%;
            padding: 5px 6px;
        }

        .success_order_header {
            flex-direction: column;
            gap: 0;
            align-items: baseline;
            padding: 5px 30px;
        }

        .overview__order {
            border-right: none;
            border-bottom: 1px dashed #ccc;
            width: 100%;
        }

        .overview__order:last-child {
            border-bottom: none;
        }

        .zooming_image_content {
            flex-direction: column;
        }

        .zooming_image_list ul li {
            display: inline-block;
        }

        .zooming_image_list ul {
            float: inherit;
        }

        .zooming_image_list {
            margin-top: 10px;
            ;
        }


        /* fixed product page footer */

        .only_product_page_fixed_footer_for_mobile {
            padding: 10px 15px;
            background-color: #fff;
            box-shadow: 0 -2px 10px rgba(0, 0, 0, 0.05);
            position: fixed;
            bottom: 0;
            left: 0;
            display: none;
            z-index: 99999999999 !important;
            width: 100%;
            margin: 0 auto;
        }

        .only_product_page_fixed_footer_for_mobile>div {
            display: flex;
            justify-content: space-between;
            align-items: center;
            width: 350px;
        }

        .mobile_sticky_footer_table {
            display: block;
            background-color: var(--white);
            -webkit-box-shadow: var(--shadow);
            box-shadow: var(--shadow);
            position: fixed;
            bottom: 0;
            left: 0;
            width: 100%;
            padding: 0px 15px;
            padding-top: 5px;
            padding-bottom: 3px;
            z-index: 111;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2) !important;
        }

        .home_page_link {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            width: 50px;
            color: var(--primary_color);
        }

        /* Common styles */
        .fixed_footer_two_btn {
            display: flex;
            justify-content: end;
            align-items: center;
            gap: 0;
        }

        .fixed_footer_two_btn .btn {
            border: none;
            outline: none;
            font-size: 14px;
            font-weight: 600;
            color: #fff;
            padding: 10px 15px;
            cursor: pointer;
            display: flex;
            align-items: center;
            gap: 5px;
            transition: all 0.3s ease;
            white-space: nowrap;
        }

        /* Add To Cart Button */
        .footer_add_to_cart_btn {
            background: red !important;
            /* greenish color */
            border-top-left-radius: 50px;
            border-bottom-left-radius: 50px;
        }

        .footer_add_to_cart_btn:hover {
            background: red !important;
            transform: translateY(-2px);
        }

        /* Order Now Button */
        .footer_order_now_btn {
            background: var(--primary_color);
            /* purple color */
            border-top-right-radius: 50px;
            border-bottom-right-radius: 50px;
            text-decoration: none;
        }

        .footer_order_now_btn:hover {
            background: var(--primary_color);
            transform: translateY(-2px);
        }

    }




    @media screen and (max-width: 767.98px) {
        .brand_image_area_see_all_btn {
            top: -1px;
        }

        .brand_image_area_see_all_btn a {
            padding: 0px 9px;
            font-size: 14px;
            padding-top: 1px;
            padding-bottom: 2px;
        }

        ._custom_padding_top_index_section {
            padding-top: 10px;
        }

        .product_name {
            margin-top: 10px;
            height: 44px;
            overflow: hidden;
        }

        footer.footer_area.section_margin_top {
            margin-top: 15px;
        }

        ._footer_para {
            margin-top: 15px;
            margin-bottom: 15px;
        }

        ._footer_social ul li {
            margin-right: 2px;
        }

        ._footer_social ul li ._footer_social_link {
            width: 35px;
            height: 35px;
            line-height: 35px;
        }

        .padding_top_f {
            margin-top: 15px;
        }

        ._footer_title {
            margin-bottom: 8px;
        }

        ._footer_number a {
            font-size: 25px;
            padding-top: 3px;
        }

        ._footer_top {
            margin-bottom: 20px;
        }

        .brand_image_area_title_subtitle p {
            font-size: 14px;
            font-weight: normal;
            line-height: 20px;
        }


        ._breadcrumb ul li {
            margin-bottom: 10px;
        }



        .cart_review {
            display: none;
        }

        .product_rating span {
            font-size: 11px;
        }

        .product_btn_mobile {
            padding: 0px 0px;
            margin-bottom: 1px;
            margin-top: 0px;
            display: block !important;
        }

        .product_btn_link,
        .product_btn_mobile {
            padding: 2px 5px;
            font-size: 13px;
        }

        .product_price {
            margin: 0px 0px;
        }

        .brand_list ul li {
            /* padding-left: 15px; */
        }

        .section_title h2 {
            font-size: 22px;
        }

        .featured_pro_title h2 {
            font-size: 22px;
        }

        .combo_products_active .owl-nav {
            font-size: 20px;
        }



        .shop_product_header_short_by p {
            display: none;
        }

        .brand_ordering .brand_ordering_ul {
            justify-content: center;
            gap: 5px;
        }

        .brand_title {
            padding: 15px 15px;
        }

        .fixed_footer_whatsapp_icon {
            position: relative;
            background-color: #0DC043;
            color: var(--white);
            width: 40px;
            height: 40px;
            line-height: 40px;
            text-align: center;
            border-radius: 100%;
            position: fixed;
            bottom: 85px;
            right: 15px;
            z-index: 99;
        }

        .custom_section_title h2 {
            display: block !important;
            width: 100% !important;
            text-align: center !important;
        }

        .slider_banner_active .owl-nav div {
            display: none;
        }

        /* heading category list toggle css start */
        .section_title_table_cell {
            -webkit-box-pack: center;
            -ms-flex-pack: center;
            justify-content: center;
        }

        .category_list_class {
            display: none;
        }

        .category_list_toggle {
            display: block;
        }

        .category_list {
            position: relative;
        }

        .category_list ul li {
            display: block;
            width: 100%;
            border-bottom: 1px solid var(--border);
        }

        .category_list ul li:last-child {
            border-bottom: 0px;
        }

        .category_list ul {
            margin: 0;
            padding: 0;
            position: absolute;
            top: 100%;
            right: -20px;
            width: 200px;
            z-index: 999999;
            background-color: var(--white);
            -webkit-box-shadow: var(--shadow);
            box-shadow: var(--shadow);
            margin-top: 21px;
        }

        .section_title h2 i {
            padding-left: 10px;
            font-size: 18px;
        }

        .category_list ul li .category_list_link {
            border-radius: 0px;
            text-align: center;
            color: var(--black);
            background-color: transparent;
            border: none;
        }

        .section_title i {
            display: block;
        }

        .section_title h2 {
            display: -webkit-box;
            display: -ms-flexbox;
            display: flex;
            -webkit-box-align: center;
            -ms-flex-align: center;
            align-items: center;
            justify-content: center;
        }

        /* heading category list toggle css end */

        .product_image {
            /* max-height: 160px; */
        }

        .footer_logo {
            text-align: center;
        }

        .footer_area {
            padding-top: 30px;
        }

        .footer_social ul li .footer_social_link {
            width: 35px;
            height: 35px;
            line-height: 35px;
            font-size: 18px;
        }

        .single_product_specification_content {
            display: inherit;
        }

        .single_product_specification_list {
            margin-bottom: 15px;
        }

        .product_name_link h2 {
            font-size: 14px;
        }

        .product_name_link {
            font-size: 14px;
        }

        .product_name_link h2 {
            font-size: 14px;
        }

        .order_tracking_content {
            padding: 20px;
        }

        .wishlist_image img {
            width: 40px;
            height: 40px;
        }

        .wishlist_name_link {
            line-height: 18px;
            font-size: 13px;
        }

        .wishlist_price span {
            display: block;
            font-size: 13px;
            line-height: 18px;
        }

        .wishlist_action_link {
            font-size: 12px;
            padding: 0px 2px;
            width: 75px;
        }

        .wishlist_delete {
            text-align: right;
        }

        .wishlist_price {
            width: 75px;
        }

        .wishlist_name {
            width: 120px;
        }

        .wishlist_delete_link {
            font-size: 16px;
        }

        .view_cart_coupon input {
            width: 100%;
            padding: 7px 10px;
            height: 45px;
        }

        .view_cart_coupon_update {
            display: block;
        }

        .view_cart_coupon_btn {
            padding: 10px 15px;
            height: 45px;
        }

        .view_cart_update {
            text-align: center;
            margin-top: 20px;
        }

        .view_cart_update_btn {
            padding: 10px 20px;
        }

        .view_cart_subtotal strong {
            font-size: 16px;
        }

        .view_cart_total strong {
            font-size: 16px;
        }

        .view_cart_image img {
            width: 40px;
            height: 40px;
        }

        .view_cart_name_link {
            font-size: 13px;
            line-height: 18px;
        }

        .view_cart_name {
            width: 120px;
        }

        .view_cart_price span {
            display: block;
            font-size: 13px;
            line-height: 18px;
        }

        .view_cart_price {
            width: 75px;
        }

        .view_cart_qty_minus {
            width: 25px;
            height: 25px;
            line-height: 25px;
            font-size: 16px;
        }

        .view_cart_qty input {
            width: 35px;
            height: 25px;
            line-height: 25px;
        }

        .view_cart_qty_plus {
            width: 25px;
            height: 25px;
            line-height: 25px;
            font-size: 16px;
        }

        .view_cart_qty {
            width: 85px;
        }

        .profile_form_item input {
            padding: 10px 10px;
        }

        .profile_form_submit_btn_link {
            padding: 10px 0px;
        }

        .auth_item {
            margin-bottom: 10px;
        }

        .order_tracking_sender_title h3 {
            padding: 5px 0px;
            font-size: 18px;
        }

        .order_tracking_courier_title h3 {
            font-size: 18px;
            padding: 5px 0px;
        }

        .header_search_item_product_name p {
            font-size: 14px;
            line-height: 18px;
        }

        .header_search_item_product_price span {
            font-size: 14px;
        }

        .customer_comment_review_content {
            max-height: 350px;
        }

        .load_more_bar {
            width: 80%;
        }

        .load_more_bar p {
            font-size: 14px;
        }

        .load_more_details {
            width: 120px;
            padding: 2px 5px;
        }

        .load_more_details p,
        .load_more_details i {
            font-size: 14px;
        }
    }

    @media screen and (max-width: 600px) {
        .single_product_tab ul li {
            margin-right: 5px;
            margin-bottom: 7px;
        }

        .single_payment_method ul {
            display: block;
        }

        .single_payment_method ul li {
            display: flex;
            align-items: center;
            gap: 5px;
            margin-bottom: 15px;
        }

        .single_payment_method ul li:last-child {
            margin-bottom: 0px;
        }

        .single_payment_method_img {
            height: 30px;
        }

        .single_payment_method ul li p {
            font-size: 16px;
            padding-left: 10px;
        }

        .single_product_add_to_wishlist {
            font-size: 20px;
        }

        .sp_social ul li {
            margin-right: 20px;
        }


        .checkout_form_btn {
            text-align: center;
            margin-top: 20px;
            position: fixed !important;
            bottom: 56px;
            left: 0;
            z-index: 3;
            padding: 0px 12px;
            width: 100%;
            margin: 0;
        }




    }

    @media screen and (max-width: 575.98px) {
        .product_image {
            /* max-height: 240px; */
        }


        .checkout_form {
            padding: 10px;
        }

        .checkout_form_title {
            margin-bottom: 20px;
        }

        .checkout_form_title h3 {
            font-size: 20px;
        }

        .order_summary_title h3 {
            font-size: 20px;
        }

        .order_summary_title {
            margin-bottom: 20px;
        }

        .checkout_form_group input,
        .checkout_form_group select,
        .checkout_form_group textarea {
            padding: 7px 10px;
        }

        .checkout_form_group .checkout_form_select {
            padding: 8px 10px;
        }

        .checkout_form_group {
            margin-bottom: 6px;
        }

        .checkout_form_group label {
            margin-bottom: 1px;
        }

        .checkout_order_summary {
            padding: 10px;
        }

        .order_summary_table .table thead tr th {
            font-size: 13px;
            line-height: 20px;
        }

        .checkout_product_name_image p {
            font-size: 12px;
        }

        .apply_coupon_item input {
            padding: 6px 10px;
        }

        .apply_coupon_item_link {
            padding: 6px 15px;
        }

        .success_title h3 {
            font-size: 20px;
            line-height: 30px;
        }

        .success_subtitle p {
            font-size: 14px;
        }

        .success_call p {
            font-size: 14px;
        }

        .product_name_link {
            margin-bottom: 3px;
        }

        .product_new_price {
            font-size: 14px;
        }

        .product_discount_price {
            font-size: 14px;
            padding-left: 5px;
        }

        .product_btn_link {
            padding: 1px 0px;
            font-size: 14px;
        }

        .checkout_form {
            padding: 15px;
        }

        .checkout_form_title {
            margin-bottom: 12px;
        }

        .checkout_form_title h2 {
            font-size: 20px;
        }

        .order_summary_title h2 {
            font-size: 20px;
        }

        .order_summary_title {
            margin-bottom: 0px;
        }

        .checkout_form_group input,
        .checkout_form_group select,
        .checkout_form_group textarea {
            padding: 7px 10px;
        }

        .checkout_form_group .checkout_form_select {
            padding: 8px 10px;
        }

        .checkout_form_group {
            margin-bottom: 6px;
        }

        .checkout_form_group label {
            margin-bottom: 1px;
        }

        .checkout_form_btn_link {
            padding: 8px 30px;
        }

        .checkout_order_summary {
            padding: 15px;
        }

        .order_summary_table .table thead tr th {
            font-size: 13px;
            line-height: 20px;
        }

        .checkout_product_name_image p {
            font-size: 12px;
        }

        .apply_coupon_item input {
            padding: 6px 10px;
        }

        .apply_coupon_item_link {
            padding: 6px 15px;
        }

        .success_title h3 {
            font-size: 20px;
            line-height: 30px;
        }

        .success_subtitle p {
            font-size: 14px;
        }

        .success_call p {
            font-size: 14px;
        }

        .product_new_price {
            font-size: 13px;
        }

        .product_discount_price {
            font-size: 14px;
            padding-left: 5px;
        }

        .order_tracking_title strong {
            font-size: 13px;
            line-height: 20px;
            font-weight: 500;
        }

        .order_tracking_title p {
            font-size: 13px;
            line-height: 20px;
        }

        .order_tracking_search input {
            padding: 7px 10px;
            font-size: 14px;
        }

        .order_tracking_search_btn_link {
            font-size: 18px;
            padding: 8px 0px;
        }

        .order_tracking_date p {
            font-size: 14px;
        }

        .order_tracking_invoice strong {
            font-weight: 500;
        }

        .order_tracking_order_status_details {
            float: inherit;
            margin-bottom: 15px;
        }

        .order_tracking_header {
            padding-bottom: 20px;
            margin-bottom: 15px;
        }

        .order_tracking_sender_organization h3 {
            font-size: 20px;
        }

        .order_tracking_courier_name h3 {
            font-size: 20px;
        }

        .order_tracking_customer_item {
            -webkit-box-align: inherit;
            -ms-flex-align: inherit;
            align-items: inherit;
        }

        .auth_item input {
            padding: 10px 15px;
        }

        .auth_sub_btn_link {
            padding: 10px 0px;
            font-size: 16px;
        }

        .auth_sub_btn_two_link {
            padding: 10px 0px;
            font-size: 16px;
        }

        .auth_title h3 {
            font-size: 20px;
        }

        .zooming_show_image {
            /* height: 350px; */
        }

        .order_left_side {
            width: 284px;
        }
    }

    .order_details {
        padding: 24px 40px;
        background-color: #f8f6f8;
        margin-top: 15px;
    }

    .product_total {
        font-weight: 700;
        color: gray;
    }

    .checkout_product_th_total_price {
        white-space: nowrap;
    }

    table.order_details_table tr {
        margin-top: 25px;
    }

    .order_summary_table table thead tr th {
        font-weight: 400;
        color: var(--black);
        padding: 5px;
        font-size: 16px;
    }

    .order_summary_table table tbody tr td {
        padding-top: 5px;
    }

    .order_summary_table table {
        width: 100%;
    }

    .order_summary_table table thead tr {
        border-bottom: 1px solid var(--border);
    }

    .order_details_table td {
        font-size: 13px;
        padding-bottom: 10px;
    }

    .order_left_side {
        width: 413px;
    }

    .winter_warm_face_masks {
        border-top: 1px dashed #ccc;
        border-bottom: 1px dashed #ccc;
    }

    .winter_warm_td {
        padding-top: 5px;
    }

    @media screen and (max-width: 480px) {
        .shop_by_origin_image {
            max-height: 120px;
        }

        .product_image {
            /* max-height: 195px; */
        }

        .single_product_name {
            margin-bottom: 10px;
        }

        .single_product_name h2 {
            font-size: 18px;
        }

        .single_product_specification_list ul li {
            font-size: 12px;
            margin-bottom: 2px;
        }

        .single_product_call_title p {
            line-height: 24px;
        }

        .single_product_tab ul li {
            margin-right: 5px;
        }

        .single_product_tab_nav .single_product_tab_nav_link {
            font-size: 10px;
            padding: 2px 6px;
        }

        .single_product_tab_nav {
            display: -webkit-box;
            display: -ms-flexbox;
            display: flex;
            -webkit-box-align: center;
            -ms-flex-align: center;
            align-items: center;
            -webkit-box-pack: justify;
            -ms-flex-pack: justify;
            justify-content: center;
        }

        .order_details {
            padding: 24px 8px;
        }

        .order_left_side {
            width: 145px;
            padding-right: 25px;
        }
    }

    @media screen and (max-width: 375px) {
        .product_image {
            /* max-height: 170px; */
        }

        .zooming_show_image {
            /* height: 330px; */
        }
    }

    @media screen and (max-width: 350px) {
        .product_image {
            /* max-height: 155px; */
        }

        .sp_social ul li .sp_social_link {
            font-size: 14px;
        }

        .mobile_sticky_footer_btn button {
            font-size: 12px;
        }

        .mobile_sticky_footer_btn a {
            font-size: 12px;
        }

        .mobile_sticky_footer .mobile_sticky_footer_link {
            font-size: 15px;
        }


    }
</style>
