<!--============ Header Area Start ============-->
<header class="header_area">
    <div class="header_top">
        <div class="container">
            <div class="row">
                <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-6 col-sm-12 col-12">
                    <div class="header_top_title">
                        <p>{{ $general_settings->title }}</p>
                    </div>
                </div>
                <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-6 d-none d-md-block">
                    <div class="header_quick">
                        <ul>
                            <li>
                                <span><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none"
                                        stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                        stroke-linejoin="round" class="feather feather-phone">
                                        <path
                                            d="M22 16.92v3a2 2 0 0 1-2.18 2 19.79 19.79 0 0 1-8.63-3.07 19.5 19.5 0 0 1-6-6 19.79 19.79 0 0 1-3.07-8.67A2 2 0 0 1 4.11 2h3a2 2 0 0 1 2 1.72 12.84 12.84 0 0 0 .7 2.81 2 2 0 0 1-.45 2.11L8.09 9.91a16 16 0 0 0 6 6l1.27-1.27a2 2 0 0 1 2.11-.45 12.84 12.84 0 0 0 2.81.7A2 2 0 0 1 22 16.92z">
                                        </path>
                                    </svg></span>
                                <span class="nedd_help_text">Nedd help? Call Us :</span>
                                <a href="tel:{{ $general_settings->header_contact_number }}" class="header_quick_link">
                                    {{ $general_settings->header_contact_number }}
                                </a>
                            </li>
                            @if ($site_configurations->show_reseller_panel == 1)
                                <li>
                                    <a href="/dropshipper/login" class="header_quick_link">
                                        <i class="fa-solid fa-user"></i>
                                        Reseller Login
                                    </a>
                                </li>
                            @endif
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="header_bottom sticky_header">
        <div class="container">
            <div class="row">
                <div class="col-xxl-2 col-xl-2 col-lg-2 col-md-4 col-sm-4 col-4 order-lg-1 order-2">
                    <div class="header_logo">
                        <a href="{{ route('root') }}">
                            <img src="{{ asset('storage/' . $general_settings->logo) }}"
                                alt="{{ $general_settings->title }}">
                        </a>
                    </div>
                </div>
                <div class="col-xxl-7 col-xl-7 col-lg-7 col-md-4 col-sm-4 col-4 order-lg-2 order-1">
                    <!-- mobile device toggle start -->
                    <a class="toggle_bar d-lg-none" href="#offcanvasMenuId" data-bs-toggle="offcanvas">
                        <i class="las la-bars"></i>
                    </a>
                    <!-- mobile device toggle end -->

                    <div class="main_menu d-none d-lg-block">
                        <ul>
                            {{-- <li>
                                <a href="{{route('root')}}" class="main_menu_link">Home</a>
                            </li> --}}
                            @foreach ($categories->slice(0, 5) as $category)
                                <li>
                                    <a href="{{ route('product.category', [$category->slug]) }}" class="main_menu_link">
                                        {{ $category->name }}

                                        @if (count($category->subCategory) > 0)
                                            <i class="las la-angle-down"></i>
                                        @endif
                                    </a>
                                    @if (count($category->subCategory) > 0)
                                        <ul class="submenu">
                                            @foreach ($category->subCategory as $subCategory)
                                                <li>
                                                    <a href="{{ route('product.category', [$category->slug, $subCategory->slug]) }}"
                                                        class="main_menu_link">
                                                        {{ $subCategory->name }}
                                                        @if (count($subCategory->subSubCategory) > 0)
                                                            <i class="las la-angle-right"></i>
                                                        @endif
                                                    </a>
                                                    @if (count($subCategory->subSubCategory) > 0)
                                                        <ul class="submenu">
                                                            @foreach ($subCategory->subSubCategory as $sub_SubCategory)
                                                                <li>
                                                                    <a href="{{ route('product.category', [$category->slug, $subCategory->slug, $sub_SubCategory->slug]) }}"
                                                                        class="main_menu_link">
                                                                        {{ $sub_SubCategory->name }}
                                                                    </a>
                                                                </li>
                                                            @endforeach
                                                        </ul>
                                                    @endif
                                                </li>
                                            @endforeach
                                        </ul>
                                    @endif
                                </li>
                            @endforeach
                        </ul>
                    </div>
                </div>
                <div class="col-xxl-3 col-xl-3 col-lg-3 col-md-4 col-sm-4 col-4 order-lg-3 order-3">
                    <div class="header_icon">
                        <div class="search_icon" data-bs-toggle="offcanvas" data-bs-target="#searchOpenTop">
                            <!-- <div class="search_icon"> -->
                            <span class="search_icon_link">
                                <!-- <span class="search_icon_link" onclick="search()"> -->
                                <i class="las la-search"></i>
                            </span>
                        </div>
                        <ul class="d-none d-lg-block">
                            <li>
                                @if (auth()->guard('customer')->check())
                                    <a href="{{ route('user.dashboard') }}" class="header_icon_link">
                                        <i class="las la-user"></i>
                                    </a>
                                @else
                                    <a href="{{ route('login') }}" class="header_icon_link">
                                        <i class="las la-user"></i>
                                    </a>
                                @endif
                            </li>
                            <li>
                                <a class="header_icon_link" data-bs-toggle="offcanvas" href="#fixed_product_sticky_id">
                                    <i class="las la-shopping-basket"></i>
                                    <strong class="subTotal"></strong>
                                    <span>0</span>
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="offcanvas offcanvas_search offcanvas-top" id="searchOpenTop">
                    <!-- <div id="search_id" class="col-md-12 search_content"> -->
                    <div class="search_btn">
                        <form action="{{ route('search.products') }}" method="GET">
                            <input type="text" name="searchInput" id="searchboxinput"
                                onkeyup="searchProduct(this.value)" value="" class="search__product"
                                placeholder="">
                            <button type="submit" class="search_btn_link">
                                <i class="fa-solid fa-magnifying-glass"></i>
                            </button>
                        </form>
                        {{-- <input type="text" onkeyup="searchProduct(this.value)" placeholder="Search Products...">
                        <button type="submit" class="search_btn_link">
                            <i class="fa-solid fa-magnifying-glass"></i>
                        </button> --}}
                    </div>
                </div>
                <!-- header search item  start -->
                <div class="header_search_item_content" id="product_search" style="display: none;">
                    <div id="search_product_show" class="header_search_item">

                    </div>
                </div>
                <!-- header search item  end -->
            </div>
        </div>
    </div>

</header>
<!--============ Header Area End ============-->

<script>
    // sticky header
    window.addEventListener("scroll", function() {
        var header = this.document.querySelector("header");
        header.classList.toggle("sticky_header", window.scrollY > 0)
    })
</script>

<script>
    const texts = ['Search for something…', 'Search for other…', 'One more search'];
    const input = document.querySelector('#searchboxinput');
    const animationWorker = function(input, texts) {
        this.input = input;
        this.defaultPlaceholder = this.input.getAttribute('placeholder');
        this.texts = texts;
        this.curTextNum = 0;
        this.curPlaceholder = '';
        this.blinkCounter = 0;
        this.animationFrameId = 0;
        this.animationActive = false;
        this.input.setAttribute('placeholder', this.curPlaceholder);

        this.switch = (timeout) => {
            this.input.classList.add('imitatefocus');
            setTimeout(
                () => {
                    this.input.classList.remove('imitatefocus');
                    if (this.curTextNum == 0)
                        this.input.setAttribute('placeholder', this.defaultPlaceholder);
                    else
                        this.input.setAttribute('placeholder', this.curPlaceholder);

                    setTimeout(
                        () => {
                            this.input.setAttribute('placeholder', this.curPlaceholder);
                            if (this.animationActive)
                                this.animationFrameId = window.requestAnimationFrame(this.animate)
                        },
                        timeout);
                },
                timeout);
        }

        this.animate = () => {
            if (!this.animationActive) return;
            let curPlaceholderFullText = this.texts[this.curTextNum];
            let timeout = 100;
            if (this.curPlaceholder == curPlaceholderFullText + '|' && this.blinkCounter == 3) {
                this.blinkCounter = 0;
                this.curTextNum = (this.curTextNum >= this.texts.length - 1) ? 0 : this.curTextNum + 1;
                this.curPlaceholder = '|';
                this.switch(400);
                return;
            } else if (this.curPlaceholder == curPlaceholderFullText + '|' && this.blinkCounter < 3) {
                this.curPlaceholder = curPlaceholderFullText;
                this.blinkCounter++;
            } else if (this.curPlaceholder == curPlaceholderFullText && this.blinkCounter < 3) {
                this.curPlaceholder = this.curPlaceholder + '|';
            } else {
                this.curPlaceholder = curPlaceholderFullText
                    .split('')
                    .slice(0, this.curPlaceholder.length + 1)
                    .join('') + '|';
                timeout = 150;
            }
            this.input.setAttribute('placeholder', this.curPlaceholder);
            setTimeout(
                () => {
                    if (this.animationActive) this.animationFrameId = window.requestAnimationFrame(this
                        .animate)
                },
                timeout);
        }

        this.stop = () => {
            this.animationActive = false;
            window.cancelAnimationFrame(this.animationFrameId);
        }

        this.start = () => {
            this.animationActive = true;
            this.animationFrameId = window.requestAnimationFrame(this.animate);
            return this;
        }
    }

    document.addEventListener("DOMContentLoaded", () => {
        let aw = new animationWorker(input, texts).start();
        input.addEventListener("focus", (e) => aw.stop());
        input.addEventListener("blur", (e) => {
            aw = new animationWorker(input, texts);
            if (e.target.value == '') setTimeout(aw.start, 1000);
        });
    });
</script>
