<!--============ Header Area Start ============-->
<header class="header_area">
    <div class="header_top d-none d-md-block">
        <div class="container">
            <div class="row">
                <div class="col-xxl-6 col-xl-4 col-lg-4 col-md-4">
                    <div class="header_top_title">
                        <p>{{ $general_settings->title }}</p>
                    </div>
                </div>
                <div class="col-xxl-6 col-xl-8 col-lg-8 col-md-8">
                    <div class="header_quick">
                        <ul>
                            <li>
                                <a href="{{ route('order.tracking') }}" class="header_quick_link">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none"
                                        stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                        stroke-linejoin="round" class="feather feather-truck">
                                        <rect x="1" y="3" width="15" height="13"></rect>
                                        <polygon points="16 8 20 8 23 11 23 16 16 16 16 8"></polygon>
                                        <circle cx="5.5" cy="18.5" r="2.5"></circle>
                                        <circle cx="18.5" cy="18.5" r="2.5"></circle>
                                    </svg>
                                    <span class="mobile_hidden_text">Track your order</span>
                                </a>
                            </li>
                            <li>
                                <a href="{{ route('wish.list') }}" class="header_quick_link">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none"
                                        stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                        stroke-linejoin="round" class="feather feather-heart">
                                        <path
                                            d="M20.84 4.61a5.5 5.5 0 0 0-7.78 0L12 5.67l-1.06-1.06a5.5 5.5 0 0 0-7.78 7.78l1.06 1.06L12 21.23l7.78-7.78 1.06-1.06a5.5 5.5 0 0 0 0-7.78z">
                                        </path>
                                    </svg>
                                    <span class="mobile_hidden_text">My Wishlist</span>
                                </a>
                            </li>
                            <li>
                                @if (auth()->guard('customer')->check())
                                    <a href="{{ route('user.dashboard') }}" class="header_quick_link">
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none"
                                            stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                            stroke-linejoin="round" class="feather feather-user">
                                            <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path>
                                            <circle cx="12" cy="7" r="4"></circle>
                                        </svg>
                                        {{ Str::words(Auth::guard('customer')->user()->name, 1, '..') }}
                                    </a>
                                @else
                                    <a href="{{ route('login') }}" class="header_quick_link">
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none"
                                            stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                            stroke-linejoin="round" class="feather feather-user">
                                            <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path>
                                            <circle cx="12" cy="7" r="4"></circle>
                                        </svg>
                                        Login / Register
                                    </a>
                                @endif
                            </li>
                            @if ($site_configurations->show_reseller_panel == 1)
                                <li>
                                    <a href="/dropshipper/login" class="header_quick_link">
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none"
                                            stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                            stroke-linejoin="round" class="feather feather-user">
                                            <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path>
                                            <circle cx="12" cy="7" r="4"></circle>
                                        </svg>
                                        Reseller Login
                                    </a>
                                </li>
                            @endif
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="header_middle sticky_header">
        <div class="container">
            <div class="row">
                <div class="col-md-4 col-sm-4 col-3 d-lg-none order-1">
                    <!-- mobile device toggle start -->
                    <a class="toggle_bar d-lg-none" href="#offcanvasMenuId" data-bs-toggle="offcanvas">
                        <i class="las la-bars"></i>
                    </a>
                    <!-- mobile device toggle end -->
                </div>
                <div class="col-xxl-3 col-xl-3 col-lg-2 col-md-4 col-sm-4 col-6 order-lg-1 order-2">
                    <div class="header_logo">
                        <a href="{{ route('root') }}">
                            <img src="{{ asset('storage/' . $general_settings->logo) }}"
                                alt="{{ $general_settings->title }}">
                        </a>
                    </div>
                </div>
                <div class="col-xxl-6 col-xl-6 col-lg-7 col-md-12 col-sm-12 col-12 order-lg-2 order-4">
                    <div class="header_middle_search">
                        <form action="{{ route('search.products') }}" method="GET" id="submitSearchForm">
                            <input type="text" placeholder="Search products…" onkeyup="searchProduct(this.value)"
                                value="" id="searchboxinput">
                            <i class="las la-search" onclick="submitSearchForm()"></i>
                        </form>

                        <!-- header search item  start -->
                        <div class="header_search_item_content" id="product_search" style="display: none;">
                            <div id="search_product_show" class="header_search_item">

                            </div>
                        </div>
                        <!-- header search item  end -->
                    </div>
                </div>
                <div class="col-xxl-3 col-xl-3 col-lg-3 col-md-4 col-sm-4 col-3 order-lg-3 order-3">
                    <div class="header_icon">
                        <div class="header_call d-none d-lg-block">
                            <a href="tel:{{ $general_settings->header_contact_number }}" class="header_call_link">
                                <div class="call_icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none"
                                        stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                        stroke-linejoin="round" class="feather feather-phone">
                                        <path
                                            d="M22 16.92v3a2 2 0 0 1-2.18 2 19.79 19.79 0 0 1-8.63-3.07 19.5 19.5 0 0 1-6-6 19.79 19.79 0 0 1-3.07-8.67A2 2 0 0 1 4.11 2h3a2 2 0 0 1 2 1.72 12.84 12.84 0 0 0 .7 2.81 2 2 0 0 1-.45 2.11L8.09 9.91a16 16 0 0 0 6 6l1.27-1.27a2 2 0 0 1 2.11-.45 12.84 12.84 0 0 0 2.81.7A2 2 0 0 1 22 16.92z">
                                        </path>
                                    </svg>
                                </div>
                                <div class="call_number">
                                    <p>Call Us :</p>
                                    <strong>{{ $general_settings->header_contact_number }}</strong>
                                </div>
                            </a>
                        </div>
                        <div class="header_cart">
                            <a class="header_cart_link" data-bs-toggle="offcanvas" href="#fixed_product_sticky_id">
                                <img src="https://i.postimg.cc/Zn7BbvCw/cart-icon.png" alt="cart-icon">
                                <span class="cart_item_total">0</span>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="header_bottom">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <div class="main_menu d-none d-lg-block">
                        <ul>
                            <li>
                                <a href="{{ route('root') }}" class="main_menu_link">হোম</a>
                            </li>
                            @foreach ($categories as $category)
                                <li>
                                    <a href="{{ route('product.category', [$category->slug]) }}"
                                        class="main_menu_link">
                                        {{ $category->name }}

                                        @if (count($category->subCategory) > 0)
                                            <i class="las la-angle-down"></i>
                                        @endif
                                    </a>
                                    @if (count($category->subCategory) > 0)
                                        <ul class="submenu">
                                            @foreach ($category->subCategory as $subCategory)
                                                <li>
                                                    <a href="{{ route('product.category', [$category->slug, $subCategory->slug]) }}"
                                                        class="main_menu_link">
                                                        {{ $subCategory->name }}
                                                        @if (count($subCategory->subSubCategory) > 0)
                                                            <i class="las la-angle-right"></i>
                                                        @endif
                                                    </a>
                                                    @if (count($subCategory->subSubCategory) > 0)
                                                        <ul class="submenu">
                                                            @foreach ($subCategory->subSubCategory as $sub_SubCategory)
                                                                <li>
                                                                    <a href="{{ route('product.category', [$category->slug, $subCategory->slug, $sub_SubCategory->slug]) }}"
                                                                        class="main_menu_link">
                                                                        {{ $sub_SubCategory->name }}
                                                                    </a>
                                                                </li>
                                                            @endforeach
                                                        </ul>
                                                    @endif
                                                </li>
                                            @endforeach
                                        </ul>
                                    @endif
                                </li>
                            @endforeach
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>

</header>
<!--============ Header Area End ============-->

<script>
    // sticky header
    window.addEventListener("scroll", function() {
        var header = this.document.querySelector("header");
        header.classList.toggle("sticky_header", window.scrollY > 0)
    })
</script>

<script>
    const texts = ['Search for something…', 'Search for other…', 'One more search'];
    const input = document.querySelector('#searchboxinput');
    const animationWorker = function(input, texts) {
        this.input = input;
        this.defaultPlaceholder = this.input.getAttribute('placeholder');
        this.texts = texts;
        this.curTextNum = 0;
        this.curPlaceholder = '';
        this.blinkCounter = 0;
        this.animationFrameId = 0;
        this.animationActive = false;
        this.input.setAttribute('placeholder', this.curPlaceholder);

        this.switch = (timeout) => {
            this.input.classList.add('imitatefocus');
            setTimeout(
                () => {
                    this.input.classList.remove('imitatefocus');
                    if (this.curTextNum == 0)
                        this.input.setAttribute('placeholder', this.defaultPlaceholder);
                    else
                        this.input.setAttribute('placeholder', this.curPlaceholder);

                    setTimeout(
                        () => {
                            this.input.setAttribute('placeholder', this.curPlaceholder);
                            if (this.animationActive)
                                this.animationFrameId = window.requestAnimationFrame(this.animate)
                        },
                        timeout);
                },
                timeout);
        }

        this.animate = () => {
            if (!this.animationActive) return;
            let curPlaceholderFullText = this.texts[this.curTextNum];
            let timeout = 100;
            if (this.curPlaceholder == curPlaceholderFullText + '|' && this.blinkCounter == 3) {
                this.blinkCounter = 0;
                this.curTextNum = (this.curTextNum >= this.texts.length - 1) ? 0 : this.curTextNum + 1;
                this.curPlaceholder = '|';
                this.switch(400);
                return;
            } else if (this.curPlaceholder == curPlaceholderFullText + '|' && this.blinkCounter < 3) {
                this.curPlaceholder = curPlaceholderFullText;
                this.blinkCounter++;
            } else if (this.curPlaceholder == curPlaceholderFullText && this.blinkCounter < 3) {
                this.curPlaceholder = this.curPlaceholder + '|';
            } else {
                this.curPlaceholder = curPlaceholderFullText
                    .split('')
                    .slice(0, this.curPlaceholder.length + 1)
                    .join('') + '|';
                timeout = 150;
            }
            this.input.setAttribute('placeholder', this.curPlaceholder);
            setTimeout(
                () => {
                    if (this.animationActive) this.animationFrameId = window.requestAnimationFrame(this
                        .animate)
                },
                timeout);
        }

        this.stop = () => {
            this.animationActive = false;
            window.cancelAnimationFrame(this.animationFrameId);
        }

        this.start = () => {
            this.animationActive = true;
            this.animationFrameId = window.requestAnimationFrame(this.animate);
            return this;
        }
    }

    document.addEventListener("DOMContentLoaded", () => {
        let aw = new animationWorker(input, texts).start();
        input.addEventListener("focus", (e) => aw.stop());
        input.addEventListener("blur", (e) => {
            aw = new animationWorker(input, texts);
            if (e.target.value == '') setTimeout(aw.start, 1000);
        });
    });
</script>
<script>
    function submitSearchForm() {
        document.getElementById('submitSearchForm').submit();
    }
</script>
