<!--============ Header Area Start ============-->
<header class="header_area">
    <!-- header middle start -->
    <div class="header_middle sticky_header">
        <div class="container">
            <div class="row">
                <div class="col-xxl-3 col-xl-3 col-lg-2 d-none d-lg-block">
                    <div class="header_middle_logo">
                        <a href="{{route('root')}}">
                            <img src="{{ asset('storage/' . $general_settings->logo) }}" alt="{{$general_settings->title}}">
                        </a>
                    </div>
                </div>
                <div class="col-xxl-5 col-xl-5 col-lg-5 col-md-12 col-sm-12 col-12">

                    <!-- header mobile device start -->
                    <div class="header_mobile_device d-lg-none d-md-block">
                        <div class="header_mobile_table_cell">
                            <a class="mobile_menu_trigger">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" class="feather feather-menu"><line x1="3" y1="12" x2="21" y2="12"></line><line x1="3" y1="6" x2="21" y2="6"></line><line x1="3" y1="18" x2="21" y2="18"></line></svg>
                            </a> <!-- header mobile device toggle end -->
                            <div class="header_mobile_logo">
                                <a href="{{route('root')}}">
                                    <img src="{{ asset('storage/' . $general_settings->logo) }}" alt="logo">
                                </a>
                            </div> <!-- header mobile device logo end -->

                            <div class="header_mobile_search" onclick="search()">
                                <svg xmlns="http://www.w3.org/2000/svg" version="1.1" x="0" y="0" viewBox="0 0 612.01 612.01" style="enable-background:new 0 0 512 512" xml:space="preserve" class=""><g><path d="M606.209 578.714 448.198 423.228C489.576 378.272 515 318.817 515 253.393 514.98 113.439 399.704 0 257.493 0S.006 113.439.006 253.393s115.276 253.393 257.487 253.393c61.445 0 117.801-21.253 162.068-56.586l158.624 156.099c7.729 7.614 20.277 7.614 28.006 0a19.291 19.291 0 0 0 .018-27.585zM257.493 467.8c-120.326 0-217.869-95.993-217.869-214.407S137.167 38.986 257.493 38.986c120.327 0 217.869 95.993 217.869 214.407S377.82 467.8 257.493 467.8z" fill="currentColor" opacity="1" data-original="currentColor"></path></g></svg>
                            </div> <!-- header mobile device search end -->
                        </div>
                    </div>
                    <!-- header mobile device end -->

                    <div id="search_id" class="header_middle_search_content search_class">
                        <div class="header_middle_search">
                            <form action="{{ route('search.products') }}" method="GET">
                                <input type="text" name="searchInput" onkeyup="searchProduct(this.value)"
                                    value=""class="search__product" placeholder="Search products...">
                                <button type="submit" class="header_middle_search_link">
                                    <svg xmlns="http://www.w3.org/2000/svg" version="1.1" x="0" y="0" viewBox="0 0 612.01 612.01" style="enable-background:new 0 0 512 512" xml:space="preserve" class=""><g><path d="M606.209 578.714 448.198 423.228C489.576 378.272 515 318.817 515 253.393 514.98 113.439 399.704 0 257.493 0S.006 113.439.006 253.393s115.276 253.393 257.487 253.393c61.445 0 117.801-21.253 162.068-56.586l158.624 156.099c7.729 7.614 20.277 7.614 28.006 0a19.291 19.291 0 0 0 .018-27.585zM257.493 467.8c-120.326 0-217.869-95.993-217.869-214.407S137.167 38.986 257.493 38.986c120.327 0 217.869 95.993 217.869 214.407S377.82 467.8 257.493 467.8z" fill="currentColor" opacity="1" data-original="currentColor"></path></g></svg>
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- header search item  start -->
                    <div class="header_search_item_content" id="product_search" style="display: none;">
                        <div id="search_product_show" class="header_search_item">

                        </div>
                    </div>
                    <!-- header search item  end -->
                </div>
                <div class="col-xxl-4 col-xl-4 col-lg-5 d-none d-lg-block">
                    <div class="header_middle_table_cell">
                        <div class="header_middle_call">
                            <a class="header_middle_call_link" href="tel:{{$general_settings->header_contact_number}}">
                                <div class="header_middle_call_icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-phone"><path d="M22 16.92v3a2 2 0 0 1-2.18 2 19.79 19.79 0 0 1-8.63-3.07 19.5 19.5 0 0 1-6-6 19.79 19.79 0 0 1-3.07-8.67A2 2 0 0 1 4.11 2h3a2 2 0 0 1 2 1.72 12.84 12.84 0 0 0 .7 2.81 2 2 0 0 1-.45 2.11L8.09 9.91a16 16 0 0 0 6 6l1.27-1.27a2 2 0 0 1 2.11-.45 12.84 12.84 0 0 0 2.81.7A2 2 0 0 1 22 16.92z"></path></svg>
                                </div>
                                <div class="header_middle_cart_text">
                                    <p>{{$general_settings->header_contact_number}}</p>
                                </div>
                            </a>
                        </div>
                        <div class="header_middle_cart" data-bs-toggle="offcanvas" href="#fixed_product_sticky_id">
                            <div class="header_cart_icon">
                                <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" class="bi bi-bag" viewBox="0 0 16 16">
                                    <path d="M8 1a2.5 2.5 0 0 1 2.5 2.5V4h-5v-.5A2.5 2.5 0 0 1 8 1m3.5 3v-.5a3.5 3.5 0 1 0-7 0V4H1v10a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V4zM2 5h12v9a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1z"/>
                                </svg>
                                <span class="cart_item_total"></span>
                            </div>
                            <div class="header_middle_cart_text total_amount">0 TK</div>
                        </div>
                        <div class="header_middle_auth">
                            @if (auth()->guard('customer')->check())
                                <a href="{{ route('user.dashboard') }}" class="header_middle_auth_link">
                                    <div class="header_middle_icon">
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 490.667 490.667" xml:space="preserve"><path d="M10.667 448c5.888 0 10.667-4.779 10.667-10.667v-26.197C21.333 325.589 97.899 256 192 256s170.667 69.589 170.667 155.136v26.197c0 5.888 4.779 10.667 10.667 10.667S384 443.221 384 437.333v-26.197c0-80.533-59.051-148.48-139.413-169.579 32.128-18.389 54.08-52.629 54.08-92.224 0-58.816-47.851-106.667-106.667-106.667S85.333 90.517 85.333 149.333c0 39.595 21.952 73.835 54.08 92.224C59.051 262.656 0 330.603 0 411.136v26.197C0 443.221 4.779 448 10.667 448zm96-298.667C106.667 102.272 144.939 64 192 64s85.333 38.272 85.333 85.333-38.272 85.334-85.333 85.334-85.333-38.272-85.333-85.334z" fill="currentColor" fill="currentColor"></svg>
                                    </div>
                                    <div class="header_middle_auth_text">
                                        <p>{{ Str::words(Auth::guard('customer')->user()->name, 1, '..') }}</p>
                                    </div>
                                </a>
                            @else
                                <a href="{{ route('login') }}" class="header_middle_auth_link">
                                    <div class="header_middle_icon">
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 490.667 490.667" xml:space="preserve"><path d="M10.667 448c5.888 0 10.667-4.779 10.667-10.667v-26.197C21.333 325.589 97.899 256 192 256s170.667 69.589 170.667 155.136v26.197c0 5.888 4.779 10.667 10.667 10.667S384 443.221 384 437.333v-26.197c0-80.533-59.051-148.48-139.413-169.579 32.128-18.389 54.08-52.629 54.08-92.224 0-58.816-47.851-106.667-106.667-106.667S85.333 90.517 85.333 149.333c0 39.595 21.952 73.835 54.08 92.224C59.051 262.656 0 330.603 0 411.136v26.197C0 443.221 4.779 448 10.667 448zm96-298.667C106.667 102.272 144.939 64 192 64s85.333 38.272 85.333 85.333-38.272 85.334-85.333 85.334-85.333-38.272-85.333-85.334z" fill="currentColor" fill="currentColor"></svg>
                                    </div>
                                    <div class="header_middle_auth_text">
                                        <p>Account</p>
                                    </div>
                                </a>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- header middle end -->

        <!-- header bottom start -->
        <div class="header_bottom d-lg-none">
            <div class="container">
                <div class="row">
                    <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        <div class="menu_overlay"></div>
                        <nav class="main_menu">
                            <div class="mobile_menu_head">
                                <div class="go_back">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" class="feather feather-chevron-left"><polyline points="15 18 9 12 15 6"></polyline></svg>
                                </div>
                                <div class="current_menu_title"></div>
                                <div class="mobile_menu_close">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-x"><line x1="18" y1="6" x2="6" y2="18"></line><line x1="6" y1="6" x2="18" y2="18"></line></svg>
                                </div>
                            </div>
                            <ul>
                                @foreach ($categories as $category) 
                                    <li>
                                        <a href="{{route('product.category',[$category->slug])}}">
                                            {{$category->name}}
                                        </a>
                                        @if (count($category->subCategory) > 0)
                                            <span class="menu_icon">
                                                <i class="fas fa-angle-down"></i>
                                            </span>
                                        @endif
                                        @if (count($category->subCategory) > 0)
                                            <ul class="sub_menu">
                                                @foreach ($category->subCategory as $subCategory)
                                                    <li>
                                                        <a href="{{route('product.category',[$category->slug, $subCategory->slug])}}">
                                                            {{$subCategory->name}}
                                                        </a>
                                                        @if (count($subCategory->subSubCategory) > 0)
                                                            <span class="menu_icon">
                                                                <i class="fas fa-angle-down"></i>
                                                            </span>
                                                        @endif
                                                        @if (count($subCategory->subSubCategory) > 0)
                                                            <ul class="sub_menu">
                                                                @foreach ($subCategory->subSubCategory as $sub_SubCategory)
                                                                    <li>
                                                                        <a href="{{route('product.category',[$category->slug, $subCategory->slug, $sub_SubCategory->slug])}}">
                                                                            {{$sub_SubCategory->name}}
                                                                        </a>
                                                                    </li>
                                                                @endforeach
                                                            </ul>
                                                        @endif
                                                    </li>
                                                @endforeach
                                            </ul>
                                        @endif
                                    </li>
                                @endforeach
                            </ul>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
        <!-- header bottom end -->
</header>
<!--============ Header Area End ============-->
