<!--============ Header Area Start ============-->
<header class="header_area sticky_header">

    <!-- header top start -->
    <div class="header_top">
        <div class="container">
            <div class="row">
                <div class="col-xxl-6 col-xl-6 col-lg-6 d-none d-lg-block">
                    <div class="header_top_site_title">
                        <p>{{$general_settings->title}}</p>
                    </div>
                </div>
                <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-12">
                    <div class="header_top_list">
                        <ul>
                            <li>
                                <a href="{{ route('order.tracking') }}" class="header_top_list_link">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-truck"><rect x="1" y="3" width="15" height="13"></rect><polygon points="16 8 20 8 23 11 23 16 16 16 16 8"></polygon><circle cx="5.5" cy="18.5" r="2.5"></circle><circle cx="18.5" cy="18.5" r="2.5"></circle></svg>
                                    Order Tracking
                                </a>
                            </li>
                            <li>
                                <a href="{{ route('contact-us') }}" class="header_top_list_link">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-info"><circle cx="12" cy="12" r="10"></circle><line x1="12" y1="16" x2="12" y2="12"></line><line x1="12" y1="8" x2="12.01" y2="8"></line></svg>
                                    Contact Us
                                </a>
                            </li>
                            @if ($site_configurations->show_reseller_panel == 1)
                            <li>
                                <a href="/dropshipper/login" class="header_top_list_link">
                                    <i class="fa-solid fa-user"></i>
                                    Reseller Login
                                </a>
                            </li>
                            @endif
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- header top end -->

    <!-- header middle start -->
    <div class="header_middle ">
        <div class="container">
            <div class="row">
                <div class="col-xxl-3 col-xl-3 col-lg-2 d-none d-lg-block">
                    <div class="header_middle_logo">
                        <a href="{{route('root')}}">
                            <img src="{{ asset('storage/' . $general_settings->logo) }}" alt="{{$general_settings->title}}">
                        </a>
                    </div>
                </div>
                <div class="col-xxl-5 col-xl-5 col-lg-5 col-md-12 col-sm-12 col-12">

                    <!-- header mobile device start -->
                    <div class="header_mobile_device d-lg-none d-md-block">
                        <div class="header_mobile_table_cell">
                            <a class="header_mobile_toggle" data-bs-toggle="offcanvas" href="#offcanvasMenuId">
                                <i class="fa-solid fa-bars"></i>
                            </a> <!-- header mobile device toggle end -->
                            <div class="header_mobile_logo">
                                <a href="{{route('root')}}">
                                    <img src="{{ asset('storage/' . $general_settings->logo) }}" alt="logo">
                                </a>
                            </div> <!-- header mobile device logo end -->

                            <div class="header_mobile_search" onclick="search()">
                                <i class="fa-solid fa-magnifying-glass"></i>
                            </div> <!-- header mobile device search end -->
                        </div>
                    </div>
                    <!-- header mobile device end -->

                    <div id="search_id" class="header_middle_search_content search_class">
                        <div class="header_middle_search">

                            <form action="{{ route('search.products') }}" method="GET">
                                <input type="text" name="searchInput" id="searchboxinput" onkeyup="searchProduct(this.value)"
                                    value="" class="search__product" placeholder="" >
                                <button type="submit" class="header_middle_search_link">
                                    <i class="fa-solid fa-magnifying-glass"></i>
                                </button>
                            </form>

                            {{-- <input type="text" onkeyup="searchProduct(this.value)" value="" id="searchboxinput" class="search__product" placeholder="">
                            <button type="submit" class="header_middle_search_link">
                                <i class="fa-solid fa-magnifying-glass"></i>
                            </button> --}}
                        </div>
                    </div>

                    <!-- header search item  start -->
                    <div class="header_search_item_content" id="product_search" style="display: none;">
                        <div id="search_product_show" class="header_search_item">

                        </div>
                    </div>
                    <!-- header search item  end -->
                </div>
                <div class="col-xxl-4 col-xl-4 col-lg-5 d-none d-lg-block">
                    <div class="header_middle_table_cell">
                        <div class="header_middle_call">
                            <a href="tel:+88{{$general_settings->header_contact_number}}" class="header_middle_call_link">
                                <div class="header_middle_call_icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-phone"><path d="M22 16.92v3a2 2 0 0 1-2.18 2 19.79 19.79 0 0 1-8.63-3.07 19.5 19.5 0 0 1-6-6 19.79 19.79 0 0 1-3.07-8.67A2 2 0 0 1 4.11 2h3a2 2 0 0 1 2 1.72 12.84 12.84 0 0 0 .7 2.81 2 2 0 0 1-.45 2.11L8.09 9.91a16 16 0 0 0 6 6l1.27-1.27a2 2 0 0 1 2.11-.45 12.84 12.84 0 0 0 2.81.7A2 2 0 0 1 22 16.92z"></path></svg>
                                </div>
                                <div class="header_middle_call_text">
                                    <p>Call Us Now:</p>
                                    <span>{{$general_settings->header_contact_number}}</span>
                                </div>
                            </a>
                        </div>
                        <!-- <div class="header_middle_wishlist">
                            <a href="{{route('wish.list')}}" class="header_middle_wishlist_link">
                                <div class="header_middle_wishlist_icon">
                                    <i class="fa-regular fa-heart"></i>
                                    <span class="wish_list_count">0</span>
                                </div>
                            </a>
                        </div> -->
                        <div class="header_cart_amount">
                        <a data-bs-toggle="offcanvas" href="#fixed_product_sticky_id" class="header_middle_cart">
                            <div class="header_middle_cart_icon">
                                <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 16 16">
                                    <path fill-rule="evenodd" d="M10.854 8.146a.5.5 0 0 1 0 .708l-3 3a.5.5 0 0 1-.708 0l-1.5-1.5a.5.5 0 0 1 .708-.708L7.5 10.793l2.646-2.647a.5.5 0 0 1 .708 0"></path>
                                    <path d="M8 1a2.5 2.5 0 0 1 2.5 2.5V4h-5v-.5A2.5 2.5 0 0 1 8 1m3.5 3v-.5a3.5 3.5 0 1 0-7 0V4H1v10a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V4zM2 5h12v9a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1z"></path>
                                </svg>
                            </div>
                            <div class="header_middle_cart_text">
                                <p>Cart amount</p>
                                <span class="total_amount">0 TK</span>
                            </div>
                        </a>
                        </div>
                        <div class="header_middle_auth">
                            @if (auth()->guard('customer')->check())
                            <a href="{{ route('user.dashboard') }}" class="header_middle_auth_link">
                                <div class="header_middle_icon">
                                    <svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M12.1992 12C14.9606 12 17.1992 9.76142 17.1992 7C17.1992 4.23858 14.9606 2 12.1992 2C9.43779 2 7.19922 4.23858 7.19922 7C7.19922 9.76142 9.43779 12 12.1992 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                        <path d="M3 22C3.57038 20.0332 4.74796 18.2971 6.3644 17.0399C7.98083 15.7827 9.95335 15.0687 12 15C16.12 15 19.63 17.91 21 22" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                    </svg>
                                </div>
                                <div class="header_middle_text">
                                    <span>Hi,</span>
                                    <span>{{ Str::words(Auth::guard('customer')->user()->name, 1, '..') }}</span>
                                </div>
                            </a>
                            @else
                            <a href="{{ route('login') }}" class="header_middle_auth_link">
                                <div class="header_middle_icon">
                                    <svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M12.1992 12C14.9606 12 17.1992 9.76142 17.1992 7C17.1992 4.23858 14.9606 2 12.1992 2C9.43779 2 7.19922 4.23858 7.19922 7C7.19922 9.76142 9.43779 12 12.1992 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                        <path d="M3 22C3.57038 20.0332 4.74796 18.2971 6.3644 17.0399C7.98083 15.7827 9.95335 15.0687 12 15C16.12 15 19.63 17.91 21 22" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                    </svg>
                                </div>
                                <div class="header_middle_text">
                                    <span>Hi,</span>
                                    <span>Login/Signup</span>
                                </div>
                            </a>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- header middle end -->

    <!-- header bottom start -->
    <div class="header_bottom d-none d-lg-block">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <div class="main_menu">
                        <ul>
                            @foreach ($categories as $category)
                            <li>
                                <a href="{{route('product.category',[$category->slug])}}" class="main_menu_link">
                                    {{$category->name}}
                                    @if (count($category->subCategory) > 0)
                                    <i class="fa-solid fa-angle-down"></i>
                                    @endif
                                </a>
                                <ul class="submenu">
                                    @foreach ($category->subCategory as $subCategory)
                                    <li>
                                        <a href="{{route('product.category',[$category->slug, $subCategory->slug])}}" class="submenu_link">
                                            {{$subCategory->name}}
                                            @if (count($subCategory->subSubCategory) > 0)
                                            <i class="fa-solid fa-angle-right"></i>
                                            @endif
                                        </a>
                                        <ul class="submenu">
                                            @foreach ($subCategory->subSubCategory as $sub_SubCategory)
                                            <li>
                                                <a href="{{route('product.category',[$category->slug, $subCategory->slug, $sub_SubCategory->slug])}}" class="submenu_link">
                                                    {{$sub_SubCategory->name}}
                                                </a>
                                            </li>
                                            @endforeach

                                        </ul>
                                    </li>
                                    @endforeach

                                </ul>
                            </li>
                            @endforeach

                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- header bottom end -->

</header>
<!--============ Header Area End ============-->


<script>
    const texts = ['Search for something…', 'Search for other…', 'One more search'];
    const input = document.querySelector('#searchboxinput');
    const animationWorker = function(input, texts) {
        this.input = input;
        this.defaultPlaceholder = this.input.getAttribute('placeholder');
        this.texts = texts;
        this.curTextNum = 0;
        this.curPlaceholder = '';
        this.blinkCounter = 0;
        this.animationFrameId = 0;
        this.animationActive = false;
        this.input.setAttribute('placeholder', this.curPlaceholder);

        this.switch = (timeout) => {
            this.input.classList.add('imitatefocus');
            setTimeout(
                () => {
                    this.input.classList.remove('imitatefocus');
                    if (this.curTextNum == 0)
                        this.input.setAttribute('placeholder', this.defaultPlaceholder);
                    else
                        this.input.setAttribute('placeholder', this.curPlaceholder);

                    setTimeout(
                        () => {
                            this.input.setAttribute('placeholder', this.curPlaceholder);
                            if (this.animationActive)
                                this.animationFrameId = window.requestAnimationFrame(this.animate)
                        },
                        timeout);
                },
                timeout);
        }

        this.animate = () => {
            if (!this.animationActive) return;
            let curPlaceholderFullText = this.texts[this.curTextNum];
            let timeout = 100;
            if (this.curPlaceholder == curPlaceholderFullText + '|' && this.blinkCounter == 3) {
                this.blinkCounter = 0;
                this.curTextNum = (this.curTextNum >= this.texts.length - 1) ? 0 : this.curTextNum + 1;
                this.curPlaceholder = '|';
                this.switch(400);
                return;
            } else if (this.curPlaceholder == curPlaceholderFullText + '|' && this.blinkCounter < 3) {
                this.curPlaceholder = curPlaceholderFullText;
                this.blinkCounter++;
            } else if (this.curPlaceholder == curPlaceholderFullText && this.blinkCounter < 3) {
                this.curPlaceholder = this.curPlaceholder + '|';
            } else {
                this.curPlaceholder = curPlaceholderFullText
                    .split('')
                    .slice(0, this.curPlaceholder.length + 1)
                    .join('') + '|';
                timeout = 150;
            }
            this.input.setAttribute('placeholder', this.curPlaceholder);
            setTimeout(
                () => {
                    if (this.animationActive) this.animationFrameId = window.requestAnimationFrame(this.animate)
                },
                timeout);
        }

        this.stop = () => {
            this.animationActive = false;
            window.cancelAnimationFrame(this.animationFrameId);
        }

        this.start = () => {
            this.animationActive = true;
            this.animationFrameId = window.requestAnimationFrame(this.animate);
            return this;
        }
    }

    document.addEventListener("DOMContentLoaded", () => {
        let aw = new animationWorker(input, texts).start();
        input.addEventListener("focus", (e) => aw.stop());
        input.addEventListener("blur", (e) => {
            aw = new animationWorker(input, texts);
            if (e.target.value == '') setTimeout(aw.start, 1000);
        });
    });
</script>