<?php
 $merchant = null;
 if (session()->has('merchant')) {
     $merchant = session()->get('merchant');
 }
 ?>
<aside class="main-sidebar">
    <!-- sidebar: style can be found in sidebar.less -->
    <section class="sidebar">
        <!-- Sidebar user panel -->
        <div class="user-panel" style="border-bottom:1px solid #ddd;">

            <div class="pull-left image">
                @if ($merchant != null && !empty($merchant->image))
                <img src="{{ asset('storage/' . $merchant->image) }}" class="img-circle" alt="User Image">
                @else
                <img src="{{ asset('merchant/dist/img/user2-160x160.jpg') }}" class="img-circle" alt="User Image">
                @endif
            </div>
            <div class="pull-left info" style="top:1px;">
                @if ($merchant != null)
                <h4 style="color: #000;">{{ explode(' ', trim($merchant->name))[0] }}</h4>
                @endif
                <a style="color: black" href="#"><i class="fa fa-circle text-success"></i> Online</a>
                <br>
            </div>
        </div>

        <div class="main_menu">
            <ul class="sidebar-menu" data-widget="tree">

                <li class="treeview">
                    <a href="#">
                        <svg stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"
                            xmlns="http://www.w3.org/2000/svg" fill="none">
                            <path
                                d="M4 5a1 1 0 0 1 1-1h4a1 1 0 0 1 1 1v5a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1V5ZM14 5a1 1 0 0 1 1-1h4a1 1 0 0 1 1 1v2a1 1 0 0 1-1 1h-4a1 1 0 0 1-1-1V5ZM4 16a1 1 0 0 1 1-1h4a1 1 0 0 1 1 1v3a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1v-3ZM14 13a1 1 0 0 1 1-1h4a1 1 0 0 1 1 1v6a1 1 0 0 1-1 1h-4a1 1 0 0 1-1-1v-6Z" />
                        </svg>
                        <span>
                            <router-link :to="{name:'merchant_dashboard'}">Dashboard</router-link>
                        </span>
                    </a>
                </li>
                <li class="treeview">
                    <router-link :to="{ name: 'merchant_order'}">
                        <svg width="24" height="24" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 33.559 33.559">
                            <path id="Path_62" data-name="Path 62"
                                d="M153.79,252.12a.984.984,0,0,1-.983-.983.983.983,0,0,0-1.966,0,2.954,2.954,0,0,0,1.977,2.784v.861a.983.983,0,0,0,1.966,0v-.868a2.949,2.949,0,0,0-.994-5.726.983.983,0,1,1,.983-.983.983.983,0,1,0,1.966,0,2.955,2.955,0,0,0-1.956-2.777v-1.444a.983.983,0,1,0-1.966,0v1.437a2.949,2.949,0,0,0,.973,5.734.983.983,0,1,1,0,1.966Zm0,0"
                                transform="translate(-140.954 -226.138)" fill="#061237"></path>
                            <path id="Path_63" data-name="Path 63"
                                d="M4.007,31.953c2.046,1.1,4.855,1.606,8.839,1.606a21.711,21.711,0,0,0,7.578-1.05,2.944,2.944,0,0,0,2.254,1.05h7.931a2.948,2.948,0,0,0,2.2-4.916,2.942,2.942,0,0,0,0-3.933,2.942,2.942,0,0,0,0-3.933,2.948,2.948,0,0,0-2.2-4.916H22.678c-.1,0-.19,0-.284.014a13.464,13.464,0,0,0-3.417-2.966,2.946,2.946,0,0,0-.936-4.629L19.68,3.255a.983.983,0,0,0-.935-1.288H15.627a2.949,2.949,0,0,0-5.562,0H6.947a.983.983,0,0,0-.935,1.288L7.652,8.281a2.946,2.946,0,0,0-.935,4.631A14.024,14.024,0,0,0,0,24.711c0,3.382,1.348,5.819,4.007,7.243Zm27.585-9.209a.984.984,0,0,1-.983.983H22.678a.983.983,0,0,1,0-1.966h7.931A.984.984,0,0,1,31.592,22.744Zm0,3.933a.984.984,0,0,1-.983.983H22.678a.983.983,0,0,1,0-1.966h7.931A.984.984,0,0,1,31.592,26.677Zm-.983,4.916H22.678a.983.983,0,0,1,0-1.966h7.931a.983.983,0,0,1,0,1.966Zm.983-12.781a.984.984,0,0,1-.983.983H22.678a.983.983,0,0,1,0-1.966h7.931A.984.984,0,0,1,31.592,18.811ZM16.751,11.929H8.914a.983.983,0,0,1,0-1.966h7.872a.983.983,0,0,1,0,1.966h-.028Zm-5.871-8a.983.983,0,0,0,.983-.983.983.983,0,0,1,1.966,0V4.916a.983.983,0,0,0,1.966,0V3.933h1.595L16.066,8H9.627L8.3,3.933ZM9.106,13.9h7.478a11.111,11.111,0,0,1,3.977,2.865,2.942,2.942,0,0,0-.079,4.017,2.942,2.942,0,0,0,0,3.933,2.942,2.942,0,0,0,0,3.933,2.938,2.938,0,0,0-.754,1.966c0,.02,0,.04,0,.06a19.87,19.87,0,0,1-6.884.923c-3.648,0-6.162-.436-7.911-1.373-2.026-1.085-2.969-2.835-2.969-5.509A11.929,11.929,0,0,1,9.106,13.9Zm0,0"
                                fill="#061237"></path>
                        </svg>
                        <span>Order</span>
                    </router-link>
                </li>

                <li class="treeview">
                    <a href="#">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"
                            stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                            class="feather feather-archive">
                            <polyline points="21 8 21 21 3 21 3 8"></polyline>
                            <rect x="1" y="3" width="22" height="5"></rect>
                            <line x1="10" y1="12" x2="14" y2="12"></line>
                        </svg>
                        <span>Products</span>
                        <span class="pull-right-container">
                            <i class="fa fa-angle-down pull-right"></i>
                        </span>
                    </a>


                    <ul class="treeview-menu">
                        <li>
                            <router-link :to="{ name : 'merchant_product_add'}"> Add
                            </router-link>
                        </li>
                        <li>
                            <router-link :to="{ name : 'merchant_product_menage'}"> Manage
                            </router-link>
                        </li>
                    </ul>
                </li>




                  <li class="treeview">

                    <a href="#">
                        <svg stroke="currentColor" fill="currentColor" stroke-width="0" viewBox="0 0 256 256" xmlns="http://www.w3.org/2000/svg">
                            <path d="M224,64l-12.16,66.86A16,16,0,0,1,196.1,144H70.55L56,64Z" opacity="0.2"></path>
                            <path d="M230.14,58.87A8,8,0,0,0,224,56H62.68L56.6,22.57A8,8,0,0,0,48.73,16H24a8,8,0,0,0,0,16h18L67.56,172.29a24,24,0,0,0,5.33,11.27,28,28,0,1,0,44.4,8.44h45.42A27.75,27.75,0,0,0,160,204a28,28,0,1,0,28-28H91.17a8,8,0,0,1-7.87-6.57L80.13,152h116a24,24,0,0,0,23.61-19.71l12.16-66.86A8,8,0,0,0,230.14,58.87ZM104,204a12,12,0,1,1-12-12A12,12,0,0,1,104,204Zm96,0a12,12,0,1,1-12-12A12,12,0,0,1,200,204Zm4-74.57A8,8,0,0,1,196.1,136H77.22L65.59,72H214.41Z"></path>
                        </svg>
                        <span>Account</span>
                        <span class="pull-right-container">
                            <i class="fa fa-angle-down pull-right"></i>
                        </span>
                    </a>


                    <ul class="treeview-menu">
                        <li class="treeview">
                            <router-link :to="{ name: 'merchant_cashbook_income' }"> Income
                            </router-link>
                        </li>

                        <li class="treeview">
                            <router-link :to="{ name: 'merchant_cashbook_pay_off' }"> Expense
                            </router-link>
                        </li>

                        <li class="treeview">
                            <router-link :to="{ name: 'merchant_payment_withdraw_history' }"> Withdraw History </router-link>
                        </li>


                    </ul>
                </li>


                {{-- <li class="treeview">
                    <a href="#">

                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                            <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                            <path d="M7 10l5 -6l5 6"></path>
                            <path d="M21 10l-2 8a2 2.5 0 0 1 -2 2h-10a2 2.5 0 0 1 -2 -2l-2 -8z"></path>
                            <path d="M12 15m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"></path>
                        </svg>


                        <span>Payment</span>
                        <span class="pull-right-container">
                            <i class="fa fa-angle-down pull-right"></i>
                        </span>
                    </a>
                    <ul class="treeview-menu">
                        <li>
                        <router-link :to="{ name: 'reseller_bank_account' }">Bank Account</router-link>
                        </li>
                        <li>
                        <router-link :to="{ name: 'reseller_mobile_banking' }">Mobile Bank</router-link>
                        </li>
                    </ul>
                </li> --}}


               


                <li class="treeview">
                    <a href="#">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"
                            stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                            class="feather feather-user">
                            <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2" />
                            <circle cx="12" cy="7" r="4" />
                        </svg>
                        <span> Profile</span>

                        <span class="pull-right-container">
                            <i class="fa fa-angle-down pull-right"></i>
                        </span>
                    </a>
                    <ul class="treeview-menu">
                        {{-- <li> <router-link  :to="{ name: 'merchant_profile'}"  > <i class="fa fa-eye"></i> profile</router-link></li> --}}
                        <li>
                            <router-link :to="{ name: 'merchant_profile_edit' }">
                                edit profile info
                            </router-link>
                        </li>
                        {{-- <li> <router-link  :to="{ name: 'merchant_contact'}"  > 
                           Phone </router-link></li> --}}
                    </ul>
                </li>



            </ul>
        </div>
    </section>
    <!-- /.sidebar -->
</aside>