<!doctype html>
<html lang="en">

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0-beta1/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-giJF6kkoqNQ00vy+HMDP7azOuL0xtbfIcaT9wjKHr8RbDVddVHyTfAAsrekwKmP1" crossorigin="anonymous">
    <link href="https://stackpath.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css" rel="stylesheet">
    

    <title>payment summary </title>
    <style>
        body {
            margin-top: 20px;
        }

        * {
            margin: 0;
            padding: 0;
        }



        table {
            border: 1px solid #000;
            padding: 10px 10px;
        }

        td {
            border: 1px solid #ddd;
            padding: 5px 5px;
        }


        .address {
            line-height: 0.4;
            text-align: center;
        }

        .logo {
            font-size: 32px;
            font-weight: bolder;
            margin-bottom: 0px;
        }

        .p-h {
            text-align: center;
            text-transform: uppercase;
            font-weight: bold;
            font-size: 16px;
        }

        
        th {
            border: 1px solid #000;
            padding: 2px;
        }
        @media print {
            #print {
                display: none;
            }

        }


        .btn-pr {
            text-align: right;
            display: block;
            position: fixed;
            right: 0;
            top: 280px;
        }

        .btn-pr button {
            height: 50px;
        }

        p{
            line-height: 25px;
        }


    </style>
</head>

<body>
 
    <div class="container">
        <div class="row">
            <div class="btn-pr">
                <button class="btn btn-success text-center print-button" onclick="allPrint()" id="print"><i class="fa fa-print"></i></button>
            </div>
            <div class="address">
                <p class="logo"> <img src="{{ asset('storage/' . $company_info->logo) }}" alt=""> </p>
                <p class="address_line">
                    {!! $company_info->invoice_address_details !!}
                </p>
            </div>

            <div class="col-lg-12">
                <p class="p-h">delivered order list</p>
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Invoice</th>
                            <th>Status</th>
                            <th>COD Amount</th>
                            <th>Collected Amount</th>
                            <th>Advance</th>
                            <th>Profit</th>
                            <th>Shipping Change</th>
                            <th>Shipping Adjust</th>
                            <th>Packaging Charge</th>
                            <th>COD Charge</th>
                            <th>Total Payable</th>
                            <th>Payment Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($transaction_details as $k => $item)
                            <tr>
                                <td>{{ $k + 1 }}</td>
                                <td>
                                    <p>{{ $item->order->invoice_no }} </p>
                                </td>
                                <td>
                                    {{$item->order->status == 5 ? "Delivered" : "Return" }}
                                </td>
                                <td>
                                    {{
                                        ($item->order->total + $item->order->shipping_cost)
                                    }}
                                </td>
                                <td>
                                    {{ $item->order->paid }}
                                </td>
                                <td>
                                    {{ $item->order->advance_paid }}
                                </td>
                                <td>
                                    @if ($item->order->status == 5)
                                        {{ $item->order->profit}}
                                    @else
                                        <s>
                                            {{ $item->order->profit}}
                                        </s>
                                    @endif
                                </td>
                                <td>
                                    {{ $item->order->regular_shipping_cost }}
                                </td>

                                <td>
                                    {{  $item->order->shipping_cost -  $item->order->regular_shipping_cost }}
                                </td>

                                <td>
                                    {{ $item->order->packaging_charge }}
                                </td>
                                <td>{{ $item->order->cod_charge }}</td>

                                <td>
                                    @if ($item->order->status == 5) 
                                        {{ $item->order->profit - ($item->order->advance_paid + $item->order->packaging_charge + $item->order->cod_charge) }}
                                    @else
                                    -  {{ ($item->order->regular_shipping_cost + $item->order->packaging_charge + $item->order->return_charge) - ($item->order->paid - $item->order->advance_paid)}}  <strong>(Charge)</strong>
                                    @endif
                                </td>




                                <td>
                                    {{ ($item->order->is_profit_paid) == 1 ? "Setteld" : "" }}
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
            </div>

        </div>
    </div>


    <script>
        function allPrint() {
            window.print();
        };

        window.addEventListener('DOMContentLoaded', (event) => {
            window.print();
        });
    </script>
    

</body>

</html>
