@extends('shop.master')
@section('title', 'Home')
@section('meta_title', $resellers->meta_title)
@section('meta_description', $resellers->meta_description)
@section('meta_key', $resellers->meta_key)
@section('meta_content', $resellers->meta_content)
@section('content')

<!--============ Banner Area Start ============-->
<div class="banner_area section_padding_bottom">
    <div class="container">
        <div class="row">
            <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                <div class="slider_banner_active owl-carousel">
                    @foreach ($sliders as $slider)
                    <div class="slider_banner_item">
                        <a href="{{ $slider->url }}" target="_blank">
                            <img src="{{ asset('storage/' . $slider->image) }}" alt="{{ $slider->url }}">
                        </a>
                    </div>
                    @endforeach

                </div>
            </div>
        </div>
    </div>
</div>
<!--============ Banner Area End ============-->




<!--====================== Nav And Banner Area Start ===========================-->

<!--====================== Nav And Banner Area End =============================-->

<!--============ Category Area Start ============-->
<section class="category_area mb-lg-3 -mb-3">
    <div class="container">
        <div class="row">
            <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                <div class="section_title">
                    <h2>Category</h2>
                </div>
            </div>
        </div>
    </div>
    <div class="container mt-4">
        <div class="row">
            <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                <div class="category_active owl-carousel">
                    @foreach ($top_section_categories as $category)
                    <div class="category_item">
                        <a href="{{ route('shop.product.category', [$resellers->username,$category->slug]) }}" class="category_item_link">
                            <div class="category_image">
                                <img src="{{ asset('storage/' . $category->icon_image) }}"
                                    alt="{{ $category->name }}">
                            </div>
                            <div class="category_name">
                                <p>{{ $category->name }}</p>
                            </div>
                            <div class="category_item_count">
                                <p>{{ $category->product_count }} Items</p>
                            </div>
                        </a>
                    </div>
                    @endforeach

                </div>
            </div>
        </div>
    </div>
</section>
<!--============ Category Area End ============-->







{{-- <!--============ New Arrival Products start ============-->
    <section class="new_arrival_area section_padding_bottom">
        <div class="container">
            <div class="section_title">
                <h2>New Arrival Products</h2>
            </div>
        </div>
        <div class="container mt-4">
            <div class="new_arrival_product owl-carousel">
                @foreach ($new_arrival_products as $product)
                    @include('shop.components.product_content', [
                        'product' => $product,
                        'resellers' => $resellers,
                    ])
                @endforeach
            </div>

    </section>
    ============ New Arrival Products End ============


    <!--============ Top Selling Products start ============-->
    <section class="topSelling_area section_padding_bottom">
        <div class="container">
            <div class="section_title">
                <h2>Top Selling Products</h2>
            </div>
        </div>
        <div class="container mt-4">
            <div class="top_selling_product owl-carousel">
                @foreach ($top_selling_products as $product)
                    @include('shop.components.product_content', [
                        'product' => $product,
                        'resellers' => $resellers,
                    ])
                @endforeach
            </div>

    </section>
    <!--============ Top Selling Products End ============--> --}}




<!--============ Category Wise Multiple Product Area Start ============-->
<div id="shop_loadmore_category_product">
</div>
<!--============ Category Wise Multiple Product Area End ============-->


<!--================Loading Spinner Start==========================-->
<div id="spinner" style=" display: none;text-align: center;">
    <img src="{{ asset('frontend/images/spinner/200w.gif') }}" alt="Loading...">
</div>
<!--================Loading Spinner end==========================-->

<!--============ Service Area Start ============-->
<section class="service_area section_padding_bottom d-none d-lg-block">
    <div class="container">
        <div class="row gy-4">
            <div class="col-xxl-3 col-xl-3 col-lg-3 col-md-6">
                <div class="service_item">
                    <div class="service_icon">
                        <i class="fa-solid fa-thumbs-up"></i>
                    </div>
                    <div class="service_title">
                        <h4>High-quality Goods</h4>
                    </div>
                    <div class="service_description">
                        <p>Enjoy top quality items for less</p>
                    </div>
                </div>
            </div>
            <div class="col-xxl-3 col-xl-3 col-lg-3 col-md-6">
                <div class="service_item">
                    <div class="service_icon">
                        <i class="fa-solid fa-headset"></i>
                    </div>
                    <div class="service_title">
                        <h4>24/7 Live chat</h4>
                    </div>
                    <div class="service_description">
                        <p>Get instant assistance whenever you need it</p>
                    </div>
                </div>
            </div>
            <div class="col-xxl-3 col-xl-3 col-lg-3 col-md-6">
                <div class="service_item">
                    <div class="service_icon">
                        <i class="fa-solid fa-truck"></i>
                    </div>
                    <div class="service_title">
                        <h4>Express Shipping</h4>
                    </div>
                    <div class="service_description">
                        <p>Fast & reliable delivery options</p>
                    </div>
                </div>
            </div>
            <div class="col-xxl-3 col-xl-3 col-lg-3 col-md-6">
                <div class="service_item">
                    <div class="service_icon">
                        <i class="fa fa-credit-card"></i>
                    </div>
                    <div class="service_title">
                        <h4>Secure Payment</h4>
                    </div>
                    <div class="service_description">
                        <p>Multiple safe payment methods</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!--============ Service Area End ============-->





@endsection

@section('scripts')
<script>
    var isLoading = false;
    //================load data========================
    function loadData() {
        console.log('loading....');
        isLoading = true; // Set loading flag to true
        $('#spinner').show();

        var data = {
            page: 1,
            limit: 2
        };

        $.ajax({
            url: "{{ route('shop.load.more.category.product') }}",
            type: 'POST',
            dataType: 'json',
            data: {
                page: data.page,
                limit: data.limit
            },
            success: function(res) {
                $('#shop_loadmore_category_product').append(res.data);
                isLoading = false;
                $('#spinner').hide();
            },
            error: function(xhr, status, error) {
                console.error(error);
                isLoading = false;
            }
        });
    }



    //==========================load more data===========================
    $(function() {
        loadData();

        isLoading = true; // Set loading flag to true
        $('#spinner').show();

        var data = {
            page: 2,
            limit: 2
        };

        var obj = $(document).loadMore({
            loadType: 'auto',
            url: "{{ route('shop.load.more.category.product') }}",
            dataType: 'json',
            type: 'post',
            scrollBottom: 700,
            data: {
                page: data.page,
                limit: data.limit
            },
            success: function(res) {
                if (res.category_length == 0) {
                    this.ajaxSwitch = false;
                }
                data.page += 1;
                obj.updatePram('data', data);
                render(res.data);

                isLoading = false;
                $('#spinner').hide();
            }
        });

        function render(data) {
            $("#shop_loadmore_category_product").append(data);
        }


    });
</script>
@endsection