@extends('shop.master')
@section('title','Check Out')
@section('content')
    <!--============ Checkout Area Start ============-->
    <section class="checkout_area section_padding">
       
            <div class="container">
                <div class="row gy-4">
                    <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-12 col-12">
                        <div class="checkout_form">
                            <form id="order_form">
                                <div class="checkout_form_title">
                                    <h3>Please Order Now</h3>
                                </div>
                                <div class="checkout_form_group">
                                    <label>Full Name</label>
                                    <input type="text" name="name" value="{{old('name')}}"  placeholder="Your Name">
                                    @error('name')
                                        <span style="color:red">{{$message}}</span>
                                    @enderror
                                </div>
                                <div class="checkout_form_group">
                                    <label>Mobile Number</label>
                                    <input type="text"  name="mobile_no" value="{{old('mobile_no')}}" placeholder="01xxxxxxxxx">
                                    @error('mobile_no')
                                        <span style="color:red">{{$message}}</span>
                                    @enderror
                                </div>
                                <div class="checkout_form_group">
                                    <label>Your Area</label>
                                    <select id="select_area"  name="shipping_charge_id" class="checkout_form_select">
                                        <option value="">--Select Your Area--</option>
                                        @foreach ($delivery_charges as $delivery_charge)
                                            <option value="{{$delivery_charge->id}}" id="{{$delivery_charge->id}}"   >{{$delivery_charge->name}}</option>
                                        @endforeach    
                                    </select>
                                    @error('shipping_charge_id')
                                        <span style="color:red">{{$message}}</span>
                                    @enderror
                                </div>
                                <div class="checkout_form_group">
                                    <label>Full Address</label>
                                    <textarea name="address"  placeholder="Village,union,thana,district">{{ old('address') }}</textarea>
                                    @error('address')
                                        <span style="color:red">{{$message}}</span>
                                    @enderror
                                </div>
                                <input type="hidden" value="{{$resellers->id}}" name="reseller_id">
                                <div class="checkout_form_btn">
                                    <button  id="order_form_submit" class="checkout_form_btn_link">Order Submit</button>
                                </div>
                            </form>
                        </div>
                    </div>
                    <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-12 col-12">
                        <div class="checkout_order_summary">
                            <div class="order_summary_title">
                                <h3>Order Summary</h3>
                            </div>
                            <div class="table-responsive order_summary_table">
                                <table class="table ">
                                    <thead>
                                        <tr>
                                            <th class="checkout_product_td_left">Product</th>
                                            <th>Quantity</th>
                                            <th>Price</th>
                                            <th class="checkout_product_th_total_price">Total Price</th>
                                            <th class="checkout_product_td_right">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody id="check_out_carts">
                                    </tbody>
                                </table>
                            </div>
                            <div id="order_summary">
                                
                            </div>
                            <div class="apply_coupon_group">
                                <label>Apply Coupon Here</label>
                                <div class="apply_coupon_item">
                                    <input type="text" id="coupon_name" value="" name="coupon_name">
                                    <button id="coupon_apply" class="apply_coupon_item_link">Apply</button>
                                </div>
                                <span id="coupon_valid" style="color: green;display:none">Congratulations. This Coupon is Valid.</span>
                                <span id="coupon_invalid" style="color: red;display:none">Oops Sorry!. This Coupon is Invalid.</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        
    </section>
    <!--============ Checkout Area End ============-->

@endsection

@section('scripts')
    <script>
        document.addEventListener('DOMContentLoaded', function() {
        // Code to execute when the DOM is fully loaded
        function handleWindowLoad() {
            console.log('Window loading has ended.');
            gtmCartItemsEvent('begin_checkout');
            window.removeEventListener('load', handleWindowLoad);
        }

        window.addEventListener('load', handleWindowLoad, { once: true });

        // Other JavaScript functionality
    });
    </script>
@endsection