@extends('shop.master')
@section('title','Products')
@section('content')
       <!--============ Breadcrumb Area Start ============-->
       <div class="breadcrumb_area section_top_space">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-12">
                    <div class="_breadcrumb">
                        <ul>
                            <li>
                                <a href="{{route('shop.index', $resellers->username)}}" class="breadcrumb_link">
                                    <i class="fa-solid fa-house-chimney"></i>
                                </a>
                            </li>
                            <li>
                                <a href="{{route('shop.product.category',[$resellers->username, $brand->slug])}}" class="breadcrumb_link">
                                   {{$brand->name}}
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--============ Breadcrumb Area End ============-->

    <!--============ Shop Category Area Start ============-->
    <div class="shop_category_area section_top_space">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-12">
                    <div class="shop_category">
                        <ul>
                            @foreach ($brands as $brand)
                                <li>
                                    <a href="{{route('shop.product.brand',[$resellers->username, $brand->slug])}}" class="shop_category_link">{{$brand->name}}</a>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--============ Shop Category Area End ============-->

    <!--============ Shop Area Start ============-->
    <div class="shop_area section_padding_bottom section_top_space">
        <div class="container">
            <!-------------------show load product---------------->
            <div class="row gy-3 gx-3">
                @foreach ($brand_products as $product)
                    <div class="col-xxl-2 col-xl-2 col-lg-3 col-md-4 col-sm-4 col-6">
                        <div class="product_card">
                            <div class="product_image">
                                <a href="{{ route('reseller.single.product', [$resellers->username, $product->slug]) }}" id="{{$product->id}}" onclick="gtmEvent(this.id,'view_item',1)">
                                        <img src="{{ asset('storage/' . $product->thumbnail_img) }}" alt="{{$product->name}}">
                                </a>
                            </div>
                            <div class="product_content">
                                <div class="product_name"  >
                                    <a href="{{ route('reseller.single.product', [$resellers->username, $product->slug]) }}" class="product_name_link" id="{{$product->id}}" onclick="gtmEvent(this.id,'view_item',1)">{{$product->name}}</a>
                                </div>
                                <div class="product_price">
                                    <span class="product_new_price">{{$product->reselling_price}} TK</span>
                                </div>
                                <div class="product_btn">
                                    <a href="{{ route('reseller.single.product', [$resellers->username, $product->slug]) }}" class="product_btn_link" id="{{$product->id}}" onclick="gtmEvent(this.id,'view_item',1)">Order Now</a>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
                
            </div>
        </div>
    </div>
    <!--============ Shop Area End ============-->

    
    <!--================Loading Spinner Start==========================-->
    <div id="spinner" style=" display: none;text-align: center;">
        <img src="{{asset('frontend/images/spinner/200w.gif')}}" alt="Loading...">
    </div>
     <!--================Loading Spinner end==========================-->


@endsection
