<?php

use App\Http\Controllers\Admin\OrderController;
use Illuminate\Support\Facades\Route;


Route::group(['namespace' => 'Admin'], function () {
    Route::get('api/get/configuration/info', 'GeneralSettingController@get_configuration_info');
    Route::post('api/edit/configuration/info', 'GeneralSettingController@edit_configuration_info');
    Route::get('api/download/db', 'GeneralSettingController@exportDB');
    Route::get('api/clean/db', 'PageInfoController@cleanDB');
    Route::get('api/get/template', 'GeneralSettingController@templates');
    Route::post('api/verify-facebook-pixel', 'GeneralSettingController@verifyFacebookPixel');
    Route::get('category/wise/subCategory/{id}', 'CategoryController@categoryWiseSubCategory');
    Route::get('subCategory/wise/subSubCategory/{id}', 'SubCategoryController@subCategoryWiseSubCategory');
    Route::get('attribute/wise/variant/{id}', 'AttributeAndVariantController@attributeWiseVariant');
    Route::get('api/common/data/fetch', 'OthersController@requestedTableData');
    Route::post('api/verify/site/config', 'OthersController@verifyConfig');
    Route::get('api/check/remember/token', 'OthersController@getRememberToken');
    Route::post('/admin/store/login', 'LoginController@login');
    Route::get('/api/remove', 'LoginController@deleteZip');
    Route::get('/api/check/authenticate', 'LoginController@checkAuthenticate');
    Route::post('/login/super/admin/dashboard', 'LoginController@superAdminLogin');
});

Route::get('admin/api/income/records', 'Admin\ProductController@incomeRecords');
Route::get('admin/download-income-records', 'Admin\ProductController@downloadCSV');
Route::group(
    [
        'middleware' => 'admin',
        'namespace' => 'Admin',
        //'prefix' => 'backend/'
    ],
    function () {

        // ->middleware(['permission:category-edit']);
        //start dashboard route
        Route::get('dashboard/welcome', 'DashboardController@dashboard');
        Route::get('api/district-wise/order/report', 'DashboardController@districtWiseOrder');
        Route::get('api/get/accounts/data', 'DashboardController@getAccounts');
        Route::get(
            'api/get/order/crate/analysis/and/other/report',
            'DashboardController@getAnalysisData'
        );

        //started user
        Route::get('list/user/all', 'UserController@getUser');
        Route::get('user/search/{data}', 'UserController@search_user');
        Route::get('api/export/users', 'UserController@export_users');
        Route::get('deactive/user/{id}', 'UserController@deActiveUser');
        Route::get('active/user/{id}', 'UserController@activeUser');
        //end user
        //send message url is here
        Route::post('api/send/message/to/customer', 'MessageController@send_message');
        //route for display subscriber
        Route::get('api/display/subscribers', 'OthersController@subscribers');
        Route::get('api/subscriber/search/{data}', 'OthersController@search_subscribers');
        Route::get('api/subscriber/remove/{id}', 'OthersController@remove_subscriber');
        Route::get('api/subscriber/exports', 'OthersController@export_subscriber');
        //route for contact user message dispaly
        Route::get('api/display/contacts', 'OthersController@contact_message');
        Route::get('api/get/contacted/customer/{id}', 'OthersController@get_contacted_customer');
        Route::get('api/contacted/customer/search/{data}', 'OthersController@search_contacted_customer');
        Route::get('api/delete/message/{id}', 'OthersController@deleteCustomerMessage');
        Route::get('/api/get/city/wise/redx/zone/{id}', 'OthersController@cityWiseRedxZone');



        Route::get('/api/customer/statuses', 'OthersController@getCustomerStatuses');
        // start team route here 
        Route::get('team/members/list', 'TeamController@index');
        Route::post('team/members/add', 'TeamController@addTeamMember');
        Route::get('team/members/edit/{id}', 'TeamController@getEditTeamMember');
        Route::post('team/members/update/{id}', 'TeamController@updateTeamMember');
        Route::get('team/members/trash/{id}', 'TeamController@destroyTeamMember');
        Route::get('team/members/active/{id}', 'TeamController@activeTeamMember');
        Route::get('team/members/deactive/{id}', 'TeamController@deactiveTeamMember');
        Route::get('api/team/members/search/{data}', 'TeamController@search_team_member');
        Route::get('api/member/salary/list/{id}', 'TeamController@salary');
        Route::get('api/member/salary/list/{id}/{month}', 'TeamController@salaryDetails');
        Route::get('/api/employee/salary/paid', 'TeamController@paidSalary');
        Route::get('/api/salary/edit/{id}', 'TeamController@editSalary');
        // end team route her
        //start account  route here....
        Route::get('api/account/purpose/list', 'AccountController@get_purpose_list');
        Route::post('api/account/purpose/add', 'AccountController@add_purpose');
        Route::get('api/account/purpose/edit/{id}', 'AccountController@get_edit_purpose');
        Route::post('api/account/purpose/update/{id}', 'AccountController@update_purpose');
        // end  account route here

        //start merchant route
        Route::get('api/merchant/list', 'MerchantController@index');
        Route::post('api/merchant/add', 'MerchantController@addMerchant');
        Route::get('api/merchant/edit/{id}', 'MerchantController@getEditMerchant');
        Route::post('api/merchant/update/{id}', 'MerchantController@updateMerchant');
        Route::get('api/merchant/trash/{id}', 'MerchantController@destroyMerchant');
        Route::get('api/merchant/active/{id}', 'MerchantController@activeMerchant');
        Route::get('api/merchant/deactive/{id}', 'MerchantController@deactiveMerchant');
        Route::get('api/search/merchant/{data}', 'MerchantController@searchMerchant');
        Route::get('api/admin/to/merchant/{id}', 'MerchantController@adminAccessMerchant');
        Route::get('api/export/merchants', 'MerchantController@exportMerchant');
        // end merchant route here

        //start carrier controller here

        Route::get('carrier/list', 'CarrierController@index');
        Route::post('carrier/add', 'CarrierController@add_carrier');
        Route::get('carrier/edit/{id}', 'CarrierController@getEdit_carrier');
        Route::post('carrier/update/{id}', 'CarrierController@update_carrier');
        Route::get('carrier/trash/{id}', 'CarrierController@destroy_carrier');
        Route::get('carrier/active/{id}', 'CarrierController@active_carrier');
        Route::get('carrier/deactive/{id}', 'CarrierController@deactive_carrier');
        Route::get('api/applied/applier/job/{id}', 'CarrierController@job_applied');
        Route::get(
            'api/download/user/resume/{id}',
            'CarrierController@download_applied_user_resume'
        );

        // end carrier controller here
        //started customer
        Route::get('/list/customer', 'CustomerController@getCustomer');
        Route::get('/block/customer/ip/{id}', 'CustomerController@blockIp');
        Route::get('/unblock/customer/ip/{id}', 'CustomerController@unblockIp');
        Route::get('/search/customer/{data}', 'CustomerController@searchCustomer');
        Route::get('api/export/customers', 'CustomerController@export_customers');
        Route::get('api/export/retail/customers', 'CustomerController@export_retail_customers');
        Route::get('api/customers/export/wholesale', 'CustomerController@export_wholesale_customers');
        Route::get('api/export//customers/officesale', 'CustomerController@export_officesale_customers');
        Route::get('customer/status/{id}', 'CustomerController@status');

        //end customer
        //start the category route
        Route::post('/category/add', 'CategoryController@store');
        Route::get('api/list/category', 'CategoryController@index');
        Route::get('api/category/status/{id}', 'CategoryController@status');
        Route::get('search/category/{search}', 'CategoryController@search');
        Route::get('edit/category/{id}', 'CategoryController@edit');
        Route::post('update/category/{id}', 'CategoryController@update');
        Route::get('api/category/delete/{id}', 'CategoryController@delete');

        //depended route
        Route::get('/category/wise/subCategory/{id}', 'CategoryController@categoryWiseSubCategory');
        Route::get('/subCategory/wise/subSubCategory/{id}', 'SubCategoryController@subCategoryWiseSubCategory');
        // Route::get('/attribute/wise/variant/{id}', 'AttributeAndVariantController@attributeWiseVariant');


        // AuthorController codes
        Route::post('/author/add', 'AuthorController@store');
        Route::get('list/author', 'AuthorController@index');
        Route::get('active/author/{id}', 'AuthorController@active');
        Route::get('deActive/author/{id}', 'AuthorController@deActive');
        Route::get('edit/author/{id}', 'AuthorController@edit');
        Route::post('update/author/{id}', 'AuthorController@update');
        Route::get('search/author/{search}', 'AuthorController@search');
        Route::get('api/author/list', 'AuthorController@getAuthorName');

        // AuthorController codes ends here

        // PublisherController codes
        Route::get('list/publisher', 'PublisherController@index');
        Route::post('/publisher/add', 'PublisherController@store');
        Route::get('active/publisher/{id}', 'PublisherController@active');
        Route::get('deActive/publisher/{id}', 'PublisherController@deActive');
        Route::get('edit/publisher/{id}', 'PublisherController@edit');
        Route::post('update/publisher/{id}', 'PublisherController@update');
        Route::get('search/publisher/{search}', 'PublisherController@search');
        Route::get('api/publisher/list', 'PublisherController@getPublisherName');
        // PublisherController codes ends here




        //start the sub-category route
        Route::get('api/list/subCategory', 'SubCategoryController@index');
        Route::post('/subCategory/add', 'SubCategoryController@store');
        Route::get('api/subCategory/status/{id}', 'SubCategoryController@status');
        Route::get('search/subCategory/{search}', 'SubCategoryController@search');
        Route::get('edit/subCategory/{id}', 'SubCategoryController@edit');
        Route::post('update/subCategory/{id}', 'SubCategoryController@update');
        Route::get('api/sub/category/delete/{id}', 'SubCategoryController@delete');
        //apply discount
        Route::post('api/sub-category/discount/add/{id}', 'SubCategoryController@addDiscount');

        //start the sub-sub category route
        Route::get('/list/subSubCategory', 'SubSubCategoryController@index');
        Route::post('/subSubCategory/add', 'SubSubCategoryController@store');
        Route::get('api/subSubCategory/status/{id}', 'SubSubCategoryController@active');
        Route::get('search/subSubCategory/{search}', 'SubSubCategoryController@search');
        Route::get('edit/subSubCategory/{id}', 'SubSubCategoryController@edit');
        Route::post('update/subSubCategory/{id}', 'SubSubCategoryController@update');
        Route::get('api/sub/sub/category/delete/{id}', 'SubSubCategoryController@delete');
        //apply discount
        Route::post('api/sub-sub-category/discount/add/{id}', 'SubSubCategoryController@addDiscount');

        //start the slider route
        Route::get('/list/slider', 'SliderController@index');
        Route::post('/slider/add', 'SliderController@store');
        Route::get('/get/edit/slider/{id}', 'SliderController@getEditSlider');
        Route::post('/slider/update/{id}', 'SliderController@updateSlider');
        Route::get('api/slider/status/{id}', 'SliderController@status');
        Route::get('delete/slider/{id}', 'SliderController@destroy');



        //start teh attribute route route
        Route::get('/list/attribute', 'AttributeAndVariantController@index');
        Route::post('/attribute/add', 'AttributeAndVariantController@store');
        Route::get('active/attribute/{id}', 'AttributeAndVariantController@active');
        Route::get('deActive/attribute/{id}', 'AttributeAndVariantController@deActive');
        Route::get('api/attribute/item/{id}', 'AttributeAndVariantController@edit');
        Route::post('api/attribute/update/{id}', 'AttributeAndVariantController@update');
        Route::get('delete/attribute/{id}', 'AttributeAndVariantController@destroy');
        //start the variant route route
        Route::get('/list/variant', 'AttributeAndVariantController@variant');
        Route::post('/variant/add', 'AttributeAndVariantController@storeVariant');
        Route::get('active/variant/{id}', 'AttributeAndVariantController@activeVariant');
        Route::get('/api/get/edit/item/{id}', 'AttributeAndVariantController@getVariantItem');
        Route::post('/api/variant/update/{id}', 'AttributeAndVariantController@updateVariant');
        Route::get('deActive/variant/{id}', 'AttributeAndVariantController@deActiveVariant');
        Route::get('api/attirbute/delete/{id}', 'AttributeAndVariantController@deleteAtrribute');
        Route::get('api/variant/delete/{id}', 'AttributeAndVariantController@deleteVariant');
        //start the merchant route
        Route::get('/list/supplier', 'SupplierController@index');
        Route::post('supplier/add', 'SupplierController@store');
        Route::get('/active/supplier/{id}', 'SupplierController@active');
        Route::get('/deActive/supplier/{id}', 'SupplierController@deActive');
        Route::get('/edit/supplier/{id}', 'SupplierController@edit');
        Route::post('/update/supplier/{id}', 'SupplierController@update');
        Route::get('api/search/supplier/{data}', 'SupplierController@search_supplier');
        Route::get('/api/suplier/amount/{id}', 'SupplierController@supplierAmountList');
        Route::get('/api/pdf/suplier/amount/{id}', 'SupplierController@pdfSupplierAmount');
        Route::get('/api/pdf/suplier/purchase/{id}', 'SupplierController@pdfSupplierPurchase');
        Route::get('api/supplier/list', 'SupplierController@supplierList');
        Route::get('api/export/supplier', 'SupplierController@export_supplier');
        Route::get('api/supplier/delete/{id}', 'SupplierController@delete');

        //start the city route
        Route::get('/list/city', 'CityController@index');
        Route::post('city/add', 'CityController@store');
        Route::get('/active/city/{id}', 'CityController@active');
        Route::get('/deActive/city/{id}', 'CityController@deActive');
        Route::get('/edit/city/{id}', 'CityController@edit');
        Route::get('api/search/city/{data}', 'CityController@search_city');
        Route::post('/update/city/{id}', 'CityController@update');

        //start here the sub city route
        Route::get('api/list/sub/city', 'SubCityController@get_sub_city_list');
        Route::post('api/sub/city/add', 'SubCityController@store_sub_city');
        Route::get('api/active/sub/city/{id}', 'SubCityController@active_city');
        Route::get('api/deActive/sub/city/{id}', 'SubCityController@de_active_city');
        Route::get('api/edit/sub/city/{id}', 'SubCityController@get_edit_item');
        Route::get('api/search/sub/city/{data}', 'SubCityController@search_sub_city');
        Route::post('api/update/sub/city/{id}', 'SubCityController@update_sub_city');
        Route::get('city/wise/sub/city/{id}', 'SubCityController@cityWiseSubCity');

        //start the offer route
        Route::post('offer/add', 'OfferController@store');
        Route::get('api/edit/offer/item/get/{id}', 'OfferController@get_edit_offer_item');
        Route::post('api/offer/edit/{id}', 'OfferController@edit_offer_item');
        Route::get('/list/offer', 'OfferController@index');
        Route::get('/active/offer/{id}', 'OfferController@active');
        Route::get('/deActive/offer/{id}', 'OfferController@deActive');
        Route::get('/delete/offer/{id}', 'OfferController@destroy');

        //start the courier route
        Route::get('/list/courier', 'CourierController@index');
        Route::get('/api/get/couriers', 'CourierController@couriers');
        Route::post('courier/add', 'CourierController@store');
        Route::get('/active/courier/{id}', 'CourierController@active');
        Route::get('/deActive/courier/{id}', 'CourierController@deActive');
        Route::get('/edit/courier/{id}', 'CourierController@edit');
        Route::get('api/search/courier/{data}', 'CourierController@search_courier');
        Route::post('/update/courier/{id}', 'CourierController@update');
        Route::post('api/update/courier/api/info', 'CourierController@updateCourierApiInfo');
        Route::get('api/get/courier/api/info', 'CourierController@getCourierApiInfo');
        Route::get('api/generate/pathao/access-token', 'CourierController@generatePathaoToken');
        Route::get('/api/set/default/{id}', 'CourierController@setDefault');



        /*********  start order source route *********/
        Route::get('/api/get/source', 'OrderSourceController@index');
        Route::post('/api/source/add', 'OrderSourceController@store');
        Route::get('/api/source/status/{id}', 'OrderSourceController@status');
        Route::get('/api/source/edit/{id}', 'OrderSourceController@edit');
        Route::post('/api/source/update/{id}', 'OrderSourceController@update');
        Route::get('/api/set/source/default/{id}', 'OrderSourceController@setDefault');
        Route::get('/api/get/active/source', 'OrderSourceController@activeSource');
        /*********  end order source route *********/



        /*********  start sms service route *********/
        Route::get('/api/get/sms', 'SmSServiceController@index');
        Route::post('/api/sms/add', 'SmSServiceController@store');
        Route::get('/api/sms/status/{id}', 'SmSServiceController@status');
        Route::get('/api/sms/edit', 'SmSServiceController@edit');
        Route::post('/api/sms/update', 'SmSServiceController@update');
        Route::get('/api/set/sms/default/{id}', 'SmSServiceController@setDefault');
        Route::get('/api/get/active/sms', 'SmSServiceController@activeSource');
        Route::get('list/send/sms', 'SmSServiceController@smsCampaignList');
        /*********  end sms service route *********/

        /*********  start marketing route *********/
        Route::get('api/product/list', 'MarketingController@productList');
        Route::post('api/fetch-number-count', 'MarketingController@fetchNumberCount');
        Route::post('api/send/sms/to/customer', 'MarketingController@sendMessage');
        /*********  end marketing route *********/



        //start the comment route
        Route::get('/list/comment', 'CommentController@index');
        Route::post('comment/add', 'CommentController@store');
        Route::get('/active/comment/{id}', 'CommentController@active');
        Route::get('/deActive/comment/{id}', 'CommentController@deActive');
        Route::get('/edit/comment/{id}', 'CommentController@edit');
        Route::post('/update/comment/{id}', 'CommentController@update');
        Route::get('/destroy/comment/{id}', 'CommentController@destroy');


        //start the product route
        Route::get('/list/product', 'ProductController@index');
        Route::post('product/add', 'ProductController@store');
        Route::get('/approved/product/{id}', 'ProductController@approved');
        Route::get('api/product/status/{id}', 'ProductController@status');
        Route::get('/deny/product/{id}', 'ProductController@deny');
        Route::get('/delete/product/{id}', 'ProductController@delete');
        Route::post('/stock/update/product/{id}', 'ProductController@stockUpdate');
        Route::get('/edit/product/{id}', 'ProductController@edit');
        Route::post('/api/update/product/{id}', 'ProductController@update');
        Route::get('/api/delete/product/image/{id}', 'ProductController@deleteImage');
        Route::get('/api/delete/book/image/{id}', 'ProductController@deleteBookImage');
        Route::get('/destroy/product/{id}', 'ProductController@destroy');
        Route::get('search/product/{search}', 'ProductController@search');
        Route::get('api/search/product/with/code/{code}', 'ProductController@searchWithCode');
        Route::get('search/single/product/{search}', 'ProductController@searchSingleProduct');
        Route::get('api/search/customer/with/phone/number/{number}', 'ProductController@searchCustomer');
        Route::get('api/brand/list', 'ProductController@brand');

        Route::get('/admin/low-stock-report', 'ProductController@lowStockReport')->name('admin.lowStockReport');

        Route::get('/api/free-delivery/products', 'ProductController@freeDeliveryProducts');
        Route::post('/api/update/fee-delivery', 'ProductController@updateFreeDelivery');

        Route::get('api/get/seggested/product/for/order', 'ProductController@get_suggested_product');
        Route::get('api/search/seggested/product/for/order/{product_code}', 'ProductController@search_suggested_product');
        Route::get('api/product/stock', 'ProductController@productStockReports');
        Route::get('api/stock/report/product/all/categories/pdf', 'ProductController@stockReportAllCategory');
        Route::get('api/stock/report/product/definite/category/pdf/{category_id}', 'ProductController@stockReportCategoryWise');

        Route::get('/product/print/barcode/{id}/{how_many}', 'ProductController@printBarcode');
        Route::get('api/search/suggested/product/with/code/name/{data}', 'ProductController@search_suggested_product_code_name');
        Route::get('api/copy/product/{id}/{copyItmes}', 'ProductController@CopyProduct');
        Route::get('api/ck/editor/image/upload', 'ProductController@ckEditorUpload');
        Route::get('api/product/stock/tracking/report', 'ProductController@stockTracking');
        Route::get('api/delete/general/product/of/combo', 'ProductController@deleteGeneralProductOfCombo');
        Route::get('api/delete/product/variant/{id}/{variant_id}', 'ProductController@deleteProductVariant');
        Route::post('/variant/status/update', 'ProductController@updateVariantStatus');
        Route::post('/product-variant/delete-image', 'ProductController@deleteVariantImage');

        Route::get('/product/ecp', 'ProductController@productECP')->withoutMiddleware(['admin']);
        Route::get('api/product/view/list', 'ProductController@productViewReport');


        Route::get('api/combo/product/list', 'ProductController@comboProduct');
        Route::get('api/product/combo/status/{id}', 'ProductController@comboStatus');
        Route::get('api/product/delivery/status/{id}', 'ProductController@deliveryStatus');

        // addition and deduction from POS 
        Route::post('api/add/to/pos',       'ProductController@addToPos');
        Route::post('api/remove/to/pos',    'ProductController@removeToPos');
        Route::get('/fetch/pos/products',    'ProductController@fetchPOSProducts');



        Route::get('/search/products/{query}', 'ProductController@searchProducts');
        Route::get('/search/product/with/variants/{code}', 'ProductController@getProductWithVariants');
        Route::get('api/brand/list', 'ProductController@brand');
        Route::get('api/brands', 'ProductController@brands');
        Route::get('api/categories', 'ProductController@categories');





        //start the coupon route
        Route::get('api/get/coupon/list', 'CouponController@index');
        Route::post('api/coupon/code/add', 'CouponController@store');
        Route::get('api/coupon/active/{id}', 'CouponController@active');
        Route::get('api/coupon/de-active/{id}', 'CouponController@deActive');
        Route::get('api/get/edit/coupon/{id}', 'CouponController@get_edit_item');
        Route::post('api/coupon/code/update/{id}', 'CouponController@update');
        Route::get('api/coupon/delete/{id}', 'CouponController@destroy');

        //start the purchase route
        Route::get('api/list/purchase', 'PurchaseController@index');
        Route::post('add/purchase', 'PurchaseController@store');
        Route::post('add/variant/wise/purchase', 'PurchaseController@variantWisePurchaseStore');
        Route::get('/active/purchase/{id}', 'PurchaseController@active');
        Route::get('/deActive/purchase/{id}', 'PurchaseController@deActive');
        Route::get('/edit/purchase/{id}', 'PurchaseController@edit');
        Route::post('/update/purchase/{id}', 'PurchaseController@update');
        Route::get('/destroy/purchase/{id}', 'PurchaseController@destroy');
        Route::get('details/purchase/{id}', 'PurchaseController@details');
        Route::get('api/purchase/search/data/{data}', 'PurchaseController@search_according_data');
        Route::get('api/purchase/date/wise/filter', 'PurchaseController@according_date_wise');
        Route::post('api/purchase/memo/upload', 'PurchaseController@uploadFile');
        Route::get('api/product/purchase/items/edit/{id}', 'PurchaseController@getPurchase');
        Route::get('api/delete/purchase-item/{id}', 'PurchaseController@deletePurchaseItem');
        Route::get('api/delete/purchase/{id}', 'PurchaseController@deletePurchase');
        Route::get('api/purchase/print/invoice/{id}', 'PurchaseController@invoicePrint');
        Route::post('api/upload/purchase/memo', 'PurchaseController@uploadPurchaseMemo');
        Route::post('api/update/product/purchase/{id}', 'PurchaseController@productPurchaseUpdate');
        Route::put('api/update/variant/wise/product/purchase/{id}', 'PurchaseController@variantWisePurchaseUpdate');
        Route::get('api/delete/product/purchase/{id}', 'PurchaseController@deleteProductPurchase');
        Route::get('api/purchase/search/products/{search}', 'PurchaseController@searchProduct');
        Route::get('api/search/purchase/product/{code}', 'PurchaseController@getPurchaseProduct');
        Route::get('/purchase/ecp', 'PurchaseController@PurchaseECP')->withoutMiddleware(['admin']);

        //start the damage product route
        Route::get('api/list/damage/product', 'DamageProductController@index');
        Route::post('/add/damage', 'DamageProductController@store');
        Route::get('api/delete/damage/product/{id}', 'DamageProductController@deleteProductDamage');
        Route::get('/details/damage/product/{id}', 'DamageProductController@details');
        // Route::get('/active/damage/product/{id}', 'DamageProductController@active');
        // Route::get('/deActive/damage/product/{id}', 'DamageProductController@deActive');
        // Route::get('/edit/damage/product/{id}', 'DamageProductController@edit');
        // Route::post('/update/damage/product/{id}', 'DamageProductController@update');
        // Route::get('/destroy/damage/product/{id}', 'DamageProductController@destroy');
        // Route::get('details/damage/product/{id}', 'DamageProductController@details');
        // Route::get('api/damage/product/search/data/{data}', 'DamageProductController@search_according_data');
        // Route::get('api/damage/product/date/wise/filter', 'DamageProductController@according_date_wise');
        // Route::get('api/product/damage/product/items/edit/{id}', 'DamageProductController@getPurchase');
        // Route::get('api/delete/damage/product-item/{id}', 'DamageProductController@deletePurchaseItem');
        // Route::get('api/damage/product/print/invoice/{id}', 'DamageProductController@invoicePrint');
        // Route::post('api/upload/damage/product/memo', 'DamageProductController@uploadPurchaseMemo');
        // Route::post('api/update/product/damage/product/{id}', 'DamageProductController@productPurchaseUpdate');

        // Route::get('api/damage/product/search/products/{search}', 'DamageProductController@searchProduct');
        // Route::get('api/search/damage/product/product/{code}', 'DamageProductController@getPurchaseProduct');
        // Route::get('/damage/product/ecp', 'DamageProductController@PurchaseECP')->withoutMiddleware(['admin']);

        //start the sale route
        Route::post('/sale/store', 'SaleController@store');
        Route::post('/sale/inventory/store', 'SaleController@storeInventory');
        Route::post('/sale/exchange/store', 'SaleController@exchangeStore');
        Route::get('/api/office/sales/list', 'SaleController@office_sale_index');
        Route::get('/api/company/sales/list', 'SaleController@company_sale_index');
        Route::get('/sale/view/{id}', 'SaleController@show');
        Route::get('/sale/paid/{id}', 'SaleController@paid');
        Route::get('/sale/returned/{id}', 'SaleController@return');
        Route::get('api/get/sale/details/{id}', 'SaleController@saleEdit');
        Route::post('api/update/sale/{id}', 'SaleController@update');
        Route::get('api/sale/delete/{id}', 'SaleController@delete');
        // this route for office sale
        Route::get(
            'api/office/sale/search/data/{data}',
            'SaleController@office_sale_search_according_data'
        );
        Route::get(
            'api/officeSale/date/wise/filter',
            'SaleController@office_sale_search_according_date_wise'
        );
        //this route for company sale
        Route::get(
            'api/company/sale/search/data/{data}',
            'SaleController@company_sale_search_according_data'
        );
        Route::get(
            'api/company/sale/date/wise/filter',
            'SaleController@company_sale_search_according_date_wise'
        );

        //start the order  route
        Route::post('create/order', 'OrderController@store');
        Route::post('update/order/{id}', 'OrderController@update');

        Route::get('orders', 'OrderController@index');
        Route::get('order/view/{id}', 'OrderController@orderView');
        // Route::get('order/edit/{id}', 'OrderController@orderEdit');

        Route::get('approved/order/{id}', 'OrderController@approved');
        Route::get('api/waiting/for/product/{id}', 'OrderController@WFP');
        Route::get('packaging/order/{id}', 'OrderController@packaging');
        Route::get('pending/order/{id}', 'OrderController@pending');
        Route::post('delivered/order', 'OrderController@delivered');
        Route::post('reseller/delivered/order', 'OrderController@resellerOrderDelivered');
        Route::get('shipment/order/{id}', 'OrderController@shipment');
        Route::get('return/order/{id}', 'OrderController@return');
        Route::post('/api/cancel/order/{id}', 'OrderController@cancel');
        Route::post('/api/ip/block/order/{id}', 'OrderController@ipBlockForCustomer');
        Route::post('/api/order/return/with/charge/{id}', 'OrderController@returnWithCost');
        Route::post('/api/order/item/return', 'OrderController@returnItem');
        Route::get('/api/partial/delivered/order/{id}', 'OrderController@partialDelivered');
        Route::get('/api/return/pending/order/{id}', 'OrderController@returnPending');
        Route::get('/api/order/delete/{id}', 'OrderController@delete');


        Route::post('order/courier/update/{id}', 'OrderController@OrderCourierUpdate');
        Route::get('/order/search/{saerch}', 'OrderController@orderSearch');
        Route::get('/order/filter', 'OrderController@OrderFilter');

        Route::get('/order/status/wise', 'OrderController@OrderStatusWise');
        Route::get('/order/search/status/wise/{saerch}', 'OrderController@orderSearchStatusWise');
        Route::get('/order/filter/status/wise', 'OrderController@OrderFilterStatusWise');

        Route::post('api/order/comment', 'OrderController@comment');
        Route::get('api/get/order/comments/{id}', 'OrderController@getOrderComments');
        Route::get('api/admin/customer/order/info', 'OrderController@customerOrderInfo');


        Route::get('/orders/progress', [OrderController::class, 'progressData']);


        //order bulk action route
        Route::get('/order/invoice/print/{id}/{print_type}', 'OrderController@orderPrint');

        Route::get('api/bulk/order/status/changed/{id}/{status}', 'OrderController@bulkStatusUpdate');
        Route::post('shipment/all/order', 'OrderController@shipmentAll');
        Route::get('delivered/all/order/{id}', 'OrderController@deliveredAll');
        Route::get('return/all/order/{id}', 'OrderController@returnAll');
        Route::get('order/return/item/{id}', 'OrderController@returnItem');
        //exchange order 
        Route::post('api/exchange/order/store', 'OrderController@storeExchange');
        Route::post('api/update/exchange/order/{id}', 'OrderController@updateExchange');
        Route::get('api/search/order/for/exchange/{id}', 'OrderController@searchForExchange');
        Route::get('api/change/order/item/exchange/status/{id}', 'OrderController@exchangeItemStatus');

        //order processing report
        Route::get('api/order/processors/list', 'OrderController@orderProcessorsList');
        Route::get('api/processor/orderProcessing/pdf/{id}', 'OrderController@DateWiseOrderReportPDF');
        Route::get('api/order/report/with/details/{id}', 'OrderController@orderProcessorDetails');



        Route::get('api/reseller/order/summary/{id}', 'OrderController@orderSummary');
        Route::get('api/reseller/order/summary/download/{id}', 'OrderController@downloadOrderSummary');
        Route::get('api/reseller/order/summary/print/{id}', 'OrderController@printOrderSummary');







        //start the others  route
        Route::get('/others', 'OthersController@others');

        //Delivery Charge
        Route::get('delivery/charge', 'OthersController@deliveryCharge');
        Route::get('edit/delivery/charge/{id}', 'OthersController@editDeliveryCharge');
        Route::post('update/delivery/charge/{id}', 'OthersController@updateDeliveryCharge');
        Route::get('api/delivery/charge/status/{id}', 'OthersController@updateDeliveryChargeStatus');

        //start the admin route
        Route::get('/single/admin', 'LoginController@admin');
        Route::get('/logout/admin', 'LoginController@logout');
        Route::get('/list/admin', 'AdminController@index');
        Route::post('/add/admin', 'AdminController@store');
        Route::get('/api/role/get/admin/{id}', 'AdminController@getAdminRole');
        Route::post('/api/role/update/admin/{id}', 'AdminController@updateAdminRole');
        Route::post('/api/assign/order/to/admin', 'AdminController@assignOrderToAdmin');
        Route::get('/api/get/admins', 'AdminController@listAdmins');

        Route::get('api/get/admin/permission/list/{id}', 'AdminController@getAdminPermission');
        Route::post('api/assign/admin/permissions/{id}', 'AdminController@assignAdminPermission');

        Route::get('api/search/admin/{data}', 'AdminController@search_admin');
        Route::get('deactive/admin/{id}', 'AdminController@deactive');
        Route::get('active/admin/{id}', 'AdminController@active');
        Route::get('/edit/admin/{id}', 'AdminController@edit');
        Route::post('/update/admin/{id}', 'AdminController@update');
        Route::post('/update/admin/password/{id}', 'AdminController@updatePassword');
        Route::post('/api/admin/reset/password/{id}', 'AdminController@resetPassword');
        //balance routes
        Route::get('api/balance/list/all', 'AccountController@balance');
        Route::post('api/balance/add', 'AccountController@store_balance');
        Route::get('api/balance/edit/{id}', 'AccountController@edit');
        Route::post('api/balance/update/{id}', 'AccountController@update');
        Route::get('api/balance/status/{id}', 'AccountController@status');
        Route::get('api/balance/delete/{id}', 'AccountController@delete');

        //start the accounts route
        //start credit route
        Route::get('credits', 'AccountController@get_credit');
        Route::post('credit/store', 'AccountController@store_credit');
        Route::get('credit/edit/{id}', 'AccountController@edit_credit');
        Route::post('credit/update/{id}', 'AccountController@update_credit');
        Route::get('credit/destroy/{id}', 'AccountController@destroy_credit');
        Route::get('api/export/credit', 'AccountController@export_credit');
        Route::get('api/credit/purpose', 'AccountController@credit_purpose');
        Route::get('api/get/payment/requests', 'AccountController@paymentRequests');
        Route::post('api/accept/payment/request', 'AccountController@payPaymentRequest');
        Route::get('api/cancel/payment/request/{id}', 'AccountController@cancelPaymentRequest');

        //credit due route......
        Route::get('api/credit/due', 'CreditDueController@index');
        Route::get('api/due/to/paid/{id}', 'CreditDueController@duePaid');
        Route::get('api/due/search/{search}', 'CreditDueController@search');
        Route::get('account/monlthly/report', 'AccountController@monthlyReport');
        Route::post('api/office/sale/due/paid', 'CreditDueController@duePaid');


        //start debit route
        Route::get('api/debits', 'AccountController@get_debit');
        Route::post('debit/store', 'AccountController@store_debit');
        Route::get('debit/edit/{id}', 'AccountController@edit_debit');
        Route::get('api/export/debit', 'AccountController@export_debit');
        Route::post('debit/update/{id}', 'AccountController@update_debit');
        Route::get('debit/destroy/{id}', 'AccountController@destroy_debit');
        Route::get('api/account/purpose', 'AccountController@accountPurpose');
        Route::get('api/employee/list', 'AccountController@employeeList');

        //start company route
        Route::get('api/company/with/sales/records', 'CompanyController@index');
        Route::get('company', 'CompanyController@companyList');
        Route::post('company/store', 'CompanyController@store');
        Route::get('company/edit/{id}', 'CompanyController@edit');
        Route::post('company/update/{id}', 'CompanyController@update');

        //start the report route
        Route::get('api/order/report', 'ReportController@orderReport');
        Route::get('api/sale/report/office', 'ReportController@officeSaleReport');
        Route::get('admin/facebook-insights', 'ReportController@fetchFacebookAdInsights');
        Route::get(
            'api/get/office/sale/pdf/{start_date}/{end_date}',
            'ReportController@office_sale_report_pdf'
        );
        Route::get(
            'api/get/sale/order/pdf/{start_date}/{end_date}',
            'ReportController@order_sale_report_pdf'
        );
        Route::get(
            'api/get/purchase/pdf/{start_date}/{end_date}',
            'ReportController@purchase_report_pdf'
        );
        Route::get('supplier/report', 'ReportController@supplierReport');
        Route::get('account/report', 'ReportController@accountReport');
        Route::get('purchase/report', 'ReportController@purchaseReport');
        Route::get('api/profit/report', 'ReportController@profitReport');
        Route::get('sale/profite/report', 'ReportController@saleProfite');
        Route::get('order/profit/report', 'ReportController@orderProfit');

        //start the admin reseller route
        Route::get('/api/active/reseller/{id}', 'ResellerController@active');
        Route::get('/api/deactive/reseller/{id}', 'ResellerController@deActive');
        Route::get('api/reseller/list', 'ResellerController@getReseller');
        Route::get('api/reseller/remove/{id}', 'ResellerController@destroy');
        Route::post('api/reseller/add', 'ResellerController@addReseller');
        Route::get('api/reseller/get/{id}', 'ResellerController@edit');
        Route::post('api/reseller/update/{id}', 'ResellerController@updateReseller');
        Route::get('api/admin/to/reseller/{id}', 'ResellerController@accountAccess');
        Route::get('api/search/reseller/{data}', 'ResellerController@reseller_search');
        Route::get('api/export/resellers', 'ResellerController@export_reseller');
        Route::get('api/reseller/payable/amount', 'ResellerController@resellerAmount');
        Route::post('api/reseller/income', 'ResellerController@manuallyIncomeSet');
        Route::post('api/reseller/expense', 'ResellerController@manuallyExpenseSet');
        Route::post('api/reseller/comment', 'ResellerController@storeComment');
        Route::get('/api/get/reseller/comments/{id}', 'ResellerController@getComment');


        // ===========================================================
        // ===========================================================  

        //reseller sale store
        Route::get('api/get/all/resellers', 'ResellerController@allReseller');
        Route::post('api/reseller/sale/store', 'SaleController@store');


        // ===========================================================
        // ===========================================================  







        //reseller payment transaction routes
        Route::get('api/get/reseller/payment/requests', 'AccountController@resellerPaymentRequests');
        Route::post('api/accept/reseller/payment/request', 'AccountController@payResellerPaymentRequest');
        Route::get('api/cancel/reseller/payment/request/{id}', 'AccountController@cancelResellerPaymentRequest');



        //merchant payment transaction routes
        Route::get('api/get/merchant/payment/requests', 'AccountController@merchantPaymentRequests');
        Route::post('api/accept/merchant/payment/request', 'AccountController@payMerchantPaymentRequest');
        Route::get('api/cancel/merchant/payment/request/{id}', 'AccountController@cancelMerchantPaymentRequest');

        //start role and permission route
        Route::post('api/role/store', 'RoleController@store');
        Route::get('api/roles', 'RoleController@index');
        Route::get('api/permissions/edit/role/{id}', 'RoleController@editRolePermissons');
        Route::post('api/permissions/update/role/{id}', 'RoleController@updateRolePermissons');

        Route::post('api/balance/transfer', 'FondTransferController@store');
        Route::get('api/balance/transfer/transactions', 'FondTransferController@index');
        Route::get('api/fund/transfer/delete/{id}', 'FondTransferController@delete');

        //order export
        Route::get('/order/export/{status}/{courier_id}', 'OrderController@exportOrder');
        Route::get('/export/selected/item/{id}', 'OrderController@exportOrderSelectedItem');

        //order export
        Route::get('export/orders/pick-list/{id}', 'OrderController@exportOrderPickList');
        Route::get('/export/orders/for/paper-fly/{id}', 'OrderController@exportOrderForPaperFly');
        Route::get('export/orders/for/redx/{id}', 'OrderController@exportOrderForRedx');
        Route::get('export/orders/for/pathao/{id}', 'OrderController@exportOrderForPathao');
        Route::get('export/orders/for/e-courier/{id}', 'OrderController@exportOrderForeCourier');
        Route::get('export/orders/for/steadfast/{id}', 'OrderController@exportOrderForSteadFast');
        Route::post('api/order/bulk/assign/to/courier', 'OrderController@orderBulkAssignToCourier');



        // general setting route is start from here
        Route::get('api/get/site/info', 'GeneralSettingController@get_site_info');
        Route::post('api/edit/site/info/{id}', 'GeneralSettingController@edit_site_info');


        Route::get('api/edit/template/{id}', 'GeneralSettingController@editTemplates');
        Route::post('api/update/template/{id}', 'GeneralSettingController@updateTemplates');

        //reseller site information here
        Route::get('api/reseller/site/info/edit', 'GeneralSettingController@reseller_get_site_info');
        Route::post('api/reseller/site/info/update/{id}', 'GeneralSettingController@reseller_edit_site_info');

        //footer setting route is start form here
        Route::get('api/get/site/footer/info', 'FooterSettingController@get_footer_info');
        Route::post('api/edit/site/footer/info/{id}', 'FooterSettingController@edit_footer_info');

        //theme setting route is start form here
        Route::get('api/get/site/theme/info', 'ThemeSettingController@get_theme_info');
        Route::post('api/edit/site/theme/info/{id}', 'ThemeSettingController@edit_theme_info');

        //page route is start form here
        Route::get('api/get/pages', 'PageInfoController@index');
        Route::post('api/store/page', 'PageInfoController@store');
        Route::get('api/get/page/{id}', 'PageInfoController@edit');
        Route::post('api/update/page/{id}', 'PageInfoController@update');
        Route::get('api/deActive/page/{id}', 'PageInfoController@deActivePage');
        Route::get('api/active/page/{id}', 'PageInfoController@activePage');
        Route::get('api/delete/page/{id}', 'PageInfoController@deletePage');

        /*********** sale campaign route *********/
        Route::post('api/banner/add', 'SaleCampaignController@AddBanner');
        Route::get('api/banner/list', 'SaleCampaignController@BannerLIst');
        Route::get('api/banner/item/{id}', 'SaleCampaignController@GetBanner');
        Route::get('api/banner/item/active/{id}', 'SaleCampaignController@ActiveBanner');
        Route::get('api/banner/item/de-active/{id}', 'SaleCampaignController@DeActiveBanner');
        Route::get('api/banner/item/delete/{id}', 'SaleCampaignController@DestroyBanner');
        Route::post('api/banner/update/{id}', 'SaleCampaignController@UpdateBanner');




        //loaner
        Route::post('api/loaner/store', 'LoanerController@store');
        Route::get('api/loaner', 'LoanerController@index');
        Route::post('api/loan/store', 'LoanerController@storeLoan');

        //start the loan route
        Route::get('api/loan', 'LoanController@index');
        Route::post('api/loand/store', 'LoanController@store');
        Route::get('api/loaners', 'LoanController@loaners');
        Route::get('api/loaners/details/{id}', 'LoanController@loanersdetails');
        Route::post('api/loan/store/{id}', 'LoanController@storeloan');
        Route::get('api/download/all/loan/pdf', 'LoanController@download_all_record');
        Route::get('api/loan/history/download/pdf/{id}', 'LoanController@download_loan_history');
        Route::get('api/loand/paid/history/download/pdf/{id}', 'LoanController@download_loan_paid_history');

        //company assets route is here
        Route::get('api/company/assets', 'AssetsController@get_assets');
        Route::post('api/company/assets/add', 'AssetsController@store_assets');
        Route::get('api/company/assets/edit/{id}', 'AssetsController@get_asset_item');
        Route::post('api/company/assets/update/{id}', 'AssetsController@update_asset_item');
        Route::get('api/company/assets/delete/{id}', 'AssetsController@delete_asset_item');
        Route::get('api/download/assets/pdf', 'AssetsController@download_assets');
        Route::get('api/get/customer/review/on/products', 'ProductReviewController@get_customer_review');
        Route::get('api/deActive/review/of/customer/{id}', 'ProductReviewController@deactive_customer_review');
        Route::get('api/active/review/of/customer/{id}', 'ProductReviewController@active_customer_review');
        Route::get('api/remove/review/of/customer/{id}', 'ProductReviewController@remove_customer_review');

        //company investment route is here
        Route::get('api/company/investor', 'InvestmentController@get_ivestors');
        Route::post('api/company/investor/add', 'InvestmentController@store');
        Route::get('api/company/investor/get/{id}', 'InvestmentController@getInvestor');
        Route::post('api/company/investor/update/{id}', 'InvestmentController@updateInvestor');
        Route::get('api/company/investor/details/{id}', 'InvestmentController@get_ivestor_details');
        Route::post('api/add/more/invest/{id}', 'InvestmentController@add_more_invest');
        Route::get('api/company/investor/list', 'InvestmentController@investor_list');
        Route::get('api/download/all/investment/pdf', 'InvestmentController@download_investors');
        Route::get('api/investor/paid/history/download/pdf/{id}', 'InvestmentController@download_profit_paid');
        Route::get('api/invest/history/download/pdf/{id}', 'InvestmentController@download_investor_record');

        Route::get('api/get/prop/up/banner', 'SaleCampaignController@get_prop_up');
        Route::post('api/edit/prop/up/banner/{id}', 'SaleCampaignController@update_prop_up_banner');

        //company bill statements route is here
        Route::get('api/bill/statement/list', 'BillStatementController@bill_list');
        Route::get('api/bill/statement/active/list', 'BillStatementController@activeBillList');
        Route::post('api/bll/statement/add', 'BillStatementController@store');
        Route::get('api/edit/bill/statement/{id}', 'BillStatementController@edit');
        Route::post('api/bll/statement/update/{id}', 'BillStatementController@update');
        Route::get('api/bll/per/month/add', 'BillStatementController@store_bill_per_month');
        Route::get('api/bll/statement/details/{id}', 'BillStatementController@bill_statement_details');
        Route::get('api/bill/status/{id}', 'BillStatementController@status');

        //account balance
        Route::get('api/balance/list', 'BillStatementController@balance');
        Route::get('api/get/balance/item/{id}', 'BillStatementController@getBalanceItem');


        Route::get('company/active/status/{id}', 'CompanyController@active');
        Route::get('company/delete/{id}', 'CompanyController@delete');
        Route::get('company/de-active/status/{id}', 'CompanyController@deActive');
        Route::post('api/get/company/sale/payment', 'SaleController@companySalePayment');
        Route::get('api/company/sale/payment/details/{id}', 'SaleController@companyPayment');
        Route::get('api/company/sale/details/{id}', 'SaleController@CompanySaleDetails');


        //supplier sales
        Route::get('api/supplier/reverse/sales/records/{id}', 'SaleController@SupplierSaleDetails');
        Route::post('api/campaign/store', 'CampaignController@store');
        Route::get('api/campaign', 'CampaignController@index');
        Route::get('api/campaign/edit/{id}', 'CampaignController@edit');
        Route::post('api/campaign/update/{id}', 'CampaignController@update');
        Route::get('api/campaign/remove/{id}', 'CampaignController@destroy');
        Route::get('api/product/assign/to/campaign/{product_code}', 'CampaignController@assignProduct');
        Route::get('api/campaign/product/{campaign_id}', 'CampaignController@campaignProducts');
        Route::get('api/deActive/campaign/{campaign_id}', 'CampaignController@deactive');
        Route::get('api/active/campaign/{campaign_id}', 'CampaignController@active');
        Route::post('api/campaign/store', 'CampaignController@store');
        Route::get('api/campaign', 'CampaignController@index');
        Route::get('api/campaign/edit/{id}', 'CampaignController@edit');
        Route::post('api/campaign/update/{id}', 'CampaignController@update');
        Route::get('api/campaign/remove/{id}', 'CampaignController@destroy');
        Route::get('api/campaign/product/remove/{productId}', 'CampaignController@removeProductfromProduct');
        Route::get('api/product/assign/to/campaign/{product_code}', 'CampaignController@assignProduct');
        Route::get('api/campaign/product/{campaign_id}', 'CampaignController@campaignProducts');
        Route::get('api/deActive/campaign/{campaign_id}', 'CampaignController@deactive');
        Route::get('api/active/campaign/{campaign_id}', 'CampaignController@active');

        ///start the campaign image route
        Route::get('api/campaign/image/{campaign_id}', 'CampaignSliderController@index');
        Route::post('api/campaign/image', 'CampaignSliderController@store');
        Route::get('api/campaign/image/remove/{id}', 'CampaignSliderController@destroy');

        //office sale invoice
        Route::get('api/print/sale/invoice/{id}', 'OrderController@officeSaleInvoicePrint');
        Route::get('api/get/order/statistic', 'OrderController@orderStatistic');
        Route::get('api/get/due/customer/payment/history/{phone}', 'CreditDueController@paymentHistory');


        //-----------director routes start -------------------
        Route::get('api/directors', 'DirectorController@getDirectors');
        Route::post('api/director/add', 'DirectorController@addDirector');
        Route::post('api/director/update/info/{id}', 'DirectorController@updateDirector');
        Route::get('api/get/director/{id}', 'DirectorController@getDirector');
        Route::get('api/director/search/{phone}', 'DirectorController@searchDirector');
        Route::post('api/store/director/payment', 'DirectorController@storeDirectorPayment');
        Route::post('api/refund/director/payment', 'DirectorController@refundDirectorPayment');
        //-----------director routes end -------------------


        //------------- brand route start ---------------
        Route::post('/brand/add', 'BrandController@store');
        Route::get('list/brand', 'BrandController@index');
        Route::get('api/brand/status/{id}', 'BrandController@status');
        Route::get('search/brand/{search}', 'BrandController@search');
        Route::get('edit/brand/{id}', 'BrandController@edit');
        Route::post('update/brand/{id}', 'BrandController@update');
        //------------- brand route end ---------------






        /******** start landing page routes ********/
        Route::get('/api/get/landing/pages', 'LandingPageController@pages');
        Route::get('/api/page/status/{id}', 'LandingPageController@status');
        Route::post('/api/page/basic/setup/add', 'LandingPageController@addPage');
        Route::get('/get/edit/page/basic/setup/{id}', 'LandingPageController@edit');
        Route::post('/api/page/basic/setup/update/{id}', 'LandingPageController@update');
        Route::get('/api/get/active/landing/pages', 'LandingPageController@activePage');
        Route::get('/api/remove/landing-page/product/{id}', 'LandingPageController@removeProduct');
        Route::post('/api/page/product/auto-cart-status/update', 'LandingPageController@updateProductAutoCartStatus');
        Route::get('/api/landing/page/product/{id}', 'LandingPageController@landingPageProduct');
        Route::get('/api/delete/review/image/{id}', 'LandingPageController@deleteImage');
        /******** start landing page routes ********/



        /******** start landing page benefit routes ********/
        Route::post('/api/benefit/add', 'BenefitController@store');
        Route::get('/api/list/benefit/{slug}', 'BenefitController@index');
        Route::get('/api/edit/benefit/{id}', 'BenefitController@edit');
        Route::post('/api/update/benefit/{id}', 'BenefitController@update');
        Route::get('/api/delete/benefit/{id}', 'BenefitController@delete');
        Route::get('/api/benefit/status/{id}', 'BenefitController@status');
        Route::get('/api/search/benefit/{search}', 'BenefitController@search');
        /******** end landing page benefit routes ********/




        /******** start description routes ********/
        Route::post('/api/description/add/{slug}', 'DescriptionController@store');
        Route::get('/api/list/description/{slug}', 'DescriptionController@index');
        Route::get('/api/edit/description/{id}', 'DescriptionController@edit');
        Route::post('/api/update/description/{id}', 'DescriptionController@update');
        Route::get('/api/delete/description/{id}', 'DescriptionController@delete');
        Route::get('/api/description/status/{id}', 'DescriptionController@status');
        Route::get('/api/search/description/{search}', 'DescriptionController@search');
        /******** end description routes ********/


        /************** start landing page reviews routes ************ */
        Route::post('api/add/review', 'ProductReviewController@addReview');
        Route::get('api/get/review/list/{slug}', 'ProductReviewController@landingPageReview');
        Route::get('api/edit/review/{id}', 'ProductReviewController@landingPageReviewEdit');
        Route::post('api/update/review/{id}', 'ProductReviewController@landingPageReviewUpdate');
        /************ end landing page reviews routes *************** */


        /**********  start bkash routes **********/
        Route::post('update/bkash/info', 'BkashController@updateBkashInfo');
        Route::get('get/bkash/info', 'BkashController@getBkashInfo');
        Route::post('update/bkash/status', 'BkashController@updateBkashStatus');
        /**********  end bkash routes **********/

        /**********  start aamarpay routes **********/
        Route::post('update/aamarpay/info', 'AamarpayController@updateAmarpayInfo');
        Route::get('get/aamarpay/info', 'AamarpayController@getAmarpayInfo');
        Route::post('update/aamarpay/status', 'AamarpayController@updateAmarpayStatus');
        /**********  start aamarpay routes **********/


        /******  start the country route *******/
        Route::post('api/country/add', 'CountryController@store');
        Route::get('api/list/country', 'CountryController@index');
        Route::get('api/active/country/{id}', 'CountryController@active');
        Route::get('api/deActive/country/{id}', 'CountryController@deActive');
        Route::get('api/search/country/{search}', 'CountryController@search');
        Route::get('api/edit/country/{id}', 'CountryController@edit');
        Route::post('api/update/country/{id}', 'CountryController@update');
        /******  end the country route *******/


        /******  start the skin route *******/
        Route::post('api/skin/add', 'SkinController@store');
        Route::get('api/list/skin', 'SkinController@index');
        Route::get('api/active/skin/{id}', 'SkinController@active');
        Route::get('api/deActive/skin/{id}', 'SkinController@deActive');
        Route::get('api/search/skin/{search}', 'SkinController@search');
        Route::get('api/edit/skin/{id}', 'SkinController@edit');
        Route::post('api/update/skin/{id}', 'SkinController@update');
        /******  end the skin route *******/
    }
);
