<?php

use App\Http\Controllers\Frontend\auth\LogInController;
use Illuminate\Support\Facades\Route;


Route::get('/', function () {
    return "ok";
});

/* ====================== Guest Router ====================== */

Route::namespace('Frontend\Auth')->group(function () {
    /* ==================== Login Controller ==================== */
    Route::get('/login', 'LogInController@index')->name('login');
    Route::post('/login', 'LogInController@store')->name('login');

    Route::get('/dropshipper/login', 'LogInController@resellerLogin')->name('reseller.login');
    Route::post('/dropshipper/login', 'LogInController@resellerStore')->name('reseller.store');

    Route::get('/login-otp', 'OtpController@otpIndex')->name('login.otp');
    Route::post('/send-otp', 'OtpController@SendOtp')->name('send.otp');
    Route::get('/get/session-otp', 'OtpController@getSessionOtp')->name('get.session.otp');
    Route::get('/clear/session-otp/{mobile_no}', 'OtpController@clearSessionOtp')->name('clear.session.otp');
    Route::get('/receive/otp', 'OtpController@receiveOtp')->name('receive.otp');
    Route::post('/otp-verify', 'OtpController@verifyCodeOtp')->name('verify.otp');

    /* ==================== Register Controller ==================== */
    Route::get('/register', 'RegisterController@index')->name('register');
    Route::post('/register', 'RegisterController@store');

    /* ==================== ResetPassword Controller ==================== */
    // Route::get('/reset-password','ResetPasswordController@index')->name('reset.password');
    // Route::post('/reset-password','ResetPasswordController@resetPassword');



    Route::get('/reseller/user', 'LogInController@resellerMerchant')->name('reseller.merchant');

    /* =============== Reseller Registration Controller =========== */
    Route::get('/user/dropshipper/login', 'ResellerRegisterController@userResellerLogin')->name('user.reseller');
    Route::get('/reseller/register', 'ResellerRegisterController@resellerRegister')->name('reseller.register');
    Route::post('/reseller/register/store', 'ResellerRegisterController@resellerRegisterStore')->name('reseller.register.store');

    /* ============ Merchant Controller ---------*/
    Route::get('/vendor/direction', 'MerchantRegisterController@merchantLoginRegister')->name('merchant.login.register');
    Route::get('/vendor/register', 'MerchantRegisterController@merchantRegister')->name('merchant.register');
    Route::post('/vendor/registration', 'MerchantRegisterController@merchantRegisterStore')->name('merchant.register.store');
});


/* ======================== Authenticate router ======================== */
Route::namespace('Frontend\User')->prefix('user')->middleware('customer')->name('user.')->group(function () {
    Route::get('/dashboard', 'HomeController@index')->name('dashboard');
    Route::get('/profile', 'ProfileController@profile')->name('profile');
    Route::get('/profile-edit', 'ProfileController@profileEdit')->name('profile.edit');
    Route::post('/profile-update/{id}', 'ProfileController@profileUpdate')->name('profile.update');
    Route::get('/change-password', 'ChangePasswordController@changePassword')->name('change.password');
    Route::post('/update-password/{id}', 'ChangePasswordController@updatePassword')->name('update.password');
    Route::get('/logout', 'HomeController@logout')->name('logout');

    Route::get('/delete-details/{id}', 'OrderController@orderDetails')->name('order.details');
    Route::get('/order-update/{id}', 'OrderController@orderUpdate')->name('order.Update');
    // Route::get('address', 'AccountController@address')->name('address');


    Route::get('/affiliate', 'AffiliateController@index')->name('affiliate');
    Route::get('/withdrawal/list/{id}', 'AffiliateController@withdrawalList')->name('affiliate.list');
    Route::get('/commission/list/{id}', 'AffiliateController@commissionList')->name('commission.list');

    Route::get('/coupon/income/{id}', 'InfluencerIncomeController@index')->name('coupon.income');
    Route::get('/coupon/withdrawal/list/{id}', 'InfluencerIncomeController@withdrawalList')->name('coupon.income.withdraw.list');
    Route::get('/coupon/commission/list/{id}', 'InfluencerIncomeController@commissionList')->name('coupon.income.list');
});

Route::group(
    [
        'namespace' => 'Frontend',
    ],
    function () {
        Route::get('/', 'HomeController@index')->name('root');


        // Route::get('/landing-page', 'HomeController@landingPage')->name('landing.page');
        Route::get('/pages/{slug}', 'HomeController@landingPage')->name('landing.page');
        Route::get('/products', 'ProductController@index')->name('products');
        Route::post('/add/cart', 'CartController@addToCart')->name('card.add');
        Route::get('/cart/index', 'CartController@index')->name('cart.index');
        Route::post('/cart/remove', 'CartController@cartRemoveItem')->name('cart.remove');
        Route::post('/cart/update', 'CartController@cartUpdate')->name('cart.update');
        Route::post('/cart/update/with/productid', 'CartController@cartUpdateWithProduct')->name('cart.update.with.id');
        Route::get('/cart/view', 'CartController@cartView')->name('cart.view');
        Route::get('/cart/ecp', 'CartController@cartECP');
        Route::post('/buy-now', 'CartController@buyNow')->name('buy.now');
        Route::post('/shipping/charge', 'CartController@setShippingCharge')->name('shipping.charge');
        Route::get('/get/shipping/charge', 'CartController@getShippingCharge')->name('shipping.charge.get');
        Route::post('/shipping/set', 'CouponController@setShippingCharge')->name(('shipping.set'));
        Route::get('/product/variants/{productId}', 'LandingPageController@getProductVariants')->name('getProductVariant');
        Route::post('/cart/update-variant', 'CartController@updateVariant')->name('cart.update.variant');
        Route::get('/combo/product', 'ProductController@comboProducts')->name('combo.product');
        Route::get('/daily-product', 'ProductController@dailyProducts')->name('daily.products');
        Route::get('/buy-one-get-one-product', 'ProductController@buyOneGetOneProducts')->name('buy.one.products');
        Route::get('/concern-product/{slug}', 'ProductController@concernProducts')->name('concern.product');
        Route::get('/country-product/{id}', 'ProductController@countryProducts')->name('country.product');
        Route::get('/brand/{slug}', 'ProductController@brandsProducts')->name('brand.product');
        Route::get('/get-delivery-charge', 'HomeController@getDeliveryCharge');

        //----------------brand-------------------
        Route::get('/brands', 'HomeController@brand')->name('brand');
        
        //author module
        Route::get('/our-authors', 'AuthorController@index')->name('all.authors');
        Route::get('/details/{slug}', 'AuthorController@autherDetails')->name('author.details');
        Route::get('/publishers', 'AuthorController@publisher')->name('publishers');
        Route::get('/publisher-details/{slug}', 'AuthorController@publisherDetails')->name('publisher-details');
        //wish list
        Route::get('/wish-list', 'WishListController@index')->name('wish.list');
        Route::get('/get/wish-list', 'WishListController@getWishList')->name('wish.list.get');
        Route::post('/delete/wish-list', 'WishListController@deleteWishList')->name('wish.list.delete');
        Route::post('/wish-list', 'WishListController@addToWishlist')->name('wish.list');

        //----------------get data product view event-------------------
        Route::Post('/get/product/content', 'ProductController@getProductContent');
        Route::get('/get/cart-items', 'ProductController@getCartItems');
        Route::post('/store-fbc', 'ProductController@storeFbc')->name('store.fbc');
        Route::post('/fire/page/view/event', 'ProductController@pageVIewEvent');

        //coupon apply
        Route::post('/coupon-apply', 'CouponController@applyCoupon')->name('coupon.apply');
        Route::get('/coupon/calculation', 'CouponController@calculationCoupon')->name(('coupon.calculation'));
        Route::post('/forget-coupon', 'CouponController@forgetCouponSession')->name('forget_coupon');
        //---about--------
        Route::get('/about', 'AboutController@index')->name('about');
        Route::get('/custom/page/{slug}', 'CustomPageController@index')->name('custom.page');

        //----------------contact-us-------------------
        Route::get('/contact-us', 'ContactUsController@index')->name('contact-us');
        Route::post('/contact-us', 'ContactUsController@store')->name('contact-us');

        //----------------Product review-------------------
        Route::post('/re-view', 'ReviewController@store')->name('product.review');

        //------new product-----------
        Route::get('/new-products', 'HomeController@newArrivalProduct')->name('product.new.arrival');

        //------top sell product-----------
        Route::get('/top-sell-products', 'HomeController@topSellProduct')->name('product.top.sell');

        //------checkout-----------
        Route::get('/checkout', 'CheckOutController@index')->name('checkout.index');
        Route::post('/checkout/order', 'OrderController@order')->name('checkout.order');
        Route::get('/order/tracking', 'OrderController@index')->name('order.tracking');
        Route::post('/order/tracking', 'OrderController@orderTrack')->name('order.tracking');
        Route::get('/clear/all-cart', 'CartController@clearCart');
        Route::get('/order-success/{invoice_no}', 'OrderController@showOrderSuccess')->name('order.success');
        Route::get('/payment/fail/{payment_id}', 'OrderController@paymentFail')->name('payment.fail');
        Route::get('/check/ecp', 'CheckecpController@checkECP');
        Route::get('get/subcity', 'CheckOutController@getSubCity');
        Route::get('/aff/{username}', 'HomeController@setAffiliateUsername');
        Route::post('/affiliate/withdrawal', 'HomeController@affiliateWithdrawal')->name('affiliate.withdrawal');
        Route::post('/coupon/income/withdrawal', 'HomeController@couponIncomeWithdrawal')->name('coupon.income.withdrawal');
        Route::get('/search-products', 'ProductController@loadSearchProducts')->name('search.products');
        Route::post('/product-search', 'ProductController@searchProduct')->name('product.search');
        Route::post('/load-more/category-product', 'HomeController@loadMoreCategoryProduct')->name('load.more.category.product');
        Route::post('/load-more/brand-product', 'HomeController@loadMoreBrandProduct')->name('load.more.brand.product');
        
        Route::post('/load-more-brand-data', 'ProductController@loadMoreBrandData')->name('load.more.brand.data');
        Route::post('/load-more-data', 'ProductController@loadMoreData')->name('load.more');
        
        Route::get('/product/{slug}', 'ProductController@singleProduct')->name('single.product');
        Route::get('/brand/product/{slug}', 'ProductController@getBrandProduct')->name('all.product.brand');


        //filerting routes
        Route::post('/filter-by-condition', 'ProductFilteringController@sortSelectWiseProducts')->name('products.sort.conditions');
        Route::post('/filter-by-price', 'ProductFilteringController@filterProductsWithPrice')->name('products.filter.by.price');
        Route::post('/filter-by-brands', 'ProductFilteringController@filterProductsWithBrandName')->name('filter.with.brands');
        Route::post('/filter-by-countries', 'ProductFilteringController@filterProductsWithCountryName')->name('filter.with.countries');
        Route::post('/filter-by-sub-sub-categories', 'ProductFilteringController@filterProductsWithSubSubCategories')->name('filter.with.subSubCategories');

        
        Route::get('/{slug}/{subCategory?}/{subSubCategory?}', 'ProductController@getCategoryProduct')->name('product.category');


        
        
    }
);