<?php

use Illuminate\Support\Facades\Route;

Route::group(['namespace' => 'Reseller'], function () {
    // slider display route started here
    Route::get('api/general/setting', 'HomeController@getSetting');
    Route::get('api/slider', 'HomeController@slider');
    Route::get('api/reselling/service', 'HomeController@service');
    Route::get('api/dropshipper/screen', 'HomeController@dropshipperScreen');
    Route::get('api/dropshipper/profile/screen', 'HomeController@dropshipperProfileScreen');
    Route::get('api/dropshipper/testimonials', 'HomeController@dropshipperTestimonials');
    Route::get('api/dropshipper/info', 'HomeController@getDropshipperInfo');
    Route::get('api/dropshipper/product', 'HomeController@getDropshipperProduct');
    Route::get('api/reselling/rule', 'HomeController@rules');
    Route::get('api/about/info', 'HomeController@aboutUs');
    Route::get('api/contact/info', 'HomeController@contactUs');
    Route::get('api/dropshipper/site/info', 'HomeController@dropshipperSiteInfo');
    Route::get('api/all/dropshipper', 'HomeController@countDropshipper');
    Route::get('api/all/categories', 'HomeController@allCategory');
    Route::get('api/subCategories', 'HomeController@subCategories');
    Route::get('api/subSubCategories', 'HomeController@subSubCategories');
    Route::get('api/new/arrival/product', 'HomeController@newArrivalProduct');
    Route::get('api/category/wise/product/{categorySlug}', 'HomeController@categoryWiseProduct');
    Route::get('api/reseller/product/status/{id}', 'HomeController@productStatus');
    Route::get('api/get/documentation/api', 'HomeController@apiDocumentation');
    //frontend


    // Route::get('api/all/products', 'HomeController@getProducts');
    Route::get('api/single/product/{id}', 'HomeController@singleProduct');
    Route::get('api/reseller/cartContent', 'HomeController@getCartContent');
    Route::get('api/reseller/cartContent/remove/{rowId}', 'HomeController@cartRemoveItem');
    Route::post('api/reseller/product/add/to/cart', 'HomeController@addToCart');
    Route::post('api/reseller/customer/order/front-page', 'OrderController@FrontPageOrderStore');
    Route::post('/reseller/update/product/basicInformation/{id}', 'HomeController@resellerResellingPriceUpdate');
    Route::get('/reseller/edit/product/{id}', 'HomeController@resellerProductEdit');





    // Route::get('api/subCategories/{slug}', 'HomeController@categoryWiseSubcategory');
    // Route::get('api/sub-category/wise/product', 'HomeController@subCategoryWiseProduct');


    Route::get('api/pages', 'HomeController@pages');
    Route::get('api/page/info/{slug}',  'HomeController@showPageInfo');
    //route for reseller login and registration and authorization
    Route::post('api/reseller/login', 'LoginController@check_login');
    Route::get('api/reseller/login/session/check', 'LoginController@checkSession');
    Route::post('api/reseller/register', 'LoginController@register_reseller')->name('reseller.register');
    Route::post('api/reseller/password/reset/send/code', 'LoginController@send_reset_code');
    // Route::post('api/reseller/verify/reset/code/{phone}', 'LoginController@reseller_reset_code_verified');
    Route::post('api/went/verify/reset/code/{phone}', 'LoginController@reseller_reset_code_verified');
    Route::post('api/reseller/new/password/set/{phone}', 'LoginController@reseller_set_new_password');
    Route::get('api/get/cities', 'HomeController@cityList');
    Route::get('api/get/sub_city/of/city/{id}', 'HomeController@subCityList');
});

Route::group(
    [
        'middleware' => 'reseller',
        'namespace' => 'Reseller',
    ],
    function () {
        Route::get('api/reseller/logout', 'LoginController@logout');
        Route::get('api/get/reseller/dashboard/data', 'HomeController@get_dashboard_highlight_info');

        Route::post('api/create/reseller/order', 'OrderController@ResellerOrderStore');
        Route::post('/api/create/reseller/front/order', 'OrderController@ResellerFrontOrderStore');
        Route::get('api/reseller/order', 'OrderController@get_reseller_order');
        Route::get('api/reseller/order/view/{id}', 'OrderController@reseller_order_details');
        Route::get('api/reseller/order/edit/{id}', 'OrderController@reseller_order_edit');
        Route::post('api/update/reseller/order/{id}', 'OrderController@ResellerOrderUpdate');

        Route::get('api/reseller/cashbook', 'OrderController@resellerCashbook');
        Route::get('api/get/single/reseller', 'HomeController@get_current_reseller');
        Route::get('api/get/payment/method', 'HomeController@getPaymentMethod');
        Route::post('api/get/single/reseller/update', 'HomeController@current_reseller_update');
        Route::post('api/update/payment/method', 'HomeController@updatePaymentMethod');
        Route::post('api/get/single/reseller/password/update', 'LoginController@current_reseller_password_update');
        //reseller payment
        Route::get('api/current/reseller/account/number', 'HomeController@paymentAccountNumber');
        Route::get('api/reseller/withdraw/transaction', 'HomeController@paymentWithDrawTransactions');
        Route::post('api/reseller/payment/withdraw/request', 'HomeController@paymentWithDrawRequest');
        //reseller product info
        Route::get('/api/reseller/show/product/list', 'HomeController@productList');
        Route::get('/api/get/resale/product-price/{product_id}', 'HomeController@findProduct');
        Route::post('/api/set/resale/product-price/{product_id}', 'HomeController@setResalePrice');
        Route::get('/api/search/product/{search}', 'HomeController@searchProduct');
        Route::get('/api/refer/list', 'HomeController@referList');
        Route::get('/api/active/bank', 'HomeController@activeBank');
        Route::post('api/send/message/to/reseller/customer', 'HomeController@sendMessage');
        Route::get('api/reseller/sms/history', 'HomeController@smsHistory');
        // Route::get('/api/category/wise/subcategory/and/products', 'HomeController@categoryWiseSubcategoryAndProduct');
        // Route::get('/api/subcategory/wise/products', 'HomeController@subcategoryWiseProducts');


        Route::get('api/approved/order/{id}', 'OrderController@approved');
        Route::get('api/pending/order/{id}', 'OrderController@pending');
        Route::get('api/cancel/order/{id}', 'OrderController@cancel');
        Route::get('api/order/reseller/comment', 'OrderController@comment');
        Route::get('api/reseller/order/search/{search}', 'OrderController@orderSearch');
        Route::get('api/order/summary/{id}', 'OrderController@orderSummary');
        Route::get('api/order/summary/download/{id}', 'OrderController@downloadOrderSummary');
        Route::get('api/order/summary/print/{id}', 'OrderController@printOrderSummary');



        /******* Category Controller Start ********/
        Route::get('reseller/categories', 'CategoryController@index');
        Route::get('reseller/category/status/{id}', 'CategoryController@status');
        /******* Category Controller End ********/



        /****** Slider Controller Start ******/
        Route::get('api/reseller/sliders', 'SliderController@index');
        Route::post('api/reseller/slider/add', 'SliderController@store');
        Route::get('api/reseller/get/edit/slider/{id}', 'SliderController@edit');
        Route::post('api/reseller/slider/update/{id}', 'SliderController@update');
        Route::get('api/reseller/active/slider/{id}', 'SliderController@active');
        Route::get('api/reseller/deActive/slider/{id}', 'SliderController@deActive');
        Route::get('api/reseller/delete/slider/{id}', 'SliderController@destroy');
        /****** Slider Controller End ******/




        /****** Page Controller Start ******/
        Route::get('api/get/reseller/pages', 'PageController@index');
        Route::post('api/store/reseller/page', 'PageController@store');
        Route::get('api/get/reseller/page/{id}', 'PageController@edit');
        Route::post('api/update/reseller/page/{id}', 'PageController@update');
        /****** Page Controller End ******/



        /******** start landing page routes ********/
        // Route::get('/api/get/landing/pages', 'LandingPageController@pages');
        // Route::get('/api/page/status/{id}', 'LandingPageController@status');
        // Route::post('/api/page/basic/setup/add', 'LandingPageController@addPage');
        // Route::get('/get/edit/page/basic/setup/{id}', 'LandingPageController@edit');
        // Route::post('/api/page/basic/setup/update/{id}', 'LandingPageController@update');
        // Route::get('/api/get/active/landing/pages', 'LandingPageController@activePage');
        // Route::get('/api/remove/exit/landing/product', 'LandingPageController@removeProduct');

        /******** start landing page routes ********/



        /******** start benefit routes ********/
        Route::post('/api/benefit/add', 'BenefitController@store');
        Route::get('/api/list/benefit/{slug}', 'BenefitController@index');
        Route::get('/api/edit/benefit/{id}', 'BenefitController@edit');
        Route::post('/api/update/benefit/{id}', 'BenefitController@update');
        Route::get('/api/delete/benefit/{id}', 'BenefitController@delete');
        Route::get('/api/benefit/status/{id}', 'BenefitController@status');
        Route::get('/api/search/benefit/{search}', 'BenefitController@search');
        /******** end benefit routes ********/




        /******** start solution routes ********/
        Route::post('/api/solution/add', 'SolutionController@store');
        Route::get('/api/list/solution/{slug}', 'SolutionController@index');
        Route::get('/api/edit/solution/{id}', 'SolutionController@edit');
        Route::post('/api/update/solution/{id}', 'SolutionController@update');
        Route::get('/api/delete/solution/{id}', 'SolutionController@delete');
        Route::get('/api/solution/status/{id}', 'SolutionController@status');
        Route::get('/api/search/solution/{search}', 'SolutionController@search');
        /******** end solution routes ********/



        /******** start image routes ********/
        Route::post('/api/image/add', 'ImageController@store');
        Route::get('/api/list/image/{slug}', 'ImageController@index');
        Route::get('/api/edit/image/{id}', 'ImageController@edit');
        Route::post('/api/update/image/{id}', 'ImageController@update');
        Route::get('/api/delete/image/{id}', 'ImageController@delete');
        Route::get('/api/image/status/{id}', 'ImageController@status');
        /******** end image routes ********/


        /************** start reviews routes ************ */
        Route::post('api/review/add', 'ProductReviewController@addReview');
        Route::get('api/get/review/list/{slug}', 'ProductReviewController@landingPageReview');
        Route::get('api/edit/review/{id}', 'ProductReviewController@landingPageReviewEdit');
        Route::post('api/update/review/{id}', 'ProductReviewController@landingPageReviewUpdate');
        /************ end reviews routes *************** */

        /************** start customer routes ************ */
        Route::get('api/reseller/customer/list', 'HomeController@customer');
        Route::get('api/reseller/customer/search/{search}', 'HomeController@searchCustomer');
        Route::get('api/export/reseller/customer', 'HomeController@exportCustomer');
        /************** end customer routes ************ */

        /************** start theme color routes ************ */
        Route::get('api/get/reseller/site/theme/info', 'BackgroundAndColorController@index');
        Route::post('api/reseller/edit/site/theme/info/{id}', 'BackgroundAndColorController@update');
        /************** end theme color routes ************ */


        /********** start the coupon route **********/
        Route::get('api/get/reseller/coupon/list', 'CouponController@index');
        Route::post('api/reseller/coupon/add', 'CouponController@store');
        Route::get('api/get/reseller/edit/coupon/{id}', 'CouponController@edit');
        Route::post('api/reseller/coupon/update/{id}', 'CouponController@update');
        Route::get('api/reseller/coupon/status/{id}', 'CouponController@status');
        Route::get('api/reseller/coupon/delete/{id}', 'CouponController@destroy');
        /********** end the coupon route **********/

    }
);

Route::group(
    [
        'namespace' => 'Admin',
    ],
    function () {
        Route::get('search/customer/with/phone/number/{number}', 'ProductController@searchCustomer');
        Route::get('/search/product/with/code/{search}', 'ProductController@searchWithCode');
        Route::get('/search/reseller/order/with/code/{code}', 'ProductController@searchResellerOrder');
    }
);
