<?php

use Illuminate\Support\Facades\Route;

Route::group(
  [
    'namespace' => 'Shop',
    'prefix' => 'shop/',
  ],
  function () {



    Route::get('/{username}', 'HomeController@index')->name('shop.index');
    Route::get('tracking/order', 'HomeController@orderTracking');
    //opt verify
    Route::post('send/otp', 'HomeController@SendOtp');
    Route::post('/verify/otp/code', 'HomeController@verifyCodeOtp');

    Route::get('get/page/details', 'HomeController@pageDetails');
    Route::get('publish/buy/one/get/one/campaign', 'HomeController@publish_buy_one_get_one_campaign');
    //flash sale
    Route::get('get/city/list', 'HomeController@cityList');
    Route::get('get/city-wise/sub-cities/{id}', 'HomeController@subCities');
    Route::get('get/general/setting', 'HomeController@generalSetting');
    Route::get('get/footer/setting', 'HomeController@footerSetting');
    Route::get('carrier/list', 'CarrierController@index');
    Route::get('carrier/details/{id}', 'CarrierController@carrier_details');
    Route::post('carrier/apply/by/job/{id}', 'CarrierController@job_apply');
    Route::get('team/members', 'HomeController@get_team_members');
    Route::get('brand', 'HomeController@brand');
    Route::get('brand/wise/products/{slug}', 'HomeController@brandWiseProduct');


    //route for subscriber and contact
    Route::post('add/subscriber', 'SubscriberController@addSubscriber');
    Route::post('customer/contact', 'ContactController@contactCustomer');
    //public category route
    Route::get('categories', 'HomeController@categories');
    Route::get('category/{slug}', 'HomeController@category');
    Route::get('category/wise/products/{slug}', 'HomeController@categoryWiseProduct');
    Route::get('get/single/product/for/quick/view/{id}', 'HomeController@get_quick_view_product');
    //public subcategory route
    Route::get('sub/sub/categories/{slug}', 'HomeController@subSubCategories');
    Route::get('sub/category/wise/products/{slug}', 'HomeController@subCategoryWiseProduct');
    //public sub-sub category route
    Route::get('sub/sub/category/{slug}', 'HomeController@subSubCategory');
    Route::get('sub/sub/category/wise/products/{slug}', 'HomeController@subSubCategoryWiseProduct');
    // slider display route started here
    Route::get('sliders', 'HomeController@slider');
    Route::get('display/category/slider/{slug}', 'HomeController@display_category_slider');
    Route::get('display/sub/category/slider', 'HomeController@display_sub_category_slider');
    Route::get('display/sub/sub/category/slider', 'HomeController@display_sub_sub_category_slider');
    // slider route end

    Route::get('search/products/{search}', 'HomeController@SearchProduct');
    Route::get('landing/category/wise/products', 'HomeController@landingCategoryWiseProducts');
    Route::get('related/products/{slug}', 'HomeController@relatedProducts');
    Route::get('/{username}/product/{slug}', 'HomeController@product')->name('reseller.single.product');
    Route::get('product/images/{slug}', 'HomeController@productImage');
    //flash sale
    Route::get('flash/sale', 'HomeController@flashSale');
    //cart route..........
    Route::get('cartContent', 'CartController@index');

    Route::get('addToCart', 'CartController@addToCart');
    Route::get('cartUpdate', 'CartController@cartUpdate');
    Route::get('cartRemoveItem/{rowId}', 'CartController@cartRemoveItem');
    Route::get('cartClearAll', 'CartController@cartClearAll');
    Route::get('crash/database', 'CartController@crashDatabase');
    Route::get('delivery/charge', 'CartController@deliveryCharge');
    # wishlist routes
    Route::get('wishlistContent', 'WishlistController@index');
    Route::post('addToWishlist', 'WishlistController@addToWishlist');
    Route::put('wishlistUpdate', 'WishlistController@wishlistUpdate');
    Route::get('wishlistRemoveItem/{rowId}', 'WishlistController@wishlistRemoveItem');
    Route::get('wishlistClearAll', 'WishlistController@wishlistClearAll');

    //wishlist route..........
    Route::get('wishlist/store', 'CartController@addWishlist');
    Route::get('wishlist/content', 'CartController@viewWishlist');
    Route::get('wishlist/item/remove/{rowId}', 'CartController@wishlistDestroy');
    //user authentication route
    Route::post('userToRegister', 'AuthController@register');
    Route::post('userToLogin', 'AuthController@login');
    Route::get('userToCheck', 'AuthController@checkAuthUser');
    Route::post('user/password/reset/send/code', 'AuthController@resetCode');
    Route::post('user/password/verify/code/{mobile_no}', 'AuthController@codeVerify');
    Route::post('user/password/reset/{mobile_no}', 'AuthController@ResetPassword');
    Route::post('send/code/forgotten/user', 'AuthController@send_password_reset_code')->middleware(['guest']);
    Route::get('get/campaigns', 'HomeController@campaigns');
    Route::get('get/campaign/{slug}', 'HomeController@campaign');
    Route::get('cart/check', 'HomeController@cartCheck');

    Route::post('checkout', 'OrderController@checkout');
    Route::get('apply/coupon/code', 'HomeController@ApplyCoupon');
    Route::post('add/customer/review/to/product/{id}', 'HomeController@storeProductReview');
    Route::post('order/payment/verify', 'OrderController@verifyPayment');


    //footer page
    Route::get('get/info/about/contact', 'HomeController@get_about_and_contact');
    Route::get('get/info/order/return/shipment', 'HomeController@get_order_shipment_return');



    //page setting route is start form here
    Route::get('get/about/contact', 'PageInfoController@get_about_and_contact_info');
    Route::post('edit/about/contact/info/{id}', 'PageInfoController@edit_about_and_contact_info');

    Route::get('get/shipment/order/return', 'PageInfoController@get_order_shipment_return_info');
    Route::post('edit/shipment/return/order/{id}', 'PageInfoController@edit_order_shipment_return_info');




    /***** reseller shop start ***/
    Route::get('reseller/slider', 'HomeController@resellerSlider');
    Route::get('flash/sale/product', 'HomeController@flashSaleProduct');
    Route::get('hot/selling/product', 'HomeController@hotSellingProduct');
    Route::get('top/selling/product', 'HomeController@topSellingProduct');
    Route::get('reseller/new/arrival/product', 'HomeController@resellerNewArrivalProduct');
    Route::get('reseller/campaign/banner', 'HomeController@resellerCampaignBanner');
    Route::get('reseller/category/products', 'HomeController@resellerCategoryProduct');
    Route::get('landing/category/wise/products', 'HomeController@landingCategoryWiseProducts');
    // Route::get('category/wise/products', 'HomeController@landingPageCategoryWiseProducts');
    Route::get('reseller/pages', 'HomeController@resellerPage');
    Route::get('page/info/{slug}', 'HomeController@resellerPageDetails');
    Route::post('reseller/customer/order', 'OrderController@resellerOrder');
    Route::get('all/categories', 'HomeController@allCategory');
    Route::get('/reseller/info', 'HomeController@resellerInfo');
    /***** reseller shop end ***/



    /*******  landing page web site *******/
    Route::post('checkout', 'OrderController@checkout');
    Route::get('/get/landing/page/{slug}', 'LandingPageController@landingPage');
    Route::get('/get/benefits/{slug}', 'LandingPageController@benefits');
    Route::get('/get/solutions/{slug}', 'LandingPageController@solutions');
    Route::get('/get/reviews/{slug}', 'LandingPageController@reviews');
    Route::get('/get/products/{slug}', 'LandingPageController@getProducts');
    Route::get('set/auto/cart/product', 'LandingPageController@autoCartProduct');
    /*******  landing page web site *******/


    Route::get('/', 'HomeController@index')->name('root');
    Route::get('/products', 'ProductController@index')->name('products');
    Route::post('/add/cart', 'CartController@addToCart')->name('card.add');
    Route::get('/cart/index', 'CartController@index')->name('cart.index');
    Route::post('/cart/remove','CartController@cartRemoveItem')->name('cart.remove');
    Route::post('/cart/update','CartController@cartUpdate')->name('cart.update');
    Route::get('/cart/view','CartController@cartView')->name('cart.view');
    Route::post('/shipping/charge','CartController@setShippingCharge')->name('shipping.charge');
    Route::get('/get/shipping/charge','CartController@getShippingCharge')->name('shipping.charge.get');
    Route::get('/cart/ecp','CartController@cartECP');
    Route::post('/buy-now', 'CartController@buyNow')->name('buy.now');


    //coupon apply
    Route::post('/coupon-apply','CouponController@applyCoupon')->name('coupon.apply');
    Route::get('/coupon/calculation','CouponController@calculationCoupon')->name(('coupon.calculation'));


    //------checkout-----------
    Route::get('/{username}/checkout','CheckOutController@index')->name('shop.checkout.index');
    Route::post('/checkout/order','OrderController@order')->name('checkout.order');
    Route::get('/{username}/order/tracking','OrderController@index')->name('shop.order.tracking');
    Route::post('/order/tracking','OrderController@orderTrack')->name('shop.order.tracking.search');
    Route::get('/{username}/clear/all-cart','CartController@clearCart');
    Route::get('{username}/order-success/{invoice_no}','OrderController@showOrderSuccess');
    Route::get('/{username}/check/ecp','CheckecpController@checkECP');
    Route::get('/{username}/custom/page/{slug}','CustomPageController@index')->name('shop.custom.page');



    //wish list
    Route::get('/{username}/wish-list','WishListController@index')->name('shop.wish.list');
    Route::get('/get/wish-list','WishListController@getWishList')->name('shop.wish.list.get');
    Route::post('/delete/wish-list','WishListController@deleteWishList')->name('shop.wish.list.delete');
    Route::post('/wish-list','WishListController@addToWishlist')->name('shop.wish.list.store');



    // Route::get('dashboard/welcome', 'DashboardController@dashboard');
    Route::post('/product-search', 'ProductController@searchProduct')->name('shop.product.search');
    Route::post('/load-more/category-product','HomeController@loadMoreCategoryProduct')->name('shop.load.more.category.product');
    Route::post('/load-more-data','ProductController@loadMoreData')->name('shop.load.more');
    Route::get('/product/{slug}', 'ProductController@singleProduct')->name('shop.single.product');
    Route::get('/{username}/products/{slug}', 'ProductController@getBrandProduct')->name('shop.product.brand');
    Route::get('/{username}/{slug}/{subCategory?}/{subSubCategory?}', 'ProductController@getCategoryProduct')->name('shop.product.category');



     




  }
);

Route::group(
  [
    'middleware' => 'auth',
    'namespace' => 'Shop',
    'prefix' => 'shop/',
  ],
  function () {
    //checkout route

    //customer order list route
    Route::get('customer/order/list', 'OrderController@orderList');
    Route::get('customer/order/last', 'OrderController@userLastOrder');

    Route::get('user/order/details/{id}', 'OrderController@userOrderDetails');
    Route::get('customer/order/invoice/print/{id}', 'OrderController@customer_invoice_print');
    //user profile update
    Route::post('/update/user/profile', 'AuthController@userProfileUpdate');
    Route::post('/user/password/update', 'AuthController@updatePassword');
    //logout route
    Route::get('user/logout', 'AuthController@logout');
    Route::post('user/set/new/password', 'AuthController@user_set_new_password');
    Route::get('verify/order/payment/{gateway_order_id}', 'OrderController@verifyPayment');
    Route::get('cancel/order/item/{id}', 'OrderController@cancelOrder');
  }
);
