<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Cache;



Route::get('reboot', function () {
    Artisan::call('storage:link');
    Artisan::call('cache:clear');
    Artisan::call('config:clear');
    Artisan::call('route:clear');
    Artisan::call('config:cache');
    dd("Ready to Start.");
});
Route::get('clear/domain', function () {
    Cache::forget('site_remember_token');
    dd("domain stored.");
});


Route::get('/api/empty/table', 'Admin\DBCleanController@emptySomeTables');



//others route
Route::get('_public/others', 'Admin\OthersController@others')->middleware('auth');
//:::::start the backend route::::::

###### ADMIN API ROUTES ######
require 'admin.php';
###### ADMIN API ROUTES ######


###### Merchant API ROUTES ######
require 'merchant.php';
###### Merchant API ROUTES ######



###### Reseller API ROUTES ######
require 'reseller.php';
###### Reseller API ROUTES ######



###### Reseller Shop ROUTES ######
require 'shop.php';
###### Reseller Shop ROUTES ######



Route::post('api/verify/otp/admin/login', 'Admin\LoginController@otpVerification');
Route::get('check/session/admin', 'Admin\LoginController@sessionCheck');
Route::get('/reseller', 'Reseller\HomeController@home');


Route::get('api/get/city/for/order/checkout', 'Admin\SubCityController@cityList');
Route::get('city/wise/sub/city/{id}', 'Admin\SubCityController@cityWiseSubCity');

Route::get('login/google', 'Frontend\Social\GoogleLoginController@redirectToProvider');
Route::get('callback/google', 'Frontend\Social\GoogleLoginController@handleProviderCallback');


Route::get('/bkash-pay', 'BkashTokenizePaymentController@payment')->name('url-pay');
Route::get('/bkash-create', 'BkashTokenizePaymentController@createPayment')->name('url-create');
Route::get('/bkash-callback', 'BkashTokenizePaymentController@callback')->name('url-callback');
// Checkout (URL) Admin Part
Route::post('/bkash-refund', 'BkashTokenizePaymentController@refundPayment')->name('url-post-refund');
Route::get('/bkash-search', 'BkashTokenizePaymentController@getSearchTransaction')->name('url-get-search');
Route::post('/bkash-search', 'BkashTokenizePaymentController@searchTransaction')->name('url-post-search');
Route::get('/redirect/payment/{payment_id}', 'BkashTokenizePaymentController@retryPayment')->name('redirect.payment');


//start the ssl route
Route::group(
    [
        // 'middleware' => 'auth',
    ],
    function () {
        Route::post('/pages/y', 'SslCommerzPaymentController@index');
        Route::post('/pay-via-ajax', 'SslCommerzPaymentController@payViaAjax');

        Route::post('/success', 'SslCommerzPaymentController@success');
        Route::post('/fail', 'SslCommerzPaymentController@fail');
        Route::post('/cancel', 'SslCommerzPaymentController@cancel');

        Route::post('/ipn', 'SslCommerzPaymentController@ipn');

        Route::get('api/get/order/{id}', 'SslCommerzPaymentController@getOrder');
    }
);

Route::get('/sociallogin/google', 'SocialiteController@login')->name('login.google');
Route::get('/callback/google', 'SocialiteController@redirect');

Route::get('/login/facebook', 'SocialiteController@loginFacebook')->name('login.facebook');
Route::get('/facebook/callback', 'SocialiteController@redirectFacebook');


//admin mix routes
Route::get('/admin/{any}', function () {
    return view('admin.master');
})->where('any', '^(?!api\/)[\/\w\.\,-]*');


//merchant mix routes
Route::get('/merchant/{any}', function () {
    return view('merchant.app');
})->where('any', '^(?!api\/)[\/\w\.\,-]*');


//reseller mix routes
Route::get('/dropshipper/{any}', function () {
    return view('reseller.app');
})->where('any', '^(?!api\/)[\/\w\.\,-]*');


Route::get('/shop/{any}', function () {
    return view('shop.master');
})->where('any', '^(?!api\/)[\/\w\.\,-]*');