<!--============ Header Area Start ============-->
<header class="header_area sticky_header">

    <!-- header top start -->
    <div class="header_top">
        <div class="container">
            <div class="row">
                <div class="col-xxl-6 col-xl-6 col-lg-6">
                    <div class="header_top_site_title">
                        <p><?php echo e($general_settings->title); ?></p>
                    </div>
                </div>
                <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-12 d-none d-lg-block">
                    <div class="header_top_list">
                        <ul>
                            <li>
                                <a href="<?php echo e(route('order.tracking')); ?>" class="header_top_list_link">
                                    <i class="fa-solid fa-location-dot"></i>
                                    Order Tracking
                                </a>
                            </li>
                            <?php if($site_configurations->show_reseller_panel == 1): ?>
                                <li>
                                    <a href="/dropshipper/login" class="header_top_list_link">
                                        <i class="fa-solid fa-user"></i>
                                        Reseller Login
                                    </a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- header top end -->

    <!-- header middle start -->
    <div class="header_middle ">
        <div class="container">
            <div class="row">
                <div class="col-xxl-3 col-xl-3 col-lg-2 d-none d-lg-block">
                    <div class="header_middle_logo">
                        <a href="<?php echo e(route('root')); ?>">
                            <img src="<?php echo e(asset('storage/' . $general_settings->logo)); ?>" alt="<?php echo e($general_settings->title); ?>">
                        </a>
                    </div>
                </div>
                <div class="col-xxl-5 col-xl-5 col-lg-5 col-md-12 col-sm-12 col-12">
                    
                    <!-- header mobile device start -->
                    <div class="header_mobile_device d-lg-none d-md-block">
                        <div class="header_mobile_table_cell">
                            <a class="header_mobile_toggle" data-bs-toggle="offcanvas" href="#offcanvasMenuId">
                                <i class="fa-solid fa-bars"></i>
                            </a> <!-- header mobile device toggle end -->
                            <div class="header_mobile_logo">
                                <a href="<?php echo e(route('root')); ?>">
                                    <img src="<?php echo e(asset('storage/' . $general_settings->logo)); ?>" alt="logo">
                                </a>
                            </div> <!-- header mobile device logo end -->
                            
                            <div class="header_mobile_search" onclick="search()">
                                <i class="fa-solid fa-magnifying-glass"></i>
                            </div> <!-- header mobile device search end -->
                        </div>
                    </div>
                    <!-- header mobile device end -->

                    <div id="search_id" class="header_middle_search_content search_class">
                        <div class="header_middle_search">
                            <form action="<?php echo e(route('search.products')); ?>" method="GET">
                                <input type="text" name="searchInput" id="searchboxinput" onkeyup="searchProduct(this.value)"
                                    value=""class="search__product" placeholder="">
                                <button type="submit" class="header_middle_search_link">
                                    <i class="fa-solid fa-magnifying-glass"></i>
                                </button>
                            </form>
                            
                        </div>
                    </div>

                    <!-- header search item  start -->
                    <div class="header_search_item_content" id="product_search" style="display: none;">
                        <div id="search_product_show" class="header_search_item">
                            
                        </div>
                    </div>
                    <!-- header search item  end -->
                </div>
                <div class="col-xxl-4 col-xl-4 col-lg-5 d-none d-lg-block">
                    <div class="header_middle_table_cell">
                        <div class="header_middle_call">
                            <a href="tel:<?php echo e($general_settings->header_contact_number); ?>" class="header_middle_call_link">
                                <div class="header_middle_call_icon">
                                    <i class="fa-solid fa-phone"></i>
                                </div>
                                <div class="header_middle_call_text">
                                    <p>Call Us Now:</p>
                                    <span><?php echo e($general_settings->header_contact_number); ?></span>
                                </div>
                            </a>
                        </div>
                        <div class="header_middle_wishlist">
                            <a href="<?php echo e(route('wish.list')); ?>" class="header_middle_wishlist_link">
                                <div class="header_middle_wishlist_icon">
                                    <i class="fa-regular fa-heart"></i>
                                    <span class="wish_list_count">0</span>
                                </div>
                            </a>
                        </div>
                        <div class="header_middle_auth">
                            <?php if(auth()->guard('customer')->check()): ?>
                                <a href="<?php echo e(route('user.dashboard')); ?>" class="header_middle_auth_link">
                                    <div class="header_middle_icon">
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-user"><path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path><circle cx="12" cy="7" r="4"></circle></svg>
                                    </div>
                                    <div class="header_middle_text">
                                        <span>Hi,</span>
                                        <span><?php echo e(Str::words(Auth::guard('customer')->user()->name, 1, '..')); ?></span>
                                    </div>
                                </a>
                            <?php else: ?>
                                <a href="<?php echo e(route('login')); ?>" class="header_middle_auth_link">
                                    <div class="header_middle_icon">
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-user"><path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path><circle cx="12" cy="7" r="4"></circle></svg>
                                    </div>
                                    <div class="header_middle_text">
                                        <span>Hi,</span>
                                        <span>Login/Signup</span>
                                    </div>
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- header middle end -->

    <!-- header bottom start -->
    <div class="header_bottom d-none d-lg-block">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <div class="main_menu">
                        <ul>
                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>    
                                <li>
                                    <a href="<?php echo e(route('product.category',[$category->slug])); ?>" class="main_menu_link">
                                        <?php echo e($category->name); ?>

                                        <?php if(count($category->subCategory) > 0): ?>
                                            <i class="fa-solid fa-angle-down"></i>
                                        <?php endif; ?>
                                    </a>
                                    <ul class="submenu">
                                        <?php $__currentLoopData = $category->subCategory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>    
                                            <li>
                                                <a href="<?php echo e(route('product.category',[$category->slug, $subCategory->slug])); ?>" class="submenu_link">
                                                    <?php echo e($subCategory->name); ?>

                                                    <?php if(count($subCategory->subSubCategory) > 0): ?>
                                                        <i class="fa-solid fa-angle-right"></i>
                                                    <?php endif; ?>
                                                </a>
                                                <ul class="submenu">
                                                    <?php $__currentLoopData = $subCategory->subSubCategory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sub_SubCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <li>
                                                            <a href="<?php echo e(route('product.category',[$category->slug, $subCategory->slug, $sub_SubCategory->slug])); ?>" class="submenu_link">
                                                                <?php echo e($sub_SubCategory->name); ?>

                                                            </a>
                                                        </li>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                   
                                                </ul>
                                            </li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        
                                    </ul>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- header bottom end -->

</header>
<!--============ Header Area End ============-->


<script>
    const texts = ['Search for something…','Search for other…','One more search'];
    const input = document.querySelector('#searchboxinput');
    const animationWorker = function (input, texts) {
    this.input = input;
    this.defaultPlaceholder = this.input.getAttribute('placeholder');
    this.texts = texts;
    this.curTextNum = 0;
    this.curPlaceholder = '';
    this.blinkCounter = 0;
    this.animationFrameId = 0;
    this.animationActive = false;
    this.input.setAttribute('placeholder',this.curPlaceholder);

    this.switch = (timeout) => {
        this.input.classList.add('imitatefocus');
        setTimeout(
        () => { 
            this.input.classList.remove('imitatefocus');
            if (this.curTextNum == 0) 
            this.input.setAttribute('placeholder',this.defaultPlaceholder);
            else
            this.input.setAttribute('placeholder',this.curPlaceholder);

            setTimeout(
            () => { 
                this.input.setAttribute('placeholder',this.curPlaceholder);
                if(this.animationActive) 
                this.animationFrameId = window.requestAnimationFrame(this.animate)}, 
            timeout);
        }, 
        timeout);
    }

    this.animate = () => {
        if(!this.animationActive) return;
        let curPlaceholderFullText = this.texts[this.curTextNum];
        let timeout = 100;
        if (this.curPlaceholder == curPlaceholderFullText+'|' && this.blinkCounter==3) {
        this.blinkCounter = 0;
        this.curTextNum = (this.curTextNum >= this.texts.length-1)? 0 : this.curTextNum+1;
        this.curPlaceholder = '|';
        this.switch(400);
        return;
        }
        else if (this.curPlaceholder == curPlaceholderFullText+'|' && this.blinkCounter<3) {
        this.curPlaceholder = curPlaceholderFullText;
        this.blinkCounter++;
        }
        else if (this.curPlaceholder == curPlaceholderFullText && this.blinkCounter<3) {
        this.curPlaceholder = this.curPlaceholder+'|';
        }
        else {
        this.curPlaceholder = curPlaceholderFullText
            .split('')
            .slice(0,this.curPlaceholder.length+1)
            .join('') + '|';
        timeout = 150;
        }
        this.input.setAttribute('placeholder',this.curPlaceholder);
        setTimeout(
        () => { if(this.animationActive) this.animationFrameId = window.requestAnimationFrame(this.animate)}, 
        timeout);
    }

    this.stop = () => {
        this.animationActive = false;
        window.cancelAnimationFrame(this.animationFrameId);
    }

    this.start = () => {
        this.animationActive = true;
        this.animationFrameId = window.requestAnimationFrame(this.animate);
        return this;
        }
    }

    document.addEventListener("DOMContentLoaded", () => {
        let aw = new animationWorker(input, texts).start();
        input.addEventListener("focus", (e) => aw.stop());
        input.addEventListener("blur", (e) => {
            aw = new animationWorker(input, texts);
            if(e.target.value == '') setTimeout( aw.start, 1000);
        });
    });
</script>
<?php /**PATH /home/stylzbd/public_html/resources/views/frontend/partials/header/template1.blade.php ENDPATH**/ ?>