
<?php $__env->startSection('title', 'Check Out'); ?>
<?php $__env->startSection('content'); ?>
    <!--============ Checkout Area Start ============-->
    <section class="checkout_area section_padding">

        <form id="order_form">
            <div class="container">
                <div class="checkout_form_title">
                                <h3><?php echo e(dynamic_lang('please_order_now')); ?> </h3>
                            </div>
                <div class="row gy-4">
                    <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-12 col-12">
                        <div class="checkout_form">
                            
                            <div class="checkout_form_group">
                                <label><?php echo e(dynamic_lang('full_name')); ?> <span class="required_r">*</span></label>
                                <input type="text" required name="name" value="<?php echo e(old('name')); ?>"
                                    placeholder="<?php echo e(dynamic_lang('full_name')); ?>">
                                <i class="fa-regular fa-user"></i>
                                <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span style="color:red"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="checkout_form_group">
                                <label><?php echo e(dynamic_lang('mobile_number')); ?> <span class="required_r">*</span></label>
                                <input type="number" name="mobile_no" value="<?php echo e(old('mobile_no')); ?>"
                                    placeholder="<?php echo e(dynamic_lang('mobile_number_placeholder')); ?>" maxlength="11"
                                    minlength="11" onkeyup="setNumber(this.value , <?php echo e($setting->incomplete_order_system); ?>)"
                                    oninput="if(this.value.length > 11) this.value = this.value.slice(0, 11);">
                                <i class="fa-solid fa-phone"></i>
                                <?php $__errorArgs = ['mobile_no'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span style="color:red"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>


                            <div class="checkout_form_group">
                                <label> <?php echo e(dynamic_lang('full_address')); ?> <span class="required_r">*</span> </label>
                                <input type="text" required name="address" value="<?php echo e(old('address')); ?>"
                                    placeholder="<?php echo e(dynamic_lang('full_address')); ?>">
                                <i class="fa-solid fa-location-dot"></i>
                                <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span style="color:red"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            
                            <input type="hidden" id="free_delivery" value="<?php echo e($has_free_delivery); ?>" name="free_delivery">
                            <input type="hidden" id="show_city_sub_city" value="<?php echo e($setting->show_city_sub_city); ?>">
                            <?php if($setting->show_city_sub_city == 1): ?>
                                <div class="checkout_form_group">
                                    <label><?php echo e(dynamic_lang('city')); ?> <span class="required_r">*</span></label>
                                    <input type="hidden" id="setInputShippingCharge" name="shipping_charge">
                                    <select id="select_city"
                                        onchange="shippingCharge(this.value, this.options[this.selectedIndex].id, <?php echo e($has_free_delivery); ?>)"
                                        name="city_id" class="checkout_form_select">
                                        <option value=""><?php echo e(dynamic_lang('select_city')); ?></option>
                                        <?php $__currentLoopData = $cities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $city): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($city->id); ?>" id="<?php echo e($city->delivery_charge); ?>">
                                                <?php echo e($city->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <?php $__errorArgs = ['shipping_charge_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span style="color:red"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="checkout_form_group">
                                    <label><?php echo e(dynamic_lang('sub_city')); ?> <span class="required_r">*</span></label>
                                    <select id="subcity" name="subcity_id" class="checkout_form_select"
                                        onchange="updateShippingChargeBySubcity(this.value)">
                                        <option value=""><?php echo e(dynamic_lang('select_sub_city')); ?></option>
                                    </select>
                                    <?php $__errorArgs = ['subcity'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span style="color:red"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            <?php else: ?>
                                <div class="checkout_form_checkbox_group">
                                    <h4><?php echo e(dynamic_lang('delivery_area')); ?> <span class="required_r">*</span></h4>
                                    <div class="checkout_form_checkbox_group_box">
                                        <?php $__currentLoopData = $delivery_charges; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $delivery_charge): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="checkout_form_checkbox form-check">
                                            <input required class="form-check-input"
                                                value="<?php echo e($delivery_charge->delivery_charge); ?>"
                                                <?php if($index === 0): ?> checked <?php endif; ?>
                                                onclick="shippingChargeBySelectArea(this.id , <?php echo e($delivery_charge->delivery_charge); ?>, <?php echo e($has_free_delivery); ?>)"
                                                type="radio" name="shipping_charge" id="<?php echo e($delivery_charge->id); ?>"
                                                <?php echo e(old('shipping_charge') == $delivery_charge->id ? 'checked' : ''); ?>>

                                            <label class="form-check-label" for="<?php echo e($delivery_charge->id); ?>">
                                                <?php echo e($delivery_charge->name); ?>

                                            </label>
                                        </div>
                                        <?php $__errorArgs = ['shipping_charge'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span style="color:red"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            <?php endif; ?>
                           
                            <?php if($setting->show_checkout_note == 1): ?>
                                <div class="checkout_form_group">
                                    <label><?php echo e(dynamic_lang('delivery_note')); ?> <span class="required_r">*</span></label>
                                    <input type="text" name="note" value="<?php echo e(old('note')); ?>"
                                        placeholder="<?php echo e(dynamic_lang('delivery_note')); ?>">
                                    <i class="fa-regular fa-comment"></i>
                                </div>
                            <?php endif; ?>
                            <?php if($setting->bkash_active == 1): ?>
                                <div class="payment_methods_img">
                                    <ul>
                                        <input type="hidden" id="set_payment" name="payment" value="0">
                                        <li class="active_payment" onclick="setOnlinePayment(0)">
                                            <!-- First image is active by default -->
                                            <div class="payment_images">
                                                <img src="<?php echo e(asset('frontend')); ?>/images/check_payment_img/payment-image1.jpg"
                                                    alt="Payment Images">
                                            </div>
                                        </li>
                                        <li onclick="setOnlinePayment(1)">
                                            <div class="payment_images">
                                                <img src="<?php echo e(asset('frontend')); ?>/images/check_payment_img/payment-image2.jpg"
                                                    alt="Payment Images">
                                            </div>
                                        </li>
                                    </ul>
                                </div>
                            <?php else: ?>
                                <input type="hidden" id="set_payment" name="payment" value="0">
                            <?php endif; ?>
                            <div class="checkout_form_btn">
                                <button id="order_form_submit" class="checkout_form_btn_link">
                                    <i class="fa-solid fa-cart-shopping"></i>
                                    <?php echo e(dynamic_lang('order_submit')); ?>

                                </button>
                            </div>

                            
                            <div class="modal fade" id="checkout_otp_modal">
                                <div class="modal-dialog modal-dialog-centered">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h1 class="modal-title fs-5" id="exampleModalLabel">OTP VERIFICATION</h1>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                aria-label="Close"></button>
                                        </div>
                                        <div class="modal-body">
                                            <p>
                                                We've sent an OTP to your mobile number
                                                <span class="text-danger fw-bold">
                                                    01600000000
                                                </span>
                                                <br>
                                                Please enter it below:
                                            </p>
                                            <form>
                                                <div class="checkout_otp_input_field">
                                                    <label for="otp">OTP Code: </label>
                                                    <input type="text" class="form-control" id="otp"
                                                        name="otp" placeholder="Enter 6-digit OTP" required>
                                                    <p class="text-danger" style="display: none">Please enter a valid
                                                        6-digit OTP</p>
                                                </div>
                                                <div class="text-center">
                                                    <button type="button" id="resendOtp" class="btn btn-link p-0"
                                                        disabled>Resend OTP</button>
                                                    <span id="countdown" class="text-muted ms-2">(Resend in 60s)</span>
                                                </div>
                                                <button type="submit" class="checkout_otp_modal_button">Verify &amp;
                                                    Place Order</button>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            

                        </div>
                    </div>
                    <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-12 col-12">
                        <div class="checkout_order_summary">
                            <?php if($site_configurations->coupon == 1): ?>
                                <div class="apply_coupon_group">
                                    <input type="hidden" id="coupon_amount" name="coupon_amount">
                                    <div class="apply_coupon_item">
                                        <input type="text" id="coupon_name" name="coupon" placeholder="Coupon Code">
                                        <a id="coupon_apply" class="apply_coupon_item_link">Apply</a>
                                    </div>
                                    <span id="coupon_valid" style="color: green;display:none">Congratulations. This Coupon is
                                        Valid.</span>
                                    <span id="coupon_invalid" style="color: red;display:none">Oops Sorry!. This Coupon is
                                        Invalid.</span>
                                </div>
                            <?php endif; ?>
                            
                            <div class="order_summary_table">
                                <table>
                                    <thead>
                                        <tr>
                                            <th class="checkout_product_td_left">Product</th>
                                            <th class="checkout_product_th_qty">Quantity</th>
                                            <th class="checkout_product_th_price">Price</th>
                                            <th class="checkout_product_th_total_price">Total Price</th>
                                            <th class="checkout_product_td_right">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody id="check_out_carts">
                                    <tbody>

                                    </tbody>
                                </table>
                            </div>
                            <div>
                                <div class="price_summary_table_cell">
                                    <strong>Sub Total :</strong>
                                    <input id="cart_sub_total" type="hidden" value="<?php echo e($cart_sub_total); ?>">
                                    <strong id="show_cart_sub_total"><?php echo e($cart_sub_total); ?> TK</strong>
                                </div>
                                <div class="price_summary_table_cell">
                                    <strong>Shipping Charge :</strong>
                                    <?php if($has_free_delivery == 1): ?>
                                        <strong>0 TK</strong>
                                    <?php else: ?>
                                        <strong id="show_shipping_charge">00 TK</strong>
                                    <?php endif; ?>
                                </div>
                                <div class="price_summary_table_cell">
                                    <strong>Discount Amount :</strong>
                                    <strong id="show_discount">00 TK</strong>
                                </div>
                                <div class="price_summary_table_cell">
                                    <strong class="price_payable_amount_text">Payable Amount :</strong>
                                    <strong class="price_payable_amount_text" id="show_payable">00 TK</strong>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </form>

    </section>
    <!--============ Checkout Area End ============-->

<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Code to execute when the DOM is fully loaded
            function handleWindowLoad() {
                console.log('Window loading has ended.');
                gtmCartItemsEvent('begin_checkout');
                window.removeEventListener('load', handleWindowLoad);
            }

            window.addEventListener('load', handleWindowLoad, {
                once: true
            });

            // Other JavaScript functionality
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/stylzbd/public_html/resources/views/frontend/pages/checkout/template1.blade.php ENDPATH**/ ?>