<div class="product_card">
    <div class="product_image" style="aspect-ratio:<?php echo e($site_configurations->image_aspect_ratio); ?>">
        <a href="<?php echo e(route('single.product', $product->slug)); ?>">
            <img src="<?php echo e(asset('storage/' . $product->thumbnail_img)); ?>" alt="<?php echo e($product->name); ?>">
        </a>

        <?php if($product->discount): ?>
            <div class="product_discount">
                <span><?php echo e(getProductDiscountPrice($product->price, $product->sale_price)); ?>%</span>
            </div>
        <?php endif; ?>




        <?php if($product->is_free_delivery == 1): ?>
            <div class="fee_delivery">
                <span><?php echo e(dynamic_lang('free_delivery')); ?></span>
            </div>
        <?php endif; ?>

    </div>
    <div class="product_content">
        <div class="product_name">
            <a href="<?php echo e(route('single.product', $product->slug)); ?>" class="product_name_link"><?php echo e($product->name); ?></a>
        </div>
        <div class="product_price">
            <span class="product_new_price"><?php echo e($product->sale_price); ?> TK</span>
            <?php if($product->price > $product->sale_price): ?>
                <span class="product_discount_price"><?php echo e($product->price); ?> TK</span>
            <?php endif; ?>
        </div>
        <?php if($product->stock <= 0 && $site_configurations->show_stock_out == 1): ?>
            <div class="product_btn">
                <a class="button_disable_add_to_cart">
                    <i class="fa-solid fa-cart-shopping"></i>
                    <?php echo e(dynamic_lang('stock_out')); ?>

                </a>
            </div>
        <?php else: ?>
            <div class="product_btn">
                <a href="<?php echo e(route('single.product', $product->slug)); ?>" class="product_btn_link"><?php echo e(dynamic_lang('order_now')); ?></a>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php /**PATH /home/stylzbd/public_html/resources/views/frontend/components/product_content/template1.blade.php ENDPATH**/ ?>