<?php
    $condition = '';
    if (today()->diffindays($product->created_at) < 14) {
        $condition = 'new';
    } else {
        $condition = 'in-stock';
    }

    $total_product_review = $total_review;
    $total_review = $total_review ? $total_review : 1;
    $variand_count = count($product->productVariant);
    $hasVideo = !empty($product->video_url);

    $template = 'template' . $site_configurations->template_id;
?>

<?php $__env->startSection('title', $product->name . ' || ' . $product->product_code); ?>
<?php $__env->startSection('meta_title', $product->meta_title); ?>
<?php $__env->startSection('meta_description', $product->meta_description); ?>
<?php $__env->startSection('meta_key', $product->meta_key); ?>
<?php $__env->startSection('meta_content', $product->meta_content); ?>
<?php $__env->startPush('facebook_open_graph'); ?>
    <meta property="og:type" content="product">
    <meta property="og:title" content="<?php echo e(Str::substr($product->name, 0, 65)); ?>">
    <meta property="og:description" content="<?php echo e($product->meta_description ?? 'n/a'); ?>">
    <meta property="og:url" content="<?php echo e(route('single.product', $product->slug)); ?>">
    <meta property="og:image" content="<?php echo e(asset('storage/' . $product->productImage[0]['image'])); ?>">
    <meta property="product:brand" content="<?php echo e(request()->getHost()); ?>">
    <meta property="product:availability" content="in stock">
    <meta property="product:condition" content="new">
    <meta property="product:price:amount" content="<?php echo e($product->sale_price); ?>">
    <meta property="product:price:currency" content="BDT">
    <meta property="product:id" content="<?php echo e($product->product_code); ?>">
    <meta property="product:item_group_id" content="<?php echo e($product->product_code); ?>">
    <meta property="product:retailer_item_id" content="<?php echo e($product->product_code); ?>">
<?php $__env->stopPush(); ?>


<?php $__env->startSection('content'); ?>
    <!--============ Single Product Area Start ============-->
    <section class="single_product_area section_padding">
        <div class="container">
            <div class="row gy-sm-4 gx-sm-4 gy-4 gx-2">
                <div class="col-xxl-4 col-xl-4 col-lg-6 col-md-12 col-sm-12 col-12">
                    <div class="zooming_image_content">
                        <div id="video-url" data-url="<?php echo e($product->video_url); ?>"></div>
                        <div class="youtube_video" id="youtube_video">
                            <?php if(!empty($product->video_url)): ?>
                                <iframe id="videoFrame" scrolling="no" width="100%" height="100%"
                                    style='aspect-ratio:<?php echo e($site_configurations->image_aspect_ratio); ?>'
                                    src="<?php echo e($product->video_url); ?>?enablejsapi=1&autoplay=1&mute=1"
                                    title="YouTube video player" frameborder="0"
                                    allow="accelerometer; autoplay; encrypted-media; gyroscope;" allowfullscreen>
                                </iframe>
                            <?php endif; ?>
                        </div>

                        <div class="zoom_img_active owl-carousel">
                            <?php $__currentLoopData = $product->productImage; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <a data-fancybox="gallery" href="<?php echo e(asset('storage/' . $image->image)); ?>"
                                    data-dot="
                                        <?php if($hasVideo): ?> <div class='video_icon_overlay_content' style='position: relative; display: inline-block;'>
                                            <?php if($index == 0): ?>
                                            <span class='video_icon_overlay' onClick='showVideo(<?php echo e($image->id); ?>)'></span> <?php endif; ?>
                                        </div>
                                        <?php endif; ?>
                                        <img src='<?php echo e(asset('storage/' . $image->image)); ?>' 
                                            onClick='showImg(<?php echo e($image->id); ?>)' style='aspect-ratio:<?php echo e($site_configurations->image_aspect_ratio); ?>'>
                                    "
                                    style="display: none;" id="main_image_<?php echo e($image->id); ?>" class="zooming_show_image">
                                    <div class="project-picture" id="<?php echo e($image->id); ?>">
                                        <img src="<?php echo e(asset('storage/' . $image->image)); ?>" alt=""
                                            style="aspect-ratio:<?php echo e($site_configurations->image_aspect_ratio); ?>">
                                        <div class="click_zoom_arror">
                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none"
                                                stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                                stroke-linejoin="round" class="feather feather-maximize-2">
                                                <polyline points="15 3 21 3 21 9"></polyline>
                                                <polyline points="9 21 3 21 3 15"></polyline>
                                                <line x1="21" y1="3" x2="14" y2="10"></line>
                                                <line x1="3" y1="21" x2="10" y2="14"></line>
                                            </svg>
                                        </div>
                                    </div>
                                </a>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>

                <div class="col-xxl-4 col-xl-4 col-lg-6 col-md-12 col-sm-12 col-12">
                    <div class="single_product_details">
                        <div class="single_product_list d-lg-block d-none">
                            <ul>
                                <li>
                                    <a href="<?php echo e(route('root')); ?>" class="single_product_list_link">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="13" height="14"
                                            viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                                            stroke-linecap="round" stroke-linejoin="round" class="feather feather-home">
                                            <path d="M3 9l9-7 9 7v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"></path>
                                            <polyline points="9 22 9 12 15 12 15 22"></polyline>
                                        </svg>
                                    </a>
                                </li>
                                <li>
                                    <a href="<?php echo e(route('product.category', [@$product->category->slug])); ?>"
                                        class="single_product_list_link">
                                        <?php echo e(@$product->category->name); ?>

                                    </a>
                                </li>
                                <?php if(isset($product->subCategory)): ?>
                                    <li>
                                        <a href="<?php echo e(route('product.category', [@$product->category->slug, @$product->subCategory->slug])); ?>"
                                            class="single_product_list_link">
                                            <?php echo e(@$product->subCategory->name); ?>

                                        </a>
                                    </li>
                                <?php endif; ?>
                                <?php if(isset($product->subSubCategory)): ?>
                                    <li>
                                        <a href="<?php echo e(route('product.category', [@$product->category->slug, @$product->subCategory->slug, @$product->subSubCategory->slug])); ?>"
                                            class="single_product_list_link">
                                            <?php echo e(@$product->subSubCategory->name); ?>

                                        </a>
                                    </li>
                                <?php endif; ?>
                            </ul>
                        </div>
                        <div class="single_product_name">
                            <input type="hidden" id="product_id" value="<?php echo e($product->id); ?>">
                            <input type="hidden" id="product_stock" value="<?php echo e($product->stock); ?>">
                            <h2><?php echo e($product->name); ?> - <span><?php echo e($product->product_code); ?></span></h2>
                        </div>
                        
                        
                        <div class="single_product_attribute s_p_price">
                            <strong>Price:</strong>
                            <div class="single_product_price">

                                <span class="single_product_new_price" id="variant_wise_price"><?php echo e($product->sale_price); ?>

                                    TK</span>
                                <?php if($product->price > $product->sale_price): ?>
                                    <span class="single_product_discount_price sigle_discount_text"><?php echo e($product->price); ?>

                                        TK</span>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php if($product->stock > 0 || $site_configurations->show_stock_out != 1): ?>
                            <?php if($variand_count > 0): ?>
                                <?php $__currentLoopData = $attributes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attribute_id => $attribute_name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($product->productVariant->contains('attribute_id', $attribute_id)): ?>
                                        <div class="select_attribute_container s_p_select">
                                            <strong class="single_product_attribute_label">Select
                                                <?php echo e($attribute_name); ?>: </strong>
                                            <div class="single_product_attribute">
                                                <div class="single_product_size_checkbox_list"
                                                    id="product_variant_<?php echo e(strtolower($attribute_name)); ?>">
                                                    <ul>
                                                        <?php
                                                            $sizeOrder = [
                                                                '26',
                                                                '27',
                                                                '28',
                                                                '29',
                                                                '30',
                                                                '31',
                                                                '32',
                                                                '33',
                                                                '34',
                                                                '35',
                                                                '36',
                                                                '37',
                                                                '38',
                                                                '39',
                                                                '40',
                                                                '41',
                                                                '42',
                                                                '43',
                                                                '44',
                                                                'XXS',
                                                                'XS',
                                                                'S',
                                                                'M',
                                                                'L',
                                                                'XL',
                                                                'XXL',
                                                                '2XL',
                                                                '3XL',
                                                                '4XL',
                                                                '5XL',
                                                            ];

                                                            $sortedVariants = $product->productVariant
                                                                ->where('attribute_id', $attribute_id)
                                                                ->sortBy(function ($variant) use ($sizeOrder) {
                                                                    return array_search(
                                                                        $variant->variant->name,
                                                                        $sizeOrder,
                                                                    ) !== false
                                                                        ? array_search(
                                                                            $variant->variant->name,
                                                                            $sizeOrder,
                                                                        )
                                                                        : 999;
                                                                });
                                                        ?>

                                                        <?php $__currentLoopData = $sortedVariants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $variant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <?php
                                                                $isInStock = $variant->stock > 0;

                                                                // Central control:
                                                                // - If variant_wise_stock is OFF (0), always allow selection
                                                                // - If variant_wise_stock is ON (1):
                                                                //      - If variant_stock_active is ON and stock <= 0 => disable
                                                                //      - Otherwise allow
                                                                $disableVariant = false;

                                                                if ($site_configurations->variant_wise_stock == 1) {
                                                                    $disableVariant =
                                                                        $site_configurations->variant_stock_active ==
                                                                            1 && !$isInStock;
                                                                }
                                                            ?>

                                                            <li>
                                                                <div
                                                                    class="single_product_size_checkbox_list_group variant">
                                                                    <input type="radio"
                                                                        name="variant<?php echo e($attribute_name); ?>"
                                                                        value="<?php echo e($variant->variant->name); ?>"
                                                                        data-variant-image="<?php echo e($variant->image); ?>"
                                                                        onclick="getVariant(
                                                                            <?php echo e(json_encode($variant->id)); ?>, 
                                                                            <?php echo e(json_encode($variant->price)); ?>, 
                                                                            <?php echo e(json_encode($product->sale_price)); ?>, 
                                                                            <?php echo e(json_encode($variant->stock)); ?>

                                                                        );

                                                                        showVariantImage(this)"
                                                                        id="<?php echo e($variant->variant->name . $variant->variant->id); ?>"
                                                                        <?php if($disableVariant): ?> disabled <?php endif; ?>>
                                                                    <label
                                                                        for="<?php echo e($variant->variant->name . $variant->variant->id); ?>"
                                                                        <?php if($disableVariant): ?> style="opacity:0.5; cursor:not-allowed;" title="Out of stock" <?php endif; ?>
                                                                        class="label_img_container">
                                                                        <?php if(!empty($variant->image)): ?>
                                                                            <div class="label_img">
                                                                                <img src="<?php echo e(asset('storage/' . $variant->image)); ?>"
                                                                                    alt="<?php echo e($variant->variant->name); ?>">
                                                                            </div>
                                                                        <?php endif; ?>
                                                                        <div class="title">
                                                                            <b><?php echo e($variant->variant->name); ?></b>
                                                                        </div>
                                                                    </label>
                                                                </div>
                                                            </li>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        <?php if(isset($product->size_chart)): ?>
                                                            <div class="size_chart" data-bs-target="#sizeChart"
                                                                onclick="showBanner()">
                                                                <b>Size Chart</b>
                                                            </div>

                                                            <div id="fixed_banner_container" style="display: none;"
                                                                onclick="closeBanner(event)"">
                                                                <div class="fixed_banner_img_with_closeIcon">
                                                                    <img src="<?php echo e(asset('storage/' . $product->size_chart)); ?>"
                                                                        alt="fixed-banner" />
                                                                    <svg onclick="closeBanner(event)" viewBox="0 0 24 24"
                                                                        width="28" height="28"
                                                                        stroke="currentColor" stroke-width="2"
                                                                        fill="none" stroke-linecap="round"
                                                                        stroke-linejoin="round" class="css-i6dzq1">
                                                                        <line x1="18" y1="6"
                                                                            x2="6" y2="18"></line>
                                                                        <line x1="6" y1="6"
                                                                            x2="18" y2="18"></line>
                                                                    </svg>
                                                                </div>
                                                            </div>
                                                        <?php endif; ?>


                                                        



                                                        
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        <?php endif; ?>
                        <?php if($product->stock <= 0 && $site_configurations->show_stock_out == 1): ?>
                            <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-6 col-sm-6 col-6 mt-3">
                                <a href="#" disabled class="button_disable_add_to_cart">
                                    <i class="fa-solid fa-cart-shopping"></i>
                                    Out of stock
                                </a>
                            </div>
                        <?php else: ?>
                            <div class="single_product_qty_with_buy_now_btn">
                                <div class="row gx-md-3 gy-md-3 gx-2 gy-2">
                                    <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-4 col-sm-4 col-5">
                                        <div class="single_product_attribute">
                                            <strong class="s_p_qty">Qty: </strong>
                                            <div class="single_product_qty">
                                                <div class="single_product_qty_btn_minus">
                                                    <button type="button" onclick="decrement()"
                                                        class="single_product_qty_minus">
                                                        <i class="fa-solid fa-minus"></i>
                                                    </button>
                                                </div>
                                                <input class="product_qty" type="text" value="1" min="1"
                                                    max="<?php echo e($product->stock); ?>">
                                                <div class="single_product_qty_btn_minus">
                                                    <button type="button" onclick="Increment()"
                                                        class="single_product_qty_plus">
                                                        <i class="fa-solid fa-plus"></i>
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-xxl-10 col-xl-10 col-lg-10 col-md-6 col-sm-6 col-5">
                                        <button type="button" id="<?php echo e($product->id); ?>"
                                            data-variant="<?php echo e($variand_count); ?>" class="single_product_add_to_cart"
                                            onclick="addToCard(event, this.id, this.getAttribute('data-variant'))">
                                            <i class="fa-solid fa-cart-shopping"></i>
                                            <?php echo e(dynamic_lang('add_to_cart')); ?>

                                        </button>
                                    </div>
                                    <div class="col-xxl-2 col-xl-2 col-lg-2 col-md-2 col-sm-2 col-2">
                                        <button class="single_product_add_to_wishlist" id="<?php echo e($product->id); ?>"
                                            data-variant="<?php echo e($variand_count); ?>" onclick="addToWishList(this.id)">
                                            <i class="fa-regular fa-heart"></i>
                                        </button>
                                    </div>
                                    <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                        <div class="single_product_buy_now_btn">
                                            <form id="buyNowForm" action="<?php echo e(route('buy.now')); ?>" method="POST">
                                                <?php echo csrf_field(); ?>
                                                <input type="hidden" name="product_id" id="form_product_id"
                                                    value="">
                                                <input type="hidden" name="quantity" id="form_quantity" value="">
                                                <!-- Dynamic variant inputs will be appended here -->
                                                <a href="#" id="<?php echo e($product->id); ?>"
                                                    data-variant="<?php echo e($variand_count); ?>"
                                                    onclick="submitBuyNowForm(this.id, this.getAttribute('data-variant'), event)"
                                                    class="single_product_buy_now_btn_link cart_check_out">
                                                    <?php echo e(dynamic_lang('order_now')); ?>

                                                    <i class="fa-solid fa-check"></i>
                                                </a>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>



                        <div class="contact_us_container">
                            <a href="tel:<?php echo e($general_settings->header_contact_number); ?>"
                                class="call_contact_us call_whats">
                                <div class="call_icon">
                                    <i class="fa-solid fa-phone"></i>
                                </div>
                                <div class="contact_des">
                                    <h5><?php echo e(dynamic_lang('call_text')); ?></h5>
                                    <h6>
                                        <?php echo e($general_settings->header_contact_number); ?>

                                    </h6>
                                </div>

                                <div class="status-badge message_badge"></div>
                            </a>
                            <a href="https://wa.me/+88<?php echo e($general_settings->whatsapp_number); ?>" id="whatsappLink"
                                class="call_contact_us call_whats">
                                <div class="whats_up">
                                    <i class="fa-brands fa-whatsapp"></i>
                                </div>
                                <div class="contact_des">
                                    <h5><?php echo e(dynamic_lang('whatsapp_text')); ?></h5>
                                    <h6>
                                        <?php echo e($general_settings->whatsapp_number); ?>

                                    </h6>
                                </div>

                                <div class="status-badge whats_badge"></div>
                            </a>
                        </div>



                    </div>
                </div>
                <div class="col-xxl-4 col-xl-4 col-lg-12 col-md-12 col-sm-12 col-12">
                    <div class="single_product_specification_content">
                        <div class="single_product_specification_list">
                            <ul>
                                <li>
                                    <i class="fa-solid fa-check"></i>
                                    <?php echo e(dynamic_lang('delivery_time')); ?>

                                </li>
                                <li>
                                    <i class="fa-solid fa-thumbs-up"></i>
                                    Quality Product
                                </li>
                                <li>
                                    <i class="fa-solid fa-handshake"></i>
                                    Cash On Delivery Available
                                </li>
                                <?php if(count($delivery_charges) > 0): ?>
                                    <?php $__currentLoopData = $delivery_charges; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $delivery_charge): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li>
                                            <i class="fa-solid fa-truck-fast"></i>
                                            Delivery Charge <?php echo e($delivery_charge->name); ?>

                                            <?php echo e($delivery_charge->delivery_charge); ?> TK
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </ul>
                        </div>
                        <div class="single_product_call_details">
                            <div class="single_product_call_title">
                                <p>Have question about this product ? please call</p>
                            </div>
                            <div class="single_product_call">
                                <ul>
                                    <li>
                                        <a href="tel:<?php echo e($general_settings->header_contact_number); ?>"
                                            class="single_product_call_link">
                                            <div class="single_product_call_content">
                                                <i class="fa-solid fa-phone"></i>
                                                <?php if(!empty($general_settings->header_contact_number)): ?>
                                                    <?php echo e($general_settings->header_contact_number); ?>

                                                <?php endif; ?>
                                            </div>
                                        </a>
                                    </li>
                                    <li>
                                        <a href="tel:<?php echo e($general_settings->header_contact_number_two); ?>"
                                            class="single_product_call_link">
                                            <div class="single_product_call_content">
                                                <i class="fa-solid fa-phone"></i>
                                                <?php if(!empty($general_settings->header_contact_number_two)): ?>
                                                    <?php echo e($general_settings->header_contact_number_two); ?>

                                                <?php endif; ?>
                                            </div>
                                            <div class="single_product_call_payment_method">
                                                <p>Bkash Personal</p>
                                            </div>
                                        </a>
                                    </li>
                                    <li>
                                        <a href="tel:<?php echo e($general_settings->header_contact_number_three); ?>"
                                            class="single_product_call_link">
                                            <div class="single_product_call_content">
                                                <i class="fa-solid fa-phone"></i>
                                                <?php echo e($general_settings->header_contact_number_three); ?>

                                            </div>
                                            <div class="single_product_call_payment_method nagad_payment_btn">
                                                <p>Nagad Personal</p>
                                            </div>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--============ Single Product Area End ============-->

    <!--============ Single Product Tab Area Start ============-->
    <div class="single_product_tab_area section_padding_bottom">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <div class="single_product_tab">
                        <ul class="nav nav-tabs single_product_tab_nav" id="myTab" role="tablist">
                            <li class="nav-item single_product_tab_nav_item" role="presentation">
                                <button class="nav-link single_product_tab_nav_link active" id="home-tab"
                                    data-bs-toggle="tab" data-bs-target="#home" type="button" role="tab"
                                    aria-controls="home" aria-selected="true">
                                    Description
                                </button>
                            </li>
                            <li class="nav-item single_product_tab_nav_item" role="presentation">
                                <button class="nav-link single_product_tab_nav_link" id="profile-tab"
                                    data-bs-toggle="tab" data-bs-target="#profile" type="button" role="tab"
                                    aria-controls="profile" aria-selected="false">
                                    DELIVERY OPTIONS
                                </button>
                            </li>
                            <li class="nav-item single_product_tab_nav_item" role="presentation">
                                <button class="nav-link single_product_tab_nav_link" id="contact-tab"
                                    data-bs-toggle="tab" data-bs-target="#contact" type="button" role="tab"
                                    aria-controls="contact" aria-selected="false">
                                    Reviews
                                </button>
                            </li>
                        </ul>
                        <div class="tab-content" id="myTabContent">
                            <div class="tab-pane fade show active" id="home" role="tabpanel"
                                aria-labelledby="home-tab">
                                <div class="single_product_tab_content">
                                    
                                    <?php echo $product->details; ?>

                                    
                                </div>
                            </div>
                            <div class="tab-pane fade" id="profile" role="tabpanel" aria-labelledby="profile-tab">
                                <div class="single_product_tab_content">
                                    <div class="single_product_tab_list">
                                        <ul>
                                            <li>
                                                Select number of product you want to buy.
                                            </li>
                                            <li>
                                                Click <strong>Add To Cart</strong> Button
                                            </li>
                                            <li>
                                                Then go to checkout page
                                            </li>
                                            <li>
                                                If you are a new customer, please click on Sign Up.provide us your valid
                                                information information.
                                            </li>
                                            <li>
                                                Complete your checkout, we received your order, and for order confirmation
                                                or customer service contact with you
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="contact" role="tabpanel" aria-labelledby="contact-tab">
                                <div class="single_product_tab_content">
                                    <div class="customer_comment_area section_padding_bottom">
                                        <div class="row">
                                            <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                                <div class="section_title text-center">
                                                    <h2>Reviews</h2>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="section_top_space">
                                            <div class="row gy-4 gx-4">

                                                <div class="col-xxl-3 col-xl-4 col-lg-12 col-md-12 col-sm-12 col-12">
                                                    <div class="customer_comment_title">
                                                        <span
                                                            class="customer_comment_avarage_rating"><?php echo e($product->avg_review ?? 0); ?></span>
                                                        <span class="customer_comment_rating_name">
                                                            
                                                            Reviews
                                                        </span>
                                                    </div>
                                                    <?php
                                                        $fullStars = floor($product->avg_review); // Full stars
                                                        $halfStar =
                                                            $product->avg_review - $fullStars >= 0.5 ? true : false; // Half star check
                                                    ?>

                                                    <div class="customer_comment_rating">
                                                        <?php for($i = 1; $i <= $fullStars; $i++): ?>
                                                            <span>
                                                                <i class="fa-solid fa-star"></i>
                                                            </span>
                                                        <?php endfor; ?>

                                                        <?php if($halfStar): ?>
                                                            <span>
                                                                <i class="fa-solid fa-star-half-stroke"></i>
                                                            </span>
                                                        <?php endif; ?>

                                                        
                                                        
                                                    </div>

                                                    <div class="customer_comment_rating_count">
                                                        <span><?php echo e(number_format($total_product_review)); ?> reviews</span>
                                                    </div>
                                                </div>

                                                <?php
                                                    $ratings = [
                                                        'five_star' => 5,
                                                        'four_star' => 4,
                                                        'three_star' => 3,
                                                        'two_star' => 2,
                                                        'one_star' => 1,
                                                    ];
                                                ?>

                                                <div class="col-xxl-5 col-xl-5 col-lg-12 col-md-12 col-sm-12 col-12">
                                                    <?php $__currentLoopData = $ratings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ratingKey => $starCount): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <div class="customer_comment_item">
                                                            <div class="customer_comment_item_star">
                                                                <?php for($i = 1; $i <= 5; $i++): ?>
                                                                    <span>
                                                                        <i
                                                                            class="fa-<?php echo e($i <= $starCount ? 'solid' : 'regular'); ?> fa-star"></i>
                                                                    </span>
                                                                <?php endfor; ?>
                                                            </div>
                                                            <div class="customer_comment_item_percentage_segment">
                                                                <span
                                                                    style="width: <?php echo e(number_format(($product->rating_stars[$ratingKey] / $total_review) * 100, 2)); ?>%;"></span>
                                                            </div>
                                                            <div class="customer_comment_item_percentage">
                                                                <span><?php echo e(number_format(($product->rating_stars[$ratingKey] / $total_review) * 100, 2)); ?>%</span>
                                                            </div>
                                                        </div>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </div>

                                                <div class="col-xxl-3 col-xl-3 col-lg-12 col-md-12 col-sm-12 col-12">
                                                    <div class="customer_comment_btn">
                                                        <button class="customer_comment_btn_link" data-bs-toggle="modal"
                                                            data-product_slug="<?php echo e($product->slug); ?>"
                                                            data-bs-target="#staticBackdrop">
                                                            <i class="fa-regular fa-pen-to-square"></i>
                                                            Write a Review
                                                        </button>
                                                    </div>
                                                </div>

                                                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                                    <div class="customer_comment_review_content">
                                                        <div class="customer_comment_list">
                                                            <ul>
                                                                <?php $__currentLoopData = $product_reviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $review): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <li>
                                                                        <div class="comment_customer_content">
                                                                            <div class="comment_customer_name">
                                                                                <h5><?php echo e($review->user_name); ?></h5>
                                                                            </div>
                                                                            <div class="comment_customer_rating">
                                                                                <?php for($i = 1; $i <= 5; $i++): ?>
                                                                                    <span>
                                                                                        <i
                                                                                            class="fa-<?php echo e($i <= $review->rating_stars ? 'solid' : 'regular'); ?> fa-star"></i>
                                                                                    </span>
                                                                                <?php endfor; ?>
                                                                            </div>
                                                                            <div class="customer_comment_details">
                                                                                <p><?php echo e($review->review); ?></p>
                                                                            </div>
                                                                            <?php if($review->image): ?>
                                                                                <div class="customer_comment_image">
                                                                                    <img src="<?php echo e(asset('storage/' . $review->image)); ?>"
                                                                                        alt="<?php echo e($review->image); ?>">
                                                                                </div>
                                                                            <?php endif; ?>
                                                                        </div>
                                                                    </li>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </ul>
                                                        </div>
                                                        <div class="comments_pagination">
                                                            <?php echo e($product_reviews->links()); ?>

                                                        </div>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--============ Single Product Tab Area End ============-->

    <!--============ Related Products Area Start ============-->
    <section class="related_product_area section_padding_bottom">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <div class="section_title text-center">
                        <h2>Related Products</h2>
                    </div>
                </div>
            </div>
        </div>
        <div class="container section_top_space">
            <div class="row gy-lg-3 gx-lg-3 gy-2 gx-2">
                <?php $__currentLoopData = $related_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="<?php echo e($site_configurations->card_row); ?> col-xl-3 col-lg-4 col-md-4 col-sm-6 col-6">
                        <?php echo $__env->make("frontend.components.product_content.$template", ['product' => $product], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </div>
        </div>
    </section>
    <!--============ Related Products Area End ============-->


    <!--============ Comment Input Area Modal Start ============-->
    <div class="modal fade" id="staticBackdrop">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content modal_content">
                <div class="modal_deader">
                    <div class="modal_star">
                        <div class="modal_close" data-bs-dismiss="modal">
                            <i class="fa-solid fa-xmark"></i>
                        </div>
                        <div class="modal_star_title">
                            <h5>write your review</h5>
                        </div>

                    </div>
                </div>
                <div class="modal_body">
                    <div class="modal_comment_group">
                        <form id="review_form" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <div class="modal_rating">
                                <input type="radio" id="star1" name="rating_stars" value="5">
                                <label for="star1"></label>
                                <input type="radio" id="star2" name="rating_stars" value="4">
                                <label for="star2"></label>
                                <input type="radio" id="star3" name="rating_stars" value="3">
                                <label for="star3"></label>
                                <input type="radio" id="star4" name="rating_stars" value="2">
                                <label for="star4"></label>
                                <input type="radio" id="star5" name="rating_stars" value="1">
                                <label for="star5"></label>
                            </div>
                            <div class="modal_comment_item">
                                <input type="text" name="user_name" placeholder="customer name">
                                <?php $__errorArgs = ['user_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="is_error"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="modal_comment_item_textarea">
                                <textarea name="review" placeholder="write comment"></textarea>
                                <?php $__errorArgs = ['review'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="is_error"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="modal_comment_item">
                                <input name="image" type="file" id="image">
                                <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="is_error"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="modal_comment_item_btn">
                                <button id="review_submit" class="modal_comment_item_btn_link">Submit</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--============ Comment Input Area End ============-->

    




<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>
        function showBanner() {
            document.getElementById("fixed_banner_container").style.display = "flex";
        }

        function closeBanner() {
            if (!event.target.closest(".fixed_banner_img_with_closeIcon img")) {
                document.getElementById("fixed_banner_container").style.display =
                    "none";
            }
        }
    </script>
    <script src="https://www.youtube.com/iframe_api"></script>
    <script>
        function submitBuyNowForm(id, have_variant, event) {
            event.preventDefault();
            let variants = {};
            let missingVariant = '';

            $('input[name^="variant"]').each(function() {
                let variantName = $(this).attr('name').replace('variant',
                    '');
                if (!$(`input[name="${$(this).attr('name')}"]:checked`).val()) {

                    missingVariant = variantName;
                    return false;
                } else {

                    variants[variantName] = $(`input[name="${$(this).attr('name')}"]:checked`).val();
                }
            });

            if (missingVariant) {
                toastr.error(`Please Select ${missingVariant}`);
                return;
            }


            document.getElementById('form_product_id').value = id;
            let quantity = document.querySelector(".product_qty").value;
            document.getElementById('form_quantity').value = quantity;


            $('#buyNowForm').find('.variant-input').remove();

            for (const [variant, value] of Object.entries(variants)) {
                $('<input>')
                    .attr('type', 'hidden')
                    .attr('name', `variants[${variant}]`)
                    .attr('value', value)
                    .addClass('variant-input')
                    .appendTo('#buyNowForm');
            }

            toastr.success('Order is processing, please wait...');

            document.getElementById('buyNowForm').submit();
            missingVariant = {};
        }
    </script>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Code to execute when the DOM is fully loaded
            function handleWindowLoad() {
                console.log('Window loading has ended.');
                //call product showing events
                gtmEvent($('#product_id').val(), 'view_item', 1);
                window.removeEventListener('load', handleWindowLoad);
            }
            window.addEventListener('load', handleWindowLoad, {
                once: true
            });
        });

        function mobileSubmenu($id) {
            document.getElementById($id).classList.toggle("mobile_submenu_toggle");
        }

        function mobileSubSubmenu($id) {
            document.getElementById($id).classList.toggle("mobile_sub_submenu_toggle");
        }
    </script>
    <!-- header mobile menu js end -->

    <!-- header mobile search js start -->
    <script>
        function search() {
            document.getElementById("search_id").classList.toggle("search_toggle");
        }
    </script>
    <!-- header mobile search js end -->

    <!-- multiple category mobile menu js start -->
    <script>
        function categoryList() {
            document.getElementById("category_list_id").classList.toggle("category_list_toggle");
        }
    </script>
    <!-- multiple category mobile menu js end -->
    <script>
        document.getElementById('whatsappLink').addEventListener('click', function(event) {
            event.preventDefault(); // Prevent default action
            var whatsappNumber = '<?php echo e($general_settings->whatsapp_number); ?>';
            var pageUrl = window.location.href; // Get current page URL
            // console.log(pageUrl);
            var message = encodeURIComponent(pageUrl);
            var whatsappUrl = `https://wa.me/+88${whatsappNumber}?text=${message}`;
            // Open the WhatsApp URL in a new tab
            window.open(whatsappUrl, '_blank');
        });
    </script>
    <!-- Zooming Image Start -->
    <script>
        var player; // Reference to the YouTube player

        // Load the YouTube API
        function onYouTubeIframeAPIReady() {
            player = new YT.Player('videoFrame', {
                events: {
                    'onReady': onPlayerReady,

                }
            });
        }

        // This will be called when the player is ready
        function onPlayerReady(event) {
            // You can optionally start playing the video automatically when the player is ready
            // event.target.playVideo();
        }
        // list image start
        let clickImageList = document.querySelector('.zooming_show_image img');

        // function showImg(id) {

        //   const videoPlayer = document.getElementById("youtube_video");
        // const imagesContainer = document.getElementById(`main_image_${id}`);
        //   const imageContainers = document.querySelectorAll('.zooming_show_image');
        // Pause and hide video if it's playing
        //if (player && player.getPlayerState() === YT.PlayerState.PLAYING) {
        // player.pauseVideo();
        //}

        //   videoPlayer.style.display = "none";
        // imagesContainer.style.display = "block";
        //    if (imageContainers) {
        //       imageContainers.forEach(imageContainer => {
        //          imageContainer.style.display = 'block';
        //       });
        //    }

        //  }

        function showVariantImage(radio) {
            const variantImage = radio.getAttribute('data-variant-image');
            const videoPlayer = document.getElementById("youtube_video");
            const productImages = document.querySelectorAll('.zooming_show_image');

            // Hide video and all product images
            if (videoPlayer) videoPlayer.style.display = "none";
            productImages.forEach(img => img.style.display = "none");

            // If no variant image, just show the first default image again
            if (!variantImage) {
                if (productImages.length > 0) {
                    productImages[0].style.display = "block"; // fallback to first image
                }
                return;
            }

            // Create or update variant image container
            let variantContainer = document.getElementById('variant_image_container');
            if (!variantContainer) {
                variantContainer = document.createElement('div');
                variantContainer.id = 'variant_image_container';
                variantContainer.classList.add('zooming_show_image');
                document.querySelector('.zooming_image_content').prepend(variantContainer);
            }

            const baseUrl = "<?php echo e(asset('storage')); ?>/";
            variantContainer.innerHTML =
                `<img src="${baseUrl}${variantImage}" style="aspect-ratio:<?php echo e($site_configurations->image_aspect_ratio); ?>">`;
            variantContainer.style.display = 'block';
        }





        function showImg(id) {
            const videoPlayer = document.getElementById("youtube_video");
            const productImages = document.querySelectorAll('.zooming_show_image');

            // Hide variant container if exists
            const variantContainer = document.getElementById('variant_image_container');
            if (variantContainer) variantContainer.style.display = 'none';

            // Hide video and show all product images
            videoPlayer.style.display = "none";
            productImages.forEach(img => {
                if (!img.id.startsWith('variant_image_container')) img.style.display = 'block';
            });
        }







        function resumeVideo() {
            // Play the video when clicking on the video area again
            if (player) {
                player.playVideo();
            }
        }

        // Load the YouTube IFrame API asynchronously
        var tag = document.createElement('script');
        tag.src = "https://www.youtube.com/iframe_api";
        var firstScriptTag = document.getElementsByTagName('script')[0];
        firstScriptTag.parentNode.insertBefore(tag, firstScriptTag);

        // Attach click event to videoWrapper to resume the video
        document.getElementById('youtube_video').addEventListener('click', function() {
            resumeVideo();
        });
        // list image end
        function showVideo(id) {

            var videoPlayer = document.getElementById("youtube_video");
            const imageContainers = document.querySelectorAll('.zooming_show_image');

            // Hide images container and show video player
            if (imageContainers) {
                imageContainers.forEach(imageContainer => {
                    imageContainer.style.display = 'none';
                });
                videoPlayer.style.display = "block";
            }
        }

        document.addEventListener('DOMContentLoaded', function() {
            const videoUrlElement = document.getElementById('video-url');
            const videoPlayer = document.getElementById('youtube_video');
            const imageContainers = document.querySelectorAll('.zooming_show_image');
            const videoIframe = document.getElementById('video-iframe');

            // Get the video URL from the data attribute
            const videoUrl = videoUrlElement.getAttribute('data-url');

            if (videoUrl) {
                // Video URL is present, show video and hide images
                videoPlayer.style.display = 'block';
                imageContainers.forEach(imageContainer => {
                    imageContainer.style.display = 'none';
                });
                videoIframe.src = videoUrl;
            } else {

                videoPlayer.style.display = 'none';
                if (imageContainers.length > 0) {
                    imageContainers.forEach(img => {
                        img.style.display = 'block';
                    });
                }
            }
        });

        // zooming image start
        document.querySelectorAll('.zooming_show_image').forEach(elem => {
            let x, y, width, height;
            elem.onmouseenter = () => {
                const size = elem.getBoundingClientRect();

                x = size.x;
                y = size.y;

                width = size.width;
                height = size.height;
            };

            elem.onmousemove = e => {
                const horizontal = (e.clientX - x) / width * 100;
                const vertical = (e.clientY - y) / height * 100;

                elem.style.setProperty('--x', horizontal + '%');
                elem.style.setProperty('--y', vertical + '%');
            };
        });
        // zooming image end

        // active image start
        var zoomingImageList = document.querySelectorAll("ul li");

        zoomingImageList.forEach(i => {
            i.addEventListener("click", () => {
                resetLinks();
                i.classList.add("active");
            })
        })

        function resetLinks() {
            zoomingImageList.forEach(i => {
                i.classList.remove("active")
            })
        }
        // active image end
    </script>
    <!-- Zooming Image End -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/stylzbd/public_html/resources/views/frontend/pages/product/single_product/template1.blade.php ENDPATH**/ ?>