<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!-- Site Title -->
    <title><?php echo $__env->yieldContent('title'); ?></title>
    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <!--Base URL -->
    <meta name="base_url" content="<?php echo e(url('')); ?>">


    <!-- Place favicon.ico in the root directory -->
    <link rel="shortcut icon" href="<?php echo e(asset('storage/' . $general_settings->icon)); ?>" type="image/x-icon" />
    <!-- Bootstrap -->
    <link rel="stylesheet" href="<?php echo e(asset('frontend')); ?>/css/bootstrap.min.css">
    <!-- Font Awesome icon -->
    <link rel="stylesheet" href="/public/frontend/css/fontawesome.min.css">
    <link rel="stylesheet" href="<?php echo e(asset('frontend')); ?>/line-awesome/css/line-awesome.min.css">
    <!--Owl Carousel -->
    <link rel="stylesheet" href="<?php echo e(asset('frontend')); ?>/css/plugin/owl.carousel.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fancyapps/ui/dist/fancybox.css" />

    <!--animate css-->
    

    <!--loadmore css-->
    <link rel="stylesheet" href="<?php echo e(asset('frontend/css/jquery.loadMore.css')); ?>">


    <!-- Toastr css -->
    <link rel="stylesheet" type="text/css"
        href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">





    <?php
    $setting = DB::table('general_settings')->latest()->first();
    $template = 'template' . $site_configurations->template_id;
    ?>

    <!-- Open Graph / Facebook -->
    


    <!-- Twitter -->
    <meta property="twitter:url" content="<?php echo e($setting->title); ?>" />
    <meta property="twitter:title" content="<?php echo e($setting->meta_content); ?>" />
    <meta property="twitter:description" content="<?php echo e($setting->meta_content); ?>" />

    <!---------------------------site meta for SEO------------------------->
    <meta name="title" content="<?php echo $__env->yieldContent('meta_title'); ?>" />
    <meta name="keywords" content="<?php echo $__env->yieldContent('meta_key'); ?>" />
    <meta name="content" content="<?php echo $__env->yieldContent('meta_content'); ?>">

    <!-- Facebook Domain Verification --->
    <?php if(!empty($setting->facebook_domain_verification)): ?>
        <?php echo $setting->facebook_domain_verification; ?>

    <?php endif; ?>
    <!-- Facebook Domain Verification End --->


    <!-- Facebook Pixel Code -->
    <?php if(!empty($setting->facebook_pixel)): ?>
        <?php echo $setting->facebook_pixel; ?>

    <?php endif; ?>
    <!-- End Facebook Pixel Code -->


    <!---------------------facebook open graph------------------------------>
    <?php echo $__env->yieldPushContent('facebook_open_graph'); ?>

    <!-- Google Domain Verification --->
    <?php if(!empty($setting->google_domain_verification)): ?>
        <?php echo $setting->google_domain_verification; ?>

    <?php endif; ?>
    <!-- Google Domain Verification End --->

    <!--================= Google tag (gtag.js) ===========================-->
    <?php if(isset($general_settings->google_analytics) && !empty($general_settings->google_analytics)): ?>
        <?php echo $general_settings->google_analytics; ?>

    <?php endif; ?>

    <?php echo $__env->make("frontend.partials.css.$template", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

</head>

<body>

    <!-- Your Chat Plugin code -->
    <?php if(!empty($setting->facebook_chat_plugin)): ?>
        <?php echo $setting->facebook_chat_plugin; ?>

    <?php endif; ?>


    <!-- Your google tag body -->
    <?php if(!empty($setting->google_body_tag)): ?>
        <?php echo $setting->google_body_tag; ?>

    <?php endif; ?>



    <!--============ Header Area Start ============-->
    <?php echo $__env->make("frontend.partials.header.$template", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!--============ Header Area End ============-->


    <div class="content">
        <?php echo $__env->yieldContent('content'); ?>
    </div>


    <!--============ Footer Area Start ============-->
    <?php echo $__env->make("frontend.partials.footer.$template", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!--============ Footer Area End ============-->

    <!--============ Fixed Footer Menu Start ============-->
    <?php if($site_configurations->template_id == 1): ?>
        <div class="fixed_footer_menu">
            <ul>
                <li>
                    <a href="<?php echo e(route('root')); ?>" class="fixed_footer_menu_link">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor"
                            stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                            class="feather feather-home">
                            <path d="M3 9l9-7 9 7v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"></path>
                            <polyline points="9 22 9 12 15 12 15 22"></polyline>
                        </svg>
                        <p class="home_text">Home</p>
                    </a>
                </li>
                <li>
                    <a href="#offcanvasMenuId" data-bs-toggle="offcanvas" class="fixed_footer_menu_link">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor"
                            stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                            class="feather feather-grid">
                            <rect x="3" y="3" width="7" height="7"></rect>
                            <rect x="14" y="3" width="7" height="7"></rect>
                            <rect x="14" y="14" width="7" height="7"></rect>
                            <rect x="3" y="14" width="7" height="7"></rect>
                        </svg>
                        <p>Category</p>
                    </a>
                </li>
                <li>
                    <a data-bs-toggle="offcanvas" href="#fixed_product_sticky_id" class="fixed_footer_menu_link">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor"
                            stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                            class="feather feather-shopping-cart">
                            <circle cx="9" cy="21" r="1"></circle>
                            <circle cx="20" cy="21" r="1"></circle>
                            <path d="M1 1h4l2.68 13.39a2 2 0 0 0 2 1.61h9.72a2 2 0 0 0 2-1.61L23 6H6"></path>
                        </svg>
                        <p>Cart</p>
                        <span class="fixed_footer_cart_count cart_item_total">0</span>
                    </a>
                </li>
                <li>
                    <a href="tel:<?php echo e($general_settings->header_contact_number); ?>" class="fixed_footer_menu_link">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor"
                            stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                            class="feather feather-phone-call">
                            <path
                                d="M15.05 5A5 5 0 0 1 19 8.95M15.05 1A9 9 0 0 1 23 8.94m-1 7.98v3a2 2 0 0 1-2.18 2 19.79 19.79 0 0 1-8.63-3.07 19.5 19.5 0 0 1-6-6 19.79 19.79 0 0 1-3.07-8.67A2 2 0 0 1 4.11 2h3a2 2 0 0 1 2 1.72 12.84 12.84 0 0 0 .7 2.81 2 2 0 0 1-.45 2.11L8.09 9.91a16 16 0 0 0 6 6l1.27-1.27a2 2 0 0 1 2.11-.45 12.84 12.84 0 0 0 2.81.7A2 2 0 0 1 22 16.92z">
                            </path>
                        </svg>
                        <p>Call</p>
                    </a>
                </li>
                <li>
                    <?php if(auth()->guard('customer')->check()): ?>
                        <a href="<?php echo e(route('user.dashboard')); ?>" class="fixed_footer_menu_link">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none"
                                stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                stroke-linejoin="round" class="feather feather-user">
                                <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path>
                                <circle cx="12" cy="7" r="4"></circle>
                            </svg>
                            <p><?php echo e(Str::words(Auth::guard('customer')->user()->name, 1, '..')); ?></p>
                        </a>
                    <?php else: ?>
                        <?php if($site_configurations->show_reseller_panel == 1): ?>
                            <a href="/reseller/user" class="fixed_footer_menu_link">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none"
                                    stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                    stroke-linejoin="round" class="feather feather-user">
                                    <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path>
                                    <circle cx="12" cy="7" r="4"></circle>
                                </svg>
                                <p>Login</p>
                            </a>
                        <?php else: ?>
                            <a href="/login" class="fixed_footer_menu_link">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none"
                                    stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                    stroke-linejoin="round" class="feather feather-user">
                                    <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path>
                                    <circle cx="12" cy="7" r="4"></circle>
                                </svg>
                                <p>Login</p>
                            </a>
                        <?php endif; ?>
                    <?php endif; ?>
                </li>
            </ul>
        </div>
    <?php endif; ?>

    <?php if($site_configurations->template_id == 2): ?>
        <div class="fixed_footer_menu">
            <ul>
                <li>
                    <a href="<?php echo e(route('root')); ?>" class="fixed_footer_menu_link">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none"
                            stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                            class="feather feather-home">
                            <path d="M3 9l9-7 9 7v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"></path>
                            <polyline points="9 22 9 12 15 12 15 22"></polyline>
                        </svg>
                        <p class="home_text">Home</p>
                    </a>
                </li>
                <li>
                    <a href="#offcanvasMenuId" data-bs-toggle="offcanvas" class="fixed_footer_menu_link">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none"
                            stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                            class="feather feather-grid">
                            <rect x="3" y="3" width="7" height="7"></rect>
                            <rect x="14" y="3" width="7" height="7"></rect>
                            <rect x="14" y="14" width="7" height="7"></rect>
                            <rect x="3" y="14" width="7" height="7"></rect>
                        </svg>
                        <p>Category</p>
                    </a>
                </li>
                <li>
                    <a data-bs-toggle="offcanvas" href="#fixed_product_sticky_id" class="fixed_footer_menu_link">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none"
                            stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                            class="feather feather-shopping-cart">
                            <circle cx="9" cy="21" r="1"></circle>
                            <circle cx="20" cy="21" r="1"></circle>
                            <path d="M1 1h4l2.68 13.39a2 2 0 0 0 2 1.61h9.72a2 2 0 0 0 2-1.61L23 6H6"></path>
                        </svg>
                        <p>Cart</p>
                        <span class="fixed_footer_cart_count cart_item_total">0</span>
                    </a>
                </li>
                <li>
                    <a href="tel:<?php echo e($general_settings->header_contact_number); ?>" class="fixed_footer_menu_link">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none"
                            stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                            class="feather feather-phone-call">
                            <path
                                d="M15.05 5A5 5 0 0 1 19 8.95M15.05 1A9 9 0 0 1 23 8.94m-1 7.98v3a2 2 0 0 1-2.18 2 19.79 19.79 0 0 1-8.63-3.07 19.5 19.5 0 0 1-6-6 19.79 19.79 0 0 1-3.07-8.67A2 2 0 0 1 4.11 2h3a2 2 0 0 1 2 1.72 12.84 12.84 0 0 0 .7 2.81 2 2 0 0 1-.45 2.11L8.09 9.91a16 16 0 0 0 6 6l1.27-1.27a2 2 0 0 1 2.11-.45 12.84 12.84 0 0 0 2.81.7A2 2 0 0 1 22 16.92z">
                            </path>
                        </svg>
                        <p>Call</p>
                    </a>
                </li>
                <li>
                    <?php if(auth()->guard('customer')->check()): ?>
                        <a href="<?php echo e(route('user.dashboard')); ?>" class="fixed_footer_menu_link">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none"
                                stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                stroke-linejoin="round" class="feather feather-user">
                                <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path>
                                <circle cx="12" cy="7" r="4"></circle>
                            </svg>
                            <p><?php echo e(Str::words(Auth::guard('customer')->user()->name, 1, '..')); ?></p>
                        </a>
                    <?php else: ?>
                        <?php if($site_configurations->show_reseller_panel == 1): ?>
                            <a href="/reseller/user" class="fixed_footer_menu_link">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none"
                                    stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                    stroke-linejoin="round" class="feather feather-user">
                                    <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path>
                                    <circle cx="12" cy="7" r="4"></circle>
                                </svg>
                                <p>Login</p>
                            </a>
                        <?php else: ?>
                            <a href="/login" class="fixed_footer_menu_link">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none"
                                    stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                    stroke-linejoin="round" class="feather feather-user">
                                    <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path>
                                    <circle cx="12" cy="7" r="4"></circle>
                                </svg>
                                <p>Login</p>
                            </a>
                        <?php endif; ?>
                    <?php endif; ?>
                </li>
            </ul>
        </div>
    <?php endif; ?>

    <?php if($site_configurations->template_id == 3): ?>
        <div class="fixed_footer_menu">
            <ul>
                <li>
                    <a href="<?php echo e(route('root')); ?>" class="fixed_footer_menu_link">
                        <i class="las la-home"></i>
                        <p class="home_text">Home</p>
                    </a>
                </li>
                <li>
                    <a href="#offcanvasMenuId" data-bs-toggle="offcanvas" class="fixed_footer_menu_link">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none"
                            stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                            class="feather feather-grid">
                            <rect x="3" y="3" width="7" height="7"></rect>
                            <rect x="14" y="3" width="7" height="7"></rect>
                            <rect x="14" y="14" width="7" height="7"></rect>
                            <rect x="3" y="14" width="7" height="7"></rect>
                        </svg>
                        <p>Category</p>
                    </a>
                </li>
                <li>
                    <a data-bs-toggle="offcanvas" href="#fixed_product_sticky_id" class="fixed_footer_menu_link">
                        <i class="las la-shopping-basket"></i>
                        <p>Cart</p>
                        <span class="fixed_footer_cart_count cart_item_total">0</span>
                    </a>
                </li>
                <li>
                    <a href="tel:<?php echo e($general_settings->header_contact_number); ?>" class="fixed_footer_menu_link">
                        <i class="las la-phone"></i>
                        <p>Call</p>
                    </a>
                </li>
                <li>
                    <?php if(auth()->guard('customer')->check()): ?>
                        <a href="<?php echo e(route('user.dashboard')); ?>" class="fixed_footer_menu_link">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none"
                                stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                stroke-linejoin="round" class="feather feather-user">
                                <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path>
                                <circle cx="12" cy="7" r="4"></circle>
                            </svg>
                            <p><?php echo e(Str::words(Auth::guard('customer')->user()->name, 1, '..')); ?></p>
                        </a>
                    <?php else: ?>
                        <?php if($site_configurations->show_reseller_panel == 1): ?>
                            <a href="/reseller/user" class="fixed_footer_menu_link">
                                <i class="las la-user"></i>
                                <p>Login</p>
                            </a>
                        <?php else: ?>
                            <a href="/login" class="fixed_footer_menu_link">
                                <i class="las la-user"></i>
                                <p>Login</p>
                            </a>
                        <?php endif; ?>

                    <?php endif; ?>
                </li>
            </ul>
        </div>
    <?php endif; ?>

    <?php if($site_configurations->template_id == 4): ?>
        <div class="fixed_footer_menu">
            <ul>
                <li>
                    <a href="<?php echo e(route('root')); ?>" class="fixed_footer_menu_link">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none"
                            stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                            class="feather feather-home">
                            <path d="M3 9l9-7 9 7v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"></path>
                            <polyline points="9 22 9 12 15 12 15 22"></polyline>
                        </svg>
                        <p class="home_text">Home</p>
                    </a>
                </li>
                <li>
                    <a href="#offcanvasMenuId" data-bs-toggle="offcanvas" class="fixed_footer_menu_link">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none"
                            stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                            class="feather feather-grid">
                            <rect x="3" y="3" width="7" height="7"></rect>
                            <rect x="14" y="3" width="7" height="7"></rect>
                            <rect x="14" y="14" width="7" height="7"></rect>
                            <rect x="3" y="14" width="7" height="7"></rect>
                        </svg>
                        <p>Category</p>
                    </a>
                </li>
                <li>
                    <a data-bs-toggle="offcanvas" href="#fixed_product_sticky_id" class="fixed_footer_menu_link">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none"
                            stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                            class="feather feather-shopping-cart">
                            <circle cx="9" cy="21" r="1"></circle>
                            <circle cx="20" cy="21" r="1"></circle>
                            <path d="M1 1h4l2.68 13.39a2 2 0 0 0 2 1.61h9.72a2 2 0 0 0 2-1.61L23 6H6"></path>
                        </svg>
                        <p>Cart</p>
                        <span class="fixed_footer_cart_count cart_item_total">0</span>
                    </a>
                </li>
                <li>
                    <a href="tel:<?php echo e($general_settings->header_contact_number); ?>" class="fixed_footer_menu_link">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none"
                            stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                            class="feather feather-phone-call">
                            <path
                                d="M15.05 5A5 5 0 0 1 19 8.95M15.05 1A9 9 0 0 1 23 8.94m-1 7.98v3a2 2 0 0 1-2.18 2 19.79 19.79 0 0 1-8.63-3.07 19.5 19.5 0 0 1-6-6 19.79 19.79 0 0 1-3.07-8.67A2 2 0 0 1 4.11 2h3a2 2 0 0 1 2 1.72 12.84 12.84 0 0 0 .7 2.81 2 2 0 0 1-.45 2.11L8.09 9.91a16 16 0 0 0 6 6l1.27-1.27a2 2 0 0 1 2.11-.45 12.84 12.84 0 0 0 2.81.7A2 2 0 0 1 22 16.92z">
                            </path>
                        </svg>
                        <p>Call</p>
                    </a>
                </li>
                <li>
                    <?php if(auth()->guard('customer')->check()): ?>
                        <a href="<?php echo e(route('user.dashboard')); ?>" class="fixed_footer_menu_link">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none"
                                stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                stroke-linejoin="round" class="feather feather-user">
                                <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path>
                                <circle cx="12" cy="7" r="4"></circle>
                            </svg>
                            <p><?php echo e(Str::words(Auth::guard('customer')->user()->name, 1, '..')); ?></p>
                        </a>
                    <?php else: ?>
                        <?php if($site_configurations->show_reseller_panel == 1): ?>
                            <a href="/reseller/user" class="fixed_footer_menu_link">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none"
                                    stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                    stroke-linejoin="round" class="feather feather-user">
                                    <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path>
                                    <circle cx="12" cy="7" r="4"></circle>
                                </svg>
                                <p>Login</p>
                            </a>
                        <?php else: ?>
                            <a href="/login" class="fixed_footer_menu_link">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none"
                                    stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                    stroke-linejoin="round" class="feather feather-user">
                                    <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path>
                                    <circle cx="12" cy="7" r="4"></circle>
                                </svg>
                                <p>Login</p>
                            </a>
                        <?php endif; ?>
                    <?php endif; ?>
                </li>
            </ul>
        </div>
    <?php endif; ?>

    <?php if($site_configurations->template_id == 5): ?>
        <div class="fixed_footer_menu">
            <ul>
                <li>
                    <a href="<?php echo e(route('root')); ?>" class="fixed_footer_menu_link fixed_footer_menu_home">
                        <i class="las la-home"></i>
                        <p class="home_text">Home</p>
                    </a>
                </li>
                <li>
                    <a class="fixed_footer_menu_link fixed_footer_menu_category mobile_menu_trigger">
                        <svg xmlns="http://www.w3.org/2000/svg" version="1.1"
                            xmlns:xlink="http://www.w3.org/1999/xlink" x="0" y="0" viewBox="0 0 32 32"
                            style="enable-background:new 0 0 512 512" xml:space="preserve" fill-rule="evenodd"
                            class="">
                            <g>
                                <path
                                    d="M15 18a1 1 0 0 0-1-1H7a1 1 0 0 0-1 1v7a1 1 0 0 0 1 1h7a1 1 0 0 0 1-1zm11 0a1 1 0 0 0-1-1h-7a1 1 0 0 0-1 1v7a1 1 0 0 0 1 1h7a1 1 0 0 0 1-1zm-13 1v5H8v-5zm11 0v5h-5v-5zm2-12a1 1 0 0 0-1-1h-7a1 1 0 0 0-1 1v7a1 1 0 0 0 1 1h7a1 1 0 0 0 1-1zM15 7a1 1 0 0 0-1-1H7a1 1 0 0 0-1 1v7a1 1 0 0 0 1 1h7a1 1 0 0 0 1-1zm9 1v5h-5V8zM13 8v5H8V8z"
                                    fill="currentColor" opacity="1" data-original="currentColor" class="">
                                </path>
                            </g>
                        </svg>
                        <p>Category</p>
                    </a>
                </li>
                
                <li>
                    <a data-bs-toggle="offcanvas" href="#fixed_product_sticky_id"
                        class="fixed_footer_menu_link fixed_footer_menu_cart">
                        <svg xmlns="http://www.w3.org/2000/svg" x="0" y="0" viewBox="0 0 13.758 13.758"
                            xml:space="preserve">
                            <path
                                d="M1.013 1.587a.265.265 0 0 0 0 .53H2.57l2.174 8.261a1.055 1.055 0 0 0 .76 1.793c.581 0 1.058-.477 1.058-1.058 0-.192-.052-.373-.143-.53h3.128a1.061 1.061 0 0 0 .914 1.587c.581.001 1.059-.476 1.059-1.057 0-.582-.478-1.06-1.06-1.06H5.207l-.244-.925h6.472c.12 0 .226-.08.256-.197L13 4.037a.265.265 0 0 0-.253-.333H3.535l-.505-1.92a.265.265 0 0 0-.256-.197zm2.662 2.647H12.4l-1.17 4.365H4.823zm2.655.991a.265.265 0 0 0-.264.265v1.852a.265.265 0 1 0 .529 0V5.49a.265.265 0 0 0-.265-.265zm1.72 0a.265.265 0 0 0-.265.265v1.852a.265.265 0 1 0 .53 0V5.49a.265.265 0 0 0-.265-.265zm1.72 0a.265.265 0 0 0-.265.265v1.852a.265.265 0 1 0 .53 0V5.49a.265.265 0 0 0-.265-.265zm-4.265 5.359c.295 0 .53.233.53.529 0 .295-.235.529-.53.529a.526.526 0 0 1-.53-.53c0-.295.235-.528.53-.528zm4.957 0c.295 0 .529.233.529.529 0 .295-.234.529-.53.529s-.526-.234-.526-.53c0-.295.231-.528.527-.528z"
                                fill="currentColor" opacity="1" data-original="currentColor"></path>
                        </svg>
                        <p>Cart</p>
                        <span class="fixed_footer_cart_count cart_item_total">0</span>
                    </a>
                </li>
                
                <li
                    <?php if(!auth()->guard('customer')->check() && !Auth::guard('reseller')->user()): ?> data-bs-toggle="modal" data-bs-target="#login_option_popup" <?php endif; ?>>
                    <?php if(auth()->guard('customer')->check()): ?>
                        <a href="<?php echo e(route('user.dashboard')); ?>"
                            class="fixed_footer_menu_link fixed_footer_menu_auth">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 490.667 490.667"
                                xml:space="preserve">
                                <path
                                    d="M10.667 448c5.888 0 10.667-4.779 10.667-10.667v-26.197C21.333 325.589 97.899 256 192 256s170.667 69.589 170.667 155.136v26.197c0 5.888 4.779 10.667 10.667 10.667S384 443.221 384 437.333v-26.197c0-80.533-59.051-148.48-139.413-169.579 32.128-18.389 54.08-52.629 54.08-92.224 0-58.816-47.851-106.667-106.667-106.667S85.333 90.517 85.333 149.333c0 39.595 21.952 73.835 54.08 92.224C59.051 262.656 0 330.603 0 411.136v26.197C0 443.221 4.779 448 10.667 448zm96-298.667C106.667 102.272 144.939 64 192 64s85.333 38.272 85.333 85.333-38.272 85.334-85.333 85.334-85.333-38.272-85.333-85.334z"
                                    fill="currentColor" fill="currentColor">
                            </svg>
                            <p><?php echo e(Str::words(Auth::guard('customer')->user()->name, 1, '..')); ?></p>
                        </a>
                    <?php elseif(Auth::guard('reseller')->user()): ?>
                        <a href="/dropshipper/dashboard" class="fixed_footer_menu_link fixed_footer_menu_auth">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 490.667 490.667"
                                xml:space="preserve">
                                <path
                                    d="M10.667 448c5.888 0 10.667-4.779 10.667-10.667v-26.197C21.333 325.589 97.899 256 192 256s170.667 69.589 170.667 155.136v26.197c0 5.888 4.779 10.667 10.667 10.667S384 443.221 384 437.333v-26.197c0-80.533-59.051-148.48-139.413-169.579 32.128-18.389 54.08-52.629 54.08-92.224 0-58.816-47.851-106.667-106.667-106.667S85.333 90.517 85.333 149.333c0 39.595 21.952 73.835 54.08 92.224C59.051 262.656 0 330.603 0 411.136v26.197C0 443.221 4.779 448 10.667 448zm96-298.667C106.667 102.272 144.939 64 192 64s85.333 38.272 85.333 85.333-38.272 85.334-85.333 85.334-85.333-38.272-85.333-85.334z"
                                    fill="currentColor" fill="currentColor">
                            </svg>
                            <p> <?php echo e(Auth::guard('reseller')->user()->name); ?></p>
                        </a>
                    <?php else: ?>
                        <a class="fixed_footer_menu_link fixed_footer_menu_auth">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 490.667 490.667"
                                xml:space="preserve">
                                <path
                                    d="M10.667 448c5.888 0 10.667-4.779 10.667-10.667v-26.197C21.333 325.589 97.899 256 192 256s170.667 69.589 170.667 155.136v26.197c0 5.888 4.779 10.667 10.667 10.667S384 443.221 384 437.333v-26.197c0-80.533-59.051-148.48-139.413-169.579 32.128-18.389 54.08-52.629 54.08-92.224 0-58.816-47.851-106.667-106.667-106.667S85.333 90.517 85.333 149.333c0 39.595 21.952 73.835 54.08 92.224C59.051 262.656 0 330.603 0 411.136v26.197C0 443.221 4.779 448 10.667 448zm96-298.667C106.667 102.272 144.939 64 192 64s85.333 38.272 85.333 85.333-38.272 85.334-85.333 85.334-85.333-38.272-85.333-85.334z"
                                    fill="currentColor" fill="currentColor">
                            </svg>
                            <p>Login</p>
                        </a>
                    <?php endif; ?>
                </li>
            </ul>
        </div>
    <?php endif; ?>

    <?php if($site_configurations->template_id == 6): ?>
        <div class="fixed_footer_menu">
            <ul>
                <li>
                    <a href="<?php echo e(route('root')); ?>" class="fixed_footer_menu_link fixed_footer_menu_home">
                        <i class="las la-home"></i>
                        <p class="home_text">Home</p>
                    </a>
                </li>
                <li>
                    <a href="#offcanvasMenuId" data-bs-toggle="offcanvas"
                        class="fixed_footer_menu_link fixed_footer_menu_category">
                        <svg xmlns="http://www.w3.org/2000/svg" version="1.1"
                            xmlns:xlink="http://www.w3.org/1999/xlink" x="0" y="0" viewBox="0 0 32 32"
                            style="enable-background:new 0 0 512 512" xml:space="preserve" fill-rule="evenodd"
                            class="">
                            <g>
                                <path
                                    d="M15 18a1 1 0 0 0-1-1H7a1 1 0 0 0-1 1v7a1 1 0 0 0 1 1h7a1 1 0 0 0 1-1zm11 0a1 1 0 0 0-1-1h-7a1 1 0 0 0-1 1v7a1 1 0 0 0 1 1h7a1 1 0 0 0 1-1zm-13 1v5H8v-5zm11 0v5h-5v-5zm2-12a1 1 0 0 0-1-1h-7a1 1 0 0 0-1 1v7a1 1 0 0 0 1 1h7a1 1 0 0 0 1-1zM15 7a1 1 0 0 0-1-1H7a1 1 0 0 0-1 1v7a1 1 0 0 0 1 1h7a1 1 0 0 0 1-1zm9 1v5h-5V8zM13 8v5H8V8z"
                                    fill="currentColor" opacity="1" data-original="currentColor" class="">
                                </path>
                            </g>
                        </svg>
                        <p>Category</p>
                    </a>
                </li>
                <li>
                    <a data-bs-toggle="offcanvas" href="#fixed_product_sticky_id"
                        class="fixed_footer_menu_link fixed_footer_menu_cart">
                        <svg xmlns="http://www.w3.org/2000/svg" x="0" y="0" viewBox="0 0 13.758 13.758"
                            xml:space="preserve">
                            <path
                                d="M1.013 1.587a.265.265 0 0 0 0 .53H2.57l2.174 8.261a1.055 1.055 0 0 0 .76 1.793c.581 0 1.058-.477 1.058-1.058 0-.192-.052-.373-.143-.53h3.128a1.061 1.061 0 0 0 .914 1.587c.581.001 1.059-.476 1.059-1.057 0-.582-.478-1.06-1.06-1.06H5.207l-.244-.925h6.472c.12 0 .226-.08.256-.197L13 4.037a.265.265 0 0 0-.253-.333H3.535l-.505-1.92a.265.265 0 0 0-.256-.197zm2.662 2.647H12.4l-1.17 4.365H4.823zm2.655.991a.265.265 0 0 0-.264.265v1.852a.265.265 0 1 0 .529 0V5.49a.265.265 0 0 0-.265-.265zm1.72 0a.265.265 0 0 0-.265.265v1.852a.265.265 0 1 0 .53 0V5.49a.265.265 0 0 0-.265-.265zm1.72 0a.265.265 0 0 0-.265.265v1.852a.265.265 0 1 0 .53 0V5.49a.265.265 0 0 0-.265-.265zm-4.265 5.359c.295 0 .53.233.53.529 0 .295-.235.529-.53.529a.526.526 0 0 1-.53-.53c0-.295.235-.528.53-.528zm4.957 0c.295 0 .529.233.529.529 0 .295-.234.529-.53.529s-.526-.234-.526-.53c0-.295.231-.528.527-.528z"
                                fill="currentColor" opacity="1" data-original="currentColor"></path>
                        </svg>
                        <p>Cart</p>
                        <span class="fixed_footer_cart_count cart_item_total">0</span>
                    </a>
                </li>
                <li>
                    <a href="tel:<?php echo e($general_settings->header_contact_number); ?>"
                        class="fixed_footer_menu_link fixed_footer_menu_call">
                        <svg xmlns="http://www.w3.org/2000/svg" x="0" y="0" viewBox="0 0 482.6 482.6"
                            xml:space="preserve">
                            <path
                                d="M98.339 320.8c47.6 56.9 104.9 101.7 170.3 133.4 24.9 11.8 58.2 25.8 95.3 28.2 2.3.1 4.5.2 6.8.2 24.9 0 44.9-8.6 61.2-26.3.1-.1.3-.3.4-.5 5.8-7 12.4-13.3 19.3-20 4.7-4.5 9.5-9.2 14.1-14 21.3-22.2 21.3-50.4-.2-71.9l-60.1-60.1c-10.2-10.6-22.4-16.2-35.2-16.2-12.8 0-25.1 5.6-35.6 16.1l-35.8 35.8c-3.3-1.9-6.7-3.6-9.9-5.2-4-2-7.7-3.9-11-6-32.6-20.7-62.2-47.7-90.5-82.4-14.3-18.1-23.9-33.3-30.6-48.8 9.4-8.5 18.2-17.4 26.7-26.1 3-3.1 6.1-6.2 9.2-9.3 10.8-10.8 16.6-23.3 16.6-36s-5.7-25.2-16.6-36l-29.8-29.8c-3.5-3.5-6.8-6.9-10.2-10.4-6.6-6.8-13.5-13.8-20.3-20.1-10.3-10.1-22.4-15.4-35.2-15.4-12.7 0-24.9 5.3-35.6 15.5l-37.4 37.4c-13.6 13.6-21.3 30.1-22.9 49.2-1.9 23.9 2.5 49.3 13.9 80 17.5 47.5 43.9 91.6 83.1 138.7zm-72.6-216.6c1.2-13.3 6.3-24.4 15.9-34l37.2-37.2c5.8-5.6 12.2-8.5 18.4-8.5 6.1 0 12.3 2.9 18 8.7 6.7 6.2 13 12.7 19.8 19.6 3.4 3.5 6.9 7 10.4 10.6l29.8 29.8c6.2 6.2 9.4 12.5 9.4 18.7s-3.2 12.5-9.4 18.7c-3.1 3.1-6.2 6.3-9.3 9.4-9.3 9.4-18 18.3-27.6 26.8l-.5.5c-8.3 8.3-7 16.2-5 22.2.1.3.2.5.3.8 7.7 18.5 18.4 36.1 35.1 57.1 30 37 61.6 65.7 96.4 87.8 4.3 2.8 8.9 5 13.2 7.2 4 2 7.7 3.9 11 6 .4.2.7.4 1.1.6 3.3 1.7 6.5 2.5 9.7 2.5 8 0 13.2-5.1 14.9-6.8l37.4-37.4c5.8-5.8 12.1-8.9 18.3-8.9 7.6 0 13.8 4.7 17.7 8.9l60.3 60.2c12 12 11.9 25-.3 37.7-4.2 4.5-8.6 8.8-13.3 13.3-7 6.8-14.3 13.8-20.9 21.7-11.5 12.4-25.2 18.2-42.9 18.2-1.7 0-3.5-.1-5.2-.2-32.8-2.1-63.3-14.9-86.2-25.8-62.2-30.1-116.8-72.8-162.1-127-37.3-44.9-62.4-86.7-79-131.5-10.3-27.5-14.2-49.6-12.6-69.7z"
                                fill="currentColor" opacity="1" data-original="currentColor"></path>
                        </svg>
                        <p>Call</p>
                    </a>
                </li>
                <li>
                    <?php if(auth()->guard('customer')->check()): ?>
                        <a href="<?php echo e(route('user.dashboard')); ?>"
                            class="fixed_footer_menu_link fixed_footer_menu_auth">
                            <svg xmlns="http://www.w3.org/2000/svg" x="0" y="0" viewBox="0 0 482.6 482.6"
                                xml:space="preserve">
                                <path
                                    d="M98.339 320.8c47.6 56.9 104.9 101.7 170.3 133.4 24.9 11.8 58.2 25.8 95.3 28.2 2.3.1 4.5.2 6.8.2 24.9 0 44.9-8.6 61.2-26.3.1-.1.3-.3.4-.5 5.8-7 12.4-13.3 19.3-20 4.7-4.5 9.5-9.2 14.1-14 21.3-22.2 21.3-50.4-.2-71.9l-60.1-60.1c-10.2-10.6-22.4-16.2-35.2-16.2-12.8 0-25.1 5.6-35.6 16.1l-35.8 35.8c-3.3-1.9-6.7-3.6-9.9-5.2-4-2-7.7-3.9-11-6-32.6-20.7-62.2-47.7-90.5-82.4-14.3-18.1-23.9-33.3-30.6-48.8 9.4-8.5 18.2-17.4 26.7-26.1 3-3.1 6.1-6.2 9.2-9.3 10.8-10.8 16.6-23.3 16.6-36s-5.7-25.2-16.6-36l-29.8-29.8c-3.5-3.5-6.8-6.9-10.2-10.4-6.6-6.8-13.5-13.8-20.3-20.1-10.3-10.1-22.4-15.4-35.2-15.4-12.7 0-24.9 5.3-35.6 15.5l-37.4 37.4c-13.6 13.6-21.3 30.1-22.9 49.2-1.9 23.9 2.5 49.3 13.9 80 17.5 47.5 43.9 91.6 83.1 138.7zm-72.6-216.6c1.2-13.3 6.3-24.4 15.9-34l37.2-37.2c5.8-5.6 12.2-8.5 18.4-8.5 6.1 0 12.3 2.9 18 8.7 6.7 6.2 13 12.7 19.8 19.6 3.4 3.5 6.9 7 10.4 10.6l29.8 29.8c6.2 6.2 9.4 12.5 9.4 18.7s-3.2 12.5-9.4 18.7c-3.1 3.1-6.2 6.3-9.3 9.4-9.3 9.4-18 18.3-27.6 26.8l-.5.5c-8.3 8.3-7 16.2-5 22.2.1.3.2.5.3.8 7.7 18.5 18.4 36.1 35.1 57.1 30 37 61.6 65.7 96.4 87.8 4.3 2.8 8.9 5 13.2 7.2 4 2 7.7 3.9 11 6 .4.2.7.4 1.1.6 3.3 1.7 6.5 2.5 9.7 2.5 8 0 13.2-5.1 14.9-6.8l37.4-37.4c5.8-5.8 12.1-8.9 18.3-8.9 7.6 0 13.8 4.7 17.7 8.9l60.3 60.2c12 12 11.9 25-.3 37.7-4.2 4.5-8.6 8.8-13.3 13.3-7 6.8-14.3 13.8-20.9 21.7-11.5 12.4-25.2 18.2-42.9 18.2-1.7 0-3.5-.1-5.2-.2-32.8-2.1-63.3-14.9-86.2-25.8-62.2-30.1-116.8-72.8-162.1-127-37.3-44.9-62.4-86.7-79-131.5-10.3-27.5-14.2-49.6-12.6-69.7z"
                                    fill="currentColor" opacity="1" data-original="currentColor"></path>
                            </svg>
                            <p><?php echo e(Str::words(Auth::guard('customer')->user()->name, 1, '..')); ?></p>
                        </a>
                    <?php else: ?>
                        <a href="/login" class="fixed_footer_menu_link fixed_footer_menu_auth">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 490.667 490.667"
                                xml:space="preserve">
                                <path
                                    d="M10.667 448c5.888 0 10.667-4.779 10.667-10.667v-26.197C21.333 325.589 97.899 256 192 256s170.667 69.589 170.667 155.136v26.197c0 5.888 4.779 10.667 10.667 10.667S384 443.221 384 437.333v-26.197c0-80.533-59.051-148.48-139.413-169.579 32.128-18.389 54.08-52.629 54.08-92.224 0-58.816-47.851-106.667-106.667-106.667S85.333 90.517 85.333 149.333c0 39.595 21.952 73.835 54.08 92.224C59.051 262.656 0 330.603 0 411.136v26.197C0 443.221 4.779 448 10.667 448zm96-298.667C106.667 102.272 144.939 64 192 64s85.333 38.272 85.333 85.333-38.272 85.334-85.333 85.334-85.333-38.272-85.333-85.334z"
                                    fill="currentColor" fill="currentColor">
                            </svg>
                            <p>Login</p>
                        </a>
                    <?php endif; ?>
                </li>
            </ul>
        </div>
    <?php endif; ?>

    <?php if($site_configurations->template_id == 7): ?>
        <div class="fixed_footer_menu">
            <ul>
                <li>
                    <a href="<?php echo e(route('root')); ?>" class="fixed_footer_menu_link">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none"
                            stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                            class="feather feather-home">
                            <path d="M3 9l9-7 9 7v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"></path>
                            <polyline points="9 22 9 12 15 12 15 22"></polyline>
                        </svg>
                        <p class="home_text">Home</p>
                    </a>
                </li>
                <li>
                    <a href="#offcanvasMenuId" data-bs-toggle="offcanvas" class="fixed_footer_menu_link">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none"
                            stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                            class="feather feather-grid">
                            <rect x="3" y="3" width="7" height="7"></rect>
                            <rect x="14" y="3" width="7" height="7"></rect>
                            <rect x="14" y="14" width="7" height="7"></rect>
                            <rect x="3" y="14" width="7" height="7"></rect>
                        </svg>
                        <p>Category</p>
                    </a>
                </li>
                <li>
                    <a data-bs-toggle="offcanvas" href="#fixed_product_sticky_id" class="fixed_footer_menu_link">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none"
                            stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                            class="feather feather-shopping-cart">
                            <circle cx="9" cy="21" r="1"></circle>
                            <circle cx="20" cy="21" r="1"></circle>
                            <path d="M1 1h4l2.68 13.39a2 2 0 0 0 2 1.61h9.72a2 2 0 0 0 2-1.61L23 6H6"></path>
                        </svg>
                        <p>Cart</p>
                        <span class="fixed_footer_cart_count cart_item_total">0</span>
                    </a>
                </li>
                <li>
                    <a href="tel:<?php echo e($general_settings->header_contact_number); ?>" class="fixed_footer_menu_link">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none"
                            stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                            class="feather feather-phone-call">
                            <path
                                d="M15.05 5A5 5 0 0 1 19 8.95M15.05 1A9 9 0 0 1 23 8.94m-1 7.98v3a2 2 0 0 1-2.18 2 19.79 19.79 0 0 1-8.63-3.07 19.5 19.5 0 0 1-6-6 19.79 19.79 0 0 1-3.07-8.67A2 2 0 0 1 4.11 2h3a2 2 0 0 1 2 1.72 12.84 12.84 0 0 0 .7 2.81 2 2 0 0 1-.45 2.11L8.09 9.91a16 16 0 0 0 6 6l1.27-1.27a2 2 0 0 1 2.11-.45 12.84 12.84 0 0 0 2.81.7A2 2 0 0 1 22 16.92z">
                            </path>
                        </svg>
                        <p>Call</p>
                    </a>
                </li>
                <li>
                    <?php if(auth()->guard('customer')->check()): ?>
                        <a href="<?php echo e(route('user.dashboard')); ?>" class="fixed_footer_menu_link">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none"
                                stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                stroke-linejoin="round" class="feather feather-user">
                                <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path>
                                <circle cx="12" cy="7" r="4"></circle>
                            </svg>
                            <p><?php echo e(Str::words(Auth::guard('customer')->user()->name, 1, '..')); ?></p>
                        </a>
                    <?php else: ?>
                        <?php if($site_configurations->show_reseller_panel == 1): ?>
                            <a href="/reseller/user" class="fixed_footer_menu_link">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none"
                                    stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                    stroke-linejoin="round" class="feather feather-user">
                                    <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path>
                                    <circle cx="12" cy="7" r="4"></circle>
                                </svg>
                                <p>Login</p>
                            </a>
                        <?php else: ?>
                            <a href="/login" class="fixed_footer_menu_link">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none"
                                    stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                    stroke-linejoin="round" class="feather feather-user">
                                    <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path>
                                    <circle cx="12" cy="7" r="4"></circle>
                                </svg>
                                <p>Login</p>
                            </a>
                        <?php endif; ?>
                    <?php endif; ?>
                </li>
            </ul>
        </div>
    <?php endif; ?>

    <?php if($site_configurations->template_id == 8): ?>
        <div class="fixed_footer_menu">
            <ul>
                <li>
                    <a href="<?php echo e(route('root')); ?>" class="fixed_footer_menu_link">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none"
                            stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                            class="feather feather-home">
                            <path d="M3 9l9-7 9 7v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"></path>
                            <polyline points="9 22 9 12 15 12 15 22"></polyline>
                        </svg>
                        <p class="home_text">Home</p>
                    </a>
                </li>
                <li>
                    <a href="#offcanvasMenuId" data-bs-toggle="offcanvas" class="fixed_footer_menu_link">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none"
                            stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                            class="feather feather-grid">
                            <rect x="3" y="3" width="7" height="7"></rect>
                            <rect x="14" y="3" width="7" height="7"></rect>
                            <rect x="14" y="14" width="7" height="7"></rect>
                            <rect x="3" y="14" width="7" height="7"></rect>
                        </svg>
                        <p>Category</p>
                    </a>
                </li>
                <li>
                    <a data-bs-toggle="offcanvas" href="#fixed_product_sticky_id" class="fixed_footer_menu_link">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none"
                            stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                            class="feather feather-shopping-cart">
                            <circle cx="9" cy="21" r="1"></circle>
                            <circle cx="20" cy="21" r="1"></circle>
                            <path d="M1 1h4l2.68 13.39a2 2 0 0 0 2 1.61h9.72a2 2 0 0 0 2-1.61L23 6H6"></path>
                        </svg>
                        <p>Cart</p>
                        <span class="fixed_footer_cart_count cart_item_total">0</span>
                    </a>
                </li>
                <li>
                    <a href="tel:<?php echo e($general_settings->header_contact_number); ?>" class="fixed_footer_menu_link">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none"
                            stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                            class="feather feather-phone-call">
                            <path
                                d="M15.05 5A5 5 0 0 1 19 8.95M15.05 1A9 9 0 0 1 23 8.94m-1 7.98v3a2 2 0 0 1-2.18 2 19.79 19.79 0 0 1-8.63-3.07 19.5 19.5 0 0 1-6-6 19.79 19.79 0 0 1-3.07-8.67A2 2 0 0 1 4.11 2h3a2 2 0 0 1 2 1.72 12.84 12.84 0 0 0 .7 2.81 2 2 0 0 1-.45 2.11L8.09 9.91a16 16 0 0 0 6 6l1.27-1.27a2 2 0 0 1 2.11-.45 12.84 12.84 0 0 0 2.81.7A2 2 0 0 1 22 16.92z">
                            </path>
                        </svg>
                        <p>Call</p>
                    </a>
                </li>
                <li>
                    <?php if(auth()->guard('customer')->check()): ?>
                        <a href="<?php echo e(route('user.dashboard')); ?>" class="fixed_footer_menu_link">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none"
                                stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                stroke-linejoin="round" class="feather feather-user">
                                <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path>
                                <circle cx="12" cy="7" r="4"></circle>
                            </svg>
                            <p><?php echo e(Str::words(Auth::guard('customer')->user()->name, 1, '..')); ?></p>
                        </a>
                    <?php else: ?>
                        <?php if($site_configurations->show_reseller_panel == 1): ?>
                            <a href="/reseller/user" class="fixed_footer_menu_link">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none"
                                    stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                    stroke-linejoin="round" class="feather feather-user">
                                    <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path>
                                    <circle cx="12" cy="7" r="4"></circle>
                                </svg>
                                <p>Login</p>
                            </a>
                        <?php else: ?>
                            <a href="/login" class="fixed_footer_menu_link">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none"
                                    stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                    stroke-linejoin="round" class="feather feather-user">
                                    <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path>
                                    <circle cx="12" cy="7" r="4"></circle>
                                </svg>
                                <p>Login</p>
                            </a>
                        <?php endif; ?>
                    <?php endif; ?>
                </li>
            </ul>
        </div>
    <?php endif; ?>

    <?php if($site_configurations->template_id == 9): ?>
        <div class="fixed_footer_menu">
            <ul>
                <li>
                    <a href="<?php echo e(route('root')); ?>" class="fixed_footer_menu_link">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none"
                            stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                            class="feather feather-home">
                            <path d="M3 9l9-7 9 7v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"></path>
                            <polyline points="9 22 9 12 15 12 15 22"></polyline>
                        </svg>
                        <p class="home_text">Home</p>
                    </a>
                </li>
                <li>
                    <a href="<?php echo e(route('wish.list')); ?>" class="fixed_footer_menu_link fixed_footer_menu_wishlist">
                        <svg xmlns="http://www.w3.org/2000/svg" version="1.1"
                            xmlns:xlink="http://www.w3.org/1999/xlink" x="0" y="0" viewBox="0 0 512 512"
                            style="enable-background:new 0 0 512 512" xml:space="preserve" class="">
                            <g>
                                <path
                                    d="M489.864 101.1A130.755 130.755 0 0 0 429.7 50.21c-28.112-11.8-59.687-13.924-91.309-6.127-28.978 7.146-57.204 22.645-82.391 45.129-25.189-22.486-53.418-37.986-82.4-45.131-31.623-7.8-63.2-5.674-91.312 6.134a130.755 130.755 0 0 0-60.161 50.9C7.107 124.859-.534 153.734.03 184.615 2.534 321.9 207.036 446.737 248.006 470.37a16 16 0 0 0 15.989 0c40.974-23.636 245.494-148.495 247.976-285.779.558-30.879-7.086-59.751-22.107-83.491zm-9.887 82.916c-.8 44.388-30.39 96.139-85.563 149.655C343.319 383.229 285.2 420.583 256 437.964c-29.2-17.378-87.31-54.727-138.4-104.287-55.176-53.512-84.766-105.259-85.576-149.646-.884-48.467 22.539-87.462 62.656-104.313a106.644 106.644 0 0 1 41.511-8.238c36.795 0 75.717 17.812 108.4 51.046a16 16 0 0 0 22.815 0c45.406-46.17 102.85-62.573 149.9-42.811 40.121 16.845 63.547 55.834 62.671 104.298z"
                                    fill="currentColor" opacity="1" data-original="currentColor"></path>
                            </g>
                        </svg>
                        <p>Wishlist</p>
                        <span class="wish_list_count">0</span>
                    </a>
                </li>
                <li>
                    <a data-bs-toggle="offcanvas" href="#fixed_product_sticky_id" class="fixed_footer_menu_link">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none"
                            stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                            class="feather feather-shopping-cart">
                            <circle cx="9" cy="21" r="1"></circle>
                            <circle cx="20" cy="21" r="1"></circle>
                            <path d="M1 1h4l2.68 13.39a2 2 0 0 0 2 1.61h9.72a2 2 0 0 0 2-1.61L23 6H6"></path>
                        </svg>
                        <p>Cart</p>
                        <span class="fixed_footer_cart_count cart_item_total">0</span>
                    </a>
                </li>
                <li>
                    <a href="tel:<?php echo e($general_settings->header_contact_number); ?>" class="fixed_footer_menu_link">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none"
                            stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                            class="feather feather-phone-call">
                            <path
                                d="M15.05 5A5 5 0 0 1 19 8.95M15.05 1A9 9 0 0 1 23 8.94m-1 7.98v3a2 2 0 0 1-2.18 2 19.79 19.79 0 0 1-8.63-3.07 19.5 19.5 0 0 1-6-6 19.79 19.79 0 0 1-3.07-8.67A2 2 0 0 1 4.11 2h3a2 2 0 0 1 2 1.72 12.84 12.84 0 0 0 .7 2.81 2 2 0 0 1-.45 2.11L8.09 9.91a16 16 0 0 0 6 6l1.27-1.27a2 2 0 0 1 2.11-.45 12.84 12.84 0 0 0 2.81.7A2 2 0 0 1 22 16.92z">
                            </path>
                        </svg>
                        <p>Call</p>
                    </a>
                </li>
                <li>
                    <?php if(auth()->guard('customer')->check()): ?>
                        <a href="<?php echo e(route('user.dashboard')); ?>" class="fixed_footer_menu_link">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none"
                                stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                stroke-linejoin="round" class="feather feather-user">
                                <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path>
                                <circle cx="12" cy="7" r="4"></circle>
                            </svg>
                            <p><?php echo e(Str::words(Auth::guard('customer')->user()->name, 1, '..')); ?></p>
                        </a>
                    <?php else: ?>
                        <?php if($site_configurations->show_reseller_panel == 1): ?>
                            <a href="/reseller/user" class="fixed_footer_menu_link">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none"
                                    stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                    stroke-linejoin="round" class="feather feather-user">
                                    <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path>
                                    <circle cx="12" cy="7" r="4"></circle>
                                </svg>
                                <p>Login</p>
                            </a>
                        <?php else: ?>
                            <a href="/login" class="fixed_footer_menu_link">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none"
                                    stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                    stroke-linejoin="round" class="feather feather-user">
                                    <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path>
                                    <circle cx="12" cy="7" r="4"></circle>
                                </svg>
                                <p>Login</p>
                            </a>
                        <?php endif; ?>
                    <?php endif; ?>
                </li>
            </ul>
        </div>
    <?php endif; ?>
    <!--============ Fixed Footer Menu End ============-->

    <!--============ Header Mobile Menu Area Start ============-->
    <?php if($site_configurations->template_id == 1): ?>
        <div class="header_mobile_menu offcanvas offcanvas-start" tabindex="-1" id="offcanvasMenuId">
            <div class="header_mobile_top">
                <div class="header_mobile_logo">
                    <a href="<?php echo e(route('root')); ?>">
                        <img src="<?php echo e(asset('storage/' . $general_settings->logo)); ?>"
                            alt="<?php echo e($general_settings->title); ?>">
                    </a>
                </div>
                <div class="header_mobile_close_icon" data-bs-dismiss="offcanvas">
                    <i class="fa-solid fa-xmark"></i>
                </div>
            </div>
            <div class="header_mobile_middle">
                <div class="mobile_main_menu">
                    <!--include mobile view-->
                    <ul>
                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li>

                                <a href="<?php echo e(route('product.category', [$category->slug])); ?>"
                                    class="mobile_main_menu_link"><?php echo e($category->name); ?></a>
                                <?php if(count($category->subCategory) > 0): ?>
                                    
                                    <i class="fa-solid fa-angle-down" id="rotate_angle_id_<?php echo e($category->id); ?>"
                                        onclick="mobileSubmenu('mobile_submenu_id_<?php echo e($category->id); ?>', 'rotate_angle_id_<?php echo e($category->id); ?>')"></i>
                                <?php endif; ?>

                                <ul id="mobile_submenu_id_<?php echo e($category->id); ?>"
                                    class="mobile_main_submenu mobile_submenu_class">
                                    <?php $__currentLoopData = $category->subCategory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li>
                                            <a href="<?php echo e(route('product.category', [$category->slug, $subCategory->slug])); ?>"
                                                class="mobile_main_submenu_link"><?php echo e($subCategory->name); ?></a>
                                            <?php if(count($subCategory->subSubCategory) > 0): ?>
                                                <i class="fa-solid fa-angle-down"
                                                    onclick="toggleSubMenu('mobile_sub_submenu_id_'+<?php echo e($subCategory->id); ?>)"></i>
                                            <?php endif; ?>
                                            <ul id="mobile_sub_submenu_id_<?php echo e($subCategory->id); ?>"
                                                class="mobile_main_sub_submenu mobile_sub_submenu_class">
                                                <?php $__currentLoopData = $subCategory->subSubCategory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sub_SubCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <li>
                                                        <a href="<?php echo e(route('product.category', [$category->slug, $subCategory->slug, $sub_SubCategory->slug])); ?>"
                                                            class="mobile_main_sub_submenu_link"><?php echo e($sub_SubCategory->name); ?></a>
                                                    </li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                            </ul>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </ul>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <?php if($site_configurations->template_id == 2): ?>
        <div class="header_mobile_menu offcanvas offcanvas-start" tabindex="-1" id="offcanvasMenuId">
            <div class="header_mobile_top">
                <div class="header_mobile_logo">
                    <a href="<?php echo e(route('root')); ?>">
                        <img src="<?php echo e(asset('storage/' . $general_settings->logo)); ?>"
                            alt="<?php echo e($general_settings->title); ?>">
                    </a>
                </div>
                <div class="header_mobile_close_icon" data-bs-dismiss="offcanvas">
                    <i class="fa-solid fa-xmark"></i>
                </div>
            </div>
            <div class="header_mobile_middle">
                <div class="mobile_main_menu">
                    <!--include mobile view-->
                    <ul>
                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li>

                                <a href="<?php echo e(route('product.category', [$category->slug])); ?>"
                                    class="mobile_main_menu_link"><?php echo e($category->name); ?></a>
                                <?php if(count($category->subCategory) > 0): ?>
                                    
                                    <i class="fa-solid fa-angle-down" id="rotate_angle_id_<?php echo e($category->id); ?>"
                                        onclick="mobileSubmenu('mobile_submenu_id_<?php echo e($category->id); ?>', 'rotate_angle_id_<?php echo e($category->id); ?>')"></i>
                                <?php endif; ?>

                                <ul id="mobile_submenu_id_<?php echo e($category->id); ?>"
                                    class="mobile_main_submenu mobile_submenu_class">
                                    <?php $__currentLoopData = $category->subCategory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li>
                                            <a href="<?php echo e(route('product.category', [$category->slug, $subCategory->slug])); ?>"
                                                class="mobile_main_submenu_link"><?php echo e($subCategory->name); ?></a>
                                            <?php if(count($subCategory->subSubCategory) > 0): ?>
                                                <i class="fa-solid fa-angle-down"
                                                    onclick="toggleSubMenu('mobile_sub_submenu_id_'+<?php echo e($subCategory->id); ?>)"></i>
                                            <?php endif; ?>
                                            <ul id="mobile_sub_submenu_id_<?php echo e($subCategory->id); ?>"
                                                class="mobile_main_sub_submenu mobile_sub_submenu_class">
                                                <?php $__currentLoopData = $subCategory->subSubCategory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sub_SubCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <li>
                                                        <a href="<?php echo e(route('product.category', [$category->slug, $subCategory->slug, $sub_SubCategory->slug])); ?>"
                                                            class="mobile_main_sub_submenu_link"><?php echo e($sub_SubCategory->name); ?></a>
                                                    </li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                            </ul>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </ul>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <?php if($site_configurations->template_id == 3): ?>
        <div class="header_mobile_menu offcanvas offcanvas-start" tabindex="-1" id="offcanvasMenuId">
            <div class="header_mobile_top">
                <div class="header_mobile_logo">
                    <a href="<?php echo e(route('root')); ?>">
                        <img src="<?php echo e(asset('storage/' . $general_settings->logo)); ?>"
                            alt="<?php echo e($general_settings->title); ?>">
                    </a>
                </div>
                <div class="header_mobile_close_icon" data-bs-dismiss="offcanvas">
                    <i class="fa-solid fa-xmark"></i>
                </div>
            </div>
            <div class="header_mobile_middle">
                <div class="mobile_main_menu">
                    <!--include mobile view-->
                    <ul>
                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li>

                                <a href="<?php echo e(route('product.category', [$category->slug])); ?>"
                                    class="mobile_main_menu_link"><?php echo e($category->name); ?></a>
                                <?php if(count($category->subCategory) > 0): ?>
                                    
                                    <i class="fa-solid fa-angle-down" id="rotate_angle_id_<?php echo e($category->id); ?>"
                                        onclick="mobileSubmenu('mobile_submenu_id_<?php echo e($category->id); ?>', 'rotate_angle_id_<?php echo e($category->id); ?>')"></i>
                                <?php endif; ?>

                                <ul id="mobile_submenu_id_<?php echo e($category->id); ?>"
                                    class="mobile_main_submenu mobile_submenu_class">
                                    <?php $__currentLoopData = $category->subCategory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li>
                                            <a href="<?php echo e(route('product.category', [$category->slug, $subCategory->slug])); ?>"
                                                class="mobile_main_submenu_link"><?php echo e($subCategory->name); ?></a>
                                            <?php if(count($subCategory->subSubCategory) > 0): ?>
                                                <i class="fa-solid fa-angle-down"
                                                    onclick="toggleSubMenu('mobile_sub_submenu_id_'+<?php echo e($subCategory->id); ?>)"></i>
                                            <?php endif; ?>
                                            <ul id="mobile_sub_submenu_id_<?php echo e($subCategory->id); ?>"
                                                class="mobile_main_sub_submenu mobile_sub_submenu_class">
                                                <?php $__currentLoopData = $subCategory->subSubCategory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sub_SubCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <li>
                                                        <a href="<?php echo e(route('product.category', [$category->slug, $subCategory->slug, $sub_SubCategory->slug])); ?>"
                                                            class="mobile_main_sub_submenu_link"><?php echo e($sub_SubCategory->name); ?></a>
                                                    </li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                            </ul>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </ul>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <?php if($site_configurations->template_id == 4): ?>
        <div class="header_mobile_menu offcanvas offcanvas-start" tabindex="-1" id="offcanvasMenuId">
            <div class="header_mobile_top">
                <div class="header_mobile_logo">
                    <a href="<?php echo e(route('root')); ?>">
                        <img src="<?php echo e(asset('storage/' . $general_settings->logo)); ?>"
                            alt="<?php echo e($general_settings->title); ?>">
                    </a>
                </div>
                <div class="header_mobile_close_icon" data-bs-dismiss="offcanvas">
                    <i class="fa-solid fa-xmark"></i>
                </div>
            </div>
            <div class="header_mobile_middle">
                <div class="mobile_main_menu">
                    <!--include mobile view-->
                    <ul>
                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li>

                                <a href="<?php echo e(route('product.category', [$category->slug])); ?>"
                                    class="mobile_main_menu_link"><?php echo e($category->name); ?></a>
                                <?php if(count($category->subCategory) > 0): ?>
                                    
                                    <i class="fa-solid fa-angle-down" id="rotate_angle_id_<?php echo e($category->id); ?>"
                                        onclick="mobileSubmenu('mobile_submenu_id_<?php echo e($category->id); ?>', 'rotate_angle_id_<?php echo e($category->id); ?>')"></i>
                                <?php endif; ?>

                                <ul id="mobile_submenu_id_<?php echo e($category->id); ?>"
                                    class="mobile_main_submenu mobile_submenu_class">
                                    <?php $__currentLoopData = $category->subCategory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li>
                                            <a href="<?php echo e(route('product.category', [$category->slug, $subCategory->slug])); ?>"
                                                class="mobile_main_submenu_link"><?php echo e($subCategory->name); ?></a>
                                            <?php if(count($subCategory->subSubCategory) > 0): ?>
                                                <i class="fa-solid fa-angle-down"
                                                    onclick="toggleSubMenu('mobile_sub_submenu_id_'+<?php echo e($subCategory->id); ?>)"></i>
                                            <?php endif; ?>
                                            <ul id="mobile_sub_submenu_id_<?php echo e($subCategory->id); ?>"
                                                class="mobile_main_sub_submenu mobile_sub_submenu_class">
                                                <?php $__currentLoopData = $subCategory->subSubCategory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sub_SubCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <li>
                                                        <a href="<?php echo e(route('product.category', [$category->slug, $subCategory->slug, $sub_SubCategory->slug])); ?>"
                                                            class="mobile_main_sub_submenu_link"><?php echo e($sub_SubCategory->name); ?></a>
                                                    </li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                            </ul>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </ul>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <?php if($site_configurations->template_id == 7): ?>
        <div class="header_mobile_menu offcanvas offcanvas-start" tabindex="-1" id="offcanvasMenuId">
            <div class="header_mobile_top">
                <div class="header_mobile_logo">
                    <a href="<?php echo e(route('root')); ?>">
                        <img src="<?php echo e(asset('storage/' . $general_settings->logo)); ?>"
                            alt="<?php echo e($general_settings->title); ?>">
                    </a>
                </div>
                <div class="header_mobile_close_icon" data-bs-dismiss="offcanvas">
                    <i class="fa-solid fa-xmark"></i>
                </div>
            </div>
            <div class="header_mobile_middle">
                <div class="mobile_main_menu">
                    <!--include mobile view-->
                    <ul>
                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li>

                                <a href="<?php echo e(route('product.category', [$category->slug])); ?>"
                                    class="mobile_main_menu_link"><?php echo e($category->name); ?></a>
                                <?php if(count($category->subCategory) > 0): ?>
                                    
                                    <i class="fa-solid fa-angle-down" id="rotate_angle_id_<?php echo e($category->id); ?>"
                                        onclick="mobileSubmenu('mobile_submenu_id_<?php echo e($category->id); ?>', 'rotate_angle_id_<?php echo e($category->id); ?>')"></i>
                                <?php endif; ?>

                                <ul id="mobile_submenu_id_<?php echo e($category->id); ?>"
                                    class="mobile_main_submenu mobile_submenu_class">
                                    <?php $__currentLoopData = $category->subCategory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li>
                                            <a href="<?php echo e(route('product.category', [$category->slug, $subCategory->slug])); ?>"
                                                class="mobile_main_submenu_link"><?php echo e($subCategory->name); ?></a>
                                            <?php if(count($subCategory->subSubCategory) > 0): ?>
                                                <i class="fa-solid fa-angle-down"
                                                    onclick="toggleSubMenu('mobile_sub_submenu_id_'+<?php echo e($subCategory->id); ?>)"></i>
                                            <?php endif; ?>
                                            <ul id="mobile_sub_submenu_id_<?php echo e($subCategory->id); ?>"
                                                class="mobile_main_sub_submenu mobile_sub_submenu_class">
                                                <?php $__currentLoopData = $subCategory->subSubCategory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sub_SubCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <li>
                                                        <a href="<?php echo e(route('product.category', [$category->slug, $subCategory->slug, $sub_SubCategory->slug])); ?>"
                                                            class="mobile_main_sub_submenu_link"><?php echo e($sub_SubCategory->name); ?></a>
                                                    </li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                            </ul>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </ul>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <?php if($site_configurations->template_id == 8): ?>
        <div class="header_mobile_menu offcanvas offcanvas-start" tabindex="-1" id="offcanvasMenuId">
            <div class="header_mobile_top">
                <div class="header_mobile_logo">
                    <a href="<?php echo e(route('root')); ?>">
                        <img src="<?php echo e(asset('storage/' . $general_settings->logo)); ?>"
                            alt="<?php echo e($general_settings->title); ?>">
                    </a>
                </div>
                <div class="header_mobile_close_icon" data-bs-dismiss="offcanvas">
                    <i class="fa-solid fa-xmark"></i>
                </div>
            </div>
            <div class="header_mobile_middle">
                <div class="mobile_main_menu">
                    <!--include mobile view-->
                    <ul>
                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li>

                                <a href="<?php echo e(route('product.category', [$category->slug])); ?>"
                                    class="mobile_main_menu_link"><?php echo e($category->name); ?></a>
                                <?php if(count($category->subCategory) > 0): ?>
                                    
                                    <i class="fa-solid fa-angle-down" id="rotate_angle_id_<?php echo e($category->id); ?>"
                                        onclick="mobileSubmenu('mobile_submenu_id_<?php echo e($category->id); ?>', 'rotate_angle_id_<?php echo e($category->id); ?>')"></i>
                                <?php endif; ?>

                                <ul id="mobile_submenu_id_<?php echo e($category->id); ?>"
                                    class="mobile_main_submenu mobile_submenu_class">
                                    <?php $__currentLoopData = $category->subCategory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li>
                                            <a href="<?php echo e(route('product.category', [$category->slug, $subCategory->slug])); ?>"
                                                class="mobile_main_submenu_link"><?php echo e($subCategory->name); ?></a>
                                            <?php if(count($subCategory->subSubCategory) > 0): ?>
                                                <i class="fa-solid fa-angle-down"
                                                    onclick="toggleSubMenu('mobile_sub_submenu_id_'+<?php echo e($subCategory->id); ?>)"></i>
                                            <?php endif; ?>
                                            <ul id="mobile_sub_submenu_id_<?php echo e($subCategory->id); ?>"
                                                class="mobile_main_sub_submenu mobile_sub_submenu_class">
                                                <?php $__currentLoopData = $subCategory->subSubCategory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sub_SubCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <li>
                                                        <a href="<?php echo e(route('product.category', [$category->slug, $subCategory->slug, $sub_SubCategory->slug])); ?>"
                                                            class="mobile_main_sub_submenu_link"><?php echo e($sub_SubCategory->name); ?></a>
                                                    </li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                            </ul>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </ul>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </div>
        </div>
    <?php endif; ?>


    <?php if($site_configurations->template_id == 9): ?>
        <div class="header_mobile_menu offcanvas offcanvas-start" tabindex="-1" id="offcanvasMenuId">
            <div class="header_mobile_top">
                <div class="header_mobile_logo">
                    <a href="<?php echo e(route('root')); ?>">
                        <img src="<?php echo e(asset('storage/' . $general_settings->logo)); ?>"
                            alt="<?php echo e($general_settings->title); ?>">
                    </a>
                </div>
                <div class="header_mobile_close_icon" data-bs-dismiss="offcanvas">
                    <i class="fa-solid fa-xmark"></i>
                </div>
            </div>
            <div class="header_mobile_middle">
                <div class="mobile_main_menu">
                    <!--include mobile view-->
                    <ul>
                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li>

                                <a href="<?php echo e(route('product.category', [$category->slug])); ?>"
                                    class="mobile_main_menu_link"><?php echo e($category->name); ?></a>
                                <?php if(count($category->subCategory) > 0): ?>
                                    
                                    <i class="fa-solid fa-angle-down" id="rotate_angle_id_<?php echo e($category->id); ?>"
                                        onclick="mobileSubmenu('mobile_submenu_id_<?php echo e($category->id); ?>', 'rotate_angle_id_<?php echo e($category->id); ?>')"></i>
                                <?php endif; ?>

                                <ul id="mobile_submenu_id_<?php echo e($category->id); ?>"
                                    class="mobile_main_submenu mobile_submenu_class">
                                    <?php $__currentLoopData = $category->subCategory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li>
                                            <a href="<?php echo e(route('product.category', [$category->slug, $subCategory->slug])); ?>"
                                                class="mobile_main_submenu_link"><?php echo e($subCategory->name); ?></a>
                                            <?php if(count($subCategory->subSubCategory) > 0): ?>
                                                <i class="fa-solid fa-angle-down"
                                                    onclick="toggleSubMenu('mobile_sub_submenu_id_'+<?php echo e($subCategory->id); ?>)"></i>
                                            <?php endif; ?>
                                            <ul id="mobile_sub_submenu_id_<?php echo e($subCategory->id); ?>"
                                                class="mobile_main_sub_submenu mobile_sub_submenu_class">
                                                <?php $__currentLoopData = $subCategory->subSubCategory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sub_SubCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <li>
                                                        <a href="<?php echo e(route('product.category', [$category->slug, $subCategory->slug, $sub_SubCategory->slug])); ?>"
                                                            class="mobile_main_sub_submenu_link"><?php echo e($sub_SubCategory->name); ?></a>
                                                    </li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                            </ul>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </ul>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        <li>
                            <a href="<?php echo e(route('combo.product')); ?>" class="main_menu_link h_combo">
                                <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M12.2606 5.55847C10.5932 1.81855 5.70271 1 5.70271 1C5.70271 1 7.95936 4.11613 5.07549 6.58024C3.25187 8.13548 2.5309 10.1565 3.31213 12.3637C3.91034 14.0544 5.17594 14.7431 6.53975 15C5.88798 13.4448 6.39243 11.5452 6.44823 11.3419C7.72276 13.7806 10.1312 11.3419 8.9214 8.69153C10.5062 9.12621 10.7428 12.6036 9.5263 14.7742C11.3231 14.0601 12.5195 12.2649 12.8477 10.6645C13.1936 8.99073 12.9303 7.05444 12.2606 5.55847Z"
                                        fill="#FF5E2C"></path>
                                </svg>
                                Combo Offers
                            </a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('buy.one.products')); ?>" class="main_menu_link h_buy_one">
                                <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M12.2606 5.55847C10.5932 1.81855 5.70271 1 5.70271 1C5.70271 1 7.95936 4.11613 5.07549 6.58024C3.25187 8.13548 2.5309 10.1565 3.31213 12.3637C3.91034 14.0544 5.17594 14.7431 6.53975 15C5.88798 13.4448 6.39243 11.5452 6.44823 11.3419C7.72276 13.7806 10.1312 11.3419 8.9214 8.69153C10.5062 9.12621 10.7428 12.6036 9.5263 14.7742C11.3231 14.0601 12.5195 12.2649 12.8477 10.6645C13.1936 8.99073 12.9303 7.05444 12.2606 5.55847Z"
                                        fill="#FF5E2C"></path>
                                </svg>
                                Buy 1 Get Free
                            </a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('daily.products')); ?>" class="main_menu_link h_daily_offers">
                                <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <g clip-path="url(#clip0_249_499)">
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M14.171 2.59L13.2 0L12.229 2.59L10.4 3.2L12.229 3.81L13.2 6.4L14.171 3.81L16 3.2L14.171 2.59ZM12.571 12.19L11.6 9.6L10.629 12.19L8.8 12.8L10.629 13.41L11.6 16L12.571 13.41L14.4 12.8L12.571 12.19ZM6.771 5.99L5.2 1.6L3.632 5.989L0 7.2L3.632 8.411L5.2 12.8L6.768 8.411L10.4 7.2L6.768 5.989L6.771 5.99Z"
                                            fill="#00CA8D"></path>
                                    </g>
                                    <defs>
                                        <clipPath id="clip0_249_499">
                                            <rect width="16" height="16" fill="white"></rect>
                                        </clipPath>
                                    </defs>
                                </svg>
                                Daily Offers

                            </a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('brand')); ?>" class="main_menu_link h_brand">
                                <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M2.01141 4.16553L4.74531 5.90835L7.4701 2.26088C7.53032 2.1802 7.60981 2.11443 7.70197 2.06905C7.79413 2.02367 7.8963 2 7.99996 2C8.10362 2 8.20578 2.02367 8.29794 2.06905C8.39011 2.11443 8.4696 2.1802 8.52982 2.26088L11.2546 5.90835L13.9885 4.16553C14.092 4.09971 14.213 4.06358 14.3372 4.06142C14.4615 4.05926 14.5838 4.09116 14.6897 4.15335C14.7956 4.21553 14.8807 4.30541 14.9349 4.41235C14.989 4.51929 15.0101 4.63883 14.9955 4.75685L13.926 13.4504C13.9074 13.6018 13.8312 13.7414 13.7121 13.8427C13.593 13.944 13.4391 14 13.2796 14H2.72027C2.56084 14 2.40695 13.944 2.28781 13.8427C2.16867 13.7414 2.09255 13.6018 2.0739 13.4504L1.00442 4.75622C0.98997 4.63826 1.01112 4.51881 1.06536 4.41197C1.11961 4.30512 1.20469 4.21535 1.31056 4.15325C1.41643 4.09114 1.53868 4.0593 1.66286 4.06148C1.78705 4.06365 1.90799 4.09976 2.01141 4.16553ZM7.99996 10.2654C8.34523 10.2654 8.67637 10.1342 8.92051 9.90078C9.16466 9.66732 9.30182 9.35068 9.30182 9.02052C9.30182 8.69036 9.16466 8.37373 8.92051 8.14027C8.67637 7.90681 8.34523 7.77565 7.99996 7.77565C7.65468 7.77565 7.32355 7.90681 7.07941 8.14027C6.83526 8.37373 6.6981 8.69036 6.6981 9.02052C6.6981 9.35068 6.83526 9.66732 7.07941 9.90078C7.32355 10.1342 7.65468 10.2654 7.99996 10.2654Z"
                                        fill="#9747FF"></path>
                                </svg>
                                Brand
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    <?php endif; ?>
    <!--============ Header Mobile Menu Area End ============-->

    <!--============ Fixed Product Cart Area Start ============-->

    <!-- template one start -->
    <?php if($site_configurations->template_id == 1): ?>
        <a class="fixed_product_sticky" data-bs-toggle="offcanvas" href="#fixed_product_sticky_id">
            <div class="fixed_product_sticky_icon">
                <i class="fa-solid fa-cart-shopping"></i>
            </div>
            <div class="fixed_product_sticky_price">
                <p class="subTotal">
                </p>
            </div>
            <div class="fixed_product_sticky_count">
                <p id="item_count">0 items</p>
            </div>
        </a>
    <?php endif; ?>
    <!-- template one end -->

    <!-- template two start -->
    <?php if($site_configurations->template_id == 3): ?>
        <a class="fixed_product_sticky" data-bs-toggle="offcanvas" href="#fixed_product_sticky_id">
            <div class="fixed_product_sticky_icon">
                <i class="las la-cart-arrow-down"></i>
            </div>
            <div class="fixed_product_sticky_price">
                <p class="subTotal">
                </p>
            </div>
            <div class="fixed_product_sticky_count">
                <p id="item_count">0 items</p>
            </div>
        </a>
    <?php endif; ?>
    <!-- template two end -->

    <!-- template two start -->
    <?php if($site_configurations->template_id == 6): ?>
        <a class="fixed_product_sticky" data-bs-toggle="offcanvas" href="#fixed_product_sticky_id">
            <div class="fixed_product_sticky_icon">
                <i class="las la-cart-arrow-down"></i>
            </div>
            <div class="fixed_product_sticky_price">
                <p class="subTotal"></p>
            </div>
            <div class="fixed_product_sticky_count">
                <p id="item_count">0 items</p>
            </div>
        </a>
    <?php endif; ?>
    <!-- template two end -->

    <!-- template Eight start -->
    <?php if($site_configurations->template_id == 8): ?>
        <a class="fixed_product_sticky" data-bs-toggle="offcanvas" href="#fixed_product_sticky_id">
            <div class="fixed_product_sticky_icon">
                <i class="fa-solid fa-cart-shopping"></i>
            </div>
            <div class="fixed_product_sticky_price">
                <p class="subTotal">
                </p>
            </div>
            <div class="fixed_product_sticky_count">
                <p id="item_count">0 items</p>
            </div>
        </a>
    <?php endif; ?>
    <!-- template Eight end -->

    <!-- template Nine start -->
    <?php if($site_configurations->template_id == 9): ?>
        <a class="fixed_product_sticky d-none d-md-block" data-bs-toggle="offcanvas"
            href="#fixed_product_sticky_id">
            <div class="fixed_product_sticky_icon">
                <i class="fa-solid fa-cart-shopping"></i>
            </div>
            <div class="fixed_product_sticky_price">
                <p class="subTotal">
                </p>
            </div>
            <div class="fixed_product_sticky_count">
                <p id="item_count">0 items</p>
            </div>
        </a>
    <?php endif; ?>
    <!-- template Nine end -->






    <!-- Template One fixed product cart start -->
    <?php if($site_configurations->template_id == 1): ?>
        <div class="fixed_product_card_content offcanvas offcanvas-end" id="fixed_product_sticky_id">
            <div class="fixed_product_card_header">
                <div class="fixed_product_card_header_icon">
                    <i class="fa-solid fa-cart-shopping"></i>
                    <span class="cart_item_total">0</span>
                </div>
                <div class="fixed_product_card_header_close" data-bs-dismiss="offcanvas">
                    <i class="fa-solid fa-xmark"></i>
                </div>
            </div>
            <div class="fixed_product_card_body">
                <div class="fixed_product_card_list">
                    <ul id="miniCart">

                    </ul>
                </div>
            </div>
            <div class="fixed_product_card_footer">
                <div class="fixed_product_card_footer_count">
                    <strong>Subtotal</strong>
                    <strong class="subTotal">

                    </strong>
                </div>
                <div class="fixed_product_card_footer_checkout">
                    <a href="<?php echo e(route('checkout.index')); ?>"
                        class="fixed_product_card_footer_checkout_link cart_check_out">Place Order</a>
                </div>
            </div>
        </div>
    <?php endif; ?>
    <!-- Template One fixed product cart end -->

    <!-- Template Two fixed product cart start -->
    <?php if($site_configurations->template_id == 2): ?>
        <div class="fixed_product_card_content offcanvas offcanvas-end" id="fixed_product_sticky_id">
            <div class="fixed_product_card_header">
                <div class="fixed_product_card_header_icon">
                    <i class="fa-solid fa-cart-shopping"></i>
                    <span class="cart_item_total">0</span>
                </div>
                <div class="fixed_product_card_header_close" data-bs-dismiss="offcanvas">
                    <i class="fa-solid fa-xmark"></i>
                </div>
            </div>
            <div class="fixed_product_card_body">
                <div class="fixed_product_card_list">
                    <ul id="miniCart">

                    </ul>
                </div>
            </div>
            <div class="fixed_product_card_footer">
                <div class="fixed_product_card_footer_count">
                    <strong>Subtotal</strong>
                    <strong class="subTotal">

                    </strong>
                </div>
                <div class="fixed_product_card_footer_checkout">
                    <a href="<?php echo e(route('checkout.index')); ?>"
                        class="fixed_product_card_footer_checkout_link cart_check_out">Place Order</a>
                </div>
            </div>
        </div>
    <?php endif; ?>
    <!-- Template Two fixed product cart end -->

    <!-- Template Three fixed product cart start -->
    <?php if($site_configurations->template_id == 3): ?>
        <div class="fixed_product_card_content offcanvas offcanvas-end" id="fixed_product_sticky_id">
            <div class="fixed_product_card_header">
                <div class="fixed_product_card_header_icon">
                    <i class="las la-shopping-basket"></i>
                    <span class="cart_item_total">0</span>
                </div>
                <div class="fixed_product_card_header_close" data-bs-dismiss="offcanvas">
                    <i class="fa-solid fa-xmark"></i>
                </div>
            </div>
            <div class="fixed_product_card_body">
                <div class="fixed_product_card_list">
                    <ul id="miniCart">

                    </ul>
                </div>
            </div>
            <div class="fixed_product_card_footer">
                <div class="fixed_product_card_footer_count">
                    <strong>Subtotal</strong>
                    <strong class="subTotal">

                    </strong>
                </div>
                <div class="fixed_product_card_footer_checkout">
                    <a href="<?php echo e(route('checkout.index')); ?>"
                        class="fixed_product_card_footer_checkout_link cart_check_out">Place Order</a>
                </div>
            </div>
        </div>
    <?php endif; ?>
    <!-- Template Three fixed product cart end -->

    <!-- Template Four fixed product cart start -->
    <?php if($site_configurations->template_id == 4): ?>
        <div class="fixed_product_card_content offcanvas offcanvas-end" id="fixed_product_sticky_id">
            <div class="fixed_product_card_header">
                <div class="fixed_product_card_header_icon">
                    <i class="las la-shopping-basket"></i>
                    <span class="cart_item_total">0</span>
                </div>
                <div class="fixed_product_card_header_close" data-bs-dismiss="offcanvas">
                    <i class="fa-solid fa-xmark"></i>
                </div>
            </div>
            <div class="fixed_product_card_body">
                <div class="fixed_product_card_list">
                    <ul id="miniCart">

                    </ul>
                </div>
            </div>
            <div class="fixed_product_card_footer">
                <div class="fixed_product_card_footer_count">
                    <strong>Subtotal</strong>
                    <strong class="subTotal">

                    </strong>
                </div>
                <div class="fixed_product_card_footer_checkout">
                    <a href="<?php echo e(route('checkout.index')); ?>"
                        class="fixed_product_card_footer_checkout_link cart_check_out">Place Order</a>
                </div>
            </div>
        </div>
    <?php endif; ?>
    <!-- Template Four fixed product cart end -->

    <!-- Template Two fixed product cart start -->
    <?php if($site_configurations->template_id == 5): ?>
        <div class="fixed_product_card_content offcanvas offcanvas-end" id="fixed_product_sticky_id">
            <div class="fixed_product_card_header">
                <div class="fixed_product_card_header_icon">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" class="bi bi-bag"
                        viewBox="0 0 16 16">
                        <path
                            d="M8 1a2.5 2.5 0 0 1 2.5 2.5V4h-5v-.5A2.5 2.5 0 0 1 8 1m3.5 3v-.5a3.5 3.5 0 1 0-7 0V4H1v10a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V4zM2 5h12v9a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1z">
                        </path>
                    </svg>
                    <span class="cart_item_total">0</span>
                </div>
                <div class="fixed_product_card_header_close" data-bs-dismiss="offcanvas">
                    <i class="fa-solid fa-xmark"></i>
                </div>
            </div>
            <div class="fixed_product_card_body">
                <div class="fixed_product_card_list">
                    <ul id="miniCart">

                    </ul>
                </div>
            </div>
            <div class="fixed_product_card_footer">
                <div class="fixed_product_card_footer_count">
                    <strong>Subtotal</strong>
                    <strong class="subTotal">

                    </strong>
                </div>
                <div class="fixed_product_card_footer_checkout">
                    <a href="<?php echo e(route('checkout.index')); ?>"
                        class="fixed_product_card_footer_checkout_link cart_check_out">Place Order</a>
                </div>
            </div>
        </div>
    <?php endif; ?>
    <!-- Template Two fixed product cart end -->

    <!-- Template Two fixed product cart start -->
    <?php if($site_configurations->template_id == 6): ?>
        <div class="fixed_product_card_content offcanvas offcanvas-end" id="fixed_product_sticky_id">
            <div class="fixed_product_card_header">
                <div class="fixed_product_card_header_icon">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" class="bi bi-bag"
                        viewBox="0 0 16 16">
                        <path
                            d="M8 1a2.5 2.5 0 0 1 2.5 2.5V4h-5v-.5A2.5 2.5 0 0 1 8 1m3.5 3v-.5a3.5 3.5 0 1 0-7 0V4H1v10a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V4zM2 5h12v9a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1z">
                        </path>
                    </svg>
                    <span class="cart_item_total">0</span>
                </div>
                <div class="fixed_product_card_header_close" data-bs-dismiss="offcanvas">
                    <i class="fa-solid fa-xmark"></i>
                </div>
            </div>
            <div class="fixed_product_card_body">
                <div class="fixed_product_card_list">
                    <ul id="miniCart">

                    </ul>
                </div>
            </div>
            <div class="fixed_product_card_footer">
                <div class="fixed_product_card_footer_count">
                    <strong>Subtotal</strong>
                    <strong class="subTotal">

                    </strong>
                </div>
                <div class="fixed_product_card_footer_checkout">
                    <a href="<?php echo e(route('checkout.index')); ?>"
                        class="fixed_product_card_footer_checkout_link cart_check_out">Place Order</a>
                </div>
            </div>
        </div>
    <?php endif; ?>
    <!-- Template Two fixed product cart end -->

    <!-- Template Two fixed product cart start -->
    <?php if($site_configurations->template_id == 8): ?>
        <div class="fixed_product_card_content offcanvas offcanvas-end" id="fixed_product_sticky_id">
            <div class="fixed_product_card_header">
                <div class="fixed_product_card_header_icon">
                    <i class="fa-solid fa-cart-shopping"></i>
                    <span class="cart_item_total">0</span>
                </div>
                <div class="fixed_product_card_header_close" data-bs-dismiss="offcanvas">
                    <i class="fa-solid fa-xmark"></i>
                </div>
            </div>
            <div class="fixed_product_card_body">
                <div class="fixed_product_card_list">
                    <ul id="miniCart">

                    </ul>
                </div>
            </div>
            <div class="fixed_product_card_footer">
                <div class="fixed_product_card_footer_count">
                    <strong>Subtotal</strong>
                    <strong class="subTotal">

                    </strong>
                </div>
                <div class="fixed_product_card_footer_checkout">
                    <a href="<?php echo e(route('checkout.index')); ?>"
                        class="fixed_product_card_footer_checkout_link cart_check_out">Place Order</a>
                </div>
            </div>
        </div>
    <?php endif; ?>
    <!-- Template Two fixed product cart end -->
    <!-- Template Two fixed product cart start -->
    <?php if($site_configurations->template_id == 9): ?>
        <div class="fixed_product_card_content offcanvas offcanvas-end" id="fixed_product_sticky_id">
            <div class="fixed_product_card_header">
                <div class="fixed_product_card_header_icon">
                    <i class="fa-solid fa-cart-shopping"></i>
                    <span class="cart_item_total">0</span>
                </div>
                <div class="fixed_product_card_header_close" data-bs-dismiss="offcanvas">
                    <i class="fa-solid fa-xmark"></i>
                </div>
            </div>
            <div class="fixed_product_card_body">
                <div class="fixed_product_card_list">
                    <ul id="miniCart">

                    </ul>
                </div>
            </div>
            <div class="fixed_product_card_footer">
                <div class="fixed_product_card_footer_count">
                    <strong>Subtotal</strong>
                    <strong class="subTotal">

                    </strong>
                </div>
                <div class="fixed_product_card_footer_checkout">
                    <a href="<?php echo e(route('checkout.index')); ?>"
                        class="fixed_product_card_footer_checkout_link cart_check_out">Place Order</a>
                </div>
            </div>
        </div>
    <?php endif; ?>
    <!-- Template Two fixed product cart end -->

    <!-- Template Eight fixed product cart start -->
    <?php if($site_configurations->template_id == 1): ?>
        <div class="fixed_product_card_content offcanvas offcanvas-end" id="fixed_product_sticky_id">
            <div class="fixed_product_card_header">
                <div class="fixed_product_card_header_icon">
                    <i class="fa-solid fa-cart-shopping"></i>
                    <span class="cart_item_total">0</span>
                </div>
                <div class="fixed_product_card_header_close" data-bs-dismiss="offcanvas">
                    <i class="fa-solid fa-xmark"></i>
                </div>
            </div>
            <div class="fixed_product_card_body">
                <div class="fixed_product_card_list">
                    <ul id="miniCart">

                    </ul>
                </div>
            </div>
            <div class="fixed_product_card_footer">
                <div class="fixed_product_card_footer_count">
                    <strong>Subtotal</strong>
                    <strong class="subTotal">

                    </strong>
                </div>
                <div class="fixed_product_card_footer_checkout">
                    <a href="<?php echo e(route('checkout.index')); ?>"
                        class="fixed_product_card_footer_checkout_link cart_check_out">Place Order</a>
                </div>
            </div>
        </div>
    <?php endif; ?>
    <!-- Template One fixed product cart end -->

    <!--============ Fixed Product Cart Area End ============-->


    <?php echo $__env->make('frontend.partials.js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


    <?php echo $__env->yieldPushContent('popup'); ?>

    <!-- All js-->
    <?php echo $__env->yieldContent('scripts'); ?>

    <script>
        function toggleSubMenu(subMenuId) {
            // console.log('toggle working');
            var subMenu = document.getElementById(subMenuId);
            if (subMenu.style.display === 'block') {
                subMenu.style.display = 'none';
            } else {
                subMenu.style.display = 'block';
            }
        };
        <?php if(Session::has('message')): ?>
            toastr.options = {
                "closeButton": true,
                "progressBar": true
            }
            toastr.success("<?php echo e(session('message')); ?>");
        <?php endif; ?>

        <?php if(Session::has('error')): ?>
            toastr.options = {
                "closeButton": true,
                "progressBar": true
            }
            toastr.error("<?php echo e(session('error')); ?>");
        <?php endif; ?>

        <?php if(Session::has('info')): ?>
            toastr.options = {
                "closeButton": true,
                "progressBar": true
            }
            toastr.info("<?php echo e(session('info')); ?>");
        <?php endif; ?>

        <?php if(Session::has('warning')): ?>
            toastr.options = {
                "closeButton": true,
                "progressBar": true
            }
            toastr.warning("<?php echo e(session('warning')); ?>");
        <?php endif; ?>
    </script>
    <script>
        //================setup ajax=======================
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        toastr.options = {
            "closeButton": true,
            "progressBar": true
        }

        //==============increment and decrement for single page start============
        var quantity = 1;
        let variant = null;
        var shipping_charge = 0;
        var sub_total = 0;
        var delivery_charge_id = 0;
        var payable_amount = 0;
        let intervalId;
        var otp_time = 0;
        var coupon = null;
        let current_city_charge = 0;


        $(".product_qty").val(quantity);

        function Increment() {
            quantity++;
            $(".product_qty").val(quantity);
        }


        function decrement() {
            if (quantity > 1) {
                quantity--;
                $(".product_qty").val(quantity);
            }
        }

        //=================increment and decrement for single page start=============

        //get variant
        // function getVariant(id) {
        //     variant = id
        // }
        function getVariant(id, price, productPrice) {

            variant = id;
            price = price ?? 0;
            productPrice = productPrice ?? 0;

            var attributPrice = "";

            attributPrice += `<span>${price} TK</span>`;


            if (price == 0) {
                $('#variant_wise_price').empty();
                $('#variant_wise_price').append(productPrice + ' TK');
            } else {
                $('#variant_wise_price').empty();
                $('#variant_wise_price').append(attributPrice);

            }
        }


        //======================addToWishList==========================
        function addToWishList(id) {

            let quantity = $(".product_qty").val();
            var postData = {
                id,
                quantity,
            };
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: '/wish-list',
                type: 'POST',
                dataType: 'json',
                data: postData,
                success: function(res) {
                    if (res.status) {
                        // Update the wishlist icon
                        toastr.success(res.message);
                        getWishList();
                    } else {
                        toastr.info(res.message);
                    }
                }
            });
        }

        //=========================get wish-list==========================
        function getWishList() {
            $.ajax({
                url: '/get/wish-list',
                type: 'GET',
                dataType: 'json',
                success: function(res) {
                    console.log(res);
                    $('.wish_list_count').html(res.item_count)
                }
            });
        }
        getWishList();

        //============================remove Wish-List==================
        function removeWishList(rowId) {
            $.ajax({
                url: '/delete/wish-list',
                type: 'POST',
                dataType: "json",
                data: {
                    rowId: rowId
                },
                success: function(res) {
                    if (res.status == true) {
                        toastr.success(res.message);
                        location.href = "/wish-list";
                    }
                    console.log(res);
                }
            });
        }



        //=========================add to cart=========================

        function addToCard(event, id, have_variant) {
            let quantity = $(".product_qty").val();
            let variants = {};
            let firstMissingVariant = null;

            $('input[name^="variant"]').each(function() {
                let variantName = $(this).attr('name').replace('variant', ''); // Remove "variant" prefix
                variantName = variantName.trim();

                if (!$(`input[name="variant${variantName}"]:checked`).val()) {
                    // If no option is selected for this variant, setting it as the first missing variant
                    if (!firstMissingVariant) {
                        firstMissingVariant = variantName;
                    }
                } else {
                    // If selected, add it to the variants 
                    variants[variantName] = $(`input[name="variant${variantName}"]:checked`).val();
                }
            });

            // Show missing variant (if any)
            if (firstMissingVariant) {
                toastr.error(`Please select ${firstMissingVariant}`);
                event.preventDefault();
                return;
            }
            page_url = window.location.href;
            var postData = {
                id,
                quantity,
                page_url,
                variants
            };

            $.ajax({
                type: "POST",
                dataType: 'json',
                data: postData,
                url: "/add/cart",
                success: function(res) {
                    console.log(res);
                    miniCart();
                    gtmEvent(id, 'add_to_cart', quantity, res.event_id);
                    toastr.success('Added to Cart Successfully');
                    $('#fixed_product_sticky_id').offcanvas('show');
                    setTimeout(() => {
                        $('#fixed_product_sticky_id').offcanvas('hide');
                    }, 3000);
                }
            });

            return true;
        }

        function addToCartFromModal(event, id, variant, variantName) {
            // console.log('attributes', variantName, 'variant', variant);

            let quantity = 1;
            let variants = {};
            if (variant) {
                variants[variantName] = variant;
            }

            page_url = window.location.href;

            var postData = {
                id,
                quantity,
                page_url,
                variants
            };

            $.ajax({
                type: "POST",
                dataType: 'json',
                data: postData,
                url: "/add/cart",
                success: function(res) {
                    miniCart();
                    gtmEvent(id, 'add_to_cart', quantity, res.event_id);

                    toastr.success('Added to Cart Successfully');

                    $('#fixed_product_sticky_id').offcanvas('show');
                    setTimeout(() => {
                        $('#fixed_product_sticky_id').offcanvas('hide');
                    }, 3000);
                }
            });

            return true;
        }


        //==========================show cart item========================
        function miniCart() {
            $.ajax({
                type: 'GET',
                url: '/cart/index',
                dataType: 'json',
                success: function(response) {
                    // getShippingCharge();
                    couponCalculation();
                    sub_total = parseInt(response.cart_sub_total);
                    var total = parseInt(sub_total + shipping_charge);
                    $('.subTotal').html(sub_total + ' TK');
                    $('.cart_item_total').html(response.cart_item_total);
                    $('#item_count').html(response.cart_item_total + ' items');
                    $('.total_amount').html(response.cart_total + ' TK');

                    var miniCart = ""
                    $.each(response.carts, function(key, value) {
                        let variants = '';
                        if (value.options.variants) {
                            $.each(value.options.variants, function(variant, name) {
                                variants += `<p>${variant}: ${name}</p>`;
                            });
                        }
                        miniCart += `
                            <li>
                                <div class="fixed_product_card_list_table_cell">
                                <!-- fixed product cart image start -->
                                <div class="fixed_product_card_image">
                                    <img src="<?php echo e(asset('storage/')); ?>/${value.options.image}" alt="${value.name}" style="aspect-ratio:<?php echo e($site_configurations->image_aspect_ratio); ?>">
                                </div>
                                <!-- fixed product cart image end -->
                        
                                <div class="fixed_product_card_details">
                                    <div class="fixed_product_card_name_size_delete">
                                        <div class="fixed_product_card_name_size">
                                            <!-- fixed product cart name start -->
                                            <div class="fixed_product_card_name">
                                                <p>${value.name}</p>
                                            </div>
                                            <!-- fixed product cart name end -->
                        
                                            <!-- fixed product cart size start -->
                                            ${variants}
                                            <!-- fixed product cart size end -->
                                        </div>
                        
                                        <!-- fixed product cart delete start -->
                                        <div class="fixed_product_card_delete_icon">
                                            <a class="card_remove" id="${value.rowId}" onclick="miniCartRemove(this.id)" >
                                                <i style="color:red;" class="fa-solid fa-trash"></i>
                                            </a>
                                        </div>
                                        <!-- fixed product cart delete end -->
                                    </div>
                                    <div class="fixed_product_card_qty_price">
                                        <!-- fixed product cart quantity start -->
                                        <div class="fixed_product_card_qty">
                                            <div class="fixed_product_card_qty_minus" id="${value.rowId}" onclick="cartDecrement(this.id)">
                                                
                                                <i class="fa-solid fa-minus"></i>
                                            </div>
                                                <input class="product_qty${value.rowId}" type="text" value="${value.qty}">
                                            <div class="fixed_product_card_qty_plus" id="${value.rowId}" onclick="cartIncrement(this.id)">
                                                <i class="fa-solid fa-plus"></i>
                                            </div>
                                        </div>
                                        <!-- fixed product cart quantity end -->
                        
                                        <!-- fixed product cart price start -->
                                        <div class="fixed_product_card_close_price">
                                            <p>${(value.qty * value.price)} TK</p>
                                        </div>
                                        <!-- fixed product cart price end -->
                                    </div>
                                </div>
                            </div>
                        </li>
                    `

                    });

                    $('#miniCart').html(miniCart);

                }
            });
        }
        miniCart();

        //======================miniCartRemove ===========================
        function miniCartRemove(rowId) {
            var show_city_sub_city = document.getElementById("show_city_sub_city") ?
                document.getElementById("show_city_sub_city").value :
                0;
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                type: 'POST',
                url: '/cart/remove',
                dataType: 'json',
                data: {
                    rowId: rowId
                },
                success: function(data) {
                    if (show_city_sub_city != 1) {
                        updateShippingCharge();
                    }
                    $('#show_cart_sub_total').text(data.cart_sub_total + ' TK');
                    var total = parseInt(data.cart_sub_total) + parseInt(shipping_charge);
                    $('#show_payable').text(total + ' TK');
                    parseInt($('#cart_sub_total').val(data.cart_sub_total));
                    checkOutCarts();
                    miniCart();
                    toastr.success('Delete Successfully');
                    // location.href = '/checkout';
                }
            });
        }

        // ============ cart increment==============
        function cartIncrement(rowId) {
            var show_city_sub_city = document.getElementById("show_city_sub_city") ?
                document.getElementById("show_city_sub_city").value :
                0;
            var qty = $(`.product_qty${rowId}`).val();
            var increment_value = parseInt(qty) + 1;

            $.ajax({
                type: 'POST',
                url: "/cart/update",
                dataType: 'json',
                data: {
                    rowId: rowId,
                    qty: increment_value,
                },
                success: function(data) {
                    if (show_city_sub_city != 1) {
                        updateShippingCharge();
                    }
                    $('#show_cart_sub_total').text(data.cart_sub_total + ' TK');
                    var total = parseInt(data.cart_sub_total) + parseInt(shipping_charge);
                    $('#show_payable').text(total + ' TK');
                    parseInt($('#cart_sub_total').val(data.cart_sub_total));
                    miniCart();
                    checkOutCarts();
                    cartViewCarts();
                    couponCalculation();
                }
            });
        }


        // ============ cart deccrement==============
        function cartDecrement(rowId) {
            var show_city_sub_city = document.getElementById("show_city_sub_city") ?
                document.getElementById("show_city_sub_city").value :
                0;
            var qty = $(`.product_qty${rowId}`).val();
            var decrement_value = parseInt(qty) == 1 ? parseInt(qty) : parseInt(qty) - 1;
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                type: 'POST',
                url: "/cart/update",
                dataType: 'json',
                data: {
                    rowId: rowId,
                    qty: decrement_value,
                },
                success: function(data) {
                    console.log(shipping_charge);

                    if (show_city_sub_city != 1) {
                        updateShippingCharge();
                    }
                    $('#show_cart_sub_total').text(data.cart_sub_total + ' TK');
                    var total = parseInt(data.cart_sub_total) + parseInt(shipping_charge);
                    $('#show_payable').text(total + ' TK');
                    parseInt($('#cart_sub_total').val(data.cart_sub_total));
                    checkOutCarts();
                    cartViewCarts();
                    couponCalculation();
                    miniCart();
                }
            });
        }

        //=========show card items==============
        $('.fixed_product_sticky').click(function() {
            miniCart();
        });

        //==============check-out cart==========
        function checkOutCarts() {
            $.ajax({
                type: 'GET',
                url: '/cart/index',
                dataType: 'json',
                success: function(response) {
                    // getShippingCharge();
                    couponCalculation();
                    //-----------set variables-----------
                    sub_total = parseInt(response.cart_sub_total);
                    payable_amount = parseInt(sub_total + shipping_charge);
                    var total = parseInt(sub_total + shipping_charge);
                    $('.subTotal').text(sub_total + ' TK');
                    $('.total_amount').text(total + ' TK');
                    $('.shipping_charge').text(shipping_charge + ' TK');
                    $('.payable_amount').text(payable_amount + ' TK' + "this");
                    // console.log(shipping_charge + "this");
                    // console.log('from checkout',shipping_charge);

                    var rows = ""
                    $.each(response.carts, function(key, value) {
                        let variants = '';
                        if (value.options.variants) {
                            $.each(value.options.variants, function(variant, name) {
                                // console.log('size="' + variant + ' Name :' + name);
                                variants += `<p>${variant}: ${name}</p>`;
                            });
                        }
                        rows += `
                                    <tr>
                                        <td class="checkout_product_td_left">
                                            <div class="checkout_product_name_image">
                                                <img src="<?php echo e(asset('storage/' . '${value . options . image}')); ?>" alt="${value.options.image}" style="aspect-ratio:<?php echo e($site_configurations->image_aspect_ratio); ?>"> 
                                            </div>
                                                <div class="products_checkout_name">
                                                    <p>${value.name.slice(0, 30) + '...'}</p>
                                                        ${variants}    
                                                </div>
                                        </td>
                                        <td>
                                            <div class="checkout_product_qty">
                                                <div id="${value.rowId}" onclick="cartDecrement(this.id)" class="checkout_product_qty_minus">
                                                    <i class="fa-solid fa-minus"></i>
                                                </div>
                                                <input type="text" class="product_qty" value="${value.qty}">
                                                <div id="${value.rowId}" onclick="cartIncrement(this.id)" class="checkout_product_qty_plus">
                                                    <i class="fa-solid fa-plus"></i>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="checkout_product_price">
                                                <p>${value.price} TK</p>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="checkout_product_total_price">
                                                <p>${(value.qty * value.price)} TK</p>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="checkout_product_delete_icon">
                                                <a id="${value.rowId}" onclick="miniCartRemove(this.id)" class="checkout_product_delete_icon_link">
                                                    <i class="fa-solid fa-trash"></i>
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                `
                    });

                    $('#check_out_carts').html(rows);

                }
            });
        }
        checkOutCarts();

        //==============check-out cart============
        function cartViewCarts() {
            $.ajax({
                type: 'GET',
                url: '/cart/index',
                dataType: 'json',
                success: function(response) {
                    sub_total = parseInt(response.cart_sub_total);
                    var total = parseInt(sub_total + shipping_charge);
                    //--------set variable---------------
                    $('.subTotal').html(sub_total + ' TK');
                    $('.total_amount').html(total + ' TK');
                    // $('.shipping_charge').text('৳ ' + shipping_charge);
                    // getShippingCharge();
                    var rows = ""
                    $.each(response.carts, function(key, value) {

                        rows += `
                            <tr>
                                <td class="padding_left_zero">
                                    <div class="view_cart_image">
                                        <a href="single_product.html">
                                            <img src="<?php echo e(asset('storage/' . '${value . options . image}')); ?>" alt="${value.name}">
                                        </a>
                                    </div>
                                </td>
                                <td>
                                    <div class="view_cart_name">
                                        <a href="#" class="view_cart_name_link">${value.name}</a>
                                    </div>
                                </td>
                                <td>
                                    <div class="view_cart_price">
                                        <span>${(value.qty * value.price)} TK</span>
                                    </div>
                                </td>
                                <td>
                                    <div class="view_cart_qty">
                                        <button id="${value.rowId}" onclick="cartDecrement(this.id)" class="view_cart_qty_minus">
                                            <i class="fa-solid fa-minus"></i>
                                        </button>
                                        <input class="product_qty" type="text" value="${value.qty}">
                                        <button id="${value.rowId}" onclick="cartIncrement(this.id)" class="view_cart_qty_plus">
                                            <i class="fa-solid fa-plus"></i>
                                        </button>
                                    </div>
                                </td>
                                <td class="padding_right_zero" style="text-align: right;">
                                    <div class="view_cart_delete">
                                        <button id="${value.rowId}" onclick="miniCartRemove(this.id)" class="view_cart_delete_link">
                                            <i class="fa-solid fa-trash">
                                            </i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                            `
                    });

                    $('#cart_view_carts').html(rows);
                }
            });
        }
        cartViewCarts();

        //==================shippingCharge==============
        function shippingChargeBySelectArea(id, val, free_delivery) {
            if (val > 0 && free_delivery != 1) {
                shipping_charge = val;
            } else {
                shipping_charge = 0;
                $('input[name="shipping_charge"]').val(shipping_charge);
            }
            orderSummaryCalculation(shipping_charge);
        }


        function shippingCharge(city_id, city_charge, free_delivery) {
            current_city_charge = (city_charge > 0 && free_delivery != 1) ? parseInt(city_charge) : 0;

            $('#setInputShippingCharge').val(current_city_charge);
            orderSummaryCalculation(current_city_charge);

            // Load subcities
            $.ajax({
                type: 'GET',
                dataType: 'json',
                data: {
                    city_id
                },
                url: 'get/subcity',
                success: function(res) {
                    if (res.status) {
                        let subcityDropdown = $('select[name="subcity_id"]');
                        subcityDropdown.empty();
                        if (res.subcitys.length === 0) {
                            subcityDropdown.append('<option value="">Sub City Not Found!</option>');
                        } else {
                            subcityDropdown.append('<option value="">Select Upozila</option>');
                            $.each(res.subcitys, function(_, value) {
                                subcityDropdown.append('<option value="' + value.id +
                                    '" data-charge="' + value.delivery_charge + '">' + value.name +
                                    '</option>');
                            });
                        }
                    }
                },
            });
        }

        function updateShippingChargeBySubcity(subcity_id) {
            if (!subcity_id) {
                $('#setInputShippingCharge').val(current_city_charge);
                orderSummaryCalculation(current_city_charge);
                return;
            }

            // Optional: use data-charge from the selected option if already loaded
            let selectedOption = $('#subcity').find('option:selected');
            let subcityCharge = parseInt(selectedOption.data('charge'));

            if (subcityCharge > 0) {
                shipping_charge = subcityCharge;
            } else {
                shipping_charge = current_city_charge;
            }

            $('#setInputShippingCharge').val(shipping_charge);
            orderSummaryCalculation(shipping_charge);
        }


        $(document).ready(function() {
            updateShippingCharge();
            orderSummaryCalculation(shipping_charge);
        });

        function updateShippingCharge() {
            let delivery_charge = $('input[name="shipping_charge"]:checked').val();
            var free_delivery = $('#free_delivery').val();

            if (free_delivery == 1) {
                shipping_charge = 0;
                $('input[name="shipping_charge"]').val(shipping_charge);
            } else {
                shipping_charge = parseInt(delivery_charge) || 0;
            }
            console.log('Updated shipping charge:', shipping_charge);
        }

        //===================== Order Calculation =======================
        function orderSummaryCalculation(charge = 0) {
            var cart_subtotal = parseInt($('#cart_sub_total').val()) || 0;
            var delivery_charge = parseInt(charge) || 0;
            console.log(cart_subtotal);

            var total_amount = cart_subtotal + delivery_charge;
            var discount_amount = 0;
            var payable_amount = total_amount;

            if (coupon != null) {
                if (coupon.discount_type == 'percentage') {
                    var calculate_amount = Math.ceil(
                        (parseInt(cart_subtotal) * parseInt(coupon.discount_amount)) / 100
                    );
                    console.log('Discount amount:', calculate_amount);
                    discount_amount = coupon.discount_amount + " %";
                    $('#coupon_amount').val(calculate_amount);
                    payable_amount = total_amount - calculate_amount;
                } else {
                    discount_amount = coupon.discount_amount;
                    $('#coupon_amount').val(discount_amount);
                    payable_amount = total_amount - coupon.discount_amount;
                }
            }

            $('#setInputShippingCharge').val(delivery_charge);
            $('#show_shipping_charge').text(delivery_charge + ' TK');
            $('#show_discount').text(discount_amount + ' TK');
            $('#show_payable').text(payable_amount + ' TK');
        }

        //===================== Apply Coupon =======================
        function applyCoupon() {

            var coupon_name = $('#coupon_name').val();
            var show_city_sub_city = document.getElementById("show_city_sub_city").value;
            $.ajax({
                type: 'POST',
                dataType: 'json',
                data: {
                    name: coupon_name,
                },
                url: '/coupon-apply',
                success: function(res) {
                    if (res.status == true) {
                        coupon = res.coupon;
                        if (show_city_sub_city != 1) {
                            updateShippingCharge();
                        }
                        orderSummaryCalculation(shipping_charge);
                        $('#coupon_valid').prop('style').removeProperty('display');
                        document.getElementById('coupon_invalid').style = "display:none";
                        toastr.success(res.message);
                    } else {
                        coupon = null;
                        $('#coupon_invalid').prop('style').removeProperty('display');
                        toastr.error(res.message);
                    }
                },
            });
        }

        function getShippingCharge() {
            $.ajax({
                url: '/get/shipping/charge',
                type: 'GET',
                dataType: 'json',
                success: function(res) {
                    shipping_charge = res.shipping_charge;
                    delivery_charge_id = res.delivery_charge_id;
                }
            });
        }

        // getShippingCharge();


        //==================couponCalculation=======================
        function couponCalculation() {
            $.ajax({
                url: '/coupon/calculation',
                type: 'GET',
                dataType: 'json',
                success: function(res) {
                    $order_summary = "";
                    if (res.success) {
                        // console.log('test ' + res.sipping_charge);
                        var delivery_charge = res.sipping_charge;


                        $order_summary +=
                            `
                            <div class="price_summary_table_cell">
                                <strong>Sub Total :</strong>
                                <strong >${res.sub_total} TK</strong>
                            </div>
                            <div class="price_summary_table_cell">
                                <strong>Delivery Charge :</strong>
                                <strong >${res.sipping_charge} TK</strong>
                            </div>
                            <div class="price_summary_table_cell">
                                <strong>Discount Amount :</strong>
                                <strong >${-res.discount_amount} TK</strong>
                            </div>
                            <div class="price_summary_table_cell">
                                <strong >Payable Amount :</strong>
                                <strong >${res.payable_amount} TK</strong>
                            </div>
                            `
                    } else {
                        $order_summary +=
                            `
                            <div class="price_summary_table_cell">
                                <strong>Sub Total :</strong>
                                <strong > 0.0 TK</strong>
                            </div>
                            <div class="price_summary_table_cell">
                                <strong>Delivery Charge :</strong>
                                <strong > 0.0 TK</strong>
                            </div>
                            <div class="price_summary_table_cell">
                                <strong>Discount Amount :</strong>
                                <strong > 0.0 TK</strong>
                            </div>
                            <div class="price_summary_table_cell">
                                <strong >Payable Amount :</strong>
                                <strong > 0.0 TK</strong>
                            </div>
                            `
                    }
                    $('#order_summary').html($order_summary);
                }
            });
        }
        couponCalculation();




        //====================product-search===============================
        function searchProduct(value) {
            if (value.length > 3) {
                $.ajax({
                    url: '/product-search',
                    type: 'POST',
                    dataType: 'json',
                    data: {
                        key: value
                    },
                    success: function(res) {
                        console.log(res);
                        if (res.status == true) {
                            $('#search_product_show').html(res.data);
                            $('#product_search').css({
                                'display': 'block'
                            });
                        } else {
                            $('#product_search').css({
                                'display': 'none'
                            });
                        }
                    }
                });
            } else {
                $('#product_search').css({
                    'display': 'none'
                });
            }
        }

        //===========================event call=======================
        var trackingWith = '<?php echo e($site_configurations->browser_side_with); ?>'
        var pixel_code = '<?php echo e(!empty($setting->facebook_pixel)); ?>'
        //--------------this event for single item--------------------
        function gtmEvent(id, event, qty, event_id = null) {
            $.ajax({
                url: '/get/product/content',
                type: 'POST',
                dataType: 'json',
                data: {
                    product_id: id,
                    quantity: qty,
                    event: event,
                    page_url: window.location.href
                },
                success: function(res) {
                    if (res.status) {

                        //------set variable------------
                        if (trackingWith == 1 && pixel_code) {
                            trackingWithPixel(res, event, event_id);
                        } else if (trackingWith == 2) {
                            trackingWithGTM(res, event, event_id);
                        }


                    } else {
                        console.log(res.message);
                    }
                }
            });
        }

        //----------------this event for multi items--------------
        function gtmCartItemsEvent(event, invoice_id = null) {
            $.ajax({
                url: '/get/cart-items',
                type: "GET",
                dataType: 'json',
                data: {
                    event: event,
                    page_url: window.location.href

                },
                success: function(res) {
                    // console.log(res);
                    if (res.status) {

                        //------set variable------------
                        if (trackingWith == 1 && pixel_code) {
                            trackingWithPixel(res, event, res.event_id, invoice_id);
                        } else if (trackingWith == 2) {
                            trackingWithGTM(res, event, res.event_id, invoice_id);
                        }
                        if (event == "purchase" && invoice_id) {
                            deleteCart(invoice_id);
                        }
                    } else {
                        console.log(res.message);
                    }


                }
            });
        }

        function trackingWithPixel(res, event, event_id, invoice_id = null) {
            // initFbPixel(res);

            if (event == 'add_to_cart') {
                fbq('track', 'AddToCart', {
                    content_ids: [res.product.product_code],
                    content_type: 'product',
                    value: res.product.sale_price,
                    currency: 'BDT'
                }, {
                    eventID: event_id
                });

            } else if (event == 'view_item') {
                fbq('track', 'ViewContent', {
                    content_ids: [res.product.product_code],
                    content_name: res.product.name,
                    content_type: 'product',
                    value: res.product.sale_price,
                    currency: 'BDT'
                }, {
                    eventID: res.event_id
                });

            } else if (event == 'begin_checkout') {
                fbq('track', 'InitiateCheckout', {
                    value: res.cart_total,
                    currency: 'BDT',
                    content_ids: res.cart_items,
                    contents: res.contents,
                    content_type: 'product'
                }, {
                    eventID: res.event_id
                });
            } else {
                fbq('track', 'Purchase', {
                    value: res.cart_total,
                    currency: 'BDT',
                    content_ids: res.cart_items,
                    contents: res.contents,
                    content_type: 'product',
                    external_id: res.external_id
                }, {
                    eventID: res.event_id
                });
                setTimeout(function() {
                    deleteCart(invoice_id);
                }, 500);
            }
        };


        function trackingWithGTM(res, event, event_id = null, invoice_id = null) {
            // Common ecommerce data
            const baseData = {
                currency: "BDT",
                value: res.cart_total,
                items: res.items,
            };

            // Extend event-specific data
            const ecommerceData = {
                add_to_cart: {
                    ...baseData
                },
                view_item: {
                    ...baseData
                },
                view_cart: {
                    ...baseData
                },
                begin_checkout: {
                    ...baseData,
                    coupon: res.coupon,
                },
                purchase: {
                    ...baseData,
                    coupon: res.coupon,
                    transaction_id: invoice_id,
                    customer: res.customer,
                },
            };

            // Reset ecommerce object
            dataLayer.push({
                ecommerce: null
            });

            // Event payload
            const payload = {
                event,
                event_id: event_id ?? res.event_id ?? "",
                ecommerce: ecommerceData[event],
            };
            console.log(payload);

            // Push to dataLayer
            if (payload.ecommerce) {
                dataLayer.push(payload);
                // console.log(`call ${event}`);
            } else {
                console.warn(`Unknown GTM event: ${event}`);
            }

            // Extra action for purchase

        }

        //==================clear Cart items=====================

        function deleteCart(invoice_id) {
            $.ajax({
                type: 'GET',
                url: '/clear/all-cart',
                dataType: 'json',
                data: {
                    invoice_id: invoice_id
                },
                success: function(res) {
                    console.log(res);
                }
            });
        }

        let isFormSubmitted = false;
        let eventListenersAdded = false;
        let phone_number = "";
        //------------order form submit------------
        function orderForm() {
            $('#order_form').submit(function(event) {
                event.preventDefault();

                if (isFormSubmitted) return; // prevent double submit
                isFormSubmitted = true;

                var formData = new FormData(this);
                formData.append('status', 1);
                name = formData.get('name');
                mobile_no = formData.get('mobile_no');
                shipping_charge_id = formData.get('shipping_charge');
                address = formData.get('address');
                note = formData.get('note');
                select_city = formData.get('city_id');
                subcity = formData.get('subcity_id');
                // shipping_charge_id = formData.get('shipping_charge_id');
                var show_city_sub_city = document.getElementById("show_city_sub_city").value;

                //-----validation start----------------
                if (!name) {
                    toastr.info('Name is required');
                    isFormSubmitted = false;
                    return;
                }

                if (!mobile_no) {
                    toastr.info('Mobile is required');
                    isFormSubmitted = false;
                    return;
                }

                if (!$.isNumeric(mobile_no)) {
                    toastr.info('Please Type Number');
                    isFormSubmitted = false;
                    return;
                }

                if (mobile_no.length != 11) {
                    toastr.info('Your Mobile Number Must-be 11 Digit');
                    isFormSubmitted = false;
                    return;
                }
                const mobilePattern = /^(01[3456789])(\d{8})$/;
                if (!mobilePattern.test(mobile_no)) {
                    toastr.info('Invalid Mobile Number Format');
                    isFormSubmitted = false;
                    return;
                }
                if (show_city_sub_city == 1) {
                    if (!select_city) {
                        toastr.info('Please Select your City');
                        isFormSubmitted = false;
                        return;
                    }
                    if (!subcity) {
                        toastr.info('Please Select your Sub-City');
                        isFormSubmitted = false;
                        return;
                    }
                } else {
                    if (!shipping_charge_id) {
                        toastr.info('Please Select Area');
                        isFormSubmitted = false;
                        return;
                    }
                }

                if (!address) {
                    toastr.info('Address is required');
                    isFormSubmitted = false;
                    return;
                }

                const $btn = $('#order_form_submit');
                const originalBtnHTML = $btn.html();
                $btn.prop('disabled', true);
                $btn.html(
                    '<i class="common_btn_icon spinner"></i> <span class="common_btn_title">Loading...</span>');


                //setup ajax
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });

                $.ajax({
                    url: '/checkout/order',
                    type: 'POST',
                    dataType: 'json',
                    data: formData,
                    processData: false,
                    contentType: false,
                    success: function(res) {
                        $('.order_form').trigger("reset");
                        if (res.status) {
                            toastr.success('Order Successfull Add');
                            if (res.payment == 0) {
                                location.href = "/order-success/" + res.invoice_no;
                            } else {
                                location.href = "/bkash-create";
                            }
                        } else {
                            toastr.warning(res.message);
                            isFormSubmitted = false;
                            $btn.prop('disabled', false).html(originalBtnHTML);
                        }
                    },
                    error: function(xhr, status, error) {
                        // Handle error
                        console.error(xhr.responseText);
                        isFormSubmitted = false;
                        $btn.prop('disabled', false).html(originalBtnHTML);

                    }
                });
            });
        }

        let saveOrderTimeout = null;

        function setNumber(val, incomplete_order_system) {
            phone_number = val;
            console.log('no: ', phone_number);
            if (incomplete_order_system == 1) {
                if (window.location.pathname.includes('/checkout') && phone_number) {
                    storeIncompleteOrder();
                }
            }
        }

        function storeIncompleteOrder() {
            console.log('Event Listeners Added:', eventListenersAdded);

            if (!eventListenersAdded) {
                eventListenersAdded = true; // Ensure this runs only once

                window.addEventListener('beforeunload', handleBeforeUnload);
                document.addEventListener("visibilitychange", handleVisibilityChange);
                // window.addEventListener("popstate", handlePopState);
            }


        }

        function handleBeforeUnload() {
            console.log('beforeunload - numberB:', phone_number);
            if (!isFormSubmitted) {
                saveIncompleteOrder();
            }
        }

        function handleVisibilityChange() {
            console.log('visibilitychange - numberV:', phone_number);
            if (document.hidden && !isFormSubmitted) {
                saveOrderTimeout = setTimeout(saveIncompleteOrder, 20000); // 20 sec delay
            } else {
                clearTimeout(saveOrderTimeout);
                console.log('cleared');
            }
        }

        function handlePopState() {
            console.log('popstate - numberS:', phone_number);
            if (!isFormSubmitted) {
                saveIncompleteOrder();
            }
        }

        function saveIncompleteOrder() {
            if (!phone_number) return; // Prevent saving if no number is entered

            var formData = new FormData($('#order_form')[0]);
            formData.append('status', 12);

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url: '/checkout/order',
                type: 'POST',
                dataType: 'json',
                data: formData,
                processData: false,
                contentType: false,
                success: function(response) {
                    isFormSubmitted = true;
                    console.log("Incomplete order saved.");
                    removeEventListeners();
                },
                error: function(xhr) {
                    console.error(xhr.responseText);
                }
            });
        }

        function removeEventListeners() {
            window.removeEventListener('beforeunload', handleBeforeUnload);
            document.removeEventListener("visibilitychange", handleVisibilityChange);
            window.removeEventListener("popstate", handlePopState);
        }

        toastr.options = {
            "positionClass": "toaster-center",
            timeOut: 3000,
            tapToDismiss: true,
            debug: false,
            fadeOut: 5,
            closeButton: true,
            progressBar: true,
            showMethod: "slideDown",
            hideMethod: "slideUp",
            closeHtml: '<button type="button" class="close" data-dismiss="toast" aria-label="Close">&times;</button>',
            newestOnTop: false,
        };
        //-------------------order Tracking---------------------
        function OrderTracking() {
            $('#order_tracking_form').submit(function(event) {
                event.preventDefault();
                var formData = $(this).serialize();

                //setup ajax
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });

                //call ajax
                $.ajax({
                    url: "<?php echo e(route('order.tracking')); ?>",
                    type: 'POST',
                    dataType: 'json',
                    data: formData,
                    success: function(res) {
                        if (res.status == true) {
                            $('#order_tracking_content').html(res.data);
                            $('#courier_name').html(res.courier_name);
                        } else {
                            data = `<div style="text-align: center;">
                                        <span>No Invoice</span>
                                    </div>`;
                            $('#order_tracking_content').html(data);
                        }
                    },
                    error: function(xhr, status, error) {
                        // Handle error
                        console.error(xhr.responseText);
                    }
                });
                console.log(formData);
            });
        }

        //-------------------Custom Product Review---------------
        function ReviewForm() {
            $('#review_form').submit(function(event) {
                event.preventDefault();
                var formData = new FormData(this);
                var button = document.querySelector('.customer_comment_btn_link');
                var productSlug = button.dataset.product_slug;
                formData.append('product_slug', productSlug);
                rating = formData.get('rating_stars');
                name = formData.get('user_name');
                review = formData.get('review');
                if (rating == null) {
                    toastr.error('Please Select Rating');
                    return;
                }
                if (name == '') {
                    toastr.error('Please write Your Name');
                    return;
                }
                if (review == '') {
                    toastr.error('Please write Review');
                    return;
                }
                //setup ajax
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });

                $.ajax({
                    url: "<?php echo e(route('product.review')); ?>",
                    type: "POST",
                    dataType: 'json',
                    data: formData,
                    processData: false,
                    contentType: false,
                    success: function(res) {
                        if (res.status == true) {
                            $('#review_form').trigger("reset");
                            toastr.success(res.message);
                            setTimeout(function() {
                                location.href = "/product/" + productSlug;
                            }, 1000);
                            //success messase
                        }
                        console.log(res);
                    }
                });
            });
        }

        //--------------------Send OTP ------------------
        function SendOTP() {
            $('#send_otp_form').submit(function(event) {
                event.preventDefault();
                var formData = $(this).serialize();

                console.log('befor ajax call');
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    url: "<?php echo e(route('send.otp')); ?>",
                    type: 'POST',
                    dataType: "json",
                    data: formData,
                    success: function(res) {
                        if (res.status == true) {
                            // intervalId = setInterval(DecrementCounter, 1000);
                            toastr.success('Successfully OTP Send');
                            location.href = '/receive/otp';
                        }
                        console.log(res);
                    }
                });
            });
        }




        function OTPVarify() {
            let otp_mobile_no = $('#otp_mobile_no').val();
            $('#otp_varify_form').submit(function(e) {
                e.preventDefault();
                var formData = new FormData(this);
                formData.append('mobile_no', otp_mobile_no);
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    url: "<?php echo e(route('verify.otp')); ?>",
                    type: 'POST',
                    dataType: 'json',
                    data: formData,
                    processData: false,
                    contentType: false,
                    success: function(res) {
                        if (res.status == true) {
                            console.log('ddd');
                            toastr.success('Successfully OTP verified');
                            location.href = '/user/dashboard';
                        } else {
                            toastr.error('OTP is incorrect');
                        }
                    }
                });
            });
        }



        function copyReferrerLink(referrerLink) {
            let text = (referrerLink).replace(/<[^>]*>/g, '');
            navigator.clipboard.writeText(`${text}`);
            toastr.success('Copied');
        }


        $('#send_otp_form_submit').one('click', function() {
            SendOTP();
        });

        $('#otp_varify_form_submit').one('click', function() {
            OTPVarify();
        });

        $('#order_form_submit').one('click', function() {
            orderForm();
            $('#order_form').submit();
        });

        // $('#select_area').change(function() {
        //     shippingCharge(parseInt($(this).val()));
        // });

        //======================different event call=====================
        $('#coupon_apply').on('click', function() {

            applyCoupon();
        });

        $('#review_submit').one('click', function() {
            ReviewForm();
        });

        $('.cart_check_out').one('click', function() {
            couponCalculation();
            cartViewCarts();
        });

        //------cart view event---------
        $('.cart_view').one('click', function() {
            cartViewCarts();
        });

        function whatsapp() {
            document.getElementById("whatsapp_id").classList.toggle("whatsapp_toggle");
        }
    </script>

    <script>
        function setOnlinePayment(type) {
            $('#set_payment').val(type);
        }
    </script>
    <script>
        const paymentMethods = document.querySelectorAll('.payment_methods_img ul li');

        paymentMethods.forEach((item) => {
            item.addEventListener('click', () => {
                paymentMethods.forEach((method) => method.classList.remove('active_payment'));
                item.classList.add('active_payment');
            });
        });
    </script>

    <script>
        document.addEventListener('DOMContentLoaded', () => {
            function getCookie(name) {
                let match = document.cookie.match(new RegExp('(^| )' + name + '=([^;]+)'));
                if (match) return decodeURIComponent(match[2]);
                return null;
            }

            function setCookie(name, value, days) {
                const maxAge = days * 24 * 60 * 60;
                document.cookie = `${name}=${encodeURIComponent(value)}; path=/; max-age=${maxAge}; SameSite=Lax`;
            }

            function generateFBP() {
                const subdomain = 1;
                const timestamp = Date.now();
                const random = Math.floor(Math.random() * 9000000000) + 1000000000;
                return `fb.${subdomain}.${timestamp}.${random}`;
            }

            function generateFBC(fbclid) {
                const subdomain = 1;
                const timestamp = Date.now();
                return `fb.${subdomain}.${timestamp}.${fbclid}`;
            }

            const urlParams = new URLSearchParams(window.location.search);
            const fbclid = urlParams.get('fbclid');

            let fbp = getCookie('_fbp');

            if (!fbp || !fbp.startsWith('fb.1.')) {
                fbp = generateFBP();
                setCookie('_fbp', fbp, 90);
            }

            let fbc = getCookie('_fbc');

            if (fbclid) {
                fbc = generateFBC(fbclid);
                setCookie('_fbc', fbc, 90);
                console.log('✨ Generated new FBC:', fbc);

                storeClickId(fbc, fbp, fbclid);
            } else if (fbc && fbp) {
                storeClickId(fbc, fbp, null);
            }

            function storeClickId(fbc, fbp, fbclid) {
                const csrfToken = $('meta[name="csrf-token"]').attr('content');

                $.ajax({
                    url: "/store-fbc",
                    type: "POST",
                    data: {
                        fbc: fbc,
                        fbp: fbp,
                        fbclid: fbclid,
                        _token: csrfToken
                    },
                    success: function(res) {

                    },
                    error: function(xhr) {
                        console.error('❌ Error storing FB params:', xhr.status, xhr.responseText);
                    }
                });
            }
        });
    </script>

    <script>
        var trackingWith = '<?php echo e($site_configurations->browser_side_with); ?>'
        var pixel_code = '<?php echo e(!empty($setting->facebook_pixel)); ?>'
        if (trackingWith == 1 && pixel_code) {
            $.ajax({
                url: "/fire/page/view/event",
                type: "POST",
                data: {
                    url: window.location.href,
                    _token: $('meta[name="csrf-token"]').attr('content')
                },
                success: function(res) {

                    fbq('track', 'PageView', {}, {
                        eventID: res.event_id
                    });
                },
                error: function(xhr) {
                    console.error("Error pageView", xhr.responseText);
                }
            });
        }
    </script>

</body>

</html>
<?php /**PATH /home/stylzbd/public_html/resources/views/frontend/app.blade.php ENDPATH**/ ?>